function [time, release, varargout] = simulate_sucrose_fixedPars(time,IC_states,par,k2)

if numel(IC_states) == 1
    [t,ves_states] = ode45(@(t,states)Rstate_model_fixedPars(t,states,par,time,k2),...
        [time(1) time(end)],IC_states);
elseif numel(IC_states) == 2
    [t,ves_states] = ode45(@(t,states)DnRstate_model(t,states,par,time,k2),...
        [time(1) time(end)],IC_states);
end

ves_states = interp1q(t,ves_states,time');
release = -ves_states(:,end).*k2; %-k2*R

if nargout == 3
    varargout{1} = ves_states;
end

end