function [weights] = sucroseWeightedFit(fit_EPSC, endWeight, peakRatio)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

if nargin == 1
    endWeight = 0.1;
    peakRatio = 1;
end
%{
hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    
else
    settings = getappdata(hMain, 'settings');
   
end
%}

%set the weights to the minimum value specified by endWeight
weights = zeros(numel(fit_EPSC), 1) + endWeight;


if iscell(fit_EPSC)
    fit_EPSC = cell2mat(fit_EPSC);
end

smoothResponse = smooth(fit_EPSC, 5000);
[peakVal, peakIdx] = min(smoothResponse(1:end-5000));
lastVal = mean(smoothResponse(end-5010:end-5000));
halfIdx = find(smoothResponse(peakIdx:end) >= mean([peakVal;lastVal]), 1, 'first');
halfIdx = peakIdx + halfIdx;
%check if the minimum is not to far to the end
%this happens mostly in relatively flat traces
if halfIdx >= numel(fit_EPSC)
    %take the midpoint of the trace
    halfIdx = floor(numel(fit_EPSC)/2);
end
%set the first part to 1
weights(1:halfIdx) = peakRatio;

%fit an exponential through the last part
if numel(fit_EPSC) - 60000 < halfIdx
    fitY = fit_EPSC(halfIdx:end);
    fitX = (0:numel(fitY)-1);
    tau = -fitX(end)/log(endWeight);
    weights(halfIdx:end) = exp(-fitX/tau);
else
    fitY = fit_EPSC(halfIdx:end-60000);
    fitX = (0:numel(fitY)-1);
    tau = -fitX(end)/log(endWeight);
    weights(halfIdx:end-60000) = exp(-fitX/tau);
    weights(end-60000:end) = 0; %endWeight;
end

end

