function onset_idx = sucrose_onset_estimate(time, EPSC)

%Hardcoded: spacing of linearFit indices and location of onset_idx based on
%linear fit

%baseline = mean(EPSC(1:1e3)); %Baseline over first 100ms
%EPSC = EPSC - baseline;
EPSC_peak = min(EPSC);
idx_linearFit = find(EPSC < EPSC_peak/2, 1);
idx_linearFit = [idx_linearFit-1e3 idx_linearFit idx_linearFit+1e3];

time_linearFit = time(idx_linearFit);
EPSC_linearFit = EPSC(idx_linearFit)';

p = polyfit(time_linearFit, EPSC_linearFit, 1);

onset_idx = find(time >= roots(p) - 0.15,1);

end