function varargout = sucrose_parameters(varargin)
% SUCROSE_PARAMETERS MATLAB code for sucrose_parameters.fig
%      SUCROSE_PARAMETERS, by itself, creates a new SUCROSE_PARAMETERS or raises the existing
%      singleton*.
%
%      H = SUCROSE_PARAMETERS returns the handle to a new SUCROSE_PARAMETERS or the handle to
%      the existing singleton*.
%
%      SUCROSE_PARAMETERS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SUCROSE_PARAMETERS.M with the given input arguments.
%
%      SUCROSE_PARAMETERS('Property','Value',...) creates a new SUCROSE_PARAMETERS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before sucrose_parameters_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to sucrose_parameters_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help sucrose_parameters

% Last Modified by GUIDE v2.5 17-Mar-2014 08:45:22

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @sucrose_parameters_OpeningFcn, ...
                   'gui_OutputFcn',  @sucrose_parameters_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before sucrose_parameters is made visible.
function sucrose_parameters_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to sucrose_parameters (see VARARGIN)

% Choose default command line output for sucrose_parameters
handles.output = hObject;

hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    return;
end

settings = getappdata(hMain, 'settings');
pars     = settings.par_init;

%{
%set the values
set(handles.edit_k1, 'String', num2str(pars(1)));
set(handles.edit_kMinus1, 'String', num2str(pars(2)));
set(handles.edit_k2_250, 'String', num2str(pars(6)));
set(handles.edit_k2_500, 'String', num2str(pars(3)));
set(handles.edit_tau250, 'String', num2str(pars(8)));
set(handles.edit_tau500, 'String', num2str(pars(5)));
set(handles.edit_onset250, 'String', num2str(pars(7)));
set(handles.edit_onset500, 'String', num2str(pars(4)));
%}

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes sucrose_parameters wait for user response (see UIRESUME)
% uiwait(handles.fig_params);


% --- Outputs from this function are returned to the command line.
function varargout = sucrose_parameters_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit_k1_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(1)));
end

% --- Executes during object creation, after setting all properties.
function edit_k1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_k1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_kMinus1_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(2)));
end

% --- Executes during object creation, after setting all properties.
function edit_kMinus1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_kMinus1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_onset250_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(7)));
end

% --- Executes during object creation, after setting all properties.
function edit_onset250_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_onset250 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_onset500_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(4)));
end


% --- Executes during object creation, after setting all properties.
function edit_onset500_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_onset500 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_tau250_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(8)));
end


% --- Executes during object creation, after setting all properties.
function edit_tau250_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_tau250 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_tau500_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(5)));
end


% --- Executes during object creation, after setting all properties.
function edit_tau500_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_tau500 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_k2_250_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(6)));
end


% --- Executes during object creation, after setting all properties.
function edit_k2_250_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_k2_250 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_k2_500_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));

if isnan(val) || val <= 0
    pars = getDefaultPars();
    set(hObject,'String', num2str(pars(3)));
end


% --- Executes during object creation, after setting all properties.
function edit_k2_500_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_k2_500 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function [pars] = getDefaultPars()
%get the handle to the main interface
hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    pars = [];
    return;
end

%retrieve the parameters
pars = getappdata(hMain, 'settings');
pars = pars.par_init;


% --- Executes on button press in push_setParam.
function push_setParam_Callback(hObject, eventdata, handles)
hMain = getappdata(0, 'h_sucrose');
settings = getappdata(hMain, 'settings');
oldPar   = settings.par_init;
settings.par_init = [str2double(get(handles.edit_k1, 'String')),...
                     str2double(get(handles.edit_kMinus1, 'String')),...
                     str2double(get(handles.edit_k2_500, 'String')),...
                     str2double(get(handles.edit_onset500, 'String')),...
                     str2double(get(handles.edit_tau500, 'String')),...
                     str2double(get(handles.edit_k2_250, 'String')),...
                     str2double(get(handles.edit_onset250, 'String')),...
                     str2double(get(handles.edit_tau250, 'String'))...
                     ];

%replace nan values with old values
nanfltr = isnan(settings.par_init);
settings.par_init(nanfltr) = oldPar(nanfltr);

setappdata(hMain, 'settings', settings);
helpdlg('Initial parameters were updated.', 'Update complete');

hFig = findobj('Tag', 'fig_params');
fig_params_CloseRequestFcn(hFig, eventdata, handles);


% --- Executes when user attempts to close fig_params.
function fig_params_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to fig_params (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
delete(hObject);
