function varargout = sucrose_preferences(varargin)
% SUCROSE_PREFERENCES MATLAB code for sucrose_preferences.fig
%      SUCROSE_PREFERENCES, by itself, creates a new SUCROSE_PREFERENCES or raises the existing
%      singleton*.
%
%      H = SUCROSE_PREFERENCES returns the handle to a new SUCROSE_PREFERENCES or the handle to
%      the existing singleton*.
%
%      SUCROSE_PREFERENCES('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SUCROSE_PREFERENCES.M with the given input arguments.
%
%      SUCROSE_PREFERENCES('Property','Value',...) creates a new SUCROSE_PREFERENCES or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before sucrose_preferences_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to sucrose_preferences_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help sucrose_preferences

% Last Modified by GUIDE v2.5 03-Jun-2014 09:19:18

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @sucrose_preferences_OpeningFcn, ...
                   'gui_OutputFcn',  @sucrose_preferences_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before sucrose_preferences is made visible.
function sucrose_preferences_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to sucrose_preferences (see VARARGIN)

% Choose default command line output for sucrose_preferences
handles.output = hObject;

hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    return;
end

setappdata(0, 'h_sucrPrefs', gcf);
setappdata(gcf, 'handles', handles);

%get the main settings and fill all controls
settings = getDefValues();
setValues(settings, 'all');

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes sucrose_preferences wait for user response (see UIRESUME)
% uiwait(handles.sucr_prefs);


function setValues(settings, level)
hPref = getappdata(0, 'h_sucrPrefs');
handles = getappdata(hPref, 'handles');

%check for the fitting method
slctMethod  = strcmpi(settings.globalFitType, {'default', 'genetic', 'anneal'});
slctDisplay = strcmpi(settings.outputDisplay, {'final', 'off', 'iter', 'diagnose'});
slctVal     = find(slctMethod);
slctDisp    = find(slctDisplay);

switch(level)
    case 'model'
        %add the correct values to all the fields of the model parameters
        set(handles.edit_sucrose_decay, 'String', num2str(settings.sucrose_decay));
        set(handles.edit_k20, 'String', num2str(settings.k20));
        if settings.useExperimental
            set(handles.edit_k20, 'Enable', 'on');
            set(handles.edit_gain, 'Enable', 'on');
        else
            set(handles.edit_k20, 'Enable', 'off');
            set(handles.edit_gain, 'Enable', 'off');
        end
        set(handles.edit_baseline_length, 'String', num2str(settings.baselineLength));
        set(handles.edit_gain, 'String', num2str(settings.gain));
        set(handles.check_useFixedParam, 'Value', settings.useFixedParam);
        set(handles.check_expFeatures, 'Value', settings.useExperimental);
    case 'fitting'
        %fitting parameters
        set(handles.edit_max_fun_evals, 'String', num2str(settings.MaxFunEvals));
        set(handles.edit_max_iter, 'String', num2str(settings.MaxIter));
        set(handles.popup_fitMethod, 'Value', slctVal);
        set(handles.popup_fitDisplay, 'Value', slctDisp);
        if slctVal ~= 3
            set(handles.check_use_random, 'Value', 0);
            set(handles.check_use_random, 'Enable', 'off');
        else
            set(handles.check_use_random, 'Value', settings.useRandomInit);
            set(handles.check_use_random, 'Enable', 'on');
        end
        set(handles.check_weightFit, 'Value', settings.useWeightedFit);
        set(handles.check_adaptiveBase, 'Value', settings.useAdaptiveBase);
    case 'all'
        set(handles.edit_sucrose_decay, 'String', num2str(settings.sucrose_decay));
        set(handles.edit_k20, 'String', num2str(settings.k20));
        if settings.useExperimental
            set(handles.edit_k20, 'Enable', 'on');
            set(handles.edit_gain, 'Enable', 'on');
        else
            set(handles.edit_k20, 'Enable', 'off');
            set(handles.edit_gain, 'Enable', 'off');
        end
        set(handles.edit_baseline_length, 'String', num2str(settings.baselineLength));
        set(handles.edit_gain, 'String', num2str(settings.gain));
        set(handles.edit_max_fun_evals, 'String', num2str(settings.MaxFunEvals));
        set(handles.edit_max_iter, 'String', num2str(settings.MaxIter));
        if slctVal ~= 3
            set(handles.check_use_random, 'Value', 0);
            set(handles.check_use_random, 'Enable', 'off');
        else
            set(handles.check_use_random, 'Value', settings.useRandomInit);
            set(handles.check_use_random, 'Enable', 'on');
        end
        set(handles.popup_fitMethod, 'Value', slctVal);
        set(handles.popup_fitDisplay, 'Value', slctDisp);
        set(handles.check_weightFit, 'Value', settings.useWeightedFit);
        set(handles.check_useFixedParam, 'Value', settings.useFixedParam);
        set(handles.check_expFeatures, 'Value', settings.useExperimental);
        set(handles.check_adaptiveBase, 'Value', settings.useAdaptiveBase);
end




function [settings] = getValues()
hPref = getappdata(0, 'h_sucrPrefs');
handles = getappdata(hPref, 'handles');
settings = getDefValues();

%modify the settings handled by this interface, leave the others intact
settings.sucrose_decay   = str2double(get(handles.edit_sucrose_decay, 'String'));
settings.k20             = str2double(get(handles.edit_k20, 'String'));
settings.baselineLength  = str2double(get(handles.edit_baseline_length, 'String'));
settings.gain            = str2double(get(handles.edit_gain, 'String'));
settings.MaxFunEvals     = str2double(get(handles.edit_max_fun_evals, 'String'));
settings.MaxIter         = str2double(get(handles.edit_max_iter, 'String'));
settings.useRandomInit   = get(handles.check_use_random, 'Value');
settings.reusePrevious   = ~settings.useRandomInit;
fitTypes                 = {'default', 'genetic', 'anneal'};
settings.globalFitType   = fitTypes{get(handles.popup_fitMethod, 'Value')};
dispTypes                = {'final', 'off', 'iter', 'diagnose'};
settings.outputDisplay   = dispTypes{get(handles.popup_fitDisplay, 'Value')};
settings.useWeightedFit  = get(handles.check_weightFit, 'Value');
settings.useFixedParam   = get(handles.check_useFixedParam, 'Value');
settings.useExperimental = get(handles.check_expFeatures, 'Value');
settings.useAdaptiveBase = get(handles.check_adaptiveBase, 'Value');


function [settings] = getDefValues()
hMain = getappdata(0, 'h_sucrose');
settings = getappdata(hMain, 'settings');



function [newVal] = verifyInputVal(oldVal, minVal, maxVal)
%check the value against the min/max
if oldVal >= minVal && oldVal <= maxVal
    %this is okay
    newVal = oldVal;
else
    %default: return the minimal value
    newVal = minVal;
end


% --- Outputs from this function are returned to the command line.
function varargout = sucrose_preferences_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function edit_max_fun_evals_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));
if isnan(val)
    %get the default values
    settings = getDefValues();
    newVal = settings.MaxFunEvals;
else
    newVal = verifyInputVal(val, 1, 1e5);
end

set(hObject, 'String', num2str(newVal));


% --- Executes during object creation, after setting all properties.
function edit_max_fun_evals_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_max_fun_evals (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_max_iter_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));
if isnan(val)
    %get the default values
    settings = getDefValues();
    newVal = settings.MaxIter;
else
    newVal = verifyInputVal(val, 1, 1e5);
end

set(hObject, 'String', num2str(newVal));


% --- Executes during object creation, after setting all properties.
function edit_max_iter_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_max_iter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in check_use_random.
function check_use_random_Callback(hObject, eventdata, handles)
% hObject    handle to check_use_random (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_use_random


% --- Executes on button press in check_reuse_previous.
function check_reuse_previous_Callback(hObject, eventdata, handles)
% hObject    handle to check_reuse_previous (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_reuse_previous


% --- Executes on button press in push_default_fit.
function push_default_fit_Callback(hObject, eventdata, handles)
settings = getDefValues();
setValues(settings, 'fitting');




function edit_sucrose_decay_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));
if isnan(val)
    %get the default values
    settings = getDefValues();
    newVal = settings.sucrose_decay;
else
    newVal = verifyInputVal(val, 1e-3, 1e3);
end

set(hObject, 'String', num2str(newVal));


% --- Executes during object creation, after setting all properties.
function edit_sucrose_decay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_sucrose_decay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_k20_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));
if isnan(val)
    %get the default values
    settings = getDefValues();
    newVal = settings.k20;
else
    newVal = verifyInputVal(val, 0, 1e3);
end

set(hObject, 'String', num2str(newVal));


% --- Executes during object creation, after setting all properties.
function edit_k20_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_k20 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_baseline_length_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));
if isnan(val)
    %get the default values
    settings = getDefValues();
    newVal = settings.baselineLength;
else
    newVal = verifyInputVal(val, 1e-3, 1e2);
end

set(hObject, 'String', num2str(newVal));


% --- Executes during object creation, after setting all properties.
function edit_baseline_length_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_baseline_length (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_gain_Callback(hObject, eventdata, handles)
val = str2double(get(hObject,'String'));
if isnan(val)
    %get the default values
    settings = getDefValues();
    newVal = settings.gain;
else
    newVal = verifyInputVal(val, 0.5, 500);
end

set(hObject, 'String', num2str(newVal));

% --- Executes during object creation, after setting all properties.
function edit_gain_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_gain (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in push_default_model.
function push_default_model_Callback(hObject, eventdata, handles)
settings = getDefValues();
setValues(settings, 'model');


% --- Executes when user attempts to close sucr_prefs.
function sucr_prefs_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to sucr_prefs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%collect all values
settings = getValues();

%move them to the main interface
hMain = getappdata(0, 'h_sucrose');
setappdata(hMain, 'settings', settings);

%remove the appdata of this interface
rmappdata(0, 'h_sucrPrefs');

% Hint: delete(hObject) closes the figure
delete(hObject);


% --- Executes on selection change in popup_fitMethod.
function popup_fitMethod_Callback(hObject, eventdata, handles)
% hObject    handle to popup_fitMethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if get(handles.popup_fitMethod, 'Value') ~= 3
    set(handles.check_use_random, 'Value', 0);
    set(handles.check_use_random, 'Enable', 'off');
else
    set(handles.check_use_random, 'Enable', 'on');
end

% --- Executes during object creation, after setting all properties.
function popup_fitMethod_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popup_fitMethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popup_fitDisplay.
function popup_fitDisplay_Callback(hObject, eventdata, handles)
% hObject    handle to popup_fitDisplay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popup_fitDisplay contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popup_fitDisplay


% --- Executes during object creation, after setting all properties.
function popup_fitDisplay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popup_fitDisplay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in check_useExtended.
function check_useExtended_Callback(hObject, eventdata, handles)
% hObject    handle to check_useExtended (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_useExtended


% --- Executes on button press in check_weightFit.
function check_weightFit_Callback(hObject, eventdata, handles)
% hObject    handle to check_weightFit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_weightFit


% --- Executes on button press in check_useFixedParam.
function check_useFixedParam_Callback(hObject, eventdata, handles)
% hObject    handle to check_useFixedParam (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_useFixedParam


% --- Executes on button press in check_expFeatures.
function check_expFeatures_Callback(hObject, eventdata, handles)
% hObject    handle to check_expFeatures (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_expFeatures
if get(hObject,'Value')
    set(handles.edit_k20, 'Enable', 'on');
    set(handles.edit_gain, 'Enable', 'on');
else
    set(handles.edit_k20, 'Enable', 'off');
    set(handles.edit_gain, 'Enable', 'off');
end


% --- Executes on button press in check_adaptiveBase.
function check_adaptiveBase_Callback(hObject, eventdata, handles)
% hObject    handle to check_adaptiveBase (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_adaptiveBase
