function varargout = sucrose_review(varargin)
% SUCROSE_REVIEW MATLAB code for sucrose_review.fig
%      SUCROSE_REVIEW, by itself, creates a new SUCROSE_REVIEW or raises the existing
%      singleton*.
%
%      H = SUCROSE_REVIEW returns the handle to a new SUCROSE_REVIEW or the handle to
%      the existing singleton*.
%
%      SUCROSE_REVIEW('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SUCROSE_REVIEW.M with the given input arguments.
%
%      SUCROSE_REVIEW('Property','Value',...) creates a new SUCROSE_REVIEW or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before sucrose_review_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to sucrose_review_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help sucrose_review

% Last Modified by GUIDE v2.5 01-May-2014 15:36:27

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @sucrose_review_OpeningFcn, ...
                   'gui_OutputFcn',  @sucrose_review_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before sucrose_review is made visible.
function sucrose_review_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to sucrose_review (see VARARGIN)

% Choose default command line output for sucrose_review
handles.output = hObject;

hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    return;
end

%set up the app data
setappdata(0, 'h_sucr_review', gcf);
setappdata(gcf, 'handles', handles);
setappdata(gcf, 'tablePosition', []);
%get the data structure from the main interace
dataStruct = getappdata(hMain, 'dataStruct');
concentrations    = unique([dataStruct.concentration]);
numConcentrations = numel(concentrations);

setappdata(gcf, 'dataStruct', dataStruct);

%update the table
initTable(numConcentrations);

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes sucrose_review wait for user response (see UIRESUME)
% uiwait(handles.sucrose_review);



function initTable(numConc)
hRev = getappdata(0, 'h_sucr_review');
handles     = getappdata(hRev, 'handles');
dataStruct  = getappdata(hRev, 'dataStruct');
sucrConc    = num2cell(sort(unique([dataStruct.concentration]), 'descend'));
sucrFileCol = cellfun(@(C) ['File (' num2str(C) ')'], sucrConc, 'UniformOutput', false);

%get the options for the columns
colFrmt = get(handles.uitable_review, 'ColumnFormat');
colEdit = get(handles.uitable_review, 'ColumnEditable');
colSize = get(handles.uitable_review, 'ColumnWidth');
colName = get(handles.uitable_review, 'ColumnName');

if numConc > 1 && numel(colFrmt) < numConc*2
    colFrmt = repmat(colFrmt, 1, numConc);
    colEdit = repmat(colEdit, 1, numConc);
    colSize = repmat(colSize, 1, numConc);
    colName = repmat(colName, 1, numConc);
elseif numConc < 1
    return;
end

numCols = numel(colEdit);
for c = 1:numel(sucrFileCol)
    colIdx = 1 + (2*(c-1));
    colName(colIdx) = sucrFileCol(c);
end

set(handles.uitable_review, 'ColumnFormat', colFrmt);
set(handles.uitable_review, 'ColumnEditable', colEdit);
set(handles.uitable_review, 'ColumnWidth', colSize);
set(handles.uitable_review, 'ColumnName', colName);

%try to link the data and put it into the table
linkTable = linkDataStructure();

if size(linkTable, 2) ~= numCols
    %error
    return;
end

%add the data to the table
set(handles.uitable_review, 'Data', linkTable);



function [tabledata] = linkDataStructure()
hRev  = getappdata(0, 'h_sucr_review');
dataS = getappdata(hRev, 'dataStruct');

groupnames  = {dataS.groupname};
filenames   = {dataS.filename};
genotypes   = {dataS.genotype};
sucroseConc = [dataS.concentration];
maxSucrose  = max(sucroseConc);
sucrConc    = sort(unique(sucroseConc), 'descend');
numConc     = numel(unique(sucroseConc));
posArray    = 1:2:(numConc*2-1);

if any(sucroseConc<maxSucrose) && ~all(sucroseConc<maxSucrose)
    [tabledata, clean_fltr] = generateLinkage(filenames, genotypes, sucroseConc, posArray, sucrConc);
    filenames(clean_fltr)   = [];
    sucroseConc(clean_fltr) = [];
    while numel(filenames) > 0
        [tbl_data, clean_fltr]  = generateLinkage(filenames, genotypes, sucroseConc, posArray, sucrConc);
        filenames(clean_fltr)   = [];
        sucroseConc(clean_fltr) = [];
        tabledata = [tabledata; tbl_data];
    end
    
    %we're done
end


function [linkedData, clean_fltr] = generateLinkage(filenames, genotypes, sucroseConc, posArray, sucrConc)
% filenames:    list of filenames available for linking
% sucroseConc:  list of sucrose concentrations
% posArray:     locations of concentrations within the linked data

maxSucrose  = max(sucroseConc);
numConc     = numel(unique(sucroseConc));

%check the concentrations supplied against the max
link_accept_fltr = sucroseConc==maxSucrose;
link_donor_fltr  = sucroseConc<maxSucrose;

%create the output table
linkedData = cell(sum(link_accept_fltr), 2*numel(posArray));
%add false values for all the remove columns
linkedData(:, 2:2:end) = {false};
linkedData(:, 1:2:end) = {'none'};
%find the column to which the acceptor files belong
acceptPos = find(maxSucrose==sucrConc, 1, 'first');
acceptPos = posArray(acceptPos);
%add the data to that column
linkedData(:, acceptPos) = filenames(link_accept_fltr)';

if numel(unique(sucroseConc)) == 1
    %nothing else to do here, return
    clean_fltr = true(1, numel(sucroseConc));
    return;
end
%determine the genotypes for the acceptor files
unqGeno = unique(genotypes(link_accept_fltr));
numGeno = numel(unqGeno);
    
%get the indices for the two groups
group_accept = find(link_accept_fltr);

%create a filter and remove the acceptors
clean_fltr = false(1, numel(filenames));
clean_fltr(group_accept) = true;

%check the linkage for each acceptor
for i = 1:numel(group_accept)
    idx = group_accept(i);
    currFilename = filenames{idx};
    currGenotype = genotypes{idx};
    genotypefltr = all([link_donor_fltr(:) strcmp(currGenotype, genotypes(:))], 2);
    idxPrefix    = regexp(currFilename, '[-_ ]\d{3,4}.abf$');
    filePrefix   = currFilename(1:idxPrefix-1);
    
    %clean up the donor filenames according to genotype
    group_donor_files = filenames(genotypefltr);
    group_donor_conc  = sucroseConc(genotypefltr);
    group_donor  = find(genotypefltr);
        
    %try to locate the donor
    filePrefix  = regexprep(filePrefix, '\(', '\\(');
    filePrefix  = regexprep(filePrefix, '\)', '\\)');
    donor_idx   = ~cellfun('isempty', regexp(group_donor_files, [filePrefix '[-_ ]'], 'once'));
    donor_idx   = find(donor_idx);
    %get a filename from the index
    if isempty(donor_idx)
        linkedData(i, 3:2:end) = {'none'};
    else
        %found it, create the links
        donor_filename = group_donor_files(donor_idx);
        donor_conc     = group_donor_conc(donor_idx);
        
        %apply a sort to make sure the order is from high to low
        [donor_conc,sortIdx] = sort(donor_conc, 'descend');
        donor_filename(sortIdx) = donor_filename;
        %check if all the sub-maximal concentrations are present
        if numel(donor_conc) < numel(posArray)-1
            %Nope, find out where to fill in the data
            for dc = 1:numel(donor_conc)
                currConc = donor_conc(dc);
                currIdx  = find(currConc==sucrConc, 1, 'first');
                idx = posArray(currIdx);
                linkedData(i, idx) = donor_filename(dc);
            end
        else
            if numel(donor_filename) > numConc-1
                linkedData(i, 3:2:end) = donor_filename(1:numConc-1);
            else
                linkedData(i, 3:2:end) = donor_filename;
            end
        end
        for j = 1:numel(donor_filename)
            fn = donor_filename{j};
            cleanIdx = find(strcmp(fn, filenames), 1, 'first');
            clean_fltr(cleanIdx) = true;
        end
    end
end


% --- Outputs from this function are returned to the command line.
function varargout = sucrose_review_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes when selected cell(s) is changed in uitable_review.
function uitable_review_CellSelectionCallback(hObject, eventdata, handles)
% hObject    handle to uitable_review (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) currently selecteds
% handles    structure with handles and user data (see GUIDATA)
hRev  = getappdata(0, 'h_sucr_review');

selectIdx = eventdata.Indices;
if numel(selectIdx) == 0
    return;
end

row = selectIdx(1);
col = selectIdx(2);

if mod(col, 2) == 0
    %even columns are true/false columns
    %deduct 1 to get the filename
    col = col - 1;
end
tabledata = get(handles.uitable_review, 'Data');
setappdata(hRev, 'tablePosition', [row, col]);
selectFile = tabledata{row, col};

if islogical(selectFile) || strcmp(selectFile, 'none')
    if strcmp(selectFile, 'none')
        cla(handles.axes_plot);
    end
    return;
else
    %locate the index and plot it
    hRev  = getappdata(0, 'h_sucr_review');
    dataS = getappdata(hRev, 'dataStruct');
    filenames = {dataS.filename};
    selIdx = find(strcmp(selectFile, filenames), 1, 'first');
    
    %get the relevant info
    fltr = any(dataS(selIdx).filters.blck_fltrs, 2);
    rawdata = dataS(selIdx).rawdata;
    time    = (0:numel(rawdata)-1)*dataS(selIdx).sample_int;
    
    rawdata(~fltr) = nan;
    time(~fltr)    = nan;
    
    %start the plotting procedure
    cla(handles.axes_plot);
    plot(handles.axes_plot, time, rawdata, 'k');
    ylabel(handles.axes_plot, 'Current (pA)');
    xlabel(handles.axes_plot, 'Time (sec)');
    title(handles.axes_plot, dataS(selIdx).filename, 'Interpreter', 'none');
end

% --- Executes when entered data in editable cell(s) in uitable_review.
function uitable_review_CellEditCallback(hObject, eventdata, handles)
% hObject    handle to uitable_review (see GCBO)
% eventdata  structure with the following fields (see UITABLE)
%	Indices: row and column indices of the cell(s) edited
%	PreviousData: previous data for the cell(s) edited
%	EditData: string(s) entered by the user
%	NewData: EditData or its converted form set on the Data property. Empty if Data was not changed
%	Error: error string when failed to convert EditData to appropriate value for Data
% handles    structure with handles and user data (see GUIDATA)

set(handles.push_remove, 'Enable', 'on');

% --- Executes on button press in push_remove.
function push_remove_Callback(hObject, eventdata, handles)
hRev      = getappdata(0, 'h_sucr_review');
dataS     = getappdata(hRev, 'dataStruct');
dataFiles = {dataS.filename};
maxConc   = max([dataS.concentration]);
tabledata = get(handles.uitable_review, 'Data');

%create a cell array for the filenames and the filters
filenames = tabledata(:, 1:2:end);
filefltrs = cell2mat(tabledata(:, 2:2:end));
numRemove = sum(sum(filefltrs));
rmFiles   = cell(1, numRemove);

numConc = size(filenames, 2);
for i = 1:numConc
    %get all the filenames that need to be removed for each concentration
    markFiles = filenames(filefltrs(:,i), i);
    nonefltr = strcmp('none', markFiles);
    if any(nonefltr)
        markFiles(nonefltr) = [];
    end
    
    if i == 1
        rmFiles = markFiles;
    else
        rmFiles = [rmFiles; markFiles(:)];
    end
end

%if there's nothing to remove, return;
if numel(rmFiles) == 0
    return;
end

%ask the user if he's sure...
answer = questdlg(['Do you really wish to remove ' num2str(numel(rmFiles)) ' files from the data structure?']);

%handle the 'no action' options
if isempty(answer) || strcmp(answer, 'Cancel') || strcmp(answer, 'No')
    %nothing to do here
    return;
end

%start removing the files
clean_fltr = false(1, numel(dataFiles));
clean_link = false(1, numel(dataFiles));
for f = 1:numel(rmFiles)
    currFile = rmFiles{f};
    idx = find(strcmp(currFile, dataFiles), 1, 'first');
    
    %remove the selected file
    clean_fltr(idx) = true;
    
    if dataS(idx).concentration == maxConc
        %remove the linked files
        linkedFiles = dataS(idx).linkedFile;
        for n = 1:numel(linkedFiles)
            linkFile = linkedFiles{n};
            idx = find(strcmp(linkFile, dataFiles), 1, 'first');
            clean_link(idx) = true;
        end
    end
end

if sum(clean_link) > 0
    %there are linked files, remove them?
    button = questdlg(['Do you also wish to remove ' num2str(sum(clean_link)) ' linked files?'], 'Remove linked files', 'Yes', 'No', 'Yes');
else
    button = [];
end

%handle the 'no action' options
if isempty(button) || strcmp(button, 'No')
    appendSucroseLog(['Started removing ' num2str(sum(clean_fltr)) ' files from the structure'], 'Info');
    for r = 1:numel(rmFiles)
        appendSucroseLog(['Removing file ' rmFiles{r}], 'Info');
    end
    appendSucroseLog(['Finished removing ' num2str(sum(clean_fltr)) ' files from the structure'], 'Info');
    dataS(clean_fltr) = [];
else
    clean_fltr = any([clean_fltr; clean_link], 1);
    appendSucroseLog(['Started removing ' num2str(sum(clean_fltr)) ' files from the structure'], 'Info');
    rmFiles = dataFiles(clean_fltr);
    for r = 1:numel(rmFiles)
        appendSucroseLog(['Removing file ' rmFiles{r}], 'Info');
    end
    appendSucroseLog(['Finished removing ' num2str(sum(clean_fltr)) ' files from the structure'], 'Info');
    dataS(clean_fltr) = [];
end

%put the data back in the appdata
setappdata(hRev, 'dataStruct', dataS);

%redraw the interface
numConc = numel(unique([dataS.concentration]));
initTable(numConc);


% --- Executes when user attempts to close sucrose_review.
function sucrose_review_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to sucrose_review (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%synchronize the appdata
hRev      = getappdata(0, 'h_sucr_review');
dataS     = getappdata(hRev, 'dataStruct');

hMain = getappdata(0, 'h_sucrose');
if ~isempty(hMain)
    dataStruct = getappdata(hMain, 'dataStruct');
    
    %check if any changes have been made
    if numel(dataStruct) ~= numel(dataS)
        button = questdlg('Do you wish to overwrite the original data structure?', 'Overwrite', 'Yes', 'No', 'Yes');
        if isempty(button) || strcmp(button, 'No')
            %do nothing
        else
            %overwrite the data structure
            setappdata(hMain, 'dataStruct', dataS);
            appendSucroseLog('Data was edited by the user.', 'info');
        end
        
    end
end
rmappdata(0, 'h_sucr_review');
% Hint: delete(hObject) closes the figure
delete(hObject);


% --------------------------------------------------------------------
function popup_menu_remove_Callback(hObject, eventdata, handles)
% hObject    handle to popup_menu_remove (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --------------------------------------------------------------------
function popup_menu_remove_from_Callback(hObject, eventdata, handles)
hRev    = getappdata(0, 'h_sucr_review');
posData = getappdata(hRev, 'tablePosition');

if isempty(posData)
    return;
else
    %get the position
    row = posData(1);
    col = posData(2);
    tabledata = get(handles.uitable_review, 'Data');
    
    if mod(col, 2) ~= 0
        %odd columns contain the filenames so add 1
        col = col + 1;
    end
    %set the values of the checkboxes to true
    tabledata(row:end, col) = {true};
    %return the data
    set(handles.uitable_review, 'Data', tabledata);
end

% --------------------------------------------------------------------
function popup_menu_remove_to_Callback(hObject, eventdata, handles)
hRev    = getappdata(0, 'h_sucr_review');
posData = getappdata(hRev, 'tablePosition');

if isempty(posData)
    return;
else
    %get the position
    row = posData(1);
    col = posData(2);
    tabledata = get(handles.uitable_review, 'Data');
    
    if mod(col, 2) ~= 0
        %odd columns contain the filenames so add 1
        col = col + 1;
    end
    %set the values of the checkboxes to true
    tabledata(1:row, col) = {true};
    %return the data
    set(handles.uitable_review, 'Data', tabledata);
end


% --------------------------------------------------------------------
function popup_menu_Callback(hObject, eventdata, handles)
% hObject    handle to popup_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
