function k2 = sucrose_sigmoid(time,t_start,t_end,k_20,k_2max,t_delay,tau_onset,tau_decay)

k2 = zeros(length(time),1);

start_idx = find(time >= t_start, 1);
end_idx = find(time >= t_end, 1);

k2(1:start_idx) = k_20;
k2(start_idx:end_idx) = k_2max*exp(-exp( -(time(start_idx:end_idx)-t_start-t_delay)/tau_onset ));
k2(end_idx:end) = k_2max*exp(-exp( -(t_end-t_start-t_delay)/tau_onset)).*exp(-(time(end_idx:end)-t_end)/tau_decay);

end