function varargout = sucrose_stats(varargin)
% SUCROSE_STATS MATLAB code for sucrose_stats.fig
%      SUCROSE_STATS, by itself, creates a new SUCROSE_STATS or raises the existing
%      singleton*.
%
%      H = SUCROSE_STATS returns the handle to a new SUCROSE_STATS or the handle to
%      the existing singleton*.
%
%      SUCROSE_STATS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SUCROSE_STATS.M with the given input arguments.
%
%      SUCROSE_STATS('Property','Value',...) creates a new SUCROSE_STATS or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before sucrose_stats_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to sucrose_stats_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help sucrose_stats

% Last Modified by GUIDE v2.5 01-Jul-2014 11:48:33

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @sucrose_stats_OpeningFcn, ...
                   'gui_OutputFcn',  @sucrose_stats_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before sucrose_stats is made visible.
function sucrose_stats_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to sucrose_stats (see VARARGIN)

% Choose default command line output for sucrose_stats
handles.output = hObject;

setappdata(0, 'h_stats', gcf);
setappdata(gcf, 'handles', handles);

hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    %ask the user to select a session file
    [sessionFile, path, ~] = uigetfile({'*.mat' 'Sucrose session (*.mat)'}, 'Select a session file', 'MultiSelect', 'off');
    if path == 0
        return;
    end
    
    try
        in = load(fullfile(path, sessionFile));
        if isfield(in, 'dataStruct')
            %dataStruct is there, check if statStruct is there as well
            dataStruct = in.dataStruct;
            if isfield(in, 'statStruct')
                statStruct = in.statStruct;
            else
                %use the dataStruct to create a statStruct
                dataStruct = in.dataStruct;
                setappdata(gcf, 'dataStruct', dataStruct);
                statStruct = generateStatStruct(dataStruct);
            end
        else
            %no valid data
            return;
        end
    catch me
        appendSucroseLog(me, 'warning');
        return;
    end
else
    dataStruct = getappdata(hMain, 'dataStruct');
    statStruct = getappdata(hMain, 'statStruct');
end

%at this point statStruct should be available
setappdata(gcf, 'dataStruct', dataStruct);
setappdata(gcf, 'statStruct', statStruct);
%set the block information
setappdata(gcf, 'currentBlock', 1);
lastBlock = max([dataStruct.nrOfBlocks]);
setappdata(gcf, 'lastBlock', lastBlock);

%set the available genotypes
genotypes = unique({dataStruct.genotype});
set(handles.popup_genotype, 'String', genotypes);
set(handles.popup_genotype, 'Value', 1);

%set the window in data cursor mode to enable identification of individual
%data points within the plot.
dcm_obj = datacursormode(gcf);
set(dcm_obj, 'UpdateFcn', @extractDataPoint);
set(dcm_obj, 'enable', 'on');

%call updatePlot to show the results
updatePlot();

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes sucrose_stats wait for user response (see UIRESUME)
% uiwait(handles.statGUI);


% --- Outputs from this function are returned to the command line.
function varargout = sucrose_stats_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


function [settings] = getSucroseSettings()
rootdir = regexprep(mfilename('fullpath'), mfilename, '');
settingsFile = fullfile(rootdir, 'sucrose_settings.mat');

try
    in = load(settingsFile);
    if isfield(in, 'settings')
        settings = in.settings;
    else
        settings = [];
    end
catch me
    appendSucroseLog(me);
    settings = [];
end



function [statS] = generateStatStruct(dataS)
hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    settings = getSucroseSettings();
else
    settings = getappdata(hMain, 'settings');
end
maxBlcks = max([dataS.nrOfBlocks]);

if isempty(dataS) || isempty(settings)
    %not enough info to process the data
    return;
end


%%% calculate the basic file statistics first (exception)
numRecords = numel(dataS);
%initialize arrays
baselineLeak  = nan(numRecords, maxBlcks);
baselineSlope = nan(numRecords, maxBlcks);
noiseLevel    = nan(numRecords, maxBlcks);
peakLevel     = nan(numRecords, maxBlcks);
fitQuality    = nan(numRecords, maxBlcks);

for d = 1:numRecords
    %get the raw data
    trace    = dataS(d).rawdata;
    trace_sm = smooth(trace, 2000);
    blckfltrs = dataS(d).filters.blck_fltrs;
    si = dataS(d).sample_int;
    
    for p = 1:dataS(d).nrOfBlocks
        %get the block filter and determine the start and stop index
        blckfltr = blckfltrs(:,p);
        i  = find(blckfltr,1,'first');
        ii = i - floor(settings.baselineLength/si+1);
        
        %check if value is within bounds and calculate the leak
        %accordingly
        if ii <= 0
            ii = i + floor(settings.baselineLength/si+1);
            baselineLeak(d, p)  = mean(trace(i:ii));
        else
            baselineLeak(d, p)  = mean(trace(ii:i));
        end
        
        %adjust the stop index for the slope to extend beyond the fitted
        %response
        ii = find(blckfltr,1,'last');
        
        %calculate the noise level during the response
        noiseLevel(d, p) = sqrt(sum((trace_sm(i:ii)-trace(i:ii)).^2)/(ii-i));
        peakLevel(d, p)  = min(trace_sm(i:ii));
        
        %for the slope, add 2 seconds to the pulse duration
        ii = ii + 2e4;
        if settings.useAdaptiveBase
            baselineSlope(d, p) = (trace(ii)-trace(i))/((ii-i-1)/si);
        else
            baselineSlope(d, p) = 0;
        end
        
        %when a fit is present, calculate the fit quality
        if isfield(dataS(d), 'blockAnalysis') && ~isempty(dataS(d).blockAnalysis)
            fitQuality(d, p) = determineFitQuality(d, p);
        end
        
    end
    
end
%add the values to the struct
statS(1).baselineLeak  = baselineLeak;
statS(1).baselineSlope = baselineSlope;
statS(1).noiseLevel    = noiseLevel;
statS(1).peakLevel     = peakLevel;
statS(1).fitQuality    = fitQuality;

%%% caclulate the mean, sd and SEM for the parameters
statS(2).baselineLeak  = struct('mean', nanmean(baselineLeak,1),...
                                'stdv', nanstd(baselineLeak,[],1),...
                                'sem', nanstd(baselineLeak,[],1)/sqrt(sum(isnan(baselineLeak))),...
                                'num', sum(isnan(baselineLeak)));
statS(2).baselineSlope = struct('mean', nanmean(baselineSlope,1),...
                                'stdv', nanstd(baselineSlope,[],1),...
                                'sem', nanstd(baselineSlope,[],1)/sqrt(sum(isnan(baselineSlope))),...
                                'num', sum(isnan(baselineSlope)));
statS(2).noiseLevel    = struct('mean', nanmean(noiseLevel,1),...
                                'stdv', nanstd(noiseLevel,[],1),...
                                'sem', nanstd(noiseLevel,[],1)/sqrt(sum(isnan(noiseLevel))),...
                                'num', sum(isnan(noiseLevel)));
statS(2).peakLevel     = struct('mean', nanmean(peakLevel,1),...
                                'stdv', nanstd(peakLevel,[],1),...
                                'sem', nanstd(peakLevel,[],1)/sqrt(sum(isnan(peakLevel))),...
                                'num', sum(isnan(peakLevel)));
statS(2).fitQuality    = struct('mean', nanmean(fitQuality,1),...
                                'stdv', nanstd(fitQuality,[],1),...
                                'sem', nanstd(fitQuality,[],1)/sqrt(sum(isnan(fitQuality))),...
                                'num', sum(isnan(fitQuality)));



function [fitQ] = determineFitQuality(idx, blckID)
trace = getFitData(idx, blckID);
trace = trace(:,2);

%no trace data
if all(isnan(trace))
    fitQ = nan;
    return;
end
%only measure during the blocks
%nanfltr = ~isnan(trace);

hStat = getappdata(0, 'h_stats');
dataS = getappdata(hStat, 'dataStruct');
blckfltr = dataS(idx).filters.blck_fltrs(:,blckID);

%return the error (standard deviation equivalent)
fitQ = sqrt(sum((dataS(idx).rawdataCorr(blckfltr) - trace(blckfltr)).^2)/sum(blckfltr));



function [currdata] = getFitData(idx, blockID)
hStat    = getappdata(0, 'h_stats');

hMain = getappdata(0, 'h_sucrose');
if isempty(hMain)
    settings = getSucroseSettings();
else
    settings = getappdata(hMain, 'settings');
end
dataS    = getappdata(hStat, 'dataStruct');

data     = dataS(idx);
si       = data.sample_int;
currConc = data.concentration;

%create the data sets for plotting
rawE  = data.rawdata;
rawT  = (0:numel(rawE)-1)*si;

%init arrays
currdata = nan(numel(rawE),2);

sucrConcentrations = findConcentration(dataS, idx); %sort(unique([dataS.concentration]), 'descend');
currSucrIndex      = find(currConc==sucrConcentrations, 1, 'first');
startParIdx = 3 + (currSucrIndex-1)*3;

%basel = data.blockAnalysis(blockID).baselineconc;
fltr  = data.filters.blck_fltrs(:,blockID);

%epsc  = rawE(fltr)-basel;
time  = rawT(fltr);

%determine the start of this block
fitStartBlck = find(fltr, 1, 'first');
fitStartBlck = (fitStartBlck-1)*si;

if blockID > numel(data.blockAnalysis)
    return;
else
    origPar = data.blockAnalysis(blockID).parameters_extended;
end

bExtended = true;
if isempty(origPar)
    origPar = data.blockAnalysis(blockID).parameters;
    bExtended = false;
end

if isempty(origPar)
    return;
end
if currConc < sucrConcentrations(1)
    %sub-maximal concentration
    origK2_subMax = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, origPar(startParIdx), origPar(startParIdx+1), origPar(startParIdx+2), settings.sucrose_decay);
    if origPar(end-1) == 1000
        [origTimeM, origRelease_conc] = simulate_sucrose(time, origPar(end), origPar([1:2 startParIdx:startParIdx+2 end-1]), origK2_subMax);
    else
        if bExtended
            fixedPars = origPar(2);
            IC_states = origPar(end-1:end);
            [origTimeM, origRelease_conc] = simulate_sucrose(time, IC_states, origPar(1), origK2_subMax, fixedPars);
        else
            [origTimeM, origRelease_conc] = simulate_sucrose(time, origPar(end-1:end), origPar([1:2 startParIdx:startParIdx+2 end-1]), origK2_subMax);
        end
        
    end
else
    %maxmimal concentration
    if bExtended
        fixedPars = origPar(2);
        IC_states = origPar(end-1:end);
        origK2_max  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, origPar(3), origPar(4), origPar(5), settings.sucrose_decay);
        [origTimeM, origRelease_conc] = simulate_sucrose(time, IC_states, origPar(1), origK2_max, fixedPars);
    else
        origK2_max  = sucrose_sigmoid(time, fitStartBlck, time(end), settings.k20, origPar(3), origPar(4), origPar(5), settings.sucrose_decay);
        [origTimeM, origRelease_conc] = simulate_sucrose(time, origPar(end), origPar([1:5 end-1]), origK2_max);
    end
end

currdata(fltr,1) = origTimeM';
currdata(fltr,2) = origRelease_conc';



function sucrConc = findConcentration(dataS, idx)

%Get all concentrations present in the current dataStruct
allConcs = sort(unique([dataS.concentration]), 'descend');
maxConc = allConcs(1);

if dataS(idx).concentration == maxConc %current conc = max conc
    maxIdx = idx;
else %current conc = submax conc
    maxIdx = find(ismember({dataS.filename}, dataS(idx).linkedFile));    
end

submaxIdx = find(ismember({dataS.filename}, dataS(maxIdx).linkedFile));

submaxConc = zeros(1, numel(submaxIdx));
for i = 1:numel(submaxIdx)
    submaxConc(i) = dataS(submaxIdx(i)).concentration;
end

sucrConc = sort([maxConc submaxConc], 'descend');



                            
% --- Executes on button press in check_individual.
function check_individual_Callback(hObject, eventdata, handles)
% hObject    handle to check_individual (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of check_individual
updatePlot();

% --- Executes when selected object is changed in uipanel_plot.
function uipanel_plot_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uipanel_plot 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
updatePlot()


function [selectIdx] = getCurrentSelection()
hStat = getappdata(0, 'h_stats');
handles = getappdata(hStat, 'handles');
tmp(1) = get(handles.radio_leak, 'Value');
tmp(2) = get(handles.radio_slope, 'Value');
tmp(3) = get(handles.radio_noise, 'Value');
tmp(4) = get(handles.radio_peak, 'Value');
tmp(5) = get(handles.radio_fitQuality, 'Value');

selectIdx = find(tmp);



function updatePlot(bNew)
hStat      = getappdata(0, 'h_stats');
handles    = getappdata(hStat, 'handles');
statStruct = getappdata(hStat, 'statStruct');
dataStruct = getappdata(hStat, 'dataStruct');

if nargin == 0
    bNew = false; 
end

%get the currently selected plot type
currPlot = getCurrentSelection();
currBlck = getappdata(hStat, 'currentBlock');
currGeno = get(handles.popup_genotype, 'String');
currGeno = currGeno{get(handles.popup_genotype, 'Value')};

if bNew
    figure('Name', 'Statistics plot');
    hPlot = axes;
else
    hPlot = handles.axes_stats;
    cla(hPlot);
end

bIndv = get(handles.check_individual, 'Value');
allgenos  = {dataStruct.genotype};
allgroups = {dataStruct.groupname};
groups = unique(allgroups);

%create a genotype filter
genofltr = strcmp(currGeno, allgenos);

%all raw data will be collected in a cell array for plotting

switch(currPlot)
    case 1
        %retrieve the leak data
        data = [statStruct(1).baselineLeak];
        ylabel = 'Leak current (pA)';
    case 2
        %slope data
        data = [statStruct(1).baselineSlope];
        ylabel = 'Baseline slope (pA/sec)';
    case 3
        %noise data
        data = [statStruct(1).noiseLevel];
        ylabel = 'Data quality (deviation; pA)';
    case 4
        %peak data
        data = [statStruct(1).peakLevel];
        ylabel = 'Peak current (pA)';
    case 5
        %fit quality data
        data = [statStruct(1).fitQuality];
        ylabel = 'Fit quality (deviation; pA)';
    otherwise
        %should not occur
        return;
end

%select only the data from the current block and the current genotype
data = data(genofltr, currBlck);
allgroups = allgroups(genofltr);

if all(isnan(data))
    return;
end

ydata = cell(1, numel(groups));
%split the data per group and put it in a cell array; this should also fix
%the problem of sorting. Genotype is not taken into consideration at this
%point yet.
for g = 1:numel(groups)
    fltr = strcmp(groups{g}, allgroups);
    ydata(g) = {data(fltr)};
end

%use the makeBarPlot function written by Arthur de Jong to display the data
[~,~,~,barHandles,~] = makeBarPlotSucrose(ydata, [], groups, ylabel, hPlot, bIndv, [], 'kruskalwallis');
title(hPlot, ['Data block ' num2str(currBlck)]);
%set the limits to auto
ylim('auto');
if nanmean(data) < 0
    set(hPlot, 'YDir', 'reverse');
else
    set(hPlot, 'YDir', 'normal');
end


for b = 1:numel(barHandles)
    uistack(barHandles(b), 'bottom');
end
%make sure any data tips are set to the front
cursmode = datacursormode(hStat);
currTip = cursmode.CurrentDataCursor;
if ~isempty(currTip)
    uistack(currTip.TextBoxHandle, 'top');
end


% --- Executes on button press in push_prev.
function push_prev_Callback(hObject, eventdata, handles)
% hObject    handle to push_prev (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hStat = getappdata(0, 'h_stats');
currBlock = getappdata(hStat, 'currentBlock');
lastBlock = getappdata(hStat, 'lastBlock');
newBlock = currBlock - 1;
if newBlock < 1
    newBlock = lastBlock;
end
setappdata(hStat, 'currentBlock', newBlock);
updatePlot();


% --- Executes on button press in push_next.
function push_next_Callback(hObject, eventdata, handles)
% hObject    handle to push_next (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hStat = getappdata(0, 'h_stats');
currBlock = getappdata(hStat, 'currentBlock');
lastBlock = getappdata(hStat, 'lastBlock');

newBlock = currBlock + 1;
if newBlock > lastBlock
    newBlock = 1;
end
setappdata(hStat, 'currentBlock', newBlock);
updatePlot();



function [txt] = extractDataPoint(~, event_obj)
hStat = getappdata(0, 'h_stats');
handles = getappdata(hStat, 'handles');
dataS = getappdata(hStat, 'dataStruct');
statStruct = getappdata(hStat, 'statStruct');
filenames = {dataS.filename};

hPlot = handles.axes_stats;
pnt = get(event_obj, 'Position');

currPlot = getCurrentSelection();
currBlck = getappdata(hStat, 'currentBlock');

switch(currPlot)
    case 1
        %retrieve the leak data
        data = [statStruct(1).baselineLeak];
        unit   = 'pA';
    case 2
        %slope data
        data = [statStruct(1).baselineSlope];
        unit   = 'pA/sec';
    case 3
        %noise data
        data = [statStruct(1).noiseLevel];
        unit = 'pA';
    case 4
        %peak data
        data = [statStruct(1).peakLevel];
        unit = 'pA';
    case 5
        %fit quality data
        data = [statStruct(1).fitQuality];
        unit = 'pA';
    otherwise
        %should not occur
        return;
end

%select only the data from the current block
data = data(:, currBlck);

%check the order of magnitude
magOrder   = ceil(log10(abs(data)));
roundOrder = min(magOrder);

if roundOrder >=0
    fltr = floor(data) == floor(pnt(2));
    dataPnt = floor(pnt(2));
    unit = [unit ' (rounded)'];
else
    if exist('roundn', 'file') == 2
        %use the roundn function if present
        fltr = roundn(data, roundOrder) == roundn(pnt(2), roundOrder);
        dataPnt = roundn(pnt(2), roundOrder);
    else
        %use the poor man's approach
        fltr = round2ClosestVal(data, 10^roundOrder) == round2ClosestVal(pnt(2), 10^roundOrder);
        dataPnt = round2ClosestVal(pnt(2), 10^roundOrder);
    end
    unit = [unit ' (rounded)'];
end

%fltr = data == pnt(2);
idx  = find(fltr);
if rem(pnt(1),1)==0 || isempty(idx)
    ii = floor(pnt(1));
    groupnames = unique({dataS.groupname});
    unit = regexprep(unit, ' \(rounded\)', '');
    txt = sprintf('Mean: %s\nValue: %0.4g %s',groupnames{ii}, pnt(2), unit);
else
    if numel(idx) == 1
        unit = regexprep(unit, ' \(rounded\)', '');
        txt = sprintf('%s\nValue: %0.4g %s', filenames{idx}, pnt(2), unit);
    else
        txtF = sprintf(repmat('%s\n',1,numel(idx)), filenames{idx});
        txtF = txtF(1:end-1);
        txt  = sprintf('%s\nValue: %0.4g %s', txtF, dataPnt, unit);
    end
end

%make sure any data tips are set to the front
cursmode = datacursormode(hStat);
currTip = cursmode.CurrentDataCursor;
if ~isempty(currTip)
    uistack(currTip.TextBoxHandle, 'top');
end


function [roundedNumber] = round2ClosestVal(rawValue, roundingPrecision)
%function for rounding a value to the nearest precision
%
%[roundedNumber] = round2ClosestValue(rawValue, roundingPrecision)
%INPUT:
%   rawValue: the value to be rounded
%   roundingPrecision: the closest value to round to
%OUTPUT:
%   roundedNumber: the number rounded to the precision set by the input

roundedNumber = floor((rawValue*(1./roundingPrecision)+0.5)).*roundingPrecision;


% --- Executes on selection change in popup_genotype.
function popup_genotype_Callback(hObject, eventdata, handles)
% hObject    handle to popup_genotype (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = cellstr(get(hObject,'String')) returns popup_genotype contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popup_genotype
updatePlot();


% --- Executes during object creation, after setting all properties.
function popup_genotype_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popup_genotype (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --------------------------------------------------------------------
function popup_export_Callback(hObject, eventdata, handles)
% hObject    handle to popup_export (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%plot the results in a new window
updatePlot(true);


% --------------------------------------------------------------------
function popup_stats_Callback(hObject, eventdata, handles)
% hObject    handle to popup_stats (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
