function [dVes_states] = ves_state_model(t,states,par,time,k2)
%VES_STATE_MODEL function for calculating the vesicle states
%   

k2IP = interp1q(time,k2,t); 

%apply the parameters
k_1 = par(1);
k_min1 = par(2);
D = par(end);

if numel(states) == 2
    D = -k_1.*states(1) + k_min1*states(2);
    R = -(k_min1 + k2IP)*states(2) + k_1.*states(1);
    dVes_states = [D; R];
else
    R = -(k_min1 + k2IP)*states(1) + k_1.*D;
    dVes_states = R;
end

end

