function varargout = abf2mat(varargin)
% ABF2MAT M-file for abf2mat.fig
%      ABF2MAT, by itself, creates a new ABF2MAT or raises the existing
%      singleton*.
%
%      H = ABF2MAT returns the handle to a new ABF2MAT or the handle to
%      the existing singleton*.
%
%      ABF2MAT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in ABF2MAT.M with the given input arguments.
%
%      ABF2MAT('Property','Value',...) creates a new ABF2MAT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before abf2mat_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to abf2mat_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help abf2mat

% Last Modified by GUIDE v2.5 29-May-2009 14:08:05

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @abf2mat_OpeningFcn, ...
                   'gui_OutputFcn',  @abf2mat_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before abf2mat is made visible.
function abf2mat_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to abf2mat (see VARARGIN)

% Choose default command line output for abf2mat
handles.output = hObject;

FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
if isempty(gcbf)
   ScreenUnits=get(0,'Units');
   set(0,'Units','pixels');
   ScreenSize=get(0,'ScreenSize');
   set(0,'Units',ScreenUnits);

   FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
   FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
else
   GCBFOldUnits = get(gcbf,'Units');
   set(gcbf,'Units','pixels');
   GCBFPos = get(gcbf,'Position');
   set(gcbf,'Units',GCBFOldUnits);
   FigPos(1:2) = [(GCBFPos(1) + GCBFPos(3) / 2) - FigWidth / 2, ...
      (GCBFPos(2) + GCBFPos(4) / 2) - FigHeight / 2];
end
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Make the GUI modal
set(handles.figure1,'WindowStyle','modal')


%Anmo's code from this point
handles.finfo = varargin{1};

set(handles.figure1,'Name','FlySpikes: converting axon data files (*.abf) to matlab files (*.mat)');

%set outputs
handles.filepicks=[];
handles.durcap=[];%maximum duration in sec
%handles.plotoption=[];
% handles.downsampleratio=[];


if(length(handles.finfo)==0)
   delete(gcf);
   return;
end


handles.filespercolumn=10;
handles.columnsperpage=3;
handles.numcolumns=ceil(length(handles.finfo)/handles.filespercolumn);
handles.hcheckbox=zeros(handles.filespercolumn*handles.columnsperpage,1);
handles.htext=zeros(handles.filespercolumn*handles.columnsperpage,1);
handles.selected=zeros(length(handles.finfo),1);
handles.onfilek=[]; %indices of file names shown on the window
handles.nowfirstcolumn = 1;
handles=updatepage(handles);


% Update handles structure
guidata(hObject, handles);

% UIWAIT makes abf2mat wait for user response (see UIRESUME)
uiwait(handles.figure1);







% --- Outputs from this function are returned to the command line.
function varargout = abf2mat_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
%varargout{1} = handles.output;
if(isfield(handles,'filepicks'))
   varargout{1} = handles.filepicks;
   varargout{2}=handles.durcap;
   if(get(handles.checkbox_updateinfo,'Value'))
       varargout{3}{1}='updateinfo';
   else
       varargout{3}={};
   end
   if(get(handles.checkbox_incluceCh2,'Value'))
       varargout{3}{end+1}='includeCh2';
   end

   channelnum=[1 2 3 4];
   nch=str2num(get(handles.edit_nchElectrode1,'String'));
   if(~isempty(nch))
       if(nch<=4 && nch>=1)
           channelnum(1)=nch;
       end
   end
   
   nch=str2num(get(handles.edit_nchElectrode2,'String'));
   if(~isempty(nch))
       if(nch<=4 && nch>=1 && nch~=channelnum(1))
           channelnum(2)=nch;
       end
   end
   nch=str2num(get(handles.edit_nchPID,'String'));
   if(~isempty(nch))
       if(nch<=4 && nch>=1 && nch~=channelnum(1) && nch~=channelnum(2))
           channelnum(3)=nch;
       end
   end   

   nch=str2num(get(handles.edit_nchValveControl,'String'));
   if(~isempty(nch))
       if(nch<=4 && nch>=1 && nch~=channelnum(1) && nch~=channelnum(2)&&nch~=channelnum(3))
           channelnum(4)=nch;
       end
   end   
   
   varargout{4}=channelnum;
   
   piddelay=round(str2double(get(handles.edit_piddelay,'String')));
   if(isempty(piddelay))
       piddelay=0;
   end
   if(piddelay<0)
       piddelay=0;
   end
   
   varargout{5}=piddelay;
   
%   varargout{2} = handles.plotoption;
%   varargout{3} = handles.downsampleratio;
   delete(handles.figure1);
else
   varargout = {[],[],[],[],[]};
%   delete(handles.figure1);
end




function handles=updatepage(handles)
nfiles=length(handles.finfo);
if(nfiles==0) return; end

%update 'handles.selected'
if(~isempty(handles.onfilek))
   for k=1:length(handles.onfilek)
      handles.selected(handles.onfilek(k))=get(handles.hcheckbox(k),'Value');
      delete(handles.hcheckbox(k));
      delete(handles.htext(k));
   end
end

columnsperpage=handles.columnsperpage;

figureposition=get(gcf,'Position');

yloc = (handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.65+.17;

if(columnsperpage>1)
   for k=2:columnsperpage
      yloc = [yloc ((handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.65+.17)];
   end
end

for k=1:(handles.filespercolumn*columnsperpage)
   textx(k)=floor((k-1)/handles.filespercolumn)/columnsperpage+.02;
end
checkboxx = textx+.24;

nfiles2bshown=min(30,length(handles.finfo)-(handles.nowfirstcolumn-1)*handles.filespercolumn);
handles.onfilek=(1:nfiles2bshown)+(handles.nowfirstcolumn-1)*handles.filespercolumn;

for k=1:nfiles2bshown
      handles.htext(k)=uicontrol('Parent', gcf,...
      'Style', 'text',...
      'String', handles.finfo(k+handles.filespercolumn*(handles.nowfirstcolumn-1)).fname,...
      'Units', 'normalized',...
      'Position', [textx(k) yloc(k) .22 .05]);
   %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
end

for k=1:nfiles2bshown
   handles.hcheckbox(k)=uicontrol('Parent', gcf,...
      'Style', 'Checkbox',...
      'String', [],...
      'Units', 'normalized',...
      'Position', [checkboxx(k) yloc(k)+.01 .05 .05],...
      'Value', handles.selected(k+handles.filespercolumn*(handles.nowfirstcolumn-1)),...
      'Tag', sprintf('checkbox_%03d',k),...
      'ToolTipString',inf2str(handles.finfo(k+handles.filespercolumn*(handles.nowfirstcolumn-1))));
   %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
end
set(handles.checkbox_all, 'Value', 0);
set(handles.text_msg,'String', sprintf('%d files listed', length(handles.finfo)));


%==================================
function out=inf2str(finfo)
out=[];
names=fieldnames(finfo);
for k=1:length(names)
   eval(strcat('val=finfo.',names{k},';'));
   if(~isempty(val) )
      if(isnumeric(val) & length(val)<10)
         val=num2str(val);
      end
      if(isstr(val) && length(val)<60)
         out=strcat(out, names{k}, '=',val,',');
      end
   end
end




% --- Executes on button press in checkbox_all.
function checkbox_all_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_all (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_all
if(get(handles.checkbox_all, 'Value'))
   %selected
   for k=1:length(handles.onfilek)
      if(handles.hcheckbox(k)~=0)
         set(handles.hcheckbox(k),'Value',1);
      end
   end
   set(handles.checkbox_column1,'Value',1);
   set(handles.checkbox_column2,'Value',1);
   set(handles.checkbox_column3,'Value',1);
else
   %deselected
   for k=1:length(handles.onfilek)
      if(handles.hcheckbox(k)~=0)
         set(handles.hcheckbox(k),'Value',0);
      end
   end
   set(handles.checkbox_column1,'Value',0);
   set(handles.checkbox_column2,'Value',0);
   set(handles.checkbox_column3,'Value',0);
end




% --- Executes on button press in pushbutton_left.
function pushbutton_left_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_left (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
nowfirstcolumn=handles.nowfirstcolumn;
if(nowfirstcolumn >1)
   handles.nowfirstcolumn=max(1,nowfirstcolumn-3);
   handles=updatepage(handles);
   guidata(hObject, handles);
end



% --- Executes on button press in pushbutton_right.
function pushbutton_right_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_right (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
nowfirstcolumn=handles.nowfirstcolumn;
if(nowfirstcolumn <= (handles.numcolumns-2))
   handles.nowfirstcolumn=min(handles.numcolumns-2,nowfirstcolumn+3);
   handles=updatepage(handles);
   guidata(hObject, handles);
end



% --- Executes on button press in pushbutton_convert.
function pushbutton_convert_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_convert (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=updatepage(handles); %update 'handles.selected'

filek=[];
for k=1:length(handles.selected)
   if(handles.selected(k)==1)
      filek=[filek; k];
   end
end

handles.filepicks=filek;

handles.durcap=str2num(get(handles.edit_durcap,'String'));

guidata(hObject, handles);
uiresume(handles.figure1);
   
   




% 
% function edit_downsampleratio_Callback(hObject, eventdata, handles)
% % hObject    handle to edit_downsampleratio (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% % Hints: get(hObject,'String') returns contents of edit_downsampleratio as text
% %        str2double(get(hObject,'String')) returns contents of edit_downsampleratio as a double
% 
% 
% % --- Executes during object creation, after setting all properties.
% function edit_downsampleratio_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to edit_downsampleratio (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
% 
% % Hint: edit controls usually have a white background on Windows.
% %       See ISPC and COMPUTER.
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end




% --- Executes on button press in checkbox_column1.
function checkbox_column1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column1
if(length(handles.onfilek)>0)
   if(get(hObject, 'Value'))
      %selected
      for k=1:min(10,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',1);
         end
      end

   else
      %deselected
      for k=1:min(10,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',0);
         end
      end
   end
end

% --- Executes on button press in checkbox_column2.
function checkbox_column2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column2
if(length(handles.onfilek)>10)
   if(get(hObject, 'Value'))
      %selected
      for k=11:min(20,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',1);
         end
      end
   else
      %deselected
      for k=11:min(20,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',0);
         end
      end
   end
end

% --- Executes on button press in checkbox_column3.
function checkbox_column3_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column3
if(length(handles.onfilek)>20)
   if(get(hObject, 'Value'))
      %selected
      for k=21:length(handles.onfilek)
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',1);
         end
      end
   else
      %deselected
      for k=21:length(handles.onfilek)
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',0);
         end
      end
   end
end



% --- Executes on button press in pushbutton_viewinf.
function pushbutton_viewinf_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_viewinf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
viewinf;




function edit_durcap_Callback(hObject, eventdata, handles)
% hObject    handle to edit_durcap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_durcap as text
%        str2double(get(hObject,'String')) returns contents of edit_durcap as a double


% --- Executes during object creation, after setting all properties.
function edit_durcap_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_durcap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end







function edit_nchElectrode1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_nchElectrode1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_nchElectrode1 as text
%        str2double(get(hObject,'String')) returns contents of edit_nchElectrode1 as a double


% --- Executes during object creation, after setting all properties.
function edit_nchElectrode1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_nchElectrode1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_nchElectrode2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_nchElectrode2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_nchElectrode2 as text
%        str2double(get(hObject,'String')) returns contents of edit_nchElectrode2 as a double


% --- Executes during object creation, after setting all properties.
function edit_nchElectrode2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_nchElectrode2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_nchPID_Callback(hObject, eventdata, handles)
% hObject    handle to edit_nchPID (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_nchPID as text
%        str2double(get(hObject,'String')) returns contents of edit_nchPID as a double


% --- Executes during object creation, after setting all properties.
function edit_nchPID_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_nchPID (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_nchValveControl_Callback(hObject, eventdata, handles)
% hObject    handle to edit_nchValveControl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_nchValveControl as text
%        str2double(get(hObject,'String')) returns contents of edit_nchValveControl as a double


% --- Executes during object creation, after setting all properties.
function edit_nchValveControl_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_nchValveControl (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox_incluceCh2.
function checkbox_incluceCh2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_incluceCh2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_incluceCh2





function edit_piddelay_Callback(hObject, eventdata, handles)
% hObject    handle to edit_piddelay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_piddelay as text
%        str2double(get(hObject,'String')) returns contents of edit_piddelay as a double


% --- Executes during object creation, after setting all properties.
function edit_piddelay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_piddelay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
