%Anmo Kim
%flyspikes.m
%12/11/2007

%====== global variables
%handles.configfname : configuration file name
%handles.activetab : currently activated tab (1..3)
%handles.nowpwd : current folder
%handles.mfolder : m folder
%handles.flist : list of .mat files


function varargout = flyspikes(varargin)
% FLYSPIKES M-file for flyspikes.fig
%      FLYSPIKES, by itself, creates a new FLYSPIKES or raises the existing
%      singlton*.
%
%      H = FLYSPIKES returns the handle to a new FLYSPIKES or the handle to
%      the existing singleton*.
%
%      FLYSPIKES('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FLYSPIKES.M with the given input arguments.
%
%      FLYSPIKES('Property','Value',...) creates a new FLYSPIKES or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before flyspikes_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to flyspikes_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help flyspikes

% Last Modified by GUIDE v2.5 09-Jul-2010 20:31:35

% Begin initialization code - DO NOT EDIT
gui_Singleton = 0;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @flyspikes_OpeningFcn, ...
    'gui_OutputFcn',  @flyspikes_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT





% --- Executes just before flyspikes is made visible.
function flyspikes_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to flyspikes (see VARARGIN)

% Choose default command line output for flyspikes
handles.output = hObject;


%intialization
if(~exist('fs_config.mat','file'))
    user='Anmo Kim';
    date0=date;
    save('./fs_config.mat','user','date0');
end
handles.configfname=which('fs_config.mat');
set(handles.figure1,'Name','FlySpikes 1.0');

handles.activetab=readconfigvar(handles.configfname,'activetab');
if(isempty(handles.activetab))
    handles.activetab=1;
end
updatetab(handles);

handles=updatepwd(handles);

handles.configvars={...
    'activetab',... %1:findspike tab, 2:viewspike tab, 3:decspike tab
    'vZoomrange0',... %starting zoom range [in sec]
    'vZoomrange1',... %end zoom range [in sec]
    'movingrate',...%movingrate for move stuff..
    'genut',...%starting point for genut (in msec)
    'temparams',...%threshold [V]
    'cmdstr',...
    'dZoomrange',...
    'fZoomrange',...
    'fresetthresholdbase',...
    'keepdelta',...
    'deltax_sliderstep',...%for finder tab, threshold adjustment
    'deltax_sliderval',...%
    'nowpwd',...%last visited path
    'p2pchangetolerance',...%spike detection parameter
    'isichangetolerance',... %spike detection parameter
    'minISI',...%minimum interspike interval
    'nSpikeTypes',...%number of spike types
    'SortingNet',...%weight vector for spike sorting
    'nPreLearn',...%number of pre-learn trials
    'nPostLearn',...%number of post-learn trials
    'SortingC',...%centroid locations
    'fInvertD',...%invert data when loaded by find panel
    'sorteq',...%sorting equalizer setting between [0,1]
    'sortbasisk',...%feature index for ordering clusters
    'sortleftwin',...%sorting left window size
    'sortrightwin'};%sorting right window size

handles.configvars_default={...
    1,...
    4.9,...
    7.5,...
    0.5,... %movingrate
    [],... %genut
    [],...%temparams
    '=u01',...
    [0 30000],...
    [4 8],...
    0.45,...%fresetthresholdbase
    0,...
    [0.01 0.1],...
    0.5,...
    [],...
    0.5,...%p2pchangetolerance
    0.25,...%isichangetolerance
    1.5,...%minISI
    3,...%nSpikeTypes
    [],...%sortingw
    100,...%nPreLearn
    50,...%nPostLearn
    [],...%SortingC
    0,...%fInvertD
    [1 1 1 1 1 1 1 1 1 1],...%sorteq
    1,...%sortbasisk
    2,...%sortleftwin
    2};%sortrightwin

handles.axesinfoid={...
    'fname',...%file name
    'd',...%data
    'dt',...%sampling interval
    't0',...%recording starting time - when d(1) is sampled
    'tend',...%ending time of the recording
    'c',...%odor concentration data
    'spkk',...%spike index for d - spike timing is 'spkk*dt+t0'
    'nspks',...%number of spikes
    'stimstart',...%stimulation start moment in msec
    'stimdur',...%stimulation duration in msec
    'valveseq',...%valve sequence
    'npulses',...%number of stimulation
    'stimtype',...%odorant type
    'valve_open0',...%valve opening moment in msec
    'Iin',...%injected current (in uA)
    'pp',...%picospritzer pressure (in psi)
    'con',...%odor concentration (in volume ratio)
    'celltype',...%celltype
    'etc',...%etc
    'analmethod',...%method of spike detection
    };


handles.infname={'fnhead',...%do not chage the order of this entry
    'fnum',...%do not chage the order of this entry
    'stimstart',...
    'stimdur',...
    'npulses',...
    'valveseq',...%    'pp/con',...
    'pp',...
    'con',...
    'stimtype',...
    'Iin',...
    'celltype',...
    'etc'};


handles.inftype={'char',...
    'num',...
    'num',...
    'num',...
    'num',...
    'char',...%    'num',...
    'num',...
    'num',...
    'char',...
    'num',...
    'char',...
    'char'};


%read all config variables
handles=readallconfig(handles);


%set fInvertD checkbox
set(handles.checkbox_fInvertD,'Value',handles.fInvertD);

%set the moving rate slider
if(handles.movingrate>=0 && handles.movingrate<=1)
    set(handles.slider_movingrate, 'Value',handles.movingrate);
end



if(~isempty(dir('*.abf')) || exist('./m','dir') || ~isempty(dir('*.mat')))
    handles.nowpwd=pwd;
else
    handles=updatepwd(handles, handles.nowpwd);
end

if(ispc())
    tempk=findstr(handles.nowpwd,'\');
else
    tempk=findstr(handles.nowpwd,'/');
end

if(isempty(tempk))
    nowpwd0=handles.nowpwd;
else
    nowpwd0=handles.nowpwd((tempk(end)+1):end);
end

if(~isempty(dir('*.abf')))
    %if the pwd is abf folder
    if(ispc())
        handles.mfolder=strcat(handles.nowpwd,'\m\');
    else
        handles.mfolder=strcat(handles.nowpwd,'/m/');
    end
elseif(~isempty(dir('*.mat')) && strcmp(nowpwd0,'m'))
    %if pwd is m folder
    if(ispc())
        handles.mfolder=strcat(handles.nowpwd,'\');
    else
        handles.mfolder=strcat(handles.nowpwd,'/');
    end
elseif(~isempty(dir('*.fig')) && strcmp(nowpwd0,'doc'))
    %if pwd is doc folder
    if(ispc())
        handles.mfolder=strcat(handles.nowpwd(1:(end-3)),'m\');
    else
        handles.mfolder=strcat(handles.nowpwd(1:(end-3)),'m/');
    end
else
    handles.mfolder='';
end


if(~isempty(handles.mfolder) && ~exist(handles.mfolder,'dir'))
    mkdir(handles.mfolder);
end

if(ispc())
    handles.docfolder=[handles.mfolder(1:(end-2)) 'doc\'];
else
    handles.docfolder=[handles.mfolder(1:(end-2)) 'doc/'];
end

if(~exist(handles.docfolder,'dir'))
    mkdir(handles.docfolder);
end

% if(~isempty(handles.mfolder))
%     if(handles.mfolder(end)~='/' && handles.mfolder(end)~='\')
%         if(ispc())
%             handles.mfolder=strcat(handles.mfolder,'\');
%         else
%             handles.mfolder=strcat(handles.mfolder,'/');
%         end
%     end
% end


xlabel(handles.axes_dAxesut,'time (ms)');
xlabel(handles.axes_dAxestk,'time (ms)');
xlabel(handles.axes_find1,'time (ms)');


%initialization for viewtab
%from viewspike20
%handles.vOnfilek=[];
%handles.vPlotoption=1;
handles.vDownsampleratio=2;
handles.vNumaxes=0;
handles.vNowaxes=0;
handles.vAxesposition0=[.06 .11 .93 .8];
handles.vAxesposition1=[.06 .36 .93 .55];
handles.vAxesposition2=[.06 .11 .93 .25];

handles.vFollowaxis0=[];
handles.vAxis0=[0 -Inf Inf -Inf];
%handles.vEndt=[];
handles.vAxesinfo=[];


%initialization for findtab
handles.find.xrange=[0 1];%xrange
handles.find.d=[];%data
handles.find.t=[];%time
handles.find.anal=[];%analyzed data
handles.find.delta=[];%threshold data
handles.find.hdeltaline=[]; %handle of delta line object
handles.find.method=[];
handles.find.info=[];
handles.find.spkk=[];
handles.find.hreddot=[]; %detected spikes
%handles.find.escmacro=0; %stop macro variable

set(handles.axes_find2,'XTickLabel',[]);
set(handles.checkbox_keepdelta,'Value',handles.keepdelta);

%cwt fields
set(handles.popupmenu_wavename, 'String', [{'haar'} {'db'} {'coif'} {'morl'}],'Value', 3);
set(handles.popupmenu_waveorder, 'String', [{'2'} {'3'} {'4'}],'Value',2);
set(handles.edit_wavescale,'String', '15');

%for delta sliderx
set(handles.slider_finddeltax,'Value',handles.deltax_sliderval,...
    'SliderStep',handles.deltax_sliderstep);

pos=get(handles.slider_finddeltax,'Position');
if(ispc)
    set(handles.slider_finddeltax,'Position', [0.02 pos(2) 0.965 pos(4)]);
elseif(ismac)
    set(handles.slider_finddeltax,'Position', [pos(1:2) 0.967 pos(4)]);
end


%reset threshold base
minthresholdbase=0.3;
maxthresholdbase=0.6;

if(handles.fresetthresholdbase>maxthresholdbase || handles.fresetthresholdbase<minthresholdbase)
    handles.fresetthresholdbase=0.45;
end
set(handles.edit_find_thresholdbase,'String', num2str(handles.fresetthresholdbase));
%set(handles.slider_find_thresholdbase,'Value',...
%    (handles.fresetthresholdbase-minthresholdbase)/(maxthresholdbase-minthresholdbase));


%=====initialization for decode panel
set(handles.popupmenu_encmethod, 'String',...
    {'ideal i&f',...%timeenc0
    'leaky i&f',... %timeenc1
    'quadratic i&f',...%timeenc4
    'refractory i&f',...%timeenc2
    'hohu w/ m-coupling',...%timeenc8
    'hohu 4d',...%timeenc9
    'Morris-Lecar',...%timeenc11
    'pif',... %timeenc3
    'pif0'});

set(handles.popupmenu_decmethod, 'String',...
    {'ideal i&f',...
    'ideal delta-insensitive',...
    'ideal stitching',...
    'ideal dilationTDM',...
    'ideal i&f - interpolation',...
    'ideal i&f - multipoint',...
    'leaky i&f',...
    'leaky delta-insensitive', ...
    'refractory i&f',... %timedec7
    'refractory i&f w/ interpolation',... %timedec8
    'hohu w/ m-coupling',...%timedec6
    'hohu 4d - floquet',...
    'hohu 4d - direct',...
    'Morris-Lecar',...
    'hohu 4d - fixed b',...
    'hohu 4d - known&condPRC',...
    'pif',...
    'population',...
    'reciprocal ISI',...
    'variational',...
    'syn_lpf',...
    'syn_exp',...
    'conj_grad',...
    'var_kernel',...
    'ideal i&f - uniform'});


handles.dec.xrange=[0 1];
handles.dec.taua=[];
handles.d_eta=[];

handles.dec.ut={};
handles.dec.t={};
handles.dec.G=[];
handles.dec.Ginv=[];
handles.dec.ck=[];
handles.dec.uhatt=[];
handles.dec.tk={};
handles.dec.tkindex=1;
handles.dec.tkinfo=[];
text_delta=[];
text_dC=[];
text_dR=[];
%handles.d_Ibase=[];%base current for hodgkin-huxley neurons

handles.dec.t_hat=[];
handles.dhfig_temani=0;
if(isempty(handles.genut))
    handles.genut.t0=0;
    handles.genut.f=10;
    handles.genut.K=5;
    handles.genut.b=0.2;
    handles.genut.c=1;
    handles.genut.npadding=4;
    handles.genut.fname='';
    handles.genut.sigma=0;
    handles.genut.UTk=[];
end
handles.d_axes1_legend=[]; %contains the string for the legend in axesut

update_genut_params(handles);

if(isempty(handles.temparams))
    handles.temparams.threshold=0.01;
    handles.temparams.R= 700000000;
    handles.temparams.C= .0000000001;
%    handles.temparams.Ibase=20;
end
handles=update_tem_params(handles,'updategui');%updategui
set(handles.edit_genut2,'String',handles.cmdstr);
set(handles.edit_tem_threshold,'String',num2str(handles.temparams.threshold*1000));

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes flyspikes wait for user response (see UIRESUME)
%uiwait(handles.figure1);





function handles=readallconfig(handles)
if(exist(handles.configfname,'file'))
    load(handles.configfname);
end
for k=1:length(handles.configvars)
    if(exist(handles.configvars{k},'var'))
        eval(['handles.' handles.configvars{k} '=' handles.configvars{k} ';']);
    else
        default_value=handles.configvars_default{k};
        if(isnumeric(default_value)&&~isempty(default_value))
            eval(['handles.' handles.configvars{k} '=[' num2str(default_value) '];']);
        elseif(isstr(default_value)&&~isempty(default_value))
            eval(['handles.' handles.configvars{k} '=''' default_value ''';']);
        else
            eval(['handles.' handles.configvars{k} '=[];']);
        end
    end
end



function val=readconfigvar(configfname, configvarname)
%read config variable from flyspikes_config.mat
val=[];
if(isempty(configvarname))
    return;
end

if(~exist(configfname,'file'))
    return;
end

if(~isempty(who('-file', configfname, configvarname)))
    load(configfname, configvarname);
    eval(['val=' configvarname ';']);
end




function done=writeconfigvar(configfname, configvarname, value)
%write config variable from 'configfname'
if(isempty(configvarname))
    return;
end

if(~exist(configfname,'file'))
    return;
end
eval([configvarname '=' value ';']);
save(configfname, '-append', configvarname);









function updatetab(handles)
%update activetab
if(handles.activetab==1)
    set(handles.pushbutton_findtab,'FontSize',15,'FontWeight','bold');
    set(handles.uipanel_findtab,'Visible','on');
else
    set(handles.pushbutton_findtab,'FontSize',7,'FontWeight','light');
    set(handles.uipanel_findtab,'Visible','off');
end

if(handles.activetab==2)
    set(handles.pushbutton_viewtab,'FontSize',15,'FontWeight','bold');
    set(handles.uipanel_viewtab,'Visible','on');
else
    set(handles.pushbutton_viewtab,'FontSize',7,'FontWeight','light');
    set(handles.uipanel_viewtab,'Visible','off');
end

if(handles.activetab==3)
    set(handles.pushbutton_decodetab,'FontSize',15,'FontWeight','bold');
    set(handles.uipanel_decodetab,'Visible','on');
else
    set(handles.pushbutton_decodetab,'FontSize',7,'FontWeight','light');
    set(handles.uipanel_decodetab,'Visible','off');
end




function handles=updatepwd(handles, newpath)
if(nargin<2)
    newpath=[];
end

if(~isempty(newpath))
    if(exist(newpath,'dir'))
        cd(newpath);
        set(handles.text_msg,'String',strcat('Current working folder: ',pwd));
    end
end

if(ispc)
    handles.nowpwd=strcat(pwd,'\');
else
    handles.nowpwd=strcat(pwd,'/');
end
set(handles.edit_pwd, 'String',handles.nowpwd);

if(strcmp(handles.nowpwd((end-1):end),'m/') || strcmp(handles.nowpwd((end-1):end),'m\'))
    handles.mfolder=handles.nowpwd;
elseif(exist([handles.nowpwd 'm'],'dir'))
    if(ispc())
        handles.mfolder=strcat(handles.nowpwd, 'm\');
    else
        handles.mfolder=strcat(handles.nowpwd, 'm/');
    end
elseif(strcmp(handles.nowpwd(max(1,(end-4)):end),'/doc/') || strcmp(handles.nowpwd(max(1,(end-4)):end),'\doc\'))
    if(ispc())
        handles.mfolder=strcat(handles.nowpwd(1:(end-4)), 'm\');
    else
        handles.mfolder=strcat(handles.nowpwd(1:(end-4)), 'm/');
    end
else
    handles.mfolder=[];
end

if(ispc())
    handles.docfolder=[handles.mfolder(1:(end-2)) 'doc\'];
else
    handles.docfolder=[handles.mfolder(1:(end-2)) 'doc/'];
end



handles=updateflist(handles);





function handles=updateflist(handles)
%update file list in the 'm' folder
if(isempty(handles.mfolder))
    files=dir('*.mat');
else
    files=dir(strcat(handles.mfolder,'*.mat'));
end

prevk=get(handles.popupmenu_flist,'Value');

if(isempty(files))
    handles.flist=[];
    set(handles.popupmenu_flist,'String', {'no .mat'});
else
    flist0={files.name};
    flist1={};
    flist2={};
    for i=1:length(flist0)
        if(strfind(flist0{i},'b.mat'))
            flist2{end+1}=flist0{i};
        else
            flist1{end+1}=flist0{i};
        end
    end
    handles.flist=[flist1 flist2];
    if(length(handles.flist)<prevk)
        set(handles.popupmenu_flist,'String', handles.flist, 'Value', 1);
    else
        set(handles.popupmenu_flist,'String', handles.flist, 'Value', prevk);
    end
end








% --- Outputs from this function are returned to the command line.
function varargout = flyspikes_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;
%delete(handles.figure1)





% --- Executes on button press in pushbutton_findtab.
function pushbutton_findtab_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_findtab (see GCBO)ma
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.activetab=1;
updatetab(handles);
guidata(hObject, handles);


% --- Executes on button press in pushbutton_viewtab.
function pushbutton_viewtab_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_viewtab (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.activetab=2;
updatetab(handles);
guidata(hObject, handles);

% --- Executes on button press in pushbutton_decodetab.
function pushbutton_decodetab_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_decodetab (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.activetab=3;
updatetab(handles);
guidata(hObject, handles);


% --- Executes on button press in pushbutton_pwd.
function pushbutton_pwd_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_pwd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
newpwd=uigetdir(handles.nowpwd);

if(newpwd~=0)
    handles=updatepwd(handles,newpwd);
    guidata(hObject, handles);
end



function edit_pwd_Callback(hObject, eventdata, handles)
% hObject    handle to edit_pwd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_pwd as text
%        str2double(get(hObject,'String')) returns contents of edit_pwd as a double
newpwd=get(hObject,'String');
handles=updatepwd(handles,newpwd);
guidata(hObject, handles);




% --- Executes on button press in pushbutton_viewinf.
function pushbutton_viewinf_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_viewinf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

viewinf(gcf);



% --- Executes on button press in pushbutton_help.
function pushbutton_help_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_help (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)






% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
%save the configuration file
for k=1:length(handles.configvars)
    if(isfield(handles, handles.configvars{k}))
        eval([handles.configvars{k} '= handles.' handles.configvars{k} ';']);
        save(handles.configfname, '-append', handles.configvars{k});
    end
end

disp(sprintf('configuration saved in %s',handles.configfname));

delete(hObject);
%uiresume();


% --- Executes on selection change in popupmenu_flist.
function popupmenu_flist_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_flist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_flist contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_flist


% --- Executes during object creation, after setting all properties.
function popupmenu_flist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_flist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_prevfile.
function pushbutton_prevfile_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_prevfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(get(handles.popupmenu_flist, 'Max') > 0)
    set(handles.popupmenu_flist, 'Value', max(1,get(handles.popupmenu_flist, 'Value')-1));
end


% --- Executes on button press in pushbutton_nextfile.
function pushbutton_nextfile_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_nextfile (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(length(get(handles.popupmenu_flist, 'String')) > get(handles.popupmenu_flist, 'Value'))
    set(handles.popupmenu_flist, 'Value', get(handles.popupmenu_flist, 'Value')+1);
end


%==================================
function out=inf2str(finfo)
noprintfields={'dt','t0','tend','con'};
out=[];
names=fieldnames(finfo);
for k=1:length(names)
    if(size(cell2mat(strfind(noprintfields,names{k}))))
        continue;
    end
    eval(strcat('val=finfo.',names{k},';'));
    if(~isempty(val) )
        if(isnumeric(val) && length(val)<10)
            val=num2str(val);
        end
        if(ischar(val) && length(val)<40)
            out=strcat(out, names{k}, '=',val,',');
        end
    end
end


%================================
function updatefindaxesxrange(handles)
nowaxis=axis(handles.axes_find1);
axis(handles.axes_find1, [handles.find.xrange nowaxis(3:4)]);

nowaxis=axis(handles.axes_find2);
axis(handles.axes_find2, [handles.find.xrange nowaxis(3:4)]);








% --- Executes on button press in pushbutton_load1.
function pushbutton_load1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_load1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

filek=get(handles.popupmenu_flist,'Value');
fname0=strcat(handles.mfolder, handles.flist{filek});
if(~exist(fname0,'file'))
    set(handles.text_msg,strcat(handles.flist{filek}, ' not found'));
    set(handles.text_axesinfo,'String',strcat(handles.flist{filek}, ' not found'));
    return;
end

warning off
load(fname0,'d');
warning on
if(~exist('d'))
    set(handles.text_msg,'String','not a valid data file');
end
    
switch(handles.activetab)
    case 1
        %for find tab
        load(fname0);
        finfo=[];
        for k=1:length(handles.axesinfoid)
            if(eval(strcat('exist(''',handles.axesinfoid{k},''')')))
                eval(strcat('finfo.',handles.axesinfoid{k},'=',handles.axesinfoid{k},';'));
            end
        end

        % %initialization for findtab
        % handles.find.xrange=[];%xrange
        % handles.find.d=[];%data
        % handles.find.t=[];%time
        % handles.find.anal=[];%analyzed data
        % handles.find.delta=[];%threshold data

        if(~isempty(d))
            if(handles.fInvertD)
                handles.find.d=-d;
            else
                handles.find.d=d;
            end
            handles.find.celltype=celltype;
            handles.find.t=((1:length(d))-1)*dt;%dt in msec
            handles.find.method=[];
            handles.find.info=finfo;
            handles.find.spkk=[];
            handles.find.hreddot=[];
            set(handles.text_fInfo,'String',inf2str(finfo));
            cla(handles.axes_find1);cla(handles.axes_find2);

            %plot the main one
            axes(handles.axes_find1);
            hline5=line(handles.find.t, handles.find.d,'Color','b');
            set(hline5,'ButtonDownFcn',@(hObject,eventdata)flyspikes('axes_find1_AddSpike',hObject,eventdata,guidata(hObject)));

            dt=handles.find.t(2)-handles.find.t(1);

            if(exist('spkk'))
                if(~isempty(spkk))
                    handles.find.spkk=spkk(1:find(spkk<length(d),1,'last'));
                    reddot=handles.find.d(handles.find.spkk);
                    handles.find.hreddot=line(handles.find.spkk*dt, ...
                        reddot,'Color','r','Marker','o','LineStyle','none');
                    set(handles.find.hreddot,'ButtonDownFcn',@(hObject,eventdata)flyspikes('axes_find1_RemoveSpike',hObject,eventdata,guidata(hObject)));
                    handles.find.info.nspks=length(handles.find.spkk);
                end
            end
            axis tight;

            %             if(~get(handles.checkbox_keepdelta,'Value') | isempty(handles.find.hdeltaline))
            %                 handles.find.delta=[];
            %                 if(ishandle(handles.find.hdeltaline))
            %                     delete(handles.find.hdeltaline);
            %                 end
            %                 if(exist('delta','var'))
            %                     if(~isempty(delta))
            %                         handles.find.delta=delta;
            %                     end
            %                 end
            %             end

            %             if(get(handles.checkbox_keepdelta,'Value'))
            %                 %if keepdelta checked
            %                 handles=plotthreshold(handles);
            %             else
            %                 handles.find.delta=[];
            %                 %handles.find.hdeltaline=[];
            %                 handles=plotthreshold(handles);
            %             end
            %

            handles.find.xrange=[0 handles.find.t(end)];
            updatefindaxesxrange(handles);

        end

        if(~get(handles.checkbox_keepdelta,'Value') || isempty(handles.find.delta))
            %keepdelta==0
            if(exist('delta'))
                handles.find.delta=delta;
            else
                handles.find.delta=[];
            end
        else
            %keepdelta==1
            if(isempty(handles.find.delta)&& exist('delta'))
                handles.find.delta=delta;
            end
        end
        handles=plotthreshold(handles);


    case 2
        %from viewspike20
        if(handles.vNumaxes==0)
            handles=vAddaxes(handles);
        end
        flist7=get(handles.popupmenu_flist,'String');
        handles=vPlot1(handles, flist7{filek});

    case 3
        load(fname0);
        if(~exist('spkk','var'))
            set(handles.text_msg,'String',strcat(handles.flist{filek}, ' - no spike train found'));
            return;
        end
        if(~exist('dt','var'))
            dt=0.1;%use default value
        end
        if(~exist('t0','var'))
            t0=0;%use default value
        end

        if(exist('spkk','var'))
            if(~isempty(spkk))
                spkt=spkk*dt/1000+t0;
                handles.dec.tkindex=length(handles.dec.tkinfo)+1;
                handles.dec.tkinfo{handles.dec.tkindex}=handles.flist{filek};
                handles.dec.tk{handles.dec.tkindex}=spkt;
                handles=d_update_axestk(handles);
            end
        end

        if(exist('c','var'))
            if(~isempty(c))
                handles.dec.ut{1}=c;
                handles.dec.t{1}=(((1:length(c))-1)*dt+t0)/1000;
                handles.dec.ut=handles.dec.ut(1);
                handles.dec.t=handles.dec.t(1);
                handles=update_dec_ut(handles);
                set(handles.text_dec1info,'String',strcat('odor concentration - ',handles.flist{filek}));
            end
        end

end
guidata(hObject,handles);






function handles=plotthreshold(handles,fromslider)
if(nargin<2) fromslider=0;end

%exception control for delta
if(isempty(handles.find.delta))
    if(~isempty(handles.find.hdeltaline))
        if(ishandle(handles.find.hdeltaline))
            delete handles.find.hdeltaline;
            handles.find.hdeltaline=[];
            return;
        end
    end
    return;
elseif(length(handles.find.t)>length(handles.find.delta))
    handles.find.delta((end+1):length(handles.find.t))=handles.find.delta(end);
elseif(length(handles.find.t)<length(handles.find.delta))
    handles.find.delta=handles.find.delta(1:length(handles.find.t));
end

%delta is not empty
axes(handles.axes_find2);
if(ishandle(handles.find.hdeltaline))
    set(handles.find.hdeltaline,'XData',handles.find.t, 'YData',handles.find.delta);
else
    handles.find.hdeltaline=line(handles.find.t, handles.find.delta,'Color','r');
end
axis auto;
nowaxis=axis(handles.axes_find2);
axis(handles.axes_find2, [handles.find.xrange nowaxis(3:4)]);

if(~fromslider)
    set(handles.slider_finddeltay,'Value',(mean(handles.find.delta)-nowaxis(3))/diff(nowaxis(3:4)));
end




% --- Executes on button press in pushbutton_zoomall.
function pushbutton_zoomall_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_zoomall (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch(handles.activetab)
    case 1 %findtab
        handles.find.xrange=[0 handles.find.t(end)];
        updatefindaxesxrange(handles);

    case 2 %viewtab
        if(handles.vNowaxes>0)
            nowaxis=axis(handles.vHaxes(handles.vNowaxes));
            nowaxis(1)=handles.vAxesinfo(handles.vNowaxes).t0;
            nowaxis(2)=handles.vAxesinfo(handles.vNowaxes).tend;%handles.vEndt(handles.vNowaxes);
            axis(handles.vHaxes(handles.vNowaxes),nowaxis);
            if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                nowaxis2=axis(handles.vAxesinfo(handles.vNowaxes).hCaxes);
                axis(handles.vAxesinfo(handles.vNowaxes).hCaxes, [nowaxis(1:2) nowaxis2(3:4)]);
            end
        else
            set(handles.text_msg, 'String', 'no axes to zoom');
        end

    case 3 %decodetab
        handles.dec.xrange=[-inf inf];
        handles.dec.xrange=update_dec_xrange(handles);
end
guidata(hObject, handles);


% --- Executes on button press in pushbutton_zoomspks.
function pushbutton_zoomspks_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_zoomspks (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch(handles.activetab)
    case 1 %findtab
        if(isempty(handles.find.spkk))
            set(handles.text_msg,'String','no spikes exist');
            return;
        end

        handles.find.xrange=[handles.find.t(handles.find.spkk(1)) handles.find.t(handles.find.spkk(end))];
        updatefindaxesxrange(handles);

    case 2 %viewtab
        if(handles.vNowaxes>0)
            spkt=handles.vAxesinfo(handles.vNowaxes).spkk*handles.vAxesinfo(handles.vNowaxes).dt+handles.vAxesinfo(handles.vNowaxes).t0;
            tmargin=0.01*(handles.vAxesinfo(handles.vNowaxes).tend-handles.vAxesinfo(handles.vNowaxes).t0);
            if(isempty(spkt))
                set(handles.text_msg,'String', 'zoomspks: no spike found');
                return;
            elseif(length(spkt)==1)
                startx=spkt(1)-tmargin;
                endx=spkt(1)+tmargin;
            else
                startx=spkt(1)-tmargin;
                endx=spkt(end)+tmargin;
            end

            nowaxis=axis(handles.vHaxes(handles.vNowaxes));
            nowaxis(1)=max(startx,0);
            nowaxis(2)=min(endx,handles.vAxesinfo(handles.vNowaxes).tend);
            axis(handles.vHaxes(handles.vNowaxes),nowaxis);
            if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                nowaxis2=axis(handles.vAxesinfo(handles.vNowaxes).hCaxes);
                axis(handles.vAxesinfo(handles.vNowaxes).hCaxes, [nowaxis(1:2) nowaxis2(3:4)]);
            end

        else
            set(handles.text_msg, 'String', 'no axes to zoom');
        end

    case 3 %decodetab
end

guidata(hObject,handles);






% --- Executes on button press in pushbutton_zoomrange.
function pushbutton_zoomrange_Callback(hObject, eventdata, handles, noverbose, xrange)
% hObject    handle to pushbutton_zoomrange (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch(handles.activetab)
    case 1 %findtab
        defAns{1}=num2str(handles.fZoomrange(1));
        defAns{2}=num2str(handles.fZoomrange(2));
    case 2 %viewtab
        defAns{1}=num2str(handles.vZoomrange0);
        defAns{2}=num2str(handles.vZoomrange1);
        defAns{3}=num2str(handles.vAxis0(3));
        defAns{4}=num2str(handles.vAxis0(4));

    case 3 %decodetab
        defAns{1}=num2str(handles.dZoomrange(1)/1000);
        defAns{2}=num2str(handles.dZoomrange(2)/1000);
end

if(nargin<4) noverbose=''; xrange=[]; end

if(~strcmp(noverbose,'noverbose'))
    if(handles.activetab==2)
        %view tab
        cellxrange = inputdlg({'start_x[sec]','end_x[sec]','miny','maxy'}, 'Align plots', [1 1 1 1]', defAns);
        if(size(cellxrange,1)==0) return; end; %if 'cancel' button clicked
        
        if(length(cellxrange) ==4)
            handles.vAxis0(3)=str2num(cell2mat(cellxrange(3)));
            handles.vAxis0(4)=str2num(cell2mat(cellxrange(4)));
        end
    else
        cellxrange = inputdlg({'start_x[sec]','end_x[sec]'}, 'Align plots', [1 1]', defAns);
        if(size(cellxrange,1)==0) return; end; %if 'cancel' button clicked
    end
    
    if(length(cellxrange) >=2)
        startx=str2num(cell2mat(cellxrange(1)));
        endx=str2num(cell2mat(cellxrange(2)));
    else
        warndlg('invalid inputs: type a number in each field');
        return;
    end;
    
else
    startx=xrange(1);endx=xrange(2);
end
if(isempty(startx) || isempty(endx))
    warndlg('invalid inputs: type a number in each field');
    return;
end;

if(startx>endx)
    warndlg('invalid inputs: start_x >= end_x?')
    return;
end;

switch(handles.activetab)
    case 1 %findtab
        handles.fZoomrange=[startx endx];
        handles.find.xrange=[startx endx]*1000;
        updatefindaxesxrange(handles);
    case 2 %viewtab
        if(handles.vNowaxes>0)
            handles.vZoomrange0=startx;
            handles.vZoomrange1=endx;
            handles.vAxis0(1:2)=[startx*1000 endx*1000];
            handles.vFollowaxis0(:)=1;
            handles=vSwitchaxes2(handles, handles.vNowaxes);
        else
            set(handles.text_msg, 'String', 'no axes to zoom');
        end

    case 3 %decodetab
        handles.dec.xrange=[startx endx]*1000;
        handles.dec.xrange=update_dec_xrange(handles);
        handles.dZoomrange=handles.dec.xrange;
end

guidata(hObject, handles);




% --- Executes on button press in pushbutton_zoomin.
function pushbutton_zoomin_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_zoomin (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

switch(handles.activetab)
    case 1 %findtab
        handles.find.xrange(2)=diff(handles.find.xrange)/1.6+handles.find.xrange(1);
        updatefindaxesxrange(handles);

    case 2 %viewtab
        if(handles.vNowaxes>0)
            nowaxis = axis(handles.vHaxes(handles.vNowaxes));
            nowaxis(2)=nowaxis(2)*3/5+nowaxis(1)*2/5;
            axis(handles.vHaxes(handles.vNowaxes), nowaxis);
            if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                nowaxis2=axis(handles.vAxesinfo(handles.vNowaxes).hCaxes);
                axis(handles.vAxesinfo(handles.vNowaxes).hCaxes, [nowaxis(1:2) nowaxis2(3:4)]);
            end
            handles.vFollowaxis0(handles.vNowaxes)=0;%set not to follow the axis0
            set(handles.text_msg, 'String', sprintf('axes#%d zoomed in', handles.vNowaxes));
        else
            set(handles.text_msg, 'String', 'no axes to zoom in');
        end
    case 3 %decodetab
        handles.dec.xrange(2)=diff(handles.dec.xrange)/1.6+handles.dec.xrange(1);
        handles.dec.xrange=update_dec_xrange(handles);
end
guidata(hObject, handles);




% --- Executes on button press in pushbutton_zoomout.
function pushbutton_zoomout_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_zoomout (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch(handles.activetab)
    case 1 %findtab
        handles.find.xrange(2)=min(handles.find.t(end),...
            diff(handles.find.xrange)*1.6+handles.find.xrange(1));
        updatefindaxesxrange(handles);
    case 2 %viewtab
        if(handles.vNowaxes>0)
            nowaxis = axis(handles.vHaxes(handles.vNowaxes));
            if(nowaxis(2)<handles.vAxesinfo(handles.vNowaxes).tend)
                nowaxis(2)=min(nowaxis(2)*1.8-nowaxis(1)*.8,handles.vAxesinfo(handles.vNowaxes).tend);
                axis(handles.vHaxes(handles.vNowaxes),nowaxis);
                if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                    nowaxis2=axis(handles.vAxesinfo(handles.vNowaxes).hCaxes);
                    axis(handles.vAxesinfo(handles.vNowaxes).hCaxes, [nowaxis(1:2) nowaxis2(3:4)]);
                end

                handles.vFollowaxis0(handles.vNowaxes)=0;%set not to follow the axis0
                set(handles.text_msg, 'String', sprintf('axes#%d zoomed out', handles.vNowaxes));
            elseif(nowaxis(1)>handles.vAxesinfo(handles.vNowaxes).t0)
                nowaxis(1)=max(nowaxis(1)*0.2-nowaxis(2)*.8,handles.vAxesinfo(handles.vNowaxes).t0);
                axis(handles.vHaxes(handles.vNowaxes),nowaxis);
                if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                    nowaxis2=axis(handles.vAxesinfo(handles.vNowaxes).hCaxes);
                    axis(handles.vAxesinfo(handles.vNowaxes).hCaxes, [nowaxis(1:2) nowaxis2(3:4)]);
                end

                handles.vFollowaxis0(handles.vNowaxes)=0;%set not to follow the axis0
                set(handles.text_msg, 'String', sprintf('axes#%d zoomed out', handles.vNowaxes));
            else
                set(handles.text_msg, 'String', sprintf('axes#%d fully zoomed out', handles.vNowaxes));
            end
        else
            set(handles.text_msg, 'String', 'no axes to zoom out');
        end

    case 3 %decodetab
        handles.dec.xrange(2)=diff(handles.dec.xrange)*1.6+handles.dec.xrange(1);
        handles.dec.xrange=update_dec_xrange(handles);
end
guidata(hObject, handles);







%from viewspike20
% --- Executes on button press in pushbutton_spikeplot.
function pushbutton_spikeplot_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_spikeplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%validk=1:handles.vNumaxes;

%check whether same files exist
% if(length(validk)>2)
%    for k=length(validk):-1:2
%       for kk=1:(k-1)
%          if(strcmp(handles.vAxesinfo(validk(k)).fname,handles.vAxesinfo(validk(kk)).fname))
%             validk=validk([1:(k-1) (k+1):end]);
%             break;
%          end
%       end
%    end
% end

validk=[];
for k=1:handles.vNumaxes
    if(~isempty(handles.vAxesinfo(k).d))
        validk=[validk k];
    end
end

if(isempty(validk))
    set(handles.text_msg, 'String','no axes with data');
    return;
end


outmsg=spikeplots(handles.vAxesinfo, handles.vHaxes, validk);
if(~isempty(outmsg) && ischar(outmsg))
    set(handles.text_msg, 'String', outmsg);
end



% --- Executes on button press in pushbutton_vsorttk.
function pushbutton_vsorttk_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vsorttk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(handles.vNumaxes==0)
    set(handles.text_msg,'String','no axes found');
    return;
end

% answer=inputdlg({'number of spike types','start time[sec]','end time[sec]', 'axes'},...
%     'spike sorting params',1,{num2str(handles.nSpikeTypes),num2str(handles.vZoomrange0),...
%     num2str(handles.vZoomrange1), num2str(handles.vNowaxes)});

% answer=spikesort({'#types :','axes# :','start [s] :', 'end [s] :'},{num2str(handles.nSpikeTypes),num2str(handles.vNowaxes),...
%     num2str(handles.vZoomrange0), num2str(handles.vZoomrange1)},handles.figure1);
answer=spikesort({'#types :','axes# :','start [s] :', 'end [s] :'},{num2str(handles.nSpikeTypes),['1:' num2str(handles.vNumaxes)],...
    num2str(handles.vZoomrange0), num2str(handles.vZoomrange1)},handles.figure1);

if(isempty(answer{1}))
    set(handles.text_msg,'String','set sorting params : escaped');
    return;
end
handles=guidata(handles.figure1);%handle structure could be updated in spikesort gui


msg=[];
nSpikeTypes=str2double(answer{1});
axesk=str2num((answer{2}));
startt=str2double(answer{3});
endt=str2double(answer{4});
if(~isempty(nSpikeTypes))
    if(nSpikeTypes>0)
        handles.nSpikeTypes=round(nSpikeTypes);
    else
        set(handles.text_msg,'String','number of spike types must be positive...');
        return;
    end
end


if(~isempty(startt))
    if(startt<0)
        startt=0;
    end
else
    return;
end






%analysis range for each spike
beforet=handles.sortleftwin;%msec
aftert=handles.sortrightwin;%msec





if(~isempty(endt))
    if(endt<startt)
        set(handles.text_msg,'String','time inteval must be typed as two increasing numbers');
        return
    end
else
    return;
end


if(isempty(axesk))
    axesk=1:handles.vNumaxes;
else
    axesk=axesk(axesk>0 & axesk <=handles.vNumaxes);
    if(isempty(axesk))
        axesk=1:handles.vNumaxes;
    end
end
handles.vZoomrange0=startt;
handles.vZoomrange1=endt;


guidata(hObject,handles);

feature5=[];
feature5k=[];
%feature5=cell(handles.vNumaxes,1);


%read all the spikes and extract their feature values
%bAmplitudeIndependent=true;
numaxes_original=handles.vNowaxes;
for ii=axesk
    if(isempty(handles.vAxesinfo(ii).spkk))
        set(handles.text_msg,'String','no detected spike found');
        continue;
    end
    
    

    handles.vFollowaxis0(:)=1;
    handles.vAxis0=[startt*1000 endt*1000 handles.vAxis0(3:4)];
    handles=vSwitchaxes2(handles, ii);
    set(handles.text_msg,'String',['scanning axes#' num2str(ii) '/' num2str(handles.vNumaxes) ' - ' handles.vAxesinfo(ii).fname '.mat']);
    drawnow;
    
    
    dt=handles.vAxesinfo(ii).dt;
    

    set(handles.text_msg,'String','hold on... detecting features for spike sorting');

    %t=((1:length(handles.vAxesinfo(ii).d))-1).*dt+handles.vAxesinfo(ii).t0;
    startk=max(1,round((startt+beforet/1000-handles.vAxesinfo(ii).t0)*1000/dt));
    endk=min(length(handles.vAxesinfo(ii).d), round((endt-aftert/1000-handles.vAxesinfo(ii).t0)*1000/dt));
    leftspkk{ii}=handles.vAxesinfo(ii).spkk(handles.vAxesinfo(ii).spkk<startk);
    spkk{ii}=handles.vAxesinfo(ii).spkk(handles.vAxesinfo(ii).spkk>=startk & handles.vAxesinfo(ii).spkk<=endk);
    rightspkk{ii}=handles.vAxesinfo(ii).spkk(handles.vAxesinfo(ii).spkk>endk);
    if(isempty(spkk{ii}))
        continue;
    end

%     cwtdata=cwt(handles.vAxesinfo(ii).d(startk:endk), [15 50 150], 'coif3');
%     cwtdata=cwtdata./((max(cwtdata')-min(cwtdata'))'*ones(1,size(cwtdata,2)));%normalize
% 
%     cwtdata1=cwtdata(:,spkk{ii}-startk+1);
    % figure;plot3(data(1,:),data(2,:),data(3,:),'LineStyle','none','Marker','o','MarkerFaceColor','b');
    % xlabel('scale 15');ylabel('scale 50'); zlabel('scale 140');

    meanii=mean(handles.vAxesinfo(ii).d(startk:endk));

    feature=zeros(3,length(spkk{ii}));
    for i=1:length(spkk{ii})
        feature(1,i)=handles.vAxesinfo(ii).d(spkk{ii}(i))-meanii;%the peak amplitude;
        
        before=handles.vAxesinfo(ii).d((max(1,spkk{ii}(i)-round(beforet/dt)):spkk{ii}(i)));
        after=handles.vAxesinfo(ii).d((spkk{ii}(i)+1):min(length(handles.vAxesinfo(ii).d),spkk{ii}(i)+round(aftert/dt)));
        [a ix1]=min(before);
        [b ix2]=min(after);
%        feature(1,i)=handles.vAxesinfo(ii).d(spkk{ii}(i))-min(before);
        feature(2,i)=handles.vAxesinfo(ii).d(spkk{ii}(i))-a;
        feature(3,i)=handles.vAxesinfo(ii).d(spkk{ii}(i))-b;

        feature(4,i)=ix1;
        feature(5,i)=ix2;
        
%         feature(6,i)=handles.vAxesinfo(ii).d(spkk{ii}(i))-min([before; after]);%peak-min(all)
        feature(6,i)=min(before)-min(after);
        %feature(7,i)=mean(after);
        %         m0=mean([before; after]);
        %         feature(7,i)=(handles.vAxesinfo(ii).d(spkk{ii}(i))-m0)./(m0-min(before));
        
        
        before2=before(1:round(length(before)/2));
        before1=before((round(length(before)/2)+1):end);
        after1=after(1:round(length(after)/2));
        after2=after((round(length(after)/2)+1):end);
        
%         feature(7,i)=max(before2)-a;
%         feature(8,i)=max(after2)-b;
%         
        feature(7,i)=mean(before2)-mean(before1);
        feature(8,i)=mean(after1)-mean(after2);
        
        feature(9,i)=handles.vAxesinfo(ii).d(spkk{ii}(i))-mean([before; after]);
        feature(10,i)=var([before; after]);
        
    end
    

    % figure;plot3(feature(1,:),feature(2,:),feature(3,:),'LineStyle','none','Marker','o','MarkerFaceColor','b');
    % xlabel('p2p_before');ylabel('p2p_after'); zlabel('spike width');

%     feature2=[feature; cwtdata1];
%     feature5=[feature5 feature2];
%    feature5k=[feature5k ii*ones(1,size(feature2,2))];
    feature5=[feature5 feature];
    feature5k=[feature5k ii*ones(1,size(feature,2))];
end

feature0=feature5;%back up

%equalizer0=ones(1,size(feature5,2));%each feature is normalized by its maximum and minimum
%equalizer0(5)=inf;
%equalizer0(6)=inf;
warning off;
weight5=(handles.sorteq'./(max(feature5')-min(feature5'))');
feature5=feature5.*repmat(weight5,1,size(feature5,2));%normalize
warning on;
    

coeffs=princomp(feature5');
feature_pca=coeffs*feature5;


handles=vSwitchaxes2(handles, numaxes_original);





nTypes=handles.nSpikeTypes;
spktag=ones(1,size(feature5,2)); %tag (1: non-determined, 0: accepted, -1: rejected);
spkkindex=1:size(feature5,2);
while(1)
    if(sum(spktag>0)<nTypes)
        nTypes=ceil(sum(spktag>0)/2);
    end
%     if(length(spkkindex)<nTypes)
%         nTypes=ceil(length(spkkindex)/2);
%     end

    set(handles.text_msg,'String',['running kmeans clustering algorithm for ' num2str(sum(spktag>0)) 'spikes']);
%     set(handles.text_msg,'String',['running kmeans clustering algorithm for ' num2str(length(spkkindex)) 'spikes']);
    drawnow;
%     [IDX,C,sumd,D]=kmeans(feature5(:,spkkindex)', nTypes);
%     IDX=spkkindex(IDX);
    [IDX,C,sumd,D]=kmeans(feature5(:,spktag>0)', nTypes);
    spktag(spktag>0)=IDX;
%     IDX=spkkindex(IDX);
    idx={};%max_amplitude=[];mean_p2p=[];
    orderfeature=[];
%     for i=1:max(IDX)
%         tempidx=(find(IDX==i));
%         if(~isempty(tempidx))
%             idx{end+1}=spkkindex(tempidx);
% %             if(~bAmplitudeIndependent)
% %                 max_amplitude(end+1)=max(feature0(10,idx{end}));
% %             end
% %             mean_p2p(end+1)=mean(feature0(2,idx{end}));
%             orderfeature(end+1)=max(feature0(handles.sortbasisk,idx{end}));
%             IDX(tempidx)=length(idx);
%         end
%     end

    for i=1:max(spktag)
        tempidx=(find(spktag==i));
        if(~isempty(tempidx))
%             idx{end+1}=spkkindex(tempidx);
%             orderfeature(end+1)=max(feature0(handles.sortbasisk,idx{end}));
            orderfeature(end+1)=max(feature0(handles.sortbasisk,tempidx));
            spktag(tempidx)=length(orderfeature); % in case a cluster is empty
        end
    end

%     if(bAmplitudeIndependent)
%         [temp axesorder]=sort(mean_p2p,'ascend');
%     else
%         [temp axesorder]=sort(max_amplitude,'ascend');
%     end
         [temp axesorder]=sort(orderfeature,'ascend');

         for i=1:length(axesorder)
             spktag(spktag==axesorder(i))=nTypes+i;
         end
         spktag(spktag>0)=spktag(spktag>0)-nTypes;

%     idx2={};
%     for i=1:length(axesorder)
%         idx2{i}=idx{axesorder(i)};
%         IDX(IDX==axesorder(i))=i+length(idx);
%     end
%     IDX=IDX-length(idx);

    % cm=colormap(lines(handles.nSpikeTypes));
    % figure(425);clf;
    % for i=1:handles.nSpikeTypes
    %     plot3(feature_pca(1,idx2{i}),feature_pca(2,idx2{i}),feature_pca(3,idx2{i}),'Marker','o','LineStyle','none','MarkerEdgeColor',cm(i,:),'MarkerFaceColor',cm(i,:));hold on;
    %     legendstr{i}=strcat('type#',num2str(i));
    % end
    % xlabel('pc1');ylabel('pc2'); zlabel('pc3');
    % legend(legendstr);

    cm=colormap(hsv(length(axesk)));
    figure(426);clf;
    for i=1:nTypes
        haxes(i)=subplot(ceil((nTypes+2)/13),min(13,(nTypes+2)),i);
%         title(strcat('#',num2str(i),' : ',num2str(length(idx2{i})),' spk'));
title(strcat('#',num2str(i),' : ',num2str(sum(spktag==i)),' spk'));
        hold on;
    end
    %discarded ones
    i=i+1;
    haxes(i)=subplot(ceil((nTypes+2)/13),min(13,(nTypes+2)),i);
    title(['#',num2str(i),'(purged) :',num2str(sum(spktag==-1)),' spk']);
    hold on;
        %
    %accepted ones
    i=i+1;
    haxes(i)=subplot(ceil((nTypes+2)/13),min(13,(nTypes+2)),i);
    title(['#',num2str(i),'(accepted) :',num2str(sum(spktag==0)),' spk']);
    hold on;

    
%     for i=1:length(spkkindex)
     for i=1:length(spktag)
%         grpk=feature5k(spkkindex(i));
%         grpspkk=spkkindex(i)-sum(feature5k<grpk);
        grpk=feature5k(i);
        grpspkk=i-sum(feature5k<grpk);
        
        dt=handles.vAxesinfo(grpk).dt;
%         if(IDX(i)>0)
        tempd=handles.vAxesinfo(grpk).d((max(1,spkk{grpk}(grpspkk)-round(beforet/dt)):(spkk{grpk}(grpspkk)+round(aftert/dt))));
        if(spktag(i)>0)
%               plot(haxes((IDX(i))), dt*((max(1,spkk{grpk}(grpspkk)-round(beforet/dt)):min(length(handles.vAxesinfo(grpk).d),...
            plot(haxes((spktag(i))), dt*((max(1,spkk{grpk}(grpspkk)-round(beforet/dt)):min(length(handles.vAxesinfo(grpk).d),...
                spkk{grpk}(grpspkk)+round(aftert/dt))))-spkk{grpk}(grpspkk)*dt,...
                tempd-mean(tempd),'Color',cm(find(axesk==grpk),:));
                %tempd-mean(tempd),'Color',cm(find(axesk==grpk),:));...
                hold on;
        elseif(spktag(i)==-1)
            plot(haxes(nTypes+1), dt*((max(1,spkk{grpk}(grpspkk)-round(beforet/dt)):min(length(handles.vAxesinfo(grpk).d),...
                spkk{grpk}(grpspkk)+round(aftert/dt))))-spkk{grpk}(grpspkk)*dt,...
                tempd-mean(tempd),'Color',[1 1 1]*.4);
                %tempd-mean(tempd),'Color',cm(find(axesk==grpk),:));...
                hold on;
        else
            plot(haxes(nTypes+2), dt*((max(1,spkk{grpk}(grpspkk)-round(beforet/dt)):min(length(handles.vAxesinfo(grpk).d),...
                spkk{grpk}(grpspkk)+round(aftert/dt))))-spkk{grpk}(grpspkk)*dt,...
                tempd-mean(tempd),'Color',cm(find(axesk==grpk),:));
                %tempd-mean(tempd),'Color',cm(find(axesk==grpk),:));...
                hold on;
        end
%         drawnow;
    end


    for i=1:(nTypes+2)
        axis(haxes(i),'tight');
        nowaxis(i,:)=axis(haxes(i));
    end

    newaxis=[-beforet aftert min(nowaxis(:,3)) max(nowaxis(:,4))];
    for i=1:(nTypes+2)
        axis(haxes(i),newaxis);
    end



%     answer=inputdlg({'finish with 0 if done', '# spike types'},...
%         'choose spike types',1,{['   ',num2str(0)], ['   ',num2str(handles.nSpikeTypes)]});
    
    guidata(handles.figure1,handles);
    answer=spikesort({'valid spike type#','# types'},{'0',num2str(nTypes)},handles.figure1);
    handles=guidata(handles.figure1);
    
    if(isempty(answer))
         spktag(spktag<0)=0;%when cancelled
        break;
    end
    if(isempty(answer{1}))
        spktag(spktag<0)=0
        break;
    end
    




    typeidx=str2num(answer{1});
    typidx=typeidx(typeidx<=nTypes);
    if(isempty(typeidx))
        set(handles.text_msg,'String','input invalid');
        return;
    elseif(typeidx(1)==0)
        %if the first is zero, quit the loop
        break;
    elseif(sum(typeidx<0)>0)
        %if there is any negative typeidx, remove them from type idx
        ntypeidx=typeidx(typeidx<0);
        for j=1:length(ntypeidx)
            spktag(spktag==-ntypeidx(j))=-1;
        end
        
        ptypeidx=typeidx(typeidx>0);
        for j=1:length(ptypeidx)
            spktag(spktag==ptypeidx(j))=0;
        end
        
        ctypeidx=ones(1,length(idx));
        ctypeidx(-ntypeidx)=0;
        typeidx=find(ctypeidx==1);
    else
        %if there is neither zero nor negative integers,
        typeidx=typeidx(typeidx>0);
        typeidx=sort(typeidx,'ascend');
        if(length(typeidx)==nTypes)
            if(sum(abs(typeidx-(1:nTypes)))==0)
                %if all are selected, do not move it to "accepted" category
                continue;
            end
        end
        for j=1:length(typeidx)
            spktag(spktag==typeidx(j))=0;
        end
    end

    
    
    if(~isempty(answer{2}))
        nspiketypes=str2num(answer{2});
    else
        nspiketypes=nTypes;
    end
    if(nspiketypes>1)
        nTypes=nspiketypes;
    end
% 
%     %using the distance D
%     nitems=0;
%     spkkindex0=[];
%     for j=1:length(typeidx)
%         spkkindex0=[spkkindex0 idx2{typeidx(j)}];
%     end
%     spkkindex=sort(spkkindex0);

    %update the current axes
%     spkkindex1=spkkindex;
    spkkindex1=find(spktag>=0);
    if(length(spkk)>=handles.vNowaxes)
        if(~isempty(spkk{handles.vNowaxes}))
            firstk=find(feature5k==handles.vNowaxes,1,'first');
            lastk=find(feature5k==handles.vNowaxes,1,'last');
            nowk=spkkindex1(spkkindex1>=firstk & spkkindex1<=lastk)-firstk+1;
            spkk7=[leftspkk{handles.vNowaxes} spkk{handles.vNowaxes}(nowk) rightspkk{handles.vNowaxes}];
            if(isfield(handles.vAxesinfo(handles.vNowaxes),'hreddot'))
                if(ishandle(handles.vAxesinfo(handles.vNowaxes).hreddot))
                    set(handles.vAxesinfo(handles.vNowaxes).hreddot, 'XData', spkk7*handles.vAxesinfo(handles.vNowaxes).dt-handles.vAxesinfo(handles.vNowaxes).t0,...
                        'YData', handles.vAxesinfo(handles.vNowaxes).d(spkk7));
                    drawnow;
                end
            end
            
        end
    end
    
    %finish the loop if last number is 0
    temp=str2num(answer{1});
    if(temp(end)==0)
        break;
    end
end



% spkkindex1=spkkindex;
spkkindex1=find(spktag>=0);
for i=axesk(1:min(end,length(spkk)))
    if(~isempty(spkk{i}))
        firstk=find(feature5k==i,1,'first');
        lastk=find(feature5k==i,1,'last');
        nowk=spkkindex1(spkkindex1>=firstk & spkkindex1<=lastk)-firstk+1;
        if(isempty(nowk))
            spkk{i}=[];
        else
            spkk{i}=spkk{i}(nowk);
        end
        handles.vAxesinfo(i).spkk=[leftspkk{i} spkk{i} rightspkk{i}];
        if(isfield(handles.vAxesinfo(i),'hreddot'))
            if(ishandle(handles.vAxesinfo(i).hreddot))
                set(handles.vAxesinfo(i).hreddot, 'XData', handles.vAxesinfo(i).spkk*handles.vAxesinfo(i).dt-handles.vAxesinfo(i).t0,...
                    'YData', handles.vAxesinfo(i).d(handles.vAxesinfo(i).spkk));
            end
        end

    end
end
    

guidata(hObject, handles);

% set(handles.text_msg, 'String', strcat(num2str(length(spkkindex)),' spk(s) sorted'));
set(handles.text_msg, 'String', [num2str(sum(spktag>=0)),' spk(s) sorted']);
%set(handles.text_fInfo,'String',inf2str(handles.find.info));







% --- Executes on button press in pushbutton_prevaxes.
function pushbutton_prevaxes_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_prevaxes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=vSwitchaxes2(handles, handles.vNowaxes-1);
guidata(hObject, handles);

% --- Executes on button press in pushbutton_nextaxes.
function pushbutton_nextaxes_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_nextaxes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(handles.vNowaxes+1>handles.vNumaxes)
    handles=vAddaxes(handles);
end
handles=vSwitchaxes2(handles, handles.vNowaxes+1);
guidata(hObject, handles);


%from viewspike20
% --- Executes on button press in pushbutton_addaxes.
% function pushbutton_addaxes_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton_addaxes (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% handles=vAddaxes(handles);
% guidata(hObject, handles);



%from viewspike20
function handles=vAddaxes(handles)
newaxesnum=handles.vNumaxes+1;
handles.vHaxes(newaxesnum)=axes('Parent', handles.uipanel_viewtab, 'Units', 'normalized','Position', handles.vAxesposition0);
%set(handles.uipanel_viewtab,'Children', [get(handles.uipanel_viewtab,'Children'); handles.vHaxes(newaxesnum) ]);
% set(handles.vHaxes(newaxesnum), 'Visible', 'off');
% children = get(handles.vHaxes(newaxesnum),'Children');
% for k=1:length(children)
%     set(children(k),'Visible','off');
% end;

for k=1:length(handles.axesinfoid)
    eval(['handles.vAxesinfo(newaxesnum).' handles.axesinfoid{k} '=[];']);
end

handles.vAxesinfo(newaxesnum).t0=0;
handles.vAxesinfo(newaxesnum).tend=1;
handles.vAxesinfo(newaxesnum).hCaxes=[];

handles.vNumaxes=handles.vNumaxes+1;

handles.vFollowaxis0(newaxesnum)=0;

vUpdateaxesnum(handles);

if(handles.vNumaxes==1)
    handles=vSwitchaxes2(handles,1);
    set(handles.text_logo1,'Visible','off');
    set(handles.text_logo2,'Visible','off');
end






function handles=vPlot1(handles, fname9)
axesk=handles.vNowaxes;
fname0=strcat(handles.mfolder, fname9);
if(~strcmpi(fname0((end-3):end),'.mat'))
    fname0=strcat(fname0,'.mat');
end
if(~exist(fname0,'file'))
    set(handles.text_msg,'String',strcat(fname9, ' not found'));
    set(handles.text_axesinfo,'String',strcat(fname9, ' not found'));
    return;
end

load(fname0);
if(~exist('d','var'))
    set(handles.text_msg, 'String', strcat(fname9,'- no data found'));
    set(handles.text_axesinfo,'String',strcat(fname9, '- no data found'));
    return;
end
if(handles.fInvertD)
    d=-d;
end


%=====initialize all recording information field
for k=1:length(handles.axesinfoid)
    if(~exist(handles.axesinfoid{k},'var'))
        eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k} '=[];']);
        eval([handles.axesinfoid{k} '=[];']);
        continue;
    end
    if(isempty(handles.axesinfoid{k}))
        eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k} '=[];']);
        continue;
    end

    eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k} '=' handles.axesinfoid{k} ';']);
end
%handles.vAxesinfo(axesk).hCaxes=[];



if(exist('ppmfactor','var'))
    if(~isempty(ppmfactor))
        %parameters (hexane, acetone, ethyl acetate) updated on 6/1/2009 based upon results from getppmfactor20090520.m
        if(strfind(lower(handles.vAxesinfo(axesk).stimtype),'hexane'))
            pidfactor=4.7;
            %handles.vAxesinfo(axesk).ppmfactor=ppmfactor*4.7;%4.7:hexane's PID response factor
        elseif(strfind(lower(handles.vAxesinfo(axesk).stimtype),'acetone'))
            pidfactor=0.997;
            %handles.vAxesinfo(axesk).ppmfactor=ppmfactor*1.2;
        elseif(strfind(lower(handles.vAxesinfo(axesk).stimtype),'ethanol'))
            pidfactor=8.8;
            %handles.vAxesinfo(axesk).ppmfactor=ppmfactor*1.2;
        elseif(strfind(lower(handles.vAxesinfo(axesk).stimtype),'ethyl acetate'))
            pidfactor=3.654;
            %handles.vAxesinfo(axesk).ppmfactor=ppmfactor*3.8;
        elseif(strfind(lower(handles.vAxesinfo(axesk).stimtype),'co2'))
            pidfactor=0.5;
            %handles.vAxesinfo(axesk).ppmfactor=ppmfactor/2;
            %divided by 2 because CO2 stream is 50%
        else
            pidfactor=1;
        end
        handles.vAxesinfo(axesk).ppmfactor=ppmfactor*pidfactor;

    end
end
if(length(handles.vAxesinfo(axesk).c)~=length(handles.vAxesinfo(axesk).d))
    handles.vAxesinfo(axesk).c=[];
end

if(isempty(handles.vAxesinfo(axesk).dt)) handles.vAxesinfo(axesk).dt=1; end;
if(isempty(handles.vAxesinfo(axesk).t0)) handles.vAxesinfo(axesk).t0=0; end;
if(isempty(handles.vAxesinfo(axesk).tend))
    handles.vAxesinfo(axesk).tend=handles.vAxesinfo(axesk).t0+...
        length(handles.vAxesinfo(axesk).d)*handles.vAxesinfo(axesk).dt;
end
%===================================================


update_axesinfo(handles, axesk);


dd=downsample_anmo(d,handles.vDownsampleratio);
dd_stimstartk=handles.vAxesinfo(axesk).stimstart*dt*handles.vDownsampleratio;
dd_stimendk=dd_stimstartk+sum(handles.vAxesinfo(axesk).stimdur)*dt*handles.vDownsampleratio;


handles.vFollowaxis0(axesk)=1;
%if(handles.vPlotoption==1 & ~isempty(spkk))%both



cla(handles.vHaxes(axesk));


if(sum(handles.vAxesinfo(axesk).stimdur)>0)
    maxy_instim=max(dd);
    miny_instim=min(dd);
    recty=[miny_instim miny_instim maxy_instim maxy_instim];

    rectx=handles.vAxesinfo(axesk).stimstart+[0 sum(handles.vAxesinfo(axesk).stimdur) sum(handles.vAxesinfo(axesk).stimdur) 0];
    if(handles.vAxesinfo(axesk).valve_open0>0)
        rectx=rectx-(handles.vAxesinfo(axesk).stimstart-handles.vAxesinfo(axesk).valve_open0.*handles.vAxesinfo(axesk).dt);
    end

    axes(handles.vHaxes(axesk));
    hrect=patch(rectx,recty, [0.75 1 1],'EdgeColor','none');%light green: [.596 .996 .655]);
    hold on;


    npulses=1;
    %     if(isfield(handles.vAxesinfo(axesk),'stimpause') && isfield(handles.vAxesinfo(axesk),'npulses'));
    %         if(~isempty(handles.vAxesinfo(axesk).stimpause) && ~isempty(handles.vAxesinfo(axesk).npulses));
    %             if(handles.vAxesinfo(axesk).npulses>1 && handles.vAxesinfo(axesk).stimpause>0)
    %                 npulses=handles.vAxesinfo(axesk).npulses;
    %                 stimpause=handles.vAxesinfo(axesk).stimpause;
    %             end
    %         end
    %     end


    if(isfield(handles.vAxesinfo(axesk),'npulses'));
        if(~isempty(handles.vAxesinfo(axesk).npulses));
            if(handles.vAxesinfo(axesk).npulses>1)
                npulses=handles.vAxesinfo(axesk).npulses;
            end
        end
    end


    if(npulses>1 && npulses<=50)
        axes(handles.vHaxes(axesk));
        for k=2:npulses
            rectx=rectx+sum(handles.vAxesinfo(axesk).stimdur);
            hrect=patch(rectx,recty, [0.75 1 1],'EdgeColor','none');%light green: [.596 .996 .655]);
        end
    end

end

axes(handles.vHaxes(axesk));
handles.vAxesinfo(axesk).hodorline=line(((1:length(dd))-1)*dt*handles.vDownsampleratio+handles.vAxesinfo(axesk).t0, dd);hold on;
handles.vAxesinfo(axesk).hreddot=line(spkk*dt+handles.vAxesinfo(axesk).t0, d(spkk), 'Marker','o','MarkerEdgeColor','r','LineStyle','none');
set(handles.vAxesinfo(axesk).hodorline,'ButtonDownFcn',@(hObject,eventdata)flyspikes('vAxes_AddSpike',hObject,eventdata,guidata(hObject)));
set(handles.vAxesinfo(axesk).hreddot,'ButtonDownFcn',@(hObject,eventdata)flyspikes('vAxes_RemoveSpike',hObject,eventdata,guidata(hObject)));
handles.vAxis0(1)=min(handles.vAxis0(1), handles.vAxesinfo(axesk).t0);
handles.vAxis0(2)=max(handles.vAxis0(2), length(d)*dt+handles.vAxesinfo(axesk).t0);
handles.vAxis0(3)=min(handles.vAxis0(3), min(dd));
handles.vAxis0(4)=max(handles.vAxis0(4), max(dd));
if(max(dd)==min(dd))
    handles.vAxis0(4)=handles.vAxis0(4)+0.1;
end
axis(handles.vHaxes(axesk), handles.vAxis0);



if(isempty(handles.vAxesinfo(axesk).c))
    %if no odor concentration data
    
    if(isfield(handles.vAxesinfo(axesk),'hCaxes'))
        if(~isempty(handles.vAxesinfo(axesk).hCaxes))
            delete(handles.vAxesinfo(axesk).hCaxes);
        end
    end
    xlabel(handles.vHaxes(handles.vNowaxes),'time [ms]');
    ylabel(handles.vHaxes(handles.vNowaxes), 'potential [mV]');
else
    %if odor concentration data exist
    set(handles.vHaxes(axesk), 'Position', handles.vAxesposition1,'XTickLabel',[]);
    ylabel(handles.vHaxes(handles.vNowaxes), 'potential [mV]');
    if(~isfield(handles.vAxesinfo(axesk),'hCaxes'))
        handles.vAxesinfo(axesk).hCaxes=[];
    end
    if(isempty(handles.vAxesinfo(axesk).hCaxes))
        handles.vAxesinfo(axesk).hCaxes=axes('Parent',...
            handles.uipanel_viewtab, 'Units', 'normalized',...
            'Position', handles.vAxesposition2);
        ylabel(handles.vAxesinfo(axesk).hCaxes,strcat('PID value',num2str(axesk)));
    else
        cla(handles.vAxesinfo(axesk).hCaxes)
    end
    cc=downsample_anmo(handles.vAxesinfo(axesk).c,handles.vDownsampleratio);

    if(isfield(handles.vAxesinfo(axesk),'ppmfactor'))
        if(~isempty(handles.vAxesinfo(axesk).ppmfactor))
            cc=handles.vAxesinfo(axesk).ppmfactor*(cc-...
                mean(cc(1:round(handles.vAxesinfo(axesk).stimstart./dt/handles.vDownsampleratio))));
            plot(handles.vAxesinfo(axesk).hCaxes,((1:length(dd))-1)*dt*handles.vDownsampleratio+...
                handles.vAxesinfo(axesk).t0, cc,'b-');
            xlabel(handles.vAxesinfo(axesk).hCaxes,'time [ms]');
            ylabel(handles.vAxesinfo(axesk).hCaxes,'ppm');

        else
            plot(handles.vAxesinfo(axesk).hCaxes,((1:length(dd))-1)*dt*handles.vDownsampleratio+...
                handles.vAxesinfo(axesk).t0, cc,'b-');
            xlabel(handles.vAxesinfo(axesk).hCaxes,'time [ms]');
            ylabel(handles.vAxesinfo(axesk).hCaxes,'PID output');

        end
    else
        plot(handles.vAxesinfo(axesk).hCaxes,((1:length(dd))-1)*dt*handles.vDownsampleratio+...
            handles.vAxesinfo(axesk).t0, cc,'b-');
        xlabel(handles.vAxesinfo(axesk).hCaxes,'time [ms]');
        ylabel(handles.vAxesinfo(axesk).hCaxes,'PID output');

    end


    valveseq=num2str(valveseq);
    if(valveseq(1)=='.')
        valveseq=[];
    end
    
    %added on 1/17/2008
    if(~isempty(valveseq)&&~isempty(handles.vAxesinfo(axesk).stimstart) && ~isempty(handles.vAxesinfo(axesk).stimdur))
        %plot valve control
        valvecontrol=ones(size(cc));
        startk=round((handles.vAxesinfo(axesk).stimstart-handles.vAxesinfo(axesk).t0)./(dt*handles.vDownsampleratio));

        durk=round(handles.vAxesinfo(axesk).stimdur./(dt*handles.vDownsampleratio));
        cumdurk=0;
        for i=1:length(durk)
            valvecontrol(startk+cumdurk+(1:durk(i)))=hex2dec(valveseq(i));
            cumdurk=cumdurk+durk(i);
        end
        if(~isempty(handles.vAxesinfo(axesk).npulses))
            if(handles.vAxesinfo(axesk).npulses>1)
                for k=2:handles.vAxesinfo(axesk).npulses
                    valvecontrol(end+(1:sum(durk)))=valvecontrol(startk+(1:sum(durk)));
                end
            end
        end

        valvecontrol=(valvecontrol+1)*(max(cc)-min(cc))/3+min(cc);
        axes(handles.vAxesinfo(axesk).hCaxes)
        line(((1:length(dd))-1)*dt*handles.vDownsampleratio+handles.vAxesinfo(axesk).t0, valvecontrol(1:length(dd)),'Color','r');
    end
end



if(isfield(handles.vAxesinfo(axesk),'hCaxes'))
    if(~isempty(handles.vAxesinfo(axesk).hCaxes))
        axis(handles.vAxesinfo(axesk).hCaxes, [handles.vAxis0(1:2) min(cc),...
            max(cc)+max(0.000001,max(cc)-min(cc))]);
    end
end
set(handles.text_msg,'String', sprintf('%s is loaded and plotted on axes#%02d', fname9, axesk));
drawnow;




%from viewspike20
function vUpdateaxesnum(handles)
%update axes number in the 'text_pagenum' gui item
set(handles.text_axesnum, 'String', sprintf('page: %2d/%2d', handles.vNowaxes, handles.vNumaxes));
if(handles.vNumaxes==0)
    set(handles.text_msg, 'String', 'no data is plotted');
    set(handles.pushbutton_prevaxes,'Enable','off');
    %    set(handles.pushbutton_nextaxes,'Enable','off');
elseif(handles.vNumaxes==1)
    set(handles.text_msg, 'String', '1 of 1 page');
    set(handles.pushbutton_prevaxes,'Enable','off');
    %    set(handles.pushbutton_nextaxes,'Enable','off');
else
    if(handles.vNowaxes==1)
        set(handles.pushbutton_prevaxes,'Enable','off');
    else
        set(handles.pushbutton_prevaxes,'Enable','on');
    end

    %     if(handles.vNumaxes==handles.vNowaxes)
    %         set(handles.pushbutton_nextaxes,'Enable','off');
    %     else
    %         set(handles.pushbutton_nextaxes,'Enable','on');
    %     end
end




%from viewspike20
function handles=vSwitchaxes2(handles, newaxes)
%handling wrong axes num
if(newaxes<0 || newaxes>handles.vNumaxes)
    set(handles.text_msg,'String', 'invalid nowaxes number');
    return;
end

if(handles.vNowaxes~=newaxes)
    if(handles.vNowaxes>0 && handles.vNowaxes<=handles.vNumaxes)
        set(handles.vHaxes(handles.vNowaxes), 'Visible', 'off');
        children = get(handles.vHaxes(handles.vNowaxes),'Children');
        for k=1:length(children)
            set(children(k),'Visible','off');
        end;
        

        if(isfield(handles.vAxesinfo(handles.vNowaxes),'hCaxes'))
            if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                set(handles.vAxesinfo(handles.vNowaxes).hCaxes, 'Visible', 'off');
                children = get(handles.vAxesinfo(handles.vNowaxes).hCaxes,'Children');
                for k=1:length(children)
                    set(children(k),'Visible','off');
                end;
            end
        end
    end

    set(handles.vHaxes(newaxes), 'Visible', 'on');
    children = get(handles.vHaxes(newaxes),'Children');
    for k=1:length(children)
        set(children(k),'Visible','on');
    end;
    %axes(handles.vHaxes(newaxes));
    if(isfield(handles.vAxesinfo(newaxes),'hCaxes'))
        if(ishandle(handles.vAxesinfo(newaxes).hCaxes))
            set(handles.vAxesinfo(newaxes).hCaxes, 'Visible', 'on');
            children = get(handles.vAxesinfo(newaxes).hCaxes,'Children');
            for k=1:length(children)
                set(children(k),'Visible','on');
            end;
        end
    end
end

if(length(handles.vFollowaxis0)>=newaxes)
    if(handles.vFollowaxis0(newaxes)==1)
        kaxis=handles.vAxis0;
        %changed on Nov. 15th, 2006 by Anmo kim because it can never fully zoom
        %out
        %    kaxis(1)=kaxis(1)+(kaxis(2)-kaxis(1))*.05;
        %    kaxis(2)=kaxis(2)-(kaxis(2)-kaxis(1))*.05;
        axis(handles.vHaxes(newaxes),kaxis);
        if(isfield(handles.vAxesinfo(newaxes),'hCaxes'))
            if(ishandle(handles.vAxesinfo(newaxes).hCaxes))
                nowaxis2=axis(handles.vAxesinfo(newaxes).hCaxes);
                axis(handles.vAxesinfo(newaxes).hCaxes, [kaxis(1:2) nowaxis2(3:4)]);
            end
        end
    end
end
handles.vFollowaxis0(newaxes)=0;

handles.vNowaxes=newaxes;
vUpdateaxesnum(handles)
if(length(handles.vAxesinfo)>=newaxes)
    set(handles.text_msg,'String', sprintf('%s on axes#%02d', handles.vAxesinfo(handles.vNowaxes).fname, handles.vNowaxes));

    update_axesinfo(handles, newaxes);
    %    if(length(handles.vAxesinfo(newaxes).fname~=0))
    %       set(handles.text_axesinfo, 'String',...
    %          sprintf('fname:%s, stimstart=%dms, stimdur=%dms, Iin=%.2fpA, pp/con=%3.1f, celltype:%s, etc:%s, #spks:%d',...
    %          handles.vAxesinfo(newaxes).fname, handles.vAxesinfo(newaxes).stimstart, handles.vAxesinfo(newaxes).stimdur,...
    %          handles.vAxesinfo(newaxes).Iin, handles.vAxesinfo(newaxes).pp, handles.vAxesinfo(newaxes).celltype,...
    %          handles.vAxesinfo(newaxes).etc, length(handles.vAxesinfo(newaxes).spkk)));
    %    else
    %       set(handles.text_axesinfo, 'String','information unavailable');
    %    end
end





%from viewspike20
function out=downsample_anmo(in, ratio)

if(ratio<1)
    set(handles.text_msg,'String', 'downsampleratio < 1 --> no downsample');
    out=in;
    return;
end

ratio=round(ratio);


lenin = length(in);
lenout = ceil(lenin/ratio);

index = zeros(ratio, lenout);
index(1,:)=1;
index = reshape(index, ratio*lenout, 1);
index = index(1:lenin);

out=in(logical(index));





% --- Executes on button press in pushbutton_loadm.
function pushbutton_loadm_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_loadm (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

handles=updatepwd(handles);

%from viewspike20
%[newonfilek newplotoption newdownsampleratio]=loadn(handles.flist);
xlsfiles={};

mfolder=strcat(handles.mfolder);
abffolder=strcat(mfolder(1:(end-2)));

xlsfiles1=dir(strcat(abffolder, '*.xls'));
finfo=[];
for k=1:length(xlsfiles1)
    if(xlsfiles1(k).name(1)~='.')
        xlsfiles{end+1}=strcat(abffolder,xlsfiles1(k).name);
    end
end

if(ispc)
    xlsfiles2=dir(strcat(mfolder, '*.xls'));
else
    xlsfiles2=dir(strcat(mfolder, '*.xls'));
end

for i=1:length(xlsfiles2)
    found=0;
    for j=1:length(xlsfiles)
        if(strcmpi(xlsfiles1(j).name,xlsfiles2(i).name))
            found=1;
        end
    end
    if(~found && xlsfiles2(i).name(1)~='.')
        xlsfiles{end+1}=strcat(mfolder,xlsfiles2(k).name);
    end
end



finfo=[];
for k=1:length(xlsfiles)
    finfo0=readdatainf(xlsfiles{k}, handles);
    finfo=[finfo finfo0];
end

mfiles=dir(strcat(mfolder, '*.mat'));
if(isempty(mfiles))
    set(handles.text_msg,'String','no .mat files found');
    return;
else
    set(handles.text_msg,'String','anlayzing data files. hold on...');
    drawnow;
end


%get rid of duplicate information
dupk=[];%index of duplicate file informations
for i=1:(length(finfo)-1)
    for j=(i+1):length(finfo)
        if(strcmpi(finfo(i).fname, finfo(j).fname))
            dupk=[dupk j];
        end
    end
end
index=ones(1,length(finfo));
index(dupk)=0;
finfo=finfo(index==1);



%get rid of invalid file names
notfoundk=[];%index of duplicate file informations
for k=1:length(finfo)
    if(~exist(strcat(mfolder, finfo(k).fname,'.mat')))
        notfoundk=[notfoundk k];
    end
end
index=ones(1,length(finfo));
index(notfoundk)=0;
finfo=finfo(index==1);

%add channel2 files
finfo0=finfo;
j=1;
for i=1:length(finfo0)
    finfo(j)=finfo0(i); j=j+1;
    if(exist(strcat(mfolder, finfo(j-1).fname,'b','.mat')))
        finfo(j)=finfo(j-1);
        finfo(j).fname=strcat( finfo(j).fname,'b');
        j=j+1;
    end
end

%add files that are not found in the information files
for i=1:length(mfiles)
    found=0;
    for j=1:length(finfo)
        if(strfind(mfiles(i).name,finfo(j).fname))
            found=1;
        end
    end
    
    if(~found)
        vars5=whos('-file', [handles.mfolder mfiles(i).name]);
        if(3==length([cell2mat(strfind({vars5.name},'delta')) cell2mat(strfind({vars5.name},'con')) cell2mat(strfind({vars5.name},'dt'))]))
           %if the file is a valid data file 
            finfo(end+1).fname=mfiles(i).name(1:(end-4));
            for i=2:length(handles.infname)
                %put empty
                if(strcmpi(handles.inftype{i},'char'))
                    eval(strcat('finfo(end).',handles.infname{i},'='''';'));
                elseif(strcmpi(handles.inftype{i},'num'))
                    if(strfind(handles.infname{i},'/'))
                        finfo(end).pp=[];
                    else
                        eval(strcat('finfo(end).',handles.infname{i},'=[];'));
                    end
                end
            end
        end
    end
end


[newonfilek newdownsampleratio]=loadn(finfo, gcf);



% if(strcmp(lower(get(gcf,'Name')),'viewinf'))
%     delete(gcf);
% end


figname=lower(get(gcf,'Name'));
figname=strcat(figname,'..........');
if(~strcmpi(figname(1:9), 'flyspikes'))
    figlist=get(0,'Children');
    for k=1:length(figlist)
        figure(figlist(k));
        figname=lower(get(gcf,'Name'));
        figname=strcat(figname,'..........');
        if(strcmp(figname(1:9), 'FlySpikes'))
            break;
        end
    end
end


if(~strcmpi(figname(1:9), 'flyspikes'))
    disp('warning: no flyspikes10 exists');
    return;
end


if(isempty(newonfilek))
    return;
end

%handles.vOnfilek=newonfilek;
nfiles=length(newonfilek);


%handles.vPlotoption=newplotoption;
handles.vDownsampleratio=newdownsampleratio;

set(handles.text_logo1,'Visible','off');
set(handles.text_logo2,'Visible','off');
drawnow;

axesoffset=0;
if(0)
    handles=vClearallaxes(handles);
    handles.vNumaxes=nfiles;
    handles.vNowaxes=0;
elseif(handles.vNumaxes==0)
    handles.vNumaxes=nfiles;
    handles.vNowaxes=0;
else
    axesoffset=handles.vNumaxes;
    handles.vNumaxes=nfiles+axesoffset;
end

handles.vFollowaxis0=[];
handles.vAxis0=[0 -Inf Inf -Inf];
handles.endt=[];

for k=1:nfiles
    if(handles.vNowaxes>0)
        set(handles.vHaxes(handles.vNowaxes), 'Visible', 'off');
        children = get(handles.vHaxes(handles.vNowaxes),'Children');
        for kk=1:length(children)
            set(children(kk),'Visible','off');
        end;
        if(isfield(handles.vAxesinfo(handles.vNowaxes),'hCaxes'))
            
            if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                set(handles.vAxesinfo(handles.vNowaxes).hCaxes, 'Visible', 'off');
                children = get(handles.vAxesinfo(handles.vNowaxes).hCaxes,'Children');
                for kk=1:length(children)
                    set(children(kk),'Visible','off');
                end
            end
        end
    end
    handles.vNowaxes=k+axesoffset;

    handles.vHaxes(k+axesoffset)=axes('Parent', handles.uipanel_viewtab,...
        'Units', 'normalized','Position', handles.vAxesposition0);
    vUpdateaxesnum(handles);
    handles=vPlot1(handles, finfo(newonfilek(k)).fname);
end
handles=vSwitchaxes2(handles,axesoffset+1);

guidata(hObject, handles);




%from viewspike20
function handles=vClearallaxes(handles)
if(handles.vNumaxes>0)
    for k=1:handles.vNumaxes
        if(ishandle(handles.vHaxes(k)))
            delete(handles.vHaxes(k));
        else
            handles.vHaxes(k)=[];
        end
        if(ishandle(handles.vAxesinfo(k).hCaxes))
            delete(handles.vAxesinfo(k).hCaxes);
        end
    end
end

handles.vNumaxes=0;
handles.vNowaxes=0;

handles.vHaxes=[];
handles.vAxesinfo=[];
handles.axis=[];
set(handles.text_axesinfo,'String','');
set(handles.text_msg, 'String', 'all axes and their information cleared');




function update_axesinfo(handles,axesk)
infostr=[];
noprintfields={'dt','t0','tend','valveseq','analmethod','Iin'};
for k=1:length(handles.axesinfoid)
    if(strcmp(handles.axesinfoid{k}, 'nspks') && ~isempty(handles.vAxesinfo(axesk).spkk))
        infostr=strcat(infostr, '#spks=',...
            num2str(length(handles.vAxesinfo(axesk).spkk)), ', ');
        continue;
    end

    if(~isempty(cell2mat(strfind(noprintfields,handles.axesinfoid{k}))))
        continue;
    end

    if(isempty(eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k}])))
        continue;
    end

    if(isnumeric(eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k}])))
        infostr1=[];
        if(length(eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k}]))==1)
            infostr1=num2str(eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k}]));
            %         else
            %             infostr1=num2str(eval(['handles.' handles.axesinfoid{k} '(1)']));
        end
        if(~isempty(infostr1) && length(infostr1)<15)
            infostr=strcat(infostr, handles.axesinfoid{k}, '=', infostr1, ', ');
        end
    elseif(isstr(eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k}])) &&...
            length(eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k}]))<60)
        infostr=strcat(infostr, handles.axesinfoid{k}, '=', eval(['handles.vAxesinfo(axesk).' handles.axesinfoid{k}]), ', ');
    else
        infostr=[];
    end
end

%infostr=sprintf('%s,#spks=%d,',infostr,length(handles.vAxesinfo(axesk).spkk));

if(~isempty(infostr))
    set(handles.text_axesinfo, 'String', infostr(1:(end-1)));
elseif(~isempty(handles.vAxesinfo(axesk).d))
    set(handles.text_axesinfo, 'String', 'no information entry found');
else
    set(handles.text_axesinfo, 'String', '');
end






% --- Executes on button press in pushbutton_clearall.
function pushbutton_clearall_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_clearall (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
switch(handles.activetab)
    case 1 %findtab

    case 2 %viewtab
        handles=vClearallaxes(handles);
        vUpdateaxesnum(handles)
        set(handles.text_logo1,'Visible','on');
        set(handles.text_logo2,'Visible','on');
        guidata(hObject, handles);

    case 3 %decodetab
        handles=clrtk(handles,'all');
        pushbutton_cla_dAxesut_Callback(handles.pushbutton_clearall,...
            eventdata, handles);
end




% --- Executes on button press in pushbutton_moveleft.
function pushbutton_moveleft_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_moveleft (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
v = get(handles.slider_movingrate,'Value')*.7+.02;
switch(handles.activetab)
    case 1 %findtab
        handles.find.xrange=handles.find.xrange-v*diff(handles.find.xrange);
        if(handles.find.xrange(1)<handles.find.t(1))
            handles.find.xrange=handles.find.xrange+...
                handles.find.t(1)-handles.find.xrange(1);
        end
        updatefindaxesxrange(handles);

    case 2 %viewtab
        if(handles.vNowaxes>0)
            nowaxis = axis(handles.vHaxes(handles.vNowaxes));
            if(nowaxis(1)-(nowaxis(2)-nowaxis(1))*v>0)
                nowaxis(1:2)=nowaxis(1:2)-(nowaxis(2)-nowaxis(1))*v;
                set(handles.text_msg, 'String', sprintf('axes#%d moved left', handles.vNowaxes));
            else
                nowaxis(1:2)=nowaxis(1:2)-nowaxis(1);
                set(handles.text_msg, 'String', sprintf('axes#%d touched the left end', handles.vNowaxes));
            end
            axis(handles.vHaxes(handles.vNowaxes),nowaxis);
            if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                nowaxis2=axis(handles.vAxesinfo(handles.vNowaxes).hCaxes);
                axis(handles.vAxesinfo(handles.vNowaxes).hCaxes, [nowaxis(1:2) nowaxis2(3:4)]);
            end

            handles.vFollowaxis0(handles.vNowaxes)=0;%set not to follow the axis0
        else
            set(handles.text_msg, 'String', 'no axes to move');
        end

    case 3 %decodetab
        handles.dec.xrange=handles.dec.xrange-v*diff(handles.dec.xrange);
        handles.dec.xrange=update_dec_xrange(handles);
end
guidata(hObject,handles);


% --- Executes on button press in pushbutton_moveright.
function pushbutton_moveright_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_moveright (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
v = get(handles.slider_movingrate,'Value')*.7+.02;
switch(handles.activetab)

    case 1 %findtab
        handles.find.xrange=handles.find.xrange+v*diff(handles.find.xrange);
        if(handles.find.xrange(2)>handles.find.t(end))
            handles.find.xrange=handles.find.xrange-...
                handles.find.xrange(2)+handles.find.t(end);
        end
        updatefindaxesxrange(handles);

    case 2 %viewtab
        if(handles.vNowaxes>0)
            nowaxis = axis(handles.vHaxes(handles.vNowaxes));
            shiftx=(nowaxis(2)-nowaxis(1))*v;
            if(nowaxis(2)<=handles.vAxesinfo(handles.vNowaxes).tend)
                shiftx=min(shiftx, handles.vAxesinfo(handles.vNowaxes).tend-nowaxis(2));
                nowaxis(1:2)=nowaxis(1:2)+shiftx;
                set(handles.text_msg, 'String', sprintf('axes#%d moved right', handles.vNowaxes));
                axis(handles.vHaxes(handles.vNowaxes),nowaxis);
                if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
                    nowaxis2=axis(handles.vAxesinfo(handles.vNowaxes).hCaxes);
                    axis(handles.vAxesinfo(handles.vNowaxes).hCaxes, [nowaxis(1:2) nowaxis2(3:4)]);
                end
            else
                set(handles.text_msg, 'String', sprintf('axes#%d touched the right end', handles.vNowaxes));
            end
            handles.vFollowaxis0(handles.vNowaxes)=0;%set not to follow the axis0
        else
            set(handles.text_msg, 'String', 'no axes to move');
        end

    case 3 %decodetab
        handles.dec.xrange=handles.dec.xrange+v*diff(handles.dec.xrange);
        handles.dec.xrange=update_dec_xrange(handles);
end
guidata(hObject,handles);




% --- Executes on slider movement.
function slider_movingrate_Callback(hObject, eventdata, handles)
% hObject    handle to slider_movingrate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
handles.movingrate=get(hObject, 'Value');
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function slider_movingrate_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider_movingrate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in pushbutton_vpop0.
function pushbutton_vpop0_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vpop0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(handles.vNowaxes>0 & handles.vNumaxes>0)
    newfig=figure(14);
    h=copyobj(handles.vHaxes(handles.vNowaxes),newfig);
    set(h, 'Position',[0.09 0.07 0.86 0.82]);
    set(h,'XTickLabelMode','auto'); grid on;
    titlestr=get(handles.text_axesinfo,'String');
    htitle=title(titlestr);
    set(htitle,'Interpreter','none');
end



% --- Executes on button press in pushbutton_vpsd.
function pushbutton_vpsd_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vpsd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(length(handles.vAxesinfo)<handles.vNowaxes || handles.vNowaxes<=0)
    set(handles.text_msg,'String', 'no data to compute');
    return;
end

% if(isempty(handles.vAxesinfo(handles.vNowaxes).fname))
%     set(handles.text_msg,'String', 'no data to compute');
%     return;
% end
% 
% load([handles.vAxesinfo(handles.vNowaxes).fname '.mat'], 'd');
% if(isempty(d))
%     set(handles.text_msg,'String', 'no data to compute');
%     return;
% end

d=handles.vAxesinfo(handles.vNowaxes).d;

[Pxx, f]=periodogram(d, [],length(d), 1000/handles.vAxesinfo(handles.vNowaxes).dt);
figure(77);semilogx(f, 10*log10(Pxx));grid on;
title(strcat('PSD Estimate via Periodogram - ', handles.vAxesinfo(handles.vNowaxes).fname),...
    'Interpreter','none');
xlabel('frequency [Hz]');ylabel('Power/frequency [dB/Hz]');
hold all;





% --- Executes on button press in pushbutton_vISI.
function pushbutton_vISI_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vISI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



t=((1:length(handles.vAxesinfo(handles.vNowaxes).c))-1)*handles.vAxesinfo(handles.vNowaxes).dt...
    +handles.vAxesinfo(handles.vNowaxes).t0;


spkk=handles.vAxesinfo(handles.vNowaxes).spkk;
if(isempty(spkk))
    set(handles.text_msg,'String','spikes are missing');
    return;
end
   
spkt=spkk*handles.vAxesinfo(handles.vNowaxes).dt;
isi=diff([spkt(:)]);


figure(23);clf;
haxes0=axes();
plot(haxes0,(spkt(1:(end-1))+spkt(2:end))./2, 1000./isi);

ylabel('1/ISI (1/sec)');
xlabel('time (ms)');

title(get(handles.text_axesinfo,'String'),'Interpreter','none');

if(handles.vNowaxes<handles.vNumaxes)
    pushbutton_nextaxes_Callback(handles.pushbutton_nextaxes, [], handles)
end







% --- Executes on button press in pushbutton_vpop1.
function pushbutton_vpop1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vpop1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.vAxesinfo(handles.vNowaxes).c))
    set(handles.text_msg,'String','no odor concentration data in this plot');
    return;
end

figure(22);clf;
haxes0=axes();
t=((1:length(handles.vAxesinfo(handles.vNowaxes).c))-1)*handles.vAxesinfo(handles.vNowaxes).dt...
    +handles.vAxesinfo(handles.vNowaxes).t0;
plot(haxes0,t, handles.vAxesinfo(handles.vNowaxes).c);

ylabel('PID value');
xlabel('time (ms)');

title(get(handles.text_axesinfo,'String'),'Interpreter','none');


% spkt=handles.vAxesinfo(handles.vNowaxes).spkk*handles.vAxesinfo(handles.vNowaxes).dt...
%     +handles.vAxesinfo(handles.vNowaxes).t0;
% if(size(spkt,1)>1 & size(spkt,2)>1)
%    set(handles.text_msg,'String', 'spkt is a matrix. first column is taken only');
%    spkt=spkt(:,1);
% end;

nowaxis=axis(handles.vHaxes(handles.vNowaxes));

if(~isempty(handles.vAxesinfo(handles.vNowaxes).spkk))
    cheight=max(handles.vAxesinfo(handles.vNowaxes).c)-min(handles.vAxesinfo(handles.vNowaxes).c);
    hold on;
    stair0=zeros(size(t));
    stair0(handles.vAxesinfo(handles.vNowaxes).spkk)=1;
    stair0=cumsum(stair0)/length(handles.vAxesinfo(handles.vNowaxes).spkk)*cheight+...
        min(handles.vAxesinfo(handles.vNowaxes).c);
    plot(t,stair0,'r');
    nowaxis2=axis(haxes0);
    axis(haxes0,[nowaxis(1:2) nowaxis2(3:4)]);
    hold off;
    legend('odor concentration','cumulative spike density');
end




% --- Executes on button press in pushbutton_vbarplot.
function pushbutton_vbarplot_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vbarplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.vAxesinfo(handles.vNowaxes).spkk))
    set(handles.text_msg,'String','no spike in this trace');
    return;
end

%axesposition0=[.1 .5 .84 .9];
%axesposition1=[.1 .60 .84 .3];
%axesposition2=[.1 .05 .84 .55];

spkt=handles.vAxesinfo(handles.vNowaxes).spkk*handles.vAxesinfo(handles.vNowaxes).dt...
    +handles.vAxesinfo(handles.vNowaxes).t0;

if(size(spkt,1)>1 & size(spkt,2)>1)
    set(handles.text_msg,'String', 'spkt is a matrix. first column is taken only');
    spkt=spkt(:,1);
end;


nowaxis=axis(handles.vHaxes(handles.vNowaxes));

% minx=spkt(1);
% maxx=spkt(end);
% minx=minx-.1*(maxx-minx);
% maxx=maxx+.1*(maxx-minx);

hfig=figure(21);clf;
haxes0=axes('Parent',hfig);
title(handles.vAxesinfo(handles.vNowaxes).fname,'Interpreter','none');
xlabel('time (ms)');

miny=0;maxy=1;
if(~isempty(handles.vAxesinfo(handles.vNowaxes).c))
    cc=handles.vAxesinfo(handles.vNowaxes).c;
    if(isfield(handles.vAxesinfo(handles.vNowaxes),'ppmfactor'))
        if(~isempty(handles.vAxesinfo(handles.vNowaxes).ppmfactor))
            cc= cc-...
                mean(cc(1:round(handles.vAxesinfo(handles.vNowaxes).stimstart./handles.vAxesinfo(handles.vNowaxes).dt)));
            cc=cc*handles.vAxesinfo(handles.vNowaxes).ppmfactor;
        end
    end


    miny=min(cc);
    maxy=max(cc);
    yrange=maxy-miny;
    miny=miny-.05*yrange;
    maxy=maxy+.05*yrange;

end


hold on;
for i=1:length(spkt)
    line([spkt(i) spkt(i)], [miny maxy],'Color','b');
end;

% 
% h=stem(spkt, -1+ones(1, length(spkt))*1.3+k,'Marker','none','Color',cm(colork,:),'BaseValue',-1+.7+k);
%         set(get(h,'BaseLine'),'LineStyle','none');

if(~isempty(handles.vAxesinfo(handles.vNowaxes).c))
    plot(haxes0,((1:length(handles.vAxesinfo(handles.vNowaxes).c))-1)*handles.vAxesinfo(handles.vNowaxes).dt...
        +handles.vAxesinfo(handles.vNowaxes).t0, cc,'r','LineWidth',1.5);
    nowaxis0=axis(haxes0);
    ylabel('PID value');
end
hold off;

title(get(handles.text_axesinfo,'String'),'Interpreter','none');
xlabel(haxes0,'time (ms)');

axis(haxes0,[nowaxis(1:2) miny maxy]);






% --- Executes on button press in pushbutton_tdm_Callback.
function pushbutton_tdm_Callback(hObject, eventdata, handles)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.dec.tk))
    set(handles.text_msg,'String','no spike sequence found');
    return;
end
nowtk=handles.dec.tk{handles.dec.tkindex};

if(isempty(nowtk))
    set(handles.text_msg,'String', 'no tk found');
    return;
end

handles=update_tem_params(handles);

decmethodstr=get(handles.popupmenu_decmethod, 'String');
decmethodval=get(handles.popupmenu_decmethod, 'Value');
decmethod=decmethodstr{decmethodval};

set(handles.text_msg,'String', 'time decoding started ... hold on...');
drawnow;

spkt=handles.dec.tk{handles.dec.tkindex};

switch decmethod
    case 'ideal i&f'
        [ut_rec t_rec G c]= timedec0(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'ideal delta-insensitive'
        [ut_rec t_rec G c]= timedec1(spkt, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'leaky i&f'
        [ut_rec t_rec G c]= timedec2(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b*10^-9, 'riemann', handles.temparams.R, handles.temparams.C, handles.text_msg);
        ut_rec=ut_rec*10^9;%nA
    case 'leaky delta-insensitive'
        [ut_rec t_rec G c]= timedec3(spkt, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.temparams.R, handles.temparams.C, handles.text_msg);
        ut_rec=ut_rec*10^9;%nA
    case 'ideal stitching'
        nowutk=get(handles.popupmenu_listofu,'Value');
        [ut_rec t_rec]= timedec4(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, handles.text_msg, handles.dec.ut{nowutk}, handles.dec.t{nowutk});
        %ut_rec=ut_rec*10^9;%nA
    case 'ideal dilationTDM'
        [ut_rec t_rec]= timedec5(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann');
    case 'refractory i&f'
        taur=str2num(get(handles.edit_dRefrac, 'String'));
        if(isempty(taur))
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        if(taur<0)
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        [ut_rec t_rec G c]= timedec7(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b,taur, 'riemann', handles.text_msg);
    case 'refractory i&f w/ interpolation'
        taur=str2num(get(handles.edit_dRefrac, 'String'));
        if(isempty(taur))
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        if(taur<0)
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        [ut_rec t_rec G c]= timedec8(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b,taur, 'riemann', handles.text_msg);
    case 'hohu w/ m-coupling'
        [ut_rec t_rec G c]= timedec6(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, handles.dec.taua, handles.d_eta, handles.text_msg);
    case 'population'
        %population timedecoding
        [ut_rec t_rec G c]= timedec9(handles.dec.tk, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'ideal i&f - interpolation'
        [ut_rec t_rec G c]= timedec10(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'ideal i&f - multipoint'
        [ut_rec t_rec G c]= timedec11(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'reciprocal ISI'
        [ut_rec t_rec G c]= timedec12(spkt, handles.temparams.threshold, handles.genut.b, handles.text_msg);
    case 'variational' %variational decoding
        dt = 1/handles.genut.f/100; % 100 samples per a zero-to-zero interval of g(.)
        t_rec=(spkt(1)-3/handles.genut.f/2):dt:(spkt(end)+3/handles.genut.f/2);%-(spkt(1)-3/handles.genut.f/2)+dt;
        ut_rec= variational_decoding_perfect(spkt', t_rec, handles.genut.b, handles.temparams.threshold);
    case 'syn_lpf' %synaptic decoding by LPF
        [ut_rec t_rec G c]= timedec14(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'syn_exp' %synaptic decoding by a leaky integrator
        [ut_rec t_rec G c]= timedec15(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'conj_grad' %synaptic decoding by a leaky integrator
        [ut_rec t_rec G c]= timedec16(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'var_kernel' %variable frequency decoder
        [ut_rec t_rec G c]= timedec17(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'ideal i&f - uniform'
        [ut_rec t_rec G c]= timedec0uniform(spkt, handles.temparams.threshold, 2*pi*handles.genut.f, handles.genut.b, 'riemann', handles.text_msg);
    case 'hohu 4d - floquet'
        [ut_rec t_rec G c]= timedec13(spkt, 2*pi*handles.genut.f,'riemann', handles.temparams.R, handles.temparams.C, handles.text_msg);
%        ut_rec=ut_rec*10^9;%nA
        ut_rec=ut_rec- handles.genut.b;
    case 'hohu 4d - direct'
        [ut_rec t_rec G c decker]= timedec23(spkt, 2*pi*handles.genut.f,'riemann', handles.temparams.R, handles.temparams.C, handles.text_msg);
%        ut_rec=ut_rec*10^9;%nA
        ut_rec=ut_rec- handles.genut.b;
    case 'Morris-Lecar'
        [ut_rec t_rec G c]= timedec24(spkt, 2*pi*handles.genut.f,'riemann', handles.temparams.R, handles.temparams.C, handles.text_msg);
%        ut_rec=ut_rec*10^9;%nA
        ut_rec=ut_rec- handles.genut.b;
    case 'hohu 4d - fixed b'
        [ut_rec t_rec G c decker]= timedec33(spkt, 2*pi*handles.genut.f,'riemann', handles.temparams.R, handles.temparams.C, handles.genut.b, handles.text_msg);
%        ut_rec=ut_rec*10^9;%nA
        %ut_rec=ut_rec- handles.genut.b;
    case 'hohu 4d - known&condPRC'
        nowutk=get(handles.popupmenu_listofu,'Value');
        ut=handles.dec.ut{nowutk};
        t=handles.dec.t{nowutk};
        bk=[];
        for jj=2:length(spkt)
            bk(jj-1)=mean(ut(t>=spkt(jj-1)&t<spkt(jj)))+handles.genut.b;
        end
        [ut_rec t_rec G c decker]= timedec43(spkt, 2*pi*handles.genut.f,'riemann', handles.temparams.R, handles.temparams.C, bk,handles.text_msg);
%        ut_rec=ut_rec*10^9;%nA
        ut_rec=ut_rec- handles.genut.b;
    otherwise
        set(handles.text_msg,'String', 'this decoding algorithm not implemented yet');
        return;
end

dt=t_rec(2)-t_rec(1);
%cut out unnecessary left/right tail of the recovered signal
ut_rec=ut_rec(t_rec>nowtk(1)-dt & t_rec<nowtk(end)+dt);
if(exist('decker'))
    decker=decker(t_rec>nowtk(1)-dt & t_rec<nowtk(end)+dt);
end
t_rec=t_rec(t_rec>nowtk(1)-dt & t_rec<nowtk(end)+dt);


newindex=length(handles.dec.ut)+1;
handles.dec.ut{newindex} = ut_rec;
handles.dec.t{newindex}=t_rec;

if(exist('decker'))
    handles.dec.decker{newindex}=decker;
end

if(exist('G'))
    handles.dec.G=G;
    handles.dec.ck=c;
else
    handles.dec.G=[];handles.dec.ck=[];
end

handles=update_dec_ut(handles,'addlastonly');

guidata(hObject, handles);
set(handles.text_msg,'String', sprintf('spike sequence has been decoded (ideal i&f model) with f=%d', handles.genut.f));






function handles=update_dec_ut(handles,addlastonly)
if(nargin<2)
    addlastonly='';
end

colormap(lines);
cm=colormap(lines(length(handles.dec.ut)+1));

if(~strcmp(addlastonly,'addlastonly'))
    cla(handles.axes_dAxesut);
    listofu={};
    if(isempty(handles.dec.ut)) return; end


    for k=1:length(handles.dec.ut)
        if(isempty(handles.dec.ut{k}))
            continue;
        elseif(isempty(handles.dec.t{k}))
            continue;
        else
            %          if(isempty(handles.dec.t{k}))
            %             %guess best
            %             if(length(handles.dec.dt)<k)
            %                handles.dec.t{k}=(0:(length(handles.dec.ut{k})-1))*0.1/1000;
            %             elseif(handles.dec.dt==0)
            %                handles.dec.t{k}=(0:(length(handles.dec.ut{k})-1))*0.1/1000;
            %             else
            %                handles.dec.t{k}=(0:(length(handles.dec.ut{k})-1))*handles.dec.dt(k);
            %             end
            %          end
            axes(handles.axes_dAxesut);
            hline=line(handles.dec.t{k}*1000,handles.dec.ut{k},'Color',cm(k,:));
            listofu{end+1}=sprintf('u%02d',k);
            text(0.02, max(1-k*0.05,0), listofu{end},'Unit','normalized','Color',cm(k,:));
        end
    end
    handles.dec.xrange(1)=handles.dec.t{1}(1)*1000;
    handles.dec.xrange(2)=handles.dec.t{1}(end)*1000;
    set(handles.popupmenu_listofu,'Value',1);
else
    k=length(handles.dec.ut);
    listofu=get(handles.popupmenu_listofu,'String');
    if(~isempty(handles.dec.ut{k})&&~isempty(handles.dec.t{k}))
        axes(handles.axes_dAxesut);
        hline=line(handles.dec.t{k}*1000,handles.dec.ut{k},'Color',cm(k,:));
        listofu{end+1}=sprintf('u%02d',k);
        text(0.02, max(1-k*0.05,0), listofu{end},'Unit','normalized','Color',cm(k,:));
    end
    if(handles.dec.xrange(1)<handles.dec.t{1}(1)*1000 ||...
            handles.dec.xrange(2)>handles.dec.t{1}(end)*1000)
        handles.dec.xrange=[handles.dec.t{1}(1)*1000 handles.dec.t{1}(end)*1000];
    end
end
set(handles.popupmenu_listofu,'String',listofu);
set(handles.text_genut2,'String',sprintf('u%02d',k+1));

%set the axis
handles.dec.xrange=update_dec_xrange(handles);




function out=update_dec_xrange(handles)
out=handles.dec.xrange;
if(isempty(get(handles.popupmenu_listofu,'String'))) return; end

nowutk=get(handles.popupmenu_listofu,'Value');
if(nowutk>length(handles.dec.ut))
    nowutk=length(handles.dec.ut);
end
if(isempty(handles.dec.ut{nowutk}) || isempty(handles.dec.t{nowutk}))
else
    %    yheight=max(handles.dec.ut{nowutk})-min(max(handles.dec.ut{nowutk}));
    yheight=max(handles.dec.ut{nowutk})-min((handles.dec.ut{nowutk}));
    if(yheight==0)
        yheight=1;
    end

    ymax=max(handles.dec.ut{nowutk})+yheight*0.01;
    ymin=min(handles.dec.ut{nowutk})-yheight*0.01;

    if(handles.dec.t{nowutk}(1)>handles.dec.xrange(1)/1000)
        gap0=handles.dec.t{nowutk}(1)*1000-handles.dec.xrange(1);
        handles.dec.xrange(1)=handles.dec.t{nowutk}(1)*1000;
        handles.dec.xrange(2)=handles.dec.xrange(2)+gap0;
        if(handles.dec.t{nowutk}(end)<handles.dec.xrange(2)/1000)
            handles.dec.xrange(2)=handles.dec.t{nowutk}(end)*1000;
        end
    end
    if(handles.dec.t{nowutk}(end)<handles.dec.xrange(2)/1000)
        gap1=handles.dec.xrange(2)-handles.dec.t{nowutk}(end)*1000;
        handles.dec.xrange(2)=handles.dec.t{nowutk}(end)*1000;
        handles.dec.xrange(1)=handles.dec.xrange(1)-gap1;
        if(handles.dec.t{nowutk}(1)>handles.dec.xrange(1)/1000)
            handles.dec.xrange(1)=handles.dec.t{nowutk}(1)*1000;
        end
    end
    axis(handles.axes_dAxesut,[handles.dec.xrange ymin ymax]);
    axis(handles.axes_dAxestk,[handles.dec.xrange 0 1]);
end
out=handles.dec.xrange;



% --- Executes on button press in pushbutton_genut.changeparams.
function pushbutton_genut_changeparams_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_genut.changeparams (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

varname={'f','b', 'c','K','t0','npadding','sigma'};
for k=1:length(varname)
    eval(['defAns{k}=num2str(handles.genut.' varname{k} ');']);
end

newparamstr = inputdlg({'f[Hz]','b[nA]', 'c[nA]', 'K(=duration/2/f)', ...
    't0(ms)','#padding', 'noise(sigma)'}, 'genut params',  ones(length(varname),1), defAns);

if(size(newparamstr,1)==0) 
    return; 
end %if 'cancel' button clicked

for k=1:length(varname)
    eval([varname{k} '=str2num(newparamstr{k});']);
    if(~isempty(eval([varname{k}])))
        eval(['handles.genut.' varname{k} '=' varname{k} ';']);
    end
end

%
% handles.genut.b=handles.genut.b*10^-9;%nA
% handles.genut.c=handles.genut.c*10^-9;%nA

update_genut_params(handles)

guidata(hObject,handles);


% --- Executes on button press in pushbutton_genut.
function pushbutton_genut_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_genut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% [handles isupdated]=updateparams(handles);
% if(~isupdated) return; end;
%handles.temparams.threshold=update_tem_threshold(handles.edit_tem_threshold,hand
%les.tem_threshold);
%Omega=2*pi*f;

T=1/handles.genut.f/2; %Nyquist rate
dt = T/1000; % 1000 samples in T
t=handles.genut.t0+((-T*handles.genut.npadding):dt:((handles.genut.K+handles.genut.npadding)*T));
st = zeros(size(t));


if(get(handles.radiobutton_dRect,'Value')==1)
    sTk = ones(handles.genut.K,1);
elseif(get(handles.radiobutton_dRamp,'Value')==1)
    sTk = cumsum(handles.genut.K-(1:handles.genut.K)+1)/handles.genut.K;
elseif(get(handles.radiobutton_dPara,'Value')==1)
    sTk=((1:handles.genut.K)-round(handles.genut.K/2)).^2;
    sTk=1-sTk./max(sTk);
elseif(get(handles.radiobutton_dRand,'Value')==1)
    sTk=rand(1,handles.genut.K);
elseif(get(handles.radiobutton_dTrough,'Value')==1)
    sTk=zeros(1,handles.genut.K);
    sTk(1)=1; sTk(end)=1;
elseif(get(handles.radiobutton_dSine,'Value')==1)
    sTk=zeros(1,handles.genut.K);
    sTk(1:3:handles.genut.K)=1;
elseif(get(handles.radiobutton_dStaircase,'Value')==1)
    sTk=zeros(1,handles.genut.K);
    if(handles.genut.K<9)
        sTk = cumsum(handles.genut.K-(1:handles.genut.K)+1)/handles.genut.K;
    else
        intervalk=floor(handles.genut.K/4);
        for i=1:3
            sTk((1:intervalk)+intervalk*(i-1))=1-(i-1)/2;
        end
        sTk((intervalk*3+1):end)=(0:(length(sTk)-intervalk*3-1))./(length(sTk)-intervalk*3-1);
    end
elseif(get(handles.radiobutton_dRand2,'Value')==1)
    sTk=rand(1,handles.genut.K);
    sTk=(sTk-min(sTk))./(max(sTk)-min(sTk))-.5;
end


for k=1:handles.genut.K
    st = st + sTk(k).*sinc(2*handles.genut.f.*(t-(k-1).*T-handles.genut.t0));
end

if(get(handles.radiobutton_dRand2,'Value')==1)
    %bipolar case
    ut=(st-mean(st))./(max(st)-min(st)).*handles.genut.c*2;
else
    %positive case
    ut=(st-min(st))./(max(st)-min(st)).*handles.genut.c;
end
ut0=ut;
len=round(length(ut)/10);

if(handles.genut.sigma>0)
    ut=ut+randn(size(ut)).*handles.genut.sigma;
end
ut(1:len*4)=ut0(1:len*4);

if(~isempty(handles.dec.t));
    if(length(t)==length(handles.dec.t))
        if(sum(ut~=handles.dec.ut)==0) %if ut is the same as handles.dec.ut
            set(handles.text_msg, 'String', 'ut is not changed');
            return; %no update
        end
    end
end

handles.dec.G=[];
handles.dec.ck=[];
handles.dec.uhatt=[];
handles.dec.t_hat=[];
handles.genut.fname='';
handles.genut.UTk=sTk;


handles.dec.ut={};
handles.dec.t={};

handles.dec.ut{1}=ut;
handles.dec.t{1}=t;

% axes(handles.axes_dAxesut);
% plot(t*1000,ut);axis tight;
set(handles.text_msg, 'String', 'u(t) created');
handles=clrtk(handles);

handles.dec.xrange=[t(1) t(end)]*1000;
handles=update_dec_ut(handles);
guidata(hObject, handles);


set(handles.text_dec1info, 'String',...
    sprintf('f=%1.1fHz, b=%1.1fnA, c=%1.1fnA, K=%1.1f, t0=%1.0fmsec, #padding=%1.0f',...
    handles.genut.f, handles.genut.b, handles.genut.c, handles.genut.K,...
    handles.genut.t0, handles.genut.npadding));




function handles=clrtk(handles,allornot)
if(nargin<2) allornot='not';end

if(~isempty(handles.dec.tk))
    if(~isempty(handles.dec.tk(handles.dec.tkindex))&&~strcmp(allornot,'all'))
        handles.dec.tkinfo=handles.dec.tkinfo(handles.dec.tkindex);
        handles.dec.tk=handles.dec.tk(handles.dec.tkindex);
        handles.dec.tkindex=1;
    else
        handles.dec.tkindex=0;
        handles.dec.tkinfo={};
        handles.dec.tk={};
    end
else
    handles.dec.tkindex=0;
    handles.dec.tkinfo={};
    handles.dec.tk={};
end
handles=d_update_axestk(handles);




function handles=d_update_axestk(handles)
set(handles.text_tkaxesnum,'String',sprintf('axes# : %2d/%2d',handles.dec.tkindex, length(handles.dec.tkinfo)));
if(~isempty(handles.dec.tk))
    nowtk=handles.dec.tk{handles.dec.tkindex};
    handles.genut.fname=handles.dec.tkinfo{handles.dec.tkindex};
else
    cla(handles.axes_dAxestk);
    return;
end


if(~isempty(nowtk))
    isi=nowtk(2:end)-nowtk(1:(end-1));
    nowaxis_ut=axis(handles.axes_dAxesut);
    axes(handles.axes_dAxestk);
    dPlottk(handles, handles.axes_dAxestk, nowtk);
    %axis([nowtk(1)-max(isi)   nowtk(end)+max(isi) 0 1]);
    %    if(~isempty(handles.dec.ut))
    %       axis([nowaxis_ut(1:2) 0 1]);
    %    end

    %   axes(handles.axes_dAxesut); %cla;

    if(~isempty(isi))
        set(handles.text_tkinfo,'String',...
            sprintf('%s, minISI=%.1f msec, maxISI=%.1f msec(f<%.1f Hz), #spks=%d(f<%.1fHz)',...
            handles.genut.fname, min(isi)*1000, max(isi)*1000, 1/2/max(isi), length(nowtk),length(nowtk)./(nowtk(end)-nowtk(1))/2 ));
    end
else
    handles.genut.fname='';
    cla(handles.axes_dAxestk);
    %axes(handles.axes_dAxesut);
    set(handles.text_tkinfo,'String','');
end

axis(handles.axes_dAxestk,[handles.dec.xrange 0 1]);



function dPlottk(handles, haxes_tk, tk)

if(size(tk,2)==1)
    tk=tk';
end

if(size(tk,1)~=1)
    return;
end

XData=[1; 1]*tk*1000;

XData=reshape(XData,[1 size(XData,2).*2]);

YData=2*ones(4,ceil(size(XData,2)/2));
YData(2:3,:)=-1;
YData=reshape(YData,[1 size(YData,2).*4]);
YData=YData(1:length(XData));

figure(handles.figure1);
axes(haxes_tk);
plot(XData, YData);
set(haxes_tk, 'YTick',[]);
nowaxis=axis;
axis([nowaxis(1:2) 0 1]);




function update_genut_params(handles)
infostr=sprintf('f=%1.1fHz, b=%1.1fnA, c=%1.1fnA, K=%1.1f, t0=%1.0fmsec, #padding=%1.0f, sigma=%1.1fnA',...
    handles.genut.f, handles.genut.b, handles.genut.c, handles.genut.K,...
    handles.genut.t0, handles.genut.npadding, handles.genut.sigma);
set(handles.text_genut,'String',infostr);



function edit_tem_threshold_Callback(hObject, eventdata, handles)
% hObject    handle to edit_tem_threshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_tem_threshold as text
%        str2double(get(hObject,'String')) returns contents of edit_tem_threshold as a double


function h=update_tem_params(h,updategui)
if(nargin<2) 
    updategui=0;
elseif(strcmpi(updategui,'updategui'))
    updategui=1;
else
    updategui=0;
end

val1=str2num(get(h.edit_tem_threshold,'String'))/1000;
if(isempty(val1) || updategui)
    set(h.edit_tem_threshold,'String',num2str(h.temparams.threshold*1000));
else
    h.temparams.threshold=val1;
end


val1=str2num(get(h.edit_dR,'String'))*1000000; %MOhm --> Ohm
if(isempty(val1)|| updategui)
    set(h.edit_dR,'String',sprintf('%3.1f',h.temparams.R/1000000));
else
    h.temparams.R=val1;
end


val1=str2num(get(h.edit_dC,'String'))/1000000000; %nF --> F
if(isempty(val1)|| updategui)
    set(h.edit_dC,'String',sprintf('%3.2f',h.temparams.C*1000000000));
else
    h.temparams.C=val1;
end


% val1=str2num(get(h.edit_dIbase,'String'))*10^-9;
% if(isempty(val1) || updategui)
%     set(h.edit_dIbase,'String',sprintf('%3.2f',h.temparams.Ibase*10^-9));
% else
%     h.temparams.Ibase=val1;
% end



% --- Executes on button press in pushbutton_tem.
function pushbutton_tem_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_tem (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
nowutk=get(handles.popupmenu_listofu,'Value');
tk=[];
if(length(handles.dec.ut)<nowutk || length(handles.dec.t)<nowutk)
    set(handles.text_msg,'String', 'tem failed: some data missing(ut, t, f)');
    return;
end

ut=handles.dec.ut{nowutk};
t=handles.dec.t{nowutk};
if(isempty(ut) || isempty(t) || isempty(handles.genut.f))
    set(handles.text_msg,'String', 'tem failed: some necessary data empty(ut, t, f)');
    return;
end

if(nargin<4) new_or_replace='new';end


handles=update_tem_params(handles);

%time encoding
encmethod=get(handles.popupmenu_encmethod, 'Value');
methodlist=get(handles.popupmenu_encmethod,'String');




switch methodlist{encmethod}
    case 'ideal i&f' %' ideal i&f'
        set(handles.text_msg,'String', 'ideal i-a-f : time encoding started ... hold on...');
        drawnow;
        [tk vt]= timeenc0(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.genut.b, handles.text_msg);
        set(handles.text_msg,'String', 'ideal i-a-f : time encodingcompleted');
    case 'leaky i&f' %' leaky i&f'
        %update R&C
        set(handles.text_msg,'String', 'leaky i-a-f : time encoding started ... hold on...');
        drawnow;
        %tk  = iaf_encode_leaky(ut, t, handles.genut.b, handles.temparams.threshold, handles.temparams.R, handles.temparams.C);
        [tk vt]= timeenc1(ut*10^-9, t, handles.temparams.threshold, handles.genut.b*10^-9, handles.temparams.R, handles.temparams.C, handles.genut.f*2*pi, handles.text_msg);
        set(handles.text_msg,'String', 'leaky i-a-f : time encoding started ... completed');
    case 'quadratic i&f' %' ideal i&f'
        set(handles.text_msg,'String', 'quadratic i-a-f : time encoding started ... hold on...');
        drawnow;
        [tk vt]= timeenc4(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.genut.b, handles.text_msg);
        set(handles.text_msg,'String', 'ideal i-a-f : time encodingcompleted');

    case 'refractory i&f' %' ideal i&f'
        taur=str2num(get(handles.edit_dRefrac, 'String'));
        if(isempty(taur))
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        if(taur<0)
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        set(handles.text_msg,'String', sprintf('ideal i-a-f with refractory period %dmsec: time encoding started ... hold on...',taur));
        drawnow;
        [tk vt]= timeenc2(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.genut.b, taur, handles.text_msg);

    case 'adaptation-e' %' adaptation-e'
        set(handles.text_msg,'String', 'adaptation-e : time encoding started ... hold on...');
        drawnow;
        [tk vt]= timeenc6(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.dec.taua, handles.d_eta, handles.text_msg);
    case 'adaptation-r' %' adaptation-r'
        set(handles.text_msg,'String', 'adaptation-r : time encoding started ... hold on...');
        drawnow;
        tk= timeenc7(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.dec.taua, handles.d_eta, handles.text_msg);
    case 'hohu w/ m-coupling' %' hohu w/ m-coupling'
        set(handles.text_msg,'String', 'm-coupling : time encoding started ... hold on...');
        drawnow;
        tk= timeenc8(ut, t, handles.genut.b, handles.text_msg);
    case 'hohu 4d' %' hohu 4d'
        set(handles.text_msg,'String', 'hohu4d : time encoding started ... hold on...');
        drawnow;
        tk= timeenc9(ut, t, handles.genut.b, handles.text_msg);
        set(handles.text_msg,'String', 'hohu4d : time encoding completed');
    case 'Morris-Lecar' 
        set(handles.text_msg,'String', 'Morris-Lecar : time encoding started ... hold on...');
        drawnow;
        %parameters for izhikevich
        gL=8; gCa=20; gK=10;EL=-80; ECa=60; EK=-90;Vhalf=[-20 -25]; %[Vhalf-Ca, Vhalf-K]
        tau=[15 5];%[tau-Ca tau-K]
        taun=1;vi=-50;ni=0.2;
        tk = timeenc11([gL gCa gK], [EL ECa EK], Vhalf, tau, taun, ut+handles.genut.b, 1000*(t(2)-t(1)), vi, ni);
        tk=tk*(t(2)-t(1))+t(1);
        set(handles.text_msg,'String', 'Morris-Lecar : time encoding completed');
        
    case 'pif' %' pif'
        set(handles.text_msg,'String', 'pif : time encoding started ... hold on...');
        drawnow;
        [tk vt]= timeenc3(ut, t, handles.temparams.threshold, handles.genut.b, handles.temparams.R, handles.temparams.C, handles.genut.f*2*pi, handles.text_msg);
        set(handles.text_msg,'String', 'pif : time encoding completed');
    case 'pif0' %' pif'
        set(handles.text_msg,'String', 'pif0 : time encoding started ... hold on...');
        drawnow;
        tk= timeenc10(ut, t, handles.genut.b, handles.text_msg);
        set(handles.text_msg,'String', 'pif0 : time encoding completed');
end


if(isempty(tk))
    return;
    % else
    %    set(handles.text_msg,'String', sprintf('%d spikes generated',length(tk)));
end

if(~strcmp(new_or_replace, 'replace'))
    %draw a column plot in a new axes
    handles.dec.tkindex=length(handles.dec.tkinfo)+1;
end

%column plot
%dPlottk(handles, handles.axes_dAxestk, tk);

tkinfstr0=sprintf('%s -> timeenc%1d,delta=%2.1fmV', ...
    get(handles.text_dec1info,'String'),...
    get(handles.popupmenu_encmethod, 'Value')-1, handles.temparams.threshold*1000);
if(strcmpi(methodlist{encmethod}(1:2),'01'))
    tkinfstr0=strcat(tkinfstr0,sprintf(',R=%3.1fMOhm,C=%3.2fnF',handles.temparams.R*10^-6,handles.temparams.C*10^9));
end
handles.dec.tkinfo{handles.dec.tkindex}=tkinfstr0;

handles.dec.tk{handles.dec.tkindex}=tk;
handles=d_update_axestk(handles);

% axes(handles.axes_dAxestk);
% nowaxis_tk=axis;
% axes(handles.axes_dAxesut);
% nowaxis_ut=axis;
% axis([nowaxis_tk(1:2) nowaxis_ut(3:4)]);


guidata(hObject, handles);



% --- Executes on button press in pushbutton_G.
function pushbutton_G_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_G (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(~isempty(handles.dec.G))
    hfig=figure(77);clf(hfig);
    set(hfig,'Name','G','NumberTitle','off');
    imagesc(handles.dec.G);
    assignin('base', 'G', handles.dec.G);
    set(handles.text_msg, 'String', 'G matrix is plotted and exported to the base workspace');
else
    set(handles.text_msg, 'String', 'no G matrix found');
end



% --- Executes on button press in pushbutton_Ginv.
function pushbutton_Ginv_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_Ginv (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(~isempty(handles.dec.G))
    hfig=figure(78);clf(hfig);
    set(hfig,'Name','G+','NumberTitle','off');
    Ginv=pinv(handles.dec.G);
    imagesc(Ginv);
    assignin('base', 'Ginv', Ginv);
    set(handles.text_msg, 'String', 'Ginv is plotted and exported to the base workspace');
else
    set(handles.text_msg, 'String', 'no Ginv matrix found');
end


% --- Executes on button press in pushbutton_ck.
function pushbutton_ck_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_ck (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(~isempty(handles.dec.ck))
    hfig=figure(79);clf;
    set(hfig,'Name','c','NumberTitle','off');
    stem(handles.dec.ck);
    nowaxis=axis;
    axis([0 (nowaxis(2)+1) nowaxis(3:4)]);
    assignin('base', 'c', handles.dec.ck);
    set(handles.text_msg, 'String', 'c matrix is plotted and exported to the base workspace');
else
    set(handles.text_msg, 'String', 'no c vector found');
end



function edit_taua_Callback(hObject, eventdata, handles)
% hObject    handle to edit_taua (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_taua as text
%        str2double(get(hObject,'String')) returns contents of edit_taua as a double


% --- Executes during object creation, after setting all properties.
function edit_taua_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_taua (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu_encmethod.
function popupmenu_encmethod_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_encmethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_encmethod contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_encmethod
set(handles.edit_dR, 'Visible', 'off');
set(handles.edit_dC, 'Visible', 'off');
%set(handles.edit_dIbase, 'Visible','off');
set(handles.text_dR, 'String','R','Visible','off');
set(handles.text_dC, 'String','C','Visible','off');
set(handles.text_dRefrac,'Visible','off');
set(handles.edit_dRefrac,'Visible','off');

encmethod=get(handles.popupmenu_encmethod, 'Value');
methodlist=get(handles.popupmenu_encmethod,'String');
%set(handles.popupmenu_decmethod,'Value',encmethod);

switch methodlist{encmethod}
    case 'ideal i&f'
    case 'leaky i&f'
        set(handles.text_dC, 'Visible','on');
        set(handles.text_dR, 'Visible','on');
        set(handles.edit_dR, 'Visible', 'on');
        set(handles.edit_dC, 'Visible', 'on');
    case 'refractory i&f'
        set(handles.text_dRefrac,'Visible','on');
        set(handles.edit_dRefrac,'Visible','on');
%     case 'hohu w/ m-coupling'
%         set(handles.edit_dIbase, 'Visible','on');
%     case 'hohu 4d'
%         set(handles.text_dIbase, 'Visible','on');
%         set(handles.edit_dIbase, 'Visible','on');
%     case 'pif'
%         set(handles.text_dIbase, 'Visible','on');
%         set(handles.edit_dIbase, 'Visible','on');
end


% --- Executes during object creation, after setting all properties.
function popupmenu_encmethod_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_encmethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on selection change in popupmenu_decmethod.
function popupmenu_decmethod_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_decmethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_decmethod contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_decmethod


% --- Executes during object creation, after setting all properties.
function popupmenu_decmethod_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_decmethod (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_eta_Callback(hObject, eventdata, handles)
% hObject    handle to edit_eta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_eta as text
%        str2double(get(hObject,'String')) returns contents of edit_eta as a double


% --- Executes during object creation, after setting all properties.
function edit_eta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_eta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_tau_Callback(hObject, eventdata, handles)
% hObject    handle to edit_tau (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_tau as text
%        str2double(get(hObject,'String')) returns contents of edit_tau as a double


% --- Executes during object creation, after setting all properties.
function edit_tau_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_tau (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_temani.
function pushbutton_temani_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_temani (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

nowutk=get(handles.popupmenu_listofu,'Value');
tk=[];
if(length(handles.dec.ut)<nowutk || length(handles.dec.t)<nowutk)
    set(handles.text_msg,'String', 'tem failed: some data missing(ut, t, f)');
    return;
end

ut=handles.dec.ut{nowutk};
t=handles.dec.t{nowutk};
if(isempty(ut) || isempty(t) || isempty(handles.genut.f))
    set(handles.text_msg,'String', 'tem failed: some necessary data empty(ut, t, f)');
    return;
end

if(nargin<4) new_or_replace='new';end


handles=update_tem_params(handles);

%time encoding
encmethod=get(handles.popupmenu_encmethod, 'Value');
methodlist=get(handles.popupmenu_encmethod,'String');



nhm=[]; %to plot limit cycles
switch methodlist{encmethod}
    case 'ideal i&f' %' ideal i&f'
        set(handles.text_msg,'String', 'ideal i-a-f : time encoding started ... hold on...');
        drawnow;
        [tk vt]= timeenc0(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.genut.b, handles.text_msg);
    case 'leaky i&f' %' leaky i&f'
        %update R&C
        set(handles.text_msg,'String', 'leaky i-a-f : time encoding started ... hold on...');
        drawnow;
        %tk  = iaf_encode_leaky(ut, t, handles.genut.b, handles.temparams.threshold, handles.temparams.R, handles.temparams.C);
        [tk vt]= timeenc1(ut*10^-9, t, handles.temparams.threshold, handles.genut.b*10^-9, handles.temparams.R, handles.temparams.C, handles.genut.f*2*pi, handles.text_msg);

    case 'refractory i&f' %' ideal i&f'
        taur=str2num(get(handles.edit_dRefrac, 'String'));
        if(isempty(taur))
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        if(taur<0)
            set(handles.text_msg,'wrong input for refractory period');
            return;
        end
        set(handles.text_msg,'String', sprintf('ideal i-a-f with refractory period %dmsec: time encoding started ... hold on...',taur));
        drawnow;
        [tk vt]= timeenc2(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.genut.b, taur, handles.text_msg);

    case 'adaptation-e' %' adaptation-e'
        set(handles.text_msg,'String', 'adaptation-e : time encoding started ... hold on...');
        drawnow;
        [tk vt]= timeenc6(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.dec.taua, handles.d_eta, handles.text_msg);
    case 'adaptation-r' %' adaptation-r'
        set(handles.text_msg,'String', 'adaptation-r : time encoding started ... hold on...');
        drawnow;
        tk= timeenc7(ut, t, handles.temparams.threshold, handles.genut.f*2*pi, handles.dec.taua, handles.d_eta, handles.text_msg);
    case 'hohu w/ m-coupling' %' hohu w/ m-coupling'
        set(handles.text_msg,'String', 'm-coupling : time encoding started ... hold on...');
        drawnow;
        tk= timeenc8(ut, t, handles.genut.b, handles.text_msg);
%     case 'hohu 4d' %' hohu 4d'
%         set(handles.text_msg,'String', 'hohu4d : time encoding started ... hold on...');
%         drawnow;
%         [tk vt nhm]= timeenc9(ut, t, handles.genut.b, [29.5457    0.5471    0.2463    0.8683], handles.text_msg);
    case 'hohu 4d' %' hohu 4d'
        set(handles.text_msg,'String', 'hohu4d : time encoding started ... hold on...');
        drawnow;
        [tk vt nhm]= timeenc9(ut, t, handles.genut.b, handles.text_msg);
        set(handles.text_msg,'String', 'hohu4d : time encoding completed');
    case 'pif' %' pif'
        set(handles.text_msg,'String', 'pif : time encoding started ... hold on...');
        drawnow;
        [tk vt]= timeenc3(ut, t, handles.temparams.threshold, handles.genut.b, handles.temparams.R, handles.temparams.C, handles.genut.f*2*pi, handles.text_msg);
        set(handles.text_msg,'String', 'pif : time encoding completed');
    case 'pif0' %' pif'
        set(handles.text_msg,'String', 'pif0 : time encoding started ... hold on...');
        drawnow;
        tk= timeenc10(ut, t, handles.genut.b, handles.text_msg);
        set(handles.text_msg,'String', 'pif0 : time encoding completed');
end


if(isempty(tk))
    return;
    % else
    %    set(handles.text_msg,'String', sprintf('%d spikes generated',length(tk)));
end

if(~strcmp(new_or_replace, 'replace'))
    %draw a column plot in a new axes
    handles.dec.tkindex=length(handles.dec.tkinfo)+1;
end

%column plot
%dPlottk(handles, handles.axes_dAxestk, tk);

tkinfstr0=sprintf('%s -> timeenc%1d,delta=%2.1fmV', ...
    get(handles.text_dec1info,'String'),...
    get(handles.popupmenu_encmethod, 'Value')-1, handles.temparams.threshold*1000);
if(strcmpi(methodlist{encmethod}(1:2),'01'))
    tkinfstr0=strcat(tkinfstr0,sprintf(',R=%3.1fMOhm,C=%3.2fnF',handles.temparams.R*10^-6,handles.temparams.C*10^9));
end
handles.dec.tkinfo{handles.dec.tkindex}=tkinfstr0;

handles.dec.tk{handles.dec.tkindex}=tk;
handles=d_update_axestk(handles);

guidata(hObject, handles);



%animation
if(~isfield(handles,'hfig_temani'))% if never created
    handles.dhfig_temani=figure(76);
    set(handles.dhfig_temani, 'MenuBar','none', 'Units',... %repositioning the new window
        'normalized','Position', [0 0.5 .6 0.47]/2);
elseif(~isvalid(handles.dhfig_temani))
    handles.dhfig_temani=figure(76);
    set(handles.dhfig_temani, 'MenuBar','none', 'Units',... %repositioning the new window
        'normalized','Position', [0 0.5 .6 0.47]/2);
else
    figure(handles.dhfig_temani);clf(handles.dhfig_temani); %figure for encoding movie
end



t=t*1000;
tk=tk*1000;
nowaxis_ut=axis(handles.axes_dAxesut);
nowaxis_tk=axis(handles.axes_dAxestk);
%subplot(211);s
nframe=200;
if(~isempty(nhm))
    postop=[0.06 .54 .55 .42];
    posbot=[0.06 0.1 .55 .39];
    posright=[0.73 0.1 0.25 0.87];
    subplot('Position', posright);cla;set(gca,'FontSize',16);
    hlimit=plot(t(1), nhm(1,1)); hold on;
    hlimit2=plot(t(1), nhm(1,1),'d','MarkerSize',7,'MarkerEdgeColor','r','MarkerFaceColor','r');
    axis([-80 40 0.30 0.8]);
else
    postop=[0.04 .53 .92 .45];
    posbot=[0.04 0.03 .92 .45];
end
htop=subplot('Position', postop);cla;set(gca,'FontSize',16);
plot(t,ut+handles.genut.b,'Color',[0.1 0.1 0.1],'LineWidth',1);hold on; 
hut=plot(t(1), ut(1)+handles.genut.b,'r','LineWidth',2);
axis(htop, 'tight');
nowaxis=axis; 
xmargin=0.1*(nowaxis(2)-nowaxis(1));
ymargin=0.1*(nowaxis(4)-nowaxis(3));
axis(htop,[nowaxis(1)-xmargin nowaxis(2)+xmargin nowaxis(3)-ymargin nowaxis(4)+ymargin]);
set(htop, 'XTick', []);

subplot('Position', posbot );cla;set(gca,'FontSize',16);
hvt=plot(t(1), vt(1),'LineWidth',1);
htk=0;
marg=(max(vt)-min(vt))/20; %margin
axis([nowaxis_tk(1:2) min(vt)-marg max(vt)+marg]);


step0=ceil(length(t)/nframe);
maxk=length(t);


istep=t(2)-t(1);
c0=clock;
fnhead=sprintf('%4d_%02d_%02d_',c0(1), c0(2),c0(3));

%make a movie
% set(handles.dhfig_temani,'DoubleBuffer','on');
% mov = moviein(0);
hfig=figure(handles.dhfig_temani);

% scrsize=get(0,'ScreenSize');figsize=[1000 600];
% set(hfig,'Color',[1 1 1],'OuterPosition',[scrsize(3)-figsize(1) scrsize(4)-figsize(2) figsize])
pos=get(hfig,'PaperPosition');
set(hfig, 'PaperSize', [8.5 4],'PaperUnits', 'inches','PaperPosition',[pos(1:2) 8.5 4]);
%set(handles.dhfig_temani,'PaperSize',[3 10]);
axis(htop, 'tight');
for k=1:nframe
    set(hut, 'XData', t(1:min(maxk,(k*step0))), 'YData', ut(1:min(maxk,(k*step0)))+handles.genut.b);
    set(hvt, 'XData', t(1:min(maxk,(k*step0))), 'YData', vt(1:min(maxk,(k*step0))));
    if(~isempty(nhm))
        set(hlimit,'XData',vt(1:min(maxk,(k*step0))),'YData',nhm(1,1:min(maxk,(k*step0))),'LineWidth',1);
        set(hlimit2,'XData',vt(min(maxk,(k*step0))),'YData',nhm(1,min(maxk,(k*step0))),'LineWidth',1);
    end
    reddot=tk(tk<=t(min(maxk,(k*step0))));
    if(length(reddot)>1)
        if(htk==0)
            htk=line(reddot,handles.temparams.threshold, 'Marker','o', 'Color', 'r', 'MarkerSize',6, 'LineStyle', 'none');
        else
            set(htk, 'XData', reddot, 'YData', vt(1+floor((reddot-t(1))/istep)));
        end
    end
    drawnow;
    bSaveMovie=true;
    if(bSaveMovie)
        print([fnhead num2str(k)], '-dtiffn', '-f76');
    end
    %mov(k)=getframe(handles.dhfig_temani);
end
%movie2avi(mov,['temani' fnhead '.avi']);

guidata(hObject, handles);



% --- Executes on button press in pushbutton_tdmall.
function pushbutton_tdmall_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_tdmall (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



function edit13_Callback(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit13 as text
%        str2double(get(hObject,'String')) returns contents of edit13 as a double


% --- Executes during object creation, after setting all properties.
function edit13_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit13 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit14_Callback(hObject, eventdata, handles)
% hObject    handle to edit14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit14 as text
%        str2double(get(hObject,'String')) returns contents of edit14 as a double


% --- Executes during object creation, after setting all properties.
function edit14_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit14 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit15_Callback(hObject, eventdata, handles)
% hObject    handle to edit15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit15 as text
%        str2double(get(hObject,'String')) returns contents of edit15 as a double


% --- Executes during object creation, after setting all properties.
function edit15_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit15 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton51.
function pushbutton51_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton51 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




% --- Executes on button press in pushbutton52.
function pushbutton52_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton52 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton53.
function pushbutton53_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton53 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton54.
function pushbutton54_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton54 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton55.
function pushbutton55_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton55 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton56.
function pushbutton56_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton56 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton57.
function pushbutton57_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton57 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton74.
function pushbutton74_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton74 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton_popup_dAxesut.
function pushbutton_popup_dAxesut_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_popup_dAxesut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

hlines=findobj('Parent',handles.axes_dAxesut, 'Type','line');
if(isempty(hlines))
    set(handles.text_msg, 'String','no line found');
    return;
end

xrange=[];
hfig=figure;axes(); xlabel('time (ms)');ylabel('I_{ext} [uA/cm^2]');hold all;
if(length(handles.dec.tk)==1)
    fname=get(handles.text_tkinfo,'String');
    nowtk=handles.dec.tk{1};
    if(~isempty(findstr(fname,'timeenc')) && length(nowtk)>1)
        subplot(212);
        hold on;
        minx=inf;
        maxx=0;

        spks=nowtk*1000;
        if(size(spks,1)>1 && size(spks,2)>1)
            %set(handles.text_msg,'String', 'spkk is a matrix. first column is taken only');
            spks=spks(:,1);
        end;

%         for i=1:length(spks)
%             line([spks(i) spks(i)], [0   1],'Color','k','Marker','^','MarkerFaceColor','k');
%         end;
        
        hline9=stem(spks, ones(1, length(spks)),'Marker','^','Color','k','MarkerFaceColor','k','BaseValue',0);
        set(get(hline9,'BaseLine'),'LineStyle','none');

%         hline9=stem(spks, ones(1, length(spks)),'Marker','none','Color','r','BaseValue',0); hold on;
%         set(get(hline9,'BaseLine'),'Line','none');
    
    
        maxx = max(spks);
        minx = min(spks);

        minx=minx-.01*(maxx-minx);
        maxx=maxx+.01*(maxx-minx);
        axis tight;
        nowaxis=axis;
        %axis([minx maxx nowaxis(3:4)]);

        xlabel('time (ms)');set(gca, 'YTick',[]);
        set(gca,'Position',[0.1 0.05 .85 0.1],'Unit','normalized');
        subplot(211);
        set(gca,'Position',[0.1 0.2 .85 0.75],'Unit','normalized');
    end
end

%haxes=copyobj(handles.axes_dAxesut, hfig);



set(hfig,'Name', 'Time Encoding/Decoding');
for k=length(hlines):-1:1
    plot(get(hlines(k),'XData'), get(hlines(k),'YData')+handles.genut.b);hold all;
end
if(~isempty(handles.d_axes1_legend))
    hlegend=legend(handles.d_axes1_legend);
    set(hlegend,'Interpreter','none');
end

hold off;
axis tight;
nowaxis=axis;
if(exist('minx','var'))
    axis([minx maxx nowaxis(3:4)]);
end
set(handles.text_msg, 'String','axes_ut popped-up!!');




% --- Executes on button press in pushbutton76.
function pushbutton76_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton76 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton77.
function pushbutton77_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton77 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton78.
function pushbutton78_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton78 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton_utrec2ut.
function pushbutton_utrec2ut_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_utrec2ut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton_savespkk.
function pushbutton_savespkk_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_savespkk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
spkk=handles.find.spkk;
%valvespk=handles.valvespk;
delta=handles.find.delta;
analmethod=handles.find.method;
save(strcat(handles.mfolder,handles.find.info.fname), 'spkk', 'delta' ,'analmethod','-append');
set(handles.text_msg, 'String', ...
    sprintf('spkk,  delta,method are appended on %s', handles.find.info.fname));


% --- Executes on button press in pushbutton100.
function pushbutton100_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton100 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton101.
function pushbutton101_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton101 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton_abf2mat.
function pushbutton_abf2mat_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_abf2mat (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(~isempty(handles.mfolder))
    abffolder=handles.mfolder(1:(end-2));
else
    abffolder=handles.nowpwd;
end


%finding all xls files
xlsfiles={};
xlsfiles1=dir(strcat(abffolder, '*.xls'));
finfo=[];
for k=1:length(xlsfiles1)
    if(xlsfiles1(k).name(1)~='.')
        xlsfiles{end+1}=strcat(abffolder,xlsfiles1(k).name);
    end
end
xlsfiles2=dir(strcat(abffolder,'m/', '*.xls'));
for i=1:length(xlsfiles2)
    found=0;
    for j=1:length(xlsfiles)
        if(strcmpi(xlsfiles1(j).name,xlsfiles2(i).name))
            found=1;
        end
    end
    if(~found && xlsfiles2(i).name(1)~='.')
        xlsfiles{end+1}=strcat(abffolder,'m/',xlsfiles2(k).name);
    end
end




finfo=[];
for k=1:length(xlsfiles)
    finfo0=readdatainf(xlsfiles{k}, handles);
    finfo=[finfo finfo0];
end


abffiles=dir(strcat(abffolder, '*.abf'));
if(isempty(abffiles))
    set(handles.text_msg,'String','no .abf files found');
    return;
else
    set(handles.text_msg,'String','abf2mat - anlyzing files... hold on...');
    drawnow;
end


%get rid of duplicate information
dupk=[];%index of duplicate file informations
for i=1:(length(finfo)-1)
    for j=(i+1):length(finfo)
        if(strcmpi(finfo(i).fname, finfo(j).fname))
            dupk=[dupk j];
        end
    end
end
index=ones(1,length(finfo));
index(dupk)=0;
finfo=finfo(index==1);



%get rid of invalid file names
notfoundk=[];%index of duplicate file informations
for k=1:length(finfo)
    if(~exist(strcat(abffolder, finfo(k).fname,'.abf')))
        notfoundk=[notfoundk k];
    end
end
index=ones(1,length(finfo));
index(notfoundk)=0;
finfo=finfo(index==1);



%add files that are not found in the information files
for i=1:length(abffiles)
    found=0;
    for j=1:length(finfo)
        if(strfind(abffiles(i).name,finfo(j).fname))
            found=1;
        end
    end
    if(~found)
        finfo(end+1).fname=abffiles(i).name(1:(end-4));
        for i=2:length(handles.infname)
            %put empty
            if(strcmpi(handles.inftype{i},'char'))
                eval(strcat('finfo(end).',handles.infname{i},'='''';'));
            elseif(strcmpi(handles.inftype{i},'num'))
                if(strfind(handles.infname{i},'/'))
                    finfo(end).pp=[];
                else
                    eval(strcat('finfo(end).',handles.infname{i},'=[];'));
                end
            end
        end
    end
end
isabf2=zeros(length(finfo),1);
for k=1:length(finfo)
    fid=fopen(strcat(abffolder, finfo(k).fname,'.abf'));
    abfver=fread(fid,8);
    if(length(abfver)<8)
        set(handles.text_msg,'String',strcat(finfo(k).fname, ' is empty'));
        return;
    end
    if(sum(abfver==[65 66 70 50 0 0 0 2]')==8)
        isabf2(k)=1;
    end
    fclose(fid);

end


[filek durcap options channelnums piddelay]=abf2mat(finfo);

if(isempty(filek))
    set(handles.text_msg,'String','abf2mat cancelled');
    return;
end

if(ispc)
    handles.mfolder=strcat(abffolder,'m\');
else
    handles.mfolder=strcat(abffolder,'m/');
end

if(~exist(handles.mfolder,'dir'))
    mkdir(handles.mfolder);
end

updateinfo=~isempty(cell2mat(strfind(options,'updateinfo')));
includeCh2=~isempty(cell2mat(strfind(options,'includeCh2')));
%digidata channel setup (recommended - 1:electrode, 2:pid, 3:controlsignal, 4:flow)
if(length(channelnums)==4)
    nch_electrode1=channelnums(1);%electrode1 channel
    nch_electrode2=channelnums(2);%electrode2 channel
    nch_pid=channelnums(3); %miniPID channel
    nch_valvecontrol=channelnums(4);%valve control signal
    % else
    %     nch_electrode1=1;%electrode1 channel
    %     nch_electrode2=2;%electrode2 channel
    %     nch_pid=3; %miniPID channel
    %     nch_valvecontrol=4;%valve control signal
end

%convert
for k=1:length(filek)
    fname = finfo(filek(k)).fname;
    clear d0 dt_usec;

    if(updateinfo && exist(strcat(handles.mfolder,fname,'.mat'),'file'))
        updateinfok=1;
    else
        updateinfok=0;
    end

    if(updateinfok)
        set(handles.text_msg, 'String',...
            strcat(fname, '.mat is updated'));
        drawnow;

        d0=[];dt=[];
    else
        if(isunix && isabf2(filek(k))==1)
            continue;
        elseif(ispc && isabf2(filek(k))==1)
            set(handles.text_msg, 'String',...
                strcat(fname, 'Axon data file(ver.2) is converted into Matlab file format'));
            drawnow;
            d0=import_abf(strcat(abffolder,fname,'.abf'));
            dt=0.1;
        else
            set(handles.text_msg, 'String',...
                strcat(fname, ' axon data file is being converted to a Matlab file'));
            drawnow;
            [d0, dt_usec] = abfload(strcat(abffolder,fname,'.abf'));
            dt=dt_usec/1000;%usec --> msec
        end
    end


    fields=fieldnames(finfo(filek(k)));
    savefields='';
    for j=1:length(fields)
        if(eval(['~isempty(finfo(filek(k)).', fields{j},')']))
            eval(strcat(fields{j},'=finfo(filek(k)).',fields{j},';'));
        elseif(eval(['~isnumeric(finfo(filek(k)).', fields{j},')']))
            eval(strcat(fields{j},'=0;'));
        else
            eval(strcat(fields{j},'='''';'));
        end
            savefields=strcat(savefields, ', ''', fields{j}, '''');
    end


    if(~isvector(d0) && ~isempty(d0))
        if(size(d0,2)==2)
            %cap the file length
            if(~isempty(durcap))
                if(durcap>0)
                    durcapk=ceil(durcap/dt*1000);
                    if(size(d0,1)>durcapk)
                        d0=d0(1:durcapk,:);
                    end
                end
            end

            d=d0(:,nch_electrode1);
            c=d0([(1+piddelay):end end*ones(1,piddelay)],nch_pid);
            matfname=strcat(handles.mfolder,fname,'.mat');

            if(exist(matfname,'file'))
                eval(strcat('save(matfname,''-append'',''d'',''dt'',''c''', savefields, ');'));
            else
                eval(strcat('save(matfname,''d'',''dt'',''c''', savefields, ');'));
            end
        elseif(size(d0,2)==4)
            %adding offset to time to compensate noisy time delay of clampex
            startk=find(d0(:,nch_valvecontrol)>0.05+d0(1,nch_valvecontrol),1,'first');

            if(~isempty(startk))
                %offsetk=round(stimstart/dt-startk);
                offsetk=-startk;

                if(offsetk<100/dt)
                    %if the offset is shorter than 100msec
                    if(offsetk<0)
                        d0= d0((-offsetk):end,:);
                    elseif(offsetk>0)
                        d0= [zeros(offsetk,4); d0];
                        d0(1:offsetk,1)=d0(offsetk+1,1);
                        d0(1:offsetk,2)=d0(offsetk+1,2);
                        d0(1:offsetk,3)=d0(offsetk+1,3);
                    end
                end
            end

            if(~isempty(durcap))
                if(durcap>0)
                    durcapk=ceil(durcap/dt*1000);
                    if(size(d0,1)>durcapk)
                        d0=d0(1:durcapk,:);
                    end
                end
            end
            d=d0(:,nch_electrode1);
            c=d0([(1+piddelay):end end*ones(1,piddelay)],nch_pid);
            %c=d0(:,nch_pid);

            matfname=strcat(handles.mfolder,fname,'.mat');

            if(exist(matfname,'file'))
                eval(strcat('save(matfname,''-append'',''d'',''dt'',''c''', savefields, ');'));
            else
                eval(strcat('save(matfname,''d'',''dt'',''c''', savefields, ');'));
            end

            if(includeCh2)
                d=d0(:,nch_electrode2);
                fname=strcat(fname,'b');
                matfname=strcat(handles.mfolder,fname,'.mat');

                if(exist(matfname,'file'))
                    eval(strcat('save(matfname,''-append'',''d'',''dt'',''c''', savefields, ');'));
                else
                    eval(strcat('save(matfname,''d'',''dt'',''c''', savefields, ');'));
                end
            end
        else
            %cap the file length
            if(~isempty(durcap))
                if(durcap>0)
                    durcapk=ceil(durcap/dt*1000);
                    if(size(d0,1)>durcapk)
                        d0=d0(1:durcapk,:);
                    end
                end
            end

            set(handles.text_msg, 'String',...
                strcat(fname, '.abf is splited into multiple files'));
            drawnow;
            for kk=1:size(d0,2)
                for jj=1:size(d0,3)
                    d=d0(:,kk,jj);
                    matfname=sprintf('%s/%s%s%03d',handles.mfolder,fname, char('a'+kk-1),jj);
                    if(exist(matfname,'file'))
                        eval(strcat('save(matfname,''-append'',''d'',''dt''', savefields, ');'));
                    else
                        eval(strcat('save(matfname,''d'',''dt''', savefields, ');'));
                    end
                end
            end
        end
    elseif(isvector(d0))
        d=d0;
        matfname=strcat(handles.mfolder,fname,'.mat');
        if(exist(matfname,'file'))
            eval(strcat('save(matfname,''-append'',''d'',''dt''', savefields, ');'));
        else
            eval(strcat('save(matfname,''d'',''dt''', savefields, ');'));
        end
    elseif(isempty(d0))
        %update info fields only
        matfname=strcat(handles.mfolder,fname,'.mat');
        eval(strcat('save(matfname,''-append''', savefields, ');'));
        if(includeCh2)
            fname=strcat(fname,'b');
            matfname=strcat(handles.mfolder,fname,'.mat');
            eval(strcat('save(matfname,''-append''', savefields, ');'));
        end
    end

    
    %plot the data file..
    set(handles.text_fInfo,'String',inf2str(finfo(filek(k))));
    cla(handles.axes_find1);cla(handles.axes_find2);

    if(~isempty(d0))
        axes(handles.axes_find1);
        plot((1:length(d))*dt-dt, d);drawnow;
    end
    %plot the main one
    
    eval(strcat('clear(''d'',''dt''',savefields,');'));
    
end

set(handles.text_msg,'String','abf2mat completes');

handles=updateflist(handles);

guidata(hObject,handles);


% --- Executes on button press in pushbutton103.
function pushbutton103_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton103 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on slider movement.
function slider_finddeltax_Callback(hObject, eventdata, handles)
% hObject    handle to slider_finddeltax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

handles.deltax_sliderval=get(hObject,'Value');
guidata(hObject,handles);

% --- Executes during object creation, after setting all properties.
function slider_finddeltax_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider_finddeltax (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in pushbutton_detectspikes.
function pushbutton_detectspikes_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_detectspikes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

p2pchangetolerance=handles.p2pchangetolerance;
isichangetolerance=handles.isichangetolerance;

if(isempty(handles.find.anal))
    set(handles.text_msg,'String','no analysis data found');
    return;
end
if(length(handles.find.anal)~=length(handles.find.delta))
    set(handles.text_msg,'String','threshold length is different from the data length');
    return;
end
if(size(handles.find.anal,1)~=size(handles.find.delta,1))
    d = handles.find.anal';
else
    d = handles.find.anal;
end
d(d<handles.find.delta)=min(handles.find.delta);
d=d-min(handles.find.delta);
if(max(d)<=0)
    set(handles.text_msg, 'String','threshold too high');
    handles.spkk=[];
    if(ishandle(handles.find.hreddot))
        set(handles.find.hreddot, 'XData', [], 'YData', []);
    end
    set(handles.pushbutton_savespkk, 'Enable', 'on');
    guidata(hObject, handles);
    return;
end


%here March 17th, 2007

minISI=handles.minISI;
% switch lower(handles.find.celltype)
%     case {'vpn', 'pn'}
%         minISI=3; %PN : 3msec
%     case {'ln', 'gh298'}
%         minISI=8;
%     case 'ab1'
%         minISI=1.4;
%     case 'ab1c'
%         minISI=1.4;
%     case 'ab2'
%         minISI=1.4;
%     case 'ab2a'
%         minISI=1.4;
%     case 'abx'
%         minISI=1.4;
%     case 'orn'
%         minISI=1.4;
%     otherwise
%         minISI=3;
% end

dt=handles.find.t(2)-handles.find.t(1);
maxk = round(minISI/dt); %3msec : maximum interval of non-zero value interval
[dout, diam]=pickpeaksonly(d, maxk);
redk=find(ne(dout,0));
if(size(redk,2)==1)redk=redk';end%make it a row vector

%adjust the location of red circles based upon the spike shape 02/24/2008
[value7 index]=max(handles.find.d((max(1,redk(1)-maxk):(redk(1)+maxk))));
redk(1)=index+max(1,redk(1)-maxk)-1;
for i=2:(length(redk)-1)
    [value7 index]=max(handles.find.d((redk(i)-maxk):(redk(i)+maxk)));
    redk(i)=index+redk(i)-maxk-1;
end
[value7 index]=max(handles.find.d((redk(end)-maxk):min(length(handles.find.d),redk(end)+maxk)));
redk(end)=index+redk(end)-maxk-1;

tooclosek=find(diff(redk)<maxk);
if(~isempty(tooclosek))
    dropk=zeros(size(redk));
    dropk(tooclosek)=1;
    dropk(tooclosek+1)=1;
    for i=1:length(tooclosek)
        if(handles.find.d(redk(tooclosek(i)))>=handles.find.d(redk(tooclosek(i)+1)))
            dropk(tooclosek(i))=0;
        else
            dropk(tooclosek(i)+1)=0;
        end
    end
    redk=redk(~dropk);
end

if(length(redk)>3)
    if(max(handles.find.delta)==min(handles.find.delta))
        %check the amplitude of spikes and take out ones with too rapid change
        %lsidek=round(1/dt);
        rsidek=round(1.5/dt);
        spkheight(1)=handles.find.d(redk(1))-min(handles.find.d(redk(1):(redk(1)+rsidek)));

        temp=1:rsidek;
        temp=repmat(redk(2:(end-1))',1,length(temp))+repmat(temp, length(redk)-2,1);
        allspikewaveforms=handles.find.d(temp);

        spkheight=[spkheight; handles.find.d(redk(2:(end-1)))-min(allspikewaveforms,[],2)]';

        spkheight(end+1)=handles.find.d(redk(end))-...
            min(handles.find.d((redk(end)):min(length(handles.find.d),(redk(end)+rsidek))));



        %remove too much varying amplitude spikes
        if(isempty(handles.find.info.stimstart))
            beforestimk=length(redk);
            med1=median(spkheight(1:beforestimk));
            spkdropk=((spkheight-med1)>p2pchangetolerance*med1*2)|((spkheight-med1)<-p2pchangetolerance*med1);
        else
            beforestimk=find(redk*dt<handles.find.info.stimstart+80,1,'last');
            med1=median(spkheight(1:beforestimk));
            spkdropk=((spkheight-med1)>p2pchangetolerance*med1*2)|((spkheight-med1)<-p2pchangetolerance*med1);
            %        stimperiod=handles.find.info.stimdur+handles.find.info.stimpause;
            stimperiod=sum(handles.find.info.stimdur);
            med2=0;
            if(stimperiod<100) %if it's alternating very fast
                afterstimk=find(redk*dt<handles.find.info.stimstart+handles.find.info.npulses*stimperiod+100,1,'last');
                for j=(beforestimk+1):afterstimk
                    if(((spkheight(j)-med1)<med1*p2pchangetolerance*2) &&((spkheight(j)-med1)>-med1*p2pchangetolerance))
                        spkdropk(j)=0;
                        continue;
                    end

                    %update med2 if this spike is out of the med1 range
                    if(med2==0)
                        med2=median(spkheight(j:(j+2)));
                    end

                    if(spkheight(j)<med1 && spkheight(j)>med2)
                        spkdropk(j)=0;
                        continue;
                    end

                    if(((spkheight(j)-med2)<med2*p2pchangetolerance*2) &&((spkheight(j)-med2)>-med2*p2pchangetolerance))
                        spkdropk(j)=0;
                        continue;
                    end

                    newmed2=(med2+median(spkheight(j:(j+2))))/2;

                    if(((spkheight(j)-newmed2)<newmed2*p2pchangetolerance*2)...
                            &&((spkheight(j)-newmed2)>-newmed2*p2pchangetolerance))
                        spkdropk(j)=0;
                        med2=newmed2;
                    end

                    if(2*redk(j)-redk(j-1) -redk(j+1) < isichangetolerance*(redk(j+1)-redk(j-1))/2)
                        %by the regularity of interspike interval
                        spkdropk(j)=0;
                    end

                end
            else
                if(handles.find.info.npulses>0)
                    for i=1:handles.find.info.npulses
                        afterstimk=find(redk*dt<handles.find.info.stimstart+sum(handles.find.info.stimdur)+stimperiod*(i-1)+100,1,'last');%100msec of maximum delay
                        spkdropk((beforestimk+1):afterstimk)=1;
                        for j=(beforestimk+1):afterstimk
                            if(((spkheight(j)-med1)<med1*p2pchangetolerance*2) &&((spkheight(j)-med1)>-med1*p2pchangetolerance))
                                spkdropk(j)=0;
                                continue;
                            end

                            %update med2 if this spike is out of the med1 range
                            if(med2==0)
                                med2=median(spkheight(j:(j+2)));
                            end

                            if(spkheight(j)<med1 && spkheight(j)>med2)
                                spkdropk(j)=0;
                                continue;
                            end

                            if(((spkheight(j)-med2)<med2*p2pchangetolerance*2) &&((spkheight(j)-med2)>-med2*p2pchangetolerance))
                                spkdropk(j)=0;
                                continue;
                            end

                            if(j<length(spkheight)-2)
                                newmed2=median(spkheight(j:(j+2)));


                                if(((spkheight(j)-newmed2)<newmed2*p2pchangetolerance*2)...
                                        &&((spkheight(j)-newmed2)>-newmed2*p2pchangetolerance))
                                    spkdropk(j)=0;
                                    med2=newmed2;
                                end
                            end
                            if(j<length(spkheight)-1)
                                if(2*redk(j)-redk(j-1) -redk(j+1) < isichangetolerance*(redk(j+1)-redk(j-1))/2)
                                    %by the regularity of interspike interval
                                    spkdropk(j)=0;
                                end
                            end
                        end
                        beforestimk=afterstimk;
                    end
                end
            end
            if(med2==0) med2=med1-0.01*med1;end
        end
        % spkdropk((afterstimk+1):end)=spkdropk((afterstimk+1):end) & ...
        %     (abs(spkheight((afterstimk+1):end)-med1)>p2pchangetolerance*med1);
        % spkdropk((afterstimk+1):end)=spkdropk((afterstimk+1):end) & ...
        %     (abs(spkheight((afterstimk+1):end)-med2)>p2pchangetolerance*med2);
        % spkdropk((afterstimk+1):end)=spkdropk((afterstimk+1):end) & ...
        %     ~(abs(spkheight((afterstimk+1):end))<med1 & abs(spkheight((afterstimk+1):end))>med2);

        redk=redk(~spkdropk(1:length(redk)));
    end

end

reddot=handles.find.d(redk);
handles.find.spkk=redk;



if(ishandle(handles.find.hreddot))
    set(handles.find.hreddot, 'XData', redk*dt, 'YData', reddot);
else
    axes(handles.axes_find1)
    handles.find.hreddot=line(redk*dt, reddot,'Color','r','Marker','o','LineStyle','none');
end


handles.find.info.nspks=length(handles.find.spkk);

guidata(hObject, handles);

set(handles.text_msg, 'String', strcat(num2str(length(redk)),' spk(s) detected'));
set(handles.text_fInfo,'String',inf2str(handles.find.info));
%pushbutton_zoomspks_Callback(handles.pushbutton_zoomspks,eventdata,handles);




% --- Executes on button press in pushbutton_fcwt.
function pushbutton_fcwt_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_fcwt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.find.d))
    set(handles.text_msg,'String','no data loaded');
    return;
end

set(handles.text_msg, 'String', 'cwt(...) is being computed... please hold on..');
drawnow;

kwavename=get(handles.popupmenu_wavename,'Value');
kwaveorder=get(handles.popupmenu_waveorder,'Value');
wavescale=str2num(get(handles.edit_wavescale,'String'));
if(isempty(wavescale))
    set(handles.text_msg, 'String', 'cwt(x) error : wavescale is improper');
    return;
end

wavenames=get(handles.popupmenu_wavename,'String');
waveorders=get(handles.popupmenu_waveorder,'String');
wavename=wavenames{kwavename};
waveorder=waveorders{kwaveorder};

%h = waitbar(.2,'Please wait...');

anal=cwt(handles.find.d, wavescale, strcat(wavename, waveorder));
if(size(anal,1)>1)
    for k=1:size(anal,1)
        anal(k,:)=anal(k,:)./max(anal(k,:));
    end
    anal0=sum(anal,1);
    anal0(1:500)=0;
    anal0((end-499):end)=0;
else
    anal0=anal;
end
handles.find.method=strcat('cwt', wavename, waveorder, num2str(wavescale));
handles.find.anal=anal0;
handles=plot_anal(handles);
set(handles.text_msg, 'String', 'cwt is completed');
drawnow;


guidata(hObject,handles);



% --- Executes on button press in pushbutton_fdiff.
function pushbutton_fdiff_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_fdiff (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.find.d))
    set(handles.text_msg,'String','no data loaded');
    return;
end

handles.find.anal=[0; diff(handles.find.d)];
handles.find.method='diff';
handles=plot_anal(handles);
set(handles.text_msg, 'String', 'diff(x) is plotted');
guidata(hObject,handles);




% --- Executes on slider movement.
function slider_finddeltay_Callback(hObject, eventdata, handles)
% hObject    handle to slider_finddeltay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
if(isempty(handles.find.hdeltaline) | isempty(handles.find.delta))
    return;
end
if(~ishandle(handles.find.hdeltaline))
    return;
end
nowaxis=axis(handles.axes_find2);

handles.find.delta=handles.find.delta-mean(handles.find.delta)...
    +diff(nowaxis(3:4))*get(hObject,'Value')+nowaxis(3);
handles=plotthreshold(handles,1);
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function slider_finddeltay_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider_finddeltay (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on selection change in popupmenu_wavename.
function popupmenu_wavename_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_wavename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_wavename contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_wavename


% --- Executes during object creation, after setting all properties.
function popupmenu_wavename_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_wavename (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on selection change in popupmenu17.
function popupmenu17_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu17 contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu17


% --- Executes during object creation, after setting all properties.
function popupmenu17_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu17 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_wavescale_Callback(hObject, eventdata, handles)
% hObject    handle to edit_wavescale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_wavescale as text
%        str2double(get(hObject,'String')) returns contents of edit_wavescale as a double


% --- Executes during object creation, after setting all properties.
function edit_wavescale_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_wavescale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_fcwtx.
function pushbutton_fcwtx_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_fcwtx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.find.d))
    set(handles.text_msg,'String','no data loaded');
    return;
end

set(handles.text_msg, 'String', 'cwt(...) is being computed... please hold on..');
drawnow;


dt=handles.find.t(2)-handles.find.t(1);
ks=ceil(4500/dt):ceil(6500/dt);

kwavename=get(handles.popupmenu_wavename,'Value');
kwaveorder=get(handles.popupmenu_waveorder,'Value');

wavenames=get(handles.popupmenu_wavename,'String');
waveorders=get(handles.popupmenu_waveorder,'String');
wavename=cell2mat(wavenames(kwavename));
waveorder=cell2mat(waveorders(kwaveorder));

a=[0.1 0.2 0.5 1 2 5:15:65 80:20:140];
anal=cwt(handles.find.d(ks), a, strcat(wavename, waveorder));
anal=anal./(max(abs(anal'))'*ones(1,size(anal,2)));%normalize it

edgew=ceil(100/dt)
figure;
h=imagesc(handles.find.t(ks((edgew+1):(end-edgew))), a, abs(anal(:,(edgew+1):(end-edgew))));
xlabel(h, 'String', 'time (ms)');
ylabel(h, 'String', 'scale');
title(h, 'String', 'cwt of d(4.6 to 6.4 sec)');

set(handles.text_msg, 'String','cwt(x) is plotted with the scale of: [0.1 0.2 1 2 5:15:65 80:20:140');





% --- Executes on button press in pushbutton_fbypass.
function pushbutton_fbypass_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_fbypass (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.find.d))
    set(handles.text_msg,'String','no data loaded');
    return;
end
handles.find.anal=handles.find.d;
handles.find.method='bypass';
handles=plot_anal(handles);
set(handles.text_msg, 'String', 'x is plotted');
guidata(hObject,handles);



function handles=plot_anal(handles)
if(~get(handles.checkbox_keepdelta,'Value') | isempty(handles.find.hdeltaline))
    axes(handles.axes_find2);
    plot(handles.find.t,handles.find.anal);
    %     if(ishandle(handles.find.hdeltaline))
    %         delete(handles.find.hdeltaline);
    %         handles.find.delta=[];
    %     end
    handles=resetfdelta(handles);
else
    %to keep the delta line
    hblueline=findobj(handles.axes_find2,'Type','line','Color','b');
    if(isempty(hblueline))
        plot(handles.axes_find2, handles.find.t, handles.find.anal);
    else
        set(hblueline,'XData',handles.find.t,'YData',handles.find.anal);
    end
    handles=resetfdelta(handles);
end

axes(handles.axes_find2);
axis auto;

updatefindaxesxrange(handles);




function handles=resetfdelta(handles)
%compute delta

if(isempty(handles.find.delta))
    [n xout]=hist(handles.find.anal,40);
    twentiethpeak=xout(find(n>40,1,'last'));%find the point where twenty highest peak is
    meananal=mean(handles.find.anal);
    delta0=(twentiethpeak-meananal)*handles.fresetthresholdbase+meananal;
    % switch lower(celltype)
    %     case {'ln','gh298'}
    %     case 'ab1'
    %     otherwise
    % end

    handles.find.delta=delta0*ones(size(handles.find.anal));
end

handles=plotthreshold(handles);







%
% % --- Executes on button press in pushbutton137.
% function pushbutton137_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton137 (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in checkbox_fInvertD.
function checkbox_fInvertD_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_fInvertD (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.fInvertD=get(hObject,'Value');
guidata(hObject,handles);


% --- Executes on selection change in popupmenu_fmacro.
function popupmenu_fmacro_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_fmacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_fmacro contents as cell array
%        contents{get(hObject,'Value')} returns selected item from
%        popupmenu_fmacro


% --- Executes during object creation, after setting all properties.
function popupmenu_fmacro_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_fmacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String',{'cwt->detect 1' 'spike sorting','bypass & detect'  'cwt & detect' 'diff & detect'});



% --- Executes on button press in pushbutton_frunmacro.
function pushbutton_frunmacro_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_frunmacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% if(handles.find.escmacro)
%    handles.find.escmacro=0;
%    guidata(hObject, handles);
% end
set(handles.togglebutton_fescmacro, 'Enable', 'on','Value',0);
macrostr=get(handles.popupmenu_fmacro,'String');
macroval=get(handles.popupmenu_fmacro,'Value');
switch lower(macrostr{macroval})
    case 'spike sorting'
        if(strcmpi(get(handles.popupmenu_flist, 'String'),'no data file'))
            set(handles.text_msg,'String','no data file found');
            return;
        end

        set(handles.checkbox_keepdelta, 'Value',0);

        while(1)
            %load the file
            pushbutton_load1_Callback(handles.pushbutton_load1, eventdata, handles);
            handles=guidata(hObject);
            drawnow;


            if(~isempty(handles.find.d) && ~isempty(handles.find.t))


                pushbutton_sortspikes_Callback(handles.pushbutton_fbypass, eventdata, handles);
                drawnow;
                handles=guidata(hObject);


                pushbutton_savespkk_Callback(handles.pushbutton_savespkk, eventdata, handles);
                handles=guidata(hObject);
                drawnow;

            end;
            %set the file name for the next loop
            if(length(get(handles.popupmenu_flist, 'String')) > get(handles.popupmenu_flist, 'Value'))
                %move to the next file
                pushbutton_nextfile_Callback(handles.pushbutton_nextfile, eventdata, handles)
                drawnow;
            else
                %quit the loop
                break;
            end

            handles=guidata(hObject);
            if(get(handles.togglebutton_fescmacro,'Value'))
                break;
            end


        end


    case 'bypass & detect' %bypass and auto threshold
        if(strcmpi(get(handles.popupmenu_flist, 'String'),'no data file'))
            set(handles.text_msg,'String','no data file found');
            return;
        end

        %set(handles.checkbox_keepdelta, 'Value',0);

        while(1)
            %load the file
            pushbutton_load1_Callback(handles.pushbutton_load1, eventdata, handles);
            handles=guidata(hObject);
            drawnow;


            if(~isempty(handles.find.d) && ~isempty(handles.find.t))

                %bypass it to the analysis pane
                pushbutton_fbypass_Callback(handles.pushbutton_fbypass, eventdata, handles);
                drawnow;
                handles=guidata(hObject);

                if(~get(handles.checkbox_keepdelta, 'Value'))
                    pushbutton_resetdelta_Callback(handles.pushbutton_resetdelta, eventdata, handles);
                    drawnow;
                    handles=guidata(hObject);
                end

                %detect spikes
                pushbutton_detectspikes_Callback(handles.pushbutton_detectspikes, eventdata, handles);
                handles=guidata(hObject);
                drawnow;

                pushbutton_savespkk_Callback(handles.pushbutton_savespkk, eventdata, handles);
                handles=guidata(hObject);
                drawnow;

            end;
            %set the file name for the next loop
            if(length(get(handles.popupmenu_flist, 'String')) > get(handles.popupmenu_flist, 'Value'))
                %move to the next file
                pushbutton_nextfile_Callback(handles.pushbutton_nextfile, eventdata, handles)
                drawnow;
            else
                %quit the loop
                break;
            end

            handles=guidata(hObject);
            if(get(handles.togglebutton_fescmacro,'Value'))
                break;
            end


        end

    case 'cwt->detect 1'
        if(strcmpi(get(handles.popupmenu_flist, 'String'),'no data file'))
            set(handles.text_msg,'String','no data file found');
            return;
        end

        %      set(handles.checkbox_keepdelta, 'Value',0);

        %load the file
        pushbutton_load1_Callback(handles.pushbutton_load1, eventdata, handles);
        handles=guidata(hObject);
        drawnow;

        if(~isempty(handles.find.d) && ~isempty(handles.find.t))

            %bypass it to the analysis pane
            pushbutton_fcwt_Callback(handles.pushbutton_fcwt, eventdata, handles);
            drawnow;
            handles=guidata(hObject);

            if(~get(handles.checkbox_keepdelta, 'Value'))
                pushbutton_resetdelta_Callback(handles.pushbutton_resetdelta, eventdata, handles);
                drawnow;
                handles=guidata(hObject);
            end

            %detect spikes
            pushbutton_detectspikes_Callback(handles.pushbutton_detectspikes, eventdata, handles);
            handles=guidata(hObject);
            drawnow;

            pushbutton_savespkk_Callback(handles.pushbutton_savespkk, eventdata, handles);
            handles=guidata(hObject);
            drawnow;

        end;

        if(~isempty(handles.find.info.stimdur))
            if(sum(handles.find.info.stimdur)*handles.find.info.npulses<100)
                handles.find.xrange=([-50 150]+handles.find.info.stimstart);
            else
                handles.find.xrange=([0 sum(handles.find.info.stimdur)*handles.find.info.npulses]+...
                    handles.find.info.stimstart)+[-.2 .2]*sum(handles.find.info.stimdur)*handles.find.info.npulses;
            end
            updatefindaxesxrange(handles);
            drawnow;
        end
        
        pushbutton_nextfile_Callback(handles.pushbutton_nextfile, eventdata, handles)


    case 'cwt & detect' %cwt and auto threshold
        if(strcmpi(get(handles.popupmenu_flist, 'String'),'no data file'))
            set(handles.text_msg,'String','no data file found');
            return;
        end

        %      set(handles.checkbox_keepdelta, 'Value',0);

        while(1)
            %load the file
            pushbutton_load1_Callback(handles.pushbutton_load1, eventdata, handles);
            handles=guidata(hObject);
            drawnow;

            if(~isempty(handles.find.d) && ~isempty(handles.find.t))

                %bypass it to the analysis pane
                pushbutton_fcwt_Callback(handles.pushbutton_fcwt, eventdata, handles);
                drawnow;
                handles=guidata(hObject);

                if(~get(handles.checkbox_keepdelta, 'Value'))
                    pushbutton_resetdelta_Callback(handles.pushbutton_resetdelta, eventdata, handles);
                    drawnow;
                    handles=guidata(hObject);
                end

                %detect spikes
                pushbutton_detectspikes_Callback(handles.pushbutton_detectspikes, eventdata, handles);
                handles=guidata(hObject);
                drawnow;

                pushbutton_savespkk_Callback(handles.pushbutton_savespkk, eventdata, handles);
                handles=guidata(hObject);
                drawnow;

            end;
            %set the file name for the next loop
            if(length(get(handles.popupmenu_flist, 'String')) > get(handles.popupmenu_flist, 'Value'))
                %move to the next file
                pushbutton_nextfile_Callback(handles.pushbutton_nextfile, eventdata, handles)
                drawnow;
            else
                %quit the loop
                break;
            end

            handles=guidata(hObject);
            if(get(handles.togglebutton_fescmacro,'Value'))
                break;
            end
            if(~isempty(handles.find.info.npulses))
                if(sum(handles.find.info.stimdur)*handles.find.info.npulses<100)
                    handles.find.xrange=([-50 150]+handles.find.info.stimstart);
                else
                    handles.find.xrange=([0 sum(handles.find.info.stimdur)*handles.find.info.npulses]+...
                        handles.find.info.stimstart)+[-.2 .2]*sum(handles.find.info.stimdur)*handles.find.info.npulses;
                end
                updatefindaxesxrange(handles);
                drawnow;
            end

        end

    case 'diff & detect'
        %diff and auto threshold
        if(strcmpi(get(handles.popupmenu_flist, 'String'),'no data file'))
            set(handles.text_msg,'String','no data file found');
            return;
        end

        %set(handles.checkbox_keepdelta, 'Value',0);

        while(1)
            %load the file
            pushbutton_load1_Callback(handles.pushbutton_load1, eventdata, handles);
            handles=guidata(hObject);
            drawnow;


            if(~isempty(handles.find.d) && ~isempty(handles.find.t))

                %bypass it to the analysis pane
                pushbutton_fdiff_Callback(handles.pushbutton_fbypass, eventdata, handles);
                drawnow;
                handles=guidata(hObject);


                if(~get(handles.checkbox_keepdelta, 'Value'))
                    pushbutton_resetdelta_Callback(handles.pushbutton_resetdelta, eventdata, handles);
                    drawnow;
                    handles=guidata(hObject);
                end


                %detect spikes
                pushbutton_detectspikes_Callback(handles.pushbutton_detectspikes, eventdata, handles);
                handles=guidata(hObject);
                drawnow;

                pushbutton_savespkk_Callback(handles.pushbutton_savespkk, eventdata, handles);
                handles=guidata(hObject);
                drawnow;

            end;
            %set the file name for the next loop
            if(length(get(handles.popupmenu_flist, 'String')) > get(handles.popupmenu_flist, 'Value'))
                %move to the next file
                pushbutton_nextfile_Callback(handles.pushbutton_nextfile, eventdata, handles)
                drawnow;
            else
                %quit the loop
                break;
            end

            handles=guidata(hObject);
            if(get(handles.togglebutton_fescmacro,'Value'))
                break;
            end


        end
end
%guidata(hObject, handles);
set(handles.togglebutton_fescmacro, 'Enable', 'off','Value',0);



% --- Executes on button press in pushbutton_find.escmacro.
% function pushbutton_fescmacro_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_find.escmacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%
% handles.find.escmacro=1;
% guidata(hObject, handles);


% --- Executes on button press in pushbutton_stretch_deltaslider.
function pushbutton_stretch_deltaslider_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_stretch_deltaslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val = get(handles.slider_finddeltax, 'SliderStep');
val(2)= 1/(1/(1+val(2)) -0.075)-1;
if(val(2)<0) val(2)=1500; end
%step : y=1-1/(1+x) (y=width of scrollbar, x=max_step)
set(handles.slider_finddeltax, 'SliderStep', val);
handles.deltax_sliderstep=val;
guidata(hObject,handles);


% --- Executes on button press in pushbutton_shorten_deltaslider.
function pushbutton_shorten_deltaslider_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_shorten_deltaslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
val = get(handles.slider_finddeltax, 'SliderStep');
val(2) = max(0.03, 1/(1/(1+val(2)) +0.075)-1); %step : 0.1 (curve : e^(log(2)*x)-1)
set(handles.slider_finddeltax, 'SliderStep', val);
handles.deltax_sliderstep=val;
guidata(hObject,handles);

% --- Executes on button press in pushbutton_deltapushup.
function pushbutton_deltapushup_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_deltapushup (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.find.delta) | isempty(handles.find.hdeltaline))
    return;
end
val = get(handles.slider_finddeltax, 'Value');
sliderstep = get(handles.slider_finddeltax, 'SliderStep');
scrollbarwidth =1-1/(1+sliderstep(2));
val = val*(1-scrollbarwidth);

startx = max(0,val);
endx= min(1, val+scrollbarwidth);

%reduce the range from 0.01 to 0.99
startx = startx*0.97+0.015;
endx = endx*0.97+0.015;

if(startx>endx)
    endx=startx+0.01;
end;

nowaxis=axis(handles.axes_find2);

startt=nowaxis(1)+(nowaxis(2)-nowaxis(1))*startx;
endt=nowaxis(1)+(nowaxis(2)-nowaxis(1))*endx;
dt=handles.find.t(2)-handles.find.t(1);
startk = round(startt/dt);
endk = round(endt/dt);

inc=ones(1,endk-startk+1).*diff(nowaxis(3:4))./50;%step pulse like increase
%inc =sin(pi*((startk:endk)-startk)./(endk-startk+1)).*diff(nowaxis(3:4))./50;%sin-like increase
if(size(handles.find.delta,2)==1)
    inc=inc';
end
handles.find.delta(startk:endk)=handles.find.delta(startk:endk)+inc;
set(handles.find.hdeltaline, 'YData', handles.find.delta)
guidata(hObject,handles);



% --- Executes on button press in pushbutton_deltapushdown.
function pushbutton_deltapushdown_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_deltapushdown (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.find.delta) || isempty(handles.find.hdeltaline))
    return;
end
val = get(handles.slider_finddeltax, 'Value');
sliderstep = get(handles.slider_finddeltax, 'SliderStep');
scrollbarwidth =1-1/(1+sliderstep(2));
val = val*(1-scrollbarwidth);

startx = max(0,val);
endx= min(1, val+scrollbarwidth);

%reduce the range from 0.01 to 0.99
startx = startx*0.97+0.015;
endx = endx*0.97+0.015;

if(startx>endx)
    endx=startx+0.01;
end;

nowaxis=axis(handles.axes_find2);

startt=nowaxis(1)+(nowaxis(2)-nowaxis(1))*startx;
endt=nowaxis(1)+(nowaxis(2)-nowaxis(1))*endx;
dt=handles.find.t(2)-handles.find.t(1);
startk = round(startt/dt);
endk = round(endt/dt);

dec = ones(1,endk-startk+1).*diff(nowaxis(3:4))./50;%"step pulse"-like decrease
%dec=sin(pi*((startk:endk)-startk)./(endk-startk+1)).*diff(nowaxis(3:4))./50; %"sin wave"-like decrease
if(size(handles.find.delta,2)==1)
    dec=dec';
end
handles.find.delta(startk:endk)=handles.find.delta(startk:endk)-dec;
set(handles.find.hdeltaline, 'YData', handles.find.delta)
guidata(hObject,handles);




% --- Executes on button press in pushbutton_savedelta.
function pushbutton_savedelta_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_savedelta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton_resetdelta.
function pushbutton_resetdelta_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_resetdelta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.find.delta=[];
if(~isempty(handles.find.hdeltaline))
    if(ishandle(handles.find.hdeltaline))
        delete(handles.find.hdeltaline);
    end
end
handles=resetfdelta(handles);
guidata(hObject,handles);


% --- Executes on button press in checkbox_keepdelta.
function checkbox_keepdelta_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_keepdelta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_keepdelta
handles.keepdelta=get(handles.checkbox_keepdelta,'Value');
guidata(hObject, handles);

% --- Executes on button press in pushbutton_cla_dAxesut.
function pushbutton_cla_dAxesut_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_cla_dAxesut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% cla(handles.axes_dAxesut); xlabel('time (ms)');
% hold(handles.axes_dAxesut,'off');
% legend('off');
% handles.d_axes1_legend=[];
% if(~isempty(handles.dec.ut))
%    axes(handles.axes_dAxesut);
%    plot(handles.dec.t*1000,handles.dec.ut);
%    axis tight;
% end
if(length(handles.dec.ut)<1)
    set(handles.text_msg,'String','nothing to clear');
    return;
end
listofu=get(handles.popupmenu_listofu,'String');
nowutk=get(handles.popupmenu_listofu,'Value');
set(handles.popupmenu_listofu,'String',listofu(nowutk),'Value',1);
handles.dec.ut=handles.dec.ut(nowutk);
handles.dec.t=handles.dec.t(nowutk);

handles.dec.t_hat=[];
handles.dec.uhatt=[];
handles.dec.G=[];
handles.dec.ck=[];

handles=update_dec_ut(handles);

guidata(hObject, handles);


% --- Executes on button press in pushbutton_dec_exportdata.
function pushbutton_dec_exportdata_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dec_exportdata (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if(isempty(handles.dec.ut))
    set(handles.text_msg','no data to export');
end

for k=1:length(handles.dec.ut)
    assignin('base', sprintf('t%02d', k), handles.dec.t{k});
    assignin('base', sprintf('u%02d', k), handles.dec.ut{k});
end
set(handles.text_msg, 'String','data are exported (tnn, unn)');


% --- Executes on button press in pushbutton_dec_showerror.
function [t err]=pushbutton_dec_showerror_Callback(hObject, eventdata, handles, src_dst)
% hObject    handle to pushbutton_dec_showerror (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(length(handles.dec.ut)<2)
    set(handles.text_msg,'String', 'at least two data must be present');
    t=[];err=[];
    return;
end

if(nargin<4)
    src_dst=[];
elseif(length(src_dst)~=2 || ~iscell(src_dst))
    src_dst=[];
end

nowtk=handles.dec.tk{handles.dec.tkindex};

if(isempty(src_dst))
    defAns{1}='1';
    defAns{2}='2';

    input0 = inputdlg({'index of uxx','index of uyy'}, 'computing uxx-uyy', [1 1]', defAns);
    if(isempty(input0)) return; end; %if 'cancel' button clicked

    if(size(input0) ==[2 1])
        v1k=str2num(input0{1});
        v2k=str2num(input0{2});
    else
        warndlg('invalid inputs: type a number in each field');
        return;
    end;

else
        v1k=(src_dst{1});
        v2k=(src_dst{2});
end

if(min(v1k)<=0 || min(v2k)<=0||max(v1k)>length(handles.dec.ut) || max(v2k)>length(handles.dec.ut))
    warndlg('invalid inputs: index out of range');
    return;
end;

legendstr={};
t={}; err={};
for i=1:length(v1k)
    for j=1:length(v2k)
        v1=handles.dec.ut{v1k(i)};
        v2=handles.dec.ut{v2k(j)};
        t1=handles.dec.t{v1k(i)};
        t2=handles.dec.t{v2k(j)};


        if(isempty(v1) || isempty(v2) || isempty(t1)||isempty(t2))
            set(handles.text_msg,'String', 'some necessary data empty');
            return;
        end

        dt=t1(2)-t1(1);
        if(t1(1)<t2(1))
            firstk=1;
            mint=t1(1);
        else
            firstk=find(t1>t2(1), 1, 'first');
            mint=t1(firstk);
        end
        maxt=min(t1(end),t2(end));

        t{end+1}=mint:dt:maxt;
        v1=v1((1:length(t{end}))+firstk-1);
        v2=interp1(t2, v2, t{end}, 'spline');

        %computing the error of the recovery  based on the threshold
        dt_rec=t2(2)-t2(1);
        spkk = round((nowtk-t{end}(1))/dt)+1;

        sk=(nowtk(2:end)+nowtk(1:(end-1)))/2;

        err{end+1}=v2-v1;
        if(nargin==3)
            figure(505);plot(t{end}*1000, err{end}); hold all;
            legendstr{end+1}=strcat('u', num2str(v1k(i)), '-u', num2str(v2k(j)));
        end
    end
end
% for i=2:length(nowtk)
%     delta1=handles.temparams.threshold(min(i,length(handles.temparams.threshold)));
%     e1(i-1)=sum(v2(spkk(i-1):(spkk(i)-1))+handles.genut.b)*dt-delta1;
% end
% stem(sk*1000, e1, 'r');
legend(legendstr);
xlabel('time (ms)');ylabel('ut_{rec}-ut');
title('recovery error');


% --- Executes on button press in pushbutton_2decode.
function pushbutton_2decode_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_2decode (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(handles.vNowaxes==0)
    set(handles.text_msg, 'String', 'no data found');
    return;
end

if(~isempty(handles.vAxesinfo(handles.vNowaxes).spkk))
    spkt=handles.vAxesinfo(handles.vNowaxes).spkk*handles.vAxesinfo(handles.vNowaxes).dt/1000+...
        handles.vAxesinfo(handles.vNowaxes).t0;
    handles.dec.tkindex=length(handles.dec.tkinfo)+1;
    handles.dec.tkinfo{handles.dec.tkindex}=handles.vAxesinfo(handles.vNowaxes).fname;
    handles.dec.tk{handles.dec.tkindex}=spkt;
    handles=d_update_axestk(handles);
end

if(~isempty(handles.vAxesinfo(handles.vNowaxes).c))
    cc=handles.vAxesinfo(handles.vNowaxes).c;
    tt=(((1:length(handles.vAxesinfo(handles.vNowaxes).c))-1)*handles.vAxesinfo(handles.vNowaxes).dt...
        +handles.vAxesinfo(handles.vNowaxes).t0)/1000;
    
    if(isempty(handles.vAxesinfo(handles.vNowaxes).stimstart))
        handles.vAxesinfo(handles.vNowaxes).stimstart=5000;
    end
    cc=cc-mean(cc(tt*1000<handles.vAxesinfo(handles.vNowaxes).stimstart &...
        tt*1000>handles.vAxesinfo(handles.vNowaxes).stimstart-500));
    
    if(isfield(handles.vAxesinfo(handles.vNowaxes),'ppmfactor'))
        if(~isempty(handles.vAxesinfo(handles.vNowaxes).ppmfactor))
            cc=handles.vAxesinfo(handles.vNowaxes).ppmfactor*cc;
        end
    end     
    
    
    handles.dec.ut{1}=cc;
    handles.dec.t{1}=tt;
    handles.dec.ut=handles.dec.ut(1);
    handles.dec.t=handles.dec.t(1);
    handles=update_dec_ut(handles);
    set(handles.text_dec1info,'String',strcat('odor concentration - ',...
        handles.vAxesinfo(handles.vNowaxes).fname));
end

%handles.activetab=3;
if(~isempty(handles.vAxesinfo(handles.vNowaxes).c) || ~isempty(handles.vAxesinfo(handles.vNowaxes).spkk))
    handles.activetab=3;
    updatetab(handles);
end

guidata(hObject, handles);




% --- Executes on button press in pushbutton_popup_tks.
function pushbutton_popup_tks_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_popup_tks (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if(length(handles.dec.tk)<1)
    set(handles.text_msg, 'String','no spike train to plot');
    return;
end



minx=inf;
maxx=0;
if(length(handles.dec.tk)>6)
    colormap(hsv(length(handles.dec.tk)));
else
    colormap(lines(length(handles.dec.tk)));
end
cm=colormap;cm=flipud(cm);

for k=1:length(handles.dec.tk)
    spks=handles.dec.tk{k};

    if(size(spks,1)>1 && size(spks,2)>1)
        %set(handles.text_msg,'String', 'spkk is a matrix. first column is taken only');
        spks=spks(:,1);
    end;

    figure(11);
    h=stem(spks, ones(1, length(spks))*k+.2,'Marker','none','Color',cm(k,:),'BaseValue',k-.2); hold on;
    set(get(h,'BaseLine'),'Line','none');

    dt=0.0001;
    t=spks(1):dt:(spks(end)+dt);
    vt=zeros(size(t));
    vt(ceil((spks-spks(1))/dt)+1)=1;
    %     figure(11);
    %     hold all;
    %     plot(t,cumsum(vt));

    maxx = max(maxx, max(spks));
    minx = min(minx, min(spks));
end;
hold off;

%
%
% minx=minx-.01*(maxx-minx);
% maxx=maxx+.01*(maxx-minx);
% nowaxis=axis;
% axis([minx maxx 0.5 length(handles.dec.tk)+.5]);
%
%
% for k=1:length(handles.dec.tk)
%     if(length(handles.dec.tkinfo{k})~=0)
%         line([0 maxx], [k   k]','Color', 'k');
%         text((maxx-minx)*.2+minx, k+.35, ...
%             handles.dec.tkinfo{k}, 'Interpreter', 'none');
%     end
% end;


xlabel('time[sec]');
htitle=title('flyspikes: spike trains');
set(htitle,'Interpreter','none');


% --- Executes on button press in pushbutton_cla_dAxestk.
function pushbutton_cla_dAxestk_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_cla_dAxestk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=clrtk(handles);
guidata(hObject, handles);

%
% % --- Executes on button press in pushbutton_vExportc.
% function pushbutton_vExportc_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton_vExportc (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% for k=1:handles.vNumaxes
%     c{k}=handles.vAxesinfo(k).c;
% end
% assignin('base', 'c', c);
% set(handles.text_msg,'String','c{i}=concentration profile of ith axes');
%

% --- Executes on button press in pushbutton_dAxesut_psd.
function pushbutton_dAxesut_psd_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dAxesut_psd (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% if(handles.vNumaxes==0)
%     set(handles.text_msg,'String','no axes found');
%     return;
% end
nowutk=get(handles.popupmenu_listofu,'Value');
if(length(handles.dec.ut)<nowutk || length(handles.dec.t) <nowutk)
    set(handles.text_msg,'String', 'psd plotting failed: some data missing(ut, t, f)');
    return;
end

ut=handles.dec.ut{nowutk};

if(isempty(ut))
    set(handles.text_msg,'String', 'psd plotting failed: some data missing(ut, t, f)');
    return;
end

dt=1;
if(~isempty(handles.dec.t{nowutk}))
    dt=handles.dec.t{nowutk}(2)-handles.dec.t{nowutk}(1);
end


[Pxx, f]=periodogram(ut, [],length(ut), 1/dt);
figure(78);clf;semilogx(f, 10*log10(Pxx));grid on;
htitle=title(strcat('periodogram of ', get(handles.text_dec1info,'String')));
set(htitle,'Interpreter','none');
xlabel('frequency [Hz]');ylabel('Power/frequency [dB/Hz]');



function edit_genut2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_genut2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_genut2 as text
%        str2double(get(hObject,'String')) returns contents of edit_genut2 as a double
pushbutton_genut2_Callback(handles.pushbutton_genut2, eventdata, handles);

%
%
% % --- Executes during object creation, after setting all properties.
% function edit_genut2_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to edit_genut2 (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
%
% % Hint: edit controls usually have a white background on Windows.
% %       See ISPC and COMPUTER.
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end


% --- Executes on selection change in popupmenu_dmacrolist.
function popupmenu_dmacrolist_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_dmacrolist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_dmacrolist contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_dmacrolist


% --- Executes during object creation, after setting all properties.
function popupmenu_dmacrolist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_dmacrolist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on button press in togglebutton_dEscmacro.
function togglebutton_dEscmacro_Callback(hObject, eventdata, handles)
% hObject    handle to togglebutton_dEscmacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on selection change in popupmenu_dMacrolist.
function popupmenu_dMacrolist_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_dMacrolist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_dMacrolist contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_dMacrolist


% --- Executes during object creation, after setting all properties.
function popupmenu_dMacrolist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_dMacrolist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String',{'test hohu4d III', 'test hohu4d II', 'test Morris-Lecar','test hohu4d', 'test uniform tdm', 'hohu f-I','vftdm0','model2', 'tfestimate','feedforward&iaf','LPF','deltaC/C','12_10_32_3psds'});


% --- Executes during object creation, after setting all properties.
function popupmenu_listofu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_listofu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_dRunmacro.
function pushbutton_dRunmacro_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dRunmacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
str=get(handles.popupmenu_dMacrolist,'String');
if(isempty(str)) set(handles.text_msg,'String','no macro defined');
    return;
end
macroname=str{get(handles.popupmenu_dMacrolist,'Value')};


switch(macroname)
    case 'test hohu4d III'
        %testing Hodgkin-Huxley neuron/direct decoding for known/unknown
        %PRCs
        savefname0=['testhohu4d3' num2str(datestr(clock,30))];
%         savefname0=['testhohu4dII201031c'];
        
        %c=[.1:1 1.2:.2:3 3.5:.5:60];
        %c=[.2:.1:.9];
        c=[0:.1:2 2.25:.25:5 5.5:.5:25];
        
        nrepeat=30;
        f=20;
        handles.genut.K=20;
        handles.genut.npadding=10;
        handles.genut.b=25;
        handles.genut.t0=0;
        
        for i=1:length(c)
            handles.genut.c=c(i);
            guidata(hObject,handles);
            handles=update_tem_params(handles,'updategui');
            for j=1:nrepeat
                pushbutton_clearall_Callback(handles.figure1,eventdata,handles);
                handles=guidata(handles.figure1);
                update_genut_params(handles);

                pushbutton_genut_Callback(handles.pushbutton_genut, [], handles)
                handles=guidata(handles.figure1);

                set(handles.popupmenu_encmethod,'Value',6);%tem, hohu4d
                pushbutton_tem_Callback(handles.pushbutton_tem, [],handles);
                handles=guidata(handles.figure1);

                %set(handles.popupmenu_decmethod,'Value',12);%tdm, hohu4d -floquet
                set(handles.popupmenu_decmethod,'Value',13);%tdm, hohu4d -direct
                pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                handles=guidata(handles.figure1);
                ut{j}=handles.dec.ut{1};
                t{j}=handles.dec.t{1};
                uthat{j}=handles.dec.ut{2};
                that{j}=handles.dec.t{2};
                err{j}=uthat{j}-interp1(t{j},ut{j},that{j});
                tk{j}=handles.dec.tk{1};
                
                
                if(0)
                    set(handles.popupmenu_decmethod,'Value',15);%tdm, hohu4d - fixed b
                    pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                    uthat2{j}=handles.dec.ut{3};
                    that2{j}=handles.dec.t{3};
                    err2{j}=uthat2{j}-interp1(t{j},ut{j},that2{j});
                    tk2{j}=handles.dec.tk{2};
                end
                pause(1);
            end
                genutparams=handles.genut;
            save([savefname0 num2str(c(i)) 'pAdirect.mat'], 't',...
                'ut', 'uthat', 'that', 'tk', 'genutparams','err');%,'uthat2','that2','err2','tk2');
        end
        
        
    case 'test hohu4d II'
        %testing Hodgkin-Huxley neuron/direct decoding for known/unknown
        %PRCs
        savefname0=['testhohu4dIII' num2str(datestr(clock,30))];
%         savefname0=['testhohu4dII201031c'];
        
        %c=[.1:1 1.2:.2:3 3.5:.5:60];
        %c=[.2:.1:.9];
        c=[0:.1:2 2.2:.25:5 5.5:.5:20];
        
        nrepeat=25;
        f=20;
        handles.genut.K=20;
        handles.genut.npadding=10;
        handles.genut.b=25;
        handles.genut.t0=0;
        
        for i=1:length(c)
            handles.genut.c=c(i);
            guidata(hObject,handles);
            handles=update_tem_params(handles,'updategui');
            for j=1:nrepeat
                pushbutton_clearall_Callback(handles.figure1,eventdata,handles);
                handles=guidata(handles.figure1);
                update_genut_params(handles);

                pushbutton_genut_Callback(handles.pushbutton_genut, [], handles)
                handles=guidata(handles.figure1);

                set(handles.popupmenu_encmethod,'Value',6);%tem, hohu4d
                pushbutton_tem_Callback(handles.pushbutton_tem, [],handles);
                handles=guidata(handles.figure1);

                %set(handles.popupmenu_decmethod,'Value',12);%tdm, hohu4d -floquet
                set(handles.popupmenu_decmethod,'Value',13);%tdm, hohu4d -direct
                pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                handles=guidata(handles.figure1);
                ut{j}=handles.dec.ut{1};
                t{j}=handles.dec.t{1};
                uthat{j}=handles.dec.ut{2};
                that{j}=handles.dec.t{2};
                err{j}=uthat{j}-interp1(t{j},ut{j},that{j});
                tk{j}=handles.dec.tk{1};
                
                
                if(0)
                    set(handles.popupmenu_decmethod,'Value',15);%tdm, hohu4d - fixed b
                    pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                    uthat2{j}=handles.dec.ut{3};
                    that2{j}=handles.dec.t{3};
                    err2{j}=uthat2{j}-interp1(t{j},ut{j},that2{j});
                    tk2{j}=handles.dec.tk{2};
                end
                pause(1);
            end
                genutparams=handles.genut;
            save([savefname0 num2str(c(i)) 'pAdirect.mat'], 't',...
                'ut', 'uthat', 'that', 'tk', 'genutparams','err');%,'uthat2','that2','err2','tk2');
        end
        
    case 'test Morris-Lecar'
        c=[0:2.5:60];
        nrepeat=50;
        f=20;
        handles.genut.K=12;
        handles.genut.npadding=8;
        handles.genut.b=5;
        handles.genut.t0=0;
        
        for i=1:length(c)
            handles.genut.c=c(i);
            guidata(hObject,handles);
            handles=update_tem_params(handles,'updategui');
            for j=1:nrepeat
                pushbutton_clearall_Callback(handles.figure1,eventdata,handles);
                handles=guidata(handles.figure1);
                update_genut_params(handles);

                pushbutton_genut_Callback(handles.pushbutton_genut, [], handles)
                handles=guidata(handles.figure1);

                set(handles.popupmenu_encmethod,'Value',7);%tem, morris-lecar
                pushbutton_tem_Callback(handles.pushbutton_tem, [],handles);
                handles=guidata(handles.figure1);

                %set(handles.popupmenu_decmethod,'Value',12);%tdm, hohu4d -floquet
                set(handles.popupmenu_decmethod,'Value',14);%tdm, morris-lecar -direct
                pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                handles=guidata(handles.figure1);
                ut{j}=handles.dec.ut{1};
                t{j}=handles.dec.t{1};
                uthat{j}=handles.dec.ut{2};
                that{j}=handles.dec.t{2};
                err{j}=uthat{j}-interp1(t{j},ut{j},that{j});
                tk{j}=handles.dec.tk{1};
                
            end
                %pause(1);
                genutparams=handles.genut;
            save(['testML20090808c' num2str(c(i)) 'pAdirect.mat'], 't',...
                'ut', 'uthat', 'that', 'tk', 'genutparams','err');
        end
        
        
        
    
    case 'test hohu4d'
        c=[5:2.5:60];
        nrepeat=50;
        f=20;
        handles.genut.K=12;
        handles.genut.npadding=8;
        handles.genut.b=8;
        handles.genut.t0=0;
        
        for i=1:length(c)
            handles.genut.c=c(i);
            guidata(hObject,handles);
            handles=update_tem_params(handles,'updategui');
            for j=1:nrepeat
                pushbutton_clearall_Callback(handles.figure1,eventdata,handles);
                handles=guidata(handles.figure1);
                update_genut_params(handles);

                pushbutton_genut_Callback(handles.pushbutton_genut, [], handles)
                handles=guidata(handles.figure1);

                set(handles.popupmenu_encmethod,'Value',6);%tem, hohu4d
                pushbutton_tem_Callback(handles.pushbutton_tem, [],handles);
                handles=guidata(handles.figure1);

                %set(handles.popupmenu_decmethod,'Value',12);%tdm, hohu4d -floquet
                set(handles.popupmenu_decmethod,'Value',13);%tdm, hohu4d -direct
                pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                handles=guidata(handles.figure1);
                ut{j}=handles.dec.ut{1};
                t{j}=handles.dec.t{1};
                uthat{j}=handles.dec.ut{2};
                that{j}=handles.dec.t{2};
                err{j}=uthat{j}-interp1(t{j},ut{j},that{j});
                tk{j}=handles.dec.tk{1};
                
                pause(1);
            end
                genutparams=handles.genut;
            save(['testhohu4d20090703c' num2str(c(i)) 'pAdirect.mat'], 't',...
                'ut', 'uthat', 'that', 'tk', 'genutparams','err');
        end
        
        
        
        
    case 'test uniform tdm'
        set(handles.togglebutton_dEscmacro,'Enable','on','Value',0);
        set(handles.popupmenu_encmethod,'Value',1);%ideal i-a-f
        handles.genut.K=21;
        handles.genut.npadding=10;
        handles.genut.t0=0;
        handles.genut.c=1;
        handles.genut.b=0.5;
        handles.genut.f=50;
        guidata(hObject,handles);

        nrepeat=10;
        delta=([3:10 12:2:20])*10^-3;
        err=[];
        for i=1:length(delta)
            handles.temparams.threshold=delta(i);
            handles=update_tem_params(handles,'updategui');
            for j=1:nrepeat
                pushbutton_clearall_Callback(handles.figure1,eventdata,handles);
                handles=guidata(handles.figure1);
                update_genut_params(handles);
                
                pushbutton_genut_Callback(handles.pushbutton_genut, [], handles)
                handles=guidata(handles.figure1);
                
                pushbutton_tem_Callback(handles.pushbutton_tem, [],handles);
                handles=guidata(handles.figure1);
                
                set(handles.popupmenu_decmethod,'Value',1);%ideal i-a-f
                pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                handles=guidata(handles.figure1);
                ut{i,j}=handles.dec.ut{1};
                t{i,j}=handles.dec.t{1};
                tk{i,j}=handles.dec.tk{1};
                kappa(i,j,1)=cond(handles.dec.G);
                ck{i,j,1}=handles.dec.ck;

                set(handles.popupmenu_decmethod,'Value',21);%ideal i-a-f - uniform tdm
                pushbutton_tdm_Callback(handles.pushbutton_tdm, [],handles);
                handles=guidata(handles.figure1);
                kappa(i,j,2)=cond(handles.dec.G);
                ck{i,j,2}=handles.dec.ck;
                
                [t5 err5]=pushbutton_dec_showerror_Callback(handles.pushbutton_dec_showerror, ...
                    [], handles, {1 [2 3]});
                handles=guidata(handles.figure1);
                figure(64);clf;
                for k=1:2
                    err(i,j,k)=sum(abs(err5{k}(t5{k}>0 & t5{k}<.2)))*(t5{k}(2)-t5{k}(1));
                    plot(t5{k}(t5{k}>0 & t5{k}<.2),err5{k}(t5{k}>0 & t5{k}<.2)); hold all;
                end
                if(get(handles.togglebutton_dEscmacro,'Value')==1)
                    break;
                end
            end
            if(get(handles.togglebutton_dEscmacro,'Value')==1)
                break;
            end
            figure(65);clf;plot(err(i,:,1));hold all; plot(err(i,:,2));
            legend({'err for nonuniform tdm','err for uniform tdm'});
            xlabel('time (ms)');
            ylabel('$error :   \hat{u}-u$','interpreter','latex');
            title(['threshold=',num2str(delta(i)*1000)]);
            datepostfix=num2str(datestr(clock,30));
            save(['test_uniform_tdm_' datepostfix(1:8)], 'ck','kappa','err','delta','t','ut','tk');
        end
        
        set(handles.togglebutton_dEscmacro,'Enable','off','Value',0);        
        
        
    case 'hohu f-I'
        
        I=[4:10 12:2:20 25:5:50];
        set(handles.popupmenu_encmethod,'Value',5);%hohu
        handles.genut.K=3;
        handles.genut.npadding=0;
        handles.genut.t0=0;
        handles.genut.c=0;
        handles.genut.f=10;
        guidata(hObject,handles);

        for i=1:length(I)
            handles.genut.b=I(i);
            pushbutton_clearall_Callback(handles.figure1,eventdata,handles);
            handles=guidata(handles.figure1);
            update_genut_params(handles);
            
            pushbutton_genut_Callback(handles.pushbutton_genut, [], handles)
            handles=guidata(handles.figure1);
            pushbutton_tem_Callback(handles.pushbutton_tem, [],handles);
            handles=guidata(handles.figure1);

            f(i)=length(handles.dec.tk{1})/(handles.dec.t{1}(end)-handles.dec.t{1}(1));
        end
                
        assignin('base','fIx',I);
        assignin('base','fIy',f);
        figure;plot(I,f,'k.');

                
    case 'vftdm0'
        %c=[1];
        c=1;%[1 2 3 4.2 5.5];
        %        threshold0=[20 12 7.5 5];
        threshold0=20:-0.5:5;
        %c=6;
        f=5:1:90;
        %f=50;
        %         c=[3];
        %         f=[4 30 50 70];
        set(handles.popupmenu_encmethod,'Value',1);
        set(handles.popupmenu_decmethod,'Value',1);
        set(handles.edit_dC,'String','0.1');
        set(handles.edit_dR,'String','700');
        handles.genut.K=55;
        handles.genut.npadding=30;
        handles.genut.b=0;
        handles.genut.t0=-0.015;
        handles.genut.c=1;
        guidata(hObject,handles);

        for jj=1:10
            jj
            sTk=(rand(1,handles.genut.K+2*handles.genut.npadding)*.5-0.25)+1;
            for i=1:length(threshold0)
                pushbutton_clearall_Callback(handles.figure1,eventdata,handles);
                handles=guidata(handles.figure1);
                handles.genut.f=50;
                set(handles.edit_tem_threshold,'String',num2str(threshold0(i)));

                update_genut_params(handles);

                T=1/handles.genut.f/2; %Nyquist rate
                dt = T/500; % 1500 samples in T
                t=handles.genut.t0+((-T*handles.genut.npadding):dt:((handles.genut.K+handles.genut.npadding)*T));
                st = zeros(size(t));



                sTk([1:handles.genut.npadding (end-handles.genut.npadding+1):end])=1;%threshold0(i)/5;

                for k=1:length(sTk)
                    st = st + sTk(k).*sinc(2*handles.genut.f.*(t-(k-1-handles.genut.npadding).*T-handles.genut.t0));
                end
                ut=st;

                if(~isempty(handles.dec.t));
                    if(length(t)==length(handles.dec.t))
                        if(sum(ut~=handles.dec.ut)==0) %if ut is the same as handles.dec.ut
                            set(handles.text_msg, 'String', 'ut is not changed');
                            return; %no update
                        end
                    end
                end

                handles.dec.G=[];
                handles.dec.ck=[];
                handles.dec.uhatt=[];
                handles.dec.t_hat=[];
                handles.genut.fname='';


                handles.dec.ut={};
                handles.dec.t={};

                handles.dec.ut{1}=ut;
                handles.dec.t{1}=t;

                % axes(handles.axes_dAxesut);
                % plot(t*1000,ut);axis tight;
                set(handles.text_msg, 'String', 'u(t) created');
                handles=clrtk(handles);

                handles.dec.xrange=[t(1) t(end)]*1000;
                handles=update_dec_ut(handles);


                set(handles.text_dec1info, 'String',...
                    sprintf('f=%1.1fHz, b=%1.1fnA, c=%1.1fnA, K=%1.1f, t0=%1.0fmsec, #padding=%1.0f',...
                    handles.genut.f, handles.genut.b, handles.genut.c, handles.genut.K,...
                    handles.genut.t0, handles.genut.npadding));

                handles.genut.f=f(1);
                update_genut_params(handles);

                guidata(hObject,handles);
                pushbutton_tem_Callback(handles.pushbutton_tem, [],handles);
                handles=guidata(handles.figure1);

                nowtk=handles.dec.tk{handles.dec.tkindex};
                spikerate(jj,i)=length(nowtk(nowtk>0 & nowtk<0.5))/.5;
                maxisi(jj,i)=max(diff(nowtk(nowtk>0 & nowtk<0.5)));
                %figure(33);clf;plot(handles.dec.t{1},handles.dec.ut{1});hold all;
                for j=1:length(f)
                    %use  recovery frequency different from the input frequency
                    handles.genut.f=f(j);
                    update_genut_params(handles);

                    figure(handles.figure1);
                    pushbutton_tdm_Callback(handles.pushbutton_tdm, [], handles);
                    handles=guidata(handles.figure1);
                    [t5 err5]=pushbutton_dec_showerror_Callback(handles.pushbutton_dec_showerror,...
                        [], handles, {[1] [(j+1)]});
                    err6=err5{end}(t5{end}>0 & t5{end}<0.5);
                    err(j,i,jj)=sqrt(sum(err6.^2)/length(err6));
                    %figure(33);plot(handles.dec.t{j+1},handles.dec.ut{j+1});
                    %plot(f(1:j),10*log(err(1:j,i,jj)));title(['c=' num2str(handles.genut.c)]);
                end
                tk=handles.dec.tk{handles.dec.tkindex};
                ut=handles.dec.ut{1};
                t=handles.dec.t{1};
                save(['VFTDM_undersampling_rmse' num2str(datestr(clock,30))],'err', 'c','f', 'spikerate','maxisi','ut','t','tk');
            end
            figure(34);clf;imagesc(c,f,10*log(err(:,:,jj)));
        end



        %save('VFTDM_undersampling_rmse','err', 'c','f', 'spikerate','maxisi');
        assignin('base','err',err);
        assignin('base','c',c);
        assignin('base','f',f);
        assignin('base','spikerate',spikerate);
        assignin('base','maxisi',maxisi);
        err=mean(err,3);

        figure;
        imagesc(mean(spikerate,1)*2,f,(10*log10(err)));
        hold on;
        %plot(c,nyquistrate,'wo');
        xlabel('local spike rate[Hz]');
        ylabel('frequency[Hz]');
        title('RMSE of time decoding [dB]');
        colorbar;

    case 'model2'
        nowutk=get(handles.popupmenu_listofu,'Value');
        if(length(handles.dec.ut)<nowutk || length(handles.dec.t)<nowutk)
            set(handles.text_msg,'String', 'macro failed: some data missing(ut, t)');
            return;
        end

        dt=handles.dec.t{nowutk}(2)-handles.dec.t{nowutk}(1);
        t0=handles.dec.t{nowutk};
        c0=handles.dec.ut{nowutk}-mean(handles.dec.ut{nowutk}(1:ceil((4.9-t0(1))/dt)));
        spkt=handles.dec.tk{handles.dec.tkindex};


        [num, den]=butter(1, 30/(1/2/dt),'low');
        c=filter(num,den,c0);%utlog);
        c=c(ceil(0.001/dt):end);
        t=t0(1:(end-ceil(0.001/dt)+1));%advancing

        c=c(ceil(0.021/dt):end);%cut some in the left end
        t=t(ceil(0.021/dt):end);

        t1=handles.dec.t{2};
        out=handles.dec.ut{2};
        out=interp1(t1,out,t,'spline');
        figure(34);hold all;plot(t,out./(c)');


        % %          kert=(0:dt:6);
        % % %         fb_ker1=zeros(size(kert));fb_ker1(1:ceil(.04/dt))=1;
        % %          fb_ker2=(exp(-kert/1.5)-exp(-kert/0.001));
        % %          fb_len=length(kert);%length of the feedback kernel
        % %          %b=zeros(size(t));
        % %          b2=ones(size(t));
        % %          endb=length(t);
        % %          spkk=1+ceil((spkt-t(1))/dt);
        % %          for k=1:length(spkk)
        % %              if(spkt(k)>t(1))
        % %                  endk=min(fb_len, endb-spkk(k)+1);
        % %                  minb=min(b2(spkk(k):end));
        % %                  if(exp((-1+minb)*3)>minb)
        % %                     impact=minb;
        % %                  else
        % %                     impact=minb;%exp((-1+minb)*4);
        % %                  end
        % %
        % %                  b2((1:endk)+spkk(k)-1)=b2((1:endk)+spkk(k)-1)-impact*fb_ker2(1:endk);
        % % %                 b((1:endk)+spkk(k)-1)=b((1:endk)+spkk(k)-1)+fb_ker1(1:endk);
        % %              end
        % %          end
        % %
        % %          figure;plot(t,b2);

        %          newindex=length(handles.dec.ut)+1;
        %          handles.dec.t{newindex}=t;
        %          handles.dec.ut{newindex}=c'.*b2;
        %          handles=update_dec_ut(handles,'addlastonly');
        %                   guidata(hObject,handles);
        %fb_ker=exp(-(0:dt:0.25)/0.005);%feedback kerenl
        %fb_ker=ones(1,ceil(0.04/dt));

        %          c1=1./(1+exp(-(c-0.01)/100));
        %
        %          kert=(0:dt:2);
        %          fb_ker1=.3*exp(-kert/0.015);
        %          fb_ker2=.02*(exp(-kert/.5)-exp(-kert/0.05));
        %          fb_len=length(fb_ker1);%length of the feedback kernel
        %          b=zeros(size(t));b2=zeros(size(t));
        %          endb=length(b);
        %          spkk=1+ceil((spkt-t(1))/dt);
        %          for k=1:length(spkk)
        %              if(spkt(k)>t(1))
        %                  endk=min(fb_len, endb-spkk(k)+1);
        %                  b2((1:endk)+spkk(k)-1)=b2((1:endk)+spkk(k)-1)+fb_ker2(1:endk);
        %                  b((1:endk)+spkk(k)-1)=b((1:endk)+spkk(k)-1)+(1-b2(spkk(k)))*fb_ker1(1:endk);
        %              end
        %          end
        %
        %          figure;plot(t,out./(c+.01)',t,b2*15+5);

        %          newindex=length(handles.dec.ut)+1;
        %          handles.dec.t{newindex}=t;
        %          handles.dec.ut{newindex}=c'.*(b+6)/6;
        %          handles=update_dec_ut(handles,'addlastonly');



        %          b(1)=0;dc(1)=0;base(1)=0;
        %          dc0=diff([0; c]);
        %          w1=ceil(0.5/dt);%for base level
        %          w2=ceil(0.025/dt);%for difference

        %         b(1)=0;a(1)=0;
        %
        %         tau1=4000;
        %         tau2=4000;
        %         dwellk=ceil(0.01/dt);
        %
        %         for k=1:(length(c)-1)
        %            db1=a(max(1,k-dwellk));
        %            db2=dt*tau2*(1-b(k)+db1)*log(1+c(k));
        %            b(k+1)=b(k)+db2-db1;
        %            a(k+1)=db2;
        %            d(k+1)=db1;
        %         end
        %
        %         figure;plot(t,b);

        %          dcdt=diff(c)/dt;
        %
        %
        %
        %         %initial condition
        %         m(1)=0;
        %         h(1)=0;
        %         I(1)=0;
        %         taum=1/5;
        %         tauh=1/5;
        %
        %         for k=1:(length(t)-1)
        %             dm=dt/taum*(dcdt(k)*(1-m(k))*exp(-h(k)+.3));
        %             m(k+1)=m(k)+dm;
        %             dh=dt/tauh*(m(k)-h(k));
        %             h(k+1)=h(k)+dh;
        %         end
        %         figure;

    case 'tfestimate'
        nowutk=get(handles.popupmenu_listofu,'Value');
        if(length(handles.dec.ut)<nowutk || length(handles.dec.t)<nowutk)
            set(handles.text_msg,'String', 'macro failed: some data missing(ut, t)');
            return;
        end

        %handles.dec.ut{1} is input
        %handles.dec.ut{2} is output
        if(length(handles.dec.ut)<1) return; end
        set(handles.popupmenu_listofu,'Value',1);
        pushbutton_cla_dAxesut_Callback(handles.pushbutton_clearall,...
            eventdata, handles);
        handles=guidata(hObject);


        pushbutton_zoomrange_Callback(handles.pushbutton_zoomrange,...
            eventdata,handles,'noverbose',[4 8]);
        handles=guidata(hObject);

        pushbutton_cutout_Callback(handles.pushbutton_dCutout, eventdata, handles)
        handles=guidata(hObject);

        x=handles.dec.ut{1};
        t1=handles.dec.t{1};

        set(handles.popupmenu_decmethod,'Value',11);
        pushbutton_tdm_Callback(handles.pushbutton_tdm, eventdata, handles)
        handles=guidata(hObject);

        pushbutton_zoomrange_Callback(handles.pushbutton_zoomrange,...
            eventdata,handles,'noverbose',[5.4 6.9]);
        handles=guidata(hObject);

        pushbutton_cutout_Callback(handles.pushbutton_dCutout, eventdata, handles)
        handles=guidata(hObject);

        x=handles.dec.ut{1};
        t1=handles.dec.t{1};
        y=handles.dec.ut{2};
        t2=handles.dec.t{2};

        if(length(t2)~=length(t1))
            y=interp1(t2,y,t1,'spline');
            t2=t1;
        end

        [Txy,F] = tfestimate(x,y,[],[],2^nextpow2(length(x)),1/(t1(2)-t1(1)));
        ht=ifft(Txy);
        figure(81);hold all; plot(F,real(Txy));
        figure(82);hold all;plot((1:length(ht))*(t1(2)-t1(1))*1000,abs(ht));


    case '12_10_32_3psds'
        ut=handles.dec.ut{nowutk};
        t=handles.dec.t{nowutk};
        dt=t(2)-t(1);

        ut1=ut(round((5.4-t(1))/dt):round((6-t(1))/dt));
        ut2=ut(round((6.1-t(1))/dt):round((6.32-t(1))/dt));
        [Pxx1, f1]=periodogram(ut1, [],length(ut1), 1/dt);
        [Pxx2, f2]=periodogram(ut2, [],length(ut1), 1/dt);


        figure(78);clf;semilogx(f1, 10*log10(Pxx1),f2, 10*log10(Pxx2));grid on;
        xlabel('frequency [Hz]');ylabel('Power/frequency [dB/Hz]');
        legend('5.4-6sec','6.1-6.32sec');


    case 'feedforward&iaf'
        nowutk=get(handles.popupmenu_listofu,'Value');
        if(length(handles.dec.ut)<nowutk || length(handles.dec.t)<nowutk)
            set(handles.text_msg,'String', 'macro failed: some data missing(ut, t)');
            return;
        end

        dt=handles.dec.t{nowutk}(2)-handles.dec.t{nowutk}(1);
        t=handles.dec.t{nowutk};
        ut=handles.dec.ut{nowutk}-mean(handles.dec.ut{nowutk}(1:ceil((4.5-t(1))/dt)))+.5;
        %        utlog=log(handles.dec.ut{nowutk}-mean(handles.dec.ut{nowutk}(1:ceil(4.5/dt)))+.01)-log(0.01);

        [num, den]=butter(1, 20/(1/2/dt),'low');
        u=filter(num,den,ut);%utlog);
        u=u(ceil(0.001/dt):end);
        t20=handles.dec.t{nowutk}(1:(end-ceil(0.001/dt)+1));%aduancing

        delay0=0.031;
        [num, den]=butter(1, 5/(1/2/dt),'low');
        w=filter(num,den,ut);%utlog);
        w=w(1:(end-ceil(delay0/dt)+1));
        t4=handles.dec.t{nowutk}(ceil(delay0/dt):end);%shifting right

        leftk=round((t4(1)-t20(1))/dt);
        rightk=round((t4(end)-t20(end))/dt);
        t20=t20((leftk+1):end);u=u((leftk+1):end);
        w=w(1:(end-rightk));t4=t4(1:(end-rightk));

        beta=0.9;
        utout=(u-w*beta);
        utout(utout<0)=0;
        %         w=w*100;u=u*100;
        %         z(1)=0.1;
        %         for k=1:(length(t4)-1)
        %             z(k+1)=z(k)+dt*((-w(k)^2-u(k)^3)*z(k)+u(k)^3);
        %         end

        newindex=length(handles.dec.ut)+1;
        handles.dec.ut{newindex} = utout;
        handles.dec.t{newindex}=t20;
        handles=update_dec_ut(handles,'addlastonly');
        guidata(hObject, handles);



        %         tk=[];
        %
        %         ut=handles.dec.ut{nowutk};
        %         t=handles.dec.t{nowutk};
        %         if(isempty(ut) | isempty(t))
        %             set(handles.text_msg,'String', 'macro failed: some necessary data empty(ut, t)');
        %             return;
        %         end
        %
        %         dt=t(2)-t(1);
        %         delayk=ceil(0.3/dt); %delay in Sec
        %         tau=0.07; %time constant in Sec(for the leaky integration)
        %         a=200;
        %         %filtering by 100Hz
        %         [num, den]=butter(10, 100/(1/2/dt), 'low');
        %         ut=filter(num,den,ut);
        %
        %         ut=ut-mean(ut(1:round(1/dt)));
        %         expkernel=a*((0:dt:0.4)+.001).*exp(-(0:dt:0.4)./tau);
        %         v=conv(ut,expkernel)*dt;
        %         v=v(length(expkernel):(end-length(expkernel)));
        %         delayk=delayk+round(length(expkernel)/2);
        %         t=t(delayk:min(end,length(v)+delayk-1));
        %         ut=ut(delayk:min(end,length(v)+delayk-1));
        %         figure(32);clf;plot(t,v(1:length(t)),'r',t,ut,'b');
        %
        %         newindex=length(handles.dec.ut)+1;
        %         v2=ut-v(1:length(t));
        %         %v2(v2<0)=0;
        %         handles.dec.ut{newindex} = v2;
        %         handles.dec.t{newindex}=t;
        %
        %         handles=update_dec_ut(handles,'addlastonly');
        %
        %         guidata(hObject, handles);

    case 'LPF'
        dt=handles.dec.t{nowutk}(2)-handles.dec.t{nowutk}(1);

        cellxrange = inputdlg({'Fpass'}, 'Low pass filter', 1, {'20'});
        if(size(cellxrange,1)==0) return; end; %if 'cancel' button clicked
        fc=str2num(cell2mat(cellxrange(1)));

        if(isempty(fc))
            warndlg('invalid inputs: type a the pass band frequency in Hz');
            return;
        end;

        [num, den]=butter(5, fc/(1/2/dt),'low');
        ut=filter(num,den,handles.dec.ut{nowutk});
        newindex=length(handles.dec.ut)+1;
        handles.dec.ut{newindex} = ut(ceil(0.031/dt):end);
        handles.dec.t{newindex}=handles.dec.t{nowutk}(1:(end-ceil(0.031/dt)+1));
        handles=update_dec_ut(handles,'addlastonly');
        guidata(hObject, handles);

    case 'deltaC/C'
        ut=handles.dec.ut{nowutk};
        t=handles.dec.t{nowutk};
        if(isempty(ut) || isempty(t))
            set(handles.text_msg,'String', 'macro failed: some necessary data empty(ut, t)');
            return;
        end

        dt=t(2)-t(1);
        deltaC=diff([0 handles.dec.t{nowutk}]);
        window=ones(ceil(0.03/dt),1);
        windowlen=length(window);
        deltaC=conv(deltaC,window);
        deltaC=deltaC(windowlen:(end-windowlen));
        t=t(ceil(windowlen/2):(end-floor(windowlen/2)-1));
        C=ut(ceil(windowlen/2):(end-floor(windowlen/2)-1));
        newindex=length(handles.dec.ut)+1;
        handles.dec.ut{newindex} = deltaC./(C'+.2);
        handles.dec.t{newindex}=t;
        handles=update_dec_ut(handles,'addlastonly');

        guidata(hObject, handles);
end

set(handles.text_msg,'String', sprintf('macro ''%s'' completed', macroname));


% --- Executes on selection change in popupmenu_listofu.
function popupmenu_listofu_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_listofu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_listofu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_listofu
handles.dec.xrange=update_dec_xrange(handles);
guidata(hObject, handles);


% --- Executes on button press in pushbutton_dCutout.
function pushbutton_dCutout_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dCutout (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

for nowutk=1:length(get(handles.popupmenu_listofu,'String'))
    %nowutk=get(handles.popupmenu_listofu,'Value');
    if(length(handles.dec.ut)<nowutk | length(handles.dec.t) <nowutk)
        set(handles.text_msg,'String', 'cutout failed: some data missing(ut, t)');
        continue;
        %return;
    end

    startk=find(handles.dec.t{nowutk}>=handles.dec.xrange(1)/1000,1,'first');
    endk=find(handles.dec.t{nowutk}<=handles.dec.xrange(2)/1000,1,'last');

    handles.dec.ut{nowutk}=handles.dec.ut{nowutk}(startk:endk);
    handles.dec.t{nowutk}=handles.dec.t{nowutk}(startk:endk);
end

handles=update_dec_ut(handles);

if(~isempty(handles.dec.tk))
    tk=handles.dec.tk{handles.dec.tkindex};
    tk=tk(tk>=handles.dec.xrange(1)/1000);
    tk=tk(tk<=handles.dec.xrange(2)/1000);
    handles.dec.tk{handles.dec.tkindex}=tk;
    handles=d_update_axestk(handles);
end
guidata(hObject,handles);


% --- Executes on button press in pushbutton_prevtk.
function pushbutton_prevtk_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_prevtk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(length(handles.dec.tk)<2) return; end
handles.dec.tkindex=handles.dec.tkindex-1;
if(handles.dec.tkindex>0)
    handles=d_update_axestk(handles);
    guidata(hObject,handles);
end

% --- Executes on button press in pushbutton_nexttk.
function pushbutton_nexttk_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_nexttk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(length(handles.dec.tk)<2) return; end
handles.dec.tkindex=handles.dec.tkindex+1;
if(handles.dec.tkindex<=length(handles.dec.tk))
    handles=d_update_axestk(handles);
    guidata(hObject,handles);
end


% --- Executes on button press in pushbutton_setthreshold.
function pushbutton_setthreshold_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_setthreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)




function finfo=readdatainf(xlsfname,handles)
%fname : file names that contains excel information file
%finfo : information structure array
finfo=[];

if(~exist(xlsfname))
    set(handles.text_msg,'String',strcat(xlsfname, ' NOT found'));
    return;
end

infname=handles.infname;
inftype=handles.inftype;

[type, sheets] = xlsfinfo(xlsfname);

warning off;
[num txt] = xlsread(xlsfname, sheets{1}, '', 'basic');
warning on;



if(isempty(txt)) return; end

% if(size(txt,1)>size(num,1))
%     num=[zeros(1,size(num,2)); num];
% end
% if(size(txt,1)>size(num,1))
%     if still longer
%     num=[zeros(size(txt,1)-size(num,1),size(num,2)); num];
% end

infindex=zeros(1,length(infname));
for i=1:length(infname)
    for j=1:size(txt,2)
        if(strcmpi(txt{1,j}, infname{i}))
            infindex(i)=j;
            break;
        end
    end
end

beginbystr=zeros(1,size(txt,1));
for i=1:size(txt,1)
    beginbystr(i)=isempty(txt{i,1});
end
txt=txt(logical(beginbystr),:);

%merge num to txt
numj=1;
if(sum(isnan(num(1,:)))==size(num,2))
    num=num(2:end,:);
end
for j=1:size(txt,2)
    if(numj>size(num,2))   break;   end

    colfoundinnum=1;
    for i=1:min(size(num,1),size(txt,1));
        if(~isempty(txt{i,j}) && ~isnan(num(i,numj)))
            %if contradicts
            colfoundinnum=0;
            break;
        end
    end

    if(colfoundinnum)
        for i=1:size(txt,1)
            if(isempty(txt{i,j})&&ischar(txt{i,j}))
                %replace it with an element from num
                if(i>size(num,1))     break;    end
                if(~isnan(num(i,numj)))
                    txt{i,j}=num(i,numj);
                end
            end
        end
        numj=numj+1;
    end
end





% numindex=infindex;
% for k=1:length(numindex)
%    if(numindex(k))
%    if(strcmpi(inftype{infindex(k)},'char'))
%       numindex(numindex>numindex(k))=numindex(numindex>numindex(k))-1;
%       numindex(k)=0;
%    end
%    end
% end
%
% numindex(numindex>size(num,2))=0;
if(~infindex(1) || ~infindex(2)) %if file name is not specified
    set(handles.text_msg,'String','fn_head or fnum is missing in xlsfname');
    return;
end



nfiles=max(size(num,1),size(txt,1))-1;


%find valid file names
validk=[];
for k=1:(nfiles+1)
    fname9=strcat(txt{k,infindex(1)},sprintf('%04d',txt{k,infindex(2)}));
    if(~isempty(fname9))
        validk=[validk k];
        finfo(length(validk)).fname=fname9;
    end
end

if(isempty(validk))
    set(handles.text_msg,'String',strcat('no information found in ',xlsfname));
    return;
end

%infname{8}='pp'; %pp/con is a bad variable name

for k=1:length(validk)
    for j=3:length(infindex)
        if(infindex(j))
            %if the information entry found in the excel file
                eval(strcat('finfo(k).',infname{j},'= txt{validk(k),infindex(j)};'));
            if(strcmpi(inftype{j},'num'))
                if(eval(['isstr(finfo(k).' infname{j} ')']))
                    eval(['finfo(k).' infname{j} '=str2num(finfo(k).' infname{j} ');']);
                end
            end
        elseif(~isfield(finfo(k),infname{j}))%because pp/con and pp
            %put empty
            if(strcmpi(inftype{j},'char'))
                eval(strcat('finfo(k).',infname{j},'='''';'));
            elseif(strcmpi(inftype{j},'num'))
                eval(strcat('finfo(k).',infname{j},'=[];'));
            end
        end
    end
end


%correct stimdur
% for k=1:length(finfo)
%     finfo(k).valveseq(1)
%     
%     if(isstr(finfo(k).valveseq(1)))
%         if(finfo(k).valveseq(1)=='.')
%             continue
%         elseif(sum('1'==num2str(dec2bin(hex2dec(finfo(k).valveseq(1)))))>1 && sum(finfo(k).stimdur)>=2500)
%             finfo(k).stimdur=finfo(k).stimdur-2500;
%         end
%     else
%         if(sum('1'==dec2bin((finfo(k).valveseq(1))))>1 && finfo(k).stimdur>=2500)
%             finfo(k).stimdur=finfo(k).stimdur-2500;
%         end
%     end
% end




function [d,si]=abfload(fn,varargin)
% ** function [d,si]=abfload(fn,varargin)
% loads and returns data in the Axon abf format.
% Data may have been acquired in the following modes:
% (1) event-driven variable-length
% (2) event-driven fixed-length
% (3) gap-free
% Information about scaling, the time base and the number of channels and
% episodes is extracted from the header of the abf file (see also abfinfo.m).
% All optional input paramters listed below (= all except the file name)
% must be specified as parameter/value pairs, e.g. as in
%          d=abfload('d:\data01.abf','start',100,'stop','e');
%
%                    >>> INPUT VARIABLES >>>
%
% NAME        TYPE, DEFAULT      DESCRIPTION
% fn          char array         abf data file name
% start       scalar, 0          only gap-free-data: start of cutout to be read (unit: sec)
% stop        scalar or char,    only gap-free-data: end of cutout to be read (unit: sec).
%             'e'                 May be set to 'e' (end of file).
% sweeps      1d-array or char,  only episodic data: sweep numbers to be read. By default,
%             'a'                 all sweeps will be read ('a')
% channels    cell array         names of channels to be read, like {'IN 0','IN 8'};
%              or char, 'a'       ** make sure spelling is 100% correct (including blanks) **
%                                 if set to 'a', all channels will be read
%
%                    <<< OUTPUT VARIABLES <<<
%
% NAME        TYPE            DESCRIPTION
% d                           the data read, the format depending on the recording mode
%             1. GAP-FREE:
%             2d array        2d array of size
%                              '<data pts>' by '<number of chans>'
%                              Examples of access:
%                              d(:,2)       data from channel 2 at full length
%                              d(1:100,:)   first 100 data points from all channels
%             2. EPISODIC FIXED-LENGTH:
%             3d array        3d array of size
%                              '<data pts per sweep>' by '<number of chans>' by '<number of sweeps>'
%                              Examples of access:
%                              d(:,2,:)            is a matrix which contains all events (at full length)
%                                                  of channel 2 in its columns
%                              d(1:200,:,[1 11])   contains first 200 data points of events #1
%                                                  and #11 of all channels
%             3. EPISODIC VARIABLE-LENGTH:
%             cell array      cell array whose elements correspond to single sweeps. Each element is
%                              a (regular) array of size
%                              '<data pts per sweep>' by '<number of chans>'
%                              Examples of access:
%                              d{1}                 a 2d-array which contains the sweep #1 (all of it, all channels)
%                              d{2}(1:100,2)        a 1d-array containing first 100 data points of of channel 2 in sweep #1
%
% si          scalar          the sampling interval in usec
%
% (c) H. Hentschke 2004


% future improvements:
% - handle expansion of header in transition to file version 1.65 better
% - gap-free: abfload internally reads data from all channels of the data file if
%  more than one channel is requested, which wastes enormous amounts of memory. An
%  improved version would repeatedly load chunks of data and split them up,
%  instead of reading all data at once

% defaults
% gap-free
start=0.0;
stop='e';
% episodic
sweeps='a';
channels='a';
verbose=1;

% assign values of optional input parameters, if any were given
pvpmod(varargin);

if verbose, disp(['** ' mfilename]); end
d=[]; si=[];
if ischar(stop)
    if ~strcmpi(stop,'e')
        error('input parameter ''stop'' must be specified as ''e'' (=end of recording) or as a scalar');
    end
end

% --- obtain vital header parameters and initialize them with -1
% temporary initializing var
tmp=repmat(-1,1,16);
% for the sake of typing economy set up a cell array (and convert it to a struct below)
% column order is
%        name, position in header in bytes, type, value)
headPar={
    'fFileVersionNumber',4,'float',-1;
    'nOperationMode',8,'short',-1;
    'lActualAcqLength',10,'long',-1;
    'nNumPointsIgnored',14,'short',-1;
    'lActualEpisodes',16,'long',-1;
    'lFileStartTime',24,'long',-1;
    'lDataSectionPtr',40,'long',-1;
    'lSynchArrayPtr',92,'long',-1;
    'lSynchArraySize',96,'long',-1;
    'nDataFormat',100,'int',-1;
    'nADCNumChannels', 120, 'int', -1;
    'fADCSampleInterval',122,'float', -1;
    'fSynchTimeUnit',130,'float',-1;
    'lNumSamplesPerEpisode',138,'long',-1;
    'lPreTriggerSamples',142,'long',-1;
    'lEpisodesPerRun',146,'long',-1;
    'fADCRange', 244, 'float', -1;
    'lADCResolution', 252, 'long', -1;
    'nFileStartMillisecs', 366, 'short', -1;
    'nADCPtoLChannelMap', 378, 'int16', tmp;
    'nADCSamplingSeq', 410, 'int16',  tmp;
    'sADCChannelName',442, 'uchar', repmat(tmp,1,10);
    'fADCProgrammableGain', 730, 'float', tmp;
    'fInstrumentScaleFactor', 922, 'float', tmp;
    'fInstrumentOffset', 986, 'float', tmp;
    'fSignalGain', 1050, 'float', tmp;
    'fSignalOffset', 1114, 'float', tmp;
    'nTelegraphEnable',4512,'short',tmp;
    'fTelegraphAdditGain',4576,'float',tmp
    };

fields={'name','offs','numType','value'};
s=cell2struct(headPar,fields,2);
numOfParams=size(s,1);
clear tmp headPar;

if ~exist(fn,'file'), error(['could not find file ' fn]); end
if verbose, disp(['opening ' fn '..']); end
[fid,messg]=fopen(fn);
if fid == -1,error(messg);end;
% determine absolute file size
fseek(fid,0,'eof');
fileSz=ftell(fid);
fseek(fid,0,'bof');

% read all vital information in header
% convert names in structure to variables and read value from header
for g=1:numOfParams,
    if fseek(fid, s(g).offs,'bof')~=0,
        fclose(fid);
        error(['something went wrong locating ' s(g).name]);
    end;
    sz=length(s(g).value);
    eval(['[' s(g).name ',n]=fread(fid,sz,''' s(g).numType ''');']);
    if n~=sz,
        fclose(fid);
        error(['something went wrong reading value(s) for ' s(g).name]);
    end;
end;

if lActualAcqLength<nADCNumChannels, error('less data points than sampled channels in file'); end;
% the numerical value of all recorded channels (numbers 0..15)
recChIdx=nADCSamplingSeq(1:nADCNumChannels);
% the corresponding indices into loaded data d
recChInd=1:length(recChIdx);
% the channel names, e.g. 'IN 8'
recChNames=[reshape(char(sADCChannelName),10,16)]';
recChNames=recChNames(recChIdx+1,:);

chInd=[];
eflag=0;
if ischar(channels)
    if strcmp(channels,'a')
        chInd=recChInd;
    else
        fclose(fid);
        error('input parameter ''channels'' must either be a cell array holding channel names or the single character ''a'' (=all channels)');
    end
else
    for i=1:length(channels)
        tmpChInd=strmatch(channels{i},recChNames,'exact');
        if ~isempty(tmpChInd)
            chInd=[chInd tmpChInd];
        else
            % set error flag to 1
            eflag=1;
        end
    end;
end
if eflag
    fclose(fid);
    disp('**** available channels:');
    disp(recChNames);
    disp(' ');
    disp('**** requested channels:');
    disp(strvcat(channels));
    error('at least one of the requested channels does not exist in data file (see above)');
end

% fFileVersionNumber needs a fix - for whatever reason its value is always
% a little less than what it should be (e.g. 1.6499999xxxx instead of 1.65)
fFileVersionNumber=.001*round(fFileVersionNumber*1000);

% gain of telegraphed instruments, if any
if fFileVersionNumber>=1.65
    addGain=nTelegraphEnable.*fTelegraphAdditGain;
    addGain(addGain==0)=1;
else
    addGain=ones(size(fTelegraphAdditGain));
end

% tell me where the data start
blockSz=512;
switch nDataFormat
    case 0
        dataSz=2;  % bytes/point
        precision='int16';
    case 1
        dataSz=4;  % bytes/point
        precision='float32';
    otherwise
        fclose(fid);
        error('invalid number format');
end;
headOffset=lDataSectionPtr*blockSz+nNumPointsIgnored*dataSz;
% fADCSampleInterval is the TOTAL sampling interval
si=fADCSampleInterval*nADCNumChannels;

if ischar(sweeps) & sweeps=='a'
    nSweeps=lActualEpisodes;
    sweeps=1:lActualEpisodes;
else
    nSweeps=length(sweeps);
end;

switch nOperationMode
    case 1
        if verbose, disp('data were acquired in event-driven variable-length mode'); end
        warndlg('function abfload has not yet been thorougly tested for data in event-driven variable-length mode - please double-check that the data loaded is correct','Just a second, please');
        if (lSynchArrayPtr<=0 | lSynchArraySize<=0), error('internal variables ''lSynchArraynnn'' are zero or negative'); end;
        switch fSynchTimeUnit
            case 0  % time information in synch array section is in terms of ticks
                synchArrTimeBase=1;
            otherwise % time information in synch array section is in terms of usec
                synchArrTimeBase=fSynchTimeUnit;
        end;
        % the byte offset at which the SynchArraySection starts
        lSynchArrayPtrByte=blockSz*lSynchArrayPtr;
        % before reading Synch Arr parameters check if file is big enough to hold them
        % 4 bytes/long, 2 values per episode (start and length)
        if lSynchArrayPtrByte+2*4*lSynchArraySize<fileSz, error('file seems not to contain complete Synch Array Section'); end;
        if fseek(fid,lSynchArrayPtrByte,'bof')~=0, error('something went wrong positioning file pointer to Synch Array Section'); end;
        [synchArr,n]=fread(fid,lSynchArraySize*2,'int32');
        if n~=lSynchArraySize*2, error('something went wrong reading synch array section'); end;
        % make synchArr a lSynchArraySize x 2 matrix
        synchArr=permute(reshape(synchArr',2,lSynchArraySize),[2 1]);
        % the length of episodes in sample points
        segLengthInPts=synchArr(:,2)/synchArrTimeBase;
        % the starting ticks of episodes in sample points WITHIN THE DATA FILE
        segStartInPts=cumsum([0 (segLengthInPts(1:end-1))']*dataSz)+headOffset;
        % start time (synchArr(:,1)) has to be divided by nADCNumChannels to get true value
        % go to data portion
        if fseek(fid,headOffset,'bof')~=0, error('something went wrong positioning file pointer (too few data points ?)'); end;
        for i=1:nSweeps,
            % if selected sweeps are to be read, seek correct position
            if ~isequal(nSweeps,lActualEpisodes),
                fseek(fid,segStartInPts(sweeps(i)),'bof');
            end;
            [tmpd,n]=fread(fid,segLengthInPts(sweeps(i)),precision);
            if n~=segLengthInPts(sweeps(i)),
                warning(['something went wrong reading episode ' int2str(sweeps(i)) ': ' segLengthInPts(sweeps(i)) ' points should have been read, ' num2str(n) ' points actually read']);
            end;
            dataPtsPerChan=n/nADCNumChannels;
            if rem(n,nADCNumChannels)>0, error('number of data points in episode not OK'); end;
            % separate channels..
            tmpd=reshape(tmpd,nADCNumChannels,dataPtsPerChan);
            % retain only requested channels
            tmpd=tmpd(chInd,:);
            tmpd=tmpd';
            % if data format is integer, scale appropriately; if it's float, tmpd is fine
            if ~nDataFormat
                for j=1:length(chInd),
                    ch=recChIdx(chInd(j))+1;
                    tmpd(:,j)=tmpd(:,j)/(fInstrumentScaleFactor(ch)*fSignalGain(ch)*fADCProgrammableGain(ch)*addGain(ch))...
                        *fADCRange/lADCResolution+fInstrumentOffset(ch)-fSignalOffset(ch);
                end;
            end
            % now place in cell array, an element consisting of one sweep with channels in columns
            d{i}=tmpd;
        end;
    case {2,5}
        if nOperationMode==2, if verbose, disp('data were acquired in event-driven fixed-length mode');  end
        else
            if verbose, disp('data were acquired in waveform fixed-length mode (clampex only)');  end
        end;
        % determine first point and number of points to be read
        startPt=0;
        dataPts=lActualAcqLength;
        dataPtsPerChan=dataPts/nADCNumChannels;
        if rem(dataPts,nADCNumChannels)>0, error('number of data points not OK'); end;
        dataPtsPerChanPerSweep=dataPtsPerChan/lActualEpisodes;
        if rem(dataPtsPerChan,lActualEpisodes)>0, error('number of data points not OK'); end;
        dataPtsPerSweep=dataPtsPerChanPerSweep*nADCNumChannels;
        if fseek(fid,startPt*dataSz+headOffset,'bof')~=0, error('something went wrong positioning file pointer (too few data points ?)'); end;
        d=zeros(dataPtsPerChanPerSweep,length(chInd),nSweeps);
        % the starting ticks of episodes in sample points WITHIN THE DATA FILE
        selectedSegStartInPts=[(sweeps-1)*dataPtsPerSweep]*dataSz+headOffset;
        for i=1:nSweeps,
            fseek(fid,selectedSegStartInPts(i),'bof');
            [tmpd,n]=fread(fid,dataPtsPerSweep,precision);
            if n~=dataPtsPerSweep,
                error(['something went wrong reading episode ' int2str(sweeps(i)) ': ' dataPtsPerSweep ' points should have been read, ' num2str(n) ' points actually read']);
            end;
            dataPtsPerChan=n/nADCNumChannels;
            if rem(n,nADCNumChannels)>0, error('number of data points in episode not OK'); end;
            % separate channels..
            tmpd=reshape(tmpd,nADCNumChannels,dataPtsPerChan);
            % retain only requested channels
            tmpd=tmpd(chInd,:);
            tmpd=tmpd';
            % if data format is integer, scale appropriately; if it's float, d is fine
            if ~nDataFormat
                for j=1:length(chInd),
                    ch=recChIdx(chInd(j))+1;
                    tmpd(:,j)=tmpd(:,j)/(fInstrumentScaleFactor(ch)*fSignalGain(ch)*fADCProgrammableGain(ch)*addGain(ch))...
                        *fADCRange/lADCResolution+fInstrumentOffset(ch)-fSignalOffset(ch);
                end;
            end
            % now fill 3d array
            d(:,:,i)=tmpd;
        end;

    case 3
        if verbose, disp('data were acquired in gap-free mode'); end
        % from start, stop, headOffset and fADCSampleInterval calculate first point to be read
        %  and - unless stop is given as 'e' - number of points
        startPt=floor(1e6*start*(1/fADCSampleInterval));
        % this corrects undesired shifts in the reading frame due to rounding errors in the previous calculation
        startPt=floor(startPt/nADCNumChannels)*nADCNumChannels;
        % if stop is a char array, it can only be 'e' at this point (other values would have
        % been caught above)
        if ischar(stop),
            dataPtsPerChan=lActualAcqLength/nADCNumChannels-floor(1e6*start/si);
            dataPts=dataPtsPerChan*nADCNumChannels;
        else
            dataPtsPerChan=floor(1e6*(stop-start)*(1/si));
            dataPts=dataPtsPerChan*nADCNumChannels;
            if dataPts<=0 error('start is larger than or equal to stop'); end
        end;
        if rem(dataPts,nADCNumChannels)>0, error('number of data points not OK'); end;
        if fseek(fid,startPt*dataSz+headOffset,'bof')~=0, error('something went wrong positioning file pointer (too few data points ?)'); end;
        % decide on the way to read data:
        % a) one (of more than one) channel requested: use the 'skip' feature of fread
        % b) more than one channels requested: read all channels, purge non-requested ones
        % A (not yet implemented) improved version would read a reasonable chunk of data
        % (all channels), separate channels, purge non-requested ones, concatenate, repeat until done
        if length(chInd)==1 && nADCNumChannels>1
            % jump to proper reading frame position in file
            if fseek(fid,(chInd-1)*dataSz,'cof')~=0, error('something went wrong positioning file pointer (too few data points ?)'); end;
            % read, skipping nADCNumChannels-1 data points after each read
            dataPtsPerChan=dataPts/nADCNumChannels;
            [d,n]=fread(fid,dataPtsPerChan,precision,dataSz*(nADCNumChannels-1));
        else
            [d,n]=fread(fid,dataPts,precision);
            if n~=dataPts,
                disp(['WARNING: something went wrong reading file (' num2str(dataPts) ' points should have been read, ' num2str(n) ' points actually read']);
                dataPts=n;
                dataPtsPerChan=dataPts/nADCNumChannels;
            end;
            % separate channels..
            d=reshape(d,nADCNumChannels,dataPtsPerChan);
            % retain only requested channels
            d=d(chInd,:);
            d=d';
        end
        % if data format is integer, scale appropriately; if it's float, d is fine
        if ~nDataFormat
            for j=1:length(chInd),
                ch=recChIdx(chInd(j))+1;
                d(:,j)=d(:,j)/(fInstrumentScaleFactor(ch)*fSignalGain(ch)*fADCProgrammableGain(ch)*addGain(ch))...
                    *fADCRange/lADCResolution+fInstrumentOffset(ch)-fSignalOffset(ch);
            end;
        end
    otherwise
        disp('recording mode of data must be event-driven variable-length (1), event-driven fixed-length (2) or gap-free (3) -- returning empty matrix');
        d=[];
        si=[];
end;

fclose(fid);

function pvpmod(x)
% PVPMOD             - evaluate parameter/value pairs
% pvpmod(x) assigns the value x(i+1) to the parameter defined by the
% string x(i) in the calling workspace. This is useful to evaluate
% <varargin> contents in an mfile, e.g. to change default settings
% of any variable initialized before pvpmod(x) is called.
%
% (c) U. Egert 1998

%############################################
% this loop is assigns the parameter/value pairs in x to the calling
% workspace.

if ~isempty(x)
    for i = 1:2:size(x,2)
        assignin('caller', x{i}, x{i+1});
    end;
end;

%############################################





function [dout, diam] = pickpeaksonly(din, maxn)
%pickpeaksonly
%Anmo Kim
%May 17th 2006
%pick high peaks only. other values ripped down to zero
%Arguments
%d1 : a row vector, which is the data to be searched
%maxn : maximum interval of non-zero value interval
%dout : 'peaks picked' version of d1

d1=din;

d1(find(d1<0))=0;

z=d1;
z(find(z>0))=1; %all positive values are forced to be 1

z1=diff(z);
% e.g. z = [ 0  1 0 1 1  1 0 0 0 1  1 0];
%      z1= [ 1 -1 1 0 0 -1 0 0 1 0 -1 0];
zstart = find(eq(z1,1))+1;
zend = find(eq(z1,-1));

diam=zeros(size(d1));

if(isempty(zend))
    [dout diam]=pickmaxonly(d1,maxn);
    return;
end;

if(zend(1) < zstart(1))
    [d1(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
    zend=zend(2:end);
end;


for k=1:length(zend)
    %    if(k==16)
    %       disp('k=16');
    %    end
    [d1(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
end;

if (length(zstart)>length(zend))
    [d1(zstart(end):end) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):end),maxn);
end;

% hist(d1(find(ne(d1,0))),50); pause;
% plot(d1); pause;
dout = d1;


%post processing : merging too close spikes
kk = find(ne(dout,0));
ii = find(le(diff(kk),maxn));

for k=1:length(ii)
    if (dout(kk(ii(k))) < dout(kk(ii(k)+1)))
        dout(kk(ii(k)))=0;
        diam(kk(ii(k)+1))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
    else
        dout(kk(ii(k)+1))=0;
        diam(kk(ii(k)))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
    end
end














function [dout, diam] = pickmaxonly(din, maxn)
%maxonly.m
%Anmo Kim
%May 16th, 2006
%description : taking the max value only within the given interval
%              other values are dropped to zero
%              if the given interval is greater than the tmax, it's chopped
%              into multiple intervals

nlevels=50;

d1=din;

if(size(d1,2)~=1)
    d1=d1';
end;

if(size(d1,2)~=1)
    disp('d1 needs be a vector, not a matrix');
    dout=[];
    diam=[];
    return;
end;

if(size(d1)==[1 1])
    dout = din;
    diam=1;
    return;
end


dout=zeros(size(din));
diam=zeros(size(din));

if (length(d1)<=maxn)
    [c, i]=max(d1);
    dout(i)=c;
    diam(i)=length(d1);

else
    delta = ones(length(d1), nlevels);
    delta=cumsum(delta,2)-1;
    delta=delta/nlevels*max(d1);

    d1=d1*ones(1,nlevels);

    higher=gt(d1,delta);
    z=diff(higher,1,1);

    kdelta=[];
    higher_area=[];
    nvaliddelta=0;
    for k=1:nlevels
        zstart=find(eq(z(:,k),1))+1;
        zend=find(eq(z(:,k),-1));

        if(isempty(zend) | isempty(zstart)) continue; end;

        if(zend(1) > zstart(end)) continue; end; %if no groove

        if(length(zstart)>2 | length(zend)>2) continue; end; %if there are more than two hills

        higher_area(nvaliddelta+1) = sum(higher(:,1)>delta(1,k));
        kdelta(nvaliddelta+1)=k;

    end;


    if(isempty(kdelta)) %no groove at all (a single valley)
        [c, i]=max(d1);
        dout(i)=c;
        diam(i)=length(d1);
        return;

    else
        [c, i]=min(higher_area);
        zstart=find(eq(z(:,kdelta(i)),1))+1;
        zend=find(eq(z(:,kdelta(i)),-1));

        if(zend(1) < zstart(1))
            [dout(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
            zend=zend(2:end);
        end;

        for k=1:length(zend)
            [dout(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
        end;

        if (length(zstart)>length(zend))
            [dout(zstart(end):length(din)) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):length(din)),maxn);
        end;
    end;
end;


% --- Executes on button press in togglebutton_fescmacro.
function togglebutton_fescmacro_Callback(hObject, eventdata, handles)
% hObject    handle to togglebutton_fescmacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of togglebutton_fescmacro
%
%
% % --- Executes on slider movement.
% function slider_find_thresholdbase_Callback(hObject, eventdata, handles)
% % hObject    handle to slider_find_thresholdbase (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
%
% % Hints: get(hObject,'Value') returns position of slider
% %        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
% minthresholdbase=0.3;
% maxthresholdbase=0.6;
%
% val=get(hObject,'Value')*(maxthresholdbase-minthresholdbase)+minthresholdbase;
% val=round(val*100)/100;
% set(handles.edit_find_thresholdbase,'String',num2str(val));
% handles.fresetthresholdbase=val;
% guidata(hObject,handles);
%
% set(handles.text_msg,'String','reset threshold base adjusted');
%
%
% % --- Executes during object creation, after setting all properties.
% function slider_find_thresholdbase_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to slider_find_thresholdbase (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
%
% % Hint: slider controls usually have a light gray background.
% if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor',[.9 .9 .9]);
% end
%
%



function edit_find_thresholdbase_Callback(hObject, eventdata, handles)
% hObject    handle to edit_find_thresholdbase (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_find_thresholdbase as text
%        str2double(get(hObject,'String')) returns contents of edit_find_thresholdbase as a double
minthresholdbase=0.3;
maxthresholdbase=1;

val=str2num(get(hObject,'String'));
if(isempty(val))
    set(handles.text_msg,'String','invalid threshold base');
    set(hObject,'String',num2str(handles.fresetthresholdbase));
    return;
elseif(val>maxthresholdbase || val<minthresholdbase)
    set(handles.text_msg,'String','invalid threshold base');
    set(hObject,'String',num2str(handles.fresetthresholdbase));
    return;
else
    handles.fresetthresholdbase=val;
    %     set(handles.slider_find_thresholdbase,'Value',...
    %         (val-minthresholdbase)/(maxthresholdbase-minthresholdbase));
    guidata(hObject,handles);
    set(handles.text_msg,'String','reset threshold base adjusted');
end




% --- Executes during object creation, after setting all properties.
function edit_find_thresholdbase_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_find_thresholdbase (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_vtwopulsemacro.
function pushbutton_vtwopulsemacro_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vtwopulsemacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



% --- Executes on button press in pushbutton_setppmfactor.
function pushbutton_setppmfactor_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_setppmfactor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% if(~isempty(handles.vAxesinfo(handles.vNowaxes).c))
%     %     set(handles.text_msg,'String','no odor concentration data in this plot');
%     %     return;
%     % end
%     %
%     % if(isempty(strfind(lower(handles.vAxesinfo(handles.vNowaxes).stimtype),'hexane')))
%     %     set(handles.text_msg,'String','stim type is not hexane');
%     %     return;
%     % end
%     % if(isempty(handles.vAxesinfo(handles.vNowaxes).con))
%     %     set(handles.text_msg,'String','concentration not found');
%     %     return;
%     % end
%
%
%     dt=handles.vAxesinfo(handles.vNowaxes).dt;
%
%     cmax=max(handles.vAxesinfo(handles.vNowaxes).c);
%     cmax=cmax-mean(handles.vAxesinfo(handles.vNowaxes).c(1:round(handles.vAxesinfo(handles.vNowaxes).stimstart/dt)));
%
%     if(~isempty(findstr('co2',lower(handles.vAxesinfo(handles.vNowaxes).stimtype))))
%         ppmfactor0=handles.vAxesinfo(handles.vNowaxes).con/cmax*10^4*0.5;
%     elseif(~isempty(findstr('hexane',lower(handles.vAxesinfo(handles.vNowaxes).stimtype))))
%         ppmfactor0=151.28/760*handles.vAxesinfo(handles.vNowaxes).con/4.7/cmax*10^4;
%         %151.28 : 1x hexane vapor pressure
%         %760 : ambient air pressure
%         %con : odor flow percentage over net flow
%         %4.7 : hexane ionization factor
%         %csteady : pid output
%         %10^6 : ppm
%         %100 : percent
%     elseif(~isempty(findstr('ethanol',lower(handles.vAxesinfo(handles.vNowaxes).stimtype))))
%         ppmfactor0=59.02/760*handles.vAxesinfo(handles.vNowaxes).con/8.8/cmax*10^4;
%         %59.02 : 1x hexane vapor pressure
%         %760 : ambient air pressure
%         %con : odor flow percentage over net flow
%         %8.8 : ethanol ionization factor
%         %csteady : pid output
%         %10^6 : ppm
%         %100 : percent
%     else
%         set(handles.text_msg,'String','unknown calibration odor');
%         return;
%     end
%
%     button = questdlg(sprintf('ppmfactor0=%f, apply to all loaded files?',ppmfactor0),'applying ppmfactor0');
%
%     if(strcmpi(button,'yes'))
%         for i=1:handles.vNumaxes
%             %write to files
%             save(strcat(handles.mfolder,handles.vAxesinfo(i).fname,'.mat'),'-append','ppmfactor')
%
%             if(ishandle(handles.vAxesinfo(handles.vNowaxes).hCaxes))
%             end
%         end
%     else(strcmpi(button,'no'))
%
%     end
%     set(handles.text_msg,'String',sprintf('ppmfactor=%f, pick files to apply',ppmfactor0));
%     save(strcat(handles.mfolder,handles.vAxesinfo(handles.vNowaxes).fname,'.mat'),'-append','ppmfactor')
% end

handles=updatepwd(handles);

%from viewspike19
%[newonfilek newplotoption newdownsampleratio]=loadn(handles.flist);
xlsfiles={};

mfolder=strcat(handles.mfolder);
abffolder=strcat(mfolder(1:(end-2)));


xlsfiles1=dir(strcat(abffolder, '*.xls'));
finfo=[];
for k=1:length(xlsfiles1)
    if(xlsfiles1(k).name(1)~='.')
        xlsfiles{end+1}=strcat(abffolder,xlsfiles1(k).name);
    end
end

if(ispc)
    xlsfiles2=dir(strcat(mfolder, '*.xls'));
else
    xlsfiles2=dir(strcat(mfolder, '*.xls'));
end

for i=1:length(xlsfiles2)
    found=0;
    for j=1:length(xlsfiles)
        if(strcmpi(xlsfiles1(j).name,xlsfiles2(i).name))
            found=1;
        end
    end
    if(~found && xlsfiles2(i).name(1)~='.')
        xlsfiles{end+1}=strcat(mfolder,xlsfiles2(k).name);
    end
end



finfo=[];
for k=1:length(xlsfiles)
    finfo0=readdatainf(xlsfiles{k}, handles);
    finfo=[finfo finfo0];
end

mfiles=dir(strcat(mfolder, '*.mat'));
if(isempty(mfiles))
    return;
end


%get rid of duplicate information
dupk=[];%index of duplicate file informations
for i=1:(length(finfo)-1)
    for j=(i+1):length(finfo)
        if(strcmpi(finfo(i).fname, finfo(j).fname))
            dupk=[dupk j];
        end
    end
end
index=ones(1,length(finfo));
index(dupk)=0;
finfo=finfo(index==1);



%get rid of invalid file names
notfoundk=[];%index of duplicate file informations
for k=1:length(finfo)
    if(~exist(strcat(mfolder, finfo(k).fname,'.mat')))
        notfoundk=[notfoundk k];
    end
end
index=ones(1,length(finfo));
index(notfoundk)=0;
finfo=finfo(index==1);

%add channel2 files
%05/27/2008
finfo0=finfo;
j=1;
for i=1:length(finfo0)
    finfo(j)=finfo0(i); j=j+1;
    if(exist(strcat(mfolder, finfo(j-1).fname,'b','.mat')))
        finfo(j)=finfo(j-1);
        finfo(j).fname=strcat( finfo(j).fname,'b');
        j=j+1;
    end
end




%add files that are not found in the information files
for i=1:length(mfiles)
    found=0;
    for j=1:length(finfo)
        if(strfind(mfiles(i).name,finfo(j).fname))
            found=1;
        end
    end
    if(~found)
        finfo(end+1).fname=mfiles(i).name(1:(end-4));
        for i=2:length(handles.infname)
            %put empty
            if(strcmpi(handles.inftype{i},'char'))
                eval(strcat('finfo(end).',handles.infname{i},'='''';'));
            elseif(strcmpi(handles.inftype{i},'num'))
                if(strfind(handles.infname{i},'/'))
                    finfo(end).pp=[];
                else
                    eval(strcat('finfo(end).',handles.infname{i},'=[];'));
                end
            end
        end
    end
end


% flist9=dir(strcat(abffolder,handles.vAxesinfo(handles.vNowaxes).fname,'.abf'));
% if(~isempty(flist9))
%     date1=datenum(flist9.date);
% else
%     date1=[];
% end
newonfilek=pickfiles(finfo, gcf,'pick files to compute and apply ppmfactors', ones(size(finfo)));


if(isempty(newonfilek))
    return;
end


set(handles.text_msg,'String','searching calibration recordings for setting ppmfactor... hold on...');
drawnow;


filedate0=[];l=1;calibfilek=[];
%if(~isempty(strfind(options,'interpolate')))
ppmfactor0=[];
for i=1:length(newonfilek)
    if(finfo(newonfilek(i)).fname(end)=='b')
        continue;
        %load(strcat(handles.mfolder,finfo(newonfilek(i)).fname(1:(end-1)),'.mat'),'c', 'stimstart','stimdur','stimtype','dt','con');
    else
        load(strcat(handles.mfolder,finfo(newonfilek(i)).fname,'.mat'),'c', 'stimstart','stimdur','stimtype','dt','con','npulses','valveseq');
    end
    if(sum(stimdur)<1000 || npulses<0 || ischar(valveseq))
        continue;
    end
    if(valveseq~=6 && valveseq~=4)
        continue;
    end

    %    cmax=max(c(round((stimstart+sum(stimdur)-100)/dt):round((stimstart+stimdur)/dt)));
    if(0)
        %take the mean around the maximum concentration point
        [temp maxk]=max(c);
        cmax=mean(c(max(1,maxk-1000):min(length(c),maxk+1000)));%take a time average for 200msec around the peak point
    else
        cmax=mean(c(stimstart*10+(7000:9000)));
    end
    
    %    cmax=mean(c(round((stimstart+sum(stimdur)-100)/dt):round((stimstart+stimdur)/dt)));
    cmax=cmax-mean(c(max(1,round(stimstart/dt)-5000):round(stimstart/dt)));

    if(finfo(newonfilek(i)).fname(end)=='b')
        flist9=dir(strcat(abffolder,finfo(newonfilek(i)).fname(1:(end-1)),'.abf'));
    else
        flist9=dir(strcat(abffolder,finfo(newonfilek(i)).fname,'.abf'));
    end

    if(~isempty(flist9))
        filedate(l)=datenum(flist9.date);
    else
        filedate(l)=0;
    end

    if(l>1)
        if(sum(filedate(l)==filedate(1:(l-1)))>0)
            filedate=filedate(1:(end-1));
            continue;
        end
    end

    calibfilek=[calibfilek newonfilek(i)];
    if(~isempty(findstr('co2',lower(stimtype))))
        ppmfactor0(l)=con*.3/cmax*10^4;
    elseif(~isempty(findstr('hexane',lower(stimtype))))
        ppmfactor0(l)=151.28/760*con/4.7/cmax*10^4;
    elseif(~isempty(findstr('ethanol',lower(stimtype))))
        ppmfactor0(l)=59.02/760*con/8.8/cmax*10^4;
    elseif(~isempty(findstr('ethyl acetate',lower(stimtype))))
        dilution=0;
        temp1=findstr('1/',stimtype);
        temp2=findstr('x',stimtype);
        if(~isempty(temp1)&&~isempty(temp2))
            dilution=str2num(stimtype(((temp1+2):(temp2-1))));
        end
        if(dilution>0 && dilution<=400)
            ppmfactor0(l)=94.02/dilution/760*con/3.654/cmax*10^4;
        else
            %if the dilution rate is not specified or found
            if(l==1)
                filedate=[];
            else
                filedate=filedate(1:(end-1));
            end
            l=l-1;calibfilek=calibfilek(1:(end-1));
        end
    else
        %if not a calibration molecule
        if(l==1)
            filedate=[];
        else
            filedate=filedate(1:(end-1));
        end
        l=l-1;calibfilek=calibfilek(1:(end-1));
    end
    l=l+1;
end
%end

if(isempty(ppmfactor0))
    set(handles.text_msg,'String','no calibration recordings found');
    return;
end

figure(33333);plot((filedate-filedate(1))*1000,ppmfactor0,'-o');xlabel('time [min]');ylabel('ppmfactor');
newonfilek2=pickfiles(finfo(calibfilek), gcf,'deselect unwanted calib files', ones(size(calibfilek)));
ppmfactor0=ppmfactor0(newonfilek2);
filedate=filedate(newonfilek2);

% [ppmfactor0 ix]=sort(ppmfactor0);
% filedate=filedate(ix);
[filedate ix]=sort(filedate);
ppmfactor0=ppmfactor0(ix);

%lower the slope of ppmfactor0 to take into account the drop of ethyl
%acetate conentration
p7=robustfit(filedate(:),ppmfactor0(:));
regressionline=polyval(flipud(p7),filedate);
halfregressionline=(regressionline-regressionline(1))*.75;
ppmfactor0=ppmfactor0-halfregressionline;
   





figname=lower(get(gcf,'Name'));
figname=strcat(figname,'..........');
if(~strcmpi(figname(1:9), 'flyspikes'))
    figlist=get(0,'Children');
    for k=1:length(figlist)
        figure(figlist(k));
        figname=lower(get(gcf,'Name'));
        figname=strcat(figname,'..........');
        if(strcmp(figname(1:9), 'FlySpikes'))
            break;
        end
    end
end


if(~strcmpi(figname(1:9), 'flyspikes'))
    disp('warning: no flyspikes10 exists');
    return;
end


if(isempty(newonfilek))
    return;
end

%slope0=(ppmfactor2-ppmfactor1)/(date2-date1);
for k=1:length(newonfilek)
    if(finfo(newonfilek(k)).fname(end)=='b')
        flist9=dir(strcat(abffolder,finfo(newonfilek(k)).fname(1:(end-1)),'.abf'));
    else
        flist9=dir(strcat(abffolder,finfo(newonfilek(k)).fname,'.abf'));
    end

    if(~isempty(flist9))
        datek=datenum(flist9.date);
        if(length(ppmfactor0)==1)
            ppmfactor=ppmfactor0;
        else
            ppmfactor=interp1_anmo(filedate,ppmfactor0,datek);
        end
    else
        ppmfactor=mean(ppmfactor0);
    end

    %     %ppmfactor=ppmfactor1;
    %     if(isnan(ppmfactor) && length(filedate)==1)
    %         ppmfactor=ppmfactor0;
    %
    %     elseif(isnan(ppmfactor)&&length(filedate)>1)
    %         %out of the range
    %         if(datek<min(filedate))
    %            slope=(ppmfactor0(2)-ppmfactor0(1))/(filedate(2)-filedate(1));
    %            ppmfactor=ppmfactor0(1)+(datek-filedate(1))*slope;
    %         else
    %             %datek > max(filedate)
    %            slope=(ppmfactor0(end)-ppmfactor0(end-1))/(filedate(end)-filedate(end-1));
    %            ppmfactor=ppmfactor0(end)+(datek-filedate(end))*slope;
    %         end
    %     end

    save(strcat(handles.mfolder,finfo(newonfilek(k)).fname,'.mat'),'-append','ppmfactor');
    set(handles.text_msg,'String',sprintf('writing to %s.mat...ppmfactor=%6.1f',finfo(newonfilek(k)).fname,ppmfactor));
    drawnow;
end


set(handles.text_msg,'String',sprintf('ppmfactor applied to %d files',length(newonfilek)));











% --- Executes on selection change in popupmenu_vMacro.
function popupmenu_vMacro_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_vMacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_vMacro contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_vMacro
macrostr=get(hObject,'String');
macronum=get(hObject,'Value');
switch macrostr{macronum}
    case 'count spikes'
        str='count spikes : count the number of spikes within a specific time interval';
    case 'compute average input'
        str='compute average input : comput the average input within a specific time interval';
    case 'paired latency'
        str='paired latency : plot the timing (difference) of the first evoked spike(s) w.r.t. the timing (difference) of the previous spike(s)';
    case 'compute d(t)'
        str='compute d(t) : compute tdm of each paired recording, and compute their pairwise difference';
    case 'align by 1st spike'
        str='align by 1st spike : get odor onset timing from user-input and align spike trains by the timing of the next spike';
    case '1st spike jitter'
        str='1st spike jitter :  get odor onset timing from user-input and compute the jitter(std) of the next spikes';
    case 'two pulse'
        str='two pulse : estimate the double pulse experiments when a recording has its npulses=2 and stimdur>0';
    case 'export all C'
        str='export all C : export the odor concentration curve to the base workspace';
    case 'export all spkt'
        str='export all spkt : export all spike trains to the base workspace';
    case 'open tk'
        str='open spike sequence';
    otherwise
        str='';
end
set(handles.text_msg,'String',str);
set(hObject,'TooltipString',str);



% --- Executes during object creation, after setting all properties.
function popupmenu_vMacro_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_vMacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
set(hObject,'String',...
    {'count spikes', 'compute average input', 'paired latency', 'compute d(t)','align by 1st spike','1st spike jitter','two pulse','export all C','export all spkt',...
    'open tk'});

% --- Executes on button press in pushbutton_vRunMacro.
function pushbutton_vRunMacro_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vRunMacro (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
macrolist=get(handles.popupmenu_vMacro,'String');
macronum=get(handles.popupmenu_vMacro,'Value');
macroname=macrolist{macronum};

switch macroname
    case 'open tk'
        if(length(handles.vAxesinfo)>=handles.vNowaxes & handles.vNowaxes>0)
            if(~isempty(handles.vAxesinfo(handles.vNowaxes).spkk))
                if(isempty(handles.vAxesinfo(handles.vNowaxes).valve_open0))
                    opentk(handles.vAxesinfo(handles.vNowaxes).spkk*handles.vAxesinfo(handles.vNowaxes).dt...
                        ,0);
                else
                    opentk(handles.vAxesinfo(handles.vNowaxes).spkk*handles.vAxesinfo(handles.vNowaxes).dt...
                        ,handles.vAxesinfo(handles.vNowaxes).valve_open0);
                end
            else
                set(handles.text_msg,'String', 'no detected spikes to open');
            end

        else
            set(handles.text_msg,'String', 'no detected spikes to open');
        end

    case 'count spikes'
        if(handles.vNumaxes==0)
            set(handles.text_msg,'String','no data loaded');
            return;
        end

        answer=inputdlg({'start[sec]', 'end[sec]'},'time interval',1,{'8','11.2'});
        if(isempty(answer))
            return;
        end
        startt=str2double(answer{1});
        endt=str2double(answer{2});
        if(isempty(startt) || isempty(endt))
            return;
        end
        
        for i=1:(handles.vNumaxes)
            fname{i}=handles.vAxesinfo(i).fname;
            spkt{i}=handles.vAxesinfo(i).spkk*handles.vAxesinfo(i).dt+handles.vAxesinfo(i).t0;
            if(isempty(spkt{i}))
                nspks(i)=0;
            else
                nspks(i)=sum(spkt{i}>=startt*1000 & spkt{i}<=endt*1000);
            end
        end
        
        assignin('base','spkt',spkt);
        assignin('base','fname',fname);
        assignin('base','nspks',nspks);
        
        
        set(handles.text_msg,'String','"fname", "spkt", and "nspks" are exported');
        
        
    case 'compute average input'
        if(handles.vNumaxes==0)
            set(handles.text_msg,'String','no data loaded');
            return;
        end

        answer=inputdlg({'start[sec]', 'end[sec]'},'time interval',1,{'8','11.2'});
        if(isempty(answer))
            return;
        end
        startt=str2double(answer{1});
        endt=str2double(answer{2});
        if(isempty(startt) || isempty(endt))
            return;
        end
        
        
        c=cell(1,handles.vNumaxes);
        for k=1:handles.vNumaxes
            if(isfield(handles.vAxesinfo(k),'c'))
                c{k}=handles.vAxesinfo(k).c;
            else
                c{k}=[];
            end
        end
        assignin('base', 'c', c);
        set(handles.text_msg,'String','"c" is exported : c{i}=c vector in ith axes');
        
        
        cmean=zeros(size(c));
        dt=handles.vAxesinfo(k).dt/1000;
        for k=1:length(c)
            if(~isempty(c{k}))
                cmean(k)=mean(c{k}(round(startt/dt):round(endt/dt)));
            end
        end
        assignin('base', 'cmean', cmean);
        set(handles.text_msg,'String',['"cmean" is exported : cmean(i) is a mean of c{i} from '...
            num2str(startt) 'sec to ' num2str(endt) 'sec']);
        

    case 'paired latency'
        if(handles.vNumaxes==0)
            set(handles.text_msg,'String','paired latency: no recording loaded');
            return;
        end


        pairs=[];
        for i=1:(handles.vNumaxes-1)
            apair=[];
            for j=(i+1):handles.vNumaxes
                if(~isempty(findstr(handles.vAxesinfo(i).fname, handles.vAxesinfo(j).fname)))
                    apair=[i j]; break;
                end
            end
            if(~isempty(apair))
                pairs=[pairs; apair];
            end
        end

        if(isempty(pairs))
            set(handles.text_msg,'String','paired latency macro : no paired recordings found');
            return;
        end

        answer=inputdlg({'puffer delay (ms)', '#spikes to compute'},'parameters',1,{'30.5','7'});
        if(isempty(answer))
            return;
        end
        if(isempty(answer{1}))
            return;
        end
        pufferdelay=str2num(answer{1});
        if(isempty(pufferdelay))
            set(handles.text_msg,'String','paired latency macro : wrong input for the puffer delay');
            return;
        end
        if(isempty(answer{2}))
            return;
        end
        %         if(pufferdelay<0 || pufferdelay > 500)
        %             set(handles.text_msg,'String','paired latency macro : puffer delay is too small or large');
        %             return;
        %         end

        nspks2compute=str2num(answer{2});
        if(isempty(nspks2compute))
            set(handles.text_msg,'String','paired latency macro : wrong input for the number of spikes to compute');
            return;
        end
        if(nspks2compute<0 || nspks2compute > 20)
            set(handles.text_msg,'String','paired latency macro : #spikes to compute is too small or large');
            return;
        end


        figure(300);clf;
        figure(301);clf;
        figure(302);clf;


        for i=1:size(pairs,1)
            spktA0=handles.vAxesinfo(pairs(i,1)).spkk*handles.vAxesinfo(pairs(i,1)).dt;
            firstk=find(spktA0>handles.vAxesinfo(pairs(i,1)).stimstart+pufferdelay,1,'first');
            spktA(i,:)=spktA0((firstk-1):(firstk+nspks2compute-1));
            %             firstspkt(i,1)=spktA(firstk);
            %             precedspkt(i,1)=spktA(firstk-1);
            %             secondspkt(i,1)=spktA(firstk+1);
            %             thirdspkt(i,1)=spktA(firstk+2);

            spktB0=handles.vAxesinfo(pairs(i,2)).spkk*handles.vAxesinfo(pairs(i,2)).dt;
            firstk=find(spktB0>handles.vAxesinfo(pairs(i,2)).stimstart+pufferdelay,1,'first');
            spktB(i,:)=spktB0((firstk-1):(firstk+nspks2compute-1));
            %             firstspkt(i,2)=spktB(firstk);
            %             precedspkt(i,2)=spktB(firstk-1);
            %             secondspkt(i,2)=spktB(firstk+1);
            %             thirdspkt(i,2)=spktB(firstk+2);
        end

        diffAB=spktA-spktB;
        if(size(diffAB,2)<9)
            colormap(lines(size(diffAB,2)));
        else
            colormap(hsv(size(diffAB,2)));
        end
        cm=colormap;




        for i=2:size(diffAB,2);
            x=diffAB(:,1);
            y=diffAB(:,i);

            figure(300);plot(x,y,'d','MarkerFaceColor',cm(i-1,:),'MarkerEdgeColor','none','MarkerSize', 7);
            nowaxis=axis; hold on; x9=[nowaxis(1)-diff(nowaxis(1:2)) nowaxis(2)+diff(nowaxis(1:2))];
            p=polyfit(x,y,1);
            plot(x9, polyval(p,x9),'Color',cm(i-1,:),'LineWidth',1);
            mse0=std(y-polyval(p,x),1);
            text(max(x)-10,polyval(p,max(x)-10),strcat('spike#',num2str(i-1),', rmse=',num2str(mse0)),'Color',cm(i-1,:));
            axis(nowaxis);
        end
        xlabel('last spontaneous spike(A)-last spontanoues spike(B) (ms)');
        ylabel('first evoked spike(A) - first evoked spike(B) (ms)');
        title(strcat('from ', handles.vAxesinfo(pairs(1,1)).fname,' ... ', handles.vAxesinfo(pairs(end,2)).fname,...
            ' : simultaneous pairs'), 'Interpreter','none');

        if(i==2 )
            %if only the first spikes are analyzed,
            for j=1:length(x)
                prevspiketiming(j)=min(handles.vAxesinfo(pairs(1,1)).stimstart+pufferdelay-spktA(j,1),...
                    handles.vAxesinfo(pairs(1,2)).stimstart+pufferdelay-spktB(j,1));
                %text(x(j),y(j),num2str(j));%mark each event with the last spike timing
                %text(x(j),y(j),num2str(prevspiketiming(j)));
            end
            figure(303);
            plot(prevspiketiming,y-polyval(p,x),'d','MarkerFaceColor','b',...
                'MarkerEdgeColor','none','MarkerSize', 7);
            xlabel('idle time after the last spike');
            ylabel('square error of relative shift sample from the fit line');
        end

        for i=1:factorial(size(diffAB,1))
            diffAB2=spktA-spktB(randperm(size(diffAB,1)),:);
            for j=2:size(diffAB2,2);
                x=diffAB2(:,1);
                y=diffAB2(:,j);

                p=polyfit(x,y,1);
                mse0(i,j)=std(y-polyval(p,x),1);
            end

            if(i>10 && (sum(abs(mean(mse0,1)-mse0(end,:))<0.1)==size(mse0,2)))%0.1msec
                for j=2:size(diffAB2,2)
                    y=diffAB2(:,j);

                    p=polyfit(x,y,1);
                    figure(301);plot(x,y,'d','MarkerFaceColor',cm(j-1,:),'MarkerEdgeColor','none','MarkerSize', 7);
                    nowaxis=axis; hold on;x9=[nowaxis(1)-diff(nowaxis(1:2)) nowaxis(2)+diff(nowaxis(1:2))];
                    plot(x9, polyval(p,x9),'Color',cm(j-1,:),'LineWidth',1);
                    text(min(x),polyval(p,min(x)),strcat('spike#',num2str(j-1),', rmse=',num2str(mse0(i,j))),'Color',cm(j-1,:));
                    axis(nowaxis);
                end
                break;
            end

        end

        xlabel('last spontaneous spike(A)-last spontanoues spike(B)(ms)');
        ylabel('first evoked spike(A) - first evoked spike(B)(ms)');
        title(strcat('from ', handles.vAxesinfo(pairs(1,1)).fname,' ... ', handles.vAxesinfo(pairs(end,2)).fname,...
            ' : non-simultaneous pairs'), 'Interpreter','none');


        %
        %
        %         z=diff(secondspkt,1,2);
        %         p=polyfit(x,z,1);
        %         figure(300);plot(x,z,'gd','MarkerFaceColor','g','MarkerEdgeColor','none','MarkerSize', 7);
        %         nowaxis=axis;
        %         plot(nowaxis(1:2), [nowaxis(1)*p(1)+p(2) nowaxis(2)*p(1)+p(2)],'g','LineWidth',1);


        %         z=diff(thirdspkt,1,2);
        %         p=polyfit(x,z,1);
        %         figure(300);
        %         plot(x,z,'rd','MarkerFaceColor','r','MarkerEdgeColor','none','MarkerSize', 7);
        %         nowaxis=axis;
        %         plot(nowaxis(1:2), [nowaxis(1)*p(1)+p(2) nowaxis(2)*p(1)+p(2)],'r','LineWidth',1);


        %         x=precedspkt(:,1);
        %         y=firstspkt(:,1);
        x=spktA(:,1);
        y=spktA(:,2);
        p1=polyfit(x,y,1);






        figure(302);plot(x,y,'bd','MarkerFaceColor','b','MarkerEdgeColor','none','MarkerSize', 7);
        hold on;


        %         x=precedspkt(:,2);
        %         y=firstspkt(:,2);
        x=spktB(:,1);
        y=spktB(:,2);
        p2=polyfit(x,y,1);

        figure(302);plot(x,y,'rd','MarkerFaceColor','r','MarkerEdgeColor','none','MarkerSize', 7);
        xlabel('last spontaneous spike timing (ms)');        ylabel('first evoked spike timing (ms)');
        title(strcat('from ', handles.vAxesinfo(pairs(1,1)).fname,' ... ', handles.vAxesinfo(pairs(end,2)).fname),...
            'Interpreter','none');
        nowaxis=axis;x9=[nowaxis(1)-diff(nowaxis(1:2)) nowaxis(2)+diff(nowaxis(1:2))];
        hold on;

        plot(x9, polyval(p1,x9),'b','LineWidth',1);
        plot(x9, polyval(p2,x9),'r','LineWidth',1);




        assignin('base','firstspkt',spktA);
        assignin('base','precedspkt',spktB);


    case 'compute d(t)'
        if(handles.vNumaxes==0)
            set(handles.text_msg,'String','computed d(t): no recording loaded');
            return;
        end


        pairs=[];
        for i=1:(handles.vNumaxes-1)
            apair=[];
            for j=(i+1):handles.vNumaxes
                if(~isempty(findstr(handles.vAxesinfo(i).fname, handles.vAxesinfo(j).fname)))
                    apair=[i j]; break;
                end
            end
            if(~isempty(apair))
                pairs=[pairs; apair];
            end
        end


        if(isempty(pairs))
            set(handles.text_msg,'String','no paired recordings found');
            return;
        end

        for i=1:size(pairs,1)

            %clear decoding pane
            handles.activetab=3;
            updatetab(handles);
            pushbutton_clearall_Callback(handles.pushbutton_clearall,[],handles);
            handles=guidata(hObject);
            handles.activetab=2;
            updatetab(handles);


            handles=vSwitchaxes2(handles, pairs(i,1));

            %moving to the decoding pane
            pushbutton_2decode_Callback(handles.pushbutton_2decode, [], handles)
            handles=guidata(hObject);



            %decode
            pushbutton_zoomrange_Callback(handles.pushbutton_zoomrange,...
                eventdata,handles,'noverbose',[4 9]);
            handles=guidata(hObject);

            pushbutton_cutout_Callback(handles.pushbutton_dCutout, eventdata, handles)
            handles=guidata(hObject);

            set(handles.popupmenu_decmethod,'Value',11);
            pushbutton_tdm_Callback(handles.pushbutton_tdm, eventdata, handles)
            handles=guidata(hObject);

            pushbutton_zoomrange_Callback(handles.pushbutton_zoomrange,...
                eventdata,handles,'noverbose',[4.5 8]);
            handles=guidata(hObject);

            pushbutton_cutout_Callback(handles.pushbutton_dCutout, eventdata, handles)
            handles=guidata(hObject);

            u1{i}=handles.dec.ut{2};
            t1{i}=handles.dec.t{2};


            %back to view pane
            handles.activetab=2;
            updatetab(handles);





            handles=vSwitchaxes2(handles, pairs(i,2));

            %moving to the decoding pane
            pushbutton_2decode_Callback(handles.pushbutton_2decode, [], handles)
            handles=guidata(hObject);


            %decode
            pushbutton_zoomrange_Callback(handles.pushbutton_zoomrange,...
                eventdata,handles,'noverbose',[4 9]);
            handles=guidata(hObject);

            pushbutton_cutout_Callback(handles.pushbutton_dCutout, eventdata, handles)
            handles=guidata(hObject);

            set(handles.popupmenu_decmethod,'Value',11);
            pushbutton_tdm_Callback(handles.pushbutton_tdm, eventdata, handles)
            handles=guidata(hObject);

            pushbutton_zoomrange_Callback(handles.pushbutton_zoomrange,...
                eventdata,handles,'noverbose',[4.5 8]);
            handles=guidata(hObject);

            pushbutton_cutout_Callback(handles.pushbutton_dCutout, eventdata, handles)
            handles=guidata(hObject);

            u2{i}=handles.dec.ut{2};
            t2{i}=handles.dec.t{2};

        end
        t=t1{1};
        for i=1:length(t1)
            if(t(1) >t1{i}(1) || t(1) > t2{i}(1))
                t=t(2:end);
            end
            if(t(end)>t1{i}(end) || t(end) > t1{i}(end))
                t=t(1:(end-1));
            end
        end

        for i=1:length(t1)
            u1{i}=interp1(t1{i},u1{i},t,'spline');t1{i}=t;
            u2{i}=interp1(t2{i},u2{i},t,'spline');t2{i}=t;
            d(i,:)=u1{i}-u2{i};
            figure(100);plot(t*1000,d(i,:));hold all;
        end
        xlabel('time (ms)');ylabel('v1-v2');

        dmean=mean(d,1);
        dstd=std(d,1,1);
        darea=[dmean-dstd; dstd*2; ]';

        figure(101);
        h=area(t*1000,darea,'BaseValue',min(min(darea)),'EdgeColor','none');
        set(h(1),'FaceColor',[1 1 1]);
        set(h(2),'FaceColor',[.6 0.8 0.4]);
        hold on;plot(t*1000,dmean,'r');
        xlabel('time (ms)');
        title('mean(v1-v2)');

        %         figure(102);
        %         for i=1:size(d,1)
        %             plot(t*1000,dmean-d(i,:)); hold all;
        %         end
        %         xlabel('time (ms)');
        %         title('noise : dm-di');




        assignin('base', 't1', t1);
        assignin('base', 'u1', u1);
        assignin('base', 't2', t2);
        assignin('base', 'u2', u2);
        assignin('base', 'd', d);

    case 'align by 1st spike'
        if(handles.vNumaxes==0)
            return;
        end

        answer=inputdlg('1st spike after ...','enter onset moment(ms)',1,{''});
        timemsec=str2num(answer{1});
        if(isempty(timemsec))
            set(handles.text_msg,'String','input incorrect');
            return;
        end
        for i=1:(handles.vNumaxes)
            timek=(timemsec+handles.vAxesinfo(i).t0)/handles.vAxesinfo(i).dt;
            firstspkk=find(handles.vAxesinfo(i).spkk>timek,1,'first');
            if(isempty(firstspkk))
                set(handles.text_msg,'String',sprintf('no spike after timemsec on axes#%d',i));
                return;
            end
            handles.vAxesinfo(i).spkk=handles.vAxesinfo(i).spkk-handles.vAxesinfo(i).spkk(firstspkk)+timek;
        end
        guidata(hObject,handles);



    case '1st spike jitter'
        if(handles.vNumaxes==0)
            return;
        end


        answer=inputdlg({'1st spike after ...', '#spikes'},'enter onset moment(ms)',1,{'5000','1'});
        if(isempty(answer))
            return;
        end

        timemsec=str2num(answer{1});
        nspks=round(str2num(answer{2}));
        if(isempty(timemsec) || isempty(nspks))
            set(handles.text_msg,'String','input incorrect');
            return;
        end
        if(nspks<1)
            set(handles.text_msg,'String','input incorrect');
            return;
        end


        firstspkt=zeros(handles.vNumaxes,nspks);
        firstspktb=zeros(handles.vNumaxes,nspks);
        ischannel1=zeros(handles.vNumaxes,1);
        ischannel2=zeros(handles.vNumaxes,1);
        for i=1:(handles.vNumaxes)
            timek=(timemsec+handles.vAxesinfo(i).t0)/handles.vAxesinfo(i).dt;
            firstspkk=find(handles.vAxesinfo(i).spkk>timek,nspks,'first');
            if(length(firstspkk)<nspks)
                set(handles.text_msg,'String',sprintf('no spike after timemsec on axes#%d',i));
                %return;
            else
                ischannel2(i)=(handles.vAxesinfo(i).fname(end)=='b');
                if(~ischannel2(i))
                    ischannel1(i)=1;
                    firstspkt(i,:)=handles.vAxesinfo(i).spkk(firstspkk)*handles.vAxesinfo(i).dt+handles.vAxesinfo(i).t0;
                else
                    firstspktb(i,:)=handles.vAxesinfo(i).spkk(firstspkk)*handles.vAxesinfo(i).dt+handles.vAxesinfo(i).t0;
                end
            end

        end

        firstspkt=firstspkt(logical(ischannel1),:);
        firstspktb=firstspktb(logical(ischannel2),:);

        %channel1
        if(~isempty(firstspkt))
            figure('Name','first spike jitter - channel#1');
            for i=1:nspks
                plot(1:size(firstspkt,1), firstspkt(:,i));hold all;
                legendstr{i}=sprintf('std(%d)=%2.2f',i,std(firstspkt(:,i)));
            end
            legend(legendstr);xlabel('trial index');ylabel('time (ms)');
        end
        if(~isempty(firstspktb))
            figure('Name','first spike jitter - channel#2');
            for i=1:nspks
                plot(1:size(firstspktb,1), firstspktb(:,i));hold all;
                legendstr{i}=sprintf('std(%d)=%2.2f',i,std(firstspktb(:,i)));
            end
            legend(legendstr);xlabel('trial index');ylabel('time (ms)');

        end

    case 'two pulse'
        %grouping experiment based upon the stimdur
        TPgroupdur=[]; %TP stands for 'two pulses'
        for i=1:length(handles.vAxesinfo)
            if(handles.vAxesinfo(i).npulses==2)
                if(isempty(find(TPgroupdur==sum(handles.vAxesinfo(i).stimdur))))
                    TPgroupdur(end+1)=handles.vAxesinfo(i).stimdur;
                end
            end
        end

        if(isempty(TPgroupdur))
            set(handles.text_msg,'String','no axes with two pulses');
            return;
        end

        TPgroupnum=zeros(1,length(handles.vAxesinfo));
        for i=1:length(handles.vAxesinfo)
            if(handles.vAxesinfo(i).npulses==2)
                for j=1:length(TPgroupdur)
                    if(sum(handles.vAxesinfo(i).stimdur)==TPgroupdur(j))
                        TPgroupnum(i)=j;
                        break;
                    end
                end
            end
        end


        %analyzing stimulation type
        % k=0;
        % TPinfo={};
        % TPaxesindices={};
        %
        % for i=1:length(handles.vAxesinfo)
        %     infoindex=0;
        %     if(handles.vAxesinfo(i).npulses==2)
        %         TPgroupnum(end+1)=find(TPgroupdur==handles.vAxesinfo(i).stimdur);
        %
        %         for j=1:length(TPinfo)
        %             if(sum(TPinfo{j}==[handles.vAxesinfo(i).stimstart handles.vAxesinfo(i).stimdur...
        %                     handles.vAxesinfo(i).stimpause])==3)
        %                 infoindex=j;
        %                 break;
        %             end
        %         end
        %
        %         if(infoindex==0)
        %             TPinfo{end+1}=[handles.vAxesinfo(i).stimstart handles.vAxesinfo(i).stimdur...
        %                 handles.vAxesinfo(i).stimpause];
        %             TPaxesindices{end+1}=i;
        %         else
        %             TPaxesindices{infoindex}=[TPaxesindices{infoindex} i];
        %         end
        %     end
        % end

        %finding the latency of the puff
        pufflatencies=[];
        for i=1:length(handles.vAxesinfo)
            if(handles.vAxesinfo(i).npulses==2 && handles.vAxesinfo(i).stimstart>50 &&...
                    ~isempty(handles.vAxesinfo(i).c))
                c_aroundpuffk=round(((handles.vAxesinfo(i).stimstart-50):...
                    handles.vAxesinfo(i).dt:(handles.vAxesinfo(i).stimstart+100))/handles.vAxesinfo(i).dt);
                c_aroundpuff=handles.vAxesinfo(i).c(c_aroundpuffk);
                [Y I]=max(c_aroundpuff);
                if(I>=round(60/handles.vAxesinfo(i).dt))
                    maxbase9=max(c_aroundpuff(1:round(60/handles.vAxesinfo(i).dt)));
                    pufflatencies(end+1)=find(c_aroundpuff>maxbase9,1,'first');
                end
            end
        end
        pufflatency=round(median(pufflatencies)*handles.vAxesinfo(i).dt)-50;


        %compute responsedur
        for i=1:length(TPgroupdur)
            TPgroup_responsedur=[];
            for j=1:length(handles.vAxesinfo)
                if(TPgroupnum(j)==i)
                    spkk_afterpuff=handles.vAxesinfo(j).spkk(handles.vAxesinfo(j).spkk >=...
                        (pufflatency+handles.vAxesinfo(j).stimstart)/handles.vAxesinfo(j).dt);
                    lastspkk=0;
                    for k=2:length(spkk_afterpuff)
                        ISIratio=(spkk_afterpuff(k+1)-spkk_afterpuff(k))/(spkk_afterpuff(k)-spkk_afterpuff(k-1));
                        if(ISIratio>1.5) %if interspike interval increase by the factor of 1.5
                            lastspkk=spkk_afterpuff(k);
                            break;
                        end
                    end
                    if(lastspkk~=0)
                        TPgroup_responsedur(end+1)=lastspkk*handles.vAxesinfo(j).dt...
                            -handles.vAxesinfo(j).stimstart;
                    end
                end
            end
            responsedur(i)=max(ceil(max(TPgroup_responsedur)),TPgroupdur(i));
        end


        %counting two pulse responses
        TPinfo=zeros(length(handles.vAxesinfo),5);
        firstspkk={};secondspkk={};
        nowaxesnum=handles.vNowaxes;
        for i=1:length(handles.vAxesinfo)
            TPinfo(i,1:3)=[handles.vAxesinfo(i).stimstart sum(handles.vAxesinfo(i).stimdur)...
                handles.vAxesinfo(i).stimpause];
            first0=(pufflatency+handles.vAxesinfo(i).stimstart)./handles.vAxesinfo(i).dt;
            first1=first0+responsedur(TPgroupnum(i))./handles.vAxesinfo(i).dt;

            second0=(pufflatency+handles.vAxesinfo(i).stimstart+sum(handles.vAxesinfo(i).stimdur)+...
                handles.vAxesinfo(i).stimpause)./handles.vAxesinfo(i).dt;
            second1=second0+responsedur(TPgroupnum(i))./handles.vAxesinfo(i).dt;

            firstspkk{i}=handles.vAxesinfo(i).spkk(find(handles.vAxesinfo(i).spkk>=first0 &...
                handles.vAxesinfo(i).spkk<=first1));
            secondspkk{i}=handles.vAxesinfo(i).spkk(find(handles.vAxesinfo(i).spkk>=second0 &...
                handles.vAxesinfo(i).spkk<=second1));
        end


        %compute max number of spikes to the first puff
        for i=1:length(TPgroupdur)
            TPgroup_maxnumspks=[];
            for j=1:length(handles.vAxesinfo)
                if(TPgroupnum(j)==i)
                    if(handles.vAxesinfo(j).stimpause > responsedur(i)-sum(handles.vAxesinfo(j).stimdur))
                        TPgroup_maxnumspks(end+1)=length(firstspkk{j});
                    end
                end
            end
            maxnumspks(i)=median(TPgroup_maxnumspks);
        end





        %resove conflict
        for i=1:length(handles.vAxesinfo)
            if(handles.vAxesinfo(i).stimpause <= responsedur(TPgroupnum(i))-sum(handles.vAxesinfo(i).stimdur) &&...
                    length(firstspkk{i}) > maxnumspks(TPgroupnum(i)))
                firstspkk{i}=firstspkk{i}(1:floor(maxnumspks(TPgroupnum(i))));
            end
            dropk=zeros(size(secondspkk{i}));
            for j=1:length(secondspkk{i})
                if(~isempty(find(firstspkk{i}==secondspkk{i}(j))))
                    dropk(j)=1;
                end
            end
            secondspkk{i}=secondspkk{i}(~dropk);

            TPinfo(i,4)=length(firstspkk{i});
            TPinfo(i,5)=length(secondspkk{i});

            handles=vSwitchaxes2(handles, i); guidata(hObject, handles);
            pushbutton_zoomrange_Callback(handles.pushbutton_zoomrange,...
                eventdata,handles,'noverbose',[firstspkk{i}(1) secondspkk{i}(end)]*handles.vAxesinfo(i).dt/1000);
            plot(handles.vHaxes(i), firstspkk{i}*handles.vAxesinfo(i).dt,  handles.vAxesinfo(i).d(firstspkk{i}),'ko','MarkerFaceColor','k');
            plot(handles.vHaxes(i), secondspkk{i}*handles.vAxesinfo(i).dt,  handles.vAxesinfo(i).d(secondspkk{i}),'mo','MarkerFaceColor','m');

            handles=guidata(hObject);
            drawnow;
        end
        handles=vSwitchaxes2(handles, nowaxesnum);guidata(hObject, handles);



        for i=1:length(TPgroupdur)
            TPgrouppause{i}=[];
            for j=1:length(handles.vAxesinfo)
                if(TPgroupnum(j)==i)
                    index2=find(TPgrouppause{i}==handles.vAxesinfo(j).stimpause);
                    if(isempty(index2))
                        TPgrouppause{i}=[TPgrouppause{i} handles.vAxesinfo(j).stimpause];
                        index2=length(TPgrouppause{i});
                        TPratio{i}{index2}=[];
                    end
                    TPratio{i}{index2}(end+1)=TPinfo(j,5)/TPinfo(j,4);
                end
            end
        end

        %plot dots on each axes




        %plot summary
        figure(10);
        for i=1:length(TPgroupdur)
            for j=1:length(TPgrouppause{i})
                TPratio_avg{i}(j)=mean(TPratio{i}{j});
            end
            [TPgrouppause{i} IX]= sort(TPgrouppause{i});
            TPratio_avg{i}=TPratio_avg{i}(IX);
            plot(TPgrouppause{i},TPratio_avg{i});
            hold all;
            legendstr{i}=strcat('stimdur=',num2str(TPgroupdur(i)));
        end
        legend(legendstr);


        guidata(hObject, handles);

    case 'export all C'
        if(handles.vNumaxes==0)
            set(handles.text_msg,'String','no data loaded');
            return;
        end
        for k=1:handles.vNumaxes
            t=((1:length(handles.vAxesinfo(k).c))-1)*handles.vAxesinfo(k).dt+handles.vAxesinfo(k).t0;
            if(~isempty(handles.vAxesinfo(k).stimstart))
                c0=mean(handles.vAxesinfo(k).c(t>handles.vAxesinfo(k).stimstart-500 & t<handles.vAxesinfo(k).stimstart));
            else
                c0=0;
            end
            t0{k}=t;
            c{k}=handles.vAxesinfo(k).c;
            if(isfield(handles.vAxesinfo(k),'ppmfactor'))
                if(~isempty(handles.vAxesinfo(k).ppmfactor))
                    c{k}=(handles.vAxesinfo(k).c-c0)*handles.vAxesinfo(k).ppmfactor;
                    fname{k}=handles.vAxesinfo(k).fname;
                end
            end
                    
        end
        assignin('base', 'tc', t0);
        assignin('base', 'c', c);
        assignin('base','fname',fname);
        set(handles.text_msg,'String','c{i},tc{i},fname{i} :concentration, time, filename for the ith axes');

    case 'export all spkt'
        for i=1:(handles.vNumaxes)
            fname{i}=handles.vAxesinfo(i).fname;
            spkt{i}=handles.vAxesinfo(i).spkk*handles.vAxesinfo(i).dt+handles.vAxesinfo(i).t0;
        end
        assignin('base','spkt',spkt);
        assignin('base','fname',fname);
    otherwise
        set(handles.text_msg,'String','macro not found');
end



% --- Executes on button press in pushbutton_setdetectionparams.
function pushbutton_setdetectionparams_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_setdetectionparams (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

answer=inputdlg({'P2P change tolerance(default:0.45)','ISI change tolerance in stim(default:0.25)','minimum ISI(default:1.5)'},...
    'detection params',1,{num2str(handles.p2pchangetolerance),num2str(handles.isichangetolerance), num2str(handles.minISI)});
if(isempty(answer))
    return;
end

msg=[];
p2pchangetolerance=str2num(answer{1});
if(~isempty(p2pchangetolerance))
    if(p2pchangetolerance>0 && p2pchangetolerance <=1)
        handles.p2pchangetolerance=p2pchangetolerance;
    else
        msg=[msg 'p2p change tolerance is out of range.. not update'];
    end
end
isichangetolerance=str2num(answer{2});
if(~isempty(isichangetolerance))
    if(isichangetolerance>0 && isichangetolerance <=1)
        handles.isichangetolerance=isichangetolerance;
    else
        msg=[msg 'ISI change tolerance is out of range.. not update'];
    end
end

minISI=str2num(answer{3});
if(~isempty(minISI))
    if(minISI>0)
        handles.minISI=minISI;
    else
        msg=[msg 'minISI is out of range.. not update'];
    end
end
if(isempty(msg))
    set(handles.text_msg,'String','detection parameters updated successfully');
else
    set(handles.text_msg,'String',msg);
end

guidata(hObject,handles);





function yi=interp1_anmo(x,Y,xi)
[x ix]=sort(x);
Y=Y(ix);

%discard duplicate samples
while(1)
    z=[(diff(x)==0) 0];
    if(sum(z)==0)
        break;
    end
    x=x(~z);Y=Y(~z);
end

if(length(x)<2)
    yi=zeros(size(xi));
    return;
end

yi=interp1(x,Y,xi);

ix=find(isnan(yi));
for i=1:length(ix)
    %interpolate linearly
    if(xi(ix)<min(x))%if isNaN because sample point is too low
        yi(ix)=Y(1)-(x(1)-xi(ix))*(Y(2)-Y(1))/(x(2)-x(1));
    else
        yi(ix)=Y(end)-(x(end)-xi(ix))*(Y(end)-Y(end-1))/(x(end)-x(end-1));
    end
end


% --- Executes on button press in pushbutton_gotoaxes.
function pushbutton_gotoaxes_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_gotoaxes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(handles.vNumaxes<2)
    return;
end

answer = inputdlg({strcat('number of pages:1...',num2str(handles.vNumaxes))}, 'jump to pages...', 1, {''});
if(isempty(answer))
    return;
end
naxes=str2num(answer{1});
if(isempty(naxes))
    set(handles.text_msg,'String','invalid number');
    return;
end

if(naxes<0 || naxes>handles.vNumaxes)
    set(handles.text_msg,'String','axes number out of range');
    return;
end


handles=vSwitchaxes2(handles, naxes);
guidata(hObject, handles);



% --- Executes on button press in pushbutton_setsortingparams.
function pushbutton_setsortingparams_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_setsortingparams (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

answer=inputdlg({'number of spike types','number of pre-learning trials','number of post-learning trails'},...
    'spike sorting params',1,{num2str(handles.nSpikeTypes),num2str(handles.nPreLearn),num2str(handles.nPostLearn)});
if(isempty(answer))
    set(handles.text_msg,'String','set sorting params : escaped');
    return;
end




msg=[];
nSpikeTypes=str2num(answer{1});
nPreLearn=str2num(answer{2});
nPostLearn=str2num(answer{3});
if(~isempty(nSpikeTypes))
    if(nSpikeTypes>0)
        handles.nSpikeTypes=round(nSpikeTypes);
    else
        msg=[msg 'number of spike types must be positive...'];
    end
end



if(~isempty(nPreLearn))
    if(nPreLearn>=0)
        handles.nPreLearn=round(nPreLearn);
    else
        msg=[msg 'nPreLearn must be positive integer, or 0 to skip...'];
    end
end



if(~isempty(nPostLearn))
    if(nPostLearn>=0)
        handles.nPostLearn=round(nPostLearn);
    else
        msg=[msg 'nPostLearn must be positive integer, or 0 to skip...'];
    end
end



if(isempty(msg))
    set(handles.text_msg,'String','sorting parameters updated successfully');
else
    set(handles.text_msg,'String',msg);
end


guidata(hObject,handles);


if(isempty(handles.find.spkk))
    set(handles.text_msg,'String','no detected spike found');
    return;
end

set(handles.text_msg,'String','hold on... detecting features for spike sorting');


dt=handles.find.t(2)-handles.find.t(1);
spkk=handles.find.spkk(1:min(end, find(handles.find.spkk<length(handles.find.d),1,'last')));

cwtdata=cwt(handles.find.d, [15 50 150], 'coif3');
cwtdata=cwtdata./((max(cwtdata')-min(cwtdata'))'*ones(1,size(cwtdata,2)));%normalize

cwtdata1=cwtdata(:,spkk);
% figure;plot3(data(1,:),data(2,:),data(3,:),'LineStyle','none','Marker','o','MarkerFaceColor','b');
% xlabel('scale 15');ylabel('scale 50'); zlabel('scale 140');


feature=zeros(3,length(spkk));
for i=1:length(spkk)
    before=handles.find.d((max(1,spkk(i)-round(2/dt)):spkk(i)));
    after=handles.find.d((spkk(i)+1):min(length(handles.find.d),spkk(i)+round(1/dt)));
    [a ix1]=min(before);
    [b ix2]=min(after);
    feature(1,i)=handles.find.d(spkk(i))-min(before);
    feature(2,i)=handles.find.d(spkk(i))-min(after);

    %feature(3,i)=round(1.5/dt)-ix1+ix2;
    %feature(3,i)=ix2;
    feature(3,i)=handles.find.d(spkk(i))-min(before);
    feature(4,i)=handles.find.d(spkk(i))-min(after);%amplitude of peak
    feature(5,i)=handles.find.d(spkk(i));
    feature(6,i)=mean(before);
%    feature(7,i)=mean(after);
    m0=mean([before; after]);
    feature(7,i)=(handles.find.d(spkk(i))-m0)./(m0-min(before));
end
feature0=feature;%back up
feature=feature./((max(feature')-min(feature'))'*ones(1,size(feature,2)));%normalize

% figure;plot3(feature(1,:),feature(2,:),feature(3,:),'LineStyle','none','Marker','o','MarkerFaceColor','b');
% xlabel('p2p_before');ylabel('p2p_after'); zlabel('spike width');

feature=[feature; cwtdata1];


coeffs=princomp(feature');
feature_pca=coeffs*feature;

[IDX,C,sumd,D]=kmeans(feature', handles.nSpikeTypes);
handles.SortingC=C;%centroid

for i=1:handles.nSpikeTypes
    idx{i}=find(IDX==i);
    mean_amplitude(i)=mean(feature0(4,idx{i}));
end


[temp axesorder]=sort(mean_amplitude,'descend');

IDX2=zeros(size(IDX));
for i=1:length(axesorder)
    IDX2(idx{axesorder(i)})=i;
    idx2(i)=idx(axesorder(i));
end

cm=colormap(lines(handles.nSpikeTypes));
figure(425);clf;
for i=1:handles.nSpikeTypes
    plot3(feature_pca(1,idx2{i}),feature_pca(2,idx2{i}),feature_pca(3,idx2{i}),'Marker','o','LineStyle','none','MarkerEdgeColor',cm(i,:),'MarkerFaceColor',cm(i,:));hold on;
    legendstr{i}=strcat('type#',num2str(i));
end
xlabel('pc1');ylabel('pc2'); zlabel('pc3');
legend(legendstr);


figure(426);clf;
for i=1:handles.nSpikeTypes
    haxes(i)=subplot(ceil(handles.nSpikeTypes/13),min(13,handles.nSpikeTypes),i);
    title(strcat('#',num2str(i),' : ',num2str(length(idx2{i})),' spk'));
    hold on;
end
%for i=1:handles.nSpikeTypes
%    haxes(i)=subplot(1,handles.nSpikeTypes,i);title(strcat('#',num2str(i),
%    ' : ',num2str(length(idx2{i})),' spk'));hold on;
%end

for i=1:(length(spkk)-1)
    plot(haxes((IDX2(i))), handles.find.t((max(1,spkk(i)-round(2/dt)):min(length(handles.find.d),spkk(i)+round(3/dt))))-handles.find.t(spkk(i)),...
        handles.find.d((max(1,spkk(i)-round(2/dt)):(spkk(i)+round(3/dt)))));  hold on;
end


for i=1:handles.nSpikeTypes
    nowaxis(i,:)=axis(haxes(i));
end

newaxis=[-2 3 min(nowaxis(:,3)) max(nowaxis(:,4))];
for i=1:handles.nSpikeTypes
    axis(haxes(i),newaxis);
end



answer=inputdlg({'spike type vector (e.g. [1 4]) for type#1&4'},...
    'choose spike types',1,{strcat('   ',num2str(1))});
if(isempty(answer))
    return;
end




% 
% typeidx=str2num(answer{1});
% if(isempty(typeidx))
%     set(handles.text_msg,'String','input invalid');
%     return;
%     %using the distance
% else



typeidx=str2num(answer{1});
if(isempty(typeidx))
    set(handles.text_msg,'String','input invalid');
    return;

elseif(sum(typeidx<0)==length(typeidx))
        ctypeidx=ones(1,handles.nSpikeTypes);
        ctypeidx(-typeidx)=0;
        typeidx=find(ctypeidx==1);
else
        typeidx=typeidx(typeidx>0);
end




if(handles.nPreLearn==0 && handles.nPostLearn==0)
    typeidx=axesorder(typeidx);
    dist=sum(D(:,typeidx)');
    [temp order]=sort(dist);
    nitems=0;
    spkkindex=[];
    for j=1:length(typeidx)
        spkkindex=[spkkindex; idx{typeidx(j)}];
    end
    spkkindex=sort(spkkindex);

else %use neural network
    typeidx=axesorder(typeidx);
    dist=sum(D(:,typeidx)');
    [temp order]=sort(dist);
    nitems=0;
    for j=1:length(typeidx)
        nitems=nitems+length(idx{typeidx(j)});
    end

    inputk=order(max(1,round(nitems*0.6)):min(length(order),round((nitems*1.4))));

    T=zeros(2,size(feature,2));
    T(2,:)=1;
    for j=1:length(typeidx)
        T(1,idx{typeidx(j)})=1;
        T(2,idx{typeidx(j)})=0;
    end
    if(~isempty(handles.SortingNet))
        if(handles.nSpikeTypes==size(handles.SortingNet.IW{1},2))
            net=handles.SortingNet;
        else
            net=newp(D',T);
        end
    else
        net=newp(D',T);
    end

    net.trainParam.epochs = handles.nPreLearn;
    net.trainParam.goal = 0.01;
    neworder=randperm(size(D,1));

    net = train(net,D(neworder,:)',T(:,neworder));
    inputk=inputk(randperm(length(inputk)));

    for i=1:min(length(inputk), handles.nPostLearn)
        handles.find.xrange=handles.find.t(spkk(order(inputk(i))))+[-50 50];
        guidata(hObject,handles);
        updatefindaxesxrange(handles);

        out1=sim(net,D(inputk(i),:)');
        if(out1(1)==1)
            set(handles.togglebutton_fAcceptSpike,'FontSize',15,'FontWeight','bold','Visible','on','Value',0);
            set(handles.togglebutton_fRejectSpike,'FontSize',8,'FontWeight','light','Visible','on','Value',0);
        else
            set(handles.togglebutton_fAcceptSpike,'FontSize',8,'FontWeight','light','Visible','on','Value',0);
            set(handles.togglebutton_fRejectSpike,'FontSize',15,'FontWeight','bold','Visible','on','Value',0);
        end
        set(handles.togglebutton_fStopSorting,'Visible','on','Value',0);
        uiwait(handles.figure1);

        if(get(handles.togglebutton_fAcceptSpike,'Value'))
            train(net,D(inputk(i),:)',[1; 0]);
        elseif(get(handles.togglebutton_fRejectSpike,'Value'))
            train(net,D(inputk(i),:)',[0; 1]);
        elseif(get(handles.togglebutton_fStopSorting,'Value'))
            break;
        end
    end

    out=sim(net,D');
    spkkindex=find(out(1,:)==1);

    handles.SortingNet=net;
    % else
    %     spkkindex=[];
    %     for i=1:length(typeidx)
    %         spkkindex=[spkkindex; idx2{typeidx(i)}];
    %     end
    %     spkkindex=sort(spkkindex);
end




handles.find.spkk0=handles.find.spkk;
handles.find.spkk=handles.find.spkk0(spkkindex);


reddot=handles.find.d(handles.find.spkk);

if(ishandle(handles.find.hreddot))
    set(handles.find.hreddot, 'XData', handles.find.spkk*dt, 'YData', reddot);
else
    axes(handles.axes_find1)
    handles.find.hreddot=line(handles.find.spkk*dt, reddot,'Color','r','Marker','o','LineStyle','none');
end


handles.find.info.nspks=length(handles.find.spkk);

guidata(hObject, handles);

set(handles.text_msg, 'String', strcat(num2str(length(handles.find.spkk)),' spk(s) sorted'));
set(handles.text_fInfo,'String',inf2str(handles.find.info));

guidata(hObject,handles);






% --- Executes on button press in togglebutton_fAcceptSpike.
function togglebutton_fAcceptSpike_Callback(hObject, eventdata, handles)
% hObject    handle to togglebutton_fAcceptSpike (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(hObject,'Visible','off');
set(handles.togglebutton_fRejectSpike,'Visible','off');
set(handles.togglebutton_fStopSorting,'Visible','off');
uiresume(handles.figure1);




% --- Executes on button press in togglebutton_fRejectSpike.
function togglebutton_fRejectSpike_Callback(hObject, eventdata, handles)
% hObject    handle to togglebutton_fRejectSpike (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(hObject,'Visible','off');
set(handles.togglebutton_fAcceptSpike,'Visible','off');
set(handles.togglebutton_fStopSorting,'Visible','off');
uiresume(handles.figure1);




% --- Executes on button press in togglebutton_fStopSorting.
function togglebutton_fStopSorting_Callback(hObject, eventdata, handles)
% hObject    handle to togglebutton_fStopSorting (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of togglebutton_fStopSorting
set(hObject,'Visible','off');
set(handles.togglebutton_fAcceptSpike,'Visible','off');
set(handles.togglebutton_fRejectSpike,'Visible','off');
uiresume(handles.figure1);






% --- Executes on button press in pushbutton_sortspikes.
function pushbutton_sortspikes_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_sortspikes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.text_msg,'String','hold on... detecting features for spike sorting');


dt=handles.find.t(2)-handles.find.t(1);
spkk=handles.find.spkk(1:min(end, find(handles.find.spkk<length(handles.find.d),1,'last')));

cwtdata=cwt(handles.find.d, [15 50 150], 'coif3');
cwtdata=cwtdata./((max(cwtdata')-min(cwtdata'))'*ones(1,size(cwtdata,2)));%normalize

cwtdata1=cwtdata(:,spkk);
% figure;plot3(data(1,:),data(2,:),data(3,:),'LineStyle','none','Marker','o','MarkerFaceColor','b');
% xlabel('scale 15');ylabel('scale 50'); zlabel('scale 140');


feature=zeros(3,length(spkk));
for i=1:length(spkk)
    before=handles.find.d((max(1,spkk(i)-round(2/dt)):spkk(i)));
    after=handles.find.d((spkk(i)+1):min(length(handles.find.d),spkk(i)+round(3/dt)));
    [a ix1]=min(before);
    [b ix2]=min(after);
    feature(1,i)=handles.find.d(spkk(i))-min(before);
    feature(2,i)=handles.find.d(spkk(i))-min(after);

    %feature(3,i)=round(1.5/dt)-ix1+ix2;
    %feature(3,i)=ix2;
    feature(3,i)=handles.find.d(spkk(i))-min(before);
    feature(4,i)=handles.find.d(spkk(i))-min(after);%amplitude of peak
    feature(5,i)=handles.find.d(spkk(i));
    feature(6,i)=mean(before);
    feature(7,i)=mean(after);
end
feature0=feature;%back up
feature=feature./((max(feature')-min(feature'))'*ones(1,size(feature,2)));%normalize

% figure;plot3(feature(1,:),feature(2,:),feature(3,:),'LineStyle','none','Marker','o','MarkerFaceColor','b');
% xlabel('p2p_before');ylabel('p2p_after'); zlabel('spike width');

feature=[feature; cwtdata1];



for i=1:size(handles.SortingC,1)
    %as many as the clusters
    D(i,:)=(sum((feature-handles.SortingC(i,:)'*ones(1,size(feature,2))).^2)); %squared Euclidean distance
end





out=sim(handles.SortingNet,D);
spkkindex=find(out(1,:)==1);


handles.find.spkk0=handles.find.spkk;
handles.find.spkk=handles.find.spkk0(spkkindex);


reddot=handles.find.d(handles.find.spkk);

if(ishandle(handles.find.hreddot))
    set(handles.find.hreddot, 'XData', handles.find.spkk*dt, 'YData', reddot);
else
    axes(handles.axes_find1)
    handles.find.hreddot=line(handles.find.spkk*dt, reddot,'Color','r','Marker','o','LineStyle','none');
end


handles.find.info.nspks=length(handles.find.spkk);

guidata(hObject, handles);

set(handles.text_msg, 'String', strcat(num2str(length(handles.find.spkk)),' spk(s) sorted'));
set(handles.text_fInfo,'String',inf2str(handles.find.info));

guidata(hObject,handles);


% --- Executes on button press in pushbutton_fFlattenThreshold.
function pushbutton_fFlattenThreshold_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_fFlattenThreshold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if(isempty(handles.find.delta) || isempty(handles.find.hdeltaline))
    return;
end
val = get(handles.slider_finddeltax, 'Value');
sliderstep = get(handles.slider_finddeltax, 'SliderStep');
scrollbarwidth =1-1/(1+sliderstep(2));
val = val*(1-scrollbarwidth);

startx = max(0,val);
endx= min(1, val+scrollbarwidth);

%reduce the range from 0.01 to 0.99
startx = startx*0.97+0.015;
endx = endx*0.97+0.015;

if(startx>endx)
    endx=startx+0.01;
end;

nowaxis=axis(handles.axes_find2);

startt=nowaxis(1)+(nowaxis(2)-nowaxis(1))*startx;
endt=nowaxis(1)+(nowaxis(2)-nowaxis(1))*endx;
dt=handles.find.t(2)-handles.find.t(1);
startk = round(startt/dt);
endk = round(endt/dt);

handles.find.delta(startk:endk)=mean(handles.find.delta(startk:endk));
set(handles.find.hdeltaline, 'YData', handles.find.delta)
guidata(hObject,handles);




% --- Executes on button press in pushbutton_dPlotSpikeBasedError.
function pushbutton_dPlotSpikeBasedError_Callback(hObject, eventdata, handles, dst)
% hObject    handle to pushbutton_dPlotSpikeBasedError (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isempty(handles.dec.ut) || isempty(handles.dec.tk))
    set(handles.text_msg,'String', 'at least one u(t) and one tk must be present');
    t=[];err=[];
    return;
end


handles=update_tem_params(handles);%to use the threshold


if(nargin<4)
    dst=[];
elseif(~isnumeric(dst))
    dst=[];
end

dst=dst(dst>0 & dst<=length(handles.dec.ut));

nowtk=handles.dec.tk{handles.dec.tkindex};

if(isempty(dst))
    defAns{1}='1';

    input0 = inputdlg({'indices of uxx'}, 'computing error of uxx for every isi', [1]', defAns);
    if(isempty(input0)) return; end; %if 'cancel' button clicked

    dst=str2num(input0{1});
    dst=dst(dst>0 & dst<=length(handles.dec.ut));
    if(isempty(dst))
        warndlg('invalid inputs: type indices of ut');
        return;
    end;
end

delta=handles.temparams.threshold;
if(length(nowtk)<length(delta))
    delta=delta(1:length(nowtk));
else
    delta((end+1):length(nowtk))=delta(end);
end


for i=1:length(dst)
    nowt=handles.dec.t{dst(i)};
    nowut=handles.dec.ut{dst(i)}+handles.genut.b;

    for j=1:(length(nowtk)-1)
        ink=find(nowt>=nowtk(j) & nowt<nowtk(j+1));
        ink(end+1)=ink(end)+1;
        v=sum((nowut(ink(1:(end-1)))+nowut(ink(2:end))).*diff(nowt(ink)))/2;
        err(i,ink)=(delta(j+1)-v)./(nowt(ink(end))-nowt(ink(1)));
    end
end

figure(79);hold all;plot(1000*nowt(1:length(err)),20*log10(abs(err)));



function edit_dRefrac_Callback(hObject, eventdata, handles)
% hObject    handle to edit_dRefrac (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_dRefrac as text
%        str2double(get(hObject,'String')) returns contents of edit_dRefrac as a double


% --- Executes during object creation, after setting all properties.
function edit_dRefrac_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_dRefrac (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in pushbutton_dSave.
function pushbutton_dSave_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dSave (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if(isempty(handles.dec.tk) && isempty(handles.dec.ut))
    return;
end

c0=clock;
fnhead=sprintf('%4d_%02d_%02d_',c0(1), c0(2),c0(3));

for k=1:100
    fname=strcat(fnhead,'fsDecode',num2str(k-1),'.mat');
    if(~exist(fname,'file'))
        break;
    end
end


answer = inputdlg('file name','matlab file name',1,{fname});
if(~isempty(answer))
    handles=update_tem_params(handles);

    dec=handles.dec;
    genut=handles.genut;
    temparams=handles.temparams;
    assignin('base','dec',dec);
    assignin('base','genut',genut);
    assignin('base','temparams',temparams);
    save(answer{1},'dec','genut','temparams');

    set(handles.text_msg,'String',['all information in decoding panel saved in ' fname ' and exported to the base working space as ''dec''']);
    drawnow;
end


% --- Executes on button press in pushbutton_dload.
function pushbutton_dload_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dload (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[fname pathname]=uigetfile('*.mat','select an decspike matlab file');

if(~fname)
    set(handles.text_msg,'String','no file chosen');
    return;
end

load([pathname fname]);

if(~exist('dec') || ~exist('genut') || ~exist('temparams'))
    set(handles.text_msg,'String','not a proper decspike file');
    return;
end

if(isempty(dec) || isempty(genut) || isempty(temparams))
    set(handles.text_msg,'some parameters are empty');
    return;
end

handles.dec=dec;
handles.genut=genut;
handles.temparams=temparams;
handles=d_update_axestk(handles);
handles=update_dec_ut(handles);
guidata(hObject,handles);

update_genut_params(handles);
update_tem_params(handles,'updategui');%updategui



set(handles.text_msg,'String',['all information in decoding panel saved in ' fname ' and exported to the base working space as ''dec''']);




% --- Executes on button press in pushbutton_genut2.
function pushbutton_genut2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_genut2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
cmdstr=get(handles.edit_genut2,'String');

%replace uxx with handles.uxx
ulocations=findstr(cmdstr,'u');i=[];
if(~isempty(ulocations))
    for k=1:length(ulocations)
        if(length(cmdstr)>=ulocations(k)+2)
            i=str2num(cmdstr(ulocations(k)+[1 2]));
            if(~isempty(i))
                if(i<=length(handles.dec.ut))
                    %then replace
                    if(ulocations(k)==1)
                        cmdstr=strcat('handles.',cmdstr);
                    else
                        cmdstr=strcat(cmdstr(1:(ulocations(k)-1)),...
                            'handles.dec.ut{',sprintf('%2d',i),'}', cmdstr((ulocations(k)+3):end));
                    end
                    ulocations=ulocations+15;
                end
            end
        end
    end
end
if(isempty(i))
    lasti=1;
else
    lasti=i;
end

%if(cmdstr(1)~='=') cmdstr=strcat('=',cmdstr);end
if(cmdstr(end)~=';') cmdstr=strcat(cmdstr,';');end

d1=0;
try
    eval(strcat('unew',cmdstr));
catch
    set(handles.text_msg,'String','syntax error');
    return;
end

handles.cmdstr=get(handles.edit_genut2,'String');
if(~isempty(unew))
    newindex=length(handles.dec.ut)+1;
    handles.dec.ut{newindex}=unew;
    if(length(handles.dec.ut{newindex})<length(handles.dec.ut{lasti}))
        halfgap=round((length(handles.dec.ut{lasti})-length(handles.dec.ut{newindex}))/2);
        handles.dec.t{newindex}=handles.dec.t{lasti}((1:length(handles.dec.ut{newindex}))+halfgap-1);
    elseif(length(handles.dec.ut{newindex})>length(handles.dec.ut{lasti}))
        handles.dec.ut{newindex}=handles.dec.ut{newindex}(1:length(handles.dec.ut{lasti}));
        handles.dec.t{newindex}=handles.dec.t{lasti};
    else
        handles.dec.t{newindex}=handles.dec.t{lasti};
    end
end

handles=update_dec_ut(handles,'addlastonly');
guidata(hObject, handles);




% --- Executes on button press in pushbutton_dfilter.
function pushbutton_dfilter_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dfilter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

nowutk=get(handles.popupmenu_listofu,'Value');
if(length(handles.dec.ut)<nowutk || length(handles.dec.t) <nowutk)
    set(handles.text_msg,'String', 'psd plotting failed: some data missing(ut, t, f)');
    return;
end

ut=handles.dec.ut{nowutk};

if(isempty(ut))
    set(handles.text_msg,'String', 'psd plotting failed: some data missing(ut, t, f)');
    return;
end

dt=1;
if(~isempty(handles.dec.t{nowutk}))
    dt=handles.dec.t{nowutk}(2)-handles.dec.t{nowutk}(1);
end

answer = inputdlg({'cut off frequency[Hz]'},'cut off frequency',1,{'15'});
if(isempty(answer))
    return;
end

fc=str2num(answer{1});
if(isempty(fc))
    return;
end
if(fc<=0)
    return;
end


oversampleR=round((1/dt/2)/fc);

b = fircls1(min(oversampleR*20, 400),1/oversampleR,0.02,0.008);
y=filter(b, 1, ut);

set(handles.text_msg,'String',['taking a low pass filter with fc=' num2str(fc) 'Hz']);drawnow;
newindex=length(handles.dec.ut)+1;
handles.dec.ut{newindex}=y;
handles.dec.t{newindex}=handles.dec.t{nowutk}-mean(grpdelay(b,1))*dt;
    

handles=update_dec_ut(handles,'addlastonly');
guidata(hObject, handles);
set(handles.text_msg,'String','new signal created by filtering');


% --- Executes on button press in pushbutton_vsavetk.
function pushbutton_vsavetk_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_vsavetk (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if(handles.vNumaxes==0)
    return;
end
m=0;
for i=1:handles.vNumaxes
    if(exist([handles.mfolder handles.vAxesinfo(i).fname '.mat'],'file'))
        m=m+1;
        spkk=handles.vAxesinfo(i).spkk;
        save([handles.mfolder handles.vAxesinfo(i).fname '.mat'], '-append','spkk');
        set(handles.text_msg,'String',[handles.vAxesinfo(i).fname '.mat updated']);
        drawnow;
    end
end

set(handles.text_msg,'String',['spike sequence updated for ' ...
    num2str(m) 'out of' num2str(handles.vNumaxes) 'axes']);

% 
% % --- Executes on mouse press over axes background.
% function axes_find1_ButtonDownFcn(hObject, eventdata, handles)
% % hObject    handle to axes_find1 (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% get(hObject,'CurrentPoint')


function axes_find1_AddSpike(hObject, eventdata, handles)

if(~strcmp(get(gcbf,'SelectionType'),'alt'))
    %only for the right click
%     set(handles.text_msg,'String','Right click the mouse to add a spike');
    return;
end

pts = get(handles.axes_find1,'CurrentPoint');
t1=pts(1,1);
y1=pts(1,2);
xl=get(handles.axes_find1,'XLim');
yl=get(handles.axes_find1,'YLim');
dx=diff(xl);dy=diff(yl);

if(~isempty(handles.find.spkk))
    dt=handles.find.t(2)-handles.find.t(1);
    spkt=handles.find.spkk*dt;
    if(sum(spkt>t1-1&spkt<t1+1)>0)
        %if spike exist within 1 ms distance, do not add
        set(handles.text_msg,'String','spike not added because an existing spike found within 1 ms distance');
        return;
    end
    startk=round((t1-1)/dt);endk=round((t1+1)/dt);
%     [junk mink]=min((handles.find.d(startk:endk)'-y1).^2./dy^2*16+((startk:endk)-(t1/dt)).^2./dx^2);
%     t2k=startk+mink-1;
    [junk maxk]=max((handles.find.d(startk:endk)'));
    t2k=startk+maxk-1;    
    
    handles.find.spkk=sort([handles.find.spkk t2k],'ascend');
    set(handles.find.hreddot,'XData',handles.find.spkk*dt, 'YData',handles.find.d(handles.find.spkk));
    handles.find.info.nspks=length(handles.find.spkk);
    set(handles.text_msg,'String',['A spike is added at t=' num2str(round(t2k*dt))]);
else
    set(handles.text_msg,'String','no spike variable exist. this part to be implemented later... ');
end

guidata(hObject,handles);
    
  
  
  
  
  
function axes_find1_RemoveSpike(hObject, eventdata, handles)

if(~strcmp(get(gcbf,'SelectionType'),'normal'))
    %only for the right click
%     set(handles.text_msg,'String','left click the mouse to remove a spike');
    return;
end

pts = get(handles.axes_find1,'CurrentPoint');
t1=pts(1,1);y1=pts(1,2);
xl=get(handles.axes_find1,'XLim');
yl=get(handles.axes_find1,'YLim');
dx=diff(xl);dy=diff(yl);

if(~isempty(handles.find.spkk))
    dt=handles.find.t(2)-handles.find.t(1);
    spkt=handles.find.spkk*dt;
    y0=handles.find.d(handles.find.spkk);
    if(size(y0,1)~=size(spkt,1))
        y0=y0';
    end
    purgedk=find(spkt>t1-min(3,dx/50)&spkt<t1+min(3,dx/50)&y0>y1-dy/25&y0<y1+dy/25);
    if(~isempty(purgedk))
        if(length(purgedk)>1)
            %if there are multple
            distx=(spkt(purgedk)-t1).^2;
            disty=(y0(purgedk)-y1).^2;
            [temp mink]=min(distx+disty);
            purgedk=purgedk(mink);
        end
        validk=true(size(spkt));
        validk(purgedk)=false; t5=spkt(purgedk);
        handles.find.spkk=handles.find.spkk(validk);
        set(handles.find.hreddot,'XData',handles.find.spkk*dt, 'YData',handles.find.d(handles.find.spkk));
        handles.find.info.nspks=length(handles.find.spkk);
        set(handles.text_msg,'String',['A spike at t=' num2str(round(t5)) ' is removed' ]);
    else
        set(handles.text_msg,'String',['no spike found at this at t='  num2str(round(t1)) 'ms']);
    end
    
else
    set(handles.text_msg,'String','weird.. this should never happen.. ');
end

guidata(hObject,handles);
    


function vAxes_AddSpike(hObject, eventdata, handles)

if(~strcmp(get(gcbf,'SelectionType'),'alt'))
    %only for the right click
%     set(handles.text_msg,'String','Right click the mouse to add a spike');
    return;
end

ii=handles.vNowaxes;
pts = get(handles.vHaxes(ii),'CurrentPoint');
t1=pts(1,1);
y1=pts(1,2);
xl=get(handles.vHaxes(ii),'XLim');
yl=get(handles.vHaxes(ii),'YLim');
dx=diff(xl);dy=diff(yl);

if(~isempty(handles.vAxesinfo(ii).spkk))
    dt=handles.vAxesinfo(ii).dt;
    spkt=handles.vAxesinfo(ii).spkk*dt;
    if(sum(spkt>t1-1&spkt<t1+1)>0)
        %if spike exist within 1 ms distance, do not add
        set(handles.text_msg,'String','spike not added because an existing spike found within 1 ms distance');
        return;
    end
    startk=round((t1-1.5)/dt);endk=round((t1+1.5)/dt);
%     [junk mink]=min((handles.vAxesinfo(ii).d(startk:endk)'-y1).^2./dy^2*36+((startk:endk)-(t1/dt)).^2./dx^2);
%     t2k=startk+mink-1;
    [junk maxk]=max((handles.vAxesinfo(ii).d(startk:endk)'));
    t2k=startk+maxk-1;
    
    handles.vAxesinfo(ii).spkk=sort([handles.vAxesinfo(ii).spkk t2k],'ascend');
    set(handles.vAxesinfo(ii).hreddot,'XData',handles.vAxesinfo(ii).spkk*dt, 'YData',handles.vAxesinfo(ii).d(handles.vAxesinfo(ii).spkk));
%     handles.find.info.nspks=length(handles.find.spkk);
    set(handles.text_msg,'String',['A spike is added at t=' num2str(round(t2k*dt))]);
else
    set(handles.text_msg,'String','no spike variable exist. this part to be implemented later... ');
end

guidata(hObject,handles);
    
  





function vAxes_RemoveSpike(hObject, eventdata, handles)

if(~strcmp(get(gcbf,'SelectionType'),'normal'))
    %only for the right click
%     set(handles.text_msg,'String','left click the mouse to remove a spike');
    return;
end
ii=handles.vNowaxes;
pts = get(handles.vHaxes(ii),'CurrentPoint');
t1=pts(1,1);y1=pts(1,2);
xl=get(handles.vHaxes(ii),'XLim');
yl=get(handles.vHaxes(ii),'YLim');
dx=diff(xl);dy=diff(yl);

if(~isempty(handles.vAxesinfo(ii).spkk))
    dt=handles.vAxesinfo(ii).dt;
    spkt=handles.vAxesinfo(ii).spkk*dt;
    y0=handles.vAxesinfo(ii).d(handles.vAxesinfo(ii).spkk);
    if(size(y0,1)~=size(spkt,1))
        y0=y0';
    end
    purgedk=find(spkt>t1-min(3,dx/50)&spkt<t1+min(3,dx/50)&y0>y1-dy/25&y0<y1+dy/25);
    if(~isempty(purgedk))
        if(length(purgedk)>1)
            %if there are multple
            distx=(spkt(purgedk)-t1).^2;
            disty=(y0(purgedk)-y1).^2;
            [temp mink]=min(distx+disty);
            purgedk=purgedk(mink);
        end
        validk=true(size(spkt));
        validk(purgedk)=false; t5=spkt(purgedk);
        handles.vAxesinfo(ii).spkk=handles.vAxesinfo(ii).spkk(validk);
        set(handles.vAxesinfo(ii).hreddot,'XData',handles.vAxesinfo(ii).spkk*dt,...
            'YData',handles.vAxesinfo(ii).d(handles.vAxesinfo(ii).spkk));
%         handles.find.info.nspks=length(handles.find.spkk);
        set(handles.text_msg,'String',['A spike at t=' num2str(round(t5)) ' is removed' ]);
    else
        set(handles.text_msg,'String',['no spike found at this at t='  num2str(round(t1)) 'ms']);
    end
    
else
    set(handles.text_msg,'String','weird.. this should never happen.. ');
end

guidata(hObject,handles);
    
