function [data inf]= import_edr(filename)
%Anmo Kim @ Rockefeller University
%6/15/2011
%-Importing EDR (Electrophysiology Data Recordings) file to matlab data
%  structure
%- EDR is a data file format used in WinEDR software
%- WinEDR is a data acquisition and analysis program for handling signals
%  from electrophysiological experiments
%- WinEDR is a part of SES(Strathclyde Electrophysiology Software) package
%- The Strathclyde Electrophysiology Software package is a suite of
%  programs for the acquisition and analysis of electrophysiological signals, 
%  developed by the author at the department of Physiology & Pharmacology, 
%  University of Strathclyde. 


data=[];inf.name={}; inf.val={};

if(~exist(filename,'file'))
    %if the file does not exist, try with additional extension characters
    if(isempty(findstr(lower(filename),'.edr')));
        filename=[filename '.edr'];
    end
end

if(~exist(filename,'file'))
    warning([filename ' does not exist.']);
    return;
end

fp=fopen(filename,'r');

header=fscanf(fp, '%c', 2048);

equalidx=findstr(header,'=');% find equal signs
cridx=find(int8(header)==13);%13 for the carriage return
infnameidx=[1 (cridx(1:(end-1))+2)];% indices of the inf name

%reading header informations
NC=0;%default
for i=1:length(equalidx)
    inf.name{i}=header(infnameidx(i):(equalidx(i)-1));
    valuestr=header((equalidx(i)+1):(cridx(i)-1));
    if(isempty(str2num(valuestr)))
        %if there exists any alphabet character
        inf.val{i}=valuestr;
    else
        inf.val{i}=str2num(valuestr);
    end
end

Vars={'NC','NP','AD','ADCMAX','YAG0','YCF0','YZ0','YAG1','YCF1','YZ1'};%required variables to interpret the data array

for i=1:length(Vars)
    eval([Vars{i} '= 0;']);
    for j=1:length(inf.name)
        if(length(inf.name{j})==length(Vars{i}))
            if(strcmp(inf.name{j},Vars{i}))
                eval([Vars{i} '=inf.val{j};']);
                break;
            end
        end
    end
end



%reading data
data=fread(fp,NP,'int16');

data=reshape(data(:),NC,NP/NC);
if(~isempty(data))
    data(1,:)=(data(1,:)-YZ0)*AD/YCF0/YAG0/(ADCMAX+1);
    if(size(data,1)>1)
        data(2,:)=(data(2,:)-YZ1)*AD/YCF1/YAG1/(ADCMAX+1);
    end
end

data=data(1,:)';

fclose(fp);



