function varargout = loadn(varargin)
% LOADN M-file for loadn.fig
%      LOADN, by itself, creates a new LOADN or raises the existing
%      singleton*.
%
%      H = LOADN returns the handle to a new LOADN or the handle to
%      the existing singleton*.
%
%      LOADN('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in LOADN.M with the given input arguments.
%
%      LOADN('Property','Value',...) creates a new LOADN or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before loadn_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to loadn_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help loadn

% Last Modified by GUIDE v2.5 11-Jul-2008 12:18:14

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @loadn_OpeningFcn, ...
                   'gui_OutputFcn',  @loadn_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before loadn is made visible.
function loadn_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to loadn (see VARARGIN)

% Choose default command line output for loadn
handles.output = hObject;

FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
if isempty(gcbf)
   ScreenUnits=get(0,'Units');
   set(0,'Units','pixels');
   ScreenSize=get(0,'ScreenSize');
   set(0,'Units',ScreenUnits);

   FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
   FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
else
   GCBFOldUnits = get(gcbf,'Units');
   set(gcbf,'Units','pixels');
   GCBFPos = get(gcbf,'Position');
   set(gcbf,'Units',GCBFOldUnits);
   FigPos(1:2) = [(GCBFPos(1) + GCBFPos(3) / 2) - FigWidth / 2, ...
      (GCBFPos(2) + GCBFPos(4) / 2) - FigHeight / 2];
end
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Make the GUI modal
set(handles.figure1,'WindowStyle','modal')


%Anmo's code from this point
if(length(varargin)<2) return; end
handles.finfo = varargin{1};
handles.figure0 = varargin{2};
handles.h0=guidata(handles.figure0);

set(handles.figure1,'Name','FlySpikes: loading data files (*.mat)');



%set outputs
handles.nowpicks=[];
%handles.plotoption=[];
handles.downsampleratio=[];


if(isempty(handles.h0.mfolder))
    handles.configfile=strcat(pwd(),'/flyspikestemp.mat');
else
    handles.configfile=strcat(handles.h0.mfolder(1:(end-2)),'flyspikestemp.mat');
end

if(isempty(handles.finfo))
   delete(gcf);
   return;
end


handles.filespercolumn=10;
handles.columnsperpage=3;
handles.numcolumns=ceil(length(handles.finfo)/handles.filespercolumn);
handles.hcheckbox=zeros(handles.filespercolumn*handles.columnsperpage,1);
handles.htext=zeros(handles.filespercolumn*handles.columnsperpage,1);
handles.selected=zeros(length(handles.finfo),1);
handles.onfilek=[]; %indices of file names shown on the window
handles.nowfirstcolumn = 1;




%load previously defined sets
handles.picklist={[]};
if(exist(handles.configfile,'file'))
    load(handles.configfile,'picklist');
    if(exist('picklist','var'))
        handles.picklist=picklist;
    end
end

liststr={};
for i=1:length(handles.picklist)
    liststr{i}=num2str(i-1);
end
liststr{end+1}='new';

set(handles.popupmenu_pickset,'String', liststr, 'Value',length(liststr));
handles.lastpickset=length(liststr);

handles=updatepage(handles);


% Update handles structure
guidata(hObject, handles);

% UIWAIT makes loadn wait for user response (see UIRESUME)
uiwait(handles.figure1);







% --- Outputs from this function are returned to the command line.
function varargout = loadn_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
%varargout{1} = handles.output;
if(isfield(handles,'nowpicks'))
    varargout{1} = handles.nowpicks;
    %   varargout{2} = handles.plotoption;
    %   varargout{3} = handles.downsampleratio;
    varargout{2} = handles.downsampleratio;
    %    if(get(handles.checkbox_plotafterclearall,'Value'))
    %        varargout{3}='plotafterclearall';
    %    else
    %        varargout{3}=[];
    %    end

    liststr=get(handles.popupmenu_pickset,'String');
    val=get(handles.popupmenu_pickset,'Value');
    str=liststr{val};
    
    picklist=handles.picklist;
    
    if(strcmpi(str,'new'))
        picklist{val}=handles.nowpicks;
    else
        %numbers
        picklist{val}=handles.nowpicks;
        picklist=picklist(1:(end-1));
    end
    if(exist(handles.configfile,'file'))    
        save(handles.configfile,'picklist','-append');
    else
        save(handles.configfile,'picklist')
    end
    
   delete(handles.figure1);
else
   varargout{1} = [];
   varargout{2} = [];
   varargout{3} = [];
%   delete(handles.figure1);
end




% function handles=updatepage(handles)
% nfiles=length(handles.flist);
% if(nfiles==0) return; end
% 
% %update 'handles.selected'
% if(~isempty(handles.onfilek))
%    for k=1:length(handles.onfilek)
%       handles.selected(handles.onfilek(k))=get(handles.hcheckbox(k),'Value');
%       delete(handles.hcheckbox(k));
%       delete(handles.htext(k));
%    end
% end
% 
% columnsperpage=handles.columnsperpage;
% 
% figureposition=get(gcf,'Position');
% 
% yloc = (handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.62+.17;
% 
% if(columnsperpage>1)
%    for k=2:columnsperpage
%       yloc = [yloc ((handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.62+.17)];
%    end
% end
% 
% for k=1:(handles.filespercolumn*columnsperpage)
%    textx(k)=floor((k-1)/handles.filespercolumn)/columnsperpage+.02;
% end
% checkboxx = textx+.24;
% 
% nfiles2bshown=min(30,length(handles.flist)-(handles.nowfirstcolumn-1)*handles.filespercolumn);
% handles.onfilek=(1:nfiles2bshown)+(handles.nowfirstcolumn-1)*handles.filespercolumn;
% 
% for k=1:nfiles2bshown
%       handles.htext(k)=uicontrol('Parent', gcf,...
%       'Style', 'text',...
%       'String', handles.flist{k+handles.filespercolumn*(handles.nowfirstcolumn-1)},...
%       'Units', 'normalized',...
%       'Position', [textx(k) yloc(k) .22 .05]);
%    %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
% end
% 
% for k=1:nfiles2bshown
%    handles.hcheckbox(k)=uicontrol('Parent', gcf,...
%       'Style', 'Checkbox',...
%       'String', [],...
%       'Units', 'normalized',...
%       'Position', [checkboxx(k) yloc(k)+.01 .05 .05],...
%       'Value', handles.selected(k+handles.filespercolumn*(handles.nowfirstcolumn-1)),...
%       'Tag', sprintf('checkbox_%03d',k));
%    %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
% end
% set(handles.checkbox_all, 'Value', 0);
% set(handles.text_msg,'String', sprintf('%d files listed', length(handles.flist)));



function handles=updatepage(handles,useselected)
nfiles=length(handles.finfo);
if(nfiles==0) return; end

if(nargin<2) useselected='';
end

if(strcmpi(useselected,'useselected'))
    %update checkboxes
    if(~isempty(handles.onfilek))
        for k=1:length(handles.onfilek)
            set(handles.hcheckbox(k),'Value',handles.selected(handles.onfilek(k)));
            delete(handles.hcheckbox(k));
            delete(handles.htext(k));
        end
    end
else
    %update 'handles.selected'
    if(~isempty(handles.onfilek))
        for k=1:length(handles.onfilek)
            handles.selected(handles.onfilek(k))=get(handles.hcheckbox(k),'Value');
            delete(handles.hcheckbox(k));
            delete(handles.htext(k));
        end
    end
end

columnsperpage=handles.columnsperpage;

figureposition=get(gcf,'Position');

yloc = (handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.69+.17;

if(columnsperpage>1)
   for k=2:columnsperpage
      yloc = [yloc ((handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.69+.17)];
   end
end

for k=1:(handles.filespercolumn*columnsperpage)
   textx(k)=floor((k-1)/handles.filespercolumn)/columnsperpage+.02;
end
checkboxx = textx+.24;

nfiles2bshown=min(30,length(handles.finfo)-(handles.nowfirstcolumn-1)*handles.filespercolumn);
handles.onfilek=(1:nfiles2bshown)+(handles.nowfirstcolumn-1)*handles.filespercolumn;

for k=1:nfiles2bshown
      handles.htext(k)=uicontrol('Parent', gcf,...
      'Style', 'text',...
      'String', handles.finfo(k+handles.filespercolumn*(handles.nowfirstcolumn-1)).fname,...
      'Units', 'normalized',...
      'Position', [textx(k) yloc(k) .22 .05]);
   %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
end

for k=1:nfiles2bshown
   handles.hcheckbox(k)=uicontrol('Parent', gcf,...
      'Style', 'Checkbox',...
      'String', [],...
      'Units', 'normalized',...
      'Position', [checkboxx(k) yloc(k)+.01 .05 .05],...
      'Value', handles.selected(k+handles.filespercolumn*(handles.nowfirstcolumn-1)),...
      'Tag', sprintf('checkbox_%03d',k),...
      'ToolTipString',inf2str(handles.finfo(k+handles.filespercolumn*(handles.nowfirstcolumn-1))));
   %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
end
set(handles.checkbox_all, 'Value', 0);
set(handles.text_msg,'String', sprintf('%d files listed', length(handles.finfo)));


%==================================
function out=inf2str(finfo)
out=[];
names=fieldnames(finfo);
for k=1:length(names)
   eval(strcat('val=finfo.',names{k},';'));
   if(~isempty(val) )
      if(isnumeric(val) & length(val)<10)
         val=num2str(val);
      end
      if(isstr(val) && length(val)<60)
         out=strcat(out, names{k}, '=',val,',');
      end
   end
end




% --- Executes on button press in checkbox_all.
function checkbox_all_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_all (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_all
if(get(handles.checkbox_all, 'Value'))
   %selected
   for k=1:length(handles.onfilek)
      if(handles.hcheckbox(k)~=0)
         set(handles.hcheckbox(k),'Value',1);
      end
   end
   set(handles.checkbox_column1,'Value',1);
   set(handles.checkbox_column2,'Value',1);
   set(handles.checkbox_column3,'Value',1);
else
   %deselected
   for k=1:length(handles.onfilek)
      if(handles.hcheckbox(k)~=0)
         set(handles.hcheckbox(k),'Value',0);
      end
   end
   set(handles.checkbox_column1,'Value',0);
   set(handles.checkbox_column2,'Value',0);
   set(handles.checkbox_column3,'Value',0);
end




% --- Executes on button press in pushbutton_left.
function pushbutton_left_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_left (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
nowfirstcolumn=handles.nowfirstcolumn;
if(nowfirstcolumn >1)
   handles.nowfirstcolumn=max(1,nowfirstcolumn-3);
   handles=updatepage(handles);
   guidata(hObject, handles);
end
set(handles.checkbox_chx,'Value',0);


% --- Executes on button press in pushbutton_right.
function pushbutton_right_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_right (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
nowfirstcolumn=handles.nowfirstcolumn;
if(nowfirstcolumn <= (handles.numcolumns-2))
   handles.nowfirstcolumn=min(handles.numcolumns-2,nowfirstcolumn+3);
   handles=updatepage(handles);
   guidata(hObject, handles);
end
set(handles.checkbox_chx,'Value',0);


% --- Executes on button press in pushbutton_ok.
function pushbutton_ok_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_ok (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=updatepage(handles); %update 'handles.selected'
handles.nowpicks=find(handles.selected==1);
handles.nowpicks=handles.nowpicks(handles.nowpicks<=length(handles.finfo)); %
% if(get(handles.radiobutton_both,'Value'))
%    handles.plotoption=1;
% elseif(get(handles.radiobutton_donly,'Value'))
%    handles.plotoption=2;
% else
%    handles.plotoption=3;
% end

handles.downsampleratio=2;
downsampleratio=str2num(get(handles.edit_downsampleratio,'String'));
if(~isempty(downsampleratio))
   if(length(downsampleratio)==1)
      if(downsampleratio>0 && downsampleratio <100)
         handles.downsampleratio=ceil(downsampleratio);
      end
   end
end

guidata(hObject, handles);
uiresume(handles.figure1);
   
   





function edit_downsampleratio_Callback(hObject, eventdata, handles)
% hObject    handle to edit_downsampleratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_downsampleratio as text
%        str2double(get(hObject,'String')) returns contents of edit_downsampleratio as a double


% --- Executes during object creation, after setting all properties.
function edit_downsampleratio_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_downsampleratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in checkbox_column1.
function checkbox_column1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column1
if(length(handles.onfilek)>0)
   if(get(hObject, 'Value'))
      %selected
      for k=1:min(10,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',1);
         end
      end

   else
      %deselected
      for k=1:min(10,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',0);
         end
      end
   end
end

% --- Executes on button press in checkbox_column2.
function checkbox_column2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column2
if(length(handles.onfilek)>10)
   if(get(hObject, 'Value'))
      %selected
      for k=11:min(20,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',1);
         end
      end
   else
      %deselected
      for k=11:min(20,length(handles.onfilek))
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',0);
         end
      end
   end
end

% --- Executes on button press in checkbox_column3.
function checkbox_column3_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column3
if(length(handles.onfilek)>20)
   if(get(hObject, 'Value'))
      %selected
      for k=21:length(handles.onfilek)
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',1);
         end
      end
   else
      %deselected
      for k=21:length(handles.onfilek)
         if(handles.hcheckbox(k)~=0)
            set(handles.hcheckbox(k),'Value',0);
         end
      end
   end
end



% --- Executes on button press in pushbutton_viewinf.
function pushbutton_viewinf_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_viewinf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
viewinf(handles.figure0);



% --- Executes on button press in checkbox_plotafterclearall.
function checkbox_plotafterclearall_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_plotafterclearall (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_plotafterclearall





function edit_setnum_Callback(hObject, eventdata, handles)
% hObject    handle to edit_setnum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_setnum as text
%        str2double(get(hObject,'String')) returns contents of edit_setnum as a double


% --- Executes during object creation, after setting all properties.
function edit_setnum_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_setnum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



% --- Executes on selection change in popupmenu_pickset.
function popupmenu_pickset_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_pickset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_pickset contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_pickset
handles=updatepage(handles); %update 'handles.selected'
handles.nowpicks=find(handles.selected==1);

liststr=get(hObject,'String');
    

handles.picklist{handles.lastpickset}=handles.nowpicks;

val=get(hObject,'Value');
if(~strcmpi(liststr(val),'new'))
    handles.selected=zeros(length(handles.finfo),1);
    handles.selected(handles.picklist{val})=1;
    handles=updatepage(handles,'useselected');
end
handles.lastpickset=val;
guidata(hObject,handles);
    



% --- Executes during object creation, after setting all properties.
function popupmenu_pickset_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_pickset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in pushbutton_dellastpickset.
function pushbutton_dellastpickset_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_dellastpickset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=updatepage(handles); %update 'handles.selected'
handles.nowpicks=find(handles.selected==1);


handles.picklist{handles.lastpickset}=handles.nowpicks;

contents=get(handles.popupmenu_pickset,'String');
val=get(handles.popupmenu_pickset,'Value');
nitems=length(contents);

if(nitems>1)
    if(nitems==2)
        contents=contents(end);
        handles.picklist=handles.picklist(end);
    else
        contents=contents([1:(end-2) end]);
        handles.picklist=handles.picklist([1:(end-2) end]);
    end
    set(handles.popupmenu_pickset,'String',contents);

    set(handles.popupmenu_pickset,'Value',min(val,nitems-1));
end

handles.lastpickset=min(handles.lastpickset,nitems-1);

handles.nowpicks=handles.picklist{min(val,nitems-1)};
handles=updatepage(handles,'useselected');

guidata(hObject,handles);


% --- Executes on button press in checkbox_chx.
function checkbox_chx_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_chx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_chx

if(get(hObject, 'Value'))
   %deselected
   for k=1:length(handles.onfilek)
      if(handles.finfo(handles.onfilek(k)).fname(end)=='b')
         set(handles.hcheckbox(k),'Value',0);
      else
         set(handles.hcheckbox(k),'Value',1);
      end
   end
else
   %selected
   for k=1:length(handles.onfilek)
      if(handles.finfo(handles.onfilek(k)).fname(end)=='b')
         set(handles.hcheckbox(k),'Value',1);
      else
         set(handles.hcheckbox(k),'Value',0);
      end
   end
end
