function varargout = spikeplots(varargin)
% SPIKEPLOTS M-file for spikeplots.fig
%      SPIKEPLOTS, by itself, creates a new SPIKEPLOTS or raises the
%      existing
%      singleton*.
%
%      H = SPIKEPLOTS returns the handle to a new SPIKEPLOTS or the handle
%      to
%      the existing singleton*.
%
%      SPIKEPLOTS('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SPIKEPLOTS.M with the given input arguments.
%
%      SPIKEPLOTS('Property','Value',...) creates a new SPIKEPLOTS or raises the
%      existing singleton*.  Starting from the left, property value pairs
%      are
%      applied to the GUI before spikeplots_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to spikeplots_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help spikeplots

% Last Modified by GUIDE v2.5 20-Feb-2011 15:25:06

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @spikeplots_OpeningFcn, ...
    'gui_OutputFcn',  @spikeplots_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if(nargin<2) disp('spikeplots require two input arguments');return; end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT



% --- Executes just before spikeplots is made visible.
function spikeplots_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to spikeplots (see VARARGIN)

% Choose default command line output for spikeplots
handles.output = hObject;

FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
if isempty(gcbf)
    ScreenUnits=get(0,'Units');
    set(0,'Units','pixels');
    ScreenSize=get(0,'ScreenSize');
    set(0,'Units',ScreenUnits);
    
    FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
    FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
else
    GCBFOldUnits = get(gcbf,'Units');
    set(gcbf,'Units','pixels');
    GCBFPos = get(gcbf,'Position');
    set(gcbf,'Units',GCBFOldUnits);
    FigPos(1:2) = [(GCBFPos(1) + GCBFPos(3) / 2) - FigWidth / 2, ...
        (GCBFPos(2) + GCBFPos(4) / 2) - FigHeight / 2];
end
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Make the GUI modal
%set(handles.figure1,'WindowStyle','modal')


%Anmo's code from this point
validk=varargin{3};
for k=1:length(validk)
    finfo(k)=varargin{1}(validk(k));
    haxes0(k)=varargin{2}(validk(k));
end

handles.finfo=finfo;
handles.haxes0=haxes0;


set(handles.figure1,'Name','FlySpikes: plotting odor/spike data (*.mat)');

%set outputs
handles.filepicks=[];
handles.plottype=[];
%handles.downsampleratio=[];


if(isempty(handles.finfo))
    delete(handles.figure1);
    return;
end


hide_optioncontrols(handles);

%set(handles.checkbox_align, 'Visible','off');

%for concentration information
havingc=[];
for i=1:length(handles.finfo)
    if(~isempty(handles.finfo(i).c))
        havingc=[havingc i];
    end
end

handles.havingc=havingc;


%retrieve the last window configuration values
%handles.flist = varargin{1};



handles.h0=guidata(haxes0(1));

handles.filespercolumn=10;
handles.columnsperpage=3;
handles.numcolumns=ceil(length(handles.finfo)/handles.filespercolumn);
handles.hcheckbox=zeros(handles.filespercolumn*handles.columnsperpage,1);
handles.htext=zeros(handles.filespercolumn*handles.columnsperpage,1);
handles.selected=ones(length(handles.finfo),1);
handles.onfilek=[]; %indices of file names shown on the window
handles.nowfirstcolumn = 1;
handles=updatepage(handles);




handles.nfig=readconfigvar( handles.h0.configfname, 'sp_nfig');
if(~isempty(handles.nfig))
    set(handles.edit_nfig,'String',num2str(round(handles.nfig)));
end


temp=readconfigvar( handles.h0.configfname, 'sp_altperiod');
if(isempty(temp))
    handles.altperiod=2;
else
    handles.altperiod=temp;
end

handles.nbins=readconfigvar( handles.h0.configfname, 'sp_nbins');
if(~isempty(handles.nbins))
    set(handles.edit_nbins,'String',num2str(round(handles.nbins)));
end


handles.bingap=readconfigvar( handles.h0.configfname, 'sp_bingap');
if(~isempty(handles.bingap))
    set(handles.edit_bingap,'String',num2str(round(handles.bingap)));
end

handles.winx=readconfigvar( handles.h0.configfname, 'sp_winx');
if(~isempty(handles.winx))
    set(handles.edit_winx,'String',num2str(round(handles.winx)));
end

handles.manifold_nISI=readconfigvar( handles.h0.configfname, 'sp_manifold_nISI');
if(~isempty(handles.manifold_nISI))
    set(handles.edit_manifold_nISI,'String',num2str(round(handles.manifold_nISI)));
end
handles.manifold_ngrid=readconfigvar( handles.h0.configfname, 'sp_manifold_ngrid');
if(~isempty(handles.manifold_ngrid))
    set(handles.edit_manifold_ngrid,'String',num2str(round(handles.manifold_ngrid)));
end
handles.manifold_delta=readconfigvar( handles.h0.configfname, 'sp_manifold_delta');
if(~isempty(handles.manifold_delta))
    set(handles.edit_manifold_delta,'String',num2str(round(handles.manifold_delta)));
end
handles.manifold_fc=readconfigvar( handles.h0.configfname, 'sp_manifold_fc');
if(~isempty(handles.manifold_fc))
    set(handles.edit_manifold_fc,'String',num2str(round(handles.manifold_fc)));
end
handles.manifold_regularity_tolerance=readconfigvar( handles.h0.configfname, 'sp_manifold_regularity_tolerance');
if(~isempty(handles.manifold_regularity_tolerance))
    set(handles.edit_regularity_tolerance,'String',num2str((handles.manifold_regularity_tolerance)));
end


handles.PNManifold_OSNPSTH=readconfigvar(handles.h0.configfname, 'sp_PNManifold_OSNPSTH');
fname=handles.PNManifold_OSNPSTH;
k7=findstr(fname,'/');
if(~isempty(k7))
    fname=fname((k7(end)+1):end);
end

set(handles.edit_PNManifold_OSNPSTH,'String',fname);


handles.plottype=readconfigvar( handles.h0.configfname, 'sp_plottype');
if(~isempty(handles.plottype) && ischar(handles.plottype))
    if(isfield(handles, ['radiobutton_' handles.plottype]))
        if(eval(strcat('ishandle(handles.radiobutton_',handles.plottype,')')))
            eval(strcat('set(handles.radiobutton_',handles.plottype,',''Value'',1);'))
            guidata(hObject, handles);
            
            eval(strcat('radiobutton_',handles.plottype,'_Callback(handles.radiobutton_',...
                handles.plottype,',[],handles);'));
            handles=guidata(hObject);
        end
    end
end



handles.pufflatency=readconfigvar(handles.h0.configfname, 'sp_pufflatency');
if(~isempty(handles.pufflatency))
    set(handles.edit_pufflatency,'String',num2str(round(handles.pufflatency)));
else
    handles.pufflatency=str2num(get(handles.edit_pufflatency,'String'));
end

handles.fanofactorbinsize=readconfigvar( handles.h0.configfname, 'sp_fanofactorbinsize');
if(~isempty(handles.fanofactorbinsize))
    set(handles.edit_fanofactorbinsize,'String',num2str(round(handles.fanofactorbinsize)));
else
    handles.fanofactorbinsize=str2num(get(handles.edit_fanofactorbinsize,'String'));
end


handles.stasize=readconfigvar( handles.h0.configfname, 'sp_stasize');
if(~isempty(handles.stasize))
    set(handles.edit_stasize,'String',num2str(round(handles.stasize)));
else
    handles.stasize=str2num(get(handles.edit_stasize,'String'));
end


temp=readconfigvar(handles.h0.configfname,'sp_samecolor4pairs');
if(~isempty(temp))
    set(handles.checkbox_samecolor4pairs,'Value',temp);
end

temp=readconfigvar(handles.h0.configfname,'sp_ensembleaverage');
if(~isempty(temp))
    set(handles.checkbox_ensembleaverage,'Value',temp);
end

temp=readconfigvar(handles.h0.configfname,'sp_spikedensity');
if(~isempty(temp))
    set(handles.checkbox_spikedensity,'Value',temp);
end
temp=readconfigvar(handles.h0.configfname,'sp_plotonlymean');
if(~isempty(temp))
    set(handles.checkbox_plotonlymean,'Value',temp);
end
temp=readconfigvar(handles.h0.configfname,'sp_paironly');
if(~isempty(temp))
    set(handles.checkbox_paironly,'Value',temp);
end

temp=readconfigvar(handles.h0.configfname,'sp_Rcorr_sigma');
if(~isempty(temp))
    set(handles.edit_Rcorr_sigma,'String',num2str(temp));
else
    set(handles.edit_Rcorr_sigma,'String','5');
end

temp=readconfigvar(handles.h0.configfname,'sp_timecap0');
if(~isempty(temp))
    set(handles.edit_timecap0,'String',num2str(temp));
else
    set(handles.edit_timecap0,'String','0');
end

temp=readconfigvar(handles.h0.configfname,'sp_timecapend');
if(~isempty(temp))
    set(handles.edit_timecapend,'String',num2str(temp));
else
    set(handles.edit_timecapend,'String','30');
end



% Update handles structure
guidata(hObject, handles);

% UIWAIT makes spikeplots wait for user response (see UIRESUME)
uiwait(handles.figure1);




function hide_optioncontrols(h)

set(h.checkbox_separatepsth, 'Visible','off');
set(h.edit_winx, 'Visible','off');
set(h.text_windowsize, 'Visible','off');
set(h.edit_nbins, 'Visible','off');
set(h.edit_bingap, 'Visible','off');
set(h.text_nbins, 'Visible','off');
set(h.checkbox_yintime, 'Visible','off');
set(h.text_cb0, 'Visible','off');
set(h.cb0, 'Visible','off');
set(h.checkbox_write2xls, 'Visible','off','Value',0);
set(h.text_pufflatency, 'Visible','off');
set(h.edit_pufflatency, 'Visible','off');
set(h.checkbox_isihisttogether, 'Visible','off');
set(h.text_fanofactorbinsize, 'Visible','off');
set(h.edit_fanofactorbinsize, 'Visible','off');
set(h.checkbox_paironly, 'Visible','off');
set(h.checkbox_spikedensity,'Visible','off');
set(h.checkbox_samecolor4pairs,'Visible','off');
set(h.checkbox_plotonlymean,'Visible','off');
set(h.checkbox_ensembleaverage,'Visible','off');
set(h.edit_Rcorr_sigma, 'Visible','off');
set(h.text_Rcorr_sigma, 'Visible','off');
set(h.text_stasize,'Visible','off');
set(h.edit_stasize,'Visible','off');
set(h.text_manifold1, 'Visible','off');
set(h.text_manifold2, 'Visible','off');
set(h.text_manifold3, 'Visible','off');
set(h.text_manifold4, 'Visible','off');
set(h.text_manifold5, 'Visible','off');
set(h.edit_manifold_delta,'Visible','off');
set(h.edit_manifold_nISI,'Visible','off');
set(h.edit_manifold_ngrid,'Visible','off');
set(h.edit_manifold_fc,'Visible','off');
set(h.checkbox_manifold_verbose,'Visible','off');
set(h.checkbox_manifold_gridfit,'Visible','off');
set(h.edit_regularity_tolerance,'Visible','off');
set(h.edit_PNManifold_OSNPSTH,'Visible','off');


% --- Outputs from this function are returned to the command line.
function varargout = spikeplots_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if(isempty(handles))
    varargout{1}=[];
else
    if(~isempty(handles.plottype))
        writeconfigvar(handles.h0.configfname,'sp_plottype',strcat('''',handles.plottype,''''));
    end
    if(~isempty(handles.PNManifold_OSNPSTH))
        writeconfigvar(handles.h0.configfname,'sp_PNManifold_OSNPSTH',strcat('''',handles.PNManifold_OSNPSTH,''''));
    end
    
    
    if(~isempty(handles.nfig) && isnumeric(handles.nfig))
        writeconfigvar(handles.h0.configfname,'sp_nfig',num2str(handles.nfig));
    end
    if(~isempty(handles.altperiod) && isnumeric(handles.altperiod))
        writeconfigvar(handles.h0.configfname,'sp_altperiod',num2str(handles.altperiod));
    end
    
    if(~isempty(handles.pufflatency) && isnumeric(handles.pufflatency))
        writeconfigvar(handles.h0.configfname,'sp_pufflatency',num2str(handles.pufflatency));
    end
    if(~isempty(handles.fanofactorbinsize) && isnumeric(handles.fanofactorbinsize))
        writeconfigvar(handles.h0.configfname,'sp_fanofactorbinsize',num2str(handles.fanofactorbinsize));
    end
    if(~isempty(handles.stasize) && isnumeric(handles.stasize))
        writeconfigvar(handles.h0.configfname,'sp_stasize',num2str(handles.stasize));
    end
    if(~isempty(handles.nbins) && isnumeric(handles.nbins))
        writeconfigvar(handles.h0.configfname,'sp_nbins',num2str(handles.nbins));
    end
    if(~isempty(handles.bingap) && isnumeric(handles.bingap))
        writeconfigvar(handles.h0.configfname,'sp_bingap',num2str(handles.bingap));
    end
    if(~isempty(handles.winx) && isnumeric(handles.winx))
        writeconfigvar(handles.h0.configfname,'sp_winx',num2str(handles.winx));
    end
    if(~isempty(handles.timecap0) && isnumeric(handles.timecap0))
        writeconfigvar(handles.h0.configfname,'sp_timecap0',num2str(handles.timecap0));
    end
    if(~isempty(handles.timecapend) && isnumeric(handles.timecapend))
        writeconfigvar(handles.h0.configfname,'sp_timecapend',num2str(handles.timecapend));
    end
    if(~isempty(handles.manifold_nISI) && isnumeric(handles.manifold_nISI))
        writeconfigvar(handles.h0.configfname,'sp_manifold_nISI',num2str(handles.manifold_nISI));
    end
    if(~isempty(handles.manifold_ngrid) && isnumeric(handles.manifold_ngrid))
        writeconfigvar(handles.h0.configfname,'sp_manifold_ngrid',num2str(handles.manifold_ngrid));
    end
    if(~isempty(handles.manifold_fc) && isnumeric(handles.manifold_fc))
        writeconfigvar(handles.h0.configfname,'sp_manifold_fc',num2str(handles.manifold_fc));
    end
    if(~isempty(handles.manifold_delta) && isnumeric(handles.manifold_delta))
        writeconfigvar(handles.h0.configfname,'sp_manifold_delta',num2str(handles.manifold_delta));
    end
    if(~isempty(handles.manifold_regularity_tolerance) && isnumeric(handles.manifold_regularity_tolerance))
        writeconfigvar(handles.h0.configfname,'sp_manifold_regularity_tolerance',num2str(handles.manifold_regularity_tolerance));
    end
    
    writeconfigvar(handles.h0.configfname,'sp_samecolor4pairs',...
        num2str(get(handles.checkbox_samecolor4pairs,'Value')));
    writeconfigvar(handles.h0.configfname,'sp_ensembleaverage',...
        num2str(get(handles.checkbox_ensembleaverage,'Value')));
    writeconfigvar(handles.h0.configfname,'sp_spikedensity',...
        num2str(get(handles.checkbox_spikedensity,'Value')));
    writeconfigvar(handles.h0.configfname,'sp_plotonlymean',...
        num2str(get(handles.checkbox_plotonlymean,'Value')));
    writeconfigvar(handles.h0.configfname,'sp_paironly',...
        num2str(get(handles.checkbox_paironly,'Value')));
    temp=str2num(get(handles.edit_Rcorr_sigma,'String'));
    if(~isempty(temp))
        if(temp>0 && temp<100)
            writeconfigvar(handles.h0.configfname,'sp_Rcorr_sigma',num2str(temp));
        end
    end
    
    varargout{1} = handles.output;
    delete(handles.figure1);
end
% if(isfield(handles,'filepicks'))
%    varargout{1} = handles.filepicks;
%    varargout{2} = handles.plottype;
%    varargout{3} = handles.downsampleratio;
%    delete(handles.figure1);
% else
%    varargout{1} = [];
%    varargout{2} = [];
%    varargout{3} = [];
% %   delete(handles.figure1);
% end

% The figure can be deleted now




%from flyspikes.m
function val=readconfigvar(configfname, configvarname)
%read config variable from flyspikes_config.mat
val=[];
if(isempty(configvarname))
    return;
end

if(~exist(configfname,'file'))
    return;
end

if(~isempty(who('-file', configfname, configvarname)))
    load(configfname, configvarname);
    eval(['val=' configvarname ';']);
end




%from flyspikes.m
function done=writeconfigvar(configfname, configvarname, value)
%write config variable from 'configfname'
if(isempty(configvarname))
    return;
end

if(~exist(configfname,'file'))
    return;
end
eval([configvarname '=[' value '];']);
save(configfname, '-append', configvarname);







function handles=updatepage(handles,coption)
%coption : =='odor' --> list files with concentration data in it
if(nargin<2) coption='';end

nfiles=length(handles.finfo);
if(nfiles==0) return; end

%update 'handles.selected'
if(~isempty(handles.onfilek))
    for k=1:length(handles.onfilek)
        handles.selected(handles.onfilek(k))=get(handles.hcheckbox(k),'Value');
        delete(handles.hcheckbox(k));
        delete(handles.htext(k));
    end
end

columnsperpage=handles.columnsperpage;

figureposition=get(handles.figure1,'Position');

yloc = (handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.59+.17;

if(columnsperpage>1)
    for k=2:columnsperpage
        yloc = [yloc ((handles.filespercolumn-(1:handles.filespercolumn))./handles.filespercolumn.*.59+.17)];
    end
end

for k=1:(handles.filespercolumn*columnsperpage)
    textx(k)=floor((k-1)/handles.filespercolumn)/columnsperpage+.02;
end
checkboxx = textx+.24;

if(strcmp(coption,'odor'))
    if(isempty(handles.havingc))
        set(handles.text_msg,'no data file contains odor concentration profile');
        nfiles2bshown=min(30,length(handles.finfo)-(handles.nowfirstcolumn-1)*handles.filespercolumn);
        handles.onfilek=(1:nfiles2bshown)+(handles.nowfirstcolumn-1)*handles.filespercolumn;
    else
        nfiles2bshown=min(30,length(handles.havingc)-(handles.nowfirstcolumn-1)*handles.filespercolumn);
        if(nfiles2bshown>0)
            handles.onfilek=handles.havingc((1:nfiles2bshown)+(handles.nowfirstcolumn-1)*handles.filespercolumn);
        else
            handles.nowfirstcolumn=1;
            nfiles2bshown=min(30,handles.havingc-(handles.nowfirstcolumn-1)*handles.filespercolumn);
            handles.onfilek=handles.havingc((1:nfiles2bshown)+(handles.nowfirstcolumn-1)*handles.filespercolumn);
        end
    end
else%if no 'c' option, files are chosen sequentially
    nfiles2bshown=min(30,length(handles.finfo)-(handles.nowfirstcolumn-1)*handles.filespercolumn);
    handles.onfilek=(1:nfiles2bshown)+(handles.nowfirstcolumn-1)*handles.filespercolumn;
end

if(nfiles2bshown>0)
    for k=1:nfiles2bshown
        handles.htext(k)=uicontrol('Parent', handles.figure1,...
            'Style', 'text',...
            'String', handles.finfo(k+handles.filespercolumn*(handles.nowfirstcolumn-1)).fname,...
            'Units', 'normalized',...
            'Position', [textx(k) yloc(k) .22 .05]);
        %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
    end
    
    for k=1:nfiles2bshown
        handles.hcheckbox(k)=uicontrol('Parent', handles.figure1,...
            'Style', 'Checkbox',...
            'String', [],...
            'Units', 'normalized',...
            'Position', [checkboxx(k) yloc(k)+.01 .05 .05],...
            'Value', handles.selected(k+handles.filespercolumn*(handles.nowfirstcolumn-1)),...
            'Tag', sprintf('checkbox_%03d',k),...
            'ToolTipString',inf2str(handles.finfo(k+handles.filespercolumn*(handles.nowfirstcolumn-1))));
        %      'Tag', sprintf('text_fnames%03d',handles.filesperpage*handles.nowpage+k));
    end
    %    set(handles.checkbox_all, 'Value', 1);
    set(handles.text_msg,'String', sprintf('%d files listed', length(handles.finfo)));
end




% % --- Executes on button press in checkbox_all.
% function checkbox_all_Callback(hObject, eventdata, handles)
% % hObject    handle to checkbox_all (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
%
% % Hint: get(hObject,'Value') returns toggle state of checkbox_all
%
%



% --- Executes on button press in pushbutton_left.
function pushbutton_left_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_left (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
nowfirstcolumn=handles.nowfirstcolumn;
if(nowfirstcolumn >3)
    handles.nowfirstcolumn=nowfirstcolumn-3;
    handles=updatepage(handles);
    guidata(hObject, handles);
end

set(handles.pushbutton_selectall,'String','none');
%set(handles.pushbutton_switchset,'String','ch1');



% --- Executes on button press in pushbutton_right.
function pushbutton_right_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_right (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
nowfirstcolumn=handles.nowfirstcolumn;
if(nowfirstcolumn < (handles.numcolumns-2))
    handles.nowfirstcolumn=nowfirstcolumn+3;
    handles=updatepage(handles);
    guidata(hObject, handles);
end

set(handles.pushbutton_selectall,'String','none');
%set(handles.pushbutton_switchset,'String','ch1');






% function edit_downsampleratio_Callback(hObject, eventdata, handles)
% % hObject    handle to edit_downsampleratio (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
%
% % Hints: get(hObject,'String') returns contents of edit_downsampleratio as text
% %        str2double(get(hObject,'String')) returns contents of edit_downsampleratio as a double
%
%
% % --- Executes during object creation, after setting all properties.
% function edit_downsampleratio_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to edit_downsampleratio (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
%
% % Hint: edit controls usually have a white background on Windows.
% %       See ISPC and COMPUTER.
% if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%     set(hObject,'BackgroundColor','white');
% end




% --- Executes on button press in checkbox_column1.
function checkbox_column1_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column1
if(~isempty(handles.onfilek))
    if(get(hObject, 'Value'))
        %selected
        for k=1:min(10,length(handles.onfilek))
            if(handles.hcheckbox(k)~=0)
                set(handles.hcheckbox(k),'Value',1);
            end
        end
        
    else
        %deselected
        for k=1:min(10,length(handles.onfilek))
            if(handles.hcheckbox(k)~=0)
                set(handles.hcheckbox(k),'Value',0);
            end
        end
    end
end

% --- Executes on button press in checkbox_column2.
function checkbox_column2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column2
if(length(handles.onfilek)>10)
    if(get(hObject, 'Value'))
        %selected
        for k=11:min(20,length(handles.onfilek))
            if(handles.hcheckbox(k)~=0)
                set(handles.hcheckbox(k),'Value',1);
            end
        end
    else
        %deselected
        for k=11:min(20,length(handles.onfilek))
            if(handles.hcheckbox(k)~=0)
                set(handles.hcheckbox(k),'Value',0);
            end
        end
    end
end

% --- Executes on button press in checkbox_column3.
function checkbox_column3_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_column3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_column3
if(length(handles.onfilek)>20)
    if(get(hObject, 'Value'))
        %selected
        for k=21:length(handles.onfilek)
            if(handles.hcheckbox(k)~=0)
                set(handles.hcheckbox(k),'Value',1);
            end
        end
    else
        %deselected
        for k=21:length(handles.onfilek)
            if(handles.hcheckbox(k)~=0)
                set(handles.hcheckbox(k),'Value',0);
            end
        end
    end
end


% --- Executes on button press in pushbutton_ok.
function pushbutton_ok_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_ok (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles=updatepage(handles); %update 'handles.selected'

filek=[];
for k=1:length(handles.selected)
    if(handles.selected(k)==1)
        filek=[filek; k];
    end
end
if(isempty(filek))
    handles.output='pltting : no file picked';
    guidata(hObject, handles);
    uiresume(handles.figure1);
    return;
end


handles.filepicks=filek;
handles.nfig=round(str2num(get(handles.edit_nfig,'String')));
if(isempty(handles.nfig))
    handles.nfig=31;
end
if(handles.nfig<1)
    handles.nfig=31;
end



handles.timecap0=(str2num(get(handles.edit_timecap0,'String')));
if(isempty(handles.timecap0))
    handles.timecap0=30;
end
handles.timecapend=(str2num(get(handles.edit_timecapend,'String')));
if(isempty(handles.timecapend))
    handles.timecapend=30;
end

if(get(handles.radiobutton_barplot,'Value'))
    handles.plottype='barplot';
    handles=plotbar(handles);
elseif(get(handles.radiobutton_isihist,'Value'))
    handles.plottype='isihist';
    handles=plotisihist(handles);
elseif(get(handles.radiobutton_ipsth,'Value'))
    handles.plottype='ipsth';
    handles=plotipsth(handles);
    % elseif(get(handles.radiobutton_conhist,'Value'))
    %     handles.plottype='conhist';
    %     handles=conhist(handles);
    % elseif(get(handles.radiobutton_crossintensity,'Value'))
    %         handles.plottype='crossintensity';
    %     handles=crossintensity(handles);
elseif(get(handles.radiobutton_raster,'Value'))
    handles.plottype='raster';
    handles=plotraster(handles);
elseif(get(handles.radiobutton_rawplot,'Value'))
    handles.plottype='rawplot';
    handles=plotraw(handles);
elseif(get(handles.radiobutton_PSTH,'Value'))
    handles.plottype='PSTH';
    handles=plotPSTH(handles);
elseif(get(handles.radiobutton_odor,'Value'))
    handles.plottype='odor';
    handles=plotraw(handles,'odor');
elseif(get(handles.radiobutton_periodhist,'Value'))
    handles.plottype='periodhist';
    handles=plotperiodhist(handles);
elseif(get(handles.radiobutton_phasejitter,'Value'))
    handles.plottype='phase';
    handles=plotphase(handles);
elseif(get(handles.radiobutton_Rcorr,'Value'))
    handles.plottype='Rcorr';
    handles=plotRcorr(handles);
elseif(get(handles.radiobutton_ISIratio,'Value'))
    handles.plottype='ISIratio';
    handles=plotISIratio(handles);
elseif(get(handles.radiobutton_fanofactor,'Value'))
    handles.plottype='fanofactor';
    handles=plotfanofactor(handles);
elseif(get(handles.radiobutton_isij,'Value'))
    handles.plottype='isij';
    handles=plotisij(handles);
elseif(get(handles.radiobutton_combo1,'Value'))
    handles.plottype='combo1';
    handles=plotcombo1(handles);
elseif(get(handles.radiobutton_isij3,'Value'))
    handles.plottype='isij3';
    handles=plotisij3(handles);
elseif(get(handles.radiobutton_combo2,'Value'))
    handles.plottype='combo2';
    handles=plotcombo2(handles);
elseif(get(handles.radiobutton_combo3,'Value'))
    handles.plottype='combo3';
    handles=plotcombo3(handles);
elseif(get(handles.radiobutton_sta,'Value'))
    handles.plottype='sta';
    handles=plotsta(handles);
elseif(get(handles.radiobutton_stc,'Value'))
    handles.plottype='stc';
    handles=plotstc(handles);
elseif(get(handles.radiobutton_2DManifold,'Value'))
    handles.plottype='2DManifold';
    handles=plot2dmanifold(handles);
    handles.nfig=handles.nfig+2;
elseif(get(handles.radiobutton_PNManifold,'Value'))
    handles.plottype='PNManifold';
    handles=plotPNmanifold(handles);
    handles.nfig=handles.nfig+2;
end

guidata(hObject, handles);
uiresume(handles.figure1);




function h=plotcombo1(h)
%plot odor waveforms, raster, and PSTH
pickedk=h.filepicks;
ischannelb=zeros(size(pickedk));
for i=1:length(pickedk)
    if(h.finfo(pickedk(i)).fname(end)=='b')
        ischannelb(i)=1;
    end
end

pickedka=pickedk(~ischannelb);
pickedkb=pickedk(logical(ischannelb));

set(h.cb0,'Value',1);%together check box for odor plotting
if(~isempty(pickedka))
    h.filepicks=pickedka;
else
    h.filepicks=pickedkb;
end
set(h.checkbox_addaxes,'Value',0)
h=plotraw(h,'odor');
hfig=gcf;
haxes1=gca;
nowaxis1=axis(haxes1);
axis(haxes1, [h.timecap0 h.timecapend nowaxis1(3:4)]);
%     set(h.checkbox_addaxes,'Value',1)
%     hline=findobj(haxes1,'Type','Line');
%     odort{ii}=get(hline(end),'XData');
%     odory{ii}=get(hline(end),'YData');
%     
set(h.checkbox_addaxes,'Value',1)

if(~isempty(pickedka))
    h=plotraster(h);
end


if(~isempty(pickedkb))
    h.filepicks=pickedkb;
    h=plotraster(h);
end
haxes2=gca;


if(~isempty(pickedka))
    h.filepicks=pickedka;
    h=plotPSTH(h);
    haxes3=gca;
else
    haxes3=[];
end



if(~isempty(pickedkb))
    if(~isempty(haxes3))
        oldnfig=h.nfig;
        h.nfig=799;
    end
    h.filepicks=pickedkb;
    h=plotPSTH(h);
    haxes3=gca;hfig=gcf;
    if(0)
        hline=findobj(haxes2,'Type','Line','Color','b');
        axis2=axis(haxes2);
        hline2=copyobj(hline,haxes3);
        set(hline2,'Color','r');
        axis1=axis(haxes3);
        axis(haxes3, [axis1(1:2) min(axis1(3), axis2(3)), max(axis1(4),axis2(4))]);
        if(~isempty(haxes3))
            close(hfig);
            h.nfig=oldnfig;
            legend({'neuron A','neuron B'});
        end
    end
end


%retouch the lines and axes - odor axes
hlines=findobj(haxes1,'Type','Line');
for i=1:length(hlines)
    x=get(hlines(i),'XData');y=get(hlines(i),'YData');
    ratio=ceil(10/((x(2)-x(1))*1000));%downsample it to 1ms sampling interval
    set(hlines(i),'XData',x(1:ratio:end),'YData',y(1:ratio:end),'LineWidth',4,'Color','k');%,[1 .3 .3]);%color changed to red on 12/31/2011
end
pos=get(haxes1,'Position');
set(haxes1,'XTick',[],'XColor','w','Box','off','FontSize',20,'Position',[0.18 pos(2) 0.8 pos(4)]);axis(haxes1,'tight');axes(haxes1);ylabel('');
axis0=axis(haxes1);%axis(haxes1,[h.timecap0+.5 h.timecapend-.5 axis0(3:4)]);
axis(haxes1,[h.timecap0+.5 h.timecapend-.5 -.3 230]);
set(haxes1,'TickDir','out','YTick',[0 100 200]);
bOSN=true;


%retouch the lines and axes - raster axes
hlines=findobj(haxes2,'Type','Line');
for i=1:length(hlines)
    if(bOSN)
    set(hlines(i),'Color',[0 0 1],'LineWidth',.25); %for OSNs
    else
    set(hlines(i),'Color',[1 0 0],'LineWidth',.25); %for PNs
    end
end
pos=get(haxes2,'Position');
set(haxes2,'XTick',[],'Color','w','XColor','w','Box','off','YColor','w','Position',[0.18 .35 0.8 0.08],'FontSize',20);
axes(haxes2);ylabel('');axis(haxes2,'tight');
axis0=axis(haxes2);
axis(haxes2,[h.timecap0+.5 h.timecapend-.5 axis0(3) axis0(4)+1]);




%retouch the lines and axes - psth axes
hlines=findobj(haxes3,'Type','Line');
for i=1:length(hlines)
    if(bOSN)
        set(hlines(i),'Color',[.2 .3 .9],'LineWidth',2);%for OSNs
    else
        set(hlines(i),'Color',[.9 .1 .1],'LineWidth',2);%for PNs
    end
end
pos=get(haxes3,'Position');
set(haxes3,'XTick',[],'Color','w','XColor','w','Box','off','FontSize',20,'Position',[0.18 pos(2) 0.8 pos(4)]);axes(haxes3);ylabel('');axis(haxes3,'tight');
axis0=axis(haxes3);%axis(haxes3,[h.timecap0+.5 h.timecapend-.5 axis0(3:4)]);
if(bOSN)
    axis(haxes3,[h.timecap0+.5 h.timecapend-.5 -.3 141]);
    set(haxes3,'TickDir','out','YTick',[0 50 100]);
else
    axis(haxes3,[h.timecap0+.5 h.timecapend-.5 -.3 260]);
    set(haxes3,'TickDir','out','YTick',[0 100 200]);
end
% %shift the raster plot close to the psth
% pos2=get(haxes2,'Position');
% set(haxes2,'Position',[pos2(1) pos(2)+pos(4) pos2(3:4)]);

%save the current figure
figsize=[350 900];
scrsize=get(0,'ScreenSize');
set(hfig,'OuterPosition',[1320 200 figsize])
pos=get(hfig,'PaperPosition');
set(hfig, 'PaperSize', [3.5 9],'PaperPositionMode', 'manual', ...
    'PaperUnits', 'inches','PaperPosition',[pos(1:2) 3.5 9]);

fname=[h.h0.docfolder h.finfo(pickedk(1)).fname h.finfo(pickedk(end)).fname((end-4):end)  '_combo1'];
print(hfig,'-depsc2',fname);
saveas(hfig,fname,'fig');










function h=plotcombo3(h)

pickedk0=h.filepicks;

if(length(h.altperiod)>1)
    nrepeat5=h.altperiod(2);
else
    nrepeat5=1;
end

haxes2=[];
odort={};
odory={};
pstht={};
psthy={};
psthtb={};
psthyb={};
filenames={};
for ii=1:h.altperiod(1)
    
    pickedk=pickedk0(mod(floor((pickedk0-1)/nrepeat5-ii+1),h.altperiod(1))==0);
     
    ischannelb=zeros(size(pickedk));
    
    %     for i=1:length(pickedk)
    %         if(h.finfo(pickedk(i)).fname(end)=='b')
    %             ischannelb(i)=1;
    %         end
    %     end
    
    pickedka=pickedk(~ischannelb);
    pickedkb=pickedk(logical(ischannelb));
    
    set(h.cb0,'Value',1);%together check box for odor plotting
    if(~isempty(pickedka))
        h.filepicks=pickedka;
    else
        h.filepicks=pickedkb;
    end
    
    if(ii>=2)
        h.nfig=h.nfig+1;
        set(h.edit_nfig,'string',h.nfig);drawnow;
    end
    
    set(h.checkbox_addaxes,'Value',0)
    h=plotraw(h,'odor');
    haxes1=gca;
    nowaxis1=axis(haxes1);
    axis(haxes1, [h.timecap0 h.timecapend nowaxis1(3:4)]);
    set(h.checkbox_addaxes,'Value',1)
    hline=findobj(haxes1,'Type','Line');
    odort{ii}=get(hline(end),'XData');
    odory{ii}=get(hline(end),'YData');
    
    
    %filtering
    dt=odort{ii}(2)-odort{ii}(1);
    fc=32;%cutoff frequency
    oversampleR=round((1000/(dt)/2)/fc);
    
    if(~isempty(pickedka))
        h.filepicks=pickedka;
        [h binx dx pstht{ii} psthy{ii}]=plotPSTH(h);
        %h=plotipsth(h);
        hpsthaxes=gca;
        hline1=findobj(hpsthaxes,'Type','Line','Color','b');
        set(hline1,'Color','r');
    else
        hpsthaxes=[];
    end
    
    
    if(~isempty(pickedkb))
        if(~isempty(hpsthaxes))
            oldnfig=h.nfig;
            h.nfig=h.nfig+1;
        end
        h.filepicks=pickedkb;
        [h binx dx psthtb{ii} psthyb{ii}]=plotPSTH(h);
        %h=plotipsth(h);
        haxes2=gca;hfig=gcf;
        hline=findobj(haxes2,'Type','Line','Color','b');
        axis2=axis(haxes2);
        hline2=copyobj(hline,hpsthaxes);
        set(hline2,'Color','b');
        %         axis1=axis(hpsthaxes);
        %         axis(hpsthaxes, [axis1(1:2) min(axis1(3), axis2(3)), max(axis1(4),axis2(4))]);
        if(~isempty(hpsthaxes))
            close(hfig);
            h.nfig=oldnfig;
            legend(hpsthaxes,{'neuron A','neuron B'});
        end
    end
    
    if(exist(['./doc/000type' num2str(ii-1) 'combo1.fig']))
        open(['./doc/000type' num2str(ii-1) 'combo1.fig']);
        
        %     if(exist(['./doc/2009_02_14_000' num2str(ii-1) 'type' num2str(ii) 'combo3.fig']))
        %         open(['./doc/2009_02_14_000' num2str(ii-1) 'type' num2str(ii) 'combo3.fig']);
        htempfig=gcf;
        haxes=findobj(gcf,'Type','Axes');
        hline=findobj(haxes(1),'Type','Line');
        axis3=axis(haxes(1));
        axis1=axis(hpsthaxes);
        hline3=copyobj(hline,hpsthaxes);
        pny{ii}=get(hline3,'YData');
        pnx{ii}=get(hline3,'XData');
        set(hline3,'Color','r');
        axis(hpsthaxes, [axis1(1:2) 0 max(axis1(4),axis3(4))]);
        close(htempfig);
        %         set(haxes1,'Position',[.1 .7 .85 .25]);
        %         set(haxes2,'Position',[.1 .47 .85 .23]);
        %         set(hpsthaxes,'Position',[.1 .1 .85 .37]);
        set(haxes1,'Position',[.12 .6 .82 .35]);
        set(hpsthaxes,'Position',[.12 .1 .82 .5]);
        %legend(hpsthaxes,{'OR59b OSN','DM4 PN'});
        %legend(hpsthaxes,{'OR42b OSN','DM1 PN'});
    elseif(ishandle(haxes2))
        set(haxes1,'Position',[.12 .7 .83 .25]);
        set(haxes2,'Position',[.12 .47 .83 .23]);
        set(hpsthaxes,'Position',[.12 .1 .83 .37]);
    else
        set(haxes1,'Position',[.1 .6 .85 .35]);
        set(hpsthaxes,'Position',[.1 .1 .85 .5]);
        %legend(hpsthaxes,{'OR59b OSNa','OR59b OSNb'});
    end
    
    tempk=findstr(h.finfo(pickedk(end)).fname,'_');
    if(isempty(tempk))
        lastfnum=[];
    else
        lastfnum=h.finfo(pickedk(end)).fname(tempk(end):end);
    end
    %     savefig([h.finfo(pickedk(1)).fname lastfnum 'type' num2str(ii) 'combo3_' num2str(binx) '_' num2str(dx)])
    
    
    for i=1:length(pickedk)
        filenames{ii}{i}=h.finfo(pickedk(i)).fname;
    end
end

save([h.h0.docfolder h.finfo(pickedk0(1)).fname lastfnum  '_odor_psth_' num2str(binx) '_' num2str(dx)], 'odort','odory','pstht','psthy','filenames');

h.nfig=h.nfig+1;
[hfig haxes1]=getnewaxes(h); hold all; title(['Odor waveforms (' h.finfo(pickedk0(1)).fname lastfnum  '_odor_psth_' num2str(binx) '_' num2str(dx) ')'],'Interpreter','none');
ylabel('Concentration');xlabel('Time (s)');
[hfig haxes2]=getnewaxes(h,'add'); hold all; title(['PSTH (' num2str(binx) 'ms bin size and ' num2str(dx) ' ms sampling interval)' ]);ylabel('Spike Frequency (Hz)');xlabel('Time (s)');
set(haxes1,'FontSize',15);    set(haxes2,'FontSize',15);
cm=colormap(hsv(length(pstht)));
for i=1:length(pstht)
    plot(haxes1, odort{i},odory{i},'Color',cm(i,:),'LineWidth',1.5);
    plot(haxes2, pstht{i}/1000,psthy{i},'Color',cm(i,:),'LineWidth',3);
end
grid(haxes1,'off');grid(haxes2,'off');
%retouch odor axes
set(haxes1,'XTick',[],'XColor','w','FontSize',20);
hlines=findobj(haxes1,'Type','line');
for i=1:length(hlines)
    x=get(hlines(i),'XData');y=get(hlines(i),'YData');
    ratio=ceil(10/((x(2)-x(1))*1000));%downsample it to 10ms sampling interval
    set(hlines(i),'XData',x(1:ratio:end),'YData',y(1:ratio:end),'LineWidth',4);
end


set(haxes2,'XTick',[],'XColor','w','FontSize',20);
axis(haxes1,'tight');axis0=axis(haxes1);axis(haxes1,[h.timecap0+.5 h.timecapend-.5 axis0(3:4)]);
axis(haxes2,'tight');axis0=axis(haxes2);axis(haxes2,[h.timecap0+.5 h.timecapend-.5 axis0(3:4)]);
 
savefig3(hfig,[h.h0.docfolder h.finfo(pickedk0(1)).fname lastfnum '_all' num2str(ii) 'combo3_' num2str(binx) '_' num2str(dx)],[450 800])
%
% assignin('base','odort',odort);
% assignin('base','odory',odory);
%
% if(exist('odor32Hzx','var'))
%     assignin('base','odor32Hzt',odor32Hzx);
%     assignin('base','odor32Hzy',odor32Hzy);
% end
%
% if(exist('pnx','var'))
%     assignin('base','pnt',pnx);
%     assignin('base','pny',pny);
% end
%
% if(~isempty(pstht))
%     assignin('base','pstht',pstht);
%     assignin('base','psthy',psthy);
% end
%
% if(~isempty(psthtb))
%     assignin('base','psthtb',psthtb);
%     assignin('base','psthyb',psthyb);
% end






function h=plotperiodhist(h)
pickedk=h.filepicks;
if(isempty(pickedk))
    h.output='spikeplots: no file selected';
    return;
end

axesinfo=h.finfo;

validk9=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk9=[validk9 pickedk(k)];
    end
end
if(isempty(validk9))
    h.output='spikeplots: no files with spike information';
    return;
end

validk=[];
stimdur=sum(axesinfo(validk9(1)).stimdur);
npulses=axesinfo(validk9(1)).npulses;
%stimpause=axesinfo(validk9(1)).stimpause;
for k=1:length(validk9)
    if(~isempty(axesinfo(validk9(k)).stimdur) && ~isempty(axesinfo(validk9(k)).stimstart))% &&...
        %~isempty(axesinfo(validk9(k)).stimpause))
        if(sum(axesinfo(validk9(k)).stimdur)==stimdur && ...%axesinfo(validk9(k)).stimpause==stimpause  && ...
                axesinfo(validk9(k)).npulses==npulses)
            validk=[validk validk9(k)];
        end
    end
end


ndata=length(validk);
[hfig haxes2]=getnewaxes(h); hold all; title('concentration for each period'); ylabel('concentration (ppm)');
[hfig haxes1]=getnewaxes(h,'add'); hold all; title('raster for each period');
[hfig haxes3]=getnewaxes(h,'add'); hold all; xlabel('Time (ms)');

ylabel('number of occurrence');


%get puff latency information
pufflatency=str2num(get(h.edit_pufflatency,'String'));
if(isempty(pufflatency))
    pufflatency=h.pufflatency;
else
    h.pufflatency=pufflatency;
end

stimperiod=stimdur;%+stimpause;
%stimperiod=200;npulses=20;
allspkk=[]; k=1;
if(length(validk)<=3)
    cm=colormap(lines(length(validk)));
else
    cm=colormap(hsv(length(validk)));
end


npulses=npulses-round(h.pufflatency./stimperiod);

for i=1:length(validk)
    spkk9=axesinfo(validk(i)).spkk-(axesinfo(validk(i)).stimstart+ h.pufflatency)/axesinfo(validk(i)).dt;
    for j=1:npulses
        spkk{i,j}=spkk9(spkk9>=0 & spkk9<stimperiod/axesinfo(validk(i)).dt);
        spkk9=spkk9-stimperiod/axesinfo(validk(i)).dt;
        if(~isempty(spkk{i,j}))
            plot(haxes1, spkk{i,j}*axesinfo(validk(i)).dt, k, 'd','MarkerEdgeColor',cm(i,:),'MarkerFaceColor',cm(i,:),'MarkerSize',5);
        end
        rasteryticklabel{k}=sprintf('%s:%03d',axesinfo(validk(i)).fname((end-3):end),j);
        k=k+1;
        if(isempty(axesinfo(validk(i)).c))
            c{i,j}=[];
        else
            c{i,j}=axesinfo(validk(i)).c(round(((0:axesinfo(validk(i)).dt:stimperiod)+...
                axesinfo(validk(i)).stimstart+ h.pufflatency+stimperiod*(j-1))/axesinfo(validk(i)).dt)+1);
            if(isfield(axesinfo(validk(i)),'ppmfactor'))
                c{i,j}=c{i,j}*axesinfo(validk(i)).ppmfactor;
            end
            plot(haxes2, ((1:length(c{i,j}))-1)*axesinfo(validk(i)).dt, c{i,j},'Color',cm(i,:));
            
        end
        allspkk=[allspkk spkk{i,j}];
    end
end
axes(haxes1); axis tight;
axes(haxes3); hist(allspkk*axesinfo(validk(i)).dt,20);
%title(sprintf('period histogram stimdur=%d, stimpause=%d, #spks=%d',stimdur, stimpause, length(allspkk)));
title(sprintf('period histogram stimdur=%d,  #spks=%d',stimdur,  length(allspkk)));
interval=round(k/5);
set(haxes1,'YTick',1:interval:(k-1),'YTickLabel',rasteryticklabel(1:interval:end));


h.output='spikeplots: period histogram plotted';















% --- Executes on button press in pushbutton_viewinf.
function pushbutton_viewinf_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_viewinf (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
viewinf;






function handles=plotbar(handles)

pickedk=handles.filepicks;
%if(isempty(validk)) return; end

axesinfo=handles.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end
if(isempty(validk))
    handles.output='no spikes found';
    return;
end
validk=fliplr(validk); %to plot data from top to bottom

%figure(11);
[hfig haxes]=getnewaxes(handles);
hold on;
minx=axesinfo(validk(1)).spkk(end)*axesinfo(validk(1)).dt;
maxx=axesinfo(validk(1)).spkk(1)*axesinfo(validk(1)).dt;

for k=1:length(validk)
    if(axesinfo(validk(k)).valve_open0>0)
        %adjust valve opening error
        spks=axesinfo(validk(k)).dt.*axesinfo(validk(k)).spkk+(axesinfo(validk(k)).stimstart-axesinfo(validk(k)).dt.*axesinfo(validk(k)).valve_open0);
    else
        spks=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
    end
    
    if(size(spks,1)>1 & size(spks,2)>1)
        %set(handles.text_msg,'String', 'spkk is a matrix. first column is taken only');
        spks=spks(:,1);
    end;
    
    if(axesinfo(validk(k)).stimdur>0)
        rectx=axesinfo(validk(k)).stimstart+[0 axesinfo(validk(k)).stimdur axesinfo(validk(k)).stimdur 0];
        recty=[-.2 -.2  .2 .2]+k;
        %axes(haxes);
        hrect=patch(rectx,recty, [1 0.55 0.55], 'EdgeColor','none');%light green: [.596 .996 .655]);
        
        
        npulses=1;
        if(isfield(axesinfo(validk(k)),'stimpause') && isfield(axesinfo(validk(k)),'npulses'));
            if(~isempty(axesinfo(validk(k)).stimpause) && ~isempty(axesinfo(validk(k)).npulses));
                if(axesinfo(validk(k)).npulses>1 && axesinfo(validk(k)).stimpause>0)
                    npulses=axesinfo(validk(k)).npulses;
                    stimpause=axesinfo(validk(k)).stimpause;
                end
            end
        end
        
        if(npulses>1)
            for j9=2:npulses
                rectx=rectx+stimpause+axesinfo(validk(k)).stimdur;
                hold on;
                %axes(haxes);
                hrect=patch(rectx,recty, [1 0.55 0.55],'EdgeColor','none');%light green: [.596 .996 .655]);
            end
        end
        
        
        
    end
    
    hold on;
    %axes(haxes);
    for i=1:length(spks)
        line([spks(i) spks(i)], [k-.2   k+.2]);
    end;
    
    
    maxx = max(maxx, max(spks));
    minx = min(minx, min(spks));
    
    yticklabel{k}=axesinfo(validk(k)).fname((end-3):end);
end;
hold off;


if(~isempty(axesinfo(validk(k)).stimstart))
    minx=min(minx-.01*(maxx-minx), axesinfo(validk(k)).stimstart-.01*(maxx-minx));
end
maxx=maxx+.01*(maxx-minx);
nowaxis=axis;
axis([minx maxx 0.5 length(validk)+.5]);


axes(haxes);
for k=1:length(validk)
    if(length(axesinfo(validk(k)).fname)~=0)
        line([0 maxx], [k   k]','Color', 'k');
        if(length(validk)<17)
            htext0=text(axesinfo(validk(k)).stimstart, k+.35, ...
                sprintf('%s %1.1f%%',axesinfo(validk(k)).fname,axesinfo(validk(k)).pp),...
                'Interpreter', 'none');
            set(htext0,'Units','normalized');
            
            axes(haxes);
            if(~isempty(axesinfo(validk(k)).stimstart)|~isempty(axesinfo(validk(k)).stimdur))
                if(axesinfo(validk(k)).stimdur<1000 | isempty(axesinfo(validk(k)).spkk))
                    if(strcmp(lower(axesinfo(validk(k)).celltype), 'ab1'))
                        htext1=text(axesinfo(validk(k)).stimstart+axesinfo(validk(k)).stimdur+4000, k+.35, ...
                            sprintf('#spks:%3d/30sec',length(axesinfo(validk(k)).spkk)));
                        
                    else
                        htext1=text(maxx-.2*(maxx-minx), k+.35, ...
                            sprintf('#spks:%3d',length(axesinfo(validk(k)).spkk)));
                    end
                else
                    spkk5=axesinfo(validk(k)).spkk;
                    
                    %counting #spikes from 'stimstart+.5' sec to
                    %'stimstart+1'sec
                    spkkin=spkk5(spkk5>(axesinfo(validk(k)).stimstart)/axesinfo(validk(k)).dt);
                    spkkin=spkkin(spkkin<(axesinfo(validk(k)).stimstart+1000)/axesinfo(validk(k)).dt);
                    if(strcmp(lower(axesinfo(validk(k)).celltype), 'ab1'))
                        htext1=text(axesinfo(validk(k)).stimstart+axesinfo(validk(k)).stimdur+1000, k+.35, ...
                            sprintf('#spks:%3din[%1.1f, %1.1f]sec/%3dtotal', ...
                            length(spkkin), (axesinfo(validk(k)).stimstart)/1100,...
                            (axesinfo(validk(k)).stimstart+1000)/1000,length(spkk5)));
                        
                    else
                        htext1=text(maxx-.3*(maxx-minx), k+.35, ...
                            sprintf('#spks:%3din[%1.1f, %1.1f]sec/%3dtotal', ...
                            length(spkkin), (axesinfo(validk(k)).stimstart)/1000,...
                            (axesinfo(validk(k)).stimstart+1000)/1000,length(spkk5)));
                    end
                end
                set(htext1, 'Interpreter', 'none','BackgroundColor',[.7 .9 .7],'Units','normalized');
            end
            
        end
    end
end;


xlabel('Time (ms)');
htitle=title(sprintf('%s ... %s',axesinfo(validk(1)).fname,axesinfo(validk(end)).fname));
set(gca,'TickDir','out','YTick',1:length(validk));
%set(gca,'TickDir','out','YTickLabel',length(validk):-1:1);
set(gca,'TickDir','out','YTickLabel',yticklabel);

set(htitle,'Interpreter','none');
handles.output='barplot is plotted';








function handles=plotisihist(handles)
validk=handles.filepicks;
nplots=length(validk);
%if(isempty(validk)) return; end

nbins=str2num(get(handles.edit_nbins,'String'));
if(~isempty(nbins))
    handles.nbins=nbins;
else
    nbins=handles.nbins;
    set(handles.edit_nbins,'String',num2str(nbins));
end

% if(isempty(nbins))
%     handles.output='crossintesity: bin number is invalid';
%     return;
% end

axesinfo=handles.finfo;

if(get(handles.checkbox_isihisttogether,'Value'))
    %plot them together
    restisiall=[];
    stimisiall=[];
    for k=1:nplots
        spkt=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
        stimdur=sum(axesinfo(validk(k)).npulses*(axesinfo(validk(k)).stimdur));
        
        if(stimdur>0)
            firstk=find(spkt>axesinfo(validk(k)).stimstart,1,'first');
            lastk=find(spkt>axesinfo(validk(k)).stimstart+stimdur,1,'first');
            
            restisiall=[restisiall diff(spkt(1:firstk))];
            stimisiall=[stimisiall diff(spkt(firstk:lastk))];
            restisiall=[restisiall diff(spkt(lastk:end))];
        else
            restisiall=[restisiall diff(spkt)];
        end
    end
    
    [hfig haxes]=getnewaxes(handles);
    if(isempty(stimisiall))
        hist(restisiall, nbins);
    else
        [n xout]=hist([restisiall stimisiall], nbins);
        
        resty=hist(restisiall, xout);
        
        stimy=hist(stimisiall, xout);
        
        %        bar(xout, [resty;stimy]','group');
        bar(xout, resty);
        hpatch= findobj(haxes,'Type','patch');
        for i=1:length(hpatch)
            color=get(hpatch(i),'FaceColor');
            set(hpatch(i),'EdgeColor',color);
        end
        legend('pre-stimulus');
        
        [hfig haxes]=getnewaxes(handles,'add');
        bar(xout, stimy);
        hpatch= findobj(haxes,'Type','patch');
        for i=1:length(hpatch)
            color=get(hpatch(i),'FaceColor');
            set(hpatch(i),'EdgeColor',color);
        end
        legend('post-stimulus');
        
        
    end
    
    
else
    %plot all separately
    minx=100000;maxx=0;
    for k=1:nplots
        [hfig haxes]=getnewaxes(handles);
        spkt=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
        if(axesinfo(validk(k)).stimdur>500 &...
                axesinfo(validk(k)).stimstart>spkt(1) &...
                axesinfo(validk(k)).stimstart+axesinfo(validk(k)).stimdur<spkt(end))
            
            firstk=find(spkt>axesinfo(validk(k)).stimstart+500,1,'first');
            lastk=find(spkt<axesinfo(validk(k)).stimstart+...
                axesinfo(validk(k)).stimdur,1,'last');
            [posty postx]=hist(diff(spkt(firstk:lastk)),nbins); %post stimulus
            if(max(posty)>0);
                posty=posty./max(posty);
            end
            
            dx=postx(2)-postx(1);
            
            lastrestk=find(spkt<axesinfo(validk(k)).stimstart,1,'last');
            restISI=diff(spkt(1:lastrestk));
            minrest=min(restISI); maxrest=max(restISI);
            
            if(minrest<postx(1))
                leftside= ceil((minrest-postx(1))/dx):-1:1;
                prex=[(postx(1)-leftside*dx) postx];
            else
                prex=postx;
            end
            
            if(maxrest>postx(end))
                rightside= 1:ceil((maxrest-postx(end))/dx);
                prex=[prex (postx(end)+rightside*dx)];
            end
            
            
            [prey prex]=hist(restISI,prex);
            if(max(prey)>0);
                prey=prey./max(prey);
            end
            
            if(prex(1)<postx(1))
                j=find(prex<postx(1),1,'last');
                postx=[prex(1:j) postx];
                posty=[zeros(1,j) posty];
            elseif(prex(1)>postx(1))
                j=find(postx<prex(1),1,'last');
                prex=[postx(1:j) prex];
                prey=[zeros(1,j) prey];
            end
            
            if(prex(end)>postx(end))
                j=find(prex>postx(end),1,'first');
                postx=[postx (((j:length(prex))-j+1)*dx+postx(end))];
                posty=[posty zeros(1,length(prex)-j+1)];
            elseif(prex(end)<postx(end))
                j=find(postx>prex(end),1,'first');
                prex=[prex (((j:length(postx))-j+1)*dx+prex(end))];
                prey=[prey zeros(1,length(postx)-j+1)];
            end
            
            
            
            bar(prex, [prey;posty]','group');
            hpatch= findobj(haxes,'Type','patch');
            for k=1:length(hpatch)
                color=get(hpatch(k),'FaceColor');
                set(hpatch(k),'EdgeColor',color);
            end
            colormap(hsv);
            minx=min(minx,prex(1));
            minx=min(minx,postx(1));
            maxx=max(maxx,prex(end));
            maxx=max(maxx,postx(end));
            prex=[];prey=[];postx=[];posty=[];
            legend('pre-stimulus', 'post-stimulus');
        else(axesinfo(validk(k)).stimdur==0)
            spkt=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
            [y x]=hist(diff(spkt),nbins);
            bar(x, y./max(y));
            minx=min(minx,min(x));
            maxx=max(maxx,max(x));
            dx=x(2)-x(1);
            
        end
        
    end
    
    
    for k=1:nplots
        subplot(nplots,1,k);
        axis([(minx-dx) (maxx+dx) 0 1]);
        title(axesinfo(validk(k)).fname,'Interpreter','none');
    end
end

handles.output='interspike interval histograms plotted';










function handles=conhist(handles)
%histogram of concurrence coefficients
validk=handles.filepicks;


if(validk<2)
    handles.output='conhist: at least two spike trains required';
end



nbins=str2num(get(handles.edit_nbins,'String'));
if(~isempty(nbins))
    handles.nbins=nbins;
else
    nbins=handles.nbins;
    set(handles.edit_nbins,'String',num2str(nbins));
end

% if(isempty(nbins))
%     handles.output='crossintesity: bin number is invalid';
%     return;
% end

%if(isempty(validk)) return; end

axesinfo=handles.finfo;
conA=[];conB=[];

hfig=figure(11);set(hfig,'Name','Histogram of Concurrence Coefficients','Color',[1 1 1]);
minx=100000;maxx=0;

nplots=length(validk)*(length(validk)-1)/2;
nowplot=1;
for k=1:(length(validk)-1)
    for l=(k+1):length(validk)
        %if(l==k) continue; end
        spktA=handles.finfo(validk(k)).spkk*axesinfo(validk(k)).dt;
        spktB=handles.finfo(validk(l)).spkk*axesinfo(validk(l)).dt;
        
        for j=1:length(spktA)
            if(spktA(j)<=spktB(1) | spktA(j)>=spktB(end)) %if out of spktB range
                continue;
            end
            
            [c1, i1]=min(abs(spktB-spktA(j)));
            spktB(i1)=-1000; %put a awkward value
            [c2, i2]=min(abs(spktB-spktA(j)));
            
            conA=[conA (2*max(c1,c2)/(c1+c2))];
        end
        
        for j=1:length(spktB)
            if(spktB(j)<=spktA(1) | spktB(j)>=spktA(end)) %if out of spktB range
                continue;
            end
            
            [c1, i1]=min(abs(spktA-spktB(j)));
            spktA(i1)=-1000; %put a awkward value
            [c2, i2]=min(abs(spktA-spktB(j)));
            
            conB=[conB (2*max(c1,c2)/(c1+c2))];
        end
        
        conA=conA-1;conB=conB-1;
        
        %getting histogram
        [Ay Ax]=hist(conA,nbins);
        dx=Ax(2)-Ax(1);
        if(min(conB)<Ax(1)-dx/2)
            leftside=Ax(1)-(ceil((Ax(1)-dx/2-min(conB))):-1:1)*dx;
            Ax=[leftside Ax];
            Ay=[zeros(size(leftside)) Ay];
        end
        
        if(max(conB)>Ax(end)+dx/2)
            rightside=Ax(end)+(1:ceil(max(conB)-Ax(end)-dx/2))*dx;
            Ax=[Ax rightside];
            Ay=[Ay zeros(size(rightside))];
        end
        
        
        By=hist(conB, Ax);
        minx=min(minx,Ax(1));
        maxx=max(maxx,Ax(end));
        
        %plotting
        subplot(nplots, 1, nowplot); nowplot=nowplot+1;
        bar(Ax, [Ay; By]');
        title(strcat(axesinfo(validk(k)).fname, '(A) vs  ',...
            axesinfo(validk(l)).fname, '(B)'),'Interpreter','none');
        
        if(nowplot-1==nplots) % for the bottom subplot
            legend('hist(\sigma_A(k))','hist(\sigma_B(k))','Orientation','horizontal');
        end
        
        conA=[];
        conB=[];
    end
end


for k=1:nplots
    subplot(nplots,1,k);
    nowaxis=axis;
    axis([(minx-dx) (maxx+dx) nowaxis(3:4)]);
end
handles.output='Histogram of Concurrence coefficients plotted';












function handles=crossintensity(handles)
%plot cross intesity function
validk=handles.filepicks;

if(length(validk)<2)
    handles.output='crossintesity: at least two spike trains required';
    return;
end

if(mod(length(validk),2)==1)
    validk=validk(1:(end-1));
    handles.output='crossintesity: the last data dropped';
end

wsize=get(handles.edit_winx,'String');
wsize=str2num(wsize);
if(isempty(wsize))
    handles.output='crossintesity: window size is invalid';
    return;
end


nbins=str2num(get(handles.edit_nbins,'String'));
if(~isempty(nbins))
    handles.nbins=nbins;
else
    nbins=handles.nbins;
    set(handles.edit_nbins,'String',num2str(nbins));
end
% if(isempty(nbins))
%     handles.output='crossintesity: bin number is invalid';
%     return;
% end


if(get(handles.checkbox_yintime,'Value')) %if checked
    yintime=1;
else
    yintime=0;
end

axesinfo=handles.finfo;


allx=[];
for l=1:(length(validk)/2)
    
    Ak=validk(2*(l-1)+1);
    Bk=validk(2*l);
    if(size(handles.finfo(Ak).spkk,1)>1)
        spktA=handles.finfo(Ak).spkk'*axesinfo(Ak).dt;
        spktB=handles.finfo(Bk).spkk'*axesinfo(Bk).dt;
    else
        spktA=handles.finfo(Ak).spkk*axesinfo(Ak).dt;
        spktB=handles.finfo(Bk).spkk*axesinfo(Bk).dt;
    end
    
    
    %distribution of spktB for every spike of spktA
    rasterx=[];rastery=[];
    for k=1:length(spktA)
        if(spktB(1)>spktA(k)-wsize/2 | spktB(end)<spktA(k)+wsize/2)
            continue;
        end
        piecek=find(spktB>=spktA(k)-wsize/2 & spktB<spktA(k)+wsize/2);
        rasterx=[rasterx (spktB(piecek)-spktA(k))];
        if(yintime)
            rastery=[rastery ones(size(piecek))*spktA(k)];
        else
            rastery=[rastery ones(size(piecek))*k];
        end
    end
    
    hfig=figure(11+l); set(hfig, 'Name', 'CrossIntensity Function','Color',[1 1 1]);
    subplot(221);
    plot(rasterx,rastery,'.');
    title(strcat(axesinfo(Bk).fname(1:(end-4)), ' spikes following ', axesinfo(Ak).fname(1:(end-4)), '`s'),...
        'Interpreter','none');
    if(yintime)
        ylabel(strcat('spk time of ',axesinfo(Ak).fname(1:(end-4))),'Interpreter','none');
    else
        ylabel(strcat('index of spike ',axesinfo(Ak).fname(1:(end-4))),'Interpreter','none');
    end
    nowaxis=axis;
    
    subplot(223);
    hist(rasterx, nbins);
    xlabel('time (ms)');
    nowaxis2=axis;
    axis([nowaxis(1:2) nowaxis2(3:4)]);
    
    allx=[allx rasterx];
    
    %distribution of spktA for every spike of spktB
    rasterx=[];rastery=[];
    for k=1:length(spktB)
        if(spktA(1)>spktB(k)-wsize/2 | spktA(end)<spktB(k)+wsize/2)
            continue;
        end
        piecek=find(spktA>=spktB(k)-wsize/2 & spktA<spktB(k)+wsize/2);
        rasterx=[rasterx (spktA(piecek)-spktB(k))];
        if(yintime)
            rastery=[rastery ones(size(piecek))*spktB(k)];
        else
            rastery=[rastery ones(size(piecek))*k];
        end
    end
    
    subplot(222);
    plot(rasterx,rastery,'.');
    title(strcat(axesinfo(Bk).fname(1:(end-4)), ' spikes following ', axesinfo(Bk).fname(1:(end-4)), '`s'),...
        'Interpreter','none');
    if(yintime)
        ylabel(strcat('spk time of ',axesinfo(Bk).fname),'Interpreter','none');
    else
        ylabel(strcat('index of spike ',axesinfo(Bk).fname),'Interpreter','none');
    end
    nowaxis=axis;
    
    subplot(224);
    hist(rasterx, nbins);
    xlabel('time (ms)');
    nowaxis2=axis;
    axis([nowaxis(1:2) nowaxis2(3:4)]);
    allx=[allx rasterx];
end

hfig121=figure(12+l);set(hfig121,'Color',[1 1 1]);
hist(allx, nbins);
xlabel('time (ms)');
title(sprintf('histogram built from %d spike trains',length(validk)));

if(isempty(handles.output))
    handles.output='Cross-intensity function is plotted';
end






function h=plotfanofactor(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

if(naxes==0) return; end;

if(naxes>2)
    colormap(hsv(naxes*(naxes-1)));
else
    colormap(lines(naxes*(naxes-1)));
end
cm=colormap;

%update the fano factor bin size
fanofactorbinsize=str2num(get(h.edit_fanofactorbinsize,'String'));
if(isempty(fanofactorbinsize))
    fanofactorbinsize=h.fanofactorbinsize;
else
    h.fanofactorbinsize=fanofactorbinsize;
end

y=cell(naxes,1);
minlen=inf;
for i=1:naxes
    spkt=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
    endt=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
    x=fanofactorbinsize:fanofactorbinsize:endt;
    for j=1:length(x)
        y{i}(j)=sum(spkt<x(j));
    end
    y{i}=diff([0 y{i}]);
    minlen=min(minlen,length(y{i}));
end

for i=1:naxes
    y{i}=y{i}(1:minlen);
end

y=cell2mat(y);

mean0=mean(y,1);
std0=std(y,1,1);
[hnewfig haxes]=getnewaxes(h);
plot(haxes,x(1:minlen)+fanofactorbinsize./2,mean0,'d-','MarkerFaceColor','b');
xlabel('Time (ms)');ylabel(sprintf('mean [#spks in %dms]',fanofactorbinsize));


[hnewfig haxes]=getnewaxes(h);
plot(haxes,x(1:minlen)+fanofactorbinsize./2,std0,'d-','MarkerFaceColor','b');
xlabel('Time (ms)');ylabel(sprintf('standard deviation [#spks in %dms]',fanofactorbinsize));


fano=std0./mean0;

[hnewfig haxes]=getnewaxes(h);
plot(haxes,x(1:minlen)+fanofactorbinsize./2,fano,'d-','MarkerFaceColor','b');
xlabel('Time (ms)');ylabel(sprintf('std./mean [#spks in %dms]',fanofactorbinsize));










function handles=plotraster(handles)
pickedk=handles.filepicks;
%if(isempty(validk)) return; end

axesinfo=handles.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end
if(isempty(validk))
    handles.output='no spikes found';
    return;
end
validk=fliplr(validk); %to plot data from top to bottom

ndata=length(validk);
[newfig haxes1]=getnewaxes(handles);

if(get(handles.checkbox_spikedensity,'Value'))
    plotspikedensity=1;
    [newfig haxes2]=getnewaxes(handles,'add');
else
    plotspikedensity=0;
end

if(get(handles.checkbox_samecolor4pairs,'Value'))
    samecolor4pairs=1;
else
    samecolor4pairs=0;
end

allspkt=[];
stimstart=[];
stimy=[];

if(samecolor4pairs)
    ncolor=1;
    for i=2:ndata
        found=0;
        if(findstr(axesinfo(validk(i)).fname, axesinfo(validk(i-1)).fname))
            found=1;
            continue;
        end
        if(~found)
            ncolor=ncolor+1;
        end
    end
else
    ncolor=ndata;
end


if(ncolor>6)
    colormap(hsv(ncolor));
else
    colormap(lines(ncolor));
end
cm=colormap;cm=flipud(cm);

colork=1;
for k=1:ndata
    spkt=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
    axes(haxes1);set(haxes1,'Color','k');
    if(axesinfo(validk(k)).stimdur>0)
        rectx=axesinfo(validk(k)).stimstart+[0 axesinfo(validk(k)).stimdur axesinfo(validk(k)).stimdur 0];
        recty=[-.2 -.2  .2 .2]+k;
        
        %        hrect=patch(rectx,recty, [.85 0.85 0.85], 'EdgeColor','none');%light green: [.596 .996 .655]);
        
        npulses=1;
        if(isfield(axesinfo(validk(k)),'stimpause') && isfield(axesinfo(validk(k)),'npulses'));
            if(~isempty(axesinfo(validk(k)).stimpause) && ~isempty(axesinfo(validk(k)).npulses));
                if(axesinfo(validk(k)).npulses>1 && axesinfo(validk(k)).stimpause>0)
                    npulses=axesinfo(validk(k)).npulses;
                    stimpause=axesinfo(validk(k)).stimpause;
                end
            end
        end
        
        if(npulses>1 && axesinfo(validk(k)).stimdur>=100)
            for j9=2:npulses
                rectx=rectx+stimpause+axesinfo(validk(k)).stimdur;
                hold on;
                hrect=patch(rectx,recty, [.85 .85 .85],'EdgeColor','none');%light green: [.596 .996 .655]);
            end
        end
    end
    
    
    %plot(spkt, ones(size(spkt))*k,'d','MarkerSize', 6, 'MarkerEdgeColor','none','MarkerFaceColor',cm(colork,:));%'b');
    spkt=spkt(spkt>=handles.timecap0*1000 & spkt<=handles.timecapend*1000);
    %     plot([spkt; spkt], [-1+ones(1, length(spkt))*.7+k+ceil(k/2); -1+ones(1, length(spkt))*1.3+k+ceil(k/2)],'Color',cm(colork,:));%,'LineWidth',1.2);
    if(~isempty(spkt))
        hold on;
        h=stem(spkt/1000, -1+ones(1, length(spkt))*1.35+k,'Marker','none','Color',cm(colork,:),'BaseValue',-1+.65+k);
        set(get(h,'BaseLine'),'LineStyle','none');
        
        %   plot([spkt; spkt], [-1+ones(1, length(spkt))*.7+k; -1+ones(1, length(spkt))*1.3+k],'Color',cm(colork,:));%,'LineWidth',1.2);
        if(k<ndata)
            if(~samecolor4pairs)
                colork=colork+1;
            elseif(isempty(findstr(axesinfo(validk(k)).fname, axesinfo(validk(k+1)).fname)))
                colork=colork+1;
            end
        end
        
        %    if(~isempty(axesinfo(validk(k)).stimstart))
        %       stimstart=[stimstart axesinfo(validk(k)).stimstart];
        %       %stimy=[stimy (ndata-k+1)];
        %    end
        if(size(spkt,2)>1) spkt=spkt';end
        allspkt=[allspkt; spkt];
        yticklabel{k}=axesinfo(validk(k)).fname((end-3):end);
    end
end
%plot(stimstart, stimy,'r');

titlechar=strcat(axesinfo(validk(ndata)).fname, '(1)');
titlechar=strcat(titlechar, '... ', axesinfo(validk(1)).fname, '(',num2str(ndata) ,')');
ylabel('index of spike train');


% set(gca,'TickDir','out','YTick',1:(length(validk)+ceil(length(validk)/2)))
% for i=1:floor(ndata/2)
% y{i*3-2}='';
% y{i*3-1}=yticklabel{i*2-1};
% y{i*3}=yticklabel{i*2};
% end
% yticklabel=y;
% set(gca,'TickDir','out','YTickLabel',yticklabel);

set(gca,'TickDir','out','YTick',1:length(validk));
set(gca,'TickDir','out','YTickLabel',yticklabel);

if(~plotspikedensity)xlabel('Time (ms)');end
htitle=title(titlechar);set(htitle,'Interpreter','none');
hold off;


if(plotspikedensity)
    winx=str2num(get(handles.edit_winx,'String'));
    if(isempty(winx))
        handles.output='windows size is not proper';
        return;
    end
    if(winx<=0)
        handles.output='windows size is not proper';
        return;
    end
    
    minx=min(allspkt); maxx=max(allspkt);
    if(winx>maxx-minx)
        handles.output='windows size is too big';
        return;
    end
    
    dx=max(axesinfo(validk(k)).dt, (maxx-minx)/length(allspkt))/2;
    dx=min(dx,winx); %if window size is too small
    x=minx:dx:maxx;
    
    allspkt=sort(allspkt);
    
    for k=1:length(x)
        spkdensity(k)=length(find(x(k)<=allspkt & allspkt<x(k)+winx));
    end
    
    axes(haxes2);
    plot(x, spkdensity);
    xlabel('Time (ms)');ylabel(sprintf('#spks in a window(%dms)',winx));
end


nowaxis=axis;
axis([handles.timecap0 handles.timecapend nowaxis(3:4)]);



handles.output='raster plot completed';















function handles=plotipsth(handles)
pickedk=handles.filepicks;
%if(isempty(validk)) return; end
separatepsth=get(handles.checkbox_separatepsth,'Value');

axesinfo=handles.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end



ndata=length(validk);
[hfig haxes]=getnewaxes(handles);

if(~separatepsth)
    allspkt=[];allisi0=[];indexk=[];
    for k=1:ndata
        spkt=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
        %hold on;
        if(size(spkt,2)>1) spkt=spkt';end
        allspkt=[allspkt; spkt(spkt>=handles.timecap0*1000 & spkt<=handles.timecapend*1000)];
        indexk=[indexk; ones(sum((spkt>=handles.timecap0*1000 & spkt<=handles.timecapend*1000)),1)*k];
        allisi0=[allisi0; diff([0; spkt(spkt>=handles.timecap0*1000 & spkt<=handles.timecapend*1000)])];
    end
    
    [allspkt order9]=sort(allspkt,'ascend');
    indexk=indexk(order9);
    allisi0=allisi0(order9);
    allisi=zeros(ndata,length(allspkt));
    allisi((1:length(allspkt))'*ndata-ndata+indexk)=allisi0;
    for i=1:ndata
        a=find(allisi(i,:)>0,1,'last');
        allisi(i,a:end)=allisi(i,a);
    end
    
    allisi=allisi';
    while(1)
        a=find(allisi==0);
        if(isempty(a))
            break;
        end
        allisi(a)=allisi(a+1);
    end
    allisi=allisi';
    %     allisi=[allisi(:,3:end) allisi(:,[end end]);...
    %         allisi(:,2:end) allisi(:,end);...
    %         allisi;...
    %         allisi(:,1) allisi(:,1:(end-1));...
    %         allisi(:,[1 1]) allisi(:,1:(end-2));];
    %      allisi=sort(allisi,1,'descend');
    %      allisi=allisi(max(1,floor(size(allisi,1)/3)):(end-floor(size(allisi,1)/3)),:);
    isim=1000./mean(allisi,1);
    %isim=1000./allisi(floor(size(allisi,1)/2),:);
    %handles.bingap=str2num(get(handles.edit_nbins,'String'));
    handles.bingap=str2num(get(handles.edit_bingap,'String'));
    
    %    minx=min(allspkt); maxx=max(allspkt);
    axes(haxes);
    
    if(~isempty(isim))
        %add padding
        plot(haxes,allspkt,isim);
        xlabel('Time (ms)');ylabel('Spike rate [1/ISI]');
        nowaxis=axis;
        axis([handles.timecap0*1000 handles.timecapend*1000 nowaxis(3:4)]);
        
        %         assignin('base','pstht',x);
        %         assignin('base','psth',spkdensity);
        handles.output='iPSTH plotted';
        
        %copy resulting plot to the clipboard
        %if(get(handles.checkbox_write2xls,'Value'))
        %   clipboard('copy', [x; spkdensity])
        %end
        
        %write result in Xls file - viewspike_result.xls
    end
else
    %separate psth
    
    for i=1:ndata
        spkt=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        
        if(size(spkt,2)>1) spkt=spkt';end
        
        %handles.bingap=str2num(get(handles.edit_nbins,'String'));
        handles.bingap=str2num(get(handles.edit_bingap,'String'));
        
        minx=handles.timecap0*1000; maxx=handles.timecapend*1000;
        if(handles.winx>maxx-minx)
            handles.output='bin size is too big';
            return;
        end
        
        dx=min(handles.bingap,handles.winx); %if window size is less than sampling interval
        x=dx*(floor(minx/dx):ceil(maxx/dx));
        
        %allspkt=sort(allspkt);
        
        for k=1:length(x)
            spkdensity(i,k)=length(find(x(k)<=spkt & spkt<x(k)+handles.winx))*1000/handles.winx;
        end
        
    end
    
    if(~isempty(x))
        axes(haxes);
        x=x+handles.winx/2;
        %         %add padding
        %         x=[x(1)-dx x x(end)+dx];
        %         spkdensity=[0 spkdensity 0];
        
        
        %hbar=bar(x, spkdensity,'b');
        %set(hbar,'EdgeColor','b');
        cm=colormap(hsv(ndata));
        for j=1:ndata
            plot(haxes,x,spkdensity(j,:),'Color',cm(j,:));hold on;
        end
        xlabel('Time (ms)');ylabel({'Spike rate', sprintf('[%dms/%dms]',handles.winx,1000*(x(2)-x(1)))});
        nowaxis=axis;
        axis([handles.timecap0*1000 handles.timecapend*1000 nowaxis(3:4)]);
        
        assignin('base','pstht',x);
        assignin('base','psth',spkdensity);
        handles.output='PSTH plotted';
    end
end


function [handles winx dx pstht psthy]=plotPSTH(handles)
%winx : bin size [ms]
%dx : sampling interval [ms]
winx=[];dx=[];
pstht=[];
psthy=[];

pickedk=handles.filepicks;
%if(isempty(validk)) return; end
separatepsth=get(handles.checkbox_separatepsth,'Value');

axesinfo=handles.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end


handles.winx=str2num(get(handles.edit_winx,'String'));
if(isempty(handles.winx))
    handles.output='window size is not proper';
    return;
end
if(handles.winx<=0)
    handles.output='window size is not proper';
    return;
end



ndata=length(validk);
[hfig haxes]=getnewaxes(handles);

if(~separatepsth)
    %handles.bingap=str2num(get(handles.edit_nbins,'String'));
    handles.bingap=str2num(get(handles.edit_bingap,'String'));
    
    %    minx=min(allspkt); maxx=max(allspkt);
    minx=handles.timecap0*1000; maxx=handles.timecapend*1000;
    
    if(handles.winx>maxx-minx)
        handles.output='window size is too big';
        return;
    end
    
    dx=min(handles.bingap,handles.winx); %if window size is too small
%     x=dx*(floor(minx/dx):ceil(maxx/dx));
    x=(minx-dx/2):dx:(maxx+dx/2);
    
    if(0)
        %compute only spike density
        allspkt=[];
        for k=1:ndata
            spkt=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
            %hold on;
            if(size(spkt,2)>1) spkt=spkt';end
            allspkt=[allspkt; spkt(spkt>=handles.timecap0*1000 & spkt<=handles.timecapend*1000)];
        end
        allspkt=sort(allspkt);
        
        if(isempty(allspkt))
            return;
        end
        
        for k=1:length(x)
            spkdensity(k)=length(find(x(k)<=allspkt & allspkt<x(k)+handles.winx))*1000/handles.winx/ndata;
        end
    else
        spkCount=zeros(ndata,length(x));
        
        %compute spike density + std
        for i=1:ndata
            spkt=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
            for j=1:length(x)
                spkCount(i,j)=sum((x(j)<=spkt & spkt<x(j)+handles.winx));
            end
        end
        
        spkCount=spkCount*1000/handles.winx;
        
        spkdensity=mean(spkCount,1);
        spkstd=std(spkCount,1);
        
    end
    x=x+dx/2;
    if(~isempty(x))
        if(0)
            %add padding
            x=x+handles.winx/2;
            x=[x(1)-dx x x(end)+dx];
            spkdensity=[0 spkdensity 0];
            spkdensity=spkdensity(x>0);
            x=x(x>0);
        end
        
        
        %hbar=bar(x, spkdensity,'b');
        %set(hbar,'EdgeColor','b');
        
        axes(haxes);hold on;
        if(1)
            confinterval=spkstd*tinv(0.95,ndata-1)/sqrt(ndata);
            hfill=fill([x fliplr(x)]/1000, [spkdensity+confinterval fliplr(spkdensity-confinterval)],'k');
            set(hfill,'FaceColor',[1 1 1]*.65,'EdgeColor',[1 1 1]*.65);
        end
        plot(haxes,x/1000,spkdensity,'LineWidth',2);
        xlabel('Time (s)');ylabel({'Spike rate', sprintf('[%dms/%dms]',handles.winx,(x(2)-x(1)))});
        nowaxis=axis;
        axis([handles.timecap0 handles.timecapend nowaxis(3:4)]);
        
        assignin('base','pstht',x);
        assignin('base','psth',spkdensity);
        handles.output='PSTH plotted';
        
        %copy resulting plot to the clipboard
        %if(get(handles.checkbox_write2xls,'Value'))
        %   clipboard('copy', [x; spkdensity])
        %end
        
        %write result in Xls file - viewspike_result.xls
        warning off MATLAB:xlswrite:AddSheet
        if(get(handles.checkbox_write2xls,'Value'))
            temp=[x; spkdensity]';
            sheettitle=strcat('PSTH-',datestr(now,'HHMMSS'));
            warning off;
            xlswrite('viewspike_result.xls',temp, sheettitle,'A2');
            xlswrite('viewspike_result.xls',{'x' 'y' 'files'}, sheettitle,'A1');
            warning on;
            for k=1:ndata
                fnames9{k}=axesinfo(validk(k)).fname;
            end
            warning off;
            xlswrite('viewspike_result.xls',fnames9', sheettitle,'C2');
            warning on;
        end
        warning on MATLAB:xlswrite:AddSheet
    end
else
    %separate psth
    
    for i=1:ndata
        spkt=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        
        if(size(spkt,2)>1) spkt=spkt';end
        
        %handles.bingap=str2num(get(handles.edit_nbins,'String'));
        handles.bingap=str2num(get(handles.edit_bingap,'String'));
        
        minx=handles.timecap0*1000; maxx=handles.timecapend*1000;
        if(handles.winx>maxx-minx)
            handles.output='window size is too big';
            return;
        end
        
        dx=min(handles.bingap,handles.winx); %if window size is less than sampling interval
        x=dx*(floor(minx/dx):ceil(maxx/dx));
        
        %allspkt=sort(allspkt);
        
        for k=1:length(x)
            spkdensity(i,k)=length(find(x(k)<=spkt & spkt<x(k)+handles.winx))*1000/handles.winx;
        end
        
    end
    
    if(~isempty(x))
        axes(haxes);
        x=x+handles.winx/2;
        %         %add padding
        %         x=[x(1)-dx x x(end)+dx];
        %         spkdensity=[0 spkdensity 0];
        
        
        %hbar=bar(x, spkdensity,'b');
        %set(hbar,'EdgeColor','b');
        cm=colormap(jet(ndata));
        for j=1:ndata
            plot(haxes,x,spkdensity(j,:),'Color',cm(j,:));hold on;
        end
        xlabel('Time (ms)');ylabel(sprintf('Spike rate [%dms, per trial]',handles.winx));
        nowaxis=axis;
        axis([handles.timecap0*1000 handles.timecapend*1000 nowaxis(3:4)]);
        
        assignin('base','pstht',x);
        assignin('base','psth',spkdensity);
        handles.output='PSTH plotted';
    end
end

winx=handles.winx;
pstht=x;
psthy=spkdensity;



function handles=plotPSD(handles)
pickedk=handles.filepicks;
%if(isempty(validk)) return; end

axesinfo=handles.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end


ndata=length(validk);

hfig76=figure(76);set(hfig76,'Color',[1 1 1]);
[num, den]=cheby2(10,80,.5);
for k=1:ndata
    d9=zeros(axesinfo(validk(k)).spkk(end),1);
    d9(axesinfo(validk(k)).spkk)=1;
    d8=filter(num,den,d9);
    [Pxx, f]=periodogram(d8, [],length(d8), 1000/axesinfo(validk(k)).dt);
    loglog(f, Pxx);grid on;
    hold all;
    legendstr(k)={axesinfo(validk(k)).fname};
end
title('PSD Estimate via Periodogram','Interpreter','none');
xlabel('frequency [Hz]');ylabel('Power/frequency [dB/Hz]');
legend(legendstr,'Interpreter','none');

handles.output='PSD plotted';


function [hfig haxes]=getnewaxes(handles,forceadd)
%determine where to locate the new axes
%relocate other axes if required
%return the handle of new axes

% anmo=handles.nfig

if(nargin<2) forceadd='noadd';end


if(get(handles.checkbox_addaxes,'Value')||strcmp(forceadd,'add'))
    hfig=figure(handles.nfig);
    set(hfig,'Color',[1 1 1]);
    
    allaxes9=findobj(hfig,'Type','axes');
    allaxes=[];
    for jj=1:length(allaxes9)
        position=get(allaxes9(jj),'Position');
        if(position(3)>0.7)
            %if width is smaller than 0.7, it's a "legend"
            allaxes(length(allaxes)+1)=allaxes9(jj);
        end
    end
    
    if(isempty(allaxes))
        haxes=axes('FontSize',15);
    else
        %reorder them
        allaxes=fliplr(allaxes);
        %if there exists some axes
        %add new axes and plot there
        nallaxes=length(allaxes)+1;
        lowmargin=1/nallaxes*.18;
        height=1/nallaxes*.72;
        for j=1:length(allaxes)
            set(allaxes(j),'Position',[0.1 (lowmargin+(nallaxes-j)/nallaxes) 0.85 height]);
            set(get(allaxes(j),'XLabel'),'Visible','off');
            if(j>1)
                set(get(allaxes(j),'Title'),'Visible','off');
            end
        end
        figure(hfig);
        haxes=axes('Position',[.1 lowmargin .85  height],'FontSize',15);
%         plottools;
        
    end
    
else
    hfig=figure(handles.nfig);clf;
    set(hfig,'Color',[1 1 1]);
    haxes=axes('FontSize',15);
end


function handles=plotphase(handles)
pickedk=handles.filepicks;
%if(isempty(validk)) return; end

axesinfo=handles.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

if(naxes<2) return; end;


[hnewfig haxes]=getnewaxes(handles);
onlypairs=get(handles.checkbox_paironly,'Value');
plotonlymean=get(handles.checkbox_plotonlymean,'Value');


if(naxes<3 && onlypairs)
    colormap(lines(ceil(naxes)));
elseif(onlypairs)
    colormap(lines(ceil(naxes)));
elseif(naxes>2)
    colormap(hsv(naxes*(naxes-1)));
else
    colormap(lines(naxes*(naxes-1)));
end

cm=colormap;
l=1;


%spktall=axesinfo(validk(naxes)).spkk*axesinfo(validk(naxes)).dt;
minendt=inf;
maxstartt=0;
stall=[];

for i=1:(naxes-1)
    %spktall=[spktall axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt];
    minendt=min(minendt, axesinfo(validk(i)).spkk(end)*axesinfo(validk(i)).dt);
    maxstartt=max(maxstartt,axesinfo(validk(i)).spkk(1)*axesinfo(validk(i)).dt);
    for j=(i+1):naxes
        stA=[];stB=[];
        if(onlypairs) %if i & j are not in pair, skip to the next turn
            if(isempty(findstr(axesinfo(validk(i)).fname,axesinfo(validk(j)).fname)))
                continue;
            end
        end
        spktA{l}=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        endtA=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
        spktB{l}=axesinfo(validk(j)).spkk*axesinfo(validk(j)).dt;
        endtB=length(axesinfo(validk(j)).d)*axesinfo(validk(j)).dt;
        
        stA0=([0 spktA{l}]+[spktA{l} endtA])./2;
        stA(1:2:(length(stA0)*2))=stA0;
        thetaA=ones(1,length(stA));
        stA(2:2:(length(stA0)*2-1))=spktA{l};
        thetaA(2:2:(length(stA0)*2-1))=0;
        
        stB0=([0 spktB{l}]+[spktB{l} endtB])./2;
        stB(1:2:(length(stB0)*2))=stB0;
        thetaB=ones(1,length(stB));
        stB(2:2:(length(stB0)*2-1))=spktB{l};
        thetaB(2:2:(length(stB0)*2-1))=0;
        
        stAB0=sort([stA stB]);
        stAB{l}=stAB0(diff([0 stAB0])>0);%remove duplicates
        
        thetaAB{l}=180*abs(interp1_anmo2(stA,thetaA,stAB{l},'linear')-interp1_anmo2(stB,thetaB,stAB{l},'linear'));
        
        stall=[stall stAB{l}];
        
        if(~plotonlymean)
            plot(haxes,stAB{l},thetaAB{l},'d','MarkerEdgeColor',...
                'none','MarkerFaceColor',cm(l*2,:));hold on;
        end
        
        %         for k=1:length(spktA{l})
        %             Bindex=find(spktB{l}>spktA{l}(k),1,'first');
        %             if(isempty(Bindex))
        %                 PhaseA{l}(k)=(spktA{l}(k)-spktB{l}(end))/...
        %                     (endtB-spktB{l}(end));
        %             elseif(Bindex==1)
        %                 PhaseA{l}(k)=spktA{l}(k)/spktB{l}(1);
        %             else
        %                 PhaseA{l}(k)=(spktA{l}(k)-spktB{l}(Bindex-1))./...
        %                     (spktB{l}(Bindex)-spktB{l}(Bindex-1));
        %             end
        %         end
        %         PhaseA{l}(PhaseA{l}>0.5)=PhaseA{l}(PhaseA{l}>0.5)-1;
        %         PhaseA{l}=PhaseA{l}*360;
        %         if(~plotonlymean)
        %             plot(haxes,spktA{l},PhaseA{l},'d','MarkerEdgeColor',...
        %                 'none','MarkerFaceColor',cm(l*2-1,:));        hold on;
        %         end
        %         for k=1:length(spktB{l})
        %             Aindex=find(spktA{l}>spktB{l}(k),1,'first');
        %             if(isempty(Aindex))
        %                 PhaseB{l}(k)=(spktB{l}(k)-spktA{l}(end))/...
        %                     (endtA-spktA{l}(end));
        %             elseif(Aindex==1)
        %                 PhaseB{l}(k)=spktB{l}(k)/spktA{l}(1);
        %             else
        %                 PhaseB{l}(k)=(spktB{l}(k)-spktA{l}(Aindex-1))./...
        %                     (spktA{l}(Aindex)-spktA{l}(Aindex-1));
        %             end
        %         end
        %         PhaseB{l}(PhaseB{l}>0.5)=PhaseB{l}(PhaseB{l}>0.5)-1;;
        %         PhaseB{l}=PhaseB{l}*360;
        %         if(~plotonlymean)
        %             plot(haxes,spktB{l},PhaseB{l},'d','MarkerEdgeColor',...
        %                 'none','MarkerFaceColor',cm(l*2,:));
        %         end
        l=l+1;
    end
    
    if(l>100) break; end; %to prevent the out of memory error
    
end

if(l==1)
    return;
end

% spktall=sort(spktall);%sort in ascending manner
% spktall=spktall(diff([0 spktall])>0);
% spktall=spktall(spktall<=minendt);
% spktall=spktall(spktall>=maxstartt);
%
%
%
% for j=1:length(PhaseA)
%     phase(2*j-1,:)=interp1(spktA{j}, PhaseA{j},spktall,'linear');
%     phase(2*j,:)=interp1(spktB{j}, PhaseB{j},spktall,'linear');
%     phase1(j,:)=max(abs(phase(2*j-1,:)),abs(phase(2*j,:)));
% end

stall=sort(stall);%sort in ascending order
stall=stall(diff([0 stall])>0);%get rid of the duplicates
for i=1:length(thetaAB)
    y(i,:)=interp1_anmo2(stAB{i},thetaAB{i},stall,'linear');
end
phaseabs=mean(y,1);

assignin('base','yphaseabs',phaseabs);
assignin('base','xphaseabs',stall);

% phasestd=zeros(size(phasemean))
% for i=1:length(phasemean)
%     phasestd(i)=sqrt(mean((min(abs(phase(:,i)-phasemean(i)), abs(360-phase(:,i)+phasemean(i)))).^2));
% end
plot(haxes,stall,phaseabs,'r','LineWidth',1);
axes(haxes);xlabel('Time (ms)');ylabel('phase(degree)');
set(haxes,'YTick',[0 45 90 135 180]);
nowaxis=axis(haxes);
%hold on; plot(haxes,nowaxis(1:2), [0 0],'k-');
axis([nowaxis(1:2) 0 180]);





function h=plotISIratio(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

if(naxes<2) return; end;

onlypairs=get(h.checkbox_paironly,'Value');
plotonlymean=get(h.checkbox_plotonlymean,'Value');

[hnewfig haxes]=getnewaxes(h);
if(naxes<3 && onlypairs)
    colormap(lines(ceil(naxes)));
elseif(onlypairs)
    colormap(lines(ceil(naxes)));
elseif(naxes>2)
    colormap(hsv(naxes*(naxes-1)));
else
    colormap(lines(naxes*(naxes-1)));
end
cm=colormap;
l=1;

stall=[];


for i=1:(naxes-1)
    for j=(i+1):naxes
        if(onlypairs) %if i & j are not in pair, skip to the next turn
            if(isempty(findstr(axesinfo(validk(i)).fname,axesinfo(validk(j)).fname)))
                continue;
            end
        end
        
        spktA{l}=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        endtA=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
        ISIA=diff([0 spktA{l} endtA]);
        
        spktB{l}=axesinfo(validk(j)).spkk*axesinfo(validk(j)).dt;
        endtB=length(axesinfo(validk(j)).d)*axesinfo(validk(j)).dt;
        ISIB=diff([0 spktB{l} endtB]);
        
        spktAB=sort([spktA{l} spktB{l}]);
        stAB{l}=([spktAB max(endtA,endtB)]+[0 spktAB])/2;
        stall=[stall stAB{l}];
        
        for k=1:length(stAB{l})
            Aindex=find(spktA{l}>stAB{l}(k),1,'first');
            Bindex=find(spktB{l}>stAB{l}(k),1,'first');
            if(~isempty(Aindex) && ~isempty(Bindex))
                ISIratioAB{l}(k)=ISIA(Aindex)/ISIB(Bindex);
            elseif(isempty(Aindex) && isempty(Bindex))
                ISIratioAB{l}(k)=ISIA(end)/ISIB(end);
            elseif(isempty(Bindex))
                ISIratioAB{l}(k)=ISIA(Aindex)/ISIB(end);
            else
                ISIratioAB{l}(k)=ISIA(end)/ISIB(Bindex);
            end
        end
        ISIratioAB{l}(ISIratioAB{l}>1)=1./ISIratioAB{l}(ISIratioAB{l}>1);
        if(~plotonlymean)
            plot(haxes,stAB{l},ISIratioAB{l},'d','MarkerEdgeColor',...
                'none','MarkerFaceColor',cm(l*2-1,:));  hold on;
        end
        l=l+1;
    end
    
    if(l>100) break; end; %to prevent the out of memory error
    
end

axes(haxes);xlabel('Time (ms)');ylabel('ISI ratio');

stall=sort(stall);%sort in ascending order
stall=stall(diff([0 stall])>0);
for i=1:length(ISIratioAB)
    y(i,:)=interp1(stAB{i},ISIratioAB{i},stall,'linear');
end
mean0=mean(y,1);

assignin('base','yISIratio',mean0);
assignin('base','xISIratio',stall);
plot(haxes,stall,mean0,'b','LineWidth',1.5);
ylabel('ISIratio');
nowaxis=axis(haxes);
axis(haxes,[nowaxis(1:2) 0 1]);






function h=plotisij(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

if(naxes<2) return; end;

onlypairs=get(h.checkbox_paironly,'Value');
plotonlymean=get(h.checkbox_plotonlymean,'Value');

[hnewfig haxes]=getnewaxes(h);
if(naxes<3 && onlypairs)
    colormap(lines(ceil(naxes)));
elseif(onlypairs)
    colormap(lines(ceil(naxes)));
elseif(naxes>2)
    colormap(hsv(naxes*(naxes-1)));
else
    colormap(lines(naxes*(naxes-1)));
end
cm=colormap;
l=1;

stall=[];


for i=1:(naxes-1)
    for j=(i+1):naxes
        if(onlypairs) %if i & j are not in pair, skip to the next turn
            if(isempty(findstr(axesinfo(validk(i)).fname,axesinfo(validk(j)).fname)))
                continue;
            end
        end
        
        spktA{l}=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        endtA=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
        stA=([spktA{l} endtA]+[0 spktA{l}])./2;
        ISIA=diff([0 spktA{l} endtA]);
        
        spktB{l}=axesinfo(validk(j)).spkk*axesinfo(validk(j)).dt;
        endtB=length(axesinfo(validk(j)).d)*axesinfo(validk(j)).dt;
        stB=([spktB{l} endtB]+[0 spktB{l}])./2;
        ISIB=diff([0 spktB{l} endtB]);
        
        %spktAB=sort([spktA{l} spktB{l}]);
        %stAB{l}=([spktAB max(endtA,endtB)]+[0 spktAB])/2;
        
        stAB{l}=sort([stA stB]);
        stAB{l}=stAB{l}(diff([0 stAB{l}])>0);%get rid of the duplicates
        isia5=interp1_anmo2(stA,ISIA,stAB{l},'linear');
        isib5=interp1_anmo2(stB,ISIB,stAB{l},'linear');
        isij{l}=abs(isia5-isib5);
        isim{l}=(isia5+isib5)./2;
        stall=[stall stAB{l}];
        
        
        
        %         for k=1:length(stAB{l})
        %             Aindex=find(spktA{l}>stAB{l}(k),1,'first');
        %             Bindex=find(spktB{l}>stAB{l}(k),1,'first');
        %             if(~isempty(Aindex) && ~isempty(Bindex))
        %                 ISIratioAB{l}(k)=ISIA(Aindex)/ISIB(Bindex);
        %             elseif(isempty(Aindex) && isempty(Bindex))
        %                 ISIratioAB{l}(k)=ISIA(end)/ISIB(end);
        %             elseif(isempty(Bindex))
        %                 ISIratioAB{l}(k)=ISIA(Aindex)/ISIB(end);
        %             else
        %                 ISIratioAB{l}(k)=ISIA(end)/ISIB(Bindex);
        %             end
        %         end
        %         ISIratioAB{l}(ISIratioAB{l}>1)=1./ISIratioAB{l}(ISIratioAB{l}>1);
        if(~plotonlymean)
            plot(haxes,stAB{l},log10(isij{l}+1),'d','MarkerEdgeColor',...
                'none','MarkerFaceColor',cm(l*2-1,:));  hold on;
        end
        l=l+1;
    end
    
    if(l>100) break; end; %to prevent the out of memory error
    
end

axes(haxes);xlabel('Time (ms)');ylabel('ISI Jitter');

stall=sort(stall);%sort in ascending order
stall=stall(diff([0 stall])>0);%get rid of the duplicates
isijall=[];
for i=1:length(isij)
    isij7(i,:)=interp1(stAB{i},isij{i},stall,'linear');
    isim7(i,:)=interp1(stAB{i},isim{i},stall,'linear');
    isijall=[isijall isij{i}];
    
end
isij0=mean(isij7,1);
isim0=mean(isim7,1);

assignin('base','isijx',stall);
assignin('base','isijy',isij0);
assignin('base','isimy',isim0);
plot(haxes,stall,log10(isij0+1),'b','LineWidth',1);hold on;
plot(haxes,stall,log10(isim0+1),'g');
plot(haxes,stall,log10(isij0./isim0+1),'r');
ylabel(['ISI Jitter, mean=' num2str(mean(isijall))]);
nowaxis=axis(haxes);
axis(haxes,[nowaxis(1:2) 0 max(log10(isij0+1))*1.1]);
set(haxes,'YTick',log10([0 0.5 1 5 10 50 100]+1),'YTickLabel',{'0' '0.5' '1' '5' '10' '50' '100'});
grid;






function h=plotisij3(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

if(naxes<2) return; end;

onlypairs=get(h.checkbox_paironly,'Value');
plotonlymean=get(h.checkbox_plotonlymean,'Value');

[hnewfig haxes]=getnewaxes(h);
if(naxes<3 && onlypairs)
    colormap(lines(ceil(naxes)));
elseif(onlypairs)
    colormap(lines(ceil(naxes)));
elseif(naxes>2)
    colormap(hsv(naxes*(naxes-1)));
else
    colormap(lines(naxes*(naxes-1)));
end
cm=colormap;
l=1;

stall=[];

if(onlypairs)
    for i=1:(naxes)
        spkt4=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        stall=[stall (spkt4(1:(end-1))+spkt4(2:end))./2];
        if(size(spkt4,1)>1)
            spkt4=spkt4';
        end
        spkt5{i}=reshape([spkt4; spkt4+axesinfo(validk(i)).dt], 1, length(spkt4)*2);
        isi4=diff([0 spkt4 length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt]);
        
        isi5{i}=[isi4(1) reshape([isi4(2:(end-1)); isi4(2:(end-1))], 1, length(isi4)*2-4) isi4(end)];
    end
    stall=sort(stall,'ascend');
    stall=stall(diff([0 stall])>0);%get rid of the duplicates
    isij=[];
    for i=1:(naxes-1)
        for j=(i+1):naxes
            if(isempty(findstr(axesinfo(validk(i)).fname,axesinfo(validk(j)).fname)))
                continue;
            end
            %for non-simultaneous pairs
            %j=j+2;
            %if(j>naxes) j=2; end
            
            endtA=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
            endtB=length(axesinfo(validk(j)).d)*axesinfo(validk(j)).dt;
            
            
            isia6=interp1_anmo2([0 spkt5{i} endtA] , [isi5{i}(1) isi5{i} isi5{i}(end)], stall,'linear');
            isib6=interp1_anmo2([0 spkt5{j} endtB] , [isi5{j}(1) isi5{j} isi5{j}(end)], stall,'linear');
            isij(l,:)=(isia6-isib6).^2;
            isim(l,:)=(isia6+isib6)./2;
            if(~plotonlymean)
                plot(haxes,stall,log10(isij{l}+1),'d','MarkerEdgeColor',...
                    'none','MarkerFaceColor',cm(l*2-1,:));  hold on;
            end
            l=l+1;
        end
        
        if(l>100) break; end; %to prevent the out of memory error
        
    end
    if(~isempty(isij))
        axes(haxes);xlabel('Time (ms)');ylabel('ISI Jitter');
        isij0=sqrt(mean(isij, 1));
        isim0=mean(isim,1);
    else
        return;
    end
else
    for i=1:(naxes)
        spkt4=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        stall=[stall (spkt4(1:(end-1))+spkt4(2:end))./2];
        if(size(spkt4,1)>1)
            spkt4=spkt4';
        end
        spkt5{i}=reshape([spkt4; spkt4+axesinfo(validk(i)).dt], 1, length(spkt4)*2);
        isi4=diff([0 spkt4 length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt]);
        
        isi5{i}=[isi4(1) reshape([isi4(2:(end-1)); isi4(2:(end-1))], 1, length(isi4)*2-4) isi4(end)];
    end
    stall=sort(stall,'ascend');
    stall=stall(diff([0 stall])>0);%get rid of the duplicates
    
    
    for i=1:(naxes)
        endt=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
        isi6(i,:)=interp1_anmo2([0 spkt5{i} endt] , [isi5{i}(1) isi5{i} isi5{i}(end)], stall,'linear');
    end
    isij0=std(isi6,1,1);
    isim0=mean(isi6,1);
    isijall=isim0;
end




assignin('base','isijy',isij0);
assignin('base','isijx',stall);
assignin('base','isimy',isim0);
plot(haxes,stall,log10(isij0+1),'r','LineWidth',1.2);hold on;
plot(haxes,stall,log10(isim0+1),'k');
%plot(haxes,stall,log10(isij0./isim0+1),'r');
ylabel(['ISI Jitter, mean=' num2str(mean(isim0))]);
nowaxis=axis(haxes);
axis(haxes,[nowaxis(1:2) 0 max(log10(isij0+1))*1.1]);
set(haxes,'YTick',log10([0 0.5 1 5 10 50 100]+1),'YTickLabel',{'0' '0.5' '1' '5' '10' '50' '100'});
grid;







function h=plotRcorr(h)
%correlation based reliability measure (Schreiber et. al, Neurocomputing,
%2003)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

if(naxes<2) return; end;

onlypairs=get(h.checkbox_paironly,'Value');
plotonlymean=get(h.checkbox_plotonlymean,'Value');
sigma=str2num(get(h.edit_Rcorr_sigma,'String'));
if(sigma<0 || sigma>100)
    return;
end
[hnewfig haxes]=getnewaxes(h);
if(naxes<3 && onlypairs)
    colormap(lines(ceil(naxes)));
elseif(onlypairs)
    colormap(lines(ceil(naxes)));
elseif(naxes>2)
    colormap(hsv(naxes*(naxes-1)));
else
    colormap(lines(naxes*(naxes-1)));
end
cm=colormap;
l=1;

stall=[];

%use only the part in the scope
if(sum(h.h0.vFollowaxis0)>0)
    t0=h.h0.vAxis0(1);
    tend=h.h0.vAxis0(2);
else
    t0=0;
    tend=inf;
end



for i=1:(naxes-1)
    for j=(i+1):naxes
        if(onlypairs) %if i & j are not in pair, skip to the next turn
            if(isempty(findstr(axesinfo(validk(i)).fname,axesinfo(validk(j)).fname)))
                continue;
            end
        end
        
        spktA{l}=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        endtA=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
        
        
        spktB{l}=axesinfo(validk(j)).spkk*axesinfo(validk(j)).dt;
        endtB=length(axesinfo(validk(j)).d)*axesinfo(validk(j)).dt;
        dt=min(axesinfo(validk(i)).dt, axesinfo(validk(j)).dt);
        if(t0>0 || tend<inf)
            spktA{l}=spktA{l}(spktA{l}>t0 & spktA{l}<tend);
            spktB{l}=spktB{l}(spktB{l}>t0 & spktB{l}<tend);
            t=max(0,t0):dt:min(min(endtA,endtB),tend);
        else
            t=0:dt:min(endtA,endtB);
        end
        lent=length(t);
        
        kernel=exp(-(-30:dt:30).^2/2/sigma^2)./sigma/sqrt(2*pi);
        lenker2=floor(length(kernel)/2);
        %   too much memory required
        %         Ax=zeros(length(spktA{l}),lent);
        %         spkkA=round((spktA{l}-t0)/dt);
        %         for k=1:length(spkkA)
        %             Ax(k,max(1,spkkA(k)-lenker2):min(lent,spkkA(k)+lenker2))...
        %                 =kernel(max(1,lenker2-spkkA(k)+2):min(lenker2*2+1,lent-spkkA(k)+lenker2+1));
        %         end
        %         Ax=sum(Ax,1);
        %
        Ax=zeros(1,lent);
        spkkA=round((spktA{l}-t0)/dt);
        for k=1:length(spkkA)
            Ax(max(1,spkkA(k)-lenker2):min(lent,spkkA(k)+lenker2))...
                =Ax(max(1,spkkA(k)-lenker2):min(lent,spkkA(k)+lenker2))+kernel(max(1,lenker2-spkkA(k)+2):min(lenker2*2+1,lent-spkkA(k)+lenker2+1));
        end
        
        % %because of memory requirement
        %         Bx=zeros(length(spktB{l}),lent);
        %         spkkB=round((spktB{l}-t0)/dt);
        %         for k=1:length(spkkB)
        %             Bx(k,max(1,spkkB(k)-lenker2):min(lent,spkkB(k)+lenker2))...
        %                 =kernel(max(1,lenker2-spkkB(k)+2):min(lenker2*2+1,lent-spkkB(k)+lenker2+1));
        %         end
        %         Bx=sum(Bx,1);
        Bx=zeros(1,lent);
        spkkB=round((spktB{l}-t0)/dt);
        for k=1:length(spkkB)
            Bx(max(1,spkkB(k)-lenker2):min(lent,spkkB(k)+lenker2))...
                =Bx(max(1,spkkB(k)-lenker2):min(lent,spkkB(k)+lenker2))+kernel(max(1,lenker2-spkkB(k)+2):min(lenker2*2+1,lent-spkkB(k)+lenker2+1));
        end
        
        
        
        tc{l}=t;
        c{l}=(Ax.*Bx)./sqrt(sum(Ax.^2))./sqrt(sum(Bx.^2));
        if(~plotonlymean)
            plot(haxes,tc{l},c{l},'Color',cm(l*2-1,:));  hold on;
        end
        l=l+1;
    end
    
    if(l>100) break; end; %to prevent the out of memory error
    
end

if(l==1 && onlypairs)
    h.output='spikeplots: no simultaneous pairs found';
    return;
elseif(l==1)
    h.output='spikeplots: no data found';
    return;
end
t0=0;tend=inf;
for i=1:length(tc)
    t0=max(t0,tc{i}(1));tend=min(tend,tc{i}(end));
    dt(i)=tc{i}(2)-tc{i}(1);
end
dt=mean(dt);
t=t0:dt:tend;
for i=1:length(c)
    cmean(i,:)=interp1(tc{i},c{i},t);
end
cmean=mean(cmean,1);

axes(haxes);xlabel('Time (ms)');ylabel('ISI ratio');
plot(haxes, t,cmean,'b','LineWidth',1.5);
% stall=sort(stall);%sort in ascending order
% stall=stall(diff([0 stall])>0);
% for i=1:length(ISIratioAB)
%     y(i,:)=interp1(stAB{i},ISIratioAB{i},stall,'linear');
% end
% mean0=mean(y,1);
%

assignin('base','Rcorr',c);
assignin('base','Rcorrt',tc);
% assignin('base','xISIratio',stall);
% plot(haxes,stall,mean0,'b','LineWidth',1.5);
ylabel('Rcorr'); xlabel('Time (ms)');
title(['Rcorr = ' num2str(sum(cmean)) ',sigma=' num2str(sigma) 'ms']);
% nowaxis=axis(haxes);
% axis(haxes,[nowaxis(1:2) 0 1]);









function h=plotISIratio2(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

if(naxes<2) return; end;

onlypairs=get(h.checkbox_paironly,'Value');
plotonlymean=get(h.checkbox_plotonlymean,'Value');

[hnewfig haxes]=getnewaxes(h);
if(naxes<3 && onlypairs)
    colormap(lines(ceil(naxes)));
elseif(onlypairs)
    colormap(lines(ceil(naxes)));
elseif(naxes>2)
    colormap(hsv(naxes*(naxes-1)));
else
    colormap(lines(naxes*(naxes-1)));
end
cm=colormap;
l=1;

stall=[];
for i=1:(naxes-1)
    for j=(i+1):naxes
        if(onlypairs) %if i & j are not in pair, skip to the next turn
            if(isempty(findstr(axesinfo(validk(i)).fname,axesinfo(validk(j)).fname)))
                continue;
            end
        end
        
        spktA{l}=axesinfo(validk(i)).spkk*axesinfo(validk(i)).dt;
        endtA=length(axesinfo(validk(i)).d)*axesinfo(validk(i)).dt;
        stA{l}=([spktA{l} endtA]+[0 spktA{l}])./2;
        ISIA=diff([0 spktA{l} endtA]);
        stall=[stall stA{l}];
        
        spktB{l}=axesinfo(validk(j)).spkk*axesinfo(validk(j)).dt;
        endtB=length(axesinfo(validk(j)).d)*axesinfo(validk(j)).dt;
        stB{l}=([spktB{l} endtB]+[0 spktB{l}])./2;
        ISIB=diff([0 spktB{l} endtB]);
        stall=[stall stB{l}];
        
        for k=1:length(stA{l})
            Bindex=find(spktB{l}>stA{l}(k),1,'first');
            if(isempty(Bindex))
                ISIratioA{l}(k)=ISIA(k)/ISIB(end);
            elseif(Bindex==1)
                ISIratioA{l}(k)=ISIA(k)/ISIB(1);
            else
                ISIratioA{l}(k)=ISIA(k)/ISIB(Bindex);
            end
        end
        ISIratioA{l}(ISIratioA{l}>1)=1./ISIratioA{l}(ISIratioA{l}>1);
        if(~plotonlymean)
            plot(haxes,stA{l},ISIratioA{l},'d','MarkerEdgeColor',...
                'none','MarkerFaceColor',cm(l*2-1,:));  hold on;
        end
        for k=1:length(stB{l})
            Aindex=find(spktA{l}>stB{l}(k),1,'first');
            if(isempty(Aindex))
                ISIratioB{l}(k)=ISIB(k)/ISIA(end);
            elseif(Aindex==1)
                ISIratioB{l}(k)=ISIB(k)/ISIA(1);
            else
                ISIratioB{l}(k)=ISIB(k)/ISIA(Aindex);
            end
        end
        ISIratioB{l}(ISIratioB{l}>1)=1./ISIratioB{l}(ISIratioB{l}>1);
        if(~plotonlymean)
            plot(haxes,stB{l},ISIratioB{l},'d','MarkerEdgeColor',...
                'none','MarkerFaceColor',cm(l*2,:));
        end
        l=l+1;
    end
    
    if(l>100) break; end; %to prevent the out of memory error
    
end

axes(haxes);xlabel('Time (ms)');ylabel('ISI ratio');

stall=sort(stall);%sort in ascending manner
stall=stall(diff([0 stall])>0);
for i=1:length(ISIratioA)
    y(2*i-1,:)=interp1(stA{i},ISIratioA{i},stall,'linear');
    y(2*i,:)=interp1(stB{i},ISIratioB{i},stall,'linear');
end
mean0=mean(y,1);

assignin('base','yISIratio',mean0);
assignin('base','xISIratio',stall);
plot(haxes,stall,mean0,'b','LineWidth',1.5);
ylabel('ISIratio');
nowaxis=axis(haxes);
axis(haxes,[nowaxis(1:2) 0 1]);



function handles=plotraw(handles,odoroption)
if(nargin<2) odoroption='';end

pickedk=handles.filepicks;
%if(isempty(validk)) return; end

axesinfo=handles.finfo;

validk=[];
for k=1:length(pickedk)
    %if(~isempty(axesinfo(pickedk(k)).spkk))
    validk=[validk pickedk(k)];
    %end
end

naxes=length(validk);

together=get(handles.cb0,'Value');
ensembleaverage=get(handles.checkbox_ensembleaverage,'Value');

if(together)
    [hnewfig haxes]=getnewaxes(handles);
    if(naxes>7)
        colormap(jet(naxes));
    else
        colormap(lines(naxes));
    end
    cm=colormap;
    
    prevxdata=[];prevdt=[];
    for k=1:naxes
        if(~strcmp(odoroption,'odor'))
            hlines=findobj(handles.haxes0(validk(k)), 'Type','line','Color',[0 0 1]);
        else
            if(~isfield(axesinfo(validk(k)),'hCaxes'))
                continue;
            end
            hlines=findobj(axesinfo(validk(k)).hCaxes,'Type','line','Color','b');
        end
        for kk=1:length(hlines)
            xdata=get(hlines(kk),'XData');
            timecapk=xdata>=handles.timecap0*1000 & xdata<=handles.timecapend*1000;
            xdata=xdata(timecapk);
            dt=xdata(2)-xdata(1);
            if(isempty(prevxdata)|| prevdt==dt)% || sum(xdata==prevxdata)==length(xdata) )
                prevxdata=xdata;
                prevdt=dt;
                ydata9=get(hlines(kk),'YData');
                ydata{k,kk}=ydata9(timecapk);
                if(~ensembleaverage)
                    %plot individuals
                    %h=copyobj(hlines(kk),haxes);
                    if(~strcmp(odoroption,'odor'))
                        h=plot(haxes,xdata/1000,ydata{k,kk});hold on;
                    else
                        if(isempty(axesinfo(validk(k)).stimstart))
                            axesinfo(validk(k)).stimstart=5000;
                        end
                        stimstartk1=find(xdata<axesinfo(validk(k)).stimstart,1,'last');
                        stimstartk0=find(xdata>axesinfo(validk(k)).stimstart-1000,1,'first');
                        if(~isempty(stimstartk0) && ~isempty(stimstartk1) && stimstartk1>=stimstartk0)
                            ydata{k,kk}=ydata{k,kk}-mean(ydata{k,kk}(stimstartk0:stimstartk1));
                        end
                        h=plot(haxes,xdata/1000,ydata{k,kk});hold on;
                    end
                    %                     set(h,'XData',xdata,'YData',ydata{k,kk}-mean(ydata{k,kk}(round((axesinfo(validk(k)).stimstart-200-handles.timecap0*1000)/dt)+...
                    %                         (1:round(200/dt)))));
                    %set(h,'YData',log(ydata-mean(ydata(1:10000))+.05)+log(.05));
                    set(h,'Visible','on','Color',cm(k,:));
                    %                    xdata=get(h, 'XData');
                    if(axesinfo(validk(k)).valve_open0>0)
                        xdata=xdata-axesinfo(validk(k)).valve_open0*axesinfo(validk(k)).dt+axesinfo(validk(k)).stimstart;
                        set(h, 'XData',xdata);
                        prevxdata=xdata;
                    end
                end
                
            end
        end
    end
    
    if(ensembleaverage&&exist('ydata','var'))
        %plot average
        if(~isempty(ydata))
            plot(haxes,prevxdata/1000,mean(cell2mat(ydata),1));
        end
    end
    
    %     %plot average odor concentration
    %     if(strcmp(odoroption,'odor'))
    %         nvalidydata=0;
    %         sumydata=zeros(size(xdata));
    %         for k=1:naxes
    %             if(length(xdata)==length(ydata{k,1}))
    %                 sumydata=sumydata+ydata{k,1};
    %                 nvalidydata=nvalidydata+1;
    %             end
    %         end
    %         if(nvalidydata>0)
    %             figure(handles.nfig+1);plot(xdata, sumydata./nvalidydata);xlabel('Time (ms)');
    %             title('mean ydata');
    %             figure(nfig);
    %         end
    %     end
    
    xlabel('Time (ms)');
    if(~strcmp(odoroption,'odor'))
        ylabel('membrane potential');
    else
        if(isfield(axesinfo(validk(1)),'ppmfactor'))
            ylabel('(ppm)');
        else
            ylabel('PID output, zero-offset');
        end
    end
    htitle=title(sprintf('%s ... %s',axesinfo(validk(1)).fname, axesinfo(validk(end)).fname));
    set(htitle,'Interpreter','none');
    hold off;
    if(naxes<20 && ~ensembleaverage)
        lh=legend(haxes, axesinfo(validk).fname);set(lh, 'Interpreter','none','FontSize',12);
    elseif(ensembleaverage)
        %lh=legend(haxes, 'ensemble average');
    end
    nowaxis=axis(haxes);
    axis(haxes,[handles.timecap0 handles.timecapend nowaxis(3:4)]);
else
    
    for k=1:naxes
        %        haxes(k)=subplot(naxes+naxes0,1,naxes0+naxes-k+1);
        [hnewfig haxes(k)]=getnewaxes(handles);
        
        if(~strcmp(odoroption,'odor'))
            children = findobj('Parent',handles.haxes0(validk(k)));
        else
            children = findobj('Parent',axesinfo(validk(k)).hCaxes);
        end
        
        for kk=length(children):-1:1
            h=copyobj(children(kk),haxes(k));
            set(h,'XData',get(h,'XData')/1000);
            set(h,'Visible','on');
            
        end;
        %         title(sprintf('fname:%s, stimstart=%dms, stimdur=%dms, Iin=%.2fpA, pp/con=%3.1f, celltype:%s, etc:%s, #spks:%d',...
        %             axesinfo(validk(k)).fname, axesinfo(validk(k)).stimstart, axesinfo(validk(k)).stimdur,...
        %             axesinfo(validk(k)).Iin, axesinfo(validk(k)).pp, axesinfo(validk(k)).celltype,...
        %             axesinfo(validk(k)).etc, length(axesinfo(validk(k)).spkk)),...
        %             'Interpreter','none');
        title(sprintf('fname:%s',...
            axesinfo(validk(k)).fname),...
            'Interpreter','none');
        
        phandles=guidata(handles.haxes0(validk(k)));
        if(~isempty(phandles.vAxis0))
            minx=phandles.vAxis0(1);  maxx=phandles.vAxis0(2);
            nowaxis=axis(haxes(k));
            axis([minx/1000 maxx/1000 nowaxis(3:4)]);
        end
        %    nowaxis=axis(handles.haxes0(k));
        %    minx=nowaxis(1);  maxx=nowaxis(2);
        %    nowaxis=axis(haxes(k));
        %    axis([minx maxx nowaxis(3:4)]);
    end
end
handles.output='raw data are plotted';


% if(get(handles.checkbox_align,'Value'))
%    for k=1:naxes
%       nowaxis=axis(haxes(k));
%       axis(haxes(k),[minx maxx nowaxis(3:4)]);
%    end
% end










function h=plotsta(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end
if(isempty(validk))
    h.output='no spikes found';
    return;
end
% validk=fliplr(validk); %to plot data from top to bottom

ndata=length(validk);





stasize=str2num(get(h.edit_stasize,'String'));
if(isempty(stasize))
    stasize=h.stasize;
else
    h.stasize=stasize;
end

fname1=cell(ndata,1);
ste1=cell(ndata,1);
sta0=zeros(1,stasize);
nspks=0;
for k=1:ndata
    %extracting spike sequence
    spkt0=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
    spkt=spkt0(spkt0>=h.timecap0*1000 & spkt0<=h.timecapend*1000);
    
    
    if(strfind(lower(axesinfo(validk(k)).stimtype),'hexane'))
        pidfactor=4.7;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'acetone'))
        pidfactor=0.997;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethanol'))
        pidfactor=8.8;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethyl acetate'))
        pidfactor=3.654;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'co2'))
        pidfactor=0.5;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'methyl butyrate'))
        pidfactor=3.49897/2;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butanal'))
        pidfactor=9.47/2;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butyraldehyde'))
        pidfactor=9.47/2;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'3% propylene'))
        pidfactor=5.744/2;
    else
        pidfactor=1;
    end
    
    c=axesinfo(validk(k)).c*axesinfo(validk(k)).ppmfactor*pidfactor;
    dt=axesinfo(validk(k)).dt;
    t=((1:length(c))-1)*dt+axesinfo(validk(k)).t0;
    c=c-mean(c(t>=4000 & t<5000));
    
    mc(k)=mean(c(t>=h.timecap0*1000 & t<h.timecapend*1000)); %mean concentration
    
    spkk=round(spkt./dt);
    stasize1=round(stasize./dt);
    index=repmat((-stasize1:0),length(spkk),1)+ repmat(spkk(:),1,stasize1+1);
    ste=c(index);
    
    ste1{k}=ste(:,1:round(1/dt):stasize1);
    fname1{k}=[axesinfo(validk(k)).fname];
    set(h.text_msg,'String',['STA: scanning ' fname1{k} '.mat   ...']);
    drawnow;
    
    sta0=sta0+sum(ste1{k}-mc(k),1);
    nspks=nspks+length(spkk);
end
sta=sta0./nspks;



underscorek=strfind(axesinfo(validk(end)).fname,'_');
if(isempty(underscorek)) underscorek=1; end
savefname=[axesinfo(validk(1)).fname '_'  axesinfo(validk(end)).fname(underscorek(end):end) '_sta_' num2str(stasize) '.mat'];

[newfig haxes1]=getnewaxes(h);
plot(haxes1,0:(stasize-1),fliplr(sta),'LineWidth',2);
axes(haxes1); xlabel('Time (ms)'); ylabel('Spike-Triggered Average');grid on;
title([axesinfo(validk(1)).fname ' ... '  axesinfo(validk(end)).fname(underscorek(end):end)],'Interpreter','none');

set(h.text_msg,'String',['saving ' savefname  ' ...']);
drawnow;
tstart=h.timecap0;
tend=h.timecapend;

save([h.h0.docfolder savefname], 'ste1', 'fname1', 'sta', 'mc','tstart','tend');

assignin('base','sta',sta);
assignin('base', 'fname', fname1);
assignin('base', 'mc', mc);

h.output=['STA is computed,plotted and saved to doc/' savefname];











function h=plotstc(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end
if(isempty(validk))
    h.output='no spikes found';
    return;
end
% validk=fliplr(validk); %to plot data from top to bottom

ndata=length(validk);


stasize=str2num(get(h.edit_stasize,'String'));
if(isempty(stasize))
    stasize=h.stasize;
else
    h.stasize=stasize;
end

underscorek=strfind(axesinfo(validk(end)).fname,'_');
if(isempty(underscorek)) underscorek=1; end
stafname=[axesinfo(validk(1)).fname '_'  axesinfo(validk(end)).fname(underscorek(end):end) '_sta_' num2str(stasize) '.mat'];
if(~exist([h.h0.docfolder stafname],'file'))
    h.output=['no STA file found: doc/' stafname ' is required...'];
    return;
end
load([h.h0.docfolder stafname], 'ste1', 'fname1', 'sta','mc','tstart','tend');
if(tstart~=h.timecap0 || tend~=h.timecapend || length(fname1)~=length(validk) || length(sta)~=stasize)
    h.output=['no STA file found: ' stafname ' is required...'];
    return;
end

for i=1:ndata
    if(~strcmp(fname1(i), axesinfo(validk(i)).fname))
        h.output=['STA file, ' stafname ' does NOT have analysis for ' axesinfo(validk(k)).fname1];
        return;
    end
end


for i=1:ndata
    ste1{i}=ste1{i}-mc(i);
end
ste=cell2mat(ste1(:));
clear('ste1','fname1','tstart','tend');

bOrthogonal2STA=false;
%make it orthogonal to STA
if(bOrthogonal2STA)
    x0=ste*sta';
    ste=ste-x0*sta./sum(sta.^2);
end
Cout=cov(ste(randperm(size(ste,1)),:));


bMean_Many_Cpriork=true; %take a mean of covariance matrices from each trial

if(bMean_Many_Cpriork)
    npriorsample=20000;
    Cprior=zeros(stasize,stasize,ndata);
    
    fname1=cell(ndata,1);
    for k=1:ndata
        %extracting spike sequence
        priort=rand(npriorsample,1)*(h.timecapend*1000-h.timecap0*1000-stasize)+h.timecap0*1000+stasize;
        
        
        if(strfind(lower(axesinfo(validk(k)).stimtype),'hexane'))
            pidfactor=4.7;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'acetone'))
            pidfactor=0.997;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethanol'))
            pidfactor=8.8;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethyl acetate'))
            pidfactor=3.654;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'co2'))
            pidfactor=0.5;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'methyl butyrate'))
            pidfactor=3.49897/2;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butanal'))
            pidfactor=9.47/2;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butyraldehyde'))
            pidfactor=9.47/2;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'3% propylene'))
            pidfactor=5.744/2;
        else
            pidfactor=1;
        end
        
        c=axesinfo(validk(k)).c*axesinfo(validk(k)).ppmfactor*pidfactor;
        dt=axesinfo(validk(k)).dt;
        t=((1:length(c))-1)*dt+axesinfo(validk(k)).t0;
        c=c-mean(c(t>=4000 & t<5000));
        
        %      mc(k)=mean(c(t>=h.timecap0*1000 & t<h.timecapend*1000)); %mean concentration
        
        priork=round(priort./dt);
        stasize1=round((stasize-1)./dt);
        index=repmat((-stasize1:round(1/dt):0),length(priork),1)+ repmat(priork(:),1,stasize);
        index=index(index(:,end)<=length(c),:);
        priorc1=c(index);
        
        
        %make it orthogonal to STA
        if(bOrthogonal2STA)
            x0=priorc1*sta';
            priorc1=priorc1-x0*sta./sum(sta.^2);
        end
        
        
        Cprior(:,:,k)=cov(priorc1);
        muprior(k,:)=mean(priorc1,1)-mc(k);
        
        fname1{k}=[axesinfo(validk(k)).fname];
        set(h.text_msg,'String',['STC: analyzing ' fname1{k} '.mat   ...']);
        drawnow;
    end
    
    Cprior=mean(Cprior,3);
    muprior=mean(muprior,1);
else
    %build an STE from whole data set and compute a single Cprior
    npriorsample=ceil(30000000./ndata/stasize);
    prior0=zeros(30000000/stasize, stasize);
    
    
    fname1=cell(ndata,1);
    for k=1:ndata
        %extracting spike sequence
        priort=rand(npriorsample,1)*(h.timecapend*1000-h.timecap0*1000-stasize)+h.timecap0*1000+stasize;
        
        
        if(strfind(lower(axesinfo(validk(k)).stimtype),'hexane'))
            pidfactor=4.7;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'acetone'))
            pidfactor=0.997;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethanol'))
            pidfactor=8.8;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethyl acetate'))
            pidfactor=3.654;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'co2'))
            pidfactor=0.5;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'methyl butyrate'))
            pidfactor=3.49897/2;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butanal'))
            pidfactor=9.47/2;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butyraldehyde'))
            pidfactor=9.47/2;
        elseif(strfind(lower(axesinfo(validk(k)).stimtype),'3% propylene'))
            pidfactor=5.744/2;
        else
            pidfactor=1;
        end
        c=axesinfo(validk(k)).c*axesinfo(validk(k)).ppmfactor*pidfactor;
        dt=axesinfo(validk(k)).dt;
        t=((1:length(c))-1)*dt+axesinfo(validk(k)).t0;
        c=c-mean(c(t>=4000 & t<5000));
        
        %      mc(k)=mean(c(t>=h.timecap0*1000 & t<h.timecapend*1000)); %mean concentration
        
        priork=round(priort./dt);
        stasize1=round((stasize-1)./dt);
        index=repmat((-stasize1:round(1/dt):0),length(priork),1)+ repmat(priork(:),1,stasize);
        priorc1=c(index);
        
        prior0((1:npriorsample)+(k-1)*npriorsample, :)=priorc1-mc(k);
        fname1{k}=[axesinfo(validk(k)).fname];
        set(h.text_msg,'String',['STC: scanning ' fname1{k} '.mat   ...']);
        drawnow;
        
        
    end
    
    %make it orthogonal to STA
    if(bOrthogonal2STA)
        x0=prior0*sta';
        prior0=prior0-x0*sta./sum(sta.^2);
    end
    
    Cprior=cov(prior0(randperm(size(prior0,1)),:));
    muprior=mean(prior0,1);
    
    clear prior0;
end



set(h.checkbox_addaxes,'Value',0)
[newfig haxes1]=getnewaxes(h);
axes(haxes1);surf(fliplr(flipud(Cprior)),'EdgeColor','none');
xlabel('Time (ms)'); ylabel('Time (ms)');
htitle=title(['Cprior: ' axesinfo(validk(1)).fname ' ... '  axesinfo(validk(end)).fname(underscorek(end):end)]);
set(htitle,'Interpreter','none');


h.nfig=h.nfig+1;
[newfig haxes2]=getnewaxes(h);
axes(haxes2);surf(fliplr(flipud(Cout)),'EdgeColor','none');
xlabel('Time (ms)'); ylabel('Time (ms)');
htitle=title(['Cout: ' axesinfo(validk(1)).fname ' ... '  axesinfo(validk(end)).fname(underscorek(end):end)]);
set(htitle,'Interpreter','none');


Cstc0=Cout-Cprior;
% bOrthogonal2STA=true;
% if(bOrthogonal2STA)
%     x0=Cstc0*sta';
%     Cstc1=Cstc0-x0*sta./sum(sta.^2);
% end


%filtering Cstc
bsmoothingSTC=true;
if(bsmoothingSTC)
    hsize=round(20); %ms
    sigma=round(4); %ms
    hgf = fspecial('gaussian', hsize, sigma);
    Cstc=imfilter(Cstc0,hgf,'symmetric');
else
    Cstc=Cstc0;
end




h.nfig=h.nfig+1;
[newfig haxes3]=getnewaxes(h);
axes(haxes3);surf(fliplr(flipud(Cstc)),'EdgeColor','none');
xlabel('Time (ms)'); ylabel('Time (ms)');
htitle=title(['Cstc: ' axesinfo(validk(1)).fname ' ... '  axesinfo(validk(end)).fname(underscorek(end):end)]);
set(htitle,'Interpreter','none');


[V, D]=eig(Cstc); %A*V=V*D
[temp tempk]=sort(-(diag(D)),'descend');
d=diag(D);
d=d(tempk);
V=V(:,tempk);


h.nfig=h.nfig+1;
[newfig haxes4]=getnewaxes(h);
plot(d,'k.');
xlabel('Index'); ylabel('eigenvalues');


set(h.checkbox_addaxes,'Value',1)

[newfig haxes4]=getnewaxes(h);
plot(0:(stasize-1),flipud(V(:,1)),'k','LineWidth',2);hold on;
plot(0:(stasize-1),flipud(V(:,2)),'r','LineWidth',2);
plot(0:(stasize-1),flipud(V(:,end)),'b','LineWidth',2);
xlabel('Time (ms)'); ylabel('eigenvectors');legend({'1st', '2nd','last'});


underscorek=strfind(axesinfo(validk(end)).fname,'_');
if(isempty(underscorek)) underscorek=1; end
stcfname=[axesinfo(validk(1)).fname '_'  axesinfo(validk(end)).fname(underscorek(end):end) '_stc_' num2str(stasize) '.mat'];




%save the results
set(h.text_msg,'String',['saving ' stcfname  ' ...']);
drawnow;
tstart=h.timecap0;
tend=h.timecapend;
save([h.h0.docfolder stcfname], 'fname1','Cprior', 'Cout', 'sta', 'tstart','tend','d','V','muprior','bsmoothingSTC','bOrthogonal2STA');
assignin('base','Cprior',Cprior);
assignin('base', 'Cout', Cout);
assignin('base', 'V', V);
assignin('base', 'd', d);


h.output=['STC is computed,plotted and saved to doc/' stcfname];











function edit_winx_Callback(hObject, eventdata, handles)
% hObject    handle to edit_winx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_winx as text
%        str2double(get(hObject,'String')) returns contents of edit_winx as a double


% --- Executes during object creation, after setting all properties.
function edit_winx_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_winx (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






function edit_nbins_Callback(hObject, eventdata, handles)
% hObject    handle to edit_nbins (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_nbins as text
%        str2double(get(hObject,'String')) returns contents of edit_nbins as a double


% --- Executes during object creation, after setting all properties.
function edit_nbins_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_nbins (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in pushbutton_concentration.
function pushbutton_concentration_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_concentration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%web http://www.ee.columbia.edu/~kanmo/spiketools/tutorial/#x1-130003.4 -browser
if(strcmp(get(handles.radiobutton_barplot,'Enable'),'off'))
    return;
end

axesinfo=handles.finfo;
validk=[];
for i=1:length(axesinfo)
    if(~isempty(axesinfo(i).c))
        validk=[validk i];
    end
end

if(isempty(validk))
    set(handles.text_msg,'no data contains concentration profile');
    return;
end

handles.finfo=handles.finfo(validk);
handles=updatepage(handles);

set(handles.radiobutton_rawplot,'Value',1);
radiobutton_rawplot_Callback(handles.radiobutton_rawplot, eventdata, handles);
handles=guidata(hObject);
set(handles.cb0,'Value',1);
drawnow;
hrb=findobj(handles.uipanel_plottype,'Style','radiobutton');
for i=1:length(hrb)
    set(hrb(i),'Enable','off');
end




% --- Executes on button press in checkbox_align.
% function checkbox_align_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_align (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_align




% --- Executes on button press in checkbox_yintime.
function checkbox_yintime_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_yintime (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_yintime




% --- Executes on button press in radiobutton_crossintensity.
function radiobutton_crossintensity_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_crossintensity (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_crossintensity
hide_optioncontrols(handles);
set(handles.edit_winx, 'Visible','on');
set(handles.text_windowsize, 'Visible','on');

set(handles.edit_nbins, 'Visible','on');
set(handles.text_nbins, 'String','number of bins', 'Visible','on');
set(handles.checkbox_yintime, 'Visible','on');




% set(handles.checkbox_align, 'Visible','off');

% --- Executes on button press in radiobutton_barplot.
function radiobutton_barplot_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_barplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_barplot
hide_optioncontrols(handles);



% --- Executes on button press in radiobutton_isihist.
function radiobutton_isihist_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_isihist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_isihist
hide_optioncontrols(handles);

set(handles.checkbox_isihisttogether, 'Visible','on');
%set(handles.edit_nbins, 'String','50');
set(handles.edit_nbins, 'Visible','on');
set(handles.text_nbins, 'String','number of bins');
set(handles.text_nbins, 'Visible','on');


% --- Executes on button press in radiobutton_ipsth.
function radiobutton_ipsth_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_ipsth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_ipsth
hide_optioncontrols(handles);
set(handles.checkbox_separatepsth, 'Visible','on');

%set(handles.edit_nbins, 'String','50');
% set(handles.edit_nbins, 'Visible','on');
% set(handles.text_nbins, 'String','number of bins');
% set(handles.text_nbins, 'Visible','on');



% --- Executes on button press in radiobutton_raster.
function radiobutton_raster_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_raster (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_raster
hide_optioncontrols(handles);
set(handles.edit_winx, 'Visible','on');
set(handles.text_windowsize, 'Visible','on');
% set(handles.text_cb0, 'Visible','on','String','spike density');
% set(handles.cb0, 'Visible','on');
set(handles.checkbox_spikedensity, 'Visible','on');
set(handles.checkbox_samecolor4pairs,'Visible','on');


% --- Executes on button press in radiobutton_rawplot.
function radiobutton_rawplot_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_rawplot (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_rawplot
hide_optioncontrols(handles);
set(handles.text_cb0, 'Visible','on','String','together');
set(handles.cb0, 'Visible','on');




% --- Executes on button press in cb0.
function cb0_Callback(hObject, eventdata, handles)
% hObject    handle to cb0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of cb0




% --- Executes on button press in radiobutton_PSTH.
function radiobutton_PSTH_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_PSTH (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_PSTH
hide_optioncontrols(handles);

set(handles.edit_winx, 'Visible','on');
set(handles.text_windowsize, 'Visible','on');
set(handles.checkbox_separatepsth, 'Visible','on');

set(handles.edit_bingap, 'Visible','on');
set(handles.text_nbins, 'String','inter-bin time (ms)', 'Visible','on');
%set(handles.checkbox_write2xls, 'Visible','on');


% --- Executes on button press in checkbox_write2xls.
function checkbox_write2xls_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_write2xls (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_write2xls





function edit_nfig_Callback(hObject, eventdata, handles)
% hObject    handle to edit_nfig (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_nfig as text
%        str2double(get(hObject,'String')) returns contents of edit_nfig as a double


% --- Executes during object creation, after setting all properties.
function edit_nfig_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_nfig (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_naxes_Callback(hObject, eventdata, handles)
% hObject    handle to edit_naxes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_naxes as text
%        str2double(get(hObject,'String')) returns contents of edit_naxes as a double


% --- Executes during object creation, after setting all properties.
function edit_naxes_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_naxes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox9.
function checkbox9_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox9 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox9




% --- Executes on button press in radiobutton_odor.
function radiobutton_odor_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_odor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
hide_optioncontrols(handles);

set(handles.cb0, 'Visible','on','Value',1);
set(handles.text_cb0, 'Visible','on','String','on the same axes');
set(handles.checkbox_ensembleaverage,'Visible','on','Value',0);

handles=updatepage(handles,'odor');
guidata(hObject,handles);


% --- Executes on button press in checkbox_addaxes.
function checkbox_addaxes_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_addaxes (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_addaxes



%==================================
function out=inf2str(finfo)
out=[];
names=fieldnames(finfo);
for k=1:length(names)
    eval(strcat('val=finfo.',names{k},';'));
    if(~isempty(val) )
        if(isnumeric(val) & length(val)<10)
            val=num2str(val);
        end
        if(isstr(val) && length(val)<60)
            out=strcat(out, names{k}, '=',val,',');
        end
    end
end




function edit_pufflatency_Callback(hObject, eventdata, handles)
% hObject    handle to edit_pufflatency (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_pufflatency as text
%        str2double(get(hObject,'String')) returns contents of edit_pufflatency as a double


% --- Executes during object creation, after setting all properties.
function edit_pufflatency_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_pufflatency (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in radiobutton_periodhist.
function radiobutton_periodhist_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_periodhist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_periodhist
hide_optioncontrols(handles);

set(handles.edit_pufflatency, 'Visible','on');
set(handles.text_pufflatency, 'Visible','on');




% --- Executes on button press in checkbox_isihisttogether.
function checkbox_isihisttogether_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_isihisttogether (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_isihisttogether




% --- Executes on button press in radiobutton_phasejitter.
function radiobutton_phasejitter_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_phasejitter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_phasejitter
hide_optioncontrols(handles);

set(handles.checkbox_paironly, 'Visible','on');
set(handles.checkbox_plotonlymean,'Visible','on');

% --- Executes on button press in radiobutton_fanofactor.
function radiobutton_fanofactor_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_fanofactor (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_fanofactor
hide_optioncontrols(handles);
set(handles.text_fanofactorbinsize,'Visible','on');
set(handles.edit_fanofactorbinsize,'Visible','on');



function edit_fanofactorbinsize_Callback(hObject, eventdata, handles)
% hObject    handle to edit_fanofactorbinsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_fanofactorbinsize as text
%        str2double(get(hObject,'String')) returns contents of edit_fanofactorbinsize as a double


% --- Executes during object creation, after setting all properties.
function edit_fanofactorbinsize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_fanofactorbinsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in radiobutton_Rcorr.
function radiobutton_Rcorr_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_Rcorr (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_Rcorr
hide_optioncontrols(handles);

set(handles.checkbox_paironly, 'Visible','on');
set(handles.checkbox_plotonlymean,'Visible','on');
set(handles.text_Rcorr_sigma,'Visible','on');
set(handles.edit_Rcorr_sigma,'Visible','on');


% --- Executes on button press in pushbutton_selectall.
function pushbutton_selectall_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_selectall (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% for k=1:length(handles.onfilek)
%     if(handles.hcheckbox(k)~=0)
%         set(handles.hcheckbox(k),'Value',~get(handles.hcheckbox(k),'Value'));
%     end
%end
if(strcmpi(get(hObject,'String'),'all'))
    for k=1:length(handles.onfilek)
        set(handles.hcheckbox(k),'Value',1);
    end
    set(hObject,'String','none');
    set(handles.checkbox_column1,'Value',1);
    set(handles.checkbox_column2,'Value',1);
    set(handles.checkbox_column3,'Value',1);
else
    for k=1:length(handles.onfilek)
        set(handles.hcheckbox(k),'Value',0);
    end
    set(hObject,'String','all');
    
    set(handles.checkbox_column1,'Value',1);
    set(handles.checkbox_column2,'Value',1);
    set(handles.checkbox_column3,'Value',1);
end





% --- Executes on button press in pushbutton_switchset.
function pushbutton_switchset_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_switchset (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
istwochannels=false;
if(handles.altperiod==2)
    for i=1:length(handles.onfilek)
        if('b'==handles.finfo(handles.onfilek(i)).fname(end))
            istwochannels=true;
            break;
        end
    end
end

for i=1:length(handles.onfilek)
    if(get(handles.hcheckbox(i),'Value')==1)
        set(handles.hcheckbox(i),'Value',0)
        firstk=i;
        break;
    end
end

if((firstk==1 && get(handles.hcheckbox(2),'Value')) || firstk>(length(handles.onfilek)/2))
    firstk=0;
end

if(~istwochannels)
    for j=1:length(handles.onfilek)
        if(mod(j,handles.altperiod)==mod(firstk+1,handles.altperiod))
            set(handles.hcheckbox(j),'Value',1)
        else
            set(handles.hcheckbox(j),'Value',0)
        end
    end
else
    if(firstk==0)firstk=2;end
    if(handles.finfo(handles.onfilek(firstk)).fname(end)~='b')
        for i=1:length(handles.onfilek)
            if('b'==handles.finfo(handles.onfilek(i)).fname(end))
                set(handles.hcheckbox(i),'Value',1);
            else
                set(handles.hcheckbox(i),'Value',0);
            end
        end
    else
        for i=1:length(handles.onfilek)
            if('b'==handles.finfo(handles.onfilek(i)).fname(end))
                set(handles.hcheckbox(i),'Value',0);
            else
                set(handles.hcheckbox(i),'Value',1);
            end
        end
    end
end

% --- Executes on button press in checkbox_paironly.
function checkbox_paironly_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_paironly (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_paironly




% --- Executes on button press in checkbox_spikedensity.
function checkbox_spikedensity_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_spikedensity (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_spikedensity




% --- Executes on button press in checkbox_samecolor4pairs.
function checkbox_samecolor4pairs_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_samecolor4pairs (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_samecolor4pairs




% --- Executes on button press in checkbox_plotonlymean.
function checkbox_plotonlymean_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_plotonlymean (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_plotonlymean




% --- Executes on button press in radiobutton_ISIratio.
function radiobutton_ISIratio_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_ISIratio (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_ISIratio
hide_optioncontrols(handles);

set(handles.checkbox_paironly, 'Visible','on');
set(handles.checkbox_plotonlymean,'Visible','on');




% --- Executes on button press in checkbox_ensembleaverage.
function checkbox_ensembleaverage_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_ensembleaverage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_ensembleaverage





function edit_Rcorr_sigma_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Rcorr_sigma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Rcorr_sigma as text
%        str2double(get(hObject,'String')) returns contents of edit_Rcorr_sigma as a double


% --- Executes during object creation, after setting all properties.
function edit_Rcorr_sigma_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Rcorr_sigma (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in radiobutton_isij.
function radiobutton_isij_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_isij (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_isij
hide_optioncontrols(handles);

set(handles.checkbox_paironly, 'Visible','on');
set(handles.checkbox_plotonlymean,'Visible','on');



function yi=interp1_anmo2(x,Y,xi,option)
%if interpolation point is out of the range, use the closest value
[x ix]=sort(x);
Y=Y(ix);


%discard duplicate samples
while(1)
    z=[(diff(x)==0) 0];
    if(sum(z)==0)
        break;
    end
    x=x(~z);Y=Y(~z);
end

if(length(x)<2)
    yi=zeros(size(xi));
    return;
end
if(nargin==4)
    yi=interp1(x,Y,xi,option);
else
    yi=interp1(x,Y,xi);
end

ix=find(isnan(yi));
for i=1:length(ix)
    %use the nearest neighbor
    if(xi(ix)<min(x))%if isNaN because sample point is too low
        yi(ix)=Y(1);
    else
        yi(ix)=Y(end);
    end
end




function edit_timecap0_Callback(hObject, eventdata, handles)
% hObject    handle to edit_timecap0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_timecap0 as text
%        str2double(get(hObject,'String')) returns contents of edit_timecap0 as a double


% --- Executes during object creation, after setting all properties.
function edit_timecap0_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_timecap0 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function edit_timecapend_Callback(hObject, eventdata, handles)
% hObject    handle to edit_timecapend (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_timecapend as text
%        str2double(get(hObject,'String')) returns contents of edit_timecapend as a double


% --- Executes during object creation, after setting all properties.
function edit_timecapend_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_timecapend (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function edit_bingap_Callback(hObject, eventdata, handles)
% hObject    handle to edit_bingap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_bingap as text
%        str2double(get(hObject,'String')) returns contents of edit_bingap as a double


% --- Executes during object creation, after setting all properties.
function edit_bingap_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_bingap (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in radiobutton_combo1.
function radiobutton_combo1_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_combo1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_combo1




% --- Executes on button press in radiobutton_isij3.
function radiobutton_isij3_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_isij3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_isij3

hide_optioncontrols(handles);

set(handles.checkbox_paironly, 'Visible','on');
set(handles.checkbox_plotonlymean,'Visible','on');


% --- Executes on button press in pushbutton_setaltN.
function pushbutton_setaltN_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_setaltN (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(isfield(handles,'altperiod'))
    answer = inputdlg({'alternating period'},'period',1,{num2str(handles.altperiod)});
else
    answer = inputdlg({'period'},'alternating period',1,{'2'});
end
if(isempty(answer))
    return;
end

num=str2num(answer{1});
if(isempty(num))
    return;
end

if(num<1)
    return;
end

handles.altperiod=num;
guidata(hObject,handles);


% --- Executes on button press in radiobutton_combo3.
function radiobutton_combo3_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_combo3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_combo3


% --- Executes on button press in radiobutton_combo2.
function radiobutton_combo2_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_combo2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_combo2




% --- Executes on button press in checkbox_separatepsth.
function checkbox_separatepsth_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_separatepsth (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_separatepsth














function edit_stasize_Callback(hObject, eventdata, handles)
% hObject    handle to edit_stasize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_stasize as text
%        str2double(get(hObject,'String')) returns contents of edit_stasize as a double


% --- Executes during object creation, after setting all properties.
function edit_stasize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_stasize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in radiobutton_sta.
function radiobutton_sta_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_sta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_sta
hide_optioncontrols(handles);
set(handles.text_stasize,'Visible','on');
set(handles.edit_stasize,'Visible','on');



% --- Executes on button press in radiobutton_stc.
function radiobutton_stc_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_stc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_stc
hide_optioncontrols(handles);
set(handles.text_stasize,'Visible','on');
set(handles.edit_stasize,'Visible','on');

function radiobutton_2DManifold_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_stc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_stc
hide_optioncontrols(handles);
set(handles.text_manifold1, 'Visible','on');
set(handles.text_manifold2, 'Visible','on');
set(handles.text_manifold3, 'Visible','on');
set(handles.text_manifold4, 'Visible','on');
set(handles.text_manifold5, 'Visible','on');
set(handles.edit_manifold_delta,'Visible','on');
set(handles.edit_manifold_nISI,'Visible','on');
set(handles.edit_manifold_ngrid,'Visible','on');
set(handles.edit_regularity_tolerance,'Visible','on');
set(handles.checkbox_manifold_verbose,'Visible','on');
set(handles.checkbox_manifold_gridfit,'Visible','on');
set(handles.edit_manifold_fc,'Visible','on');



% --- Executes on button press in pushbutton_incnfig.
function pushbutton_incnfig_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_incnfig (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

nfig=str2num(get(handles.edit_nfig,'String'));
if(isempty(nfig))
    nfig=0;
else
    nfig=nfig+1;
end

set(handles.edit_nfig,'String',num2str(round(nfig)));
handles.nfig=round(nfig);

set(handles.checkbox_addaxes,'Value',0)
guidata(hObject,handles);


% --- Executes when selected object is changed in uipanel_plottype.
function uipanel_plottype_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uipanel_plottype
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)


plottypestr=get(hObject,'String');
hide_optioncontrols(handles);
switch(plottypestr)
    case 'STC'
        set(handles.text_stasize,'Visible','on');
        set(handles.edit_stasize,'Visible','on');
    case 'STA'
        set(handles.text_stasize,'Visible','on');
        set(handles.edit_stasize,'Visible','on');
    case '2DManifold'
        set(handles.text_manifold1, 'Visible','on');
        set(handles.text_manifold2, 'Visible','on');
        set(handles.text_manifold3, 'Visible','on');
        set(handles.text_manifold4, 'Visible','on');
        set(handles.edit_manifold_delta,'Visible','on');
        set(handles.edit_manifold_nISI,'Visible','on');
        set(handles.edit_manifold_ngrid,'Visible','on');
        set(handles.edit_regularity_tolerance,'Visible','on');
        set(handles.checkbox_manifold_verbose,'Visible','on');
        set(handles.checkbox_manifold_gridfit,'Visible','on');
        set(handles.edit_manifold_fc,'Visible','on');
    case 'PNManifold'
        set(handles.text_manifold1, 'Visible','on');
        set(handles.text_manifold2, 'Visible','on');
        set(handles.text_manifold3, 'Visible','on');
        set(handles.text_manifold4, 'Visible','on');
        set(handles.edit_manifold_delta,'Visible','on');
        set(handles.edit_manifold_nISI,'Visible','on');
        set(handles.edit_manifold_ngrid,'Visible','on');
        set(handles.edit_regularity_tolerance,'Visible','on');
        set(handles.checkbox_manifold_verbose,'Visible','on');
        set(handles.checkbox_manifold_gridfit,'Visible','on');
        set(handles.edit_manifold_fc,'Visible','on');
        set(handles.edit_PNManifold_OSNPSTH,'Visible','on');
        
end



function edit_manifold_delta_Callback(hObject, eventdata, handles)
% hObject    handle to edit_manifold_delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_manifold_delta as text
%        str2double(get(hObject,'String')) returns contents of edit_manifold_delta as a double


% --- Executes during object creation, after setting all properties.
function edit_manifold_delta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_manifold_delta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_manifold_nISI_Callback(hObject, eventdata, handles)
% hObject    handle to edit_manifold_nISI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_manifold_nISI as text
%        str2double(get(hObject,'String')) returns contents of edit_manifold_nISI as a double


% --- Executes during object creation, after setting all properties.
function edit_manifold_nISI_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_manifold_nISI (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_regularity_tolerance_Callback(hObject, eventdata, handles)
% hObject    handle to edit_regularity_tolerance (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_regularity_tolerance as text
%        str2double(get(hObject,'String')) returns contents of edit_regularity_tolerance as a double


% --- Executes during object creation, after setting all properties.
function edit_regularity_tolerance_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_regularity_tolerance (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_manifold_fc_Callback(hObject, eventdata, handles)
% hObject    handle to edit_manifold_fc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_manifold_fc as text
%        str2double(get(hObject,'String')) returns contents of edit_manifold_fc as a double


% --- Executes during object creation, after setting all properties.
function edit_manifold_fc_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_manifold_fc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




function h=plot2dmanifold(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end
if(isempty(validk))
    h.output='no spikes found';
    return;
end
% validk=fliplr(validk); %to plot data from top to bottom

ndata=length(validk);


%load parameters
delay=0;%in ms
delta=str2num(get(h.edit_manifold_delta,'String'));
if(isempty(delta))
    delta=h.manifold_delta;
else
    h.manifold_delta=delta;
end

fc=str2num(get(h.edit_manifold_fc,'String'));
if(isempty(fc))
    fc=h.manifold_fc;
else
    h.manifold_fc=fc;
end

nISI=str2num(get(h.edit_manifold_nISI,'String'));
if(isempty(nISI))
    nISI=h.manifold_nISI;
else
    h.manifold_nISI=nISI;
end
ngrid=str2num(get(h.edit_manifold_ngrid,'String'));
if(isempty(ngrid))
    ngrid=h.manifold_ngrid;
else
    h.manifold_ngrid=ngrid;
end
regularity_tolerance=str2num(get(h.edit_regularity_tolerance,'String'));
if(isempty(regularity_tolerance))
    regularity_tolerance=h.manifold_regularity_tolerance;
else
    h.manifold_regularity_tolerance=regularity_tolerance;
end
bGridfit=get(h.checkbox_manifold_gridfit,'Value');


verbose=get(h.checkbox_manifold_verbose,'Value');
if(verbose)
    baddaxes=get(h.checkbox_addaxes,'Value');
    set(h.checkbox_addaxes,'Value',0);
    [newfig haxes0]=getnewaxes(h);view(-100,40);grid on; hold(haxes0,'on');
    set(haxes0,'YDir','reverse');
    xlabel('Concentraiton');ylabel('Rate-of-change');zlabel('Spike frequency');
    
    set(h.checkbox_addaxes,'Value',baddaxes);
    cm0=colormap(hsv(ndata));
end

fname1=cell(ndata,1);
for k=1:ndata
    %extracting spike sequence
    spkt0=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
    spkt=spkt0(spkt0>=h.timecap0*1000 & spkt0<=h.timecapend*1000);
    
    
    %loading odor concentration
    %     if(~isempty(strfind(lower(axesinfo(validk(k)).stimtype),'acetone')))
    %         pidfactor=0.997;
    %     elseif(~isempty(strfind(lower(axesinfo(validk(k)).stimtype),'ethyl acetate')))
    %         pidfactor=3.654;
    %     else
    %         pidfactor=1;
    %     end
    if(strfind(lower(axesinfo(validk(k)).stimtype),'hexane'))
        pidfactor=4.7;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'acetone'))
        pidfactor=0.997;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethanol'))
        pidfactor=8.8;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'ethyl acetate'))
        pidfactor=3.654;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'co2'))
        pidfactor=0.5;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'methyl butyrate'))
        pidfactor=3.49897/2;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butanal'))
        pidfactor=9.47/2;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'butyraldehyde'))
        pidfactor=9.47/2;
    elseif(strfind(lower(axesinfo(validk(k)).stimtype),'3% propylene'))
        pidfactor=5.744/2;
    else
        pidfactor=1;
    end
    
    if(isfield(axesinfo(validk(k)),'ppmfactor'))
        ppmfactor=axesinfo(validk(k)).ppmfactor;
    else
        ppmfactor=1;pidfactor=1;
    end
    
    
    c=axesinfo(validk(k)).c*ppmfactor*pidfactor;
    dt=axesinfo(validk(k)).dt;
    t=((1:length(c))-1)*dt+axesinfo(validk(k)).t0;
    t1=t(t>=h.timecap0*1000 & t<=h.timecapend*1000);
    c=c-mean(c(t>=4000 & t<5000));
    
    delayk=round(delay/dt);
    c=c([ones(1,delayk) 1:(end-delayk)]);%add delay
    
    %filtering the odor concentration waveform - (t1, c1)
    oversampleR=round(1000/(dt/2)/fc);
    b = fircls1(min(400,oversampleR*20),1/oversampleR,0.02,0.008);
    tempc=filter(b, 1, c);
    tempk=round(mean(grpdelay(b,1)));
    if(tempk>0)
        c1=interp1(t,tempc([(tempk+1):end end*ones(1,tempk)]), t1);
    elseif(tempk<0)
        c1=interp1(t,tempc([ones(1,-tempk) 1:(end+tempk)]), t1);
    end
    
    
    dcdt=(c1-[ c1(1)*ones(1,round(delta/dt)) c1(1:(end-round(delta/dt)))])/delta*1000;
    
    
    spkk=round((spkt-t1(1))./dt);
    ISIk=[diff(spkk(:))'];
    ISIt=ISIk*dt;
    
    %c2{k} : mean odor concentration for each ISI
    cumc1=cumsum(c1);
    c2{k}=(cumc1(spkk(2:end))-cumc1(spkk(1:(end-1))))./ISIk;
    
    %dcdt2{k} : mean dc/dt for each ISI
    cumdcdt1=cumsum(dcdt);
    dcdt2{k}=(cumdcdt1(spkk(2:end))-cumdcdt1(spkk(1:(end-1))))./ISIk;
    
    %lambda{k} : local spike rate for each ISI
    ISI2=ISIt;
    for i=2:nISI
        if(mod(i,2)==0)
            ISI2=[ISI2; [ISIt((i/2+1):end) inf(1,i/2)]];
        else
            ISI2=[[inf(1,floor(i/2)) ISIt(1:(end-floor(i/2)))]; ISI2;];
        end
    end
    
    
    mean0=mean(ISI2,1);
    lambda{k}=1000./mean0;
    
    if(nISI>1)
        cv0=std(ISI2,1)./mean0.^1.25;
        bRegular=(cv0<regularity_tolerance);
        incISI=diff(ISI2,1);%increase of ISI
        incISI(incISI>0)=1; incISI(incISI<0)=-1;
        bInc=(floor(abs(sum(incISI,1))/size(incISI,1)));
        bInc(isnan(bInc))=0;
        bInc=logical(bInc);  %logical array for fully asending or fully descending ISI sequences
        if(nISI>2)
            mean0(bInc)=ISIt(bInc); %do not average with neighbor if it is fully ascending or descending
        end
        lambda{k}(~(bInc|bRegular))=inf;
    end
    
    
    %remove noisy samples
    c2{k}=c2{k}(~isinf(lambda{k}));
    dcdt2{k}=dcdt2{k}(~isinf(lambda{k}));
    lambda{k}=lambda{k}(~isinf(lambda{k}));
    
    if(verbose)
        plot3(haxes0, c2{k},dcdt2{k},lambda{k},'Marker','.','Color',cm0(k,:),'LineStyle','none');
    end
    
    fname1{k}=[axesinfo(validk(k)).fname];
    set(h.text_msg,'String',['2D Manifold: scanning ' fname1{k} '.mat   ...']);
    drawnow;
end

if(~verbose)
    baddaxes=get(h.checkbox_addaxes,'Value');
    set(h.checkbox_addaxes,'Value',0);
    [newfig haxes0]=getnewaxes(h);view(-100,40);grid on; hold(haxes0,'on');
    set(haxes0,'YDir','reverse');
    xlabel('Concentraiton');ylabel('Rate-of-change');zlabel('Spike frequency');
    
    set(h.checkbox_addaxes,'Value',baddaxes);
    cm0=colormap(hsv(ndata));
    for k=1:ndata
        plot3(haxes0, c2{k},dcdt2{k},lambda{k},'Marker','.','Color',cm0(k,:),'LineStyle','none');
    end
end


underscorek=strfind(axesinfo(validk(end)).fname,'_');
if(isempty(underscorek)) underscorek=1; end
savefname=[axesinfo(validk(1)).fname '_'  axesinfo(validk(end)).fname(underscorek(end):end) '_2dmanifold_nISI' num2str(nISI) '.mat'];

if(bGridfit)
    x=cell2mat(c2(:)');y=cell2mat(dcdt2(:)');z=cell2mat(lambda(:)');
    xnodes=linspace(min(x),max(x),ngrid);ynodes=linspace(min(y),max(y),ngrid);
    [zgrid,xgrid,ygrid,zgrid2] = gridfit2(x,y,z,xnodes,ynodes);
    zgrid(zgrid<0)=0;zgrid2(zgrid2<0)=0;
    baddaxes=get(h.checkbox_addaxes,'Value');
    set(h.checkbox_addaxes,'Value',0);
    
    h.nfig=h.nfig+1;
    [newfig haxes1]=getnewaxes(h);view(-100,40);grid on; hold(haxes1,'on');
    set(haxes1,'YDir','reverse');colormap(jet);
    surf(xgrid,ygrid,zgrid2,'EdgeColor','interp');
    xlabel('Concentraiton');ylabel('Rate-of-change');zlabel('Spike frequency');
    set(h.checkbox_addaxes,'Value',baddaxes);
    %     plot(haxes1,0:(stasize-1),fliplr(sta),'LineWidth',2);
    % axes(haxes1); xlabel('Time (ms)'); ylabel('Spike-Triggered Average');grid on;
    % title([axesinfo(validk(1)).fname ' ... '  axesinfo(validk(end)).fname(underscorek(end):end)],'Interpreter','none');
end
set(h.text_msg,'String',['saving ' savefname  ' ...']);
drawnow;
tstart=h.timecap0;
tend=h.timecapend;

save([h.h0.docfolder savefname], 'c2', 'dcdt2', 'lambda', 'fname1','tstart','tend','xgrid','ygrid','zgrid2','zgrid', 'ngrid','fc','delta','delay','nISI','regularity_tolerance');

assignin('base','c2',c2);
assignin('base', 'dcdt2', dcdt2);
assignin('base', 'lambda', lambda);

h.output=['2D Manifold samples are saved to doc/' savefname];









% --- Executes on button press in checkbox_manifold_verbose.
function checkbox_manifold_verbose_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_manifold_verbose (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_manifold_verbose


% --- Executes on button press in checkbox_manifold_gridfit.
function checkbox_manifold_gridfit_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox_manifold_gridfit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox_manifold_gridfit
if(~get(hObject,'Value'))
    set(handles.edit_manifold_ngrid,'Enable','off');
else
    set(handles.edit_manifold_ngrid,'Enable','on');
end


function edit_manifold_ngrid_Callback(hObject, eventdata, handles)
% hObject    handle to edit_manifold_ngrid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_manifold_ngrid as text
%        str2double(get(hObject,'String')) returns contents of edit_manifold_ngrid as a double


% --- Executes during object creation, after setting all properties.
function edit_manifold_ngrid_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_manifold_ngrid (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

%
% % --- If Enable == 'on', executes on mouse press in 5 pixel border.
% % --- Otherwise, executes on mouse press in 5 pixel border or over text_manifold5.
% function text_manifold5_ButtonDownFcn(hObject, eventdata, handles)
% % hObject    handle to text_manifold5 (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)




% --- Executes on button press in radiobutton_PNManifold.
function radiobutton_PNManifold_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton_PNManifold (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton_PNManifold
hide_optioncontrols(handles);
set(handles.text_manifold1, 'Visible','on');
set(handles.text_manifold2, 'Visible','on');
set(handles.text_manifold3, 'Visible','on');
set(handles.text_manifold4, 'Visible','on');
set(handles.text_manifold5, 'Visible','on');
set(handles.edit_manifold_delta,'Visible','on');
set(handles.edit_manifold_nISI,'Visible','on');
set(handles.edit_manifold_ngrid,'Visible','on');
set(handles.edit_regularity_tolerance,'Visible','on');
set(handles.checkbox_manifold_verbose,'Visible','on');
set(handles.checkbox_manifold_gridfit,'Visible','on');
set(handles.edit_manifold_fc,'Visible','on');
set(handles.edit_PNManifold_OSNPSTH,'Visible','on');






function h=plotPNmanifold(h)
pickedk=h.filepicks;
%if(isempty(validk)) return; end

axesinfo=h.finfo;

validk=[];
for k=1:length(pickedk)
    if(~isempty(axesinfo(pickedk(k)).spkk))
        validk=[validk pickedk(k)];
    end
end
if(isempty(validk))
    h.output='no spikes found';
    return;
end
% validk=fliplr(validk); %to plot data from top to bottom

ndata=length(validk);


%load parameters
delay=50;%in ms !!!!!!Some delay is added due to 
delta=str2num(get(h.edit_manifold_delta,'String'));
if(isempty(delta))
    delta=h.manifold_delta;
else
    h.manifold_delta=delta;
end

fc=str2num(get(h.edit_manifold_fc,'String'));
if(isempty(fc))
    fc=h.manifold_fc;
else
    h.manifold_fc=fc;
end

nISI=str2num(get(h.edit_manifold_nISI,'String'));
if(isempty(nISI))
    nISI=h.manifold_nISI;
else
    h.manifold_nISI=nISI;
end
ngrid=str2num(get(h.edit_manifold_ngrid,'String'));
if(isempty(ngrid))
    ngrid=h.manifold_ngrid;
else
    h.manifold_ngrid=ngrid;
end
regularity_tolerance=str2num(get(h.edit_regularity_tolerance,'String'));
if(isempty(regularity_tolerance))
    regularity_tolerance=h.manifold_regularity_tolerance;
else
    h.manifold_regularity_tolerance=regularity_tolerance;
end
bGridfit=get(h.checkbox_manifold_gridfit,'Value');


verbose=get(h.checkbox_manifold_verbose,'Value');
if(verbose)
    baddaxes=get(h.checkbox_addaxes,'Value');
    set(h.checkbox_addaxes,'Value',0);
    [newfig haxes0]=getnewaxes(h);view(-100,40);grid on; hold(haxes0,'on');
    set(haxes0,'YDir','reverse');
    xlabel('Concentraiton');ylabel('Rate-of-change');zlabel('Spike frequency');
    
    set(h.checkbox_addaxes,'Value',baddaxes);
    cm0=colormap(hsv(ndata));
end







load(h.PNManifold_OSNPSTH,'odort','odory','pstht','psthy');
for i=1:length(odort)
    odort{i}=odort{i}*1000;
end
dt=1;
% t1=round(max(h.timecap0*1000,pstht{1}(1))):dt:round(min(h.timecapend*1000,pstht{1}(end)));
t1=round(h.timecap0*1000):dt:round(h.timecapend*1000);
[junk c1]=interp1tcy(odort,odory,pstht,psthy,t1, 0, 78,fc); %take spike rate as input concentration
delayk=round(delay/dt);
c1=c1(:,[ones(1,delayk) 1:(end-delayk)]);%add delay
    


dcdt=(c1-[ repmat(c1(:,1),1,round(delta/dt)) c1(:,1:(end-round(delta/dt)))])./delta*1000;
nOSN=length(odort);%number of OSN c/PSTH pairs


fname1=cell(ndata,1);
for k=1:ndata
    %extracting spike sequence
    spkt0=axesinfo(validk(k)).spkk*axesinfo(validk(k)).dt;
    spkt=spkt0(spkt0>=h.timecap0*1000 & spkt0<=h.timecapend*1000);
    
    
    
    spkk=round((spkt-t1(1))./dt);
    ISIk=[diff(spkk(:))'];
    ISIt=diff((spkt-t1(1)));
    
    %c2{k} : mean odor concentration for each ISI
    cumc1=cumsum(c1(mod(validk(k)-1,nOSN)+1,:));
    c2{k}=(cumc1(spkk(2:end))-cumc1(spkk(1:(end-1))))./ISIk;
    
    %dcdt2{k} : mean dc/dt for each ISI
    cumdcdt1=cumsum(dcdt(mod(validk(k)-1,nOSN)+1,:));
    dcdt2{k}=(cumdcdt1(spkk(2:end))-cumdcdt1(spkk(1:(end-1))))./ISIk;
    
    %lambda{k} : local spike rate for each ISI
    ISI2=ISIt;
    for i=2:nISI
        if(mod(i,2)==0)
            ISI2=[ISI2; [ISIt((i/2+1):end) inf(1,i/2)]];
        else
            ISI2=[[inf(1,floor(i/2)) ISIt(1:(end-floor(i/2)))]; ISI2;];
        end
    end
    
    
    mean0=mean(ISI2,1);
    lambda{k}=1000./mean0;
    
    if(nISI>1)
        cv0=std(ISI2,1)./mean0.^1.25;
        bRegular=(cv0<regularity_tolerance);
        incISI=diff(ISI2,1);%increase of ISI
        incISI(incISI>0)=1; incISI(incISI<0)=-1;
        bInc=(floor(abs(sum(incISI,1))/size(incISI,1)));
        bInc(isnan(bInc))=0;
        bInc=logical(bInc);  %logical array for fully asending or fully descending ISI sequences
        if(nISI>2)
            mean0(bInc)=ISIt(bInc); %do not average with neighbor if it is fully ascending or descending
        end
        lambda{k}(~(bInc|bRegular))=inf;
    end
    
    
    %remove noisy samples
    c2{k}=c2{k}(~isinf(lambda{k}));
    dcdt2{k}=dcdt2{k}(~isinf(lambda{k}));
    lambda{k}=lambda{k}(~isinf(lambda{k}));
    
    if(verbose)
        plot3(haxes0, c2{k},dcdt2{k},lambda{k},'Marker','.','Color',cm0(k,:),'LineStyle','none');
    end
    
    fname1{k}=[axesinfo(validk(k)).fname];
    set(h.text_msg,'String',['2D Manifold: scanning ' fname1{k} '.mat   ...']);
    drawnow;
end

if(~verbose)
    baddaxes=get(h.checkbox_addaxes,'Value');
    set(h.checkbox_addaxes,'Value',0);
    [newfig haxes0]=getnewaxes(h);view(-100,40);grid on; hold(haxes0,'on');
    set(haxes0,'YDir','reverse');
    xlabel('Concentraiton');ylabel('Rate-of-change');zlabel('Spike frequency');
    
    set(h.checkbox_addaxes,'Value',baddaxes);
    cm0=colormap(hsv(ndata));
    for k=1:ndata
        plot3(haxes0, c2{k},dcdt2{k},lambda{k},'Marker','.','Color',cm0(k,:),'LineStyle','none');
    end
end


underscorek=strfind(axesinfo(validk(end)).fname,'_');
if(isempty(underscorek)) underscorek=1; end
savefname=[axesinfo(validk(1)).fname '_'  axesinfo(validk(end)).fname(underscorek(end):end) '_PNmanifold_nISI' num2str(nISI) '.mat'];

if(bGridfit)
    x=cell2mat(c2(:)');y=cell2mat(dcdt2(:)');z=cell2mat(lambda(:)');
    xnodes=linspace(min(x),max(x),ngrid);ynodes=linspace(min(y),max(y),ngrid);
    [zgrid,xgrid,ygrid,zgrid2] = gridfit2(x,y,z,xnodes,ynodes);
    zgrid(zgrid<0)=0;zgrid2(zgrid2<0)=0;
    baddaxes=get(h.checkbox_addaxes,'Value');
    set(h.checkbox_addaxes,'Value',0);
    
    h.nfig=h.nfig+1;
    [newfig haxes1]=getnewaxes(h);view(-100,40);grid on; hold(haxes1,'on');
    set(haxes1,'YDir','reverse');colormap(jet);
    surf(xgrid,ygrid,zgrid2,'EdgeColor','interp');
    xlabel('Concentraiton');ylabel('Rate-of-change');zlabel('Spike frequency');
    set(h.checkbox_addaxes,'Value',baddaxes);
    %     plot(haxes1,0:(stasize-1),fliplr(sta),'LineWidth',2);
    % axes(haxes1); xlabel('Time (ms)'); ylabel('Spike-Triggered Average');grid on;
    % title([axesinfo(validk(1)).fname ' ... '  axesinfo(validk(end)).fname(underscorek(end):end)],'Interpreter','none');
end
set(h.text_msg,'String',['saving ' savefname  ' ...']);
drawnow;
tstart=h.timecap0;
tend=h.timecapend;

save([h.h0.docfolder savefname], 'c2', 'dcdt2', 'lambda', 'fname1','tstart','tend','xgrid','ygrid','zgrid2','zgrid', 'ngrid','fc','delta','nISI','regularity_tolerance');

assignin('base','c2',c2);
assignin('base', 'dcdt2', dcdt2);
assignin('base', 'lambda', lambda);

h.output=['2D Manifold samples are saved to doc/' savefname];







function edit_PNManifold_OSNPSTH_Callback(hObject, eventdata, handles)
% hObject    handle to edit_PNManifold_OSNPSTH (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_PNManifold_OSNPSTH as text
%        str2double(get(hObject,'String')) returns contents of edit_PNManifold_OSNPSTH as a double


% --- Executes during object creation, after setting all properties.
function edit_PNManifold_OSNPSTH_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_PNManifold_OSNPSTH (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over edit_PNManifold_OSNPSTH.
function edit_PNManifold_OSNPSTH_ButtonDownFcn(hObject, eventdata, handles)
% hObject    handle to edit_PNManifold_OSNPSTH (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%load the OSN data file

[fname pname] = uigetfile('*.mat','Pick OSN PSTH file to be used as input',handles.PNManifold_OSNPSTH);
if(fname==0)
    return;
end
handles.PNManifold_OSNPSTH=[pname fname];
set(handles.edit_PNManifold_OSNPSTH,'String',fname,'TooltipString',handles.PNManifold_OSNPSTH);
guidata(hObject,handles);
