function varargout = spikesort(varargin)
% SPIKESORT M-file for spikesort.fig
%      SPIKESORT, by itself, creates a new SPIKESORT or raises the existing
%      singleton*.
%
%      H = SPIKESORT returns the handle to a new SPIKESORT or the handle to
%      the existing singleton*.
%
%      SPIKESORT('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in SPIKESORT.M with the given input arguments.
%
%      SPIKESORT('Property','Value',...) creates a new SPIKESORT or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before spikesort_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to spikesort_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help spikesort

% Last Modified by GUIDE v2.5 07-Dec-2009 08:21:53

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @spikesort_OpeningFcn, ...
                   'gui_OutputFcn',  @spikesort_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if(nargin<2) disp('spikesort requires at least two input arguments');return; end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before spikesort is made visible.
function spikesort_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to spikesort (see VARARGIN)

% Choose default command line output for spikesort
handles.output = {};


FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
if isempty(gcbf)
   ScreenUnits=get(0,'Units');
   set(0,'Units','pixels');
   ScreenSize=get(0,'ScreenSize');
   set(0,'Units',ScreenUnits);

   FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
   FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
else
   GCBFOldUnits = get(gcbf,'Units');
   set(gcbf,'Units','pixels');
   GCBFPos = get(gcbf,'Position');
   set(gcbf,'Units',GCBFOldUnits);
   FigPos(1:2) = [(GCBFPos(1) + GCBFPos(3) / 2) - FigWidth / 2, ...
      (GCBFPos(2) + GCBFPos(4) / 2) - FigHeight / 2];
end
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Make the GUI modal
set(handles.figure1,'WindowStyle','modal')


%Anmo's code from this point
if(length(varargin)<2) return; end

handles.nparams=min(length(varargin{1}),length(varargin{2}));

for i=1:handles.nparams
    eval(['set(handles.text_param' num2str(i) ',''String'',varargin{1}{' num2str(i) '});']);
    eval(['set(handles.edit_param' num2str(i) ',''String'',varargin{2}{' num2str(i) '});']);
    if(strfind(varargin{1}{i},'type'))
        %keepting the spike type number as a global variable
        handles.nspiketypes=str2num(varargin{2}{i});
    end
end




if(i<4)
    %if it is the initial sort, i must be 4
    %this runs only at the subsequent sorting runs
    for j=(i+1):4
        eval(['set(handles.text_param' num2str(j) ',''Visible'',''off'');']);
        eval(['set(handles.edit_param' num2str(j) ',''Visible'',''off'');']);
    end
    
    %enable 'retry' button
    set(handles.pushbutton_retry,'Visible','on');
    
    %disable left/right window adjustment
    set(handles.edit_leftwindowsize,'Enable','off');
    set(handles.edit_rightwindowsize,'Enable','off');
end


if(nargin>2)
    handles.figure0=varargin{3};
else
    handles.figure0=-1;
end


if(handles.figure0>=0)
    if(exist('SpikeFeatureDiagram.mat','file'))
        load('SpikeFeatureDiagram.mat');
        axes(handles.axes1);
        handles.diagram1=image(SpikeFeatureDiagram);
        axis off;
        set(handles.diagram1,'Visible','on');
        
        
        
        axes(handles.axes2);
        handles.diagram2=image(SpikeFeatureDiagram2);
        set(handles.diagram2,'Visible','off');
        axis off;
        
    end
    
    h0=guidata(handles.figure0);
    handles.sorteq=h0.sorteq;
    handles.sortbasisk=h0.sortbasisk;
    handles.sortleftwin=h0.sortleftwin;
    handles.sortrightwin=h0.sortrightwin;
    
    for i=1:10
        eval(['set(handles.slider' num2str(i) ',''Value'',handles.sorteq(' num2str(i) '));']);
        eval(['set(handles.text' num2str(49+i) ',''String'',num2str(round(handles.sorteq(' num2str(i) ')*100)/100));']);
    end
    
    
    set(handles.edit_orderingfeature,'String',num2str(handles.sortbasisk));
    set(handles.edit_leftwindowsize,'String',num2str(handles.sortleftwin));
    set(handles.edit_rightwindowsize,'String',num2str(handles.sortrightwin));
    
    featurestr={'#1.peak amplitude','#2.peak - min(bef.)','#3.peak - min(aft.)',...
        '#4.timing(min(bef.))','#5.timing(min(aft.))','#6.min(before)-min(after)',...
        '#7.max(1Q)-min(2Q)','#8.max(3Q)-min(4Q)','#9.peak-mean(all)',...
        '#10.var(all)'};
    for i=1:10
        eval(['set(handles.text' num2str(i+4) ',''String'',featurestr{i});']);
    end


else
    set(handles.pushbutton_setequalizer,'Enable','off');
    
end


% Update handles structure
guidata(hObject, handles);

% UIWAIT makes spikesort wait for user response (see UIRESUME)
uiwait(handles.figure1);




% --- Outputs from this function are returned to the command line.
function varargout = spikesort_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
if(isfield(handles,'output'))
    varargout{1} = handles.output;
    delete(handles.figure1);
else
    varargout{1}={[]};
end

% if(isfield(handles,'filepicks'))
%    varargout{1} = handles.filepicks;
%    varargout{2}= {};
% %    if(get(handles.checkbox_interpolate,'Value'))
% %        varargout{2}='interpolate';
% %    end
%    
%    delete(handles.figure1);
% else
%    varargout{1} = [];
%    varargout{2} = [];
% %   delete(handles.figure1);
% end





% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text50,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function slider2_Callback(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text51,'String',num2str(round(get(hObject,'Value')*100)/100));



% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function slider3_Callback(hObject, eventdata, handles)
% hObject    handle to slider3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text52,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes during object creation, after setting all properties.
function slider3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function slider4_Callback(hObject, eventdata, handles)
% hObject    handle to slider4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text53,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes during object creation, after setting all properties.
function slider4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes during object creation, after setting all properties.
function slider5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end




% --- Executes on slider movement.
function slider5_Callback(hObject, eventdata, handles)
% hObject    handle to slider5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text54,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes on slider movement.
function slider6_Callback(hObject, eventdata, handles)
% hObject    handle to slider6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text55,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes during object creation, after setting all properties.
function slider6_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider6 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function slider7_Callback(hObject, eventdata, handles)
% hObject    handle to slider3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text56,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes during object creation, after setting all properties.
function slider7_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end




% --- Executes on slider movement.
function slider8_Callback(hObject, eventdata, handles) %#ok<DEFNU>
% hObject    handle to slider8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text57,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes during object creation, after setting all properties.
function slider8_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



% --- Executes on slider movement.
function slider9_Callback(hObject, eventdata, handles)
% hObject    handle to slider7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text58,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes during object creation, after setting all properties.
function slider9_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider7 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes during object creation, after setting all properties.
function slider10_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function slider10_Callback(hObject, eventdata, handles)
% hObject    handle to slider10 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
set(handles.text59,'String',num2str(round(get(hObject,'Value')*100)/100));


% --- Executes on button press in pushbutton_apply.
function pushbutton_apply_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_apply (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

for i=1:10
    eval(['handles.sorteq(i)=get(handles.slider' num2str(i) ',''Value'');']);
end
temp=round(str2double(get(handles.edit_orderingfeature,'String')));
if(temp>0 && temp<=10)
    handles.sortbasisk=temp;
end
temp=str2double(get(handles.edit_leftwindowsize,'String'));
if(temp>0)
    handles.sortleftwin=temp;
end
temp=str2double(get(handles.edit_rightwindowsize,'String'));
if(temp>0)
    handles.sortrightwin=temp;
end
guidata(hObject,handles);

%update the data for parent figure
h0=guidata(handles.figure0);
h0.sorteq=handles.sorteq;
h0.sortbasisk=handles.sortbasisk;
h0.sortleftwin=handles.sortleftwin;
h0.sortrightwin=handles.sortrightwin;
guidata(handles.figure0,h0);

set(handles.uipanel2,'Visible','off');
set(handles.uipanel1,'Visible','on');
pos=get(handles.figure1,'Position');
pos(4)=15;
set(handles.figure1,'Position',pos);


function edit_leftwindowsize_Callback(hObject, eventdata, handles)
% hObject    handle to edit_leftwindowsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_leftwindowsize as text
%        str2double(get(hObject,'String')) returns contents of edit_leftwindowsize as a double


% --- Executes during object creation, after setting all properties.
function edit_leftwindowsize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_leftwindowsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_rightwindowsize_Callback(hObject, eventdata, handles)
% hObject    handle to edit_rightwindowsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_rightwindowsize as text
%        str2double(get(hObject,'String')) returns contents of edit_rightwindowsize as a double


% --- Executes during object creation, after setting all properties.
function edit_rightwindowsize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_rightwindowsize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_setcancel.
function pushbutton_setcancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_setcancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.uipanel2,'Visible','off');
set(handles.uipanel1,'Visible','on');
pos=get(handles.figure1,'Position');
pos(4)=15;
set(handles.figure1,'Position',pos);



function edit_orderingfeature_Callback(hObject, eventdata, handles)
% hObject    handle to edit_orderingfeature (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_orderingfeature as text
%        str2double(get(hObject,'String')) returns contents of edit_orderingfeature as a double


% --- Executes during object creation, after setting all properties.
function edit_orderingfeature_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_orderingfeature (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_done.
function pushbutton_done_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_done (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
for i=1:handles.nparams
    eval(['handles.output{' num2str(i) '}=get(handles.edit_param' num2str(i) ',''String'');']);
end
if(handles.nparams==2)
    handles.output{1}(end+(1:2))=' 0';
end
guidata(hObject, handles);
uiresume(handles.figure1);



% --- Executes on button press in pushbutton_cancel.
function pushbutton_cancel_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_cancel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.output{1}=[];
guidata(hObject, handles);
uiresume(handles.figure1);




% --- Executes on button press in pushbutton_setequalizer.
function pushbutton_setequalizer_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_setequalizer (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.uipanel1,'Visible','off');
set(handles.uipanel2,'Visible','on');
pos=get(handles.figure1,'Position');
pos(4)=43.55;
set(handles.figure1,'Position',pos);

function edit_param1_Callback(hObject, eventdata, handles)
% hObject    handle to edit_param1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_param1 as text
%        str2double(get(hObject,'String')) returns contents of edit_param1 as a double


% --- Executes during object creation, after setting all properties.
function edit_param1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_param1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_param2_Callback(hObject, eventdata, handles)
% hObject    handle to edit_param2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_param2 as text
%        str2double(get(hObject,'String')) returns contents of edit_param2 as a double


% --- Executes during object creation, after setting all properties.
function edit_param2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_param2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_param3_Callback(hObject, eventdata, handles)
% hObject    handle to edit_param3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_param3 as text
%        str2double(get(hObject,'String')) returns contents of edit_param3 as a double


% --- Executes during object creation, after setting all properties.
function edit_param3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_param3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit_param4_Callback(hObject, eventdata, handles)
% hObject    handle to edit_param4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_param4 as text
%        str2double(get(hObject,'String')) returns contents of edit_param4 as a double


% --- Executes during object creation, after setting all properties.
function edit_param4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_param4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_switchdiagram.
function pushbutton_switchdiagram_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_switchdiagram (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if(strcmpi(get(handles.diagram1,'Visible'),'on'))
    set(handles.diagram1,'Visible','off');
    set(handles.diagram2,'Visible','on');
    
else
    set(handles.diagram1,'Visible','on');
    set(handles.diagram2,'Visible','off');
    
end
    


% --- Executes on button press in pushbutton_retry.
function pushbutton_retry_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_retry (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
for i=1:handles.nparams
    eval(['handles.output{' num2str(i) '}=get(handles.edit_param' num2str(i) ',''String'');']);
end 
if(isempty(handles.output{1}))
    handles.output{1}=['1:' num2str(handles.nspiketypes)];
elseif(length(str2num(handles.output{1}))==1)
    if((str2num(handles.output{1}))==0)
        handles.output{1}=['1:' num2str(handles.nspiketypes)];
    end
end

guidata(hObject, handles);
uiresume(handles.figure1);
