function [ut t G c]= timedec1(tk, Omega, b, method, htext_msg)
%timedec1.m
%Anmo Kim
%September 15th, 2007
%time decoding machine with integrate and fire model with R=\infty
%%%%  delta insensitive implementation  %%%%%%
%tk : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias added to u(t) (to make it absolutely positive)
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' will be used


%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[];


if(nargin<3)
   warn6('timedec1: wrong input argumnents\n u = timedec1(sk, delta, Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==3)
   method='quad';
elseif(~strcmp(lower(method),'riemann'))
   method='quad';
end


dt = pi/Omega/2000; % 2000 samples per zero-to-zero interval of g(.)



sk = (tk(1:(end-1))+tk(2:end))./2;

%B=-eye(length(sk))+diag(ones(length(sk)-1,1), 1);
Binv=-triu(ones(length(sk)));



t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
lent=length(t);


if(strcmp(method,'quad'))
%use 'adaptive Simpson quadrature' method for
%                  computing integral

warn6('timedec1:simpson quadrature integration not implemented yet', htext_msg);

else
   t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
   gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
  
   GSK0 = cumsum(gsk0).* dt;
   ti = round((tk-t0(1))/dt)+1;
   si = round((ti(1:(end-1))+ti(2:end))./2);
   
   for k=1:length(si)
      G(:,k)=(GSK0(ti(2:end)+si(end)-si(k))-GSK0(ti(1:(end-1))+si(end)-si(k)))';
   end

   Bq=-b*(tk(1:(end-2))+tk(3:end)-2*tk(2:(end-1)));
%   Bq(end+1)=b*(tk(end)-tk(end-1))-delta;
   Bq(end+1)=0;
   
   if(size(Bq,1)==1) Bq=Bq'; end   
   c =pinv(G)*Binv*Bq;

   ut=zeros(size(t));
   
   for k=1:length(si)
      ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
   end
end



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end