function [ut t G c]= timedec11(tk0, delta, Omega, b, method, htext_msg)
%timedec11.m
%Anmo Kim
%June 26th, 2007
%time decoding machine with integrate and fire model with R=\infty in
%if an ISI longer than the required one for perfect recovery, 'divide uniformly' 
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk0 : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' is to be used




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[]; c=[];


if(nargin<4)
   warn6('timedec11: wrong input argumnents\n u = timedec11(sk, delta, Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==4)
   method='quad';
elseif(~strcmp(lower(method),'riemann'))
   method='quad';
end


% if(delta > a*pi/Omega)
%    warn6('timedec11: delta value does not satisfy the perfect recovery condition',htext_msg);
% end


if(length(tk0) < 2)
   warn6('timedec11: a single spike cannot be decoded',htext_msg);
   return;
end

if(size(tk0,2)==1) tk0=tk0'; end %tk0 becomes a row vector

dt = pi/Omega/500; % 2000 samples per a zero-to-zero interval of g(.)

maxisi=pi/Omega*.5; %perfect recovery condition

if(length(delta)>length(tk0)-1) delta=delta(1:(length(tk0)-1));
else
   delta((end+1):(length(tk0)-1))=delta(end);
end

if(size(delta,2)>1) delta=delta'; end

tk1=tk0;
k=1;
while(k<length(tk1))
   if(tk1(k+1)-tk1(k)> maxisi)
      tk1=[tk1(1:k) (tk1(k)+tk1(k+1))/2 tk1((k+1):end)];
      %tk1=[tk1(1:k) ((1:549)*(tk1(k+1)-tk1(k))/550+tk1(k)) tk1((k+1):end)]; <-- this did not help much
      %k=k; %check it back whether new intervals are appropriate
   else
      k=k+1;
   end
end

sk = (tk1(1:(end-1))+tk1(2:end))./2;


%t=max(0,tk0(1)-3*pi/Omega):dt:(tk0(end)+3*pi/Omega);
t=(tk0(1)-3*pi/Omega):dt:(tk0(end)+3*pi/Omega);
lent=length(t);


if(strcmp(method,'quad'))
%use 'adaptive Simpson quadrature' method for
%                  computing integral

warn6('timedec11:simpson quadrature integration not implemented yet', htext_msg);

else
   t0 = t(1):dt:(2*tk0(end)-tk0(1)+3*pi/Omega+1);
   gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
  
   GSK0 = cumsum(gsk0).* dt;
%    GSK0=sinint(Omega.*(t0-sk(end)))./Omega;
   ti = round((tk0-t0(1))/dt)+1;
   si = round((sk-t0(1))/dt)+1;
   
   for k=1:length(si)
      G(:,k)=(GSK0(ti(2:end)+si(end)-si(k))-GSK0(ti(1:(end-1))+si(end)-si(k)))';
   end
   Ginv = pinv(G); %Moore-penrose pseudo inverse matrix
   
   if(size(tk0,2)>1) tk0=tk0';end
   q=delta-b*diff(tk0);
   
   c = Ginv*q;

   ut=zeros(size(t));
   
   for k=1:length(si)
      ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
   end
end




%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end