function [ut t G c]= timedec12(tk, delta, a, htext_msg)
%timedec12.m
%reciprocal ISI
%Anmo Kim
%June 27th, 2007
%reciprocal ISI




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[]; c=[];

if(nargin<4)
    htext_msg=0;
end

if(nargin<3)
   warn6('timedec12: wrong input argumnents\n u = timedec12(sk, delta, a)', htext_msg);
   return;
end


if(length(tk) < 2)
   warn6('timedec12: a single spike cannot be decoded',htext_msg);
   return;
end

if(size(tk,2)==1) tk=tk'; end %tk becomes a row vector

dt = 1/10000; % 100usec


t=(tk(1)-dt):dt:(tk(end)+dt);

ut=zeros(size(t));
ti=round((tk-t(1))/dt)+1;
for k=1:(length(tk)-1)
   ut(ti(k):(ti(k+1)-1))=1/(tk(k+1)-tk(k))*delta;
end


%[num, den]=cheby2(10,80,(Omega/2/pi)/(1/dt/2));
%ut=filter(num,den,ut);



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end