function [ut t G c]= timedec14(tk, delta, Omega, a, method, htext_msg)
%timedec14.m
%Anmo Kim
%August 31st, 2007
%time decoding machine with integrate and fire model with R=\infty in
%synaptic decoding using LPF
%  - impuse inputs
%  - ideal LPF


%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[]; c=[];


if(nargin<4)
   warn6('timedec14: wrong input argumnents\n u = timedec14(sk, delta, Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==4)
   method='quad';
elseif(~strcmpi(method,'riemann'))
   method='quad';
end


if(delta > a*pi/Omega)
   warn6('timedec14: delta value does not satisfy the perfect recovery condition',htext_msg);
end


if(length(tk) < 2)
   warn6('timedec14: a single spike cannot be decoded',htext_msg);
   return;
end

if(size(tk,2)==1) tk=tk'; end %tk becomes a row vector

dt = 1/10000; % 100usec


t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);

ut=zeros(size(t));
ti=round((tk-t(1))/dt)+1;

for k=1:length(tk)
   ut=ut+sinc(Omega/pi.*( ((1:length(t))-1)*dt - tk(k)+t(1))).*Omega./pi/100; 
end





%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end