function [ut t G c]= timedec16(tk, delta, Omega, a, method, htext_msg)
%timedec16.m
%Anmo Kim
%Oct. 20th, 2007
%Time Decoding using Conjugate Gradient method


%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[]; c=[];


if(nargin<4)
   warn6('timedec16: wrong input argumnents\n u = timedec16(sk, delta, Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==4)
   method='quad';
elseif(~strcmpi(method,'riemann'))
   method='quad';
end


if(delta > a*pi/Omega)
   warn6('timedec16: delta value does not satisfy the perfect recovery condition',htext_msg);
end


if(length(tk) < 2)
   warn6('timedec16: a single spike cannot be decoded',htext_msg);
   return;
end

if(size(tk,2)==1) tk=tk'; end %tk becomes a row vector

dt = 1/10000; % 100usec


t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);

t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
ti = round((tk-t0(1))/dt)+1;
si = round((ti(1:(end-1))+ti(2:end))./2);
sk = (tk(1:(end-1))+tk(2:end))./2;
gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi;

u(1,:)=zeros(1,length(t));
r(1,:)=delta(1)*ones(1,length(si));
w(1,:)=delta(1)*ones(1,length(si));
k=1;

while(1)
   figure(116);subplot(211);hold all;plot(t,u);subplot(212);hold all;plot(r(k,:));
   d(k,:)=TD(w(k,:), t, si, gsk0);
   a(k)=sum(TD(r(k,:), t, si, gsk0).^2*dt)/sum((TE(d(k,:), ti).*dt).^2)
   u(k+1,:)=u(k,:)+a(k)*d(k,:);
   r(k+1,:)=r(k,:)-a(k)*TE(d(k,:), ti).*dt;
   b(k)=sum(TD(r(k+1,:), t, si, gsk0).^2*dt)/sum(TD(r(k,:), t, si, gsk0).^2*dt);
   w(k+1,:)=r(k+1,:)+b(k)*w(k,:);
   k=k+1;
end



function u = TD(d, t, si, gsk0)
u=zeros(1,length(t));
for k=1:length(si)
   u = u +d(k).*gsk0((1:length(t))+si(end)-si(k));
end




function d = TE(u, ti)
for k=1:(length(ti)-1)
   d(k)=sum(u(ti(k):(ti(k+1)-1)));
end




%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end