function [ut t G c]= timedec17(tk, delta, Omega, b, method, htext_msg)
%timedec17.m
%Anmo Kim
%Nov. 02th, 2007
%time decoding machine with integrate and fire model with R=\infty
%
%function [ut t G Ginv c]= timedec17(tk, delta, Omega, b, method, htext_msg)
%
%tk : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias of u(t)
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' is to be used




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[];


if(nargin<4)
   warn6('timedec17: wrong input argumnents\n u = timedec17(sk, delta, Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==4)
   method='quad';
elseif(~strcmpi(method,'riemann'))
   method='quad';
end


% if(delta > a*pi/Omega)
%    warn6('timedec17: delta value does not satisfy the perfect recovery condition',htext_msg);
% end





minSegSize=2;
npadding=10;

Omegak=segmenttk(tk, 30, minSegSize, Omega);
segisi=pi./Omegak;


nsegment=sum(diff([0 segisi])~=0);
seg0=find(diff([0 segisi 0])~=0);



dt = pi/Omega/2000; % 2000 samples per a zero-to-zero interval of g(.)

sk = (tk(1:(end-1))+tk(2:end))./2;

%t=max(0,tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
ti = round((tk-t0(1))/dt)+1;
lent=length(t);
for i=1:length(sk)
    for j=1:length(sk)
        Ok=min(Omegak(i),Omegak(j));
        gsk0 = sinc(Ok./pi.*(t0-sk(j))).*Ok./pi;
        G(i,j)=sum(gsk0(ti(i):ti(i+1)))*dt;
    end
end


Ginv = pinv(G);
if(size(delta,2)>1) delta=delta';end
if(size(tk,2)>1) tk=tk';end
q=delta-b*diff(tk);
c = Ginv*q;

ut=zeros(size(t0));
for j=1:length(sk)
    gsk0 = sinc(Omegak(j)./pi.*(t0-sk(j))).*Omegak(j)./pi;
    ut=ut+gsk0*c(j);
end


% if(strcmp(method,'quad'))
% %use 'adaptive Simpson quadrature' method for
% %                  computing integral
% 
% warn6('timedec17:simpson quadrature integration not implemented yet', htext_msg);
% 
% else
%    t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
%    gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
%   
%    GSK0 = cumsum(gsk0).* dt;
%    ti = round((tk-t0(1))/dt)+1;
%    si = round((ti(1:(end-1))+ti(2:end))./2);
%    difftk=diff(tk);
%    
%    for k=1:length(si)
%       local_maxISI=max(difftk(max(1,k-5):min(length(difftk),k+5)));
%       if( local_maxISI> pi/Omega)
%          gsk = sinc(1/(local_maxISI).*(t0-sk(end)))/(local_maxISI);
%          GSK=cumsum(gsk).*dt;
%          G(:,k)=(GSK(ti(2:end)+si(end)-si(k))-GSK(ti(1:(end-1))+si(end)-si(k)))';
%       else
%          G(:,k)=(GSK0(ti(2:end)+si(end)-si(k))-GSK0(ti(1:(end-1))+si(end)-si(k)))';
%       end
%    end
%    Ginv = pinv(G); %Moore-penrose pseudo inverse matrix
%    if(length(delta)>length(sk)) delta=delta(1:length(sk));
%    else
%       delta((end+1):length(sk))=delta(end);
%    end
%    
%    if(size(delta,2)>1) delta=delta';end
%    if(size(tk,2)>1) tk=tk';end
%    q=delta-b*diff(tk);
%    c = Ginv*q;
% 
%    ut=zeros(size(t));
%    
%    for k=1:length(si)
%       local_maxISI=max(difftk(max(1,k-5):min(length(difftk),k+5)));
%       if( local_maxISI> pi/Omega)
%          gsk = sinc(1/(local_maxISI).*(t0-sk(end)))/(local_maxISI);
%          ut = ut +c(k).*gsk((1:length(t))+si(end)-si(k));
%       else
%          ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
%       end
%    end
% end


% gsk3 = repmat(gsk, [1 1 length(sk)]);
% 
% 
% onoff=zeros([1 size(gsk,2) size(gsk,1)]);
% for k=1:length(sk)
%   onoff(1, (round(tk(k)/dt):round(tk(k+1)/dt)), k)=1;
% end
% 
% onoff3 = repmat(onoff, [length(sk) 1 1]);



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end





function Omegak=segmenttk(tk, maxRange, minSegSize, maxBW)
%splitting a spike sequence into segments based upon the local spike rate
%Omegak : recovery bandwidth for each interspike interval (in radian)
%         length(Omegak)=length(tk)-1

%tk : time sequence [in sec]
%maxRange : maximum range of 1/(t_{k+1}-t_k) in a single segment
%minSegSize : minimum segment size (exempted when a segment is flanked by
%             fast spiking segments
%maxBW : maximum bandwidth in radian

isi=diff(tk);

%isi(isi < pi/maxBW)=pi/maxBW;
fk=1./isi;

segk=[];%index of fk within current window
for i=1:length(fk)
    if(isempty(segk))
        segk=i;
    elseif(max(fk([segk i])) - min(fk([segk i])) < maxRange || 1/min(fk([segk i])) <=pi/maxBW )
        segk=[segk i];
    elseif(length(segk)>=minSegSize)
        fk(segk)=min(fk(segk));
        segk=i;
    elseif(segk(1)==1)
        fk(segk)=min(fk(segk));
        segk=i;
    elseif(max(fk(segk)) < fk(segk(1)-1) && max(fk(segk)) < fk(i))
        %if it's shorter than minSegSize and flanked by high spiking
        %regions
        fk(segk)=min(fk(segk));
        segk=i;
    else
        segk=[segk i];
    end
end

if(length(segk)>=minSegSize)
    fk(segk)=min(fk(segk));
else
    fk(segk)=min(fk(segk(1)-1));
end

Omegak=pi*fk;
Omegak(Omegak>maxBW)=maxBW;