function [ut t G c decker]= timedec23(tk,  Omega,method, R, C, htext_msg)
%timedec23.m
%Anmo Kim
%Jan. 4th, 2009
%time decoding machine for 4d hodgkin-huxley neuron
%using project-integrate-and-fire concept, or phase response curve
%prc is varying based upon the current inter-spike interval

%PRC is obtained by simulating of the direct stimulation with 1uA/cm^2 delta pulse



%tk : sequence of spike timings
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' is to be used




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[];




if(nargin<3)
   warn6('timedec23: wrong input argumnents\n u = timedec23(sk,  Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==4)
   method='quad';
elseif(~strcmpi(method,'riemann'))
   method='quad';
end


%load hohu4dIbaseprc_floquet.mat
load hohu4dIbaseprc_direct.mat
%Ibase, isi, dt, prc
dt0=dt*10^-3;
prc0=chi*1000;%prc is corrected by scaling uniformly to its 96% amplitude
Ibase0=Ibase;

dt = pi/Omega/2000; % 2000 samples per a zero-to-zero interval of g(.)



prc=interp1((0:(size(prc0,2)-1))*dt0, prc0', 0:dt:(size(prc0,2)*dt0-dt0),'spline');
isik=round(isi/dt/1000*874/865.4); %scaling


sk = (tk(1:(end-1))+tk(2:end))./2;
%sk=linspace((tk(2)+tk(1))./2, (tk(end)+tk(end-1))/2, ceil(pi/Omega/max(diff(tk(2:end))))*ceil(Omega/pi*(tk(end)-tk(1))));


t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
lent=length(t);

if(strcmp(method,'quad'))
%use 'adaptive Simpson quadrature' method for
%                  computing integral

warn6('timedec23:simpson quadrature integration not implemented yet', htext_msg);

else
   t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
   gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
  
   %load prcibase.mat
   
   ti = round((tk-t0(1))/dt)+1;
    si=round((sk-t0(1))/dt)+1;  
    
    decker=zeros(size(t));
    bkhat=zeros(size(t));
   for l=1:(length(tk)-1)
       
       starti=ti(l)+si(end)+1;
       endi=ti(l+1)+si(end);
       nowisik=ti(l+1)-ti(l);%the previous one - because of the hysterisis.

       nextk=find(isik<=nowisik,1,'first');
       if(isempty(nextk))
           prc7=prc(:,end);
       elseif(nextk==1)
           prc7=prc(:,1);
       else
           prc7=(isik(nextk-1)-nowisik)/(isik(nextk-1)-isik(nextk))*prc(:,nextk-1)...
               +(nowisik-isik(nextk))/(isik(nextk-1)-isik(nextk))*prc(:,nextk);
           Ibase7=(isik(nextk-1)-nowisik)/(isik(nextk-1)-isik(nextk))*Ibase(nextk-1)...
               +(nowisik-isik(nextk))/(isik(nextk-1)-isik(nextk))*Ibase(nextk);
       end
       if(length(prc7)>=ti(l+1)-ti(l))
           nowprc=prc7(1:(ti(l+1)-ti(l)))';
       else
           %in case the ISI is longer than the maximum PRC length
           nowprc=[ zeros(1,ti(l+1)-ti(l)-length(prc7)) prc7'];
       end
       
       %figure(3);hold all;plot(prc7);
      for k=1:length(si)
         G(l,k)=sum(gsk0((starti-si(k)):(endi-si(k))).*nowprc)*dt;
      end
      
      %for plotting purposes
      decker(ti(l):(ti(l+1)-1))=nowprc/1000;
      bkhat(ti(l):(ti(l+1)-1))=Ibase7;

   end
   Ginv = pinv(G); %Moore-penrose pseudo inverse matrix
   

   c = Ginv*ones(size(Ginv,2),1);
   

   ut=zeros(size(t));
   
   for k=1:length(si)
      ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
   end
end


if(false)
    %plot the prc kernels w.r.t time
    temp=max(decker)-min(decker);
    figure(823);clf;hstem=stem(tk*1000,ones(size(tk))*max(decker)+temp*.1,'Color',[.4 .4 .4],'Marker','None','LineStyle','--');
    set(hstem,'BaseValue',min(decker)-temp*.1);
    set(get(hstem,'BaseLine'),'LineStyle','none');
    hold on; plot(t*1000,decker,'k');xlabel('Time (ms)');ylabel('Conditional Kernel, \Chi');
end

if(true)
    %plot the bkhat kernels w.r.t time
    temp=max(bkhat)-min(bkhat);
    figure(823);clf;hstem=stem(tk*1000,ones(size(tk))*max(bkhat)+temp*.1,'Color',[.4 .4 .4],'Marker','None','LineStyle','--');
    set(hstem,'BaseValue',min(bkhat)-temp*.1);
    set(get(hstem,'BaseLine'),'LineStyle','none');
    hold on; plot(t*1000,bkhat,'k');xlabel('Time (ms)');ylabel('estimated base level, bhat_k');
end


%ut=ut*10^(12);%A-->pA
% gsk3 = repmat(gsk, [1 1 length(sk)]);
% 
% 
% onoff=zeros([1 size(gsk,2) size(gsk,1)]);
% for k=1:length(sk)
%   onoff(1, (round(tk(k)/dt):round(tk(k+1)/dt)), k)=1;
% end
% 
% onoff3 = repmat(onoff, [length(sk) 1 1]);



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end