function [ut t G c]= timedec3(tk, Omega, b, method, R, C, htext_msg)
%timedec3.m
%Anmo Kim
%September 22th, 2007 
%derived from timedec2.m
%time decoding machine with a leaky integrate and fire model
%delta insensitive algorithm

%tk : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' is to be used




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[];


if(nargin<3)
   warn6('timedec3: wrong input argumnents\n u = timedec3(sk, Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==3)
   method='quad';
elseif(~strcmpi(method,'riemann'))
   method='quad';
end


% if(R*C*log(1-delta/(delta-a*R))*Omega/pi >1)
%    warn6('timedec3: delta value does not satisfy the perfect recovery condition',htext_msg);
% end

b=b*10^-12; %pA-->A


dt = pi/Omega/2000; % 2000 samples per a zero-to-zero interval of g(.)


sk = (tk(1:(end-1))+tk(2:end))./2;

t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
lent=length(t);


if(strcmp(method,'quad'))
%use 'adaptive Simpson quadrature' method for
%                  computing integral

warn6('timedec3:simpson quadrature integration not implemented yet', htext_msg);

else
   t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
   gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
  
%   GSK0 = cumsum(gsk0).* dt;
%    GSK0=sinint(Omega.*(t0-sk(end)))./Omega;
   ti = round((tk-t0(1))/dt)+1;
   si = round((ti(1:(end-1))+ti(2:end))./2);
   
   for l=1:length(si)
      starti=ti(l)+si(end)+1;
      endi=ti(l+1)+si(end);
      expker= exp(((starti:endi)-endi)*dt/R/C);%exponential kernel
      for k=1:length(si)
         G(l,k)=sum(gsk0((starti-si(k)):(endi-si(k))).*expker)*dt;
      end
      
   end
   Ginv = pinv(G); %Moore-penrose pseudo inverse matrix
   
   %delta insensitive algorithm
   Binv=-triu(ones(length(sk)));
   m2=tk(3:end)-tk(2:(end-1));
   m1=tk(2:(end-1))-tk(1:(end-2));
   Bq=C*b*R*(exp(-m2/R/C)-exp(-m1/R/C));
   Bq(end+1)=0;
%   Bq(end+1)=C*b*R- C*b*R*exp(-(tk(end)-tk(end-1))/R/C);
   
   if(size(Bq,1)==1) Bq=Bq'; end   
   q=Binv*Bq;
   c =Ginv*q;

   ut=zeros(size(t));
   
   for k=1:length(si)
      ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
   end
end

ut=ut*10^(12);%A-->pA
% gsk3 = repmat(gsk, [1 1 length(sk)]);
% 
% 
% onoff=zeros([1 size(gsk,2) size(gsk,1)]);
% for k=1:length(sk)
%   onoff(1, (round(tk(k)/dt):round(tk(k+1)/dt)), k)=1;
% end
% 
% onoff3 = repmat(onoff, [length(sk) 1 1]);



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end