%timedec4.m
function [ut t]= timedec4(tk, delta, Omega, b, htext_msg, ut00, t00)
%timedec4.m
%Anmo Kim
%August 24th, 2006
%time decoding machine with a leaky integrate and fire neuron model
%using "VARIABLE FREQUENCY" and "STITCHING" algorithm

%tk : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias




t=[];ut=[];
minSegSize=2;
npadding=10;

Omegak=segmenttk(tk, 30, minSegSize, Omega);
segisi=pi./Omegak;


nsegment=sum(diff([0 segisi])~=0);
seg0=find(diff([0 segisi 0])~=0);

% figure(5);
% for ii=1:length(tk)
%     if(sum(seg0==ii)>0)
%         plot([tk(ii) tk(ii)],[0 1],'r'); hold on;
%     else
%         plot([tk(ii) tk(ii)],[0 1],'b'); hold on;
%     end
% end

% t9={};
% ut9={};
%VFTDM for each segment
for i=1:nsegment
    firstk=seg0(i);
    lastk=seg0(i+1);
    segmentisi(i)=segisi(firstk);
    lnqr(i)=1/segmentisi(i)/2-5;

    nowtk=tk(firstk:lastk);
    segtk{i}=nowtk;

    if(firstk==1)
        lpadinterval=(tk(firstk+1)-tk(firstk));
    else
        lpadinterval=min(tk(firstk)-tk(firstk-1),tk(firstk+1)-tk(firstk));
    end

    if(lpadinterval<0.5*(tk(firstk+1)-tk(firstk)))
        lpadinterval=0.5*(tk(firstk+1)-tk(firstk));
    end
    lpadtk=(-npadding:-1)*lpadinterval+tk(firstk);

    if(lastk==length(tk))
        rpadinterval=(tk(lastk)-tk(lastk-1));
    else
        rpadinterval=min(tk(lastk+1)-tk(lastk),tk(lastk)-tk(lastk-1));
    end

    if(lpadinterval<0.5*(tk(lastk)-tk(lastk-1)))
        rpadinterval=0.5*(tk(lastk)-tk(lastk-1));
    end
    rpadtk=(1:npadding)*rpadinterval+tk(lastk);
    nowtk=[lpadtk nowtk rpadtk];

    deltak=delta*ones(1,length(nowtk));

    if(Omegak(firstk)<2*pi*Omega)
        omeganow=Omegak(firstk)*.9;
    else
        omeganow=Omegak(firstk);
    end
    [ut0 t0]= timedec0(nowtk, deltak, omeganow, b, 'riemann');
    %     ut9{end+1}=ut0;
    %     t9{end+1}=t0;

    if(isempty(t))
        t=t0;ut=ut0;
    else
        t1=tk(firstk-1);
        t2=tk(firstk);
        t3=tk(firstk+1);


        if(t2-t1>t3-t2)
            %merging on the left side
            tx=2*t2-t3;
            ltk=find(t>tx & t<t2);
            lt=t(ltk);
            rtk0=find(t0>lt(end),1,'first');


            left=ut(ltk).*(1-sin(pi*(lt-tx)/2/(t2-tx)));
            right=interp1(t0,ut0,lt).*sin(pi*(lt-tx)/2/(t2-tx));
            merged=left+right;
            t=[t(1:ltk(end)) t0(rtk0:end)];
            ut=[ut(1:(ltk(1)-1)) merged ut0(rtk0:end)];

        else
            %merging on the right side
            tx=2*t2-t1;
            rtk=find(t0>t2 & t0<tx);
            rt=t0(rtk);
            ltkend=find(t<rt(1),1,'last');

            left=interp1(t,ut,rt).*(1-sin(pi*(rt-t2)/2/(tx-t2)).^2);
            right=ut0(rtk).*sin(pi*(rt-t2)/2/(tx-t2)).^2;
            merged=left+right;
            t=[t(1:ltkend) t0(rtk(1):end)];
            ut=[ut(1:ltkend) merged ut0((rtk(end)+1):end)];

        end
    end
end

oversampleR=10;
dt=pi/Omega/oversampleR;
t8=t(1):dt:t(end);
ut=interp1(t,ut,t8);
t=t8;

%
% uf = fft(ut);
% cutoffk=ceil(length(uf)/2/oversampleR);
% uf((cutoffk+1):(end-cutoffk))=0;
% ut=abs(ifft(uf));

% abandoned because of the group delay
% linear phase filter is recommended to prevent the delay
% [b,a] = cheby2(4,40,Omega/pi*dt);
% ut=filter(b, a, ut);
% delay0=grpdelay(b,a);

b = fircls1(20*oversampleR,1.5/oversampleR,0.02,0.008);
[gd w]=grpdelay(b,1);
t=t-mean(gd)*dt;
ut=filter(b, 1, ut);






%save stitching.mat tk delta Omega b ut00 t00 Omegak tk t ut t9 ut9


function Omegak=segmenttk(tk, maxRange, minSegSize, maxBW)
%splitting a spike sequence into segments based upon the local spike rate
%Omegak : recovery bandwidth for each interspike interval (in radian)
%         length(Omegak)=length(tk)-1

%tk : time sequence [in sec]
%maxRange : maximum range of 1/(t_{k+1}-t_k) in a single segment
%minSegSize : minimum segment size (exempted when a segment is flanked by
%             fast spiking segments
%maxBW : maximum bandwidth in radian

isi=diff(tk);

%isi(isi < pi/maxBW)=pi/maxBW;
fk=1./isi;

segk=[];%index of fk within current window
for i=1:length(fk)
    if(isempty(segk))
        segk=i;
    elseif(max(fk([segk i])) - min(fk([segk i])) < maxRange || 1/min(fk([segk i])) <=pi/maxBW )
        segk=[segk i];
    elseif(length(segk)>=minSegSize)
        fk(segk)=min(fk(segk));
        segk=i;
    elseif(segk(1)==1)
        fk(segk)=min(fk(segk));
        segk=i;
    elseif(max(fk(segk)) < fk(segk(1)-1) && max(fk(segk)) < fk(i))
        %if it's shorter than minSegSize and flanked by high spiking
        %regions
        fk(segk)=min(fk(segk));
        segk=i;
    else
        segk=[segk i];
    end
end

if(length(segk)>=minSegSize)
    fk(segk)=min(fk(segk));
else
    fk(segk)=min(fk(segk(1)-1));
end

Omegak=pi*fk;
Omegak(Omegak>maxBW)=maxBW;