%timedec5.m
function [ut t]= timedec5(tk, delta, Omega, b, htext_msg)
%timedec5.m
%Anmo Kim
%September 2nd, 2006
%time decoding of undersampled spikes using 'dilation method'


minSegSize=2;

Omegak=segmenttk(tk, 30, minSegSize, Omega);
segisi=pi./Omegak;

delta0=delta(1); 
delta=delta0*ones(size(tk));

isi=diff(tk);
underk=find(Omegak<Omega);%undersampled inter spike intervals
for i=1:length(underk)
    div(i)=ceil(Omega./Omegak(underk(i)));
    isi(underk(i))=isi(underk(i))/div(i);
    delta(underk(i)+1)=delta(underk(i)+1)/div(i);
end


seg0=find(diff([0 segisi 0])~=0);
% 
% figure(5);
% for ii=1:length(tk)
%     if(sum(seg0==ii)>0)
%         plot([tk(ii) tk(ii)],[0 1],'r'); hold on;
%     else
%          plot([tk(ii) tk(ii)],[0 1],'b'); hold on;
%     end
% end



tk1=cumsum([tk(1) isi]);
% underk=find(delta(2:end)<delta0);
% div=round(delta0./delta(underk+1));


[ut0 t0]= timedec0(tk1, delta, Omega, b, 'riemann');
dt=t0(2)-t0(1);

% t9=t0;
% ut9=ut0;
% tk9=tk1;

nowdiv=[];
for i=1:length(underk)
      if(isempty(nowdiv))
        nowdiv=div(i);
        t1=tk1(underk(i));
      elseif(div(i)~=nowdiv || underk(i)~=underk(i-1)+1)
        t2=tk1(underk(i-1)+1);
        isi=t2-t1;
        ink=find(t0>t1 & t0<=t2);
        t0(ink)=(t0(ink)-t1)*nowdiv + t1;
%         dilate0=1./(1+exp(-8*((t0(ink)-t1-isi/2)/isi)));
%         dilate0=(dilate0-dilate0(1))./(dilate0(end)-dilate0(1));
%         t0(ink)=isi*(nowdiv-1).*dilate0 + t0(ink);
        tshift=isi*(nowdiv-1);
        t0((ink(end)+1):end)=t0((ink(end)+1):end)+tshift;
        tk1((underk(i-1)+1):end)=tk1((underk(i-1)+1):end)+tshift;

      %for the next run
      nowdiv=div(i);
      t1=tk1(underk(i));
      elseif(i==length(underk))
        t2=tk1(underk(i)+1);
        isi=t2-t1;
        ink=find(t0>t1 & t0<=t2);
        t0(ink)=(t0(ink)-t1)*nowdiv + t1;
%         dilate0=1./(1+exp(-8*((t0(ink)-t1-isi/2)/isi)));
%         dilate0=(dilate0-dilate0(1))./(dilate0(end)-dilate0(1));
%         t0(ink)=isi*(nowdiv-1).*dilate0 + t0(ink);
        tshift=isi*(nowdiv-1);
        t0((ink(end)+1):end)=t0((ink(end)+1):end)+tshift;
        tk1((underk(i)+1):end)=tk1((underk(i)+1):end)+tshift;          
      end
end

%transitionk=diff(diff([t0(1) t0]));

% 
% for i=1:length(underk)
%     t1=tk1(underk(i));
%     t2=tk1(underk(i)+1);
%     isi=t2-t1;
%     ink=find(t0>t1 & t0<=t2);
%     t0(ink)=(t0(ink)-t1)*div(i) + t1;
%     %t0(ink)=isi*(div(i)-1)./(1+exp(-(4*(t0(ink)-t1-isi/2)/isi).^3)) + t0(ink);
%     tshift=isi*(div(i)-1);
%     t0((ink(end)+1):end)=t0((ink(end)+1):end)+tshift;
%     tk1((underk(i)+1):end)=tk1((underk(i)+1):end)+tshift;
% end
% 

% 
% figure(32);plot(t0);

oversampleR=10;
dt=pi/Omega/oversampleR;

t=t0(1):dt:t0(end);
ut=interp1(t0,ut0,t);

% % for smooth dilation
% i=0;
% while(1)
%     if(i==length(underk))
%         break;
%     end
%     i=i+1;
%     t1=tk1(underk(i));
%     
%     while(1)
%         if(i<length(underk))
%             if(underk(i+1)==underk(i)+1 && div(i+1)==div(i))
%                 i=i+1;
%             else
%                 break;
%             end
%         else
%             break;
%         end
%     end
%     t2=tk1(underk(i)+1);
%         
%     isi=t2-t1;
%     
%     
%     ink=find(t0>t1 & t0<=t2);
%     %t0(ink)=(t0(ink)-t1)*div(i) + t1;
%     t0(ink)=isi*(div(i)-1)./(1+exp(-(4*(t0(ink)-t1-isi/2)/isi).^3)) + t0(ink);
%     tshift=isi*(div(i)-1);
%     t0((ink(end)+1):end)=t0((ink(end)+1):end)+tshift;
%     tk1((underk(i)+1):end)=tk1((underk(i)+1):end)+tshift;
% end


b = fircls1(oversampleR*20,1.5/oversampleR,0.02,0.008);
t=t-mean(grpdelay(b,1))*dt;
ut=filter(b, 1, ut);


%save dilation.mat tk delta Omega b tk9 t9 ut9 t ut Omegak

function Omegak=segmenttk(tk, maxRange, minSegSize, maxBW)
%splitting a spike sequence into segments based upon the local spike rate
%Omegak : recovery bandwidth for each interspike interval (in radian)
%         length(Omegak)=length(tk)-1

%tk : time sequence [in sec]
%maxRange : maximum range of 1/(t_{k+1}-t_k) in a single segment
%minSegSize : minimum segment size (exempted when a segment is flanked by
%             fast spiking segments
%maxBW : maximum bandwidth in radian

isi=diff(tk);

%isi(isi < pi/maxBW)=pi/maxBW;
fk=1./isi;

segk=[];%index of fk within current window
for i=1:length(fk)
    if(isempty(segk))
        segk=i;
    elseif(max(fk([segk i])) - min(fk([segk i])) < maxRange || 1/min(fk([segk i])) <=pi/maxBW )
        segk=[segk i];
    elseif(length(segk)>=minSegSize)
        fk(segk)=min(fk(segk));
        segk=i;
    elseif(segk(1)==1)
        fk(segk)=min(fk(segk));
        segk=i;
    elseif(max(fk(segk)) < fk(segk(1)-1) && max(fk(segk)) < fk(i))
        %if it's shorter than minSegSize and flanked by high spiking
        %regions
        fk(segk)=min(fk(segk));
        segk=i;
    else
        segk=[segk i];
    end
end

if(length(segk)>=minSegSize)
    fk(segk)=min(fk(segk));
else
    fk(segk)=min(fk(segk(1)-1));
end

Omegak=pi*fk;
Omegak(Omegak>maxBW)=maxBW;