function [ut t G c]= timedec6(tk, delta, Omega, a, taua, eta, htext_msg)
%timedec6.m
%Anmo Kim
%Oct. 25th, 2006
%time decoding machine with i&f model with R=\infty and '''adaptation'''
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%a : infimum of u(t)

%taua : adaptation time constant
%eta : adaptation factor



%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[];


if(nargin<6)
   disp('timedec6: wrong input argumnents\n  timedec6(tk, delta, Omega, a, taua, eta, htext_msg)');
   return;
end

if(nargin==6) htext_msg=[]; end

if(delta > a*pi/Omega)
   warn6('timedec6??????: delta value does not satisfy the perfect recovery condition',htext_msg);
end


dt = pi/Omega/2000; % 2000 samples per a zero-to-zero interval of g(.)


sk = (tk(1:(end-1))+tk(2:end))./2;

%t=max(0,tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
lent=length(t);

t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
GSK0 = cumsum(gsk0).* dt;
%    GSK0=sinint(Omega.*(t0-sk(end)))./Omega;
ti = round((tk-t0(1))/dt)+1;
si = round((ti(1:(end-1))+ti(2:end))./2);

for k=1:length(si)
   G(:,k)=(GSK0(ti(2:end)+si(end)-si(k))-GSK0(ti(1:(end-1))+si(end)-si(k)))';
   %       for kk=1:length(si)
   %           G(k,kk)=sum(gsk0((ti(k)+si(end)-si(kk)):(ti(k+1)+si(end)-si(kk)))).*dt;
   %       end
end
Ginv = pinv(G); %Moore-penrose pseudo inverse matrix


ti2 = round((tk-t(1))/dt)+1;
ct = delta.*ones(1,length(t));
for k=1:length(tk)
   ct(ti2(k):end) = ct(ti2(k):end) + eta.*delta.*exp(-(t(ti2(k):end)-t(ti2(k)))/taua);
end

c = ct(ti2-1);

%figure;plot(ct);

ut=zeros(size(t));

for k=1:length(si)
   ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
end





%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end