function [ut t G c]= timedec7(tk, delta, Omega, b,taur,  method,  htext_msg)
%timedec7.m
%Anmo Kim
%Nov. 17th 2008
%time decoding machine with refractory period - integrate and fire model with R=\infty

%tk : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias of u(t)
%taur : refractory period in msec
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' is to be used




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[]; c=[];


if(nargin<7)
    htext_msg=[];
end

if(nargin<5)
   warn6('timedec7: wrong input arguments\n u = timedec7(tk, delta, Omega, b,taur,  method,  htext_msg', htext_msg);
   return;
end


if(nargin==5)
   method='riemann';
elseif(~strcmpi(method,'riemann'))
   method='quad';
end


% if(delta > a*pi/Omega)
%    warn6('timedec0: delta value does not satisfy the perfect recovery condition',htext_msg);
% end


dt = pi/Omega/2000; % 2000 samples per a zero-to-zero interval of g(.)
%dt=max(min(dt, 10^-5),5*10^-7);
dt=max(min(dt, 10^-5),5*10^-7);

sk = (tk(1:(end-1))+tk(2:end))./2;
%sk=linspace((tk(2)+tk(1))./2, (tk(end)+tk(end-1))/2, ceil(Omega/pi*(tk(end)-tk(1))));

%t=max(0,tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
lent=length(t);


if(strcmp(method,'quad'))
%use 'adaptive Simpson quadrature' method for
%                  computing integral

warn6('timedec0:simpson quadrature integration not implemented yet', htext_msg);

else
   t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
   gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
   
   GSK0 = cumsum(gsk0).* dt;
%    GSK0=sinint(Omega.*(t0-sk(end)))./Omega;
   ti = round((tk-t0(1))/dt)+1;
%   si = round((ti(1:(end-1))+ti(2:end))./2);
   si=round((sk-t0(1))/dt)+1;  
   refrack=round(taur/1000/dt);
   
   for k=1:length(si)
      G(:,k)=(GSK0(ti(2:end)+si(end)-si(k))-GSK0(refrack+1+ti(1:(end-1))+si(end)-si(k)))';
   end
   Ginv = pinv(G); %Moore-penrose pseudo inverse matrix
   
   if(length(delta)>length(tk)) delta=delta(1:length(tk));
   else
      delta((end+1):length(tk)) = delta(end);
   end
   
   
      
   if(size(delta,2)>1) delta=delta';end
   if(size(tk,2)>1) tk=tk';end
   q=delta(2:end)-b*diff(tk);
   c = Ginv*q;

   ut=zeros(size(t));
   
   for k=1:length(si)
      ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
   end
end


% gsk3 = repmat(gsk, [1 1 length(sk)]);
% 
% 
% onoff=zeros([1 size(gsk,2) size(gsk,1)]);
% for k=1:length(sk)
%   onoff(1, (round(tk(k)/dt):round(tk(k+1)/dt)), k)=1;
% end
% 
% onoff3 = repmat(onoff, [length(sk) 1 1]);



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end