function [ut t G c]= timedec9(tkall, delta, Omega, b, method, htext_msg)
%timedec9.m
%Anmo Kim
%Oct. 31st, 2007
%population time decoding machine with integrate and fire model with R=\infty

%function [ut t G Ginv c]= timedec9(tkall, delta, Omega, b, method, htext_msg)
%tkall : sequence of spike timings
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias of u(t)
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' is to be used




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[];


if(nargin<4)
   warn6('timedec9: wrong input argumnents\n u = timedec9(tk, delta, Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==4)
   method='quad';
elseif(~strcmp(lower(method),'riemann'))
   method='quad';
end

if(~iscell(tkall))
   warn6('timedec9 - tkall should be a cell array : type "help timedec9"');
   return;
end

% if(length(tkall)<2)
%    warn6('timedec9 - tk should be a cell array');
%    return;
% end

ntem=length(tkall);

mintk=inf;
maxtk=-inf;
ntkall=0;
for k=1:ntem
   if(length(tkall{k})<2)
      warn6('timedec9 - number of spikes too small');
      return;
   end
   mintk = min(mintk, min(tkall{k}));
   maxtk = max(maxtk, max(tkall{k}));
   ntkall= ntkall+length(tkall{k});
end

dt = pi/Omega/2000; % 2000 samples per zero-to-zero interval of g(.)

nskall=0;
cum_nsk(1)=0;
maxsk=-inf;
for k=1:ntem
   skall{k} = (tkall{k}(1:(end-1))+tkall{k}(2:end))./2;
   nskall=nskall+length(skall{k});
   cum_nsk(k+1)=cum_nsk(k)+length(skall{k});
   maxsk=max(maxsk,skall{k}(end));
end


t=(mintk-3*pi/Omega):dt:(maxtk+3*pi/Omega);
lent=length(t);

G=zeros(nskall);

if(strcmp(method,'quad'))
%use 'adaptive Simpson quadrature' method for
%                  computing integral
warn6('timedec9:simpson quadrature integration not implemented yet', htext_msg);


else
      t0 = t(1):dt:(2*maxtk-mintk+6*pi/Omega+1);
      gsk0 = sinc(Omega./pi.*(t0-maxsk)).*Omega./pi; %g(sk(end))

      GSK0 = cumsum(gsk0).* dt;
      maxsi=round((maxsk-t(1))/dt)+1;
   for j=1:ntem
         si = round((skall{j}-t(1))/dt)+1;
      for i=1:ntem
         ti = round((tkall{i}-t(1))/dt)+1;
         for l=1:length(si)
            G((1:length(skall{i}))+cum_nsk(i),l+cum_nsk(j))=...
               (GSK0(ti(2:end)+maxsi-si(l))-GSK0(ti(1:(end-1))+maxsi-si(l)))';
         end
      end
   end
   
   Ginv = pinv(G); %Moore-penrose pseudo inverse matrix
   if(length(delta)>length(nskall)) delta=delta(1:length(nskall));
   else
      delta((end+1):length(nskall))=delta(end);
   end
   
   if(length(b)<ntem)
      b((end+1):ntem)=b(end);
   end
   
   if(size(delta,2)>1) delta=delta';end

   q=zeros(nskall,1);
   for i=1:ntem
      if(size(tkall{i},2)>1) tkall{i}=tkall{i}';end
      q((1:length(skall{i}))+cum_nsk(i))=delta-b(i)*diff(tkall{i});
   end
   c = Ginv*q;

   ut=zeros(size(t));

   for j=1:ntem
      si = round((skall{j}-t(1))/dt)+1;
      for l=1:length(si)
         ut = ut +c(l+cum_nsk(j)).*gsk0((1:length(t))+maxsi-si(l));
      end
   end
end


% gsk3 = repmat(gsk, [1 1 length(sk)]);
% 
% 
% onoff=zeros([1 size(gsk,2) size(gsk,1)]);
% for k=1:length(sk)
%   onoff(1, (round(tk(k)/dt):round(tk(k+1)/dt)), k)=1;
% end
% 
% onoff3 = repmat(onoff, [length(sk) 1 1]);



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end