function [tk vt]= timeenc0(ut, t, delta0, Omega, b, htext_msg)
%timeenc0.m
%Anmo Kim
%Oct. 11th, 2006
%time encoding machine with ideal(R=\infty) integrate and fire model
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%ut : input signal
%t : sampling interval
%delta0 : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias
%htext_msg : handles of text_msg gui interface to display warnings(optional)


%initialization part ------------------------------------------------------
tk=[];
vt=zeros(size(ut));

if(nargin<3)
   warn6('timeenc0: wrong input argumnents\n tk= timeenc0(ut, t, delta0)', htext_msg);
   return;
end

if(nargin<4) Omega=0; end
if(nargin<5) b=0; end
if(nargin<6) htext_msg=-1; end

% if(isempty(ut) | isempty(t) | isempty(delta0) | isempty(Omega) |isempty(b))
%    warn6('timeenc0: some input arguments are empty', htext_msg);
%    return;
% end


if(size(ut,1)>1)
   ut=ut';
end
if(size(ut,1)>1)
   warn6('timeenc0 : multiple ut vectors are not supported', htext_msg);
   ut=ut(1,:);
end


a=min(ut+b);

dt=t(2)-t(1);

%integrate and fire (no leakyness. i.e. R=\infty)
Ut = cumsum(ut+b)*dt; %biased and integrated
tk(1)=1;
if(length(delta0)==1)
   
    while(1)
        if(isempty(tk)) prevtk=0;
        else prevtk = tk(end); end

        i=find(gt(Ut,delta0*(1+length(tk))),1,'first');
        if(isempty(i))
            vt((prevtk+1):end)=Ut((prevtk+1):end)-delta0*length(tk);
            break;
        else
            vt((prevtk+1):i)=Ut((prevtk+1):i)-delta0*length(tk);
            tk=[tk i];
            %Ut-Ut(i); <-- error
        end
    end
elseif(length(delta0)>1)
    delta1=0;
    while(1)
        if(isempty(tk)) prevtk=0;
        else prevtk = tk(end); end
        
        prevdelta1=delta1; %old delta;
        delta1=delta1+delta0(min(length(delta0), (1+length(tk))));
        
        i=find(gt(Ut,delta1),1,'first');
        if(isempty(i))
            vt((prevtk+1):end)=Ut((prevtk+1):end)-prevdelta1;
            break;
        else
            vt((prevtk+1):i)=Ut((prevtk+1):i)-prevdelta1;
            tk=[tk i];
            %Ut-Ut(i); <-- error
        end
    end
else
    warn6('timeenc0:threshod is not defined');
    return    
end


tk=t(tk);


if(Omega>0)
    r= mean(delta0)/a*Omega/pi;
    warn6(sprintf('timeenc0: ut is time encoded (ideal i&f model), r = %.2f, #spks=%d',r, length(tk)), htext_msg);
else
    warn6(sprintf('timeenc0: ut is time encoded (ideal i&f model),  #spks=%d',length(tk)), htext_msg);
end





%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end