function [tk vt]= timeenc1(ut, t, delta0,  b, R, C,Omega, htext_msg)
%timeenc1.m
%Anmo Kim
%May 1st, 2007
%time encoding machine with leaky(RC filter) integrate and fire neuron
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%ut : input signal
%t : sampling interval
%delta0 : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%R : resistance
%C : capacitance
%htext_msg : handles of text_msg gui interface to display warnings(optional)


%initialization part ------------------------------------------------------
tk=[];
vt=zeros(size(ut));

if(nargin<3)
   warn6('timeenc1: wrong input argumnents\n tk= timeenc1(ut, t, delta0)', htext_msg);
   return;
end

if(nargin<4) b=0; end
if(nargin<5) R=inf; end
if(nargin<6) C=1; end
if(nargin<7) Omega=0; end
if(nargin<8) htext_msg=-1; end


% if(isempty(ut) | isempty(t) | isempty(delta0) | isempty(Omega))
%    warn6('timeenc1: some input arguments are empty', htext_msg);
%    return;
% end


if(size(ut,1)>1)
    ut=ut';
end

if(size(ut,1)>1)
   warn6('timeenc1 : multiple ut vectors are not supported yet', htext_msg);
   ut=ut(1,:);
end


ut=ut+b; %add bias

%ut=ut*10^-(12); %pA --> A

%delta0=delta0*10^-3; %mV --> V

a=min(ut);

dt=t(2)-t(1);


%algorithm
%set y=\sum_{k=0}^{n} u(t0+k*dt)*exp(-(n-k)*dt/R/C)+C*y0*exp(-(n-k)*dt/R/C)
%if  y >= C*delta,   then generate a spike at "N*dt+t0" and 
%     set y0 to `y - (C*delta-C*y0*exp(-(N-k)*dt/R/C))'

%update issue (iterative form)
%the integration at N+1, y((N+1)*dt), is obtained from y(N*dt)
%             y((N+1)*dt)=y(N*dt)*exp(-dt/R/C)+u(t0+(N+1)*dt)*dt

tk=[t(1)];
if(length(delta0)==1)
   vt(1)=R*ut(1)*(1-exp(-dt/R/C));
    for k=2:length(t)
       if(vt(k-1)>=delta0)
          tk=[tk t(k-1)];
          vt(k)=ut(k)*dt+(vt(k-1)-delta0); 
       else
          %vt(k)=vt(k-1)*exp(-dt/R/C)+ut(k)*dt;
          vt(k)=vt(k-1)*exp(-dt/R/C)+R*(1-exp(-dt/R/C))*ut(k);
       end       
    end
elseif(length(delta0)>1)
   %if a sequence of thresholds is given
   vt(1)=R*ut(1)*(1-exp(-dt/R/C));
   delta1=delta0(1);
    for k=2:length(t)
       if(vt(k-1)>=delta1)
          delta1=delta0(min(length(tk),length(delta0)));
          tk=[tk t(k-1)];
          vt(k)=ut(k)*dt+(vt(k-1)-delta1); 
       else
          vt(k)=vt(k-1)*exp(-dt/R/C)+R*(1-exp(-dt/R/C))*ut(k);
       end       
    end
        
else
    warn6('delta0 is empty');
    return;    
end

if(Omega>0)
    r= R*C*log(1-mean(delta0)/(mean(delta0)-a*R))*Omega/pi;
    warn6(sprintf('timeenc1: ut is time encoded (leaky i&f model), r = %.2f, #spks=%d',r, length(tk)), htext_msg);
else
    warn6(sprintf('timeenc1: ut is time encoded (leaky i&f model),  #spks=%d',length(tk)), htext_msg);
end




%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end