function [tk vt]= timeenc10(ut, t, Ibase, htext_msg)
%timeenc10.m - Hodgkin-Huxley 4dimensional
%Anmo Kim
%May 3rd, 2007
%Project-Integrate-and-Fire neuron
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%ut : input signal
%t : sampling interval
%Ibase : base current
%htext_msg : handles of text_msg gui interface to display
%warnings(optional)

%some constants
%initial conditions
x0=[29.5457    0.5471    0.2463    0.8683];
%input weights
B=diag([1 0.0027 0.0025 0.0093]); %ideally, this should be computed here..

if (isempty(ut))
   set(text_msg,'String','timeenc10:no input signal is avaliable');
   return;
elseif(isvector(ut))
   if(size(ut,2)==1)
      ut=ut';
   end
   ut=[ut; zeros(3,length(ut))];
else %matrix
   if(size(ut,1)==4)
   elseif(size(ut,2)==4)
      ut=ut';
   else
      set(htext_msg,'String','timeenc10: input signal should be 4 dimensional');
      return;
   end
end

if (size(ut,2)~=length(t))
   set(htext_msg,'String','timeenc10: input signal length NOT agree with time vector length');
   return;
end


dt=t(2)-t(1);
hohu4d0_fname='hohu4d0_exp.mat';
%Simulate Hodgkin-Huxley Neuron with zero input
if(exist(hohu4d0_fname,'file')) %zero input Hodgkin-Huxley solution
   warning off;
   load(hohu4d0_fname,'tz', 'x0z', 'dtz', 'xz', 'peakkz','Ibasez');
   warning on;
   if(sum(ismember({'tz', 'x0z', 'dtz', 'xz', 'peakkz','Ibasez'},who))~=6)
      clear('tz', 'x0z', 'xz', 'dtz','peakkz','Ibasez');
   end
end


if(exist('tz','var'))
   ii=find(cell2mat(Ibasez)==Ibase & cell2mat(dtz)==dt);
   i=[];
   for k=1:length(ii)
      if(sum(x0z{ii(k)}==x0)==4)%if x0 matches
         i=ii(k);
         break;
      end
   end
   if(isempty(i))
      %no matches of (Ibase, dt) pair
      i=length(Ibasez)+1;
      ty=[t (t(end)+(dt:dt:.2))]; %simulate 100msec more (positive input increase the #spikes)
      set(htext_msg,'String',sprintf('Computing zero input Hodgkin-Huxley Output... hold on... Ibase=%1.1fpA',Ibase));
      drawnow;
      global Ibase_global;
      Ibase_global=Ibase;
      [t9 xy]=ode23s(@f_hh4d, ty*1000, x0);

      %detect spikes
      peakky=1+find(xy(2:end-1,1)>xy(1:end-2,1)&xy(2:end-1,1)>=xy(3:end,1));
   
      tz{i}=ty;x0z{i}=x0; xz{i}=xy; dtz{i}=dt; peakkz{i}=peakky; Ibasez{i}=Ibase;

      save(hohu4d0_fname,'tz', 'x0z', 'xz', 'dtz', 'peakkz','Ibasez');
      
   elseif(length(tz{i})<length(t)+ceil(.2/dt)-1)
      %match exist but too short -> update it
      ty=[t (t(end)+(dt:dt:.2))]; %simulate 100msec more (positive input increase the #spikes)
      set(htext_msg,'String',sprintf('Computing zero input Hodgkin-Huxley Output... hold on... Ibase=%1.1fpA',Ibase));
      drawnow;
       global Ibase_global;
      Ibase_global=Ibase;
      [t9 xy]=ode23s(@f_hh4d, ty*1000, x0);

      %detect spikes
      peakky=1+find(xy(2:end-1,1)>xy(1:end-2,1)&xy(2:end-1,1)>=xy(3:end,1));
   
      tz{i}=ty;x0z{i}=x0; xz{i}=xy; dtz{i}=dt; peakkz{i}=peakky; Ibasez{i}=Ibase;
      save(hohu4d0_fname,'tz', 'x0z', 'xz', 'dtz', 'peakkz','Ibasez');
   else 
      %matched entry is long enough --> just use them
      ty=tz{i};
      xy=xz{i};
      peakky=peakkz{i};
   end
   
   
else
   %if no proper file exist
   ty=[t (t(end)+(dt:dt:.2))]; %simulate 100msec more (positive input increase the #spikes)
   set(htext_msg,'String',sprintf('Computing zero input Hodgkin-Huxley Output... hold on... Ibase=%1.1fpA',Ibase));
   drawnow;
      global global_Ibase;
      global_Ibase=Ibase;
      [t9 xy]=ode23s(@f_hh4d, ty*1000, x0);

      %detect spikes
      peakky=1+find(xy(2:end-1,1)>xy(1:end-2,1)&xy(2:end-1,1)>=xy(3:end,1));
   
   tz{1}=ty;x0z{1}=x0; xz{1}=xy; dtz{1}=dt; peakkz{1}=peakky; Ibasez{1}=Ibase;

   save(hohu4d0_fname,'tz', 'x0z', 'xz', 'dtz', 'peakkz','Ibasez');

%    if(noplot==0)
%       figure(7);
%       subplot(212);
%       plot(thh0, xhh0(1,:));
%       xlabel('time');
%       ylabel('membrane potential');
%       title('Zero Input Hodgkin-Huxley');
%       set(handles.text_msg,'String','zero-input Hodgkin-Huxley output is plotted on a new figure');
%    end
end

peakk=peakky;


% loading the phase response curve
prcfname='prc_hh4d_floquet1.mat';
if(exist(prcfname,'file'))
   set(htext_msg,'String','Loading PRC from prc_hh4d_floquet.mat - hold on...');
   warning off;
   load(prcfname,'prcdt','prc', 'Ibasep');
   warning on;
   if(sum(ismember({'prcdt','prc','Ibasep'},who))~=3)
      clear('prcdt','prc','Ibasep');
   end
end

if(exist('Ibasep','var'))
   ii=find(cell2mat(Ibasep)==Ibase & cell2mat(prcdt)==dt);
   if(isempty(ii))
      %if no match
      ii=length(Ibasep)+1;
      set(htext_msg,'String','PRC not found. computing PRC. hold on...');
      drawnow;

      prc1=floquet_hh4d(11,dt*1000, x0,Ibase, htext_msg); %for a single period : t=[0:9.67]
      prc{ii}=prc1; prcdt{ii}=dt; Ibasep{ii}=Ibase;
      save('prc_hh4d_floquet.mat','prcdt','prc', 'Ibasep');
   else
      %if matched
      prc1=prc{ii};
   end
else
   %no proper prc file fount --> create a new prc file
   set(htext_msg,'String','PRC file does not exist. computing PRC. hold on...');
   drawnow;
   
   
   prc1=floquet_hh4d(11,dt*1000, x0,Ibase, htext_msg); %for a single period : t=[0:9.67]
   prc{1}=prc1; prcdt{1}=dt; Ibasep{1}=Ibase;
   save('prc_hh4d_floquet.mat','prcdt','prc', 'Ibasep');

end

prctheta=((1:size(prc1,1))-1)/size(prc1,1); %normalze the phase variable


%Simulate PIF Neuron
psp=zeros(size(t));%phase shift process
out=zeros(size(t));
spkk(1)=peakk(1);
phasenowk=0;
% pspwin=0:dt:5; %.5msec is the length of psp delay
% pspwin=pspwin*0;

set(htext_msg,'String','Simulating PIF neuron - hold on...');
drawnow;

b=sum((max(ut'*B).*min(prc1)))*1.1;%should 'sum' be replaced with 'min'????
if(b>=0)b=1; else b=-b;end


phasek=1;
for k=peakk(1):(length(t)-1)
   Tx=(peakk(min(length(peakk),length(spkk)+1))-peakk(min(length(peakk)-1,length(spkk))));
   prcnow=interp1(prctheta, prc1,...
      (k-spkk(end))/Tx);

   if(isnan(prcnow))
      prcnow=zeros(1,4);
   end
   
   out(k+1)=out(k)+(b+prcnow*B*ut(:,k)); %rectangular integration
   psp(k+1)=psp(k)+prcnow*B*ut(:,k)*dt;
   phasenowk=phasenowk+prcnow*B*ut(:,k);
   if(out(k+1)>=Tx-(1-b)*(k+1-spkk(end)))
      theta(length(spkk))=dt*(Tx-(k+1-spkk(end)));
      out(k+1)=out(k+1)-(Tx-(1-b)*(k+1-spkk(end)));
      spkk=[spkk k];
      phasenowk=0;
   end
end


vt=out;
tk=t(spkk);

set(htext_msg,'String','PIF neuron simulation completed');










function [dout, diam] = pickpeaksonly(din, maxn)
%pickpeaksonly
%Anmo Kim
%May 17th 2006
%pick high peaks only. other values ripped down to zero
%Arguments
%d1 : a row vector, which is the data to be searched
%maxn : maximum interval of non-zero value interval
%dout : 'peaks picked' version of d1

d1=din;

d1(find(d1<0))=0;

z=d1;
z(find(z>0))=1; %all positive values are forced to be 1

z1=diff(z);
% e.g. z = [ 0  1 0 1 1  1 0 0 0 1  1 0];
%      z1= [ 1 -1 1 0 0 -1 0 0 1 0 -1 0];
zstart = find(eq(z1,1))+1;
zend = find(eq(z1,-1));

diam=zeros(size(d1));

if(isempty(zend))
   [dout diam]=pickmaxonly(d1,maxn);
   return;
end;

if(zend(1) < zstart(1))
   [d1(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
   zend=zend(2:end);
end;


for k=1:length(zend)
   %    if(k==16)
   %       disp('k=16');
   %    end
   [d1(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
end;

if (length(zstart)>length(zend))
   [d1(zstart(end):end) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):end),maxn);
end;

% hist(d1(find(ne(d1,0))),50); pause;
% plot(d1); pause;
dout = d1;


%post processing : merging too close spikes
kk = find(ne(dout,0));
ii = find(le(diff(kk),maxn));

for k=1:length(ii)
   if (dout(kk(ii(k))) < dout(kk(ii(k)+1)))
      dout(kk(ii(k)))=0;
      diam(kk(ii(k)+1))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
   else
      dout(kk(ii(k)+1))=0;
      diam(kk(ii(k)))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
   end
end








function [dout, diam] = pickmaxonly(din, maxn)
%maxonly.m
%Anmo Kim
%May 16th, 2006
%description : taking the max value only within the given interval
%              other values are dropped to zero
%              if the given interval is greater than the tmax, it's chopped
%              into multiple intervals

nlevels=50;

d1=din;

if(size(d1,2)~=1)
   d1=d1';
end;

if(size(d1,2)~=1)
   disp('d1 needs be a vector, not a matrix');
   dout=[];
   diam=[];
   return;
end;

if(size(d1)==[1 1])
   dout = din;
   diam=1;
   return;
end


dout=zeros(size(din));
diam=zeros(size(din));

if (length(d1)<=maxn)
   [c, i]=max(d1);
   dout(i)=c;
   diam(i)=length(d1);

else
   delta = ones(length(d1), nlevels);
   delta=cumsum(delta,2)-1;
   delta=delta/nlevels*max(d1);

   d1=d1*ones(1,nlevels);

   higher=gt(d1,delta);
   z=diff(higher,1,1);

   kdelta=[];
   higher_area=[];
   nvaliddelta=0;
   for k=1:nlevels
      zstart=find(eq(z(:,k),1))+1;
      zend=find(eq(z(:,k),-1));

      if(isempty(zend) | isempty(zstart)) continue; end;

      if(zend(1) > zstart(end)) continue; end; %if no groove

      if(length(zstart)>2 | length(zend)>2) continue; end; %if there are more than two hills

      higher_area(nvaliddelta+1) = sum(higher(:,1)>delta(1,k));
      kdelta(nvaliddelta+1)=k;

   end;


   if(isempty(kdelta)) %no groove at all (a single valley)
      [c, i]=max(d1);
      dout(i)=c;
      diam(i)=length(d1);
      return;

   else
      [c, i]=min(higher_area);
      zstart=find(eq(z(:,kdelta(i)),1))+1;
      zend=find(eq(z(:,kdelta(i)),-1));

      if(zend(1) < zstart(1))
         [dout(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
         zend=zend(2:end);
      end;

      for k=1:length(zend)
         [dout(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
      end;

      if (length(zstart)>length(zend))
         [dout(zstart(end):length(din)) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):length(din)),maxn);
      end;
   end;
end;








function prc=floquet_hh4d(tend, dt, x0, Ibase, htext_msg)
%from E9060 lec#4

F=@f_hh4d;
global global_Ibase;
global_Ibase=Ibase; %high threshold

%dt and tend in milli second scale
%step1 : find the asymtotically stable periodic solution
repeat=4.2; %number of the simulation interval (multiple of t)
t1=0:dt:(tend*repeat);
[t2, x2]=ode23s(F, t1, x0);
peak=1+find(x2(2:end-1,1)>x2(1:end-2,1)&x2(2:end-1,1)>=x2(3:end,1));
peak0 = t2(peak(end)); % the last peak is used for reference
peak1 = x2(peak(end),1); % the last peak is used for reference

startk=peak(max(end-1,1));
endk=min(startk+round(mean(diff(peak)))+ceil(1/dt), length(t2));%1msec is extra
to=t2(startk:endk);
xo=x2(startk:endk,:);

%step2: computing Phi(T,0):the transition matrix
dx = 0.000001; dy = 0.000001;dz = 0.000001; dw = 0.000001; % for evaluation of Jacobian
Phi{1}=eye(length(x0)); % initial point;

for i=1:(length(to)-1) % integration
      A{i} = [(feval(F,0,xo(i,:)+[dx 0 0 0])-feval(F,0,xo(i,:)))/dx,...
         (feval(F,0,xo(i,:)+[0 dy 0 0])-feval(F,0,xo(i,:)))/dy,...
         (feval(F,0,xo(i,:)+[0 0 dz 0])-feval(F,0,xo(i,:)))/dz,...
         (feval(F,0,xo(i,:)+[0 0 0 dw])-feval(F,0,xo(i,:)))/dw];
      
   Phi{i+1} = expm(dt*A{i})*Phi{i}; %exponential euler
end;
i=i+1;
A{i} = [(feval(F,0,xo(i,:)+[dx 0 0 0])-feval(F,0,xo(i,:)))/dx,...
   (feval(F,0,xo(i,:)+[0 dy 0 0])-feval(F,0,xo(i,:)))/dy,...
   (feval(F,0,xo(i,:)+[0 0 dz 0])-feval(F,0,xo(i,:)))/dz,...
   (feval(F,0,xo(i,:)+[0 0 0 dw])-feval(F,0,xo(i,:)))/dw];


%step3 : set phi1(t)=dxo/dt
phi1=feval(F, 0, xo(1,:));


%step4 : set psi1(0) as an eigenvector of Phi(T,0)'
for k=1:70
   d0(:,k)=eig(Phi{end-k+1}');
end

[C,I]=min(abs(d0'-1));
[c2,i2]=min(C);
k0=I(i2);

Tk=length(to)-k0+1; %adjust the period
M0=Phi{Tk};   %the monodromy matrix

[v d]=eig(M0');
if(abs(d(1,1)-1)<abs(d(2,2)-1)) %if the eigenvalue is close to 1
   psi1(:,1)=v(:,1);
   set(htext_msg,'String',sprintf('eigenvalue:%1.3f',d(1,1)));
else
   psi1(:,1)=v(:,2);
   set(htext_msg,'String',sprintf('eigenvalue:%1.3f',d(2,2)));
end

psi1(:,1)=psi1(:,1)./(psi1(:,1)'*phi1);


%step5 : compute psi_1(t)
psi1(:,Tk)=psi1(:,1); % initial point; %give extra .5 sec

for i=Tk:-1:2 % backward integration
   psi1(:,i-1) = psi1(:,i) + dt*(A{i}'*psi1(:,i));
end;

prc=psi1';

% if(haxes==0 | ~ishandle(haxes))
%    return;
% end

% hold(handles.axes(handles.nowaxes),'off');
% plot(handles.axes(handles.nowaxes),(1:Tk)/Tk*2*pi, psi1(1,:));
% xlabel(handles.axes(handles.nowaxes),'phase');
% ylabel(handles.axes(handles.nowaxes),'phase response curve');



function dx = f_hh4d(t,x)
global global_Ibase;
dx = zeros(4,1); 
V=x(1); n=x(2); h=x(3); m=x(4);

%CM=1;%uF/cm^2
%VNa=115;VK=-12;Vl=10.613;%mV -- original values
ENa=50;EK=-77;El=-54.387;%mV
gnabar=120; gkbar=36; glbar=0.3; %m*mho/cm^2

%alphas and betas are computed based on 6.3oC temperature

%computing for n (potassium channel)
alphan=0.01*(-x(1)-55)/(exp((-x(1)-55)/10)-1);
betan=0.125*exp(-(x(1)+65)/80);
dx(2)=alphan*(1-x(2))-betan*x(2);

%computing for h (sodium closing)
alphah=0.07*exp(-(x(1)+65)/20);
betah=1/(exp((-x(1)-35)/10)+1);
dx(3)=alphah*(1-x(3))-betah*x(3);

%computing for m (sodium opening)
alpham=0.1*(-x(1)-40)/(exp((-x(1)-40)/10)-1);
betam=4*exp(-(x(1)+65)/18);
dx(4)=alpham*(1-x(4))-betam*x(4);

dx(1)=-(gnabar*x(4)^3*x(3)*(x(1)-ENa)+gkbar*x(2)^4*(x(1)-EK)+...
   glbar*(x(1)-El))+global_Ibase;

