%timeenc11.m
%Anmo Kim
%5/11/2009
%Morris-Lecar Model

function [tk v n]=timeenc11(g, E, Vhalf, tau, taun, Iext, dt, v0, n0)
%g : conductances [gL, gCa, gK]
%E : reversal potential [EL, ECa, EK]
%Vhalf : [Vhalf-Ca, Vhalf-K]
%tau : time constnat [tau-Ca, tau-K] in [msec]
%taun : time constnat for "recovery variable, n" in [msec]
%Iext : external current
%dt : time vector [msec]
%v0 : initial value for v
%n0 : initial value for n 

gL=g(1); gCa=g(2); gK=g(3);

EL=E(1); ECa=E(2); EK=E(3);

v=zeros(size(Iext));
n=zeros(size(Iext));
v(1)=v0;n(1)=n0; %initialize
for i=2:length(Iext)
    Vdot=Iext(i)-gL*(v(i-1)-EL)-gCa*(v(i-1)-ECa)./(1+exp((Vhalf(1)-v(i-1))./tau(1)))-gK*(v(i-1)-EK).*n(i-1);
    ndot=(1./(1+exp((Vhalf(2)-v(i-1))./tau(2)))-n(i-1))./taun;
    n(i)=n(i-1)+ndot.*dt;
    v(i)=v(i-1)+Vdot.*dt;
end

dout=pickpeaksonly(v, round(2/dt));
tk=find(dout>0);
    