function [tk vt]= timeenc2(ut, t, delta0, Omega, b,taur, htext_msg)
%timeenc2.m
%Anmo Kim
%Nov. 12th, 2008
%time encoding machine with refractory period - ideal(R=\infty) integrate and fire model
%tk : sequence of spike timings
%ut : input signal
%t : sampling interval
%delta0 : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%b : bias
%taur : refractory period in msec
%htext_msg : handles of text_msg gui interface to display warnings(optional)


%initialization part ------------------------------------------------------
tk=[];
vt=zeros(size(ut));

if(nargin<3)
   warn6('timeenc2: wrong input argumnents\n tk= timeenc2(ut, t, delta0)', htext_msg);
   return;
end

if(nargin<4) Omega=0; end
if(nargin<5) b=0; end
if(nargin<6) htext_msg=-1; end

% if(isempty(ut) | isempty(t) | isempty(delta0) | isempty(Omega) |isempty(b))
%    warn6('timeenc2: some input arguments are empty', htext_msg);
%    return;
% end


if(size(ut,1)>1)
   ut=ut';
end
if(size(ut,1)>1)
   warn6('timeenc2 : multiple ut vectors are not supported', htext_msg);
   ut=ut(1,:);
end


a=min(ut+b);

dt=t(2)-t(1);

refrack=round(taur/1000/dt);

%integrate and fire (no leakyness. i.e. R=\infty)
Ut = cumsum(ut+b)*dt; %biased and integrated
tk(1)=1;
vt=zeros(size(ut));

prevtk=1;
Ut=Ut+delta0(1);%
deltak=delta0(1);
while(1)
    if(length(Ut) >= prevtk+refrack)
        vt(prevtk+(1:(refrack)))=Ut(prevtk)-deltak;
        deltak=deltak+delta0(min(end,length(tk)))+Ut(prevtk+refrack)-Ut(prevtk);
    else
        break;
    end
    
    i=find(gt(Ut,deltak),1,'first');
    if(~isempty(i))
        tk=[tk i];
        vt((prevtk+refrack+1):i)=Ut((prevtk+refrack+1):i)-deltak+delta0(1);
    else
        vt((prevtk+refrack+1):end)=Ut((prevtk+refrack+1):end)-deltak+delta0(1);
        break;
    end
%    deltak=delta0(min(length(delta0), (1+length(tk))));
    prevtk = tk(end);
end


tk=t(tk);


if(Omega>0)
    r= mean(delta0)/a*Omega/pi;
    warn6(sprintf('timeenc2: ut is time encoded (ideal i&f model), r = %.2f, #spks=%d',r, length(tk)), htext_msg);
else
    warn6(sprintf('timeenc2: ut is time encoded (ideal i&f model),  #spks=%d',length(tk)), htext_msg);
end





%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end