function [tk vt]= timeenc3(ut, t, delta0,  b, R, C,Omega, htext_msg)
%timeenc3.m
%Anmo Kim
%Jan. 5th, 2009
%project-integrate-and-fire neuron
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%ut : input signal
%t : sampling interval
%delta0 : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%R : resistance
%C : capacitance
%htext_msg : handles of text_msg gui interface to display warnings(optional)


%initialization part ------------------------------------------------------
tk=[];
vt=zeros(size(ut));

if(nargin<3)
   warn6('timeenc1: wrong input argumnents\n tk= timeenc1(ut, t, delta0)', htext_msg);
   return;
end

if(nargin<4) b=0; end
if(nargin<5) R=inf; end
if(nargin<6) C=1; end
if(nargin<7) Omega=0; end
if(nargin<8) htext_msg=-1; end


% if(isempty(ut) | isempty(t) | isempty(delta0) | isempty(Omega))
%    warn6('timeenc1: some input arguments are empty', htext_msg);
%    return;
% end


if(size(ut,1)>1)
    ut=ut';
end

if(size(ut,1)>1)
   warn6('timeenc1 : multiple ut vectors are not supported yet', htext_msg);
   ut=ut(1,:);
end


ut=ut+b; %add bias

%ut=ut*10^-(12); %pA --> A

%delta0=delta0*10^-3; %mV --> V

a=min(ut);



%load hohu4dIbaseprc.mat
load hohu4dIbaseprc_direct
%Ibase, isi, dt, prc
dt0=dt*10^-3;
prc0=prc;
Ibase0=Ibase;

dt=t(2)-t(1);

prc=interp1((0:(size(prc0,2)-1))*dt0, prc0', 0:dt:(size(prc0,2)*dt0-dt0),'spline');
isik=(isi/dt/1000);

k=1;
tk=t(1);
while(k<=length(t))
    nextk=find(Ibase0>=ut(round(k)),1,'first');
    
    
    if(isempty(nextk))
        nextk=length(Ibase0);
    end
    if(nextk==1)
        nowprc=prc(:,1);
    else
        nowprc=(Ibase0(nextk)-ut(round(k)))/(Ibase0(nextk)-Ibase0(nextk-1))*prc(:,nextk)...
        +(ut(round(k))-Ibase0(nextk))/(Ibase0(nextk)-Ibase0(nextk-1))*prc(:,nextk-1);
    end
    
    nowisik=interp1(Ibase0, isik, ut(round(k)));
    
    if(length(t)<=nowisik+floor(k))
        break;
    end
    phaseshiftk=ut((1:round(nowisik))+round(k)-1)*nowprc(1:round(nowisik));
    
    nowisik=nowisik-phaseshiftk;
    
    k=k+nowisik;
    tk(end+1)=round(k)*dt+t(1);
        
end


vt=zeros(size(ut));
ti=round((tk-t(1))/dt)+1;
for i=1:(length(ti)-1)
    vt(ti(i):(ti(i+1)-1))=(0:(ti(i+1)-ti(i)-1))./(ti(i+1)-ti(i)-1);
end


prcibase=ut(ti);
save prcibase.mat prcibase


if(Omega>0)
    r= R*C*log(1-mean(delta0)/(mean(delta0)-a*R))*Omega/pi;
    warn6(sprintf('timeenc1: ut is time encoded (leaky i&f model), r = %.2f, #spks=%d',r, length(tk)), htext_msg);
else
    warn6(sprintf('timeenc1: ut is time encoded (leaky i&f model),  #spks=%d',length(tk)), htext_msg);
end




%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end