function [tk v]=timeenc4(ut, t, vpeak, vreset)
%quadratic integrate-and-fire neuron
%4/30/2009
%using forward euler method
%ut : input vector [unitless]
%t : time vector [in sec]
%vpeak : threshold [unitless]
%vreset : reset value [unitless]



v=zeros(size(t));
tk=[];

v(1)=vreset; %setting the initial condition
dt=(t(2)-t(1));

for i=2:length(t)
    %forward Euler
    v(i)=v(i-1)+dt*(ut(i-1)+v(i-1).^2);
    
    if(v(i)>=vpeak)
        v(i)=vreset;
        tk(end+1)=t(i);
    end
end

