function [tk v]=timeenc5(ut, t, a, b, vr, mr, vth, nfig)
%Izhikevich's simple model
%4/30/2009
%using forward euler method
%ut : input vector [unitless]
%t : time vector [in sec]
%system equaiton
%    v'=ut+v.^2-m
%    m'=a(b*v-m)
%    threshold is 1
%a : system parameter
%b : system parameter
%vr : reset value for v
%mr : reset value for m

tk=[];v=[];

if(nargin<7)
    return;
end

if(nargin<8)    nfig=0; end
if(nfig<0) nfig=0; end

if(nfig>0)
    hfig=figure(nfig);
    haxes1=findobj(hfig,'Type','Axes');
    if(length(haxes1)==2)
        haxes2=haxes1(2);
        haxes1=haxes1(1);
    else
        haxes1=subplot(211);
        haxes2=subplot(212);
    end
else
    haxes1=-1;
end

% vth=5;%threshold

v=zeros(size(t));
m=zeros(size(t));
v(1)=vr;m(1)=mr;%setting the initial condition
dt=(t(2)-t(1))*1000;
for i=2:length(t)
    %forward Euler
    m(i)=m(i-1)+dt*a*(b*v(i-1)-m(i-1));
    v(i)=v(i-1)+dt*(ut(i-1)+v(i-1).^2-m(i-1));
    
    if(v(i)>=vth)
        v(i)=vr;
        m(i)=m(i)+mr;
        tk(end+1)=t(i);
    end
end



if(ishandle(haxes1))
    I=mean(ut);
    x=linspace(min(v),vth*1.2,25);
    y=linspace(min(m),max(m),25)';
    X=x(ones(1,length(y)),:);
    Y=y(:,ones(1,length(x)));
    axes(haxes1);hold(haxes1,'off');
    plot(haxes1,v,m,'r');hold(haxes1,'on');
    quiver(X,Y,X.^2-Y+I, a*(b*X-Y),.1);
    y2=I+x.^2;
    plot(haxes1,x(y2<max(y)),y2(y2<max(y)),'k',x,x.*b,'k');drawnow;
    %axis(haxes1,[min(x) max(x) min(y) max(y)]);
    plot(haxes2,t,v);
end