function [tk vt]= timeenc6(ut, t, delta, Omega, taua, eta, htext_msg)
%timeenc6.m
%Anmo Kim
%Oct. 25th, 2006
%time encoding machine with ideal integrate and fire model in exponential adaptation
%mode
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%ut : input signal
%t : set of increasing sampling points i.e. [startt:dt:endt] (in sec)
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%taua : adaptation time constant(in sec)
%eta : adaptation factor
%htext_msg : handles of text_msg gui interface to display warnings(optional)


%initialization part ------------------------------------------------------
tk=[];
vt=zeros(size(ut));


if(nargin<6)
   disp('timeenc6: wrong input argumnents\n tk= timeenc6(ut, t, delta, Omega, taua, eta, htext_msg)');
   return;
end

if(nargin==6) htext_msg=[];end

if(isempty(ut) | isempty(t) | isempty(delta) | isempty(Omega))
   warn6('timeenc6: some input arguments are empty', htext_msg);
   return;
end


if(size(ut,1)>1)
   warn6('timeenc6 : multiple ut vectors are not supported yet', htext_msg);
   ut=ut(1,:);
end

a=min(ut);
r=delta/a*Omega/pi;

dt=t(2)-t(1);

%integrate and fire (no leakyness. i.e. R=\infty)
Ut = cumsum(ut)*dt;
DELTA=delta.*ones(1,length(ut));
prevDELTA=[];
while(1)
   
   if(isempty(tk)) prevtk=0;
   else prevtk = tk(end); end
 
   ii=find(gt(Ut,DELTA),1,'first');
   if(isempty(ii)) 
       vt((prevtk+1):end)=Ut((prevtk+1):end);%-prevDELTA;
       break; 
   else
      vt((prevtk+1):ii)=Ut((prevtk+1):ii);%-prevDELTA; 
      tk=[tk ii];
      Ut=Ut-Ut(ii);
      DELTA(tk(end):end)=DELTA(tk(end):end)+delta.*eta.*exp(-(t(tk(end):end)-t(tk(end)))/taua);
   end
end

%figure;plot(DELTA);
tk=t(tk);

warn6(sprintf('timeenc6: ut is time encoded (ideal i&f model with adaptation), r = %.2f???, #spks=%d',r, length(tk)), htext_msg);
   


%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end