function tk= timeenc7(ut, t, delta, Omega, gamma, eta, htext_msg)
%timeenc7.m
%Anmo Kim
%Nov. 4th, 2006
%time encoding machine with ideal integrate and fire model in reciprocal adaptation
%mode
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%ut : input signal
%t : set of increasing sampling points i.e. [startt:dt:endt] (in sec)
%delta : a spike threshold
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%gamma : adaptation time constant(in sec)
%eta : adaptation factor
%htext_msg : handles of text_msg gui interface to display warnings(optional)


%initialization part ------------------------------------------------------
tk=[];

if(nargin<6)
   disp('timeenc7: wrong input argumnents\n tk= timeenc7(ut, t, delta, Omega, gamma, eta, htext_msg)');
   return;
end

if(nargin==6) htext_msg=[];end

if(isempty(ut) | isempty(t) | isempty(delta) | isempty(Omega))
   warn6('timeenc7: some input arguments are empty', htext_msg);
   return;
end


if(size(ut,1)>1)
   warn6('timeenc7 : multiple ut vectors are not supported yet', htext_msg);
   ut=ut(1,:);
end

a=min(ut);
r=delta/a*Omega/pi;

dt=t(2)-t(1);

%integrate and fire (no leakiness. i.e. R=\infty)
Ut = cumsum(ut)*dt;
DELTA=delta.*ones(1,length(ut));
while(1)
   i=find(gt(Ut,DELTA),1,'first');
   if(isempty(i)) 
       break; 
   else
      tk=[tk i];
      Ut=Ut-Ut(i);
      DELTA((tk(end)+1):end)=DELTA((tk(end)+1):end)+delta.*eta./((t((tk(end)+1):end)-t(tk(end))).^gamma);
   end
end

figure;plot(DELTA);
tk=t(tk);

warn6(sprintf('timeenc7: ut is time encoded (ideal i&f model with adaptation), r = %.2f???, #spks=%d',r, length(tk)), htext_msg);
   


%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   disp(s);
   return;
end

if(isempty(htext_msg))
   disp(s);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   disp(s);
end