function varargout = timeenc8(varargin)
% TIMEENC8 M-file for timeenc8.fig
%      TIMEENC8, by itself, creates a new TIMEENC8 or raises the existing
%      singleton*.
%
%      H = TIMEENC8 returns the handle to a new TIMEENC8 or the handle to
%      the existing singleton*.
%
%      TIMEENC8('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TIMEENC8.M with the given input arguments.
%
%      TIMEENC8('Property','Value',...) creates a new TIMEENC8 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before timeenc8_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to timeenc8_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help timeenc8

% Last Modified by GUIDE v2.5 27-Jan-2007 15:16:52

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
    'gui_Singleton',  gui_Singleton, ...
    'gui_OpeningFcn', @timeenc8_OpeningFcn, ...
    'gui_OutputFcn',  @timeenc8_OutputFcn, ...
    'gui_LayoutFcn',  [] , ...
    'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before timeenc8 is made visible.
function timeenc8_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to timeenc8 (see VARARGIN)

% Choose default command line output for timeenc8
handles.output = hObject;

FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
if isempty(gcbf)
    ScreenUnits=get(0,'Units');
    set(0,'Units','pixels');
    ScreenSize=get(0,'ScreenSize');
    set(0,'Units',ScreenUnits);

    FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
    FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
else
    GCBFOldUnits = get(gcbf,'Units');
    set(gcbf,'Units','pixels');
    GCBFPos = get(gcbf,'Position');
    set(gcbf,'Units',GCBFOldUnits);
    FigPos(1:2) = [(GCBFPos(1) + GCBFPos(3) / 2) - FigWidth / 2, ...
        (GCBFPos(2) + GCBFPos(4) / 2) - FigHeight / 2];
end
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Make the GUI modal
set(handles.figure1,'WindowStyle','modal') %temporarily off !!!! make sure
%to put this back on

%anmo's code from here
%tk= timeenc8(handles.ut, handles.t, handles.b, handles.text_msg);
if(length(varargin)<4)
    delete(handles.figure1);
    return;
end

handles.ut = varargin{1};
handles.t = varargin{2}*1000;%sec --> msec
handles.b = varargin{3};
handles.text_msg0 = varargin{4};
handles.x0=[0 0.05 .4 0.5]'; %initial condition for [V m h n]

set(handles.pushbutton_hhif, 'Enable','off');

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes timeenc8 wait for user response (see UIRESUME)
uiwait(handles.figure1);






% --- Outputs from this function are returned to the command line.
function varargout = timeenc8_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure

if(isfield(handles,'tk'))
    varargout{1} = handles.tk/1000;
    varargout{2} = handles.vt;
    delete(handles.figure1);
    set(handles.text_msg0, 'String','timeenc8: hohu w/ m-coupling is completed');
else
    varargout{1} = [];
    varargout{2} = [];
    %    set(handles.text_msg0,'String','timeenc8: hohu w/ m-coupling is NOT completed');
end

%varargout{1} = handles.output;


% --- Executes on button press in pushbutton_ok.
function pushbutton_ok_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_ok (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if(~isfield(handles,'tk'))
    handles.tk=[];
    handles.vt=[];
end

guidata(hObject, handles);
uiresume(handles.figure1);





function edit_Iext_Callback(hObject, eventdata, handles)
% hObject    handle to edit_Iext (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit_Iext as text
%        str2double(get(hObject,'String')) returns contents of edit_Iext as a double





% --- Executes during object creation, after setting all properties.
function edit_Iext_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit_Iext (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





% --- Executes on button press in pushbutton_hh.
function pushbutton_hh_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_hh (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Iext=0;
Iext1=str2num(get(handles.edit_Iext,'String'));
if(~isempty(Iext1))
    if(length(Iext1)==1)
        if(Iext1>-30 & Iext1 <100)
            Iext=Iext1;
        end
    end
else
    set(handles.edit_Iext,'String', '0')
end



%ANmo Kim
%Jan. 26th, 2007
set(handles.text_msg, 'String', 'computing... hold on...');
drawnow;

[tk vt]=hohu(Iext, handles.t, handles.x0);


axes(handles.axes_hh);
plot(handles.t,vt);
hold on;
plot(tk, vt(ceil((tk-handles.t(1))/(handles.t(2)-handles.t(1)))), 'ro','MarkerSize',10);
hold off;
%handles.vt=vt;
%handles.tk=tk;
%====================================================================

set(handles.text_hh, 'String',...
    sprintf('I_{ext}=%.1f uA/cm^2', Iext));

set(handles.text_msg, 'String',...
    sprintf('hodgkin-huxley solution is plotted with constatnt external current %f uA/cm^2',...
    Iext));

guidata(hObject, handles);






% --- Executes on button press in pushbutton_hhmc.
function pushbutton_hhmc_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_hhmc (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
handles.Iext=0;

Iext=str2num(get(handles.edit_Iext,'String'));
if(~isempty(Iext))
    if(length(Iext)==1)
        if(Iext>-30 & Iext <100)
            handles.Iext=Iext;
        end
    end
else
    set(handles.edit_Iext,'String', '0')
end


%Hodgkin-Huxley w/ multiplicative coupling==============================
%ANmo Kim
%Jan. 26th, 2007
set(handles.text_msg, 'String', 'computing... hold on...');
drawnow;

[tk vt]=hohumc(handles.ut+handles.b, handles.t, handles.Iext, handles.x0);
axes(handles.axes_hhmc);
plot(handles.t,vt);
hold on;
plot(tk, vt(ceil((tk-handles.t(1))/(handles.t(2)-handles.t(1)))), 'ro','MarkerSize',10);
hold off;
handles.vt=vt;
handles.tk=tk;
%====================================================================

set(handles.text_hhmc, 'String',...
    sprintf('I_{ext}=%.1f uA/cm^2', handles.Iext));

set(handles.text_msg, 'String',...
    'a solution of the hodgkin-huxley neuron w/ multiplicative coupling is plotted');

set(handles.pushbutton_hhif, 'Enable','on');
guidata(hObject, handles);




% --- Executes on button press in pushbutton_hhif.
function pushbutton_hhif_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_hhif (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)



set(handles.text_msg, 'String', 'integrate-and-fire : computing thresholds... hold on...');
drawnow;

tk =hohu(handles.Iext, handles.t, handles.x0, length(handles.tk));

delta=diff([handles.t(1) tk])/1000;
tk=[];
set(handles.text_msg, 'String', 'integrate-and-fire : running integrate-and-fire... hold on...');
drawnow;
[tk vt]=timeenc0(handles.ut, handles.t/1000, delta, 0, handles.b, handles.text_msg);

axes(handles.axes_hhif);
plot(handles.t,vt);
hold on;
plot(tk*1000, vt(ceil((tk*1000-handles.t(1))/(handles.t(2)-handles.t(1)))), 'ro','MarkerSize',10);
hold off;
%====================================================================

set(handles.text_hh, 'String',...
    sprintf('I_{ext}=%.1f uA/cm^2', handles.Iext));

set(handles.text_msg, 'String',...
    'solution for the integrate-and-fire neuron w/ variable threshold is plotted');

guidata(hObject, handles);









function [tk vt]=hohu(Iext, t, x0, nspks0)
%hohu.m
%Anmo Kim
%Jan. 26th, 2006
%hodgkin-huxley neuron with input ut with exponential euler
%Iext : input signal
%t : vector of sampling timing
%x0 : initial condition
%nspks0 : number of spikes
% tk : a vector of spike timing
% vt : membrane potential

tk=[]; vt=[];

if(nargin<3)
    disp('too few input arguments');
    return;
end

if(nargin<4) nspks0=0;end
if(nspks0<0) nspks0=0;end

if(~isvector(length(Iext)))
    disp('x0 shoulbe be a vector');
    return;
end       
    

if(~isvector(x0) | length(x0)~=4)
    disp('x0 should be a 4x1 vector');
    return;
end



%x=hhosc_ee(t, ones(size(t))*Iext, x0, nspks);

V=zeros(size(t));
m=zeros(size(t));
h=zeros(size(t));
n=zeros(size(t));

%computing V (membrane potential)
%CM=1;%uF/cm^2
VNa=115;VK=-12;Vl=10.613;%mV -- original values
%ENa=50;EK=-77;El=-54.387;%mV
gnabar=120; gkbar=36; glbar=0.3; %m*mho/cm^2

V(1)=x0(1); m(1)=x0(2); h(1)=x0(3); n(1)=x0(4);

dt=t(2)-t(1);

if(nspks0==0)
    for k=1:(length(t)-1)

        %alphas and betas are based on 6.3oC temperature
        

        %computing h (sodium closing)
        alphah=0.07*exp(-V(k)/20);
        betah=1/(exp((-V(k)+30)/10)+1);
        ah=1/(1+betah/alphah);
        h(k+1)=ah+(h(k)-ah)*exp(-dt*(betah+alphah));


        %computing n (potassium channel)
        alphan=0.01*(-V(k)+10)/(exp((-V(k)+10)/10)-1);
        betan=0.125*exp(-V(k)/80);
        an=1/(1+betan/alphan);
        n(k+1)=an+(n(k)-an)*exp(-dt*(betan+alphan));

        %computing m (sodium opening)
        alpham=0.1*(-V(k)+25)/(exp((-V(k)+25)/10)-1);
        betam=4*exp(-V(k)/18);
        am=1/(1+betam/alpham);
        m(k+1)=am+(m(k)-am)*exp(-dt*(betam+alpham));


        gna=gnabar*m(k)^3*h(k);
        gk=gkbar*n(k)^4;
        tauV=1/(gna+gk+glbar);
        aV=(Iext(min(length(Iext),k))+gna*VNa+gk*VK+glbar*Vl)*tauV;
        V(k+1)=aV+(V(k)-aV)*exp(-dt/tauV);
    end

else
    k=1; nspks1=0;
    while(1)

            %alphas and betas are based on 6.3oC temperature
            %computing m (sodium opening)
            alpham=0.1*(-V(k)+25)/(exp((-V(k)+25)/10)-1);
            betam=4*exp(-V(k)/18);
            am=1/(1+betam/alpham);
            m(k+1)=am+(m(k)-am)*exp(-dt*(betam+alpham));


            %computing h (sodium closing)
            alphah=0.07*exp(-V(k)/20);
            betah=1/(exp((-V(k)+30)/10)+1);
            ah=1/(1+betah/alphah);
            h(k+1)=ah+(h(k)-ah)*exp(-dt*(betah+alphah));


            %computing n (potassium channel)
            alphan=0.01*(-V(k)+10)/(exp((-V(k)+10)/10)-1);
            betan=0.125*exp(-V(k)/80);
            an=1/(1+betan/alphan);
            n(k+1)=an+(n(k)-an)*exp(-dt*(betan+alphan));


            gna=gnabar*m(k)^3*h(k);
            gk=gkbar*n(k)^4;
            tauV=1/(gna+gk+glbar);
            aV=(Iext(min(length(Iext),k))+gna*VNa+gk*VK+glbar*Vl)*tauV;
            V(k+1)=aV+(V(k)-aV)*exp(-dt/tauV);

        if(m(k)<0.8 & m(k+1)>=0.8) %sodium activation -> spike detected
            nspks1=nspks1+1;
        end
        k=k+1;
        if(nspks1>nspks0) break; end
    end
    t=(0:(length(V)-1))*dt+t(1);
end

% if(size(V,1)>1)
%     x=[V m h n]';
% else
%     x=[V;m;h;n];
% end


% vt=x(1,:);

Vhigh=V;
Vhigh(Vhigh<(max(V)-min(V))/2)=0;

peaks=pickpeaksonly(Vhigh, 2/(t(2)-t(1))); %minimum ISI is 2msec
tk=t(peaks>0);
vt=V;





function [dout, diam] = pickpeaksonly(din, maxn)
%pickpeaksonly
%Anmo Kim
%May 17th 2006
%pick high peaks only. other values ripped down to zero
%Arguments
%d1 : a row vector, which is the data to be searched
%maxn : maximum interval of non-zero value interval
%dout : 'peaks picked' version of d1

d1=din;

d1(find(d1<0))=0;

z=d1;
z(find(z>0))=1; %all positive values are forced to be 1

z1=diff(z);
% e.g. z = [ 0  1 0 1 1  1 0 0 0 1  1 0];
%      z1= [ 1 -1 1 0 0 -1 0 0 1 0 -1 0];
zstart = find(eq(z1,1))+1;
zend = find(eq(z1,-1));

diam=zeros(size(d1));

if(isempty(zend))
    [dout diam]=pickmaxonly(d1,maxn);
    return;
end;

if(zend(1) < zstart(1))
    [d1(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
    zend=zend(2:end);
end;


for k=1:length(zend)
    %    if(k==16)
    %       disp('k=16');
    %    end
    [d1(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
end;

if (length(zstart)>length(zend))
    [d1(zstart(end):end) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):end),maxn);
end;

% hist(d1(find(ne(d1,0))),50); pause;
% plot(d1); pause;
dout = d1;


%post processing : merging too close spikes
kk = find(ne(dout,0));
ii = find(le(diff(kk),maxn));

for k=1:length(ii)
    if (dout(kk(ii(k))) < dout(kk(ii(k)+1)))
        dout(kk(ii(k)))=0;
        diam(kk(ii(k)+1))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
    else
        dout(kk(ii(k)+1))=0;
        diam(kk(ii(k)))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
    end
end














function [dout, diam] = pickmaxonly(din, maxn)
%maxonly.m
%Anmo Kim
%May 16th, 2006
%description : taking the max value only within the given interval
%              other values are dropped to zero
%              if the given interval is greater than the tmax, it's chopped
%              into multiple intervals

nlevels=50;

d1=din;

if(size(d1,2)~=1)
    d1=d1';
end;

if(size(d1,2)~=1)
    disp('d1 needs be a vector, not a matrix');
    dout=[];
    diam=[];
    return;
end;

if(size(d1)==[1 1])
    dout = din;
    diam=1;
    return;
end


dout=zeros(size(din));
diam=zeros(size(din));

if (length(d1)<=maxn)
    [c, i]=max(d1);
    dout(i)=c;
    diam(i)=length(d1);

else
    delta = ones(length(d1), nlevels);
    delta=cumsum(delta,2)-1;
    delta=delta/nlevels*max(d1);

    d1=d1*ones(1,nlevels);

    higher=gt(d1,delta);
    z=diff(higher,1,1);

    kdelta=[];
    higher_area=[];
    nvaliddelta=0;
    for k=1:nlevels
        zstart=find(eq(z(:,k),1))+1;
        zend=find(eq(z(:,k),-1));

        if(isempty(zend) | isempty(zstart)) continue; end;

        if(zend(1) > zstart(end)) continue; end; %if no groove

        if(length(zstart)>2 | length(zend)>2) continue; end; %if there are more than two hills

        higher_area(nvaliddelta+1) = sum(higher(:,1)>delta(1,k));
        kdelta(nvaliddelta+1)=k;

    end;


    if(isempty(kdelta)) %no groove at all (a single valley)
        [c, i]=max(d1);
        dout(i)=c;
        diam(i)=length(d1);
        return;

    else
        [c, i]=min(higher_area);
        zstart=find(eq(z(:,kdelta(i)),1))+1;
        zend=find(eq(z(:,kdelta(i)),-1));

        if(zend(1) < zstart(1))
            [dout(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
            zend=zend(2:end);
        end;

        for k=1:length(zend)
            [dout(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
        end;

        if (length(zstart)>length(zend))
            [dout(zstart(end):length(din)) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):length(din)),maxn);
        end;
    end;
end;










function [tk vt]=hohumc(ut, t, Iext, y0)
%hohumc.m
%Anmo Kim
%Jan. 27th, 2006
%hodgkin-huxley neuron with multiplicative coupling (input ut)
%ut : input signal
%t : vector of sampling timing
%Iext : base external current
%x0 : initial condition
% tk : a vector of spike timing
% vt : membrane potential

tk=[]; vt=[];

if(~isvector(y0) | length(y0)~=4)
    disp('y0 should be a 4x1 vector');
    return;
end


if(length(ut)~=length(t))
    disp('the length of ut and t must be the same');
    return;
end


%computing V (membrane potential)
%CM=1;%uF/cm^2
VNa=115;VK=-12;Vl=10.613;%mV -- original values
%ENa=50;EK=-77;El=-54.387;%mV
gnabar=120; gkbar=36; glbar=0.3; %m*mho/cm^2

V(1)=y0(1); m(1)=y0(2); h(1)=y0(3); n(1)=y0(4);

dt=(t(2)-t(1));

for k=1:(length(t)-1)

    uk=ut(min(length(ut),k));
    
    %alphas and betas are based on 6.3oC temperature
    %computing m (sodium opening)
    alpham=0.1*(-V(k)+25)/(exp((-V(k)+25)/10)-1);
    betam=4*exp(-V(k)/18);
    am=1/(1+betam/alpham);
    m(k+1)=am+(m(k)-am)*exp(-dt*(betam+alpham)*uk);


    %computing h (sodium closing)
    alphah=0.07*exp(-V(k)/20);
    betah=1/(exp((-V(k)+30)/10)+1);
    ah=1/(1+betah/alphah);
    h(k+1)=ah+(h(k)-ah)*exp(-dt*(betah+alphah)*uk);


    %computing n (potassium channel)
    alphan=0.01*(-V(k)+10)/(exp((-V(k)+10)/10)-1);
    betan=0.125*exp(-V(k)/80);
    an=1/(1+betan/alphan);
    n(k+1)=an+(n(k)-an)*exp(-dt*(betan+alphan)*uk);


    gna=gnabar*m(k)^3*h(k);
    gk=gkbar*n(k)^4;
    tauV=1/(gna+gk+glbar)/uk;
    aV=(Iext+gna*VNa+gk*VK+glbar*Vl)/(gna+gk+glbar);
    V(k+1)=aV+(V(k)-aV)*exp(-dt/tauV);
end


vthigh=V;
vthigh(vthigh<(max(V)-min(V))/2)=0;

peaks=pickpeaksonly(vthigh, 2/dt); %minimum ISI is 2msec
tk=t(peaks>0);
vt=V;






% function xdot=hhosc_fe(x)
% %hhosc_fe.m
% %Anmo Kim
% %Jan. 25, 2007
% %Hodgkin-Huxley oscillator building block using forward euler method
% % for the time encoding machine with multiplicative coupling
% %All parameters in this code come from Hodgkin & Huxley 1952 JPhysiology
% xdot=[];
% 
% if(size(x,1)~=1 & size(x,2)~=1)
%     disp('input vector should be a 4x1 vector');
%     return;
% end
% 
% if(size(x,1)~=4 & size(x,2)~=4)
%     disp('input vector should be a 4x1 vector');
%     return;
% end
% 
% V=x(1); m=x(2); h=x(3); n=x(4);
% 
% %alphas and betas are based on 6.3oC temperature
% %computing for m (sodium opening)
% alpham=0.1*(-V+25)/(exp((-V+25)/10)-1);
% betam=4*exp(-V/18);
% mdot=alpham*(1-m)-betam*m;
% 
% %computing for h (sodium closing)
% alphah=0.07*exp(-V/20);
% betah=1/(exp((-V+30)/10)+1);
% hdot=alphah*(1-h)-betah*h;
% 
% %computing for n (potassium channel)
% alphan=0.01*(-V+10)/(exp((-V+10)/10)-1);
% betan=0.125*exp(-V/80);
% ndot=alphan*(1-n)-betan*n;
% 
% %computing for V (membrane potential)
% %CM=1;%uF/cm^2
% VNa=115;VK=-12;Vl=10.613;%mV -- original values
% %ENa=50;EK=-77;El=-54.387;%mV
% gnabar=120; gkbar=36; glbar=0.3; %m*mho/cm^2
% Vdot=-(gnabar*m^3*h*(V-VNa)+gkbar*n^4*(V-VK)+glbar*(V-Vl));%/CM;
% 
% 
% xdot=[Vdot mdot hdot ndot];
% if(size(x,1)~=size(xdot,1))
%     xdot=xdot';
% end
% 
% 



% function x=hhosc_ee(t, ut, x0, nspks0)
% %hhosc_ee.m
% %Anmo Kim
% %Jan. 31, 2007
% %Hodgkin-Huxley oscillator building block using exponential euler method
% % for the time encoding machine with multiplicative coupling
% %All parameters in this code come from Hodgkin & Huxley 1952 JPhysiology
% x=[];
% 
% if(nargin<3)
%     disp('too few input arguments');
%     return;
% end
% 
% if(nargin<4) nspks0=0;end
% 
% if(nspks0<0) nspks0=0;end
% 
% 
% if(~isvector(t) | length(t)<2)
%     disp('t should be a vector having more than one element');
%     return;
% end
% 
% if(~isvector(x0) | length(x0)~=4)
%     disp('x0 should be a 4x1 vector');
%     return;
% end
% 

