function [tk vt nhm]= timeenc9(ut, t, Ibase, htext_msg,x0)
%timeenc9.m - Hodgkin-Huxley 4dimensional
%Anmo Kim
%May 3rd, 2007
%Hodgkin-Huxley neuron
%input is assumed to be absolutely positive and has an infimum $a >0$
%tk : sequence of spike timings
%ut : input signal
%t : sampling interval
%Ibase : base current
%htext_msg : handles of text_msg gui interface to display warnings(optional)

if(nargin<5)
    x0=[29.5457    0.5471    0.2463    0.8683];
end

if(nargin<4)
    htext_msg=0;
end

x=hohu4d(t, x0, ut+Ibase);
%figure(1);plot(x');
%detect spikes
maxn=ceil(5/(t(2)-t(1))/1000); %minimum interspike interval : 5msec
peaks=pickpeaksonly(x(1,:)+30, maxn);

peakk=find(peaks>0);

tk=t(peakk);
vt=x(1,:);
nhm=x(2:4,:);




function x=hohu4d(t, x0, ut, method)
%4 dimensional hodgkin-huxley
V=x0(1); n=x0(2); h=x0(3); m=x0(4);
if(size(ut,1)==4)
   Iin=ut(1,:);
   ni=ut(2,:);
   hi=ut(3,:);
   mi=ut(4,:);
else
   Iin=ut(1,:);
   ni=zeros(size(Iin));
   hi=zeros(size(Iin));
   mi=zeros(size(Iin));
end

t=t*1000; %sec --> msec

%CM=1;%uF/cm^2
%VNa=115;VK=-12;Vl=10.613;%mV -- original values
ENa=50;EK=-77;El=-54.387;%mV
gnabar=120; gkbar=36; glbar=0.3; %m*mho/cm^2

% if(nargin==3) method='forward'; end
%
% switch lower(method)
%    case 'forward'
%       x(:,1)=x0';
%       for k=1:(length(t)-1)
%          dt=t(k+1)-t(k);
%          dx=f_hh4d(0, x(:,k),Iin(k));
%          x(:,k+1)=x(:,k)+dx*dt;
%       end
%    case 'exponential'
%      Iin=Iin+35; %35pA
for k=1:(length(t)-1)
   dt=t(k+1)-t(k);
   %alphas and betas are based on 6.3oC temperature

   %computing for h (sodium closing)
   alphah=0.07*exp(-(V(k)+65)/20);
   betah=1/(exp((-V(k)-35)/10)+1);
   ah=(alphah+hi(k))/(betah+alphah);
   h(k+1)=ah+(h(k)-ah)*exp(-dt*(betah+alphah));

   %computing for n (potassium channel)
   alphan=0.01*(-V(k)-55)/(exp((-V(k)-55)/10)-1);
   betan=0.125*exp(-(V(k)+65)/80);
   an=(alphan+ni(k))/(betan+alphan);
   n(k+1)=an+(n(k)-an)*exp(-dt*(betan+alphan));

   %computing for m (sodium opening)
   alpham=0.1*(-V(k)-40)/(exp((-V(k)-40)/10)-1);
   betam=4*exp(-(V(k)+65)/18);
   am=(alpham+mi(k))/(betam+alpham);
   m(k+1)=am+(m(k)-am)*exp(-dt*(betam+alpham));


   gna=gnabar*m(k)^3*h(k);
   gk=gkbar*n(k)^4;
   tauV=1/(gna+gk+glbar);
   %   aV=(Iext(min(length(Iext),k))+gna*VNa+gk*VK+glbar*Vl)*tauV;
   aV=(Iin(k)+gna*ENa+gk*EK+glbar*El)*tauV;
   V(k+1)=aV+(V(k)-aV)*exp(-dt/tauV);
end
x=[V; n; h; m;];

% end



function [dout, diam] = pickpeaksonly(din, maxn)
%pickpeaksonly
%Anmo Kim
%May 17th 2006
%pick high peaks only. other values ripped down to zero
%Arguments
%d1 : a row vector, which is the data to be searched
%maxn : maximum interval of non-zero value interval
%dout : 'peaks picked' version of d1

d1=din;

d1(find(d1<0))=0;

z=d1;
z(find(z>0))=1; %all positive values are forced to be 1

z1=diff(z);
% e.g. z = [ 0  1 0 1 1  1 0 0 0 1  1 0];
%      z1= [ 1 -1 1 0 0 -1 0 0 1 0 -1 0];
zstart = find(eq(z1,1))+1;
zend = find(eq(z1,-1));

diam=zeros(size(d1));

if(isempty(zend))
   [dout diam]=pickmaxonly(d1,maxn);
   return;
elseif(isempty(zstart))
    zstart=1;
end;

if(zend(1) < zstart(1))
   [d1(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
   zend=zend(2:end);
end;


for k=1:length(zend)
   %    if(k==16)
   %       disp('k=16');
   %    end
   [d1(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
end;

if (length(zstart)>length(zend))
   [d1(zstart(end):end) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):end),maxn);
end;

% hist(d1(find(ne(d1,0))),50); pause;
% plot(d1); pause;
dout = d1;


%post processing : merging too close spikes
kk = find(ne(dout,0));
ii = find(le(diff(kk),maxn));

for k=1:length(ii)
   if (dout(kk(ii(k))) < dout(kk(ii(k)+1)))
      dout(kk(ii(k)))=0;
      diam(kk(ii(k)+1))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
   else
      dout(kk(ii(k)+1))=0;
      diam(kk(ii(k)))=diam(kk(ii(k)+1))+diam(kk(ii(k)));
   end
end








function [dout, diam] = pickmaxonly(din, maxn)
%maxonly.m
%Anmo Kim
%May 16th, 2006
%description : taking the max value only within the given interval
%              other values are dropped to zero
%              if the given interval is greater than the tmax, it's chopped
%              into multiple intervals

nlevels=50;

d1=din;

if(size(d1,2)~=1)
   d1=d1';
end;

if(size(d1,2)~=1)
   disp('d1 needs be a vector, not a matrix');
   dout=[];
   diam=[];
   return;
end;

if(size(d1)==[1 1])
   dout = din;
   diam=1;
   return;
end


dout=zeros(size(din));
diam=zeros(size(din));

if (length(d1)<=maxn)
   [c, i]=max(d1);
   dout(i)=c;
   diam(i)=length(d1);

else
   delta = ones(length(d1), nlevels);
   delta=cumsum(delta,2)-1;
   delta=delta/nlevels*max(d1);

   d1=d1*ones(1,nlevels);

   higher=gt(d1,delta);
   z=diff(higher,1,1);

   kdelta=[];
   higher_area=[];
   nvaliddelta=0;
   for k=1:nlevels
      zstart=find(eq(z(:,k),1))+1;
      zend=find(eq(z(:,k),-1));

      if(isempty(zend) || isempty(zstart)) continue; end;

      if(zend(1) > zstart(end)) continue; end; %if no groove

      if(length(zstart)>2 || length(zend)>2) continue; end; %if there are more than two hills

      higher_area(nvaliddelta+1) = sum(higher(:,1)>delta(1,k));
      kdelta(nvaliddelta+1)=k;

   end;


   if(isempty(kdelta)) %no groove at all (a single valley)
      [c, i]=max(d1);
      dout(i)=c;
      diam(i)=length(d1);
      return;

   else
      [c, i]=min(higher_area);
      zstart=find(eq(z(:,kdelta(i)),1))+1;
      zend=find(eq(z(:,kdelta(i)),-1));

      if(zend(1) < zstart(1))
         [dout(1:zend(1)) diam(1:zend(1))]=pickmaxonly(d1(1:zend(1)), maxn);
         zend=zend(2:end);
      end;

      for k=1:length(zend)
         [dout(zstart(k):zend(k)) diam(zstart(k):zend(k))]=pickmaxonly(d1(zstart(k):zend(k)),maxn);
      end;

      if (length(zstart)>length(zend))
         [dout(zstart(end):length(din)) diam(zstart(end):end)]=pickmaxonly(d1(zstart(end):length(din)),maxn);
      end;
   end;
end;


