function varargout = viewinf(varargin)
% VIEWINF M-file for viewinf.fig
%      VIEWINF, by itself, creates a new VIEWINF or raises the existing
%      singleton*.
%
%      H = VIEWINF returns the handle to a new VIEWINF or the handle to
%      the existing singleton*.
%
%      VIEWINF('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VIEWINF.M with the given input arguments.
%
%      VIEWINF('Property','Value',...) creates a new VIEWINF or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before viewinf_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to viewinf_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help viewinf

% Last Modified by GUIDE v2.5 17-Jan-2008 14:06:26

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
   'gui_Singleton',  gui_Singleton, ...
   'gui_OpeningFcn', @viewinf_OpeningFcn, ...
   'gui_OutputFcn',  @viewinf_OutputFcn, ...
   'gui_LayoutFcn',  [] , ...
   'gui_Callback',   []);
if nargin && ischar(varargin{1})
   gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
   [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
   gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before viewinf is made visible.
function viewinf_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to viewinf (see VARARGIN)

handles.output = 'Yes';

% Update handles structure
guidata(hObject, handles);

% Insert custom Title and Text if specified by the user
% Hint: when choosing keywords, be sure they are not easily confused
% with existing figure properties.  See the output of set(figure) for
% a list of figure properties.
% if(nargin > 3)
%    for index = 1:2:(nargin-3),
%       if nargin-3==index, break, end
%       switch lower(varargin{index})
%          case 'title'
%             set(hObject, 'Name', varargin{index+1});
%          case 'string'
%             set(handles.text1, 'String', varargin{index+1});
%       end
%    end
% end

% Determine the position of the dialog - centered on the callback figure
% if available, else, centered on the screen
FigPos=get(0,'DefaultFigurePosition');
OldUnits = get(hObject, 'Units');
set(hObject, 'Units', 'pixels');
OldPos = get(hObject,'Position');
FigWidth = OldPos(3);
FigHeight = OldPos(4);
if isempty(gcbf)
   ScreenUnits=get(0,'Units');
   set(0,'Units','pixels');
   ScreenSize=get(0,'ScreenSize');
   set(0,'Units',ScreenUnits);

   FigPos(1)=1/2*(ScreenSize(3)-FigWidth);
   FigPos(2)=2/3*(ScreenSize(4)-FigHeight);
else
   GCBFOldUnits = get(gcbf,'Units');
   set(gcbf,'Units','pixels');
   GCBFPos = get(gcbf,'Position');
   set(gcbf,'Units',GCBFOldUnits);
   FigPos(1:2) = [(GCBFPos(1) + GCBFPos(3) / 2) - FigWidth / 2, ...
      (GCBFPos(2) + GCBFPos(4) / 2) - FigHeight / 2];
end
FigPos(3:4)=[FigWidth FigHeight];
set(hObject, 'Position', FigPos);
set(hObject, 'Units', OldUnits);

% Make the GUI modal
%set(handles.figure1,'WindowStyle','modal')

if(nargin<1)
    return;
end
if(isempty(varargin{1}))
    return;
end
if(~ishandle(varargin{1}))
    return;
end
handles.h0 = guidata(varargin{1});

%Anmo's code from here
files=dir('*.xls');
nfile1=length(files);
if(nfile1>0)
   for k=1:nfile1
      xlsfnames(k)={files(k).name};
   end
end

nfile2=0;
pwdvar=pwd;
if(strcmp(pwdvar((end-1):end), '\m') || strcmp(pwdvar((end-1):end), '/m'))
   files2=dir('../*.xls');
   nfile2=length(files2);
   for kk=1:nfile2
      files2(kk).name=strcat('../',files2(kk).name);
      xlsfnames(nfile1+kk)={files2(kk).name};
   end
end

if(nfile1+nfile2==0)
   set(handles.popupmenu_flist,'String', 'no xls files', 'Enable', 'off');
   set(handles.pushbutton_loadit, 'Enable', 'off');
   return;
else
   set(handles.popupmenu_flist,'String', xlsfnames);
end

set(handles.pushbutton_prev,'Enable','off');
set(handles.pushbutton_next,'Enable','off');
% set(handles.pushbutton_findvalve1  ,'Enable','off');
% set(handles.pushbutton_findvalveall  ,'Enable','off');
% set(handles.pushbutton_moveleft  ,'Enable','off');
% set(handles.pushbutton_moveright  ,'Enable','off');
set(handles.listbox_files2bupdated  ,'Enable','off');
% set(handles.pushbutton_update  ,'Enable','off');


handles.nowfile=0; %the index of the file displayed on the axes_valveopen
handles.dt=0.1; %default sampling interval (used when 'dt' is not found in the data file)
guidata(hObject, handles);




















% --- Outputs from this function are returned to the command line.
function varargout = viewinf_OutputFcn(hObject, eventdata, handles)
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in popupmenu_flist.
function popupmenu_flist_Callback(hObject, eventdata, handles)
% hObject    handle to popupmenu_flist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns popupmenu_flist contents as cell array
%        contents{get(hObject,'Value')} returns selected item from popupmenu_flist
% contents = get(hObject,'String');
% readinfoxls(hObject, handles, contents{get(hObject,'Value')});



% --- Executes during object creation, after setting all properties.
function popupmenu_flist_CreateFcn(hObject, eventdata, handles)
% hObject    handle to popupmenu_flist (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
   set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pushbutton_close.
function pushbutton_close_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_close (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
delete(gcf);



% --- Executes on selection change in listbox_files2bupdated.
function listbox_files2bupdated_Callback(hObject, eventdata, handles)
% hObject    handle to listbox_files2bupdated (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns listbox_files2bupdated contents as cell array
%        contents{get(hObject,'Value')} returns selected item from listbox_files2bupdated


val = get(hObject,'Value');
if(handles.nowfile == val)
   return;
end

switchto(hObject, eventdata, handles);
 
handles.nowfile=val;
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function listbox_files2bupdated_CreateFcn(hObject, eventdata, handles)
% hObject    handle to listbox_files2bupdated (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
   set(hObject,'BackgroundColor','white');
end




% % --- Executes on button press in pushbutton_update.
% function pushbutton_update_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton_update (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% dt= 0.1;
% validfileks2=[];
% set(hObject, 'enable', 'off');
% drawnow;
% for k=1:length(handles.finfo)
%    fname=cell2mat(handles.fnames(k));
%    stimdur=handles.stimdur(k);
%    stimstart=handles.stimstart(k);
%    pp=handles.pp(k);
%    etc=cell2mat(handles.etc(k));
%    celltype=cell2mat(handles.celltype(k));
%    valve_open0=handles.valve_open0(k);
%    Iin=handles.Iin{k}(1);
% 
%    if(exist(fname,'file'))
%       %      load(fname, 'd');
%       save(fname, 'fname', 'stimstart', 'stimdur', 'celltype', 'pp', 'etc', 'dt', 'Iin', 'valve_open0', '-append');
%       if(valve_open0~=0)
%          save(fname, 'valve_open0', '-append')
%       end
%       set(handles.text_msg, 'String', strcat(fname, ' is being updated'));
%       drawnow;
%       validfileks2=[validfileks2 k];
%    end
%    
%    if(strcmp(lower(etc),'episodic'))
%       fname0=fname;
%       for ii=1:size(handles.Iin{k},2)
%          fname = strcat(fname0(1:(end-5)), char(fname0(end-4)+ii), '.mat');
%          Iin=handles.Iin{k}(ii);
%          if(exist(fname,'file'))
%             save(fname, 'fname', 'stimstart', 'stimdur', 'celltype', 'pp', 'etc', 'dt', 'Iin', 'valve_open0', '-append');
% %             if(valve_open0~=0)
% %                save(fname, 'valve_open0', '-append')
% %             end
%             set(handles.text_msg, 'String', strcat(fname, ' is being updated'));
%             drawnow;
%          end
%       end
%    end
% end
% 
% 
% handles.fnames=handles.fnames(validfileks2);
% handles.stimstart=handles.stimstart(validfileks2);
% handles.stimdur=handles.stimdur(validfileks2);
% handles.celltype=handles.celltype(validfileks2);
% handles.pp=handles.pp(validfileks2);
% handles.etc=handles.etc(validfileks2);
% 
% set(handles.text_msg, 'String', strcat(num2str(length(handles.finfo)), ' files have been updated'));
% %set(handles.listbox_files2bupdated, 'String', handles.fnames);
% %---------------------------------
% guidata(hObject, handles);
% set(hObject, 'enable', 'on');





% 
% % --- Executes on button press in pushbutton_findvalveall.
% function pushbutton_findvalveall_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton_findvalveall (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% for kfile=1:length(handles.finfo)
%    set(handles.listbox_files2bupdated, 'Value', kfile);
%    drawnow;
%    handles.valve_open0(kfile)=find_valve_open0(hObject, eventdata, handles);
% end
% handles.nowfile=length(handles.finfo);
% guidata(hObject, handles);
% 


% --- Executes on button press in pushbutton_prev.
function pushbutton_prev_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_prev (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.listbox_files2bupdated, 'Value', max(get(handles.listbox_files2bupdated, 'Value')-1,1));
switchto(hObject, eventdata, handles);




% --- Executes on button press in pushbutton_next.
function pushbutton_next_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_next (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.listbox_files2bupdated, 'Value', min(get(handles.listbox_files2bupdated, 'Value')+1,length(handles.finfo)));
switchto(hObject, eventdata, handles);








% % --- Executes on button press in pushbutton_findvalve1.
% function pushbutton_findvalve1_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton_findvalve1 (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% handles.valve_open0(handles.nowfile)=find_valve_open0(hObject, eventdata, handles);
% guidata(hObject, handles);
% 
% 
% 
% 
% % --- Executes on button press in pushbutton_moveleft.
% function pushbutton_moveleft_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton_moveleft (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% if(~isfield(handles, 'fnames'))
%    return;
% end
% kfile=get(handles.listbox_files2bupdated, 'Value');
% fname=cell2mat(handles.fnames(kfile));
% 
% if(exist(fname,'file'))
%    load(fname, 'd');
% 
%    warning off;
%    load(fname, 'dt');
%    warning on;
%    if(~exist('dt','var')) dt=handles.dt; end
% 
%    stimstart=handles.stimstart(kfile);
% 
%    if(handles.valve_open0(handles.nowfile)==0)
%       return;
%    end
% 
%    valve_open0=handles.valve_open0(handles.nowfile);
%    k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec
%    d2=d(k);
% 
%    movingstep=(get(handles.slider_movingstep, 'Value')*10)^3/4+5;
%    valve_open0=max(valve_open0-round(movingstep), k(1));
%    handles.valve_open0(handles.nowfile)=valve_open0;
%    %save(fname, 'valve_open0', '-append');
% 
%    axes(handles.axes_valveopen);
%    plot(k*dt, d2, 'b-', valve_open0*dt, d(valve_open0), 'ro');
% end
% guidata(hObject, handles);
% 
% 
% % --- Executes on button press in pushbutton_moveright.
% function pushbutton_moveright_Callback(hObject, eventdata, handles)
% % hObject    handle to pushbutton_moveright (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    structure with handles and user data (see GUIDATA)
% 
% if(~isfield(handles, 'fnames'))
%    return;
% end
% kfile=get(handles.listbox_files2bupdated, 'Value');
% fname=cell2mat(handles.fnames(kfile));
% 
% if(exist(fname,'file'))
%    load(fname, 'd');
% 
%    warning off;
%    load(fname, 'dt');
%    warning on;
%    if(~exist('dt','var')) dt=handles.dt; end
% 
%    stimstart=handles.stimstart(kfile);
% 
%    if(handles.valve_open0(handles.nowfile)==0)
%       return;
%    end
% 
%    valve_open0=handles.valve_open0(handles.nowfile);
%    k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec
%    d2=d(k);
% 
%    movingstep=(get(handles.slider_movingstep, 'Value')*10)^3/4+5;
%    valve_open0=min(valve_open0+round(movingstep), k(end));
%    handles.valve_open0(handles.nowfile)=valve_open0;
%    %   save(fname, 'valve_open0', '-append');
% 
%    axes(handles.axes_valveopen);
%    plot(k*dt, d2, 'b-', valve_open0*dt, d(valve_open0), 'ro');
% end
% guidata(hObject, handles);




% --- Executes on button press in pushbutton_loadit.
function pushbutton_loadit_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton_loadit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

xlsfnames=get(handles.popupmenu_flist, 'String');
val=get(handles.popupmenu_flist,'Value' );
xlsfname=xlsfnames{val};


finfo= readdatainf(xlsfname, handles.h0);%call readdatainf in flyspikes
      
% matfiles=dir(strcat(handles.h0.mfolder, '*.mat'));
% if(isempty(matfiles))
%    set(handles.text_msg,'String','no .mat files found');
%    return;
% end
   


if(~isempty(handles.h0.mfolder))
    if(handles.h0.mfolder(end)~='/' && handles.h0.mfolder(end)~='\')
        if(ispc())
            handles.h0.mfolder=strcat(handles.h0.mfolder,'\');
        else
            handles.h0.mfolder=strcat(handles.h0.mfolder,'/');
        end
    end
end


for k=1:length(finfo)
      if(exist(strcat(handles.h0.mfolder, finfo(k).fname,'.mat')))
        infostr{k}=inf2str(finfo(k));
      elseif(~isempty(finfo(k).fname))
        infostr{k}=finfo(k).fname; 
      else
        infostr{k}=' '; 
      end
end


handles.finfo=finfo;


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(handles.listbox_files2bupdated, 'String', infostr);

set(handles.listbox_files2bupdated, 'Value', 1)
fname=finfo(1).fname;
handles.nowfile=1;
% if(exist(fname,'file'))
%    load(fname, 'd');
% 
%    warning off;
%    load(fname, 'dt');
%    warning on;
% 
%    if(~exist('dt','var')) dt=handles.dt; end
% 
%    stimstart =handles.finfo(1).stimstart;
%    if(exist('stimstart','var'))
%       if(stimstart/dt - 800<0)
%          warndlg('stimstart comes too early to scan around');
%       end
%       k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec
% 
%       d2=d(k);
% 
%    end
% end


set(handles.pushbutton_prev,'Enable','on');
set(handles.pushbutton_next,'Enable','on');
set(handles.listbox_files2bupdated  ,'Enable','on');
guidata(hObject, handles);




%fnames=readinfoxls(hObject, handles, cell2mat(xlsfnames(val)));

% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % xlsfname=cell2mat(xlsfnames(val));
% % %function fnames=readinfoxls(hObject, handles, xlsfname)
% % 
% % [type, sheets] = xlsfinfo(xlsfname);
% % 
% % warning off;
% % [num txt] = xlsread(xlsfname, sheets{1}, '', 'basic');
% % warning on;
% % %xlsread sometimes read the first line to 'num', sometimes not
% % %to take care of the irregularity
% % if(~isnan(num(1,1)))
% %    num= [NaN(1, size(num,2)); num];
% % end
% % 
% % %num = [zeros(1,size(num,2)); num];
% % 
% % %find the index of fnum
% % if(strcmp(cell2mat(txt(1,1)),'fnhead'))
% %    fnhead=txt(2:end,1);
% % end;
% % 
% % if(~exist('fnhead', 'var'))
% %    warndlg('fnhead column not found');
% %    handles.fnames=[];
% %    guidata(hObject, handles);
% %    return;
% % end;
% % 
% % 
% % if(strcmp(cell2mat(txt(1,2)),'fnum'))
% %    fnum=num(2:end,1);
% % end;
% % 
% % if(~exist('fnum', 'var'))
% %    warndlg('fnum column not found');
% %    handles.fnames=[];
% %    guidata(hObject, handles);
% %    return;
% % end;
% % 
% % 
% % %find the index of stimstart
% % if(strcmp(cell2mat(txt(1,3)),'stimstart'))
% %    stimstart=num(2:end,2);
% % end;
% % 
% % if(~exist('stimstart', 'var'))
% %    warndlg('stimstart column not found');
% %    handles.stimstart=[];
% %    guidata(hObject, handles);
% %    return;
% % end;
% % 
% % 
% % %find the index of stimdur
% % if(strcmp(cell2mat(txt(1,4)),'stimdur'))
% %    stimdur=num(2:end,3);
% % end;
% % 
% % if(~exist('stimdur', 'var'))
% %    warndlg('stimdur column not found');
% %    handles.stimdur=[];
% %    %    guidata(hObject, handles);
% %    %    return;
% % end;
% % 
% % 
% % %find the index of pp (picospritzer pressure in psi unit)
% % if(strcmp(txt{1,5}(1:2),'pp'))
% %    pp=num(2:end,4);
% % end;
% % 
% % if(~exist('pp', 'var'))
% %    warndlg('pp column not found');
% %    handles.pp=[];
% %    %    guidata(hObject, handles);
% % end;
% % 
% % %find the index of pp (picospritzer pressure in psi unit)
% % if(strcmp(cell2mat(txt(1,6)),'Iin'))
% %    Iin0=num(2:end,5);
% %    if(length(Iin0)<size(txt,1)-1)
% %       Iin0=[Iin0; zeros(size(txt,1)-1-length(Iin0),1)];
% %    end
% % end;
% % 
% % if(~exist('Iin0', 'var'))
% %    warndlg('Iin column not found');
% %    handles.Iin0=[];
% %    %    guidata(hObject, handles);
% % end;
% % 
% % 
% % %find the index of celltype
% % if(strcmp(cell2mat(txt(1,7)),'celltype'))
% %    if(size(txt,1)>1)
% %       celltype=txt(2:end,7);
% %    end
% % end;
% % 
% % if (~exist('celltype', 'var'))
% %    warndlg('celltype column not found');
% %    handles.celltype=[];
% %    %    guidata(hObject, handles);
% % end;
% % 
% % 
% % 
% % for k=1:size(celltype,1)
% %    if (strcmp(cell2mat(celltype(k)), ''))
% %       celltype(k)={'pn'};
% %    end
% % end
% % 
% % for k=(size(celltype,1)+1):length(fnum)
% %    celltype(k)={'pn'};
% % end;
% % 
% % 
% % 
% % 
% % %find the index of etc
% % if(strcmp(cell2mat(txt(1,8)),'etc'))
% %    if(size(txt,1)>1)
% %       etc=txt(2:end,8);
% %    end;
% % end;
% % 
% % 
% % if (~exist('etc', 'var'))
% %    warndlg('etc column not found');
% %    handles.etc=[];
% %    %    guidata(hObject, handles);
% % end;
% % 
% % for k=(size(etc,1)+1):length(fnum)
% %    etc(k)={''};
% % end;
% % 
% % nfiles=min([length(fnhead) length(fnum) length(stimstart) length(stimdur)]);
% % for k=1:nfiles
% %    if(length(fnhead{k})==5)%short file name format
% %       fnames(k)= {strcat(fnhead{k}, sprintf('%03d',fnum(k)),'.mat')};
% %    else
% %       fnames(k)= {strcat(fnhead{k}, sprintf('%04d',fnum(k)),'.mat')};
% %    end
% % end
% % 
% % 
% % validfileks=[];
% % %check if wrong file name
% % for k=1:nfiles
% %    if(exist(fnames{k},'file'))
% %       validfileks = [validfileks; 1];
% %    elseif(exist(strcat(fnames{k}(1:(end-4)),'a001.mat'),'file'))
% %       validfileks=[validfileks; 1];
% %       fnames(k)={strcat(fnames{k}(1:(end-4)),'a001.mat')};
% % 
% %    else
% %       validfileks = [validfileks; 0];
% %       disp(sprintf('wrong file name: %s',fnames{k}));
% %    end
% % end
% % 
% % %set Iin---------------------------------------------------------------
% % Iin=cell(nfiles,1);
% % for k=1:nfiles
% %    if(validfileks(k))
% %       if(isnan(Iin0(k)))
% %          Iin(k)={str2num(txt{(k+1),6})};
% %       else
% %          Iin(k)={Iin0(k)};
% %       end
% %    else
% %       Iin{k}=0;
% %    end
% % end
% % %------------------------------------------------------------------
% % 
% % 
% % % %------------------------------------------------------------------
% % % %to provide 'multiple sweep recordings'(episodic recordings...)
% % % Iin=cell(nfiles,1);
% % % for k=1:nfiles
% % %    if(strcmp(lower(etc(k)), 'episodic') & k <= nfiles)
% % %       tempname=cell2mat(fnames(k));
% % %       if(exist(strcat(tempname(1:(end-4)),'aa.mat'),'file'))
% % %          validfileks(k)=1;
% % %          fnames(k)={strcat(tempname(1:(end-4)),'aa.mat')};
% % %       end
% % %       Iin(k)={str2num(cell2mat(txt((k+1),6)))};
% % %    else
% % %       Iin(k)={Iin0(k)};
% % %    end
% % % end
% % % %------------------------------------------------------------------
% % 
% % 
% % handles.fnames=fnames(logical(validfileks));
% % handles.stimstart=stimstart(logical(validfileks));
% % handles.stimdur=stimdur(logical(validfileks));
% % handles.celltype=celltype(logical(validfileks));
% % handles.etc=etc(logical(validfileks));
% % handles.pp=pp(logical(validfileks));
% % handles.Iin=Iin(logical(validfileks));
% % handles.valve_open0=zeros(sum(validfileks),1);
% % 
% % nfiles=length(handles.finfo);
% % if(nfiles==0)
% %    return;
% % end
% % 
% % warning off;
% % for k=1:nfiles
% %    load(cell2mat(handles.fnames(k)), 'valve_open0');
% % %    if(exist('valve_open0','var'))
% % %       handles.valve_open0(k)=valve_open0;
% % %       finfo(k)= {sprintf('%24s    %8d      %8d     %8d       %7.1f     %8d',...
% % %          cell2mat(fnames(k)),stimstart(k), stimdur(k), pp(k), Iin{k}(1), valve_open0)};
% % %    else
% % %       finfo(k)= {sprintf('%24s    %8d      %8d     %8d       %7.1f  ',...
% % %          cell2mat(fnames(k)),stimstart(k), stimdur(k), pp(k), Iin{k}(1))};
% % %    end
% % % replaced by the following on Jan. 16th, 2007
% %    if(exist('valve_open0','var'))
% %       handles.valve_open0(k)=valve_open0;
% %       finfo(k)= {sprintf('%24s  %8d    %8d   %7.1f     %7.1f   %8d     %-24s',...
% %          fnames{k},stimstart(k), stimdur(k), pp(k), Iin{k}(1), valve_open0, etc{k})};
% %    else
% %       finfo(k)= {sprintf('%24s  %8d    %8d   %7.1f     %7.1f               %-24s',...
% %          fnames{k},stimstart(k), stimdur(k), pp(k), Iin{k}(1), etc{k})};
% %    end
% % end
% % warning on;
% % 
% % set(handles.listbox_files2bupdated, 'String', finfo);
% % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % 
% % 
% % 
% % set(handles.listbox_files2bupdated, 'Value', 1)
% % fname=cell2mat(fnames(1));
% % handles.nowfile=1;
% % if(exist(fname,'file'))
% %    load(fname, 'd');
% % 
% %    warning off;
% %    load(fname, 'dt');
% %    warning on;
% % 
% %    if(~exist('dt','var')) dt=handles.dt; end
% % 
% %    stimstart =handles.stimstart(1);
% %    if(exist('stimstart','var'))
% %       if(stimstart/dt - 800<0)
% %          warndlg('stimstart comes too early to scan around');
% %       end
% %       k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec
% % 
% %       d2=d(k);
% % 
% %       %    w=zeros(size(k));
% %       %    if(exist('valve_open0','var'))
% %       %       w(valve_open0-k(1)+1)=d2(valve_open0-k(1)+1);
% %       %    end
% % 
% % 
% % %       axes(handles.axes_valveopen);
% % %       if(handles.valve_open0(1)~=0)
% % %          plot(k*dt, d2, 'b-', handles.valve_open0(1)*dt, d(handles.valve_open0(1)), 'ro');
% % %       else
% % %          plot(k*dt, d2, 'b-');
% % %       end
% %    end
% % end
% % 
% % 
% % set(handles.pushbutton_prev,'Enable','on');
% % set(handles.pushbutton_next,'Enable','on');
% % % set(handles.pushbutton_findvalve1  ,'Enable','on');
% % % set(handles.pushbutton_findvalveall  ,'Enable','on');
% % % set(handles.pushbutton_moveleft  ,'Enable','on');
% % % set(handles.pushbutton_moveright  ,'Enable','on');
% % set(handles.listbox_files2bupdated  ,'Enable','on');
% % % set(handles.pushbutton_update  ,'Enable','on');





% % --- Executes during object creation, after setting all properties.
% function slider_movingstep_CreateFcn(hObject, eventdata, handles)
% % hObject    handle to slider_movingstep (see GCBO)
% % eventdata  reserved - to be defined in a future version of MATLAB
% % handles    empty - handles not created until after all CreateFcns called
% 
% % Hint: slider controls usually have a light gray background.
% if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
%    set(hObject,'BackgroundColor',[.9 .9 .9]);
% end





function switchto(hObject, eventdata, handles)
handles.nowfile=get(handles.listbox_files2bupdated, 'Value');
fname=handles.finfo(handles.nowfile).fname;
if(exist(fname,'file') & handles.stimdur(handles.nowfile)~=0)
   load(fname, 'd');

   warning off;
   load(fname, 'dt');
   warning on;
   if(~exist('dt','var')) dt=handles.dt; end

   stimstart=handles.stimstart(handles.nowfile);
   if(stimstart/dt - 800<0 | stimstart/dt+400>length(d) )
      warndlg(strcat(fname,': stimstart comes too early or too late'));
      return;
   end
   k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec

   d2=d(k);

%    axes(handles.axes_valveopen);
%    if(handles.valve_open0(handles.nowfile)~=0)
%       valve_open0=handles.valve_open0(handles.nowfile);
%       plot(k*dt, d2, 'b-', valve_open0*dt, d(valve_open0), 'ro');
%    else
%       plot(k*dt, d2, 'b-');
%    end

elseif(exist(fname,'file') & strcmp(lower(handles.etc(handles.nowfile)),'episodic'))
   load(fname, 'd');

   warning off;
   load(fname, 'dt');
   warning on;
   if(~exist('dt','var')) dt=handles.dt; end

   stimstart=handles.stimstart(handles.nowfile);
%this code is disabled by Anmo Kim on Nov. 15th since the stimstart is
%meaningless in case of episodic mode
%    if(stimstart/dt - 800<0 | stimstart/dt+400>length(d) )
%       warndlg(strcat(fname,': stimstart comes too early or too late'));
%       return;
%    end
%   k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec
   k=max(stimstart/dt-800,1):max(stimstart/dt+400,1201); 
   
   d2=d(k);

%    axes(handles.axes_valveopen);
%    plot(k*dt, d2, 'b-');
end

guidata(hObject, handles);









function valve_open0 = find_valve_open0(hObject, eventdata, handles)
valve_open0=0;
template=[-49.255368754245524;-49.377439060947495;-49.591062097675945;-49.804685134404394;-50.04882574780834;-50.2014136311858;-50.354001514563265;-50.50658939794073;-50.689694857993686;-50.87280031804664;-50.93383547139763;-50.87280031804664;-50.84228274137115;-50.87280031804664;-51.14745850812608;-51.330563968179035;-51.330563968179035;-51.26952881482805;-51.36108154485453;-51.63573973493396;-51.757810041635935;-51.69677488828495;-51.45263427488101;-51.666257311609456;-51.879880348337906;-51.757810041635935;-51.51366942823199;-51.60522215825847;-51.69677488828495;-51.39159912154002;-51.23901123815256;-51.39159912154002;-51.26952881482805;-51.116940931450586;-51.40004639150354;-51.45263427488101;-51.330563968179035;-51.45263427488101;-51.81884519498692;-51.81884519498692;-51.9103979400134;-52.24609126844382;-52.06298580839086;-52.12402096174185;-52.42919672849678;-52.27660884511931;-52.49023188184776;-52.64281976522523;-52.398679151821284;-52.734372495251705;-52.612302188549734;-52.612302188549734;-52.79540764860269;-52.520749458523255;-52.82592522527818;-52.64281976522523;-52.64281976522523;-52.67333734190072;-52.67333734190072;-52.88696037862917;-52.58178461187424;-52.79540764860269;-52.67333734190072;-52.79540764860269;-52.67333734190072;-52.7648900719272;-52.64281976522523;-52.70385491857621;-52.64281976522523;-52.734372495251705;-52.55126703519875;-52.64281976522523;-52.67333734190072;-52.64281976522523;-52.82592522527818;-52.70385491857621;-52.49023188184776;-52.734372495251705;-52.79540764860269;-52.7648900719272;-52.67333734190072;-52.67333734190072;-52.55126703519875;-52.49023188184776;-52.49023188184776;-52.42919672849678;-52.36816157514579;-52.24609126844382;-52.15453853841734;-52.12402096174185;-52.093503385066356;-52.21557369176833;-52.21557369176833;-52.398679151821284;-52.36816157514579;-52.3376439984703;-52.03246823171537;-51.84936277166241;-52.03246823171537;-52.15453853841734;-52.15453853841734;-52.03246823171537;-51.9103979400134;-52.093503385066356;-52.21557369176833;-52.12402096174185;-52.00195065503988;-52.12402096174185;-52.27660884511931;-52.15453853841734;-51.9103979400134;-52.03246823171537;-52.06298580839086;-51.94091550168889;-51.94091550168889;-52.12402096174185;-52.06298580839086;-52.12402096174185;-52.24609126844382;-52.3376439984703;-52.03246823171537;-52.093503385066356;-52.21557369176833;-52.03246823171537;-52.00195065503988;-52.185056115092834;-51.971433078364385;-52.093503385066356;-52.185056115092834;-52.00195065503988;-52.12402096174185;-52.185056115092834;-51.94091550168889;-52.21557369176833;-52.12402096174185;-52.12402096174185;-52.27660884511931;-52.06298580839086;-52.3376439984703;-52.185056115092834;-52.27660884511931;-52.307126421794806;-52.185056115092834;-52.42919672849678;-52.185056115092834;-52.398679151821284;-52.307126421794806;-52.520749458523255;-52.24609126844382;-52.42919672849678;-52.307126421794806;-52.49023188184776;-52.398679151821284;-52.58178461187424;-52.45971430517227;-52.42919672849678;-52.49023188184776;-52.21557369176833;-52.520749458523255;-52.520749458523255;-52.36816157514579;-52.24609126844382;-52.27660884511931;-52.42919672849678;-52.55126703519875;-52.612302188549734;-52.612302188549734;-52.734372495251705;-52.79540764860269;-52.82592522527818;-52.79540764860269;-52.856442801953676;-52.856442801953676;-52.7648900719272;-52.67333734190072;-52.55126703519875;-52.58178461187424;-52.734372495251705;-52.856442801953676;-52.91747795530466;-52.856442801953676;-52.67333734190072;-52.70385491857621;-52.91747795530466;-53.03954826200663;-52.88696037862917;-52.70385491857621;-52.82592522527818;-52.97851310865565;-52.97851310865565;-52.734372495251705;-52.7648900719272;-52.88696037862917;-52.88696037862917;-52.67333734190072;-52.70385491857621;-52.91747795530466;-52.734372495251705;-52.64281976522523;-52.7648900719272;-52.734372495251705;-52.520749458523255;-52.612302188549734;-52.734372495251705;-52.49023188184776;-52.612302188549734;-52.7648900719272;-52.64281976522523;-52.64281976522523;-52.947995531980155;-52.7648900719272;-52.79540764860269;-52.856442801953676;-52.612302188549734;-52.88696037862917;-52.88696037862917;-52.79540764860269;-52.97851310865565;-52.82592522527818;-52.947995531980155;-52.88696037862917;-52.79540764860269;-52.97851310865565;-52.7648900719272;-53.03954826200663;-52.82592522527818;-52.88696037862917;-52.7648900719272;-52.79540764860269;-52.856442801953676;-52.734372495251705;-52.91747795530466;-52.79540764860269;-52.88696037862917;-52.734372495251705;-52.82592522527818;-52.734372495251705;-52.91747795530466;-52.612302188549734;-52.947995531980155;-52.82592522527818;-52.856442801953676;-52.91747795530466;-52.734372495251705;-52.64281976522523;-52.612302188549734;-52.734372495251705;-52.856442801953676;-52.79540764860269;-52.612302188549734;-52.185056115092834;-51.40004639150354;-50.32348393788777;-49.74364998105341;-49.46899179097397;-49.346921484272;-49.346921484272;-49.28588633092102;-49.255368754245524;-49.19433380089453;];
if(mod(length(template),2)==1) template=template(1:(end-1)); end
%always even length


kfile=get(handles.listbox_files2bupdated, 'Value');
fname=cell2mat(handles.fnames(kfile));

if(exist(fname,'file') & handles.stimdur(kfile)~=0)
   load(fname, 'd');

   warning off;
   load(fname, 'dt');
   warning on;
   if(~exist('dt','var')) dt=handles.dt; end

   stimstart =handles.stimstart(kfile);
   if(stimstart/dt - 800-length(template)/2<0 | ...
         stimstart/dt+400+length(template)/2>length(d) )
      warndlg(strcat(fname,': stimstart comes too early or too late'));
      return;
   end
   k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec
   d1=d((k(1)-length(template)/2):(k(end)+length(template)/2));

   %if(~exist('valve_open0','var'))

   %valve opening detection
   v = flipud(template);
   z = -ones(size(v));
   w = conv(d1,v) - conv(d1,z);
   w = w(length(template):(end-length(template)));

   [c, i]=max(w);
   valve_open0=min(max(i-length(template)/2+k(1),k(1)), k(end));
   finfo=get(handles.listbox_files2bupdated, 'String');
   finfo{kfile}=sprintf('%24s      %8d      %8d     %8d       %7.1f       %8d',...
      cell2mat(handles.fnames(kfile)),handles.stimstart(kfile), handles.stimdur(kfile), handles.pp(kfile),...
      handles.Iin{kfile}(1), valve_open0);
   set(handles.listbox_files2bupdated, 'String', finfo);
   %save(fname, 'valve_open0', '-append');
   %end

   d2=d(k);

%    axes(handles.axes_valveopen);
%    %plot(k*dt, d2, 'b-', k*dt, w, 'ro');
%    plot(k*dt, d2, 'b-', valve_open0*dt, d(valve_open0), 'ro');

elseif(exist(fname,'file') & strcmp(lower(handles.etc(kfile)), 'episodic'))
   load(fname, 'd');

   warning off;
   load(fname, 'dt');
   warning on;
   if(~exist('dt','var')) dt=handles.dt; end

   stimstart=handles.stimstart(kfile);
%this code is disabled by Anmo Kim on Nov. 15th since the stimstart is
%meaningless in case of episodic mode
%    if(stimstart/dt - 800<0 | stimstart/dt+400>length(d) )
%       warndlg(strcat(fname,': stimstart comes too early or too late'));
%       return;
%    end
%   k=(stimstart/dt - 800):(stimstart/dt+400);  %-60 msec ~ +30 msec
   k=max(stimstart/dt-800,1):max(stimstart/dt+400,1201); 

   valve_open0=0;
   finfo=get(handles.listbox_files2bupdated, 'String');
   finfo{kfile}=sprintf('%24s      %8d      %8d     %8d       %7.1f       %8d',...
      cell2mat(handles.fnames(kfile)),handles.stimstart(kfile), handles.stimdur(kfile), handles.pp(kfile),...
      handles.Iin{kfile}(1), valve_open0);
   set(handles.listbox_files2bupdated, 'String', finfo);

   d2=d(k);

%    axes(handles.axes_valveopen);
%    plot(k*dt, d2, 'b-');
end


% function finfo=readdatainf(xlsfname,handles)
% %fname : file names that contains excel information file
% %finfo : information structure array
% finfo=[];
% 
% if(~exist(xlsfname))
%    set(handles.text_msg,'String',strcat(xlsfname, ' NOT found'));
%    return;
% end
% 
% infname=handles.infname;
% inftype=handles.inftype;
% 
% [type, sheets] = xlsfinfo(xlsfname);
% 
% warning off;
% [num txt] = xlsread(xlsfname, sheets{1}, '', 'basic');
% warning on;
% 
% if(isempty(txt)) return; end
% 
% infindex=zeros(1,length(infname));
% for i=1:length(infname)
%    for j=1:size(txt,2)
%       if(strcmpi(txt{1,j}, infname{i}))
%          infindex(i)=j;
%          break;
%       end
%    end
% end
% 
% 
% numindex=infindex;
% for k=1:length(numindex)
%    if(numindex(k))
%    if(strcmpi(inftype{infindex(k)},'char'))
%       numindex(numindex>numindex(k))=numindex(numindex>numindex(k))-1;
%       numindex(k)=0;
%    end
%    end
% end
% 
% numindex(numindex>size(num,2))=0;
% 
% 
% nfiles=max(size(num,1),size(txt,1))-1;
% 
% if(~infindex(1) || ~infindex(2)) %if file name is not specified
%    set(handles.text_msg,'String','fn_head or fnum is missing in xlsfname');
%    return;
% end
% 
% %find valid file names
% validk=[];
% for k=2:nfiles
%    fname9=strcat(txt{k,1},sprintf('%04d',num(k,1)));
%    if(~isempty(fname9))
%       validk=[validk k];
%       finfo(length(validk)).fname=fname9;
%    end
% end
% 
% if(isempty(validk))
%    set(handles.text_msg,'String',strcat('no information found in ',xlsfname));
%    return;
% end
% 
% infname{7}='pp'; %pp/con is a bad variable name
% 
% for k=1:length(validk)
%    for j=3:length(infindex)
%       if(infindex(j))
%          %if the information entry found in the excel file
%          if(strcmpi(inftype(j),'char'))
%             eval(strcat('finfo(k).',infname{j},'= txt{validk(k),infindex(j)};'));
%          elseif(strcmpi(inftype(j),'num'))
%             eval(strcat('finfo(k).',infname{j},'= num(validk(k),numindex(j));'));
%          end
%       else
%          %put empty
%          if(strcmpi(inftype{j},'char'))
%             eval(strcat('finfo(k).',infname{j},'='''';'));
%          elseif(strcmpi(inftype{j},'num'))
%             eval(strcat('finfo(k).',infname{j},'=[];'));
%          end
%       end
%    end
% end


function finfo=readdatainf(xlsfname,handles)
%fname : file names that contains excel information file
%finfo : information structure array
finfo=[];

if(~exist(xlsfname))
    set(handles.text_msg,'String',strcat(xlsfname, ' NOT found'));
    return;
end

infname=handles.infname;
inftype=handles.inftype;

[type, sheets] = xlsfinfo(xlsfname);

warning off;
[num txt] = xlsread(xlsfname, sheets{1}, '', 'basic');
warning on;


   
if(isempty(txt)) return; end

% if(size(txt,1)>size(num,1))
%     num=[zeros(1,size(num,2)); num];
% end
% if(size(txt,1)>size(num,1))
%     if still longer
%     num=[zeros(size(txt,1)-size(num,1),size(num,2)); num];
% end

infindex=zeros(1,length(infname));
for i=1:length(infname)
    for j=1:size(txt,2)
        if(strcmpi(txt{1,j}, infname{i}))
            infindex(i)=j;
            break;
        end
    end
end

beginbystr=zeros(1,size(txt,1));
for i=1:size(txt,1)
    beginbystr(i)=isempty(txt{i,1});
end
txt=txt(logical(beginbystr),:);

%merge num to txt
numj=1;

if(sum(isnan(num(1,:)))==size(num,2))
    num=num(2:end,:);
end
for j=1:size(txt,2)
    if(numj>size(num,2))   break;   end

    colfoundinnum=1;
    for i=1:size(num,1)
        if(~isempty(txt{i,j}) && ~isnan(num(i,numj)))
            %if contradicts
            colfoundinnum=0;
            break;
        end
    end

    if(colfoundinnum)
        for i=1:size(txt,1)
            if(isempty(txt{i,j})&&isstr(txt{i,j}))
                %replace it with an element from num
                if(i>size(num,1))     break;    end
                if(~isnan(num(i,numj)))
                    txt{i,j}=num(i,numj);
                end
            end
        end
        numj=numj+1;
    end
end





% numindex=infindex;
% for k=1:length(numindex)
%    if(numindex(k))
%    if(strcmpi(inftype{infindex(k)},'char'))
%       numindex(numindex>numindex(k))=numindex(numindex>numindex(k))-1;
%       numindex(k)=0;
%    end
%    end
% end
%
% numindex(numindex>size(num,2))=0;


nfiles=max(size(num,1),size(txt,1))-1;

if(~infindex(1) || ~infindex(2)) %if file name is not specified
    set(handles.text_msg,'String','fn_head or fnum is missing in xlsfname');
    return;
end

%find valid file names
validk=[];
for k=1:(nfiles+1)
    fname9=strcat(txt{k,infindex(1)},sprintf('%04d',txt{k,infindex(2)}));
    if(~isempty(fname9))
        validk=[validk k];
        finfo(length(validk)).fname=fname9;
    end
end

if(isempty(validk))
    set(handles.text_msg,'String',strcat('no information found in ',xlsfname));
    return;
end

%infname{8}='pp'; %pp/con is a bad variable name

for k=1:length(validk)
    for j=3:length(infindex)
        if(infindex(j))
            %if the information entry found in the excel file
            eval(strcat('finfo(k).',infname{j},'= txt{validk(k),infindex(j)};'));
        elseif(~isfield(finfo(k),infname{j}))%because pp/con and pp
            %put empty
            if(strcmpi(inftype{j},'char'))
                eval(strcat('finfo(k).',infname{j},'='''';'));
            elseif(strcmpi(inftype{j},'num'))
                eval(strcat('finfo(k).',infname{j},'=[];'));
            end
        end
    end
end


%correct stimdur
for k=1:length(finfo)
    if(isstr(finfo(k).valveseq(1)))
    if(sum('1'==dec2bin(hex2dec(finfo(k).valveseq(1))))>1 && finfo(k).stimdur>=2500)
        finfo(k).stimdur=finfo(k).stimdur-2500;
    end
    else
    if(sum('1'==dec2bin((finfo(k).valveseq(1))))>1 && finfo(k).stimdur>=2500)
        finfo(k).stimdur=finfo(k).stimdur-2500;
    end
    end
end



%==================================
function out=inf2str(finfo)
out=[];
names=fieldnames(finfo);
for k=1:length(names)
   eval(strcat('val=finfo.',names{k},';'));
   if(~isempty(val) )
      if(isnumeric(val) & length(val)<10)
         val=num2str(val);
      end
      if(isstr(val) && length(val)<60)
         out=strcat(out, names{k}, '=',val,',');
      end
   end
end
