%Following code is a modified verson of Jason Rihel's work
%Grigorios Oikonomou

%% Set up the function

% function genox = analysis2(listname, filename)

%% Clean up
clear all
%close all

%% Define the path you will be working in:
tic
working_path = '/Users/GrigoriosOikonomou/Documents/Prober lab/Videotrackers/analysis_software/analysis2/'



%% Import genotype list(listname) and dataset

listname = '140526_3B_genotype_4.txt'
filename = '140526_3B_DATA.txt'

gridmap = importdata(strcat(working_path,'genotype_lists/', listname), '\t', 2)
dataset = importdata(strcat(working_path,'data_files/', filename), '\t', 2)

%% Import the names of the genotypes and sort the data in different cells based on genotypes 

number_of_genos = str2double(listname(20))
% grab the 20th character from the name of the genotype file (listname) and
% then convert that to a double; this way I have the number of genotypes
% (number_of_genos)


for i=1:number_of_genos
    genox.name{i} = gridmap.colheaders{i}
    genox.data{i} = dataset.data(:, gridmap.data(find(~isnan(gridmap.data(:,i))),i)+2)
end

%% Save the fish numbers

for i=1:number_of_genos
    genox.fishID{i} = gridmap.data(find(~isnan(gridmap.data(:,i))), i)
end

%% Get the zeitgeber info from the dataset file (last column)

genox.zeitgeber = dataset.data(:, end)

%% Get the light schedule info from the zeitgeber info

% lights are on at time 0, lights are off at time 14

genox.lightschedule = genox.zeitgeber
% first just copy the zeitgeber

genox.lightschedule(find(genox.lightschedule < 14)) = 0
% if <14 then lights are off, therefore 0
genox.lightschedule(find(genox.lightschedule >= 14)) =1
% if >= 14 lights are on, therefore 1

% so the stamp is 0 for day, and 1 for night.


%% Get the genox.time in hours

for j=1:length(genox.lightschedule)
    genox.time(j) = (j)
end

% now convert the minutes to hours:
genox.time = genox.time/60


%% Get the genox.daynumber 

% you add the first zeitgeber value to all time points so that you take 
% into account the time that you started the experiment
% then you divide by 24 to get the number of days:
genox.daynumber = (genox.zeitgeber(1) + genox.time)/24

% add 1 since you start at day 1, not day 0:
genox.daynumber = genox.daynumber +1

% now round down:
genox.daynumber = floor(genox.daynumber)


%% Data for Activity Graph - 1h bins

% First a time stamp for the first graph:
% take every ten minutes!
genox.onehourtime = genox.time(60:60:end) + genox.zeitgeber(1)



for i = 1:number_of_genos  % loop through all genotypes (i) (1:2 for 111206_1A)
    for j = 1:length(genox.data{i}(1,1:end)) % within that genotype, loop through all columns (j) (1:48 for both genotypes of 111206_1A)
        for q = 60:60:length(genox.data{i})  % within each column, loop from row 60 to end in steps of 60 (every 60 minutes)
                                            %could also do q =
                                            %10:10:length(geno.data{i}(1:end,1))
                                            %but if you don't specify
                                            %matlab clooks at rows which is
                                            %what you want here
         genox.onehour{i}(q/60, j)= sum(genox.data{i}(q-59:q,j))
         % make new cell geno.tenmnute{phenotype#}(row = initial/10, column =
         % column/fish number) = sum(within the genotype cell, rows in
         % groups of 10, in fish column)!!!    
        end
    end
end

%% Activity Graph - 1h bins

h = figure
hold on
xlabel('Zeitgeber Time (hours)')
ylabel('Average Activity (sec/h)')
title(strcat('Activity 1h bins ', filename(1:end-9)))

for j = 1:number_of_genos;

% First to define the colors that will be used for the different genotypes:
% copied from JR
 
    if j == 1
        c = [0 0 1]; %blue       
    end 
    if j == 2
        c = [0 1 1]; %cyan
    end
    if j == 3 
        c =  [1 0 0]; %red 
    end
    if j == 4 
        c = [1 0 1]; %magenta/purple
    end
    if j == 5
        c = [0 1 0]; %green
    end
    if j == 6 
        c = [1 1 0]; %yellow
    end
    if j == 7
        c = [0 0 0]; %black
    end
    if j == 8 
        c = [0.5 0.5 0.5];
    end
    if j == 9
        c = [.5 .2 .8];
    end 
    if j == 10 
        c = [0.5 .2 .2];
    end
    if j > 10
        c = [1 1 1];
    end 
    
% now to plot each genotype (j)
plot(genox.onehourtime,mean(genox.onehour{j}'),...
    'LineWidth',2,... 
    'color',c,...
    'MarkerSize',1,...
    'marker','.') 

% % and to update the legend
 legendname(j)=cellstr(genox.name{j})

end


for i = 1:number_of_genos
    to_sort(i) = max(mean(genox.onehour{i}'))
end
sorted = sort(to_sort)


% axis and legend for regular output
axis([genox.onehourtime(1) max(genox.onehourtime) 0 (sorted(1, end) + 125)]) % for +75 on biggest value
legend(legendname) %if you want legend

set(gca,'TickDir','out',...
    'FontSize',9,...
    'XTick',[14, 24, 38],...
    'XTickLabel',[],...
    'LineWidth',1)

% save regular fig
hgsave(strcat(working_path,'analysis_output/', filename(1:end-9), '_Activity_1hr.fig'))
% save regular tiff
set(gcf, 'paperunits', 'centimeters', 'paperposition', [0 0 15 15])
print('-dtiff', '-r300', [working_path, 'analysis_output/', filename(1:end-9), '_Activity_1hr.tif'])


%% Data for Waking Activity Graph - 1h bins and  %10min bins

% The trick here is to convert all the zeroes from the activity data to NaN
% so that you can skip them when graphing

for i = 1:number_of_genos
    genox.avewaking{i} = genox.data{i} % first just copy the data
    genox.avewaking{i}(find(genox.data{i} == 0)) = NaN
end

% ATTENTION: despite the name, the genox.avewaking does not include averaged data!!!

% And to 1h bins

for i =  1:number_of_genos % loop through the genotypes
    for j = 1:length(genox.avewaking{i}(1,1:end)) % within genos loop through fish/columns
        for q=60:60:length(genox.avewaking{i})
            genox.avewakechart1h{i}(q/60,j)=nanmean(genox.avewaking{i}(q-59:q,j))
        end
    end
end

% ATTENTION: instead of summing like we did for the other chart data
% (activity and sleep), here we calculate the mean right away without
% taking into account the NaNs (they do not count in any way so that the
% average of [2, NaN] is 2, not 1.

%% Waking Activity Graph - 1hr bins

figure
hold on
xlabel('Zeitgeber Time (hours)')
ylabel('Average Waking Activity (sec awake min | 1h Bins)')
title(strcat('Waking Activity 1hr bins ',filename(1:end-9))) 


for j = 1:length(gridmap.data(1,1:end));
    
    if j == 1
        c = [0 0 1]; %blue       
    end 
    if j == 2
        c = [0 1 1]; %cyan
    end
    if j == 3 
        c =  [1 0 0]; %red 
    end
    if j == 4 
        c = [1 0 1]; %magenta/purple
    end
    if j == 5
        c = [0 1 0]; %green
    end
    if j == 6 
        c = [1 1 0]; %yellow
    end
    if j == 7
        c = [0 0 0]; %black
    end
    if j == 8 
        c = [0.5 0.5 0.5];
    end
    if j == 9
        c = [.5 .2 .8];
    end 
    if j == 10 
        c = [0.5 .2 .2];
    end
    if j > 10
        c = [1 1 1];
    end 
      
plot(genox.onehourtime, nanmean(genox.avewakechart1h{j}'),...
        'LineWidth',2,... 
        'color',c,...
        'MarkerSize',1,...
        'marker','.') 

% legendname(j) = cellstr(genox.name{j})

end

% GO: made some changes here so that:
% the max on Y is the maximum value of activity+10

for i = 1:number_of_genos
    to_sort(i) = max(nanmean(genox.avewakechart1h{i}'))
end
sorted = sort(to_sort)

% axis and legend for regular output
axis([genox.onehourtime(1) genox.onehourtime(end) 0 (sorted(1, end)+2)])
legend(legendname)

set(gca,'TickDir','out',...
    'FontSize',9,...
    'XTick',[14, 24, 38],...
    'XTickLabel',[],...
    'LineWidth',1)

% save regular fig
hgsave(strcat(working_path, 'analysis_output/', filename(1:end-9), '_WakingActivity_1hr.fig'))
% save regular tif
set(gcf, 'paperunits', 'centimeters', 'paperposition', [0 0 15 15])
print('-dtiff', '-r300', [working_path, 'analysis_output/', filename(1:end-9), '_WakingActivity_1hr.tif'])



%% Data for the Sleep Graph - 10min bins and 1hr bins

% convert all the data values to 1 or 0 for when they are asleep of not:

for i = 1:number_of_genos
    genox.sleep{i} = genox.data{i} % first just copy the data
    genox.sleep{i}(find(genox.data{i} <= 0.1)) = 1 %0.1 is the minimum value given by the VT; if equal or below that, asleep
    genox.sleep{i}(find(genox.data{i} > 0.1)) = 0 % if above that, awake
end



%now average for 1h

for i = 1:number_of_genos %loop through all genos
    for j=1:length(genox.sleep{i}(1,1:end)) %loop through all fish/columns in that geno
        for q=60:60:length(genox.sleep{i})
            genox.sleepchart1h{i}(q/60, j) = sum(genox.sleep{i}(q-59:q, j))
        end
    end
end


%% Sleep graph - 1hr bins

figure
hold on
xlabel('Zeitgeber Time (hours)')
ylabel('Sleep (min/hr)')
title (strcat('Sleep 1hr bins ', filename(1:end-9)))


for j = 1:number_of_genos;

% First to define the colors that will be used for the different genotypes:
 
    if j == 1
        c = [0 0 1]; %blue       
    end 
    if j == 2
        c = [0 1 1]; %cyan
    end
    if j == 3 
        c =  [1 0 0]; %red 
    end
    if j == 4 
        c = [1 0 1]; %magenta/purple
    end
    if j == 5
        c = [0 1 0]; %green
    end
    if j == 6 
        c = [1 1 0]; %yellow
    end
    if j == 7
        c = [0 0 0]; %black
    end
    if j == 8 
        c = [0.5 0.5 0.5];
    end
    if j == 9
        c = [.5 .2 .8];
    end 
    if j == 10 
        c = [0.5 .2 .2];
    end
    if j > 10
        c = [1 1 1];
    end 
    
    % now to plot each genotype (j)
    plot(genox.onehourtime, mean(genox.sleepchart1h{j}'),...
            'LineWidth',2,... 
            'color',c,...
            'MarkerSize',1,...
            'marker','.') 



    % and to update the legend
    % legendname(j) = cellstr(genox.name{j})
end

% the max on Y is the maximum value of activity+10

for i = 1:number_of_genos
    to_sort(i) = max(nanmean(genox.sleepchart1h{i}'))
end
sorted = sort(to_sort)


% axis and legend for regular output 
axis([genox.onehourtime(1) genox.onehourtime(end) 0 (sorted(1, end) +10)])
legend(legendname)


set(gca,'TickDir','out',...
    'FontSize',9,...
    'XTick',[14, 24, 38],...
    'XTickLabel',[],...
    'LineWidth',1)



% save regular fig
hgsave(strcat(working_path, 'analysis_output/', filename(1:end-9), '_Sleep_1hr.fig'))
% save regular tif
set(gcf, 'paperunits', 'centimeters', 'paperposition', [0 0 15 15])
print('-dtiff', '-r300', [working_path, 'analysis_output/', filename(1:end-9), '_Sleep_1hr.tif'])



%% sleepcontinuity and sleepboutstart


genox.sleepcontinuity = genox.sleep %initially just copy the sleep data

for i=1:number_of_genos  %loop through the genotypes
    for j =1:length(genox.sleepcontinuity{i}(1,1:end)) %and all fish/columns within the genotypes
        for k = 2: length(genox.sleepcontinuity{i}) %start at position #2 so that you can compare to previous position
            if genox.sleep{i}(k,j) == 1; %if the fish j of genotype i, is asleep at timepoint k...
                if genox.sleep{i}(k-1,j) == 0 % ...and awake at k-1: 
                    genox.sleepcontinuity{i}(k,j) = 1 %then sleep continuity of k = 1 (the counter starts over because the fish fell asleep!
                end
                %if the fish j of genotype i, is asleep at timepoint k...
                if genox.sleep{i}(k-1,j) == 1 % ... and asleep at k-1:
                    z = 1+ genox.sleepcontinuity{i}(k-1,j) %add 1 to the sleep continuity score of the k-1
                    genox.sleepcontinuity{i}(k,j) = z % and make the resulting value the sleep continuity score of k!!!
                end
                % what if the sleep is awake at timepoint k? Then sleep
                % continuity will be 0, since this is the value that was
                % put there when we copied the genox.sleep over to
                % genox.sleepcontinuity.
            end
        end
    end
    % Before leaving this loop, we can mark the beginning of every sleep
    % bout. How? What we have now is: 0 0 0 1 2 3 4 5... 0 0 0 1 2 3...
    % We can make everything except the "1"s zero! Then only the beginnings
    % will be marked!
    genox.sleepboutstart{i} = genox.sleepcontinuity{i}
    genox.sleepboutstart{i}(find(genox.sleepcontinuity{i}>1))=0
    
end

            
%% lightboundries (light/dark transitions)      

% In genox.lightschedule, 0 marks light on, 1 marks lights off!
% To mark the light/dark boundaries I just need to look for positions that
% have different values than the previous position!

genox.lightboundries = genox.lightschedule %initially just copy over

for q= 2:length(genox.lightboundries)
    if genox.lightschedule(q) == genox.lightschedule(q-1)
        genox.lightboundries(q)= 0
    end
    if genox.lightschedule(q) ~= genox.lightschedule(q-1)
         genox.lightboundries(q)= 1
    end
end

genox.lightboundries(1)=1 % perhaps because when program starts you go from dark to light?
% I am not sure this is a good idea...


    
%% Sleeplatency

% the trick here is to start at the lightboundries and keep adding 1s until
% the fish start the first sleep bout

for i = 1:number_of_genos % loop within the sleep data through all the genotypes i
    for j = 1:length(genox.sleep{i}(1,1:end)); % and all the fish j in that geno                                                    
            genox.sleeplatency{i}(:,j) = genox.lightboundries;  % first just copy the same lightboundries column to the sleeplatency column for the current fish (j)
            for k = 1: length(genox.sleep{i})-1; % now loop through all the timepoints (rows) in that fish's data except the last one (since we change the next
                                                 % timepoint in this loop, see below
                if genox.sleeplatency{i}(k,j) == 1; % if there is a boundry at timepoint k (remember we just copied over the boundries to the latency)...
                    if genox.sleep{i}(k+1,j) == 0; % ...and the fish are asleep at k+1(next position) (look at genox.sleep)
                        genox.sleeplatency{i}(k+1,j) = 1; % then mark the k+1 with 1 in the genox.sleeplatency
                    end    
                end    
            end
       end
end



%% LAST BIT
% The last part of this program is the summary table data, which will
% include the major summary data from the original Excel Chart

for i=1:number_of_genos; %loop through all the genotypes
    for j = 1:max(genox.daynumber) % loop through all the days
        for k = 1:length(genox.fishID{i}) % loop through all the fish k of that genotype
            
        % getting the total sleep for each fish for each day and night    
        genox.summarytable.sleep.day{i}(j,k) = sum(genox.sleep{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 0)),k));
        
       
        genox.summarytable.sleep.night{i}(j,k) = sum(genox.sleep{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 1)),k));
     
        
        
        % getting the total # of sleep bouts for each fish for each day and night
        genox.summarytable.sleepBout.day{i}(j,k) = sum(genox.sleepboutstart{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 0)),k));
        genox.summarytable.sleepBout.night{i}(j,k)=sum(genox.sleepboutstart{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 1)),k));
        
        % to get the mean length of the sleep bouts that a fish had during
        % each day/night, divide the total sleep of that day/night with the
        % number of sleep bouts for that day/night
        genox.summarytable.sleepLength.day{i}(j,k)= genox.summarytable.sleep.day{i}(j,k)/genox.summarytable.sleepBout.day{i}(j,k);
        genox.summarytable.sleepLength.night{i}(j,k)= genox.summarytable.sleep.night{i}(j,k)/genox.summarytable.sleepBout.night{i}(j,k);
        %!!! above if there have been no sleep bouts, the division of
        %sleep/#ofbouts will give you Inf!!!
        
        
        % to get the sleep latency scores for all the fish, all days/nights you again use
        % find with genox.daynumber and genox.lightschedule to define the
        % relevant segment of the genox.sleeplatency array, and sum again
        % for each fish
        genox.summarytable.sleepLatency.day{i}(j,k)=sum(genox.sleeplatency{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 0)),k));
        genox.summarytable.sleepLatency.night{i}(j,k)=sum(genox.sleeplatency{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 1)),k));
        
        % to get the averageActivity use find with genox.daynumber and genox.lightschedule to define the
        % relevant segment of the genox.data, then use 'mean'
        genox.summarytable.averageActivity.day{i}(j,k)=nanmean(genox.data{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 0)),k));
        genox.summarytable.averageActivity.night{i}(j,k)=nanmean(genox.data{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 1)),k));
        
        
      
        genox.summarytable.TotalActivityDIV.day{i}(j,k)=sum(genox.data{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 0)),k))/14;
        genox.summarytable.TotalActivityDIV.night{i}(j,k)=sum(genox.data{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 1)),k))/10;
        
               
        % to get the averageWaking use find with genox.daynumber and genox.lightschedule to define the
        % relevant segment of the genox.data, then use 'nanmean'
        genox.summarytable.averageWaking.day{i}(j,k)=nanmean(genox.avewaking{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 0)),k));
        genox.summarytable.averageWaking.night{i}(j,k)=nanmean(genox.avewaking{i}(intersect(find(genox.daynumber == j),find(genox.lightschedule == 1)),k));
  
        end
    end
    
        for p = 1:length(genox.fishID{i}) % already looping days and genotypes, now loop fish
         
            
            % total sleep for each fish for day/night (1, #of fish)
            genox.summarytable.sleep.daytotal{i}(p) = sum(genox.summarytable.sleep.day{i}(1:end,p));
            genox.summarytable.sleep.nighttotal{i}(p) = sum(genox.summarytable.sleep.night{i}(1:end,p));
            
            % mean # of bouts for each fiss in day/night (1, #of fish)
            genox.summarytable.sleepBout.daymean{i}(p) = nanmean(genox.summarytable.sleepBout.day{i}(1:end,p));
            genox.summarytable.sleepBout.nightmean{i}(p) = nanmean(genox.summarytable.sleepBout.night{i}(1:end,p));
            
            % mean bout sleepLength for each fish in day/night (1, #of fish)
            genox.summarytable.sleepLength.daymean{i}(p) = nanmean(genox.summarytable.sleepLength.day{i}(1:end,p));
            genox.summarytable.sleepLength.nightmean{i}(p) = nanmean(genox.summarytable.sleepLength.night{i}(1:end,p)); 
            
            % mean latency for each fish in day/night(1, #of fish)
            genox.summarytable.sleepLatency.daymean{i}(p) = nanmean(genox.summarytable.sleepLatency.day{i}(1:end,p));
            genox.summarytable.sleepLatency.nightmean{i}(p) = nanmean(genox.summarytable.sleepLatency.night{i}(1:end,p)); 
            
            % mean activity for each fish in day/night (1, #of fish)
            genox.summarytable.averageActivity.daymean{i}(p) = nanmean(genox.summarytable.averageActivity.day{i}(1:end,p));
            genox.summarytable.averageActivity.nightmean{i}(p) = nanmean(genox.summarytable.averageActivity.night{i}(1:end,p));
            
            % mean waking activity for each fish in day/night (1, #of fish)
            genox.summarytable.averageWaking.daymean{i}(p) = nanmean(genox.summarytable.averageWaking.day{i}(1:end,p));
            genox.summarytable.averageWaking.nightmean{i}(p) = nanmean(genox.summarytable.averageWaking.night{i}(1:end,p));
       end
end

            
% finding the genotype averages for each datapoint
for i=1:number_of_genos
       
        genox.summarytable.mean.sleep.day{i}= nanmean(genox.summarytable.sleep.day{i}, 2)'; 
        genox.summarytable.mean.sleep.night{i} = nanmean(genox.summarytable.sleep.night{i}, 2)';
        
        % mean # of sleep bouts
        genox.summarytable.mean.sleepBout.day{i}= nanmean(genox.summarytable.sleepBout.day{i}, 2)';
        genox.summarytable.mean.sleepBout.night{i}= nanmean(genox.summarytable.sleepBout.night{i}, 2)';
        
        % mean length of sleep bouts
        genox.summarytable.mean.sleepLength.day{i}=  nanmean(genox.summarytable.sleepLength.day{i}, 2)';
        genox.summarytable.mean.sleepLength.night{i}=  nanmean(genox.summarytable.sleepLength.night{i}, 2)';
        
        % mean sleep latency
        genox.summarytable.mean.sleepLatency.day{i}=  nanmean(genox.summarytable.sleepLatency.day{i}, 2)';
        genox.summarytable.mean.sleepLatency.night{i}=  nanmean(genox.summarytable.sleepLatency.night{i}, 2)';
        
        % mean average activity
        genox.summarytable.mean.averageActivity.day{i}=  nanmean(genox.summarytable.averageActivity.day{i}, 2)';
        genox.summarytable.mean.averageActivity.night{i}=  nanmean(genox.summarytable.averageActivity.night{i}, 2)';
        
        % mean average waking activity
        genox.summarytable.mean.averageWaking.day{i}=  nanmean(genox.summarytable.averageWaking.day{i}, 2)';
        genox.summarytable.mean.averageWaking.night{i}=  nanmean(genox.summarytable.averageWaking.night{i}, 2)';

        genox.summarytable.mean.sleep.daytotal{i} = nanmean(genox.summarytable.sleep.daytotal{i});
        genox.summarytable.mean.sleep.nighttotal{i} = nanmean(genox.summarytable.sleep.nighttotal{i});
        genox.summarytable.mean.sleepBout.daymean{i} = nanmean(genox.summarytable.sleepBout.daymean{i});
        genox.summarytable.mean.sleepBout.nightmean{i} = nanmean(genox.summarytable.sleepBout.nightmean{i});
        genox.summarytable.mean.sleepLength.daymean{i} = nanmean(genox.summarytable.sleepLength.daymean{i});
        genox.summarytable.mean.sleepLength.nightmean{i} = nanmean(genox.summarytable.sleepLength.nightmean{i});
        genox.summarytable.mean.sleepLatency.daymean{i} = nanmean(genox.summarytable.sleepLatency.daymean{i});
        genox.summarytable.mean.sleepLatency.nightmean{i} = nanmean(genox.summarytable.sleepLatency.nightmean{i});
        genox.summarytable.mean.averageActivity.daymean{i} = nanmean(genox.summarytable.averageActivity.daymean{i});
        genox.summarytable.mean.averageActivity.nightmean{i} = nanmean(genox.summarytable.averageActivity.nightmean{i});
        genox.summarytable.mean.averageWaking.daymean{i} = nanmean(genox.summarytable.averageWaking.daymean{i});
        genox.summarytable.mean.averageWaking.nightmean{i} = nanmean(genox.summarytable.averageWaking.nightmean{i});


        genox.summarytable.std.sleep.day{i}= nanstd(genox.summarytable.sleep.day{i}, 0, 2)'; 
        genox.summarytable.std.sleep.night{i} = nanstd(genox.summarytable.sleep.night{i}, 0, 2)';
        genox.summarytable.std.sleepBout.day{i}= nanstd(genox.summarytable.sleepBout.day{i}, 0, 2)';
        genox.summarytable.std.sleepBout.night{i}= nanstd(genox.summarytable.sleepBout.night{i}, 0, 2)';
        genox.summarytable.std.sleepLength.day{i}=  nanstd(genox.summarytable.sleepLength.day{i}, 0, 2)';
        genox.summarytable.std.sleepLength.night{i}=  nanstd(genox.summarytable.sleepLength.night{i}, 0, 2)';
        genox.summarytable.std.sleepLatency.day{i}=  nanstd(genox.summarytable.sleepLatency.day{i}, 0, 2)';
        genox.summarytable.std.sleepLatency.night{i}=  nanstd(genox.summarytable.sleepLatency.night{i}, 0, 2)';
        genox.summarytable.std.averageActivity.day{i}=  nanstd(genox.summarytable.averageActivity.day{i}, 0, 2)';
        genox.summarytable.std.averageActivity.night{i}=  nanstd(genox.summarytable.averageActivity.night{i}, 0, 2)';
        genox.summarytable.std.averageWaking.day{i}=  nanstd(genox.summarytable.averageWaking.day{i}, 0, 2)';
        genox.summarytable.std.averageWaking.night{i}=  nanstd(genox.summarytable.averageWaking.night{i}, 0, 2)';
        genox.summarytable.std.sleep.daytotal{i} = nanstd(genox.summarytable.sleep.daytotal{i});
        genox.summarytable.std.sleep.nighttotal{i} = nanstd(genox.summarytable.sleep.nighttotal{i});
        genox.summarytable.std.sleepBout.daymean{i} = nanstd(genox.summarytable.sleepBout.daymean{i});
        genox.summarytable.std.sleepBout.nightmean{i} = nanstd(genox.summarytable.sleepBout.nightmean{i});
        genox.summarytable.std.sleepLength.daymean{i} = nanstd(genox.summarytable.sleepLength.daymean{i});
        genox.summarytable.std.sleepLength.nightmean{i} = nanstd(genox.summarytable.sleepLength.nightmean{i});
        genox.summarytable.std.sleepLatency.daymean{i} = nanstd(genox.summarytable.sleepLatency.daymean{i});
        genox.summarytable.std.sleepLatency.nightmean{i} = nanstd(genox.summarytable.sleepLatency.nightmean{i});
        genox.summarytable.std.averageActivity.daymean{i} = nanstd(genox.summarytable.averageActivity.daymean{i});
        genox.summarytable.std.averageActivity.nightmean{i} = nanstd(genox.summarytable.averageActivity.nightmean{i});
        genox.summarytable.std.averageWaking.daymean{i} = nanstd(genox.summarytable.averageWaking.daymean{i});
        genox.summarytable.std.averageWaking.nightmean{i} = nanstd(genox.summarytable.averageWaking.nightmean{i}); 
end


toc


%% saving

save(strcat(working_path, 'analysis_output/',filename(1:end-9),'.mat'),'genox')

%end

clear all

