%save('STAstuff.mat','STAavg','STAvec','wsize','wdth','hght')
clear;
close all;
load STAstuff;
load bins;
spikes=bins;


figure;
hist(spikes);



datcop=STAavg;
thresh=40;

%datcop_sum=sum(datcop>thresh,2);

datcop_sum=mIdx;
plot(spikes);

tinc=1000*0.0334;

m=mean(spikes);


m=m;

%mu=log(m^2/sqrt(v+m^2));
%sigma=sqrt(log(v/(m^2)+1));


poissspikes=poissrnd(m,size(spikes,1),size(spikes,2));

spikes=poissspikes;

figure;
hold on;  
plot(spikes./mean(spikes),'k');
plot(mIdx./mean(mIdx),'r');


 [xc1,lags1] = xcorr(spikes-mean(spikes),datcop_sum-mean(datcop_sum),'coeff');
 [xc2,lags2] = xcorr(poissspikes-mean(poissspikes),datcop_sum-mean(datcop_sum),'coeff');

 
 figure;
 
  [xc3, bdu3, bdl3] = xcorrc(spikes-mean(spikes),datcop_sum-mean(datcop_sum),'coeff',200,0.99);
 
  hold on;
  
  
 
  
  %h=stem(tinc*lags1,xc3,'r');
  h=plot(tinc*lags1,xc3,'r');
  
  plot(tinc*lags1,bdu3,'b');
  plot(tinc*lags1,bdl3,'b');
  set(h,'MarkerFaceColor','red');
 axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);

xlabel('time (milliseconds)');
ylabel('crosscorrelation coefficient');
  
  
  ylim([-0.35 0.6]);
  
  smallint=[-50 50]*tinc;
  largeint=[-500 500]*tinc;
  
  xlim(largeint);
 figure;
 
  [xc4, bdu4, bdl4] = xcorrc(poissspikes-mean(poissspikes),datcop_sum-mean(datcop_sum),'coeff',200,0.99);
 
  hold on;
  h=stem(tinc*lags2,xc4,'g');
  plot(tinc*lags2,bdu4,'b');
  plot(tinc*lags2,bdl4,'b');
  set(h,'MarkerFaceColor','green');
  
  ylim([-0.25 0.25]);
 xlim([-50 50]);
 figure;
 hold on;
 plot(tinc*lags2,xc2,'b');
 plot(tinc*lags1,xc1,'r');
 
 ylim([-0.45 0.45]); 

meanvec=mean(STAavg,1);
stdvec=std(STAavg);

size(STAavg)
size(stdvec)

%remove mean and normalize
STAavg=(STAavg-repmat(meanvec,size(STAavg,1),1))/repmat(stdvec,size(STAavg,1),1);

%STAvec=STAvec-repmat(meanvec,size(STAavg,1),1);


%STAvec=[];
%NS=sum(spikes);
%for i=1:length(spikes)
%
%    if spikes(i)>0
%        STAvec=[STAvec;(spikes(i)/NS)*STAavg(i,:)];
%    end;
%
%end;

X=STAavg;
y=spikes;
NS=sum(spikes);
T=length(spikes);
lambda=0.00001;
I=eye(size(X,2),size(X,2));


size(X)
size(y)

STA=X'*y;

%STA=(T/NS)*inv(X'*X+lambda*I)*X'*y;


imSTA=reshape(STA,wsize,size(STA,1)/wsize);


for i=1:size(imSTA,1)
    figure;
    
    im1=abs(reshape(imSTA(i,:),wdth,hght));
    imagesc(im1);
    
    
%    entropy(im1)
    

    %surf(reshape(imSTA(i,:),wdth,hght))
    colorbar
 %   pause;
end;




