%copyright 2010 Alexandre Mathy

function [ mtn, rois] = analyze_movie( fn ,rois)


if nargin <2
    [filename, pathname] = uigetfile('*');
    fn=fullfile(pathname, filename);
    rois=getrois(fn);
end;

info.color='red'; 
info.title='Analyzing video'; 
p=progbar(info); 


readerobj=mmreader(fn);
 % Read in all video frames.
    vidFrames = read(readerobj,1);
    
%    size(vidFrames)
       % Get the number of frames.
    %numFrames = get(readerobj, 'numberOfFrames');
      
    
    startframe=8475; %1061;%5300;
    numFrames=200;%2000;
    
    %get(readerobj, 'numberOfFrames')
  
  % numFrames=9000

    
     frame_rate=readerobj.FrameRate;
      

       
       alph=0.3;
       bet=0.9;
            
      
       tot=[];
       
       
   
       
       se=strel('square',2);

       
      
       for j=1:length(rois)
           
          
           state(j).label=rois(j).name;
           state(j).roi=rois(j);
           state(j).currstate.k=1;
           state(j).tot=zeros(numFrames,1);
           
           
           
           
          x1=state(j).roi.pos(1);
           x2=state(j).roi.pos(3);
           y1=state(j).roi.pos(2);
           y2=state(j).roi.pos(4);
           hght=y2-y1;
           wdth=x2-x1;
           blank1=zeros(hght,wdth,3);
           blank2=zeros(hght,wdth);
           
          % scrsz = get(0,'ScreenSize');
          % 'Position',[1 scrsz(4)/2 scrsz(3)/2 scrsz(4)/2]
           state(j).fig1=figure('Position', [(j-1) *250, 600,200,300]);
           set(state(j).fig1, 'Name', state(j).label);
           state(j).im1=image(blank1);
           state(j).fig2=figure('Position', [(j-1) *250, 100 ,200,300]);
           set(state(j).fig2, 'Name', state(j).label);
           state(j).im2=imagesc(blank2,[0 1]);
           
          
       end;
       
       vidFrames=[];
       f1=figure;
       xlim([0 numFrames]);
       
       
       
       
       %initialize video  
       
    fn = 'mouse.mov';
	fprintf('Creating the movie %s.\n', fn);
	MakeQTMovie('start',fn);
	
	MakeQTMovie('quality', 1.0);
	theSound = [];
    	sr = 22050;
        
        

        %subplot(211);
		%plot(sin((1:100)/4+i));
        %subplot(212);
		%plot(sin((1:100)/4+i),'r');

       
        
       load 'ephys.txt';
       ephys=ephys';
        
       %ephys=sin(0.01 * (1:numFrames));
    
       
       currindinframe=1;
    
       ephys=ephys-min(ephys);
       
       for k = 1 : numFrames 
           
           
           try
           vidFrames = read(readerobj,k+startframe-1);
           catch Exception
               'reading error!'
               break;
           end;
        
           
           
           
           for j=1:size(state,2)
               currlabel=state(j).label;
               
               

               
      
               
               rngY=uint32(state(j).roi.pos(2)):uint32(state(j).roi.pos(4));
               rngX=uint32(state(j).roi.pos(1)):uint32(state(j).roi.pos(3));

               
               hght=length(rngY);
               wdth=length(rngX);
               
               
               if k==1
                  ephysframe=255*ones(hght,wdth,3);
               end;
               
                if k==1 && j==1
                    MakeQTMovie('size', [(2*hght) wdth]);
                end;

               state(j).currstate.k=k;
               state(j).currstate.frame= vidFrames(rngY,rngX,:);
               [mtnidx,currstate,binim]=getmotionidx(state(j).currstate,alph,bet,40,state(j).im1,state(j).im2,se);
               state(j).currstate=currstate;
               state(j).tot(k,1)=mtnidx;
               
               
               movFrame=zeros(3*hght,wdth,3);
               
               
               midxframe=zeros(hght,wdth,3);
               midxframe(:,:,1)=255*binim;
               midxframe(:,:,2)=0;
               midxframe(:,:,3)=0;%*255*(1-binim);
              
               
               
               
               if (currindinframe>=wdth)           
                   currindinframe=1;
                   ephysframe=255*ones(hght,wdth,3);
               else
                   currindinframe=currindinframe+1;
               end;
               
               
               indskip=floor(0.0334/(1/2e4));
               e_inds=currindinframe; %( (k-1)*indskip +(1:indskip));
               
               
               size(e_inds)
               
               
               
               currsig=min(floor( (mean(ephys(e_inds))./max(ephys)) .*hght)+1,hght);
               
               ephysframe(currsig,currindinframe,1)=0;
               ephysframe(currsig,currindinframe,2)=0;
               ephysframe(currsig,currindinframe,3)=255;
               
               movFrame=[vidFrames(rngY,rngX,:); midxframe];
               
               
               	MakeQTMovie('addmatrix',movFrame);
        		theSound = [theSound  sin(440/sr*2*pi*(2^(k/12))*(1:sr/10))];
       
           

                
              
           end
           
           
           
           	
           if (mod(k,100)==1)          
               progbar(p,k/numFrames*100);
               disp(f1,state, numFrames)
           end;

       end
       
       
     for j=1:size(state,2)
          mtn(j,:)=state(j).tot;
     end;     
     
     close all;
     
%     figure;
          
    disp(f1,state, numFrames);
     
     tm=((1:size(mtn,2))-1)*1/frame_rate;
     
     mtn=mtn';
     tm=tm';
     
     
     mtn=[tm mtn];
     
     mtn;
     
     
     hold off;
     
     
    progbar(p,-1);
    
    
    
    %end movie
    
    MakeQTMovie('framerate', 15);
	MakeQTMovie('addsound', theSound, sr);
	MakeQTMovie('finish');
       
     
end

function [mtnidx,newstate,binim]=getmotionidx(currstate, alph, bet, thresh, fig1,fig2,se)
 
           
         
           if currstate.k==1
             currstate.BG=currstate.frame;
           end;
           diffim=distfunct(currstate.frame,currstate.BG);
           
           if currstate.k==1
             newstate.smoothed_diffim=diffim;
           else  
             newstate.smoothed_diffim=(1-bet).*currstate.smoothed_diffim+bet.*diffim;
           end;
           
           %image(BG);
           %image(frame);
           
          % size(diffim)
           %figure(fig1)
           %image(currstate.frame)          
           
           set(fig1, 'CData', currstate.frame);
           
           binim=(newstate.smoothed_diffim>thresh);
           binim=imerode(binim,se);
           
           %figure(fig2)
           %imagesc(binim,[0 1]);
          
           set(fig2, 'CData', binim);
           
           drawnow
           
           mtnidx=sum(sum(binim));
           
           newstate.BG=(1-alph).*currstate.BG+alph.*currstate.frame;
           

           
end
function [C]=distfunct(A,B)
%C=abs(A(:,:,1)-B(:,:,1))+abs(A(:,:,2)-B(:,:,2))+abs(A(:,:,3)-B(:,:,3));
C=sum(abs(A-B),3);
end

function disp(f1, state,nf)

     figure(f1);
     
     cols=['r','g','b','k','y','m','c'];
     for j=1:size(state,2)
      
         plot(state(j).tot./max(state(j).tot),cols(j));
         xlim([0 nf]);
         hold on;
         leg{j}=  state(j).label;
        
     end;
     
     legend(leg);
end