

clear;
close all;

M_rest=[ 10.28 3.9  28.42 4.04 ];
E_rest=[153 56 106 76 36 61 57 43 106];


M_motion=[2.33 51.36 104 27.93];
E_motion=[250 133 124 136 93 135 90 95 169];




%M=randi(10,[1 4]);

%E=4*randi(10,[1 9]);





n=10000;
alpha=0.05;
s = RandStream('mcg16807','Seed',0)
RandStream.setGlobalStream(s)


R_rest=zeros(n,1);
R_motion=zeros(n,1);


for i=1:n
    
    r1=randi(length(M_rest),[length(M_rest) 1]);
    r2=randi(length(E_rest),[length(E_rest) 1]);
    
    rat=mean(E_rest(r2))./mean(M_rest(r1));
    
    R_rest(i)=rat;
    
    
    r1=randi(length(M_motion),[length(M_motion) 1]);
    r2=randi(length(E_motion),[length(E_motion) 1]);
    
    rat=mean(E_motion(r2))./mean(M_motion(r1));
    
    R_motion(i)=rat;
end;


%%%%%%%%%%%%%%%%%%%%%%%%%%%REST
R_rest=sort(R_rest);


'REST'
R_rest(floor(alpha*n))

R_rest(floor( (1-alpha)*n))

'INITIAL'
mean(E_rest)/mean(M_rest)

'POST'
mean(R_rest)
median(R_rest)
std(R_rest)


%%%motion
R_motion=sort(R_motion);


'MOTION'
R_motion(floor(alpha*n))

R_motion(floor( (1-alpha)*n))

'INITIAL'
mean(E_motion)./mean(M_motion)

'POST'
mean(R_motion)
median(R_motion)
std(R_motion)


figure;
hold on;
hist([R_rest R_motion],100);

axe=gca;
set(gcf, 'PaperPositionMode', 'auto');
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
%set(gca,'XTick',[1 2])
%set(gca,'XTickLabel',{'Long time';'short time'})
set(gcf,'position',[100, 200, 500, 400])
legend('');
xlabel('EPSC:MFT spike ratio');
ylabel('Count');
legend('Rest','Motion');