close all;
clear;

spike=[];
ns=1;


spike(ns).files={'../GC_spikes/06_01_2011_Cell6/spikes.txt'};
spike(ns).threshold=-10e-3;
ns=ns+1;



spike(ns).files={'../GC_spikes/10520cell2/spikes11.txt';'../GC_spikes/10520cell2/spikes12.txt'};
spike(ns).threshold=-10e-3;
ns=ns+1;




spike(ns).files={'../GC_spikes/110106cell3/spikes11.txt';'../GC_spikes/110106cell3/spikes12.txt'};
spike(ns).threshold=-30;
ns=ns+1;


spike(ns).files={'../GC_spikes/110111cell2/spikes10.txt';'../GC_spikes/110111cell2/spikes11.txt';'../GC_spikes/110111cell2/spikes12.txt';'../GC_spikes/110111cell2/spikes13.txt'};
spike(ns).threshold=-30;
ns=ns+1;



spike(ns).files={'../GC_spikes/110112cell4/spikes28.txt';'../GC_spikes/110112cell4/spikes29.txt';'../GC_spikes/110112cell4/spikes30.txt'};
spike(ns).threshold=40;
ns=ns+1;


spike(ns).files={'../GC_spikes/060111cell4/Spikes017.txt';'../GC_spikes/060111cell4/Spikes018.txt';'../GC_spikes/060111cell4/Spikes019.txt'};
spike(ns).threshold=-10;
ns=ns+1;

spike(ns).files={'../GC_spikes/060111cell5/Spikes024.txt';'../GC_spikes/060111cell5/Spikes025.txt';'../GC_spikes/060111cell5/Spikes026.txt';'../GC_spikes/060111cell5/Spikes027.txt'};
spike(ns).threshold=-10;
ns=ns+1;



ps=[];

depols=[];


freq_f=[];
freq_depol=[];
freq_n=[];
freq_cell=[];
freq_T=[];

for i=1:length(spike)
    burst_I{i}={};
end;
for i=1:length(spike)
  % close all; 
  
  recording=[];
  for k=1:length(spike(i).files) 
  spikes=load(spike(i).files{k});
   
  spike(i).files{k}
   size(spikes);
   
   for j=1:size(spikes,2);
       recording=[recording;spikes(:,j)];
   end;
   
  end;
%   f=figure;
   
%  plot(recording);
%   spike(i).threshold
%   pause;
   
 
   analysis=spikeanalysis(recording,spike(i).threshold,strcat('figs/BTA_',num2str(i)),1/2e4);
   

   nsingle=0;
   nburst=0;
   
   
   gotone=0;

   
   nbb=0;
   
   for m=1:length(analysis.bursts)
       b=analysis.bursts{m};
       
       
       if length(b)==1
           nsingle=nsingle+1;
       else
           nburst=nburst+nsingle;
       end;
       
       
       if length(b)>3  && m < length(analysis.depolmat)
           gotone=1;
           nbb=nbb+1;
           sampInt=1/2e4;
           freq=1/(sampInt*mean(diff(b)));
        
           freq_f=[freq_f freq];
           freq_depol=[freq_depol analysis.depolmat(m)];
           freq_n=[freq_n length(b)];
           freq_cell=[freq_cell i];
           freq_T=[freq_T (sampInt*(b(length(b))-b(1)))];
%           pause;
           burst_I{i}{nbb}=b;
           
           
       end;
       
       
   end;
      

   
   depols=[depols; mean(analysis.depolmat)];
   'proportion'
   p=100.*nburst./(nsingle+nburst);
   p
   ps=[ps p];
end    

'mean proportion'
mean(ps)



save('spikefreqdata','freq_f','freq_cell','freq_n','freq_T','freq_depol','depols','burst_I');


figure;

plot(freq_f,freq_depol,'ro');


xlabel('Burst frequency (Hz)');
ylabel('Burst depolarization (mV)');
axe=gca;
set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);

print('-depsc','-r400','figs/burstfreqdepol.eps')


figure;
hold on;
title('depol')
ylabel('Burst depolarization (mV)');
plot(0.*depols,depols,'ro');

%legend('GC EPSC','MFT','GC spike');
errorbar(0,mean(depols),std(depols)./sqrt(length(depols)-1),'rx','MarkerFaceColor',[1 1 1]);


axe=gca;

set(gcf,'position',[100, 200, 150, 400])
set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[0])
set(gca,'XTickLabel',{'GC'});
ylim([0 15]);
print('-depsc','-r400','figs/burstdepol.eps')