close all;
load('spikefreqdata');

cols={'ro','go','bo','mo','co','r*','g*','b*','m*'};



figure
plot(freq_cell,'rx');

figure;
hold on;


%plot(freq_depol,freq_f,'ro');


for i=1:length(freq_depol)

    plot(freq_depol(i),freq_f(i),cols{freq_cell(i)});
end;



 [R,P]=corrcoef(freq_depol,freq_f);
size(freq_f)
 R
 P
 
 pause
 
 
 
 PO = polyfit(freq_depol,freq_f,1);
 
 
 x=-5:1:30;
 size(freq_f)
 
 plot(x,polyval(PO,x),'k');
 
ylabel('Burst frequency (Hz)');
xlabel('Burst depolarization (mV)');
axe=gca;
set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);

print('-depsc','-r400','figs/burstfreqdepol.eps')


%freq_n=[];
%freq_cell=[];
%freq_T=[];

figure
hold on;
for i=1:length(freq_depol)
    freq_cell(i)
    plot(freq_depol(i),freq_n(i),cols{freq_cell(i)});
end;
ylabel('Number of spikes in burst');
xlabel('Burst depolarization (mV)');
print('-depsc','-r400','figs/burstnumdepol.eps')

figure
hold on;
for i=1:length(freq_depol)
    freq_cell(i)
    plot(freq_depol(i),freq_T(i),cols{freq_cell(i)});
end;
ylabel('duration of burst (seconds)');
xlabel('Burst depolarization (mV)');
print('-depsc','-r400','figs/burstdurationdepol.eps')


