
close all;


t=0:1500;

lambda=0.001;
maxfreq=400;

sampint=1/20e3;
kernel=exp(-t.*lambda);
kernel=kernel./sum(kernel);
kernel=fliplr(kernel);

kernel=kernel*(1./sampint);
plot(kernel);


tinc=1/2e4;


fastproc=9;

xc1_tot=[];
xc2_tot=[];
TA1_tot=[];

x1_tot=[];
y1_tot=[];

x2_tot=[];
y2_tot=[];
y3_tot=[];
m2_tot=[];
mtxs_tot=[];
cells_tot=[];

spill_charges=[];
fast_charges=[];
for cellind=1:9

% pause;

    
switch cellind
    case 1
        load spill110112040;
        load ../GC_EPSCs/110112cell4EPSC/STAstuff41
    case 2
        load spill110111000;
        load ../GC_EPSCs/110111cell1EPSC/STAstuff00;
    case 3
        load spill110106030;
        load ../GC_EPSCs/110106cell6EPSC/STAstuff29;

    case 4
        load spill110106002;
        load ../GC_EPSCs/110106cell1EPSC/STAstuff11;
    case 5
        load spill10910007;
        load ../GC_EPSCs/10910cell1EPSC/STAstuff16;
    case 6
        load spill10519000;
        load ../GC_EPSCs/10519cell1EPSC/STAstuff03;

    case 7
        load spill110111cell2EPSC015;
        load ../GC_EPSCs/110111cell2EPSC/STAstuff015;
    case 8
        load spill120111cell1EPSC02;
        load ../GC_EPSCs/120111cell1EPSC/STAstuff02;
    case 9
        load spill090111cell1EPSCs00;
        load ../GC_EPSCs/090111cell1EPSC/STAstuff00;     
        
end



mIdx=mIdx./max(mIdx);



t=0:20;

%smooth motion index
lambda=0.05;
m_kernel=exp(-t.*lambda);
m_kernel=m_kernel./sum(m_kernel);
m_kernel=fliplr(m_kernel);
mIdx=conv(mIdx,m_kernel,'valid');
pad=50;
mIdx=[mIdx,zeros(1,pad)];

x=[];
y=[];
mtxs=[];

f1=figure;


xc1=[];
xc2=[];
TA1=[];


binsize=0.0334;
numseconds=50;

for i=1:length(spilldata)
    
    currs=(i-1)*5;
    currbin=floor(currs/binsize)+1;
    
    sd=spilldata(i);
    sd.baseline_spline;
    sd.fast_component;
    sd.mintab;
    
    
    
    size(sd.baseline_spline)
    
    
    acc=zeros(size(sd.baseline_spline));

  
      if size(sd.mintab,1)==0
        continue
    end;
    
    
    m_inds=currbin+floor(sd.mintab(:,1).*sampint./binsize);
    
    m_inds
    
    mtxs=[mtxs;mIdx(m_inds)'];
    
    acc(sd.mintab(:,1))=1;

    
    
   
    
    
    TA1=spill_TA(-sd.baseline_spline,acc);%-(sd.fast_component-max(sd.fast_component)));
    
  
    acc=conv(acc,kernel,'valid');
    
    if (fastproc~=1)
    
    s1=spillxcorr(-sd.baseline_spline,acc,'dude');
    s2=spillxcorr(-sd.baseline_spline,-(sd.fast_component-max(sd.fast_component)),'dude');
    
    xc1=[xc1; s1.xc];
    xc2=[xc2; s2.xc];
    
    xc1_tot=[xc1_tot; s1.xc];
    xc2_tot=[xc2_tot; s2.xc];
    TA1_tot=[TA1_tot;TA1];
%    pause;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
A=-sd.baseline_spline;
B=acc;
A=A(1:length(B));
A=A-mean(A);
B=B-mean(B);
%tfestimate(A,B)
%pause;
    
    end
%    figure;
%    plot(acc);
%    pause;
%    hold off;
%    plot(sd.fast_component)
%    hold on;
    %plot(sd.mintab(:,1),sd.mintab(:,2),'ro');
%    pause;
    
    
    spillover=sd.baseline_spline;
    spillover=spillover-max(spillover);
    spillover=-spillover;
    mintab=sd.mintab;
    
    
    figure(f1);
    hold on;
    
    for j=2:size(mintab,1)
        lastmin=mintab(j-1,1);
        currmin=mintab(j,1);
        currminamp=mintab(j,2)-sd.baseline_spline(currmin);
        currminamp=-currminamp;
        currspill=spillover(currmin);
    
 
        
        currmtx=mtxs(j);
        
        if (currmin>length(acc))
            continue;
        end;
        
        
        currISI=(currmin-lastmin)*sampint;
        currFreqbasic=1./currISI;
        
        currFreq=acc(currmin);
        
        if currFreq>maxfreq
            continue;
        end;
        
    
        %plot(currFreq,spillover(currmin),'ko');
        
        x=[x; currFreq];
        y=[y; spillover(currmin)];
       
        
        x2_tot=[x2_tot; currFreq];
        y2_tot=[y2_tot; spillover(currmin)];
        y3_tot=[y3_tot; currminamp];
        cells_tot=[cells_tot;cellind];
        
        m2_tot=[mtxs;mIdx(m_inds(2:length(m_inds)))'];
        
        %%%%%average over 100ms to get charge
        boxsize=100e-3;
        rng=currmin:(currmin+floor(boxsize/sampint));
        
       % size(rng)
       % boxsize
       % sampint
       % pause;
        
        fast_charge=0;
        spill_charge=0;
       
        
        if max(rng)<length(sd.fast_component)
            fast_charge=sum(sd.fast_component(rng))*boxsize*1e-12;
            spill_charge=sum(spillover(rng))*boxsize*1e-12;
        else
            fast_charge=NaN;
            spill_charge=NaN;
        end
        fast_charges=[fast_charges; fast_charge];
        spill_charges=[spill_charges; spill_charge];
        
        mtxs_tot=[mtxs_tot;currmtx];
        x1_tot=[x1_tot; currFreq];
        y1_tot=[y1_tot;(currminamp/(currminamp+currspill))];
        
        
        
         if currFreqbasic>maxfreq
            continue;
        end;
        
       % 
        
        
        
    end;
    
    
end;



divs=100;
c_mp=flipud(autumn(divs));



%ffact=1;

ffact=floor(1./(3*std(mtxs)));

ffact


figure;
hold on;

I=randperm(length(x));
x=x(I);
y=y(I);
mtxs=mtxs(I);

if (fastproc~=1)
    
for i=1:length(x)
    cind=floor(mtxs(i)*divs)+1;
    cind=ffact*cind;
    cind=min(cind,divs-1);
    col=c_mp(cind,:);
    
    
    plot(x(i),y(i),'ko','Color',col,'MarkerFaceColor',col);

%     ag_plot_little_circles(x(i), y(i), 4,col, 0.4);
%     pause(0.001);
end
end;

[R,P]=corrcoef(x,y);




%kmax=100;lambda=0.01;plot((kmax./(1+exp(-lambda.*t))));
f=inline('beta(1) .*(1./(1+exp(-beta(2).*x)) - 0.5)','beta','x');
beta=nlinfit(x,y,f,[10,0.01]);
ts=1:10:maxfreq;
plot(ts,f(beta,ts),'r');


R=R(1,2)
P=P(1,2)
gcf

text(180,max(y)+0.1*max(y), strcat('R=',num2str(R,3),' P=',num2str(P,3)),'FontSize',14,'Color','r');

ylim([0 max(y)+0.2*max(y)]);

axe=gca;
ylabel('Spillover current (pA)');
xlabel('EPSC frequency (Hz)');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
%ylim([-1.5 3.5]);
print('-depsc','-r800',strcat('figs/spillover_figs_',num2str(cellind),'.eps'));


figure;
plot_x_mat(xc1,tinc,s1.lags,num2str('frequency ',num2str(cellind)));
figure;
plot_x_mat(xc2,tinc,s1.lags,num2str('current ',num2str(cellind)));

figure;
plot(mean(TA1));


%%%%%DUDE
figure;

hold on;

I=randperm(length(x));
x=x(I);
y=y(I);
mtxs=mtxs(I);

%if (fastproc~=1)
    
%for i=1:length(x)
%    cind=floor(mtxs(i)*divs)+1;
%    cind=ffact*cind;
%    cind=min(cind,divs-1);
%    col=c_mp(cind,:);
%    
    
%    plot(x(i),y(i),'ko','Color',col,'MarkerFaceColor',col);

%end
%end;



numbins=8;
binsize=50;


summ_x_bin=floor(x/binsize);


summ_xs=[];
summ_ys=[];
summ_mts=[];
summ_yes=[];



ffact2=floor(1./(2*std(mtxs)));


for i=0:numbins

    summ_xs=[summ_xs (i+0.5)*binsize];
    
    summ_xrng=summ_x_bin(summ_x_bin==i);
    summ_yrng=(y( (summ_x_bin==i) ));
    summ_mtnrng=(mtxs( (summ_x_bin==i) ));
 
    
    summ_ymn=mean(summ_yrng);
    summ_ystd=std(summ_yrng);
    
    summ_mtsmn=mean(summ_mtnrng);
    
    %(i,yrng,'ro');
    
    summ_ys=[summ_ys summ_ymn];
    summ_mts=[summ_mts summ_mtsmn];
    summ_yes=[summ_yes summ_ystd];
    
    
end;


plot(summ_xs,summ_ys,'k--');
for i=0:numbins

    
    max_mt=max(summ_mts);
    min_mt=min(summ_mts);
    
    cind=floor( ((summ_mts(i+1)-min_mt)/(max_mt-min_mt))*divs)+1;
    cind=cind;
    cind=min(cind,divs-1);
    col=c_mp(cind,:);

    xlim([0 350]);
    
    alexerrorbar(summ_xs(i+1),summ_ys(i+1),summ_yes(i+1),col,5);
    plot(summ_xs(i+1),summ_ys(i+1),'ko','Color',col,'MarkerFaceColor',col);
end;

colormap(c_mp);
colorbar;

%plot(summ_xs,summ_ys,'ro');
%errorbar(summ_xs,summ_ys,summ_yes,'ro');



ylim([0 max(summ_ys)+max(summ_yes)]);

axe=gca;
ylabel('Spillover current (pA)');
xlabel('EPSC frequency (Hz)');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
%ylim([-1.5 3.5]);
print('-depsc','-r800',strcat('figs/spillover_figs_',num2str(cellind),'summ.eps'));
%%%%%dude

end;




figure;
plot(mean(TA1_tot),'g');

figure;
hold on;

plot_x_mat(xc1_tot,tinc,s1.lags,'total frequency');
print('-depsc','-r800','spill_freq_corr.eps');
figure;
plot_x_mat(xc2_tot,tinc,s1.lags,'total current');
print('-depsc','-r800','spill_current_corr.eps');
figure;

hold on;
plot(x1_tot,y1_tot);

save('spillvsfreq','x1_tot','y1_tot','x2_tot','y2_tot','y3_tot','spill_charges','fast_charges','mtxs_tot','cells_tot');




figure;
hold on;

I=randperm(length(x2_tot));
x=x2_tot(I);
y=y2_tot(I);
%m2_tot=m2_tot(I);

if (fastproc~=1)
    
for i=1:length(x)
    col='b';
    plot(x(i),y(i),'ko','Color',col,'MarkerFaceColor',col);

%     ag_plot_little_circles(x(i), y(i), 4,col, 0.4);
%     pause(0.001);
end
end;
