function [bins,valbins,inds]=convspill2(spillanal)


valid=1-spillanal(2,:);
spillover=spillanal(1,:);


ind=find(1-valid);


%figure;
%plot(spillover(ind));
%pause;

binsize=0.0334;
numseconds=50;

bins=zeros(ceil(numseconds/binsize),1);
valbins=zeros(ceil(numseconds/binsize),1);


freqac=20e3;


for i=1:length(valbins)
    
    currind=(floor((i-1)*(binsize*freqac)):floor((i+1)*(binsize*freqac)))+1;
    
    currind=min(currind,length(valid));
    val=min(valid(currind));
    spill=mean(spillover(currind));
    
    valbins(i)=val;
    bins(i)=spill;
    inds(i)=currind(1);
end;



