addpath('../spike_analysis/');



c=load('output/cellmap.mat');

cellmap=c.cellmap;


numtraces=90;


numcells=8;


slow_ns=[];
both_ns=[];
fast_ns=[];
NMDA_ns=[];

freq_f=[];
freq_depol=[];
freq_n=[];
freq_cell=[];
freq_T=[];
depols=[];


slowmats=[];
fastmats=[];
datmats=[];

f1=figure;
f2=figure;
for i=1:numtraces
    
close all;    


f1=figure;
f2=figure;    

%    pause;
    slowfn=strcat('processed/slowout',num2str(i));
    fastfn=strcat('processed/fastout',num2str(i));
    bothfn=strcat('processed/bothout',num2str(i));
    NMDAfn=strcat('processed/NMDAout',num2str(i));
    
    %%%dude
%    NMDAfn=strcat('processed/bothout',num2str(i));
     
    slowfitfn=strcat('output/slow',num2str(i));
    fastfitfn=strcat('output/fast',num2str(i));
    rawfn=strcat('output/raw',num2str(i));
    
    
    
    slow=load(slowfn);
    fast=load(fastfn);
    both=load(bothfn);
    NMDA=load(NMDAfn);
    NMDA=NMDA(:,1);
    slowfit=load(slowfitfn);
    fastfit=load(fastfitfn);
    rawfit=load(rawfn);
    
    dt=2.5000e-05;
    
    
    Nsamps=length(slow);
    
    
    [slow_spikes,n_slow]=getspikes(slow);
    [fast_spikes,n_fast]=getspikes(fast);
    [both_spikes,n_both]=getspikes(both);
    [NMDA_spikes,n_NMDA]=getspikes(NMDA);
    
    
    plot(both);
    hold on;
    recording=both;
    recording=recording';
    spikevec=1.0*(recording>-10);
    spikevec=[(diff(spikevec)>0) 0]&(spikevec==0);
    plot(20*spikevec,'r');

    
   analysis=spillspikeanalysis(both,-25,strcat('figs/dude',num2str(i)),dt,fastfit,slowfit);
   
    
   nsingle=0;
   nburst=0;
   for m=1:length(analysis.bursts)
       b=analysis.bursts{m};
       
       if length(b)==1
           nsingle=nsingle+1;
       else
           nburst=nburst+nsingle;
       end;
       
       
       if length(b)>3  && m < length(analysis.depolmat)
           sampInt=1/2e4;
           freq=1/(sampInt*mean(diff(b)));
           
           freq
           
           freq_f=[freq_f freq];
           freq_depol=[freq_depol analysis.depolmat(m)];
           freq_n=[freq_n length(b)];
           freq_cell=[freq_cell cellmap(i)];
           freq_T=[freq_T (sampInt*(b(length(b))-b(1)))];
%           pause;
       end;
   end;
       
       
   if length(analysis.bursts)>0
     depols=[depols; mean(analysis.depolmat)];
     fastmats=[fastmats;analysis.fastmat];
     slowmats=[slowmats;analysis.slowmat];
     datmats=[datmats;analysis.datmat];
   end;
    1/2e4
    
    
    save('spillspikefreqdata','freq_f','freq_cell','freq_n','freq_T','freq_depol','depols','slowmats','fastmats','datmats');

    
   
    figure(f1);
    plot(dt*(1:Nsamps),slow,'r');
    hold on;
    plot(dt*(1:Nsamps),fast,'g');
    plot(dt*(1:Nsamps),both,'b');
    hold off;
    
    ylim([-90 30])
    print('-depsc','-r400',strcat('figs/out/out',num2str(i),'.eps'))


    
    figure(f2);
    Nsamps=length(slowfit);
    dt=0.05e-3;
    
    
    plot(dt*(1:Nsamps),fastfit,'g');
    hold on;
    plot(dt*(1:Nsamps),rawfit,'k');
    
    %plot(dt*(1:Nsamps),slowfit+fastfit,'m');
    plot(dt*(1:Nsamps),slowfit,'r','linewidth',2);
    
    hold off;
    
    
    print('-depsc','-r400',strcat('figs/out/fit',num2str(i),'.eps'))

    f_fact=1/(Nsamps*dt);
    
    n_slow=f_fact*n_slow;
    n_fast=f_fact*n_fast;
    n_both=f_fact*n_both;
    n_NMDA=f_fact*n_NMDA;
    
    slow_ns=[slow_ns; n_slow];
    fast_ns=[fast_ns; n_fast];
    both_ns=[both_ns; n_both];
    NMDA_ns=[NMDA_ns; n_NMDA];
    
%    numsubs=6;
%    subsize=0.7;
    
    
    numsubs=5;
    subsize=1.5;
    
    
    inmult=0.5;
    
    fig2=gcf;

    
    for ind=0:numsubs
        realind=inmult*ind;
        xlim([realind realind+1]*subsize);
        
        
        set(gcf,'position',[100, 200, 600, 400])
        
        print('-depsc','-r400',strcat('figs/out/sub/fit',num2str(i),'sub',num2str(ind),'.eps'))
% pause;
    end;

    
    
    %pause;
end;

figure;
hist(fast_ns,100)
figure;
hist(both_ns,100)

datmat=[slow_ns fast_ns both_ns NMDA_ns];


figure;
hold on;
md=mean(datmat);
sd=std(datmat)./sqrt(numcells-1);
errorbar([1 2 3 4],md,sd,'k+')
bar(md);

md
sd
pause;


ylim([0 20])
xlim([0.4 4.6])
axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4])
set(gca,'YTick',[0 5 10 15 20])
set(gca,'XTickLabel',{'Spillover';'EPSCs';'Both';'NMDA'})
ylabel('Spike Rate (Hz)')
set(gcf,'position',[100, 200, 250, 200])
print('-depsc','-r400','TOT_spillbar.eps')



't test 1'
[H,P]=ttest2(datmat(:,1),datmat(:,2));
H
P

't test 2'
[H,P]=ttest2(datmat(:,2),datmat(:,3));
H
P


't test 3'
[H,P]=ttest(datmat(:,3),datmat(:,4));
'NMDA'
H
P

pause;


'ANOVA'
 P = anova1([datmat(:,1),datmat(:,2),datmat(:,3)],[],'on');
P

save('sillspikefreqdata','freq_f','freq_cell','freq_n','freq_T','freq_depol','depols','slowmats','fastmats','datmats');

colormap autumn;

hold on;

figure;
hold on;
plot(slowmats,'k');
plot(mean(slowmats),'r');